/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef __HdkCdbManager_AntConfigSm_h__
#define __HdkCdbManager_AntConfigSm_h__
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "HdkCdbManagerTask_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

 /*Configuration SM states*/
 typedef enum HdkCdbManagerConfigAntsSmStates
 {
	 CONFIG_ANTS_SM_STATE_IDLE,
	 CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_SCHED,
	 CONFIG_ANTS_SM_STATE_SETTING_CONFIGURATION,
	 CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_END,
	 CONFIG_ANTS_SM_STATE_LAST
	 
 }HdkCdbManagerConfigAntsSmStates_e;
 /*Common configuration SM events*/
 typedef enum HdkCdbManager_ConfigAntsSmEvents
 {
	 CONFIG_ANTS_SM_EVENT_PREPARE_CHANGE,
	 CONFIG_ANTS_SM_EVENT_PROCESS_SCHED,
	 CONFIG_ANTS_SM_EVENT_SET_AFE_CAL_DATA,
	 CONFIG_ANTS_SM_EVENT_SET_RSSI_CAL_DATA,
	 CONFIG_ANTS_SM_EVENT_SET_ANTS,
	 CONFIG_ANTS_SM_EVENT_SET_ANTS_DONE,
	 
 }HdkCdbManager_ConfigAntsSmEvents_e;

typedef struct CdbManagerConfigAntsSmDb
{
	HdkCdbManagerConfigAntsSmStates_e state;
}CdbManagerConfigAntsSmDb_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------
void HdkCdbManagerAntConfigSmPrepareChangeReq(K_MSG* pMsg);
void HdkCdbManagerAntConfigSmPrepareChangeDone(K_MSG* pMsg);
void HdkCdbManagerAntConfigSmSetAfeCalData(K_MSG* pMsg);
void HdkCdbManagerAntConfigSmSetRssiCalData(K_MSG* pMsg);
void HdkCdbManagerAntConfigSmSetAntReq(K_MSG* pMsg);
void HdkCdbManagerAntConfigSmSetAntCfm(K_MSG* pMsg);
void HdkCdbManagerAntConfigSm(uint8 eventGeneralType, K_MSG* pMsg);

#endif 
