/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef __HdkCdbManager_ConfigSm_h__
#define __HdkCdbManager_ConfigSm_h__
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "HdkCdbManagerTask_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define NUMBER_OF_STAGES 3

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
 /*Configuration SM states*/
 typedef enum HdkCdbManagerConfigSmStates_e
 {
	 CONFIG_SM_STATE_IDLE,
	 CONFIG_SM_STATE_CONFIG_STAGE_START,
	 CONFIG_SM_STATE_WAIT_FOR_SEC_BAND_CFM,
	 CONFIG_SM_STATE_LAST	 
 }HdkCdbManagerConfigSmStates_e;
 /*Common configuration SM events*/
 typedef enum HdkCdbManager_ConfigSmEvents
 {
	 CONFIG_SM_EVENT_SET_CONFIGURATION_REQ,
	 CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_REQ,
	 CONFIG_SM_EVENT_SET_CONFIGURATION_CFM,
	 CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_CFM,
 }HdkCdbManager_ConfigSmEvents_e;

typedef struct CdbManagerConfigSmDb
{
	HdkCdbManagerConfigSmStates_e state;
	uint8 waitForBandRspBitmap;
	HdkCdbManagerConfigMsg_t msgReqParams;
	uint8 stageCounter;
}CdbManagerConfigSmDb_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------
void HdkCdbManagerConfigSm(uint8 eventGeneralType, K_MSG* pMsg);
void HdkCdbManager_ConfigSmConfigurationReq(K_MSG* pMsg);
void HdkCdbManager_ConfigSmConfigurationCfm(K_MSG* pMsg);

#endif //__HdkCdbManager_ConfigSm_h__
