/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef __HdkCdbManager_OfflineCalSm_h__
#define __HdkCdbManager_OfflineCalSm_h__
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "HdkCdbManagerTask_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
 /*Offline calibration SM*/
 typedef enum HdkCdbManagerOfflineCalStates
 {
	 OFFLINE_CAL_SM_STATE_IDLE,
	 OFFLLINE_CAL_SM_STATE_WAIT_FOR_NON_CALIBRATING_BAND_PAUSE_DONE,
	 OFFLLINE_CAL_SM_STATE_CHANGING_TO_MAX_ANT_CONFIG,
	 OFLLINE_CAL_SM_WAIT_FOR_CALIBRATION_REQ_FROM_BAND,	 
	 OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING,
	 OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_FINISHED,
	 OFFLLINE_CAL_SM_WAIT_FOR_RESUME_CALIBRATING_BAND,
 }HdkCdbManagerOfflineCalStates_e;
 typedef enum HdkCdbManagerOfflineCalEvents
 {
	 OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION,
	 OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION_SINGLE_BAND,
	 OFFLINE_CAL_SM_EVENT_NON_CALIBRATING_BAND_PAUSE_DONE,
	 OFFLINE_CAL_SM_EVENT_CHANGE_TO_MAX_ANTS_DONE,	 
	 OFFLINE_CAL_SM_EVENT_RESUME_NON_CALIBRATING_BAND_DONE,
	 OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH,
	 OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH,
	 OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH_SINGLE_BAND,
	 OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_CFM,
	 OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE,
	 OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE_SINGLE_BAND,
 }HdkCdbManagerOfflineCalEvents_e;

typedef struct CdbManagerOfflineSmDb
{
	HdkCdbManagerOfflineCalStates_e state;
	bool isCalibrateProcess;
	HdkCdbManagerOfflineCalRequester_e requester;
	BandId_e calibratingBand;
	dualBandOfflineCalType_e calCdbType;
	K_MSG* hostMsg;
}CdbManagerOfflineSmDb_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------
void HdkCdbManager_SmHandlerRunOfflnieCalReq(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOfflineCalFinishedOnOneCh(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOfflineCalFinishedOnLastCh(K_MSG* pMsg);
void HdkCdbManager_SmHandlerPauseDone(K_MSG* pMsg);
void HdkCdbManager_SmHandlerResumeDone(K_MSG* pMsg);
void HdkCdbManager_SmHandlerChangeToMaxAntsDone(K_MSG* pMsg);
void HdkCdbManager_SmHandlerResumeCalibratingBandCfm(K_MSG* pMsg);
void HdkCdbManager_SmHandlerResumeCalibratingBandDone(K_MSG* pMsg);
void HdkCdbManagerOfflineCalSm(HdkCdbManagerOfflineCalEvents_e event, K_MSG* pMsg);





#endif //__HdkCdbManager_OfflineCalSm_h__
