/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef __HdkCdbManager_OnlineCalSm_h__
#define __HdkCdbManager_OnlineCalSm_h__
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "HdkCdbManagerTask_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
// Online calibration scheduling defines
#ifdef ENET_INC_UMAC
#define CLBRSCHEDSM_TIMER_VAL_AFTER_OFFLINE_ST    (30010)     /* 30 sec + 10ms */
#else
#define CLBRSCHEDSM_TIMER_VAL_AFTER_OFFLINE_ST    (30010000)     /* 30 sec + 10ms */
#endif
#define CLBRSCHEDSM_ONLINE_CALIB_FAST_MODE_DELAYS 				    (12)    /* number of delays during fast mode calibration */  
#ifdef ENET_INC_UMAC
#define CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_FAST_MODE		(30010) /* 30 sec + 10ms */
#else
#define CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_FAST_MODE		(30010000) /* 30 sec + 10ms */
#endif
#ifdef ENET_INC_UMAC
#define CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_REGULAR_MODE	(600010)/* 10 min + 10ms */
#else
#define CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_REGULAR_MODE	(600010000)/* 10 min + 10ms */
#endif
#ifdef ENET_INC_UMAC
#define CLBRSCHEDSM_TIMER_VAL_DURING_ONLINE_CALIB 				    (1010)  /* 1 sec + 10ms */
#else
#define CLBRSCHEDSM_TIMER_VAL_DURING_ONLINE_CALIB 				    (1010000)  /* 1 sec + 10ms */
#endif
#define CLBRSCHEDSM_NUMBER_OF_DELAYS_FOR_NEXT_CALIB_IN_FAST_MODE    (1)  
#define CLBRSCHEDSM_NUMBER_OF_DELAYS_FOR_NEXT_CALIB_IN_REGULAR_MODE (12)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
/*Online calibration SM*/
 typedef enum HdkCdbManagerOnlineCalStates
 {
	ONLINE_CAL_SM_STATE_IDLE,
	ONLINE_CAL_SM_STATE_WAIT_FOR_CALIBRATION_SCHEDULED,
	ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_FIRST_BAND_SERIAL_MODE,
	ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_SECOND_BAND_SERIAL_MODE,
	ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_FIRST_BAND_SERIAL_MODE,
	ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_SECOND_BAND_SERIAL_MODE,
	ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_PARALLEL_MODE,
	ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_PARALLEL_MODE,
	ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED,
	ONLINE_CAL_SM_STATE_LAST	
 }HdkCdbManagerOnlineCalStates_e;
 typedef enum HdkCdbManagerOnlineCalEvents
 {
	ONLINE_CAL_SM_EVENT_EN_DIS_CAL,
	ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED,
	ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND,
	ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND,
	ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND_SINGLE_BAND,
	ONLINE_CAL_SM_EVENT_CTS2SELF_SENT,
	ONLINE_CAL_SM_EVENT_CTS2SELF_SENT_SINGLE_BAND,
	ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND,
	ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND_SINGLE_BAND,
	ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND,
		
 }HdkCdbManagerOnlineCalEvents_e;
typedef enum cdbOnlineCalmode
{
	CDB_ONLINE_CAL_PARALLEL_MODE,
	CDB_ONLINE_CAL_SERIAL_MODE,
}cdbOnlineCalmode_e;
typedef struct OnlineCalSM_TimingParams
{
	uint32  timerValInFastMode; 	 //for debug config
	uint32  timerValInRegularMode;   //for debug config
	uint32  delayAmountInRegularMode;//for debug config 
	uint32  modeCount; 				 //for debug config
	uint32  delayTime;
	uint32	onlineMask;
	uint8 	delayCount;
	uint8   calibModeCount;
	uint8   delayAmount;
	bool	onlineTimerActive;
	uint32	m_onlineTimerValue;
}OnlineCalSM_TimingParams_t;


typedef struct CdbManagerOnlineCalDb_t
{
	HdkCdbManagerOnlineCalStates_e state;
	uint8 waitForBandRspBitmap;
	uint8 onlineCalibrationEnabledBitMap;
	uint8 onlineCalibrationInProcessBitMap;
	cdbOnlineCalmode_e calibrationMode;
	uint8 moreFrags[HDK_NUM_OF_BANDS];
	uint8 wasCalibrated[HDK_NUM_OF_BANDS];
	ClbrProcType_e nextCalibration[HDK_NUM_OF_BANDS];
	OnlineCalSM_TimingParams_t timingParams;
	bool runOnlineImmediate;
#ifdef HDK_CDB_SUPPORT
	bool enabledBitmapOverride;	
	bool origEnabledState;
	uint8 origEnabledBand;
#endif
	HdkCdbManagerMainSmBandState_e BandMainstate[HDK_NUM_OF_BANDS];
}CdbManagerOnlineCalDb_t;
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------
void HdkCdbManager_SmHandlerTimerExpired(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOnlineProcessSched(K_MSG* pMsg);
void HdkCdbManager_SmHandlerCtsSendInd(K_MSG* pMsg);
void HdkCdbManager_SmEnDisOnlineCalReq(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOnlineTimerExpired(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOnlineProcessSchedInd(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOnlineCalibrationEnded(K_MSG* pMsg);
void HdkCdbManager_SmHandlerOnlineProcessEnded(K_MSG* pMsg);
void HdkCdbManager_onlineSchedParamsInit (void);
void HdkCdbManagerOnlineCalSetMainState(BandId_e band, HdkCdbManagerMainSmBandState_e BandMainstate);
void HdkCdbManagerOnlineCalSm(uint8 eventGeneralType, K_MSG* pMsg);
bool checkIfVapsAreReadyForOnlineCal(void);



#endif //__HdkCdbManager_OnlineCalSm_h__
