/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkCdbManagerTask.h"
#include "loggerAPI.h"
#include "queue_utility.h"
#include "Hdk_Api.h"
#include "EventsManager_api.h"
#include "OSAL_UpperMacMessages.h"
#include "ConfigurationManager_api.h"
#include "Indirect_API.h"
#include "init_ifmsg.h"
#include "um_interface.h"
#include "HostInterface_API.h"
#include "RegAccess_Api.h"
#include "MT_Math.h"
#if defined (ENET_INC_ARCH_WAVE600) 
#include "MacGeneralRegs.h"
#include "phy_lib.h"
#include "SocRegsRegs.h"
#endif

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 1

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef void (*hdkCdbManStateMachineFunc)(uint8, K_MSG*);

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void hdkSetHwDependentConfigReq(K_MSG* pMsg);
static void hdkSetHwDependentDone(K_MSG* pMsg);
static void changeBandStateInd( K_MSG* pmsg);
static void postVapActivationInd( K_MSG* pmsg);
static void HdkCdbManActivateDmaReq(K_MSG* pMsg);
static void HdkCdbManHostDataChunkDmaCompleteBand0(K_MSG* pMsg);
static void HdkCdbManHostDataChunkDmaCompleteBand1(K_MSG* pMsg);
static void hdkCdbManSendErrorsToHost(K_MSG* pMsg);
static void HdkCdbManSetPsdPmAddress(K_MSG* psdPMShramAddressMsg);
static void HdkPvtRead(K_MSG* psMsg);
static void radarSerialTrace(K_MSG * psMsg);

extern uint8* HdkCdbManagerGetAfeCalEfuseData(void);

uint32* psdProgmodelShramAddressHdkCdbMan = NULL;

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

static const FunctionEntry_t afpTaskTable[TASK_HDK_CDB_MAN_END - TASK_HDK_CDB_MAN_START]=
{	
	/*HW dependent*/
	{hdkSetHwDependentConfigReq,				  			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_HW_DEPENDENT_CONFIG_REQ)},
	{hdkSetHwDependentDone,									DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_HW_DEPENDENT_COMMON_CONFIG_DONE)},
	/* ADD VAP messages*/
	{HdkCdbManager_SmHandlerAddVapReq,						DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_ADD_VAP_REQ)},
	{HdkCdbManager_SmHandlerCommonConfigDone, 				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_ADD_VAP_COMMON_CONFIG_DONE)},
	{HdkCdbManager_SmHandlerAddVapBandConfigCfm,			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM)},
	{HdkCdbManager_SmHandlerRemoveVapReq,					DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_REMOVE_VAP_REQ)},
	{HdkCdbManager_SmHandlerRemoveNonLastVapReq,			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_REMOVE_NON_LAST_VAP_BAND_CONFIG_CFM)},
	{HdkCdbManager_SmHandlerRemoveVapBandCfm,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_REMOVE_VAP_BAND_CONFIG_CFM)},
	/*Common config messages*/
	{HdkCdbManager_ConfigSmConfigurationReq, 				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ)},
	{HdkCdbManager_ConfigSmConfigurationCfm,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_CONFIG_SM_CONFIG_CFM)},
	/* Offline calibration messages*/
	{HdkCdbManager_SmHandlerRunOfflnieCalReq,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_RUN_OFFLINE_CALIBRATION_REQ)},
	{HdkCdbManager_SmHandlerOfflineCalFinishedOnOneCh,		DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH)},
	{HdkCdbManager_SmHandlerOfflineCalFinishedOnLastCh,		DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH)},
	{HdkCdbManager_SmHandlerPauseDone,						DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_NON_CALIBRATING_BAND_PAUSE_DONE)},
	{HdkCdbManager_SmHandlerResumeDone,						DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_NON_CALIBRATING_BAND_RESUME_DONE)},
	{HdkCdbManager_SmHandlerChangeToMaxAntsDone, 			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_MAX_ANTS_CFM)},
	{HdkCdbManager_SmHandlerResumeCalibratingBandCfm,		DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_RESUME_CALIBRATING_BAND_CFM)},
	{HdkCdbManager_SmHandlerResumeCalibratingBandDone,		DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_RESUME_CALIBRATING_BAND_DONE)},
	/* Online calibration messages*/
	{HdkCdbManager_SmEnDisOnlineCalReq, 					DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_EN_DIS_ONLINE_CAL_REQ)},
	{HdkCdbManager_SmHandlerOnlineTimerExpired,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED)},
	{HdkCdbManager_SmHandlerOnlineProcessSchedInd, 			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_SYNC_SERVICE_PROCESS_SCHEDULED_IND)},
	{HdkCdbManager_SmHandlerCtsSendInd, 					DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_SYNC_SERVICE_CTS_SENT_IND)},
	{HdkCdbManager_SmHandlerOnlineCalibrationEnded,			DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_ONLINE_CALIBRATION_ENDED)},
	{HdkCdbManager_SmHandlerOnlineProcessEnded,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED)},
	/* Load and Store DMA complete msg */
	{HdkCdbManActivateDmaReq,								DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_ACTIVATE_DMA_REQ)},
	{HdkCdbManHostDataChunkDmaCompleteBand0,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND0)},
	{HdkCdbManHostDataChunkDmaCompleteBand1,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND1)},
	/* Change state indication from HdkBand*/
	{changeBandStateInd, 									DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_STATE_CHANGED_IND)},		
	{postVapActivationInd, 									DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_BAND_POST_VAP_ACTIVATION_IND)},
	/* Send calibration error message to host*/
	{hdkCdbManSendErrorsToHost,								DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SEND_CAL_ERROR_MSG_TO_HOST_REQ)},
	/*Set antenna configuration*/
	{HdkCdbManagerAntConfigSmPrepareChangeReq,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_PREPARE_ANT_CONFIG_REQ)},
	{HdkCdbManagerAntConfigSmPrepareChangeDone,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_PREPARE_ANT_CONFIG_DONE)},
	{HdkCdbManagerAntConfigSmSetAntReq,						DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_ANT_CONFIG_REQ)},
	{HdkCdbManagerAntConfigSmSetAfeCalData,					DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_AFE_CAL_DATA)},
	{HdkCdbManagerAntConfigSmSetRssiCalData,				DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_RSSI_CAL_DATA)},
	{HdkCdbManagerAntConfigSmSetAntCfm,						DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_ANT_CONFIG_DONE)},
	{HdkCdbManSetPsdPmAddress, 								DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_SET_PSD_PM_ADDRESS_REQ)},
	{HdkPvtRead,											DOUBLE_CHECK_MSG_TYPE(HDK_CDB_MAN_PVT_READ)},
	{radarSerialTrace,										DOUBLE_CHECK_MSG_TYPE(HDK_RADAR_SERIAL_TRACE)}
};
static const hdkCdbManStateMachineFunc StateMachineFuncArr[NUM_OF_STATE_MACHINES] = 
{
	HdkCdbManagerConfigSm,
	HdkCdbManager_AddVapSm,
	HdkCdbManagerOnlineCalSm,
	HdkCdbManagerOfflineCalSm,
	HdkCdbManagerAntConfigSm,
};
static HdkCdbManagerEventTypeTable_t* EventModeTableArr[NUM_OF_STATE_MACHINES] = 
{
	&HdkCdbManagerConfigSmEventModeTable,
	&HdkCdbManagerAddVapEventModeTable,
	&HdkCdbManagerOnlineCalEventModeTable,
	&HdkCdbManagerOfflineCalEventModeTable,
	&HdkCdbManagerAntConfigSmEventModeTable
};

HdkCdbManagerDbStruct_t HdkCdbManagerDb;
uint8 dmaManagerClientIdBand0;
uint8 dmaManagerClientIdBand1;
const HdkCdbManagerMainSmBandState_e convertHdkBandMainState2HdkCdbMainState[HDK_NUMBER_OF_STATES] = 
{
	HDK_CDB_MAN_MAIN_SM_STATE_IDLE,		//HDK_STATE_IDLE
	HDK_CDB_MAN_MAIN_SM_STATE_INIT,		//HDK_STATE_INIT
	HDK_CDB_MAN_MAIN_SM_STATE_READY,	//HDK_STATE_READY
	HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE,	//HDK_STATE_ACTIVE
	HDK_CDB_MAN_MAIN_SM_STATE_DISABLE,	//HDK_STATE_DISABLED
};
/*---------------------------------------------------------------------------------
/						Functions definition							
/----------------------------------------------------------------------------------*/
void HdkCdbManager_TaskEntry(K_MSG *HdkCdbManagerMsg)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("HdkCdbManager_TaskEntry, msgType = %d",HdkCdbManagerMsg->header.tKMsgType);
#endif
	/* Use common task switching and Table */
	vTaskDispatcher(HdkCdbManagerMsg, afpTaskTable, TASK_HDK_CDB_MAN_START, TASK_HDK_CDB_MAN_END);
}

void CdbManagerHandleReceivedMsgFromBand(uint8* pWaitForBandRspBitmap, BandId_e band)
{
	/*Verify received band*/
	ASSERT(CDB_IS_BIT_SET_IN_BYTE(band,*pWaitForBandRspBitmap) != 0);
	CDB_MAN_CLR_BIT_IN_BYTE(band,*pWaitForBandRspBitmap);
}
/**********************************************************************************

hdkSetHwDependentConfigReq 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void hdkSetHwDependentConfigReq(K_MSG* pMsg)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	UmiHwDependentConfig_t* pConfigReq = (UmiHwDependentConfig_t*)pK_MSG_DATA(pMsg);
#endif
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	
#ifdef HDK_CDB_DEBUG_LOGGER
	SLOG0(0, 0, UmiHwDependentConfig_t, pConfigReq);
#endif	
	/*Send message to configuration SM to set add vap common configuration in bands*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_HW_DEPENDENT_COMMON_CONFIG_DONE;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 3;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_INDIRECT_RESET_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_RESET_PHY_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task= TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_CONFIG_SM_HW_DEPENDENT_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->hostMsgAddress = pMsg;
	pConfigSmParams->configureVapId = ConfigurationManager_GetFirstVapForBand(CONFIGURATION_MANAGER_BAND_0);
	ASSERT(psdProgmodelShramAddressHdkCdbMan);//must be non zero
	pConfigSmParams->param = (uint32)psdProgmodelShramAddressHdkCdbMan;

	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,pMsg->header.vapId); 

}
/**********************************************************************************

hdkSetHwDependentDone 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
static void hdkSetHwDependentDone(K_MSG* pMsg)
{
	HdkCdbManagerConfigMsg_t* pConfigMsg = (HdkCdbManagerConfigMsg_t*)pK_MSG_DATA(pMsg);

	
	/*Send confirmation to host, take original Kmsg address from pConfigMsg */
	OSAL_SEND_MESSAGE(UMI_KMSG_HW_DEPENDENT_CONFIG_CFM, TASK_UM_IF_TASK, pConfigMsg->hostMsgAddress, pConfigMsg->hostMsgAddress->header.vapId);
}
/**********************************************************************************

changeBandStateInd 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

static void changeBandStateInd( K_MSG* pmsg)
{
	HdkCdbManagerBandChangeStateMsg_t*	pBandChangeStateIndParams = (HdkCdbManagerBandChangeStateMsg_t*)pK_MSG_DATA(pmsg);
	HdkCdbManagerBandChangeStateMsg_t *pBandChangeStateResParams;
	HdkCdbManagerMainSmBandState_e cdbMainState = convertHdkBandMainState2HdkCdbMainState[pBandChangeStateIndParams->bandState];
	K_MSG *pBandChangeStateMsg;

	/*Set main SM band state*/
	hdkCdbMainSmChangeState(pBandChangeStateIndParams->band, cdbMainState);
	
	/* Send response to HdkTask*/	
	pBandChangeStateMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerBandChangeStateMsg_t));
	pBandChangeStateResParams = (HdkCdbManagerBandChangeStateMsg_t*)pK_MSG_DATA(pBandChangeStateMsg);
	MEMCPY(pBandChangeStateResParams, pBandChangeStateIndParams, sizeof(HdkCdbManagerBandChangeStateMsg_t));

	OSAL_SEND_MESSAGE(pBandChangeStateIndParams->retMsg, pBandChangeStateIndParams->retTask,pBandChangeStateMsg, ConfigurationManager_GetFirstVapForBand(pBandChangeStateIndParams->band));
}
/**********************************************************************************

postVapActivationInd 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

static void postVapActivationInd( K_MSG* pmsg)
{
	BandId_e bandId = ConfigurationManager_GetBandForVap(pmsg->header.vapId);
	
	ASSERT(bandId < HDK_NUM_OF_BANDS);
	/*Set main SM band state*/
	HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[bandId] = TRUE;

	HdkCdbManagerDb.addVapSm.vapPostActivationCounter[bandId]++;

	if((HdkCdbManagerDb.onlineCalSmDb.runOnlineImmediate == TRUE) && (HdkCdbManagerDb.onlineCalSmDb.onlineCalibrationEnabledBitMap != 0))
	{
		if (checkIfVapsAreReadyForOnlineCal() == TRUE)
		{			
			// Initialize Online schedule params
			HdkCdbManager_onlineSchedParamsInit();
			OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED, TASK_HDK_CDB_MANAGER, VAP_ID_DO_NOT_CARE);
		}
	}
}
/**********************************************************************************

HdkCdbManager_Init 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif

void HdkCdbManager_Init(void)
{
#if defined (ENET_INC_ARCH_WAVE600) 

	PHY_MAC_BAND_CONFIG_REG_INIT();

#endif

	memset (&HdkCdbManagerDb, 0, sizeof(HdkCdbManagerDbStruct_t)); 

	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_SINGLE_BAND) //Single band mode
	{

		HdkCdbManagerDb.mainSmDb.mode = HDK_CDB_SINGLE_BAND;
		HdkCdbManagerDb.mainSmDb.state.bandState[CONFIGURATION_MANAGER_BAND_0] = HDK_CDB_MAN_MAIN_SM_STATE_INIT;	
		HdkCdbManagerDb.onlineCalSmDb.BandMainstate[CONFIGURATION_MANAGER_BAND_0]= HDK_CDB_MAN_MAIN_SM_STATE_INIT;
#if defined (ENET_INC_ARCH_WAVE600) 
		PHY_Reset((uint8)CONFIGURATION_MANAGER_BAND_0,1);
#if defined (BAND_1_PHY_RESET_WORKAROUND) 
		PHY_Reset((uint8)CONFIGURATION_MANAGER_BAND_1,1); //There is a bug in A0 that causes band1 to consume a lot of power if it is held in reset
#else
		PHY_Reset((uint8)CONFIGURATION_MANAGER_BAND_1,0); 
#endif
		PHY_SET_MAC_BAND((uint8)CONFIGURATION_MANAGER_BAND_0);
#endif
	}
	else //Dual band mode
	{
		HdkCdbManagerDb.mainSmDb.mode = HDK_CDB_DUAL_BAND;
		HdkCdbManagerDb.mainSmDb.state.bandState[CONFIGURATION_MANAGER_BAND_0] = HDK_CDB_MAN_MAIN_SM_STATE_INIT;	
		HdkCdbManagerDb.mainSmDb.state.bandState[CONFIGURATION_MANAGER_BAND_1] = HDK_CDB_MAN_MAIN_SM_STATE_INIT;
		HdkCdbManagerDb.onlineCalSmDb.BandMainstate[CONFIGURATION_MANAGER_BAND_0] = HDK_CDB_MAN_MAIN_SM_STATE_INIT;
		HdkCdbManagerDb.onlineCalSmDb.BandMainstate[CONFIGURATION_MANAGER_BAND_1] = HDK_CDB_MAN_MAIN_SM_STATE_INIT;
#if defined (ENET_INC_ARCH_WAVE600) 
		PHY_Reset((uint8)CONFIGURATION_MANAGER_BAND_0,1);
		PHY_Reset((uint8)CONFIGURATION_MANAGER_BAND_1,1);
		PHY_SET_MAC_BAND((uint8)CONFIGURATION_MANAGER_BAND_0);
		PHY_SET_MAC_BAND((uint8)CONFIGURATION_MANAGER_BAND_1);
#endif
		
	}
	
#if defined (ENET_INC_ARCH_WAVE600) 
	/*TBD - should be moved to IndirectReset function */
		FCSI_CENTRAL_ENABLE(TRUE);
		FCSI_CENTRAL_RESET(TRUE); // Central FCSI reset
#endif
	HdkCdbManager_onlineCalSmInit();
}

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif




#if defined ENET_INC_UMAC
void HdkCdbManager_PostInitDmaInit(void)
{
	dmaRegistration_t dmaRegisterBand0;
	dmaRegistration_t dmaRegisterBand1;

	// Register as a client with DMA Manager
	// Fill parameters
	dmaRegisterBand0.priority = DMA_PRIORITY_5;
	dmaRegisterBand0.eventId = EVENT_ID_DMA_HDK_BAND0;

	dmaRegisterBand1.priority = DMA_PRIORITY_5;
	dmaRegisterBand1.eventId = EVENT_ID_DMA_HDK_BAND1;
	// Register and get clientID
	dmaManagerClientIdBand0 = DmaManager_Register(&dmaRegisterBand0);
	dmaManagerClientIdBand1 = DmaManager_Register(&dmaRegisterBand1);
}
#endif
static void HdkCdbManHostDataChunkDmaCompleteBand0(K_MSG* pMsg)
{
#if defined ENET_INC_UMAC
	uint8 vapId = ConfigurationManager_GetFirstVapForBand0();
	UNUSED_PARAM(pMsg);
	/*Event turned off by EventManager_TriggerSwEvent, we should turn it on here*/
	EventManager_TurnOnEvent(EVENT_ID_DMA_HDK_BAND0);	
	/*Send DMA complete Msg to Hdk band0 */
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CHUNK_DMA_COMPLETE, TASK_HDK, vapId); 
#endif	
}
static void HdkCdbManHostDataChunkDmaCompleteBand1(K_MSG* pMsg)
{
#if defined ENET_INC_UMAC
	uint8 vapId = ConfigurationManager_GetFirstVapForBand1();
	UNUSED_PARAM(pMsg);
	/*Event turned off by EventManager_TriggerSwEvent, we should turn it on here*/
	EventManager_TurnOnEvent(EVENT_ID_DMA_HDK_BAND1);	
	/*Send DMA complete Msg to Hdk band1 */
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CHUNK_DMA_COMPLETE, TASK_HDK, vapId); 
#endif
}
static void HdkCdbManActivateDmaReq(K_MSG* pMsg)
{
#if defined ENET_INC_UMAC
	HdkCdbManagerActivateDmaMsg_t* activateDmaMsg = (HdkCdbManagerActivateDmaMsg_t*)pK_MSG_DATA(pMsg);
	dmaDesc_t*	pDmaDesc = NULL;
	uint8 clientId = ((activateDmaMsg->band == CONFIGURATION_MANAGER_BAND_0) ? dmaManagerClientIdBand0 : dmaManagerClientIdBand1);

	// Allocate DMA descriptor
	pDmaDesc = DmaManager_AllocateDesc();

	// Fill DMA descriptor
	pDmaDesc->source 		= activateDmaMsg->dmaParams.source;
	pDmaDesc->destination 	= activateDmaMsg->dmaParams.destination;
	pDmaDesc->direction 	= activateDmaMsg->dmaParams.direction;
	pDmaDesc->length		= activateDmaMsg->dmaParams.length;
	pDmaDesc->clientId 		= clientId;

	// Kick DMA manager
	DmaManager_NewDmaRequest(pDmaDesc);	
#endif
}
static void hdkCdbManSendErrorsToHost(K_MSG* pMsg)
{
#if defined ENET_INC_UMAC
	HdkCdbManCalibrationErrorMsgToHost_t* pCalErrorMsgToHostParams = (HdkCdbManCalibrationErrorMsgToHost_t*)pK_MSG_DATA(pMsg);
	MAC_EVENT sMACEvent;
	uint8 vapId;
	
	sMACEvent.u.sCalibrationEvent.u32calibrAlgoType = pCalErrorMsgToHostParams->calibrAlgoType;
	sMACEvent.u.sCalibrationEvent.u32ErrCode = pCalErrorMsgToHostParams->errCode;
	sMACEvent.u32EventID = pCalErrorMsgToHostParams->eventId;
	sMACEvent.u32Timestamp = pCalErrorMsgToHostParams->timeStamp;
	vapId = ConfigurationManager_GetFirstVapForBand(pCalErrorMsgToHostParams->band);
	
	vIF_SendMsg(&sUmiIndFreeQueue, UMI_MC_MAN_MAC_EVENT_IND, TASK_UM_IF_TASK, &sMACEvent, sizeof(MAC_EVENT), vapId);
#else
	ASSERT(0); //This message should be received here in LM
#endif
}

void hdkCdbManagerGetMainState(BandId_e currentBand, HdkCdbManSmType_e smType,HdkCdbManagerMainSmBandState_e* currentBandstate_p, HdkCdbManagerMainSmBandState_e* otherBandstate_p)
{
	BandId_e otherBand = ((currentBand == CONFIGURATION_MANAGER_BAND_0) ? CONFIGURATION_MANAGER_BAND_1 : CONFIGURATION_MANAGER_BAND_0);
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;

	if (smType == HDK_CDB_MAN_ONLINE_CAL_SM)
	{
		*currentBandstate_p = pOnlineCalSmDb->BandMainstate[currentBand];
		*otherBandstate_p = pOnlineCalSmDb->BandMainstate[otherBand];

	}
	else
	{
		*currentBandstate_p = HdkCdbManagerDb.mainSmDb.state.bandState[currentBand];
		*otherBandstate_p = HdkCdbManagerDb.mainSmDb.state.bandState[otherBand];

	}


}
void sendEventToSm(K_MSG* pMsg, HdkCdbManSmType_e smType, uint8 singleBandEvent, uint8 dualBandEvent)
{
	HdkCdbManagerEventTypeTable_t* eventTypeTable = EventModeTableArr[smType];

	HdkCdbManagerMainSmBandState_e currentBandstate;
	HdkCdbManagerMainSmBandState_e otherBandstate;
	HdkCdbManagerOfflineCalSmMsg_t* pOfflineCalMsgParams;
	bool forceRunSingleBand;
	BandId_e currentBand = ConfigurationManager_GetBandForVap(pMsg->header.vapId);

	ASSERT(currentBand < HDK_NUM_OF_BANDS);
	hdkCdbManagerGetMainState(currentBand, smType, &currentBandstate,&otherBandstate);

	forceRunSingleBand = FALSE;
	
	if (smType == HDK_CDB_MAN_OFFLINE_CAL_SM)
	{
		pOfflineCalMsgParams = (HdkCdbManagerOfflineCalSmMsg_t*)pK_MSG_DATA(pMsg);
		if ((pOfflineCalMsgParams->dualBandOfflineCalType == SINGLE_BAND_OFFLINE_CAL) || ((HdkCdbManagerDb.offlineCalSmDb.calCdbType == SINGLE_BAND_OFFLINE_CAL) && (HdkCdbManagerDb.offlineCalSmDb.state != OFFLINE_CAL_SM_STATE_IDLE)))
		{
			forceRunSingleBand = TRUE;
		}
	}
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_DDD("sendEventToSm, State machine = %d,  singleBandEvent = %d, dualBandEvent = %d", smType, singleBandEvent, dualBandEvent);
	ILOG0_DD("currentBandstate %d otherBandstate %d",currentBandstate, otherBandstate);
#endif
	if ((forceRunSingleBand != TRUE) && ((HdkCdbManagerDb.mainSmDb.mode == HDK_CDB_DUAL_BAND) && 
		(eventTypeTable->HdkCdbManagerEventModeTable[currentBandstate][otherBandstate] == HDK_CDB_MAN_DUAL_BAND_EVENT)))
	{
		/*Dual band mode*/
		ASSERT(dualBandEvent != INVALID_SM_EVENT);
		StateMachineFuncArr[smType](dualBandEvent,pMsg); //call SM
	}
	else if(eventTypeTable->HdkCdbManagerEventModeTable[currentBandstate][otherBandstate] != HDK_CDB_MAN_INVALID_EVENT)
	{
		/*Single band mode*/
		ASSERT(singleBandEvent != INVALID_SM_EVENT);
		StateMachineFuncArr[smType](singleBandEvent,pMsg); //call SM
	}
	else //HDK_CDB_MAN_INVALID_EVENT
	{
		ASSERT(0);
	}
}
static void HdkCdbManSetPsdPmAddress(K_MSG* psdPMShramAddressMsg)
{
	PsdProgmodelShramAddressIndMsg_t* params;
	params = (PsdProgmodelShramAddressIndMsg_t*)pK_MSG_DATA(psdPMShramAddressMsg);
	
	psdProgmodelShramAddressHdkCdbMan = params->psdProgmodelSramAdd;
}

#define PVT_TEMP_CALCS_RES		23
#define PVT_VOLT_CALCS_RES		24
#define PVT_DATA_NUM_BITS	10
#define PVT_READ_TIMEOUT	10000
static void HdkPvtRead(K_MSG * psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600
#ifndef ENET_INC_ARCH_WAVE600D2 // There will be a different PVT sensor for 600-2, compile out for now.
	UMI_PVT_t* params;
	int32 a0,a1,a2,a3,a4;
	RegSocRegsPvtSensorCtrl_u pvtCtrlReg;
	RegSocRegsPvtSensorData_u pvtData;
	uint32 starttime;
	uint32 timediff;
	uint32 x, x_square;
	int64 tmp64;
	int32 tmp32;
	uint8 trimvalue;
	uint8* afeCalEfuseDataArray;
	
	params = (UMI_PVT_t*)pK_MSG_DATA(psMsg);

	//calc temperature
	a0 = -433934303;	// -51.729 in 23bit fixed point resolution
	a1 = 2535625;		// 0.30227 in 23bit fixed point resolution
	a2 = -1437;			// -1.7128E-4 in 23bit fixed point resolution
	a3 = 2203;			// sqrt of 6.898E-8 in 23bit fixed point resolution
	a4 = 30;			// sqrt of abs(-1.2713E-11) in 23bit fixed point resoltion

	pvtCtrlReg.val = 0;
	pvtCtrlReg.bitFields.pvtEna = 0;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	afeCalEfuseDataArray=HdkCdbManagerGetAfeCalEfuseData();
	trimvalue=(afeCalEfuseDataArray[17]&0x1F); // temperature sensor[4:0] trim value is mapped into index 18 in the ABB Efuse section
	pvtCtrlReg.bitFields.pvtTrim = trimvalue;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	pvtCtrlReg.bitFields.pvtEna = 1;
	//trigger temperature measurement and wait for valid
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	starttime = GET_TSF_TIMER_LOW();
	timediff = 0;
	RegAccess_Read(REG_SOC_REGS_PVT_SENSOR_DATA, &pvtData.val);
	while (pvtData.bitFields.pvtDataValid == 0)
	{
		RegAccess_Read(REG_SOC_REGS_PVT_SENSOR_DATA, &pvtData.val);
		timediff = GET_TSF_TIMER_LOW() - starttime;
		ASSERT(timediff < PVT_READ_TIMEOUT);
	}
	// calc a0 + a1*x + a2*x^2 + a3*x^3 + a4*x^4
	// a3*x^3 = (sqrt(a3)*x)^2 * x : sqrt(a3) requires lower fixed point resolution
	// a4*x^4 = ((sqrt(a4)*x^2)^2  : sqrt(a4) requires lower fixed point resolution
	x = pvtData.bitFields.pvtData;
	x_square = x * x;
	SERIAL_TRACE("PVT temp raw value", x, 0, 0);
	tmp64 = a4 * x_square; // sqrt(a4)*x^2
	tmp32 = -((tmp64 * tmp64) >> PVT_TEMP_CALCS_RES); // a4*x^4, shifted back to 23bit resolution
	tmp64 = a3 * x_square; // sqrt(a3)*x^2
	tmp32 += (tmp64 * a3 * x) >> PVT_TEMP_CALCS_RES; // a3*x^3, shifted back to 23bit resolution
	tmp32 += (int64)a2 * x_square; // a2*x^2
	tmp32 += a1 * x + a0; // a1*x + a0
	params->temperature = tmp32 >> PVT_TEMP_CALCS_RES;

	//trigger volatage measurement
	pvtCtrlReg.bitFields.pvtEna = 0;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	pvtCtrlReg.bitFields.pvtVsample = 1;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	pvtCtrlReg.bitFields.pvtEna = 1;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
	starttime = GET_TSF_TIMER_LOW();
	timediff = 0;
	RegAccess_Read(REG_SOC_REGS_PVT_SENSOR_DATA, &pvtData.val);
	while (pvtData.bitFields.pvtDataValid == 0)
	{
		RegAccess_Read(REG_SOC_REGS_PVT_SENSOR_DATA, &pvtData.val);
		timediff = GET_TSF_TIMER_LOW() - starttime;
		ASSERT(timediff < PVT_READ_TIMEOUT);
	}

	a0 = 7640512; // 0.45541 in 24bit fixed point resolution
	a1 = 13314;   // 7.9359E-4 in 24bit fixed point resolution

	// calc a0 + a1 * x
	x = pvtData.bitFields.pvtData;
	SERIAL_TRACE("PVT voltage raw value", x, 0, 0);
	tmp64 = a1 * x + a0;
	tmp32 = (tmp64 * 1000) >> PVT_VOLT_CALCS_RES; //convert result to mV
	params->voltage = tmp32;
	
	// disable sensor
	pvtCtrlReg.bitFields.pvtEna = 0;
	RegAccess_Write(REG_SOC_REGS_PVT_SENSOR_CTRL, pvtCtrlReg.val);
#endif // ENET_INC_ARCH_WAVE600D2
	OSAL_SEND_MESSAGE(UMI_MC_MAN_PVT_CFM, TASK_UM_IF_TASK, psMsg, INVALID_VAP);
#endif	
}
static void radarSerialTrace(K_MSG * psMsg)
{
	RadarSerialTraceMsg_t* params = (RadarSerialTraceMsg_t*)pK_MSG_DATA(psMsg);

	UNUSED_PARAM(params);
	switch(params->serialTraceType)
	{
		case RADAR_SERIAL_TRACE_TIMER_EXPIRED:
			SERIAL_TRACE("TimerExpired", params->val1, params->val2,params->val3);
			break;
		case RADAR_SERIAL_TRACE_RADAR_FILTERED:
			SERIAL_TRACE("Radar filtered", params->val1, params->val2,params->val3);
			break;
		case RADAR_SERIAL_TRACE_RADAR_NOT_FILERED:
			SERIAL_TRACE("Radar not filtered", params->val1, params->val2,params->val3);
			break;
		default:
			SERIAL_TRACE("Illegal serial trace type!", params->val1, params->val2,params->val3);
			break;
	}
}

