/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "HdkCdbManagerTask.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 5




/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void addVapSmChangeState(HdkCdbManagerAddVapSmStates_e state);
static void addVapSmHandleAddVapDuringSmProcess(K_MSG* pAddVapMsg);
static void addVapSmHandleAddVapAfterCommonConfigDone(K_MSG* pAddRemoveVapMsg);
static void sendAddVapCommonConfigMsg(BandId_e band);
static void handleCommonConfigDoneEvent(K_MSG* pConfigSmMsg);
static void addVapSmHandleBandConfigDoneEvent(BandId_e band, uint8 vapId);
static void addVapSmHandleAddVapAtInit(K_MSG* pAddRemoveVapMsg);
static void vapSmHandleRemoveVapBandCfmEvent(BandId_e band, uint8 vapId);
static void vapSmHandleRemoveVap(K_MSG* pRemoveVapMsg);
static BandId_e extractBandAndVapFromAddVapSmMsg(K_MSG* pAddVapSmMsg, uint8* vapId);
static K_MSG* sendBssManagerRemoveVapCfmMsg(uint8 vapId);
static K_MSG* sendBssManagerAddVapCfmMsg(uint8 vapId);
static K_MSG* extractAddRemoveVapMsgFromBssManMsg(K_MSG* bssManMsg);
BandId_e getBandForVap(uint8 vapId);


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

HdkCdbManagerEventTypeTable_t HdkCdbManagerAddVapEventModeTable = 
{
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE*/
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_INIT*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_READY*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
};

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
void HdkCdbManager_SmHandlerAddVapReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_ADD_VAP, ADD_VAP_SM_EVENT_ADD_VAP);
}
void HdkCdbManager_SmHandlerRemoveVapReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_REMOVE_VAP, ADD_VAP_SM_EVENT_REMOVE_VAP);
}
void HdkCdbManager_SmHandlerRemoveNonLastVapReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_REMOVE_NON_LAST_VAP_BAND_CFM, ADD_VAP_SM_EVENT_REMOVE_NON_LAST_VAP_BAND_CFM);
}
void HdkCdbManager_SmHandlerCommonConfigDone(K_MSG* pMsg)
{
	
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_COMMON_CONFIG_DONE, ADD_VAP_SM_EVENT_COMMON_CONFIG_DONE);
}
void HdkCdbManager_SmHandlerAddVapBandConfigCfm(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_BAND_CONFIG_DONE_SINGLE_BAND, ADD_VAP_SM_EVENT_BAND_CONFIG_DONE);
}
void HdkCdbManager_SmHandlerRemoveVapBandCfm(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ADD_VAP_SM, ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM_SINGLE_BAND, ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM);
}

void HdkCdbManager_AddVapSm(uint8 eventGeneralType, K_MSG* pMsg)
{
	CdbManagerAddVapSmDb_t* pVapSmDb = &HdkCdbManagerDb.addVapSm;
	K_MSG* pAddRemoveVapMsg;
	BandId_e band;
	HdkCdbManagerAddVapSmEvents_e event = (HdkCdbManagerAddVapSmEvents_e)eventGeneralType;
	uint8 vapId;
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("HdkCdbManager_AddVapSm, event = %d",event);
#endif	
	switch (pVapSmDb->state)
	{
		case ADD_VAP_SM_STATE_INIT:
		{
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					/*First add vap after system went up */
					addVapSmHandleAddVapAtInit(pMsg);
					addVapSmChangeState(ADD_VAP_SM_STATE_COMMON_CONFIG_IN_PROCESS);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case ADD_VAP_SM_STATE_COMMON_CONFIG_IN_PROCESS:
		{
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					/*
					Add vap request during common confugration sequence in process.
					If add vap received for other band, store message, 
					for the same band ignore - because only first vap whould be handled here*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					addVapSmHandleAddVapDuringSmProcess(pAddRemoveVapMsg);
					break;
				case ADD_VAP_SM_EVENT_COMMON_CONFIG_DONE:
					/*Common configuration done*/
					handleCommonConfigDoneEvent(pMsg);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADDING_FIRST_VAP_IN_BAND);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case ADD_VAP_SM_STATE_WAIT_FOR_ADD_VAP:
		{
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					addVapSmHandleAddVapAfterCommonConfigDone(pAddRemoveVapMsg);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADDING_FIRST_VAP_IN_BAND);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case ADD_VAP_SM_STATE_ADDING_FIRST_VAP_IN_BAND:
		{
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					/*Add vap after one band already in process, if other band =>send message
					if same band => ignore and send Add vap confirmation to BSS manager*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					addVapSmHandleAddVapAfterCommonConfigDone(pAddRemoveVapMsg);
					break;
#ifdef HDK_CDB_SUPPORT
				case ADD_VAP_SM_EVENT_BAND_CONFIG_DONE:
					/*Add vap finished in HdkBand*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg, &vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					addVapSmHandleBandConfigDoneEvent(band,vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADD_FIRST_VAP_IN_FIRST_BAND_DONE);
					break;
#endif
				case ADD_VAP_SM_EVENT_BAND_CONFIG_DONE_SINGLE_BAND:
					/*Add vap finished in HdkBand in single band mode*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg,&vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					addVapSmHandleBandConfigDoneEvent(band,vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADD_FIRST_VAP_DONE);
					break;
				default:
						ASSERT(0);
			}
			break;
		}
#ifdef HDK_CDB_SUPPORT
		case ADD_VAP_SM_STATE_ADD_FIRST_VAP_IN_FIRST_BAND_DONE:
		{
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					/*Add vap after one band already in process, if other band =>send message
					if same band => ignore and send Add vap confirmation to BSS manager*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					addVapSmHandleAddVapAfterCommonConfigDone(pAddRemoveVapMsg);
					break;
				case ADD_VAP_SM_EVENT_BAND_CONFIG_DONE:
					/*Add vap finished in HdkBand*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg,&vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					addVapSmHandleBandConfigDoneEvent(band,vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADD_FIRST_VAP_DONE);
					break;
				case ADD_VAP_SM_EVENT_REMOVE_VAP:
					/*Remove vap after one band first vap added finished, if this is the last vap in band, 
					send message to Hdk band for disable phy otherwize send confirmaion to Bss manager*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					vapSmHandleRemoveVap(pAddRemoveVapMsg);
					break;
				case ADD_VAP_SM_EVENT_REMOVE_NON_LAST_VAP_BAND_CFM:
					band = extractBandAndVapFromAddVapSmMsg(pMsg,&vapId);					
					sendBssManagerRemoveVapCfmMsg(vapId);
					break;					
				case ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM:
					/*If this event received in this state we can be sure that this is the last vap in first band*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg, &vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					vapSmHandleRemoveVapBandCfmEvent(band,vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_WAIT_FOR_ADD_VAP);
					break;

				default:
					ASSERT(0);
			}
			break;
		}
#endif
		case ADD_VAP_SM_STATE_ADD_FIRST_VAP_DONE:
		{
			/*Add first vap has been done in two bands*/
			switch (event)
			{
				case ADD_VAP_SM_EVENT_ADD_VAP:
					/*Add vap after one band already in process, if other band =>send message
					if same band => ignore and send Add vap confirmation to BSS manager*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					addVapSmHandleAddVapAfterCommonConfigDone(pAddRemoveVapMsg);
					break;

				case ADD_VAP_SM_EVENT_REMOVE_VAP:
					/*Remove vap after two bands first vap added finished, if this is the last vap in band, 
					send message to Hdk band for disable phy otherwize send confirmaion to Bss manager*/
					pAddRemoveVapMsg = extractAddRemoveVapMsgFromBssManMsg(pMsg);
					vapSmHandleRemoveVap(pAddRemoveVapMsg);
					break;
#ifdef HDK_CDB_SUPPORT
				case ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM:
					/*If this event received in this state we can be sure that one band last vap removed, 
					send confirmation to Bss manager and change state*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg, &vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					vapSmHandleRemoveVapBandCfmEvent(band, vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_ADD_FIRST_VAP_IN_FIRST_BAND_DONE);
					break;
#endif
				case ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM_SINGLE_BAND:
					/*If this event received in this state we can be sure that last band last vap removed, 
					send confirmation to Bss manager and change state*/
					band = extractBandAndVapFromAddVapSmMsg(pMsg, &vapId);
					CdbManagerHandleReceivedMsgFromBand(&(pVapSmDb->waitForBandRspBitmap),band);
					vapSmHandleRemoveVapBandCfmEvent(band,vapId);
					addVapSmChangeState(ADD_VAP_SM_STATE_WAIT_FOR_ADD_VAP);
					break;
					
				case ADD_VAP_SM_EVENT_REMOVE_NON_LAST_VAP_BAND_CFM:
					band = extractBandAndVapFromAddVapSmMsg(pMsg,&vapId);					
					sendBssManagerRemoveVapCfmMsg(vapId);
					break;					
				default:
					ASSERT(0);
			}
			break;
		}

		default:
			ASSERT(0);
			break;
	}	
}

static void addVapSmChangeState(HdkCdbManagerAddVapSmStates_e state)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("addVapSmChangeState, state = %d", state);
#endif	
	HdkCdbManagerDb.addVapSm.state = state;
}

static void addVapSmHandleAddVapDuringSmProcess(K_MSG* pAddVapMsg)
{
	uint8 vapId; 
	BandId_e band;

	vapId = pAddVapMsg->header.vapId;
	band = ConfigurationManager_GetBandForVap(vapId);
	HdkCdbManagerDb.addVapSm.vapAddedCounter[band]++;
	//If band related to the msg is not in process store msg, if band is under process just send CFM to VAP manager
	if(HdkCdbManagerDb.addVapSm.vapAddedCounter[band] == 1) 
	{
		/*first vap for other band - not the one in process -> store msg for send it after common configuration finished*/
		HdkCdbManagerDb.addVapSm.pAddVapMsgStored[band] = pAddVapMsg;
	}
	else
	{
		/*Send cfm to driver*/
		sendBssManagerAddVapCfmMsg(vapId);
	}
}

static void addVapSmHandleAddVapAfterCommonConfigDone(K_MSG* pAddRemoveVapMsg)
{
	uint8 vapId; 
	BandId_e band;
	CdbManagerAddVapSmDb_t* pAddVapSmDb = &HdkCdbManagerDb.addVapSm;
	
	vapId = pAddRemoveVapMsg->header.vapId;
    band = getBandForVap(vapId);
	ASSERT(band < NUM_OF_CONFIGURATION_MANAGER_BANDS); // KW_FIX_FW_G Range Check
	pAddVapSmDb->vapAddedCounter[band]++;
	
	if(pAddVapSmDb->vapAddedCounter[band] == 1)
	{
		/*First vap in band => forward add vap message to Hdk band for handling*/
		CDB_MAN_SET_BIT_IN_BYTE(band,HdkCdbManagerDb.addVapSm.bandInProecessBitmap);
		hdkCdbManAddVapSmSendMsgToBand(pAddRemoveVapMsg, band, HDK_ADD_VAP_BAND_CONFIG_REQ, HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM);
	}
	else // band in process send confirmation without do anything
	{
		sendBssManagerAddVapCfmMsg(vapId);
	}
}

static void sendAddVapCommonConfigMsg(BandId_e band)
{
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	uint8 vapId;
	
	vapId = ConfigurationManager_GetFirstVapForBand(band);
	/*Send message to configuration SM to set add vap common configuration in bands*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_ADD_VAP_COMMON_CONFIG_DONE;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 3;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_RESET_PHY_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_RESET_RF_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_RESET_RF_BAND_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->configureVapId = vapId;
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,vapId); 

}

static void handleCommonConfigDoneEvent(K_MSG* pConfigSmMsg)
{
	uint8 bandInProcessBitmap = HdkCdbManagerDb.addVapSm.bandInProecessBitmap;
	BandId_e configuredBand;
	BandId_e otherBand;
	K_MSG* pAddVapMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;

	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	configuredBand = ConfigurationManager_GetBandForVap(pConfigSmParams->configureVapId);
	otherBand = GET_OTHER_BAND(configuredBand);
	
	ASSERT(CDB_IS_BIT_SET_IN_BYTE(configuredBand,bandInProcessBitmap));
	pAddVapMsg = HdkCdbManagerDb.addVapSm.pAddVapMsgStored[configuredBand];

	hdkCdbManAddVapSmSendMsgToBand(pAddVapMsg, configuredBand, HDK_ADD_VAP_BAND_CONFIG_REQ, HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM);
	if (HdkCdbManagerDb.addVapSm.pAddVapMsgStored[otherBand] != NULL) 
	{
		/*Msg from other band wait for handling =>send it to Hdk band task for handling*/
		pAddVapMsg = HdkCdbManagerDb.addVapSm.pAddVapMsgStored[otherBand];
		hdkCdbManAddVapSmSendMsgToBand(pAddVapMsg, otherBand, HDK_ADD_VAP_BAND_CONFIG_REQ, HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM);
	}
}

static void addVapSmHandleBandConfigDoneEvent(BandId_e band, uint8 vapId)
{
	CdbManagerAddVapSmDb_t* pVapSmDb = &HdkCdbManagerDb.addVapSm;

	CDB_MAN_CLR_BIT_IN_BYTE(band,pVapSmDb->bandInProecessBitmap);
	sendBssManagerAddVapCfmMsg(vapId);
}

static void vapSmHandleRemoveVapBandCfmEvent(BandId_e band, uint8 vapId)
{
	CdbManagerAddVapSmDb_t* pVapSmDb = &HdkCdbManagerDb.addVapSm;

	CDB_MAN_CLR_BIT_IN_BYTE(band,pVapSmDb->bandInProecessBitmap);
	sendBssManagerRemoveVapCfmMsg(vapId);
}

void hdkCdbManAddVapSmSendMsgToBand(K_MSG* pAddVapRemoveMsg,BandId_e band, K_MSG_TYPE reqMsgType,K_MSG_TYPE retMsgType)
{
	K_MSG* pMsgToBand;
	HdkCdbManagerAddVapSmMsg_t* pAddVapSmMsg;

	ASSERT(ConfigurationManager_GetBandForVap(pAddVapRemoveMsg->header.vapId) == band);
	CDB_MAN_SET_BIT_IN_BYTE(band,HdkCdbManagerDb.addVapSm.bandInProecessBitmap);
	CDB_MAN_SET_BIT_IN_BYTE(band,HdkCdbManagerDb.addVapSm.waitForBandRspBitmap);
	
	pMsgToBand = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerAddVapSmMsg_t));
	pAddVapSmMsg = (HdkCdbManagerAddVapSmMsg_t *)pK_MSG_DATA(pMsgToBand);
	pAddVapSmMsg->pAddRemoveVapMsg = pAddVapRemoveMsg;
	pAddVapSmMsg->retMsg = retMsgType;
	pAddVapSmMsg->retTask = TASK_HDK_CDB_MANAGER;

	OSAL_SEND_MESSAGE(reqMsgType, TASK_HDK, pMsgToBand, pAddVapRemoveMsg->header.vapId); 

}

static void vapSmHandleRemoveVap(K_MSG* pRemoveVapMsg)
{
	
	uint8 vapId; 
	BandId_e band;
	CdbManagerAddVapSmDb_t* pAddVapSmDb = &HdkCdbManagerDb.addVapSm;
#ifdef ENET_INC_ARCH_WAVE600
	K_MSG* pMsgToBand;
	HdkCdbManagerAddVapSmMsg_t* pAddVapSmMsg;
#endif
	vapId = pRemoveVapMsg->header.vapId;
    band = getBandForVap(vapId);
	ASSERT(band < NUM_OF_CONFIGURATION_MANAGER_BANDS); // KW_FIX_FW_G Range Check

	ASSERT(HdkCdbManagerDb.addVapSm.vapAddedCounter[band] > 0);
	HdkCdbManagerDb.addVapSm.vapAddedCounter[band]--;
	if (HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[band] == TRUE)
	{
		ASSERT(HdkCdbManagerDb.addVapSm.vapPostActivationCounter[band] > 0);
		HdkCdbManagerDb.addVapSm.vapPostActivationCounter[band]--;
		if(pAddVapSmDb->vapPostActivationCounter[band] == 0)
		{
			/* clear Vap is Active flag for online calibrations */		
			HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[band] = FALSE;
		}

	}
	if(pAddVapSmDb->vapAddedCounter[band] == 0)
	{
		/*last vap in band => send remove vap to Hdk band for disable antennas */
		hdkCdbManAddVapSmSendMsgToBand(pRemoveVapMsg, band, HDK_REMOVE_VAP_BAND_CONFIG_REQ, HDK_CDB_MAN_REMOVE_VAP_BAND_CONFIG_CFM);
	}
	else //Send message to HDK task for ERP remove vap handling - need to be done for each remove vap
	{
		hdkCdbManAddVapSmSendMsgToBand(pRemoveVapMsg, band, HDK_REMOVE_NON_LAST_VAP_REQ, HDK_CDB_MAN_REMOVE_NON_LAST_VAP_BAND_CONFIG_CFM);
	}
}

static BandId_e extractBandAndVapFromAddVapSmMsg(K_MSG* pAddVapSmMsg, uint8* vapId)
{
	BandId_e band;

	*vapId = pAddVapSmMsg->header.vapId;
	band = ConfigurationManager_GetBandForVap(*vapId);

	return band;
}

static K_MSG* sendBssManagerAddVapCfmMsg(uint8 vapId)
{
	K_MSG* psEventMsg;

	psEventMsg = OSAL_GET_MESSAGE(sizeof(BssManagerVapManagerReq_t));
	/*Send cfm to add vap manager*/
	FILL_VAP_MANAGER_CONFIRM_MSG(psEventMsg,vapId,VAP_MANAGER_ADD_VAP, BSS_MANAGER_VAP_MANAGER_HDK_CLIENT);
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psEventMsg, vapId);

	return psEventMsg;
}

static K_MSG* sendBssManagerRemoveVapCfmMsg(uint8 vapId)
{
	K_MSG* psEventMsg;

	psEventMsg = OSAL_GET_MESSAGE(sizeof(BssManagerVapManagerReq_t));
	/*Send confirmation to BSS manager*/
	FILL_VAP_MANAGER_CONFIRM_MSG(psEventMsg,vapId,VAP_MANAGER_REMOVE_VAP, BSS_MANAGER_VAP_MANAGER_HDK_CLIENT);
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psEventMsg, vapId);

	return psEventMsg;
}

static K_MSG* extractAddRemoveVapMsgFromBssManMsg(K_MSG* bssManMsg)
{
	BssManagerVapManagerReq_t* pVapManagerReq;
	pVapManagerReq = (BssManagerVapManagerReq_t *)pK_MSG_DATA(bssManMsg);

	return (pVapManagerReq->psMsg);
}

static void addVapSmHandleAddVapAtInit(K_MSG* pAddRemoveVapMsg)
{
	uint8 vapId; 
	BandId_e band;
	CdbManagerAddVapSmDb_t* pAddVapSmDb = &HdkCdbManagerDb.addVapSm;
	K_MSG* pAddVapMsg;

	pAddVapMsg = extractAddRemoveVapMsgFromBssManMsg(pAddRemoveVapMsg);
	vapId = pAddRemoveVapMsg->header.vapId;
	band = getBandForVap(vapId);
	ASSERT(band < NUM_OF_CONFIGURATION_MANAGER_BANDS); // KW_FIX_FW_G Range Check

	/*Store add vap message per band*/
	pAddVapSmDb->pAddVapMsgStored[band] = pAddVapMsg; 
	pAddVapSmDb->vapAddedCounter[band]++;
	CDB_MAN_SET_BIT_IN_BYTE(band, pAddVapSmDb->bandInProecessBitmap);
	/*Call Hdk configuration SM for RF init sequence*/
	sendAddVapCommonConfigMsg(band);
}

BandId_e getBandForVap(uint8 vapId)
{
    BandId_e band;
    
    band = ConfigurationManager_GetBandForVap(vapId);

    return band;
}


