/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "HdkCdbManagerTask.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 0




/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

static void configAntsSmHandlerPrepareChangeEvent(K_MSG* pMsg);
static void configAntsSmHandlerSetAntEvent(K_MSG* pMsg);
static void configAntsSmChangeState(HdkCdbManagerConfigAntsSmStates_e state);
void HdkCdbManagerSetAfeCalEfuseData(K_MSG * psMsg);
uint8* HdkCdbManagerGetAfeCalEfuseData(void);

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
HdkCdbManagerEventTypeTable_t HdkCdbManagerAntConfigSmEventModeTable = 
{
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE*/
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_INIT*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_READY*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
};

uint8 afeCalEfuseData[AFE_CALIBRATION_DATA_SIZE_GEN6] = {0};

void HdkCdbManagerSetAfeCalEfuseData(K_MSG * psMsg)
{	
	afe_calibration_data_t* params;
	uint8 index;

	params = (afe_calibration_data_t*)pK_MSG_DATA(psMsg);
	for (index = 0; index < AFE_CALIBRATION_DATA_SIZE_GEN6; index++)
	{
		afeCalEfuseData[index] = params->calibrationData[index];
	}
}

uint8* HdkCdbManagerGetAfeCalEfuseData(void)
{	
	return afeCalEfuseData;
}

void HdkCdbManagerAntConfigSmPrepareChangeReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_PREPARE_CHANGE, CONFIG_ANTS_SM_EVENT_PREPARE_CHANGE);
}
void HdkCdbManagerAntConfigSmPrepareChangeDone(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_PROCESS_SCHED, CONFIG_ANTS_SM_EVENT_PROCESS_SCHED);
}

void HdkCdbManagerAntConfigSmSetAfeCalData(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_SET_AFE_CAL_DATA, CONFIG_ANTS_SM_EVENT_SET_AFE_CAL_DATA);
}
void HdkCdbManagerAntConfigSmSetRssiCalData(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_SET_RSSI_CAL_DATA, CONFIG_ANTS_SM_EVENT_SET_RSSI_CAL_DATA);
}
void HdkCdbManagerAntConfigSmSetAntReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_SET_ANTS, CONFIG_ANTS_SM_EVENT_SET_ANTS);
}
void HdkCdbManagerAntConfigSmSetAntCfm(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ANT_CONFIG_SM, CONFIG_ANTS_SM_EVENT_SET_ANTS_DONE, CONFIG_ANTS_SM_EVENT_SET_ANTS_DONE);
}
/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
void HdkCdbManagerAntConfigSm(uint8 eventGeneralType, K_MSG* pMsg)
{
	CdbManagerConfigAntsSmDb_t* pconfigAntsSmDb = &HdkCdbManagerDb.configAntsSmDb;
	HdkCdbManager_ConfigAntsSmEvents_e event = (HdkCdbManager_ConfigAntsSmEvents_e)eventGeneralType;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;

	switch (pconfigAntsSmDb->state)
	{
 		case CONFIG_ANTS_SM_STATE_IDLE:
		{
			switch (event)
			{
				case CONFIG_ANTS_SM_EVENT_PREPARE_CHANGE:
					configAntsSmHandlerPrepareChangeEvent(pMsg);
					configAntsSmChangeState(CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_SCHED);
					break;
#if !defined (HDK_REL_2_0)	
				case CONFIG_ANTS_SM_EVENT_SET_AFE_CAL_DATA:
					/*Forward message to LM*/
					HdkCdbManagerSetAfeCalEfuseData(pMsg);
					OSAL_SEND_MESSAGE(HDK_AFE_SET_CALIBRATION_DATA, TASK_HDK,pMsg,pMsg->header.vapId); 
					break;
				case CONFIG_ANTS_SM_EVENT_SET_RSSI_CAL_DATA:
					/*Forward message to LM*/
					OSAL_SEND_MESSAGE(HDK_RSSI_CALIBRATION_DATA, TASK_HDK,pMsg,pMsg->header.vapId); 
					break;
#endif
				case CONFIG_ANTS_SM_EVENT_SET_ANTS:
#ifdef HDK_CDB_PARTIAL_DRIVER_SUPPORT_PATCH
					/*Patch for driver wrong implemenation - in current driver implemenation this message is sent twice (for two bands) instead of once when the first band goes up as deinfed!
					(It will be changed in the future) - 
					in order to support this we handling only the first VAP and confirmed the others*/
					if ((HdkCdbManagerDb.addVapSm.vapAddedCounter[CONFIGURATION_MANAGER_BAND_0] == 0) &&
						(HdkCdbManagerDb.addVapSm.vapAddedCounter[CONFIGURATION_MANAGER_BAND_1] == 0))
					{
#endif
						/*In boot seuqnce set antenna is done here without setting proceess*/
						configAntsSmHandlerSetAntEvent(pMsg);
						configAntsSmChangeState(CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_END);
#ifdef HDK_CDB_PARTIAL_DRIVER_SUPPORT_PATCH
					}
					else
					{
						OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_ANT_CONFIG_CFM, TASK_UM_IF_TASK,pMsg,pMsg->header.vapId); 
					}
#endif
					break;

				default:
					ASSERT(0);
			}
			break;
 		}
 		case CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_SCHED:
		{
			switch (event)
			{
				case CONFIG_ANTS_SM_EVENT_PROCESS_SCHED:
					pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pMsg);
					/*Send confirmation to driver*/
					OSAL_SEND_MESSAGE(UMI_MC_MAN_PREPARE_ANT_CONFIG_CFM, TASK_UM_IF_TASK,pConfigSmParams->hostMsgAddress,pMsg->header.vapId); 
					configAntsSmChangeState(CONFIG_ANTS_SM_STATE_SETTING_CONFIGURATION);
					break;
				default:
					ASSERT(0);
			}
			break;
 		}
		case CONFIG_ANTS_SM_STATE_SETTING_CONFIGURATION:
		{
			switch (event)
			{
#if !defined (HDK_REL_2_0)	

				case CONFIG_ANTS_SM_EVENT_SET_AFE_CAL_DATA:
					/*Forward message to LM*/
					OSAL_SEND_MESSAGE(HDK_AFE_SET_CALIBRATION_DATA, TASK_HDK,pMsg,pMsg->header.vapId); 
					break;
				case CONFIG_ANTS_SM_EVENT_SET_RSSI_CAL_DATA:
					/*Forward message to LM*/
					OSAL_SEND_MESSAGE(HDK_RSSI_CALIBRATION_DATA, TASK_HDK,pMsg,pMsg->header.vapId); 
					break;
#endif
				case CONFIG_ANTS_SM_EVENT_SET_ANTS:
					configAntsSmHandlerSetAntEvent(pMsg);
					configAntsSmChangeState(CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_END);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case CONFIG_ANTS_SM_STATE_WAIT_FOR_PROCESS_END:
		{
			switch (event)
			{
				case CONFIG_ANTS_SM_EVENT_SET_ANTS_DONE:
					pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pMsg);
					/*Send confirmation to driver*/
					OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_ANT_CONFIG_CFM, TASK_UM_IF_TASK,pConfigSmParams->hostMsgAddress,pMsg->header.vapId); 
					configAntsSmChangeState(CONFIG_ANTS_SM_STATE_IDLE);
					break;		
  				default:
					ASSERT(0);
			}
			break;
		}
		default:
			ASSERT(0);
			break;
	}	
}

static void configAntsSmChangeState(HdkCdbManagerConfigAntsSmStates_e state)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("HdkCdbManager_ConfigSmChangeState, state = %d", state);
#endif	
	HdkCdbManagerDb.configAntsSmDb.state = state;
}
static void configAntsSmHandlerPrepareChangeEvent(K_MSG* pMsg)
{
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	
	/*Send message to configuration SM to set process and disable all ants*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_PREPARE_ANT_CONFIG_DONE;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 1;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_SET_PROCESS_AND_DISABLE_ALL_ANTS_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->hostMsgAddress = pMsg;
	pConfigSmParams->configureVapId = pMsg->header.vapId;
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,pMsg->header.vapId); 
}
static void configAntsSmHandlerSetAntEvent(K_MSG* pMsg)
{
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	
	/*Send message to configuration SM to set add vap common configuration in bands*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_SET_ANT_CONFIG_DONE;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 1;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_SET_ANT_CONFIG_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = CONFIGURATION_MANAGER_BAND_0;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = CONFIGURATION_MANAGER_BAND_0;

	pConfigSmParams->hostMsgAddress = pMsg;
	pConfigSmParams->configureVapId = pMsg->header.vapId;
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,pMsg->header.vapId); 
}

