/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "HdkCdbManagerTask.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 2




/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

static void configSmSendMsgToBand (CdbManagerConfigSmDb_t* pConfigSmDb, BandId_e band, K_MSG_TYPE reqMsg,K_TASKID taskId, K_MSG_TYPE retMsg, uint8* pWaitForBandRspBitmap);
static void configSmChangeState(HdkCdbManagerConfigSmStates_e state);
static void sendConfigMessageToBands(CdbManagerConfigSmDb_t* pConfigSmDb, bool isDualBand);
static bool incrementStageCounter(CdbManagerConfigSmDb_t* pConfigSmDb, bool isDualBand);
static bool checkIfLastStage(CdbManagerConfigSmDb_t* pConfigSmDb);
static void configSmSendReqDoneMsgToRequester(void);
static BandId_e extractBandFromConfigSmMsg(K_MSG* pConfigSmMsg);

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
HdkCdbManagerEventTypeTable_t HdkCdbManagerConfigSmEventModeTable = 
{
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE*/
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_INIT*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_READY*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
};
void HdkCdbManager_ConfigSmConfigurationReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_CONFIG_SM, CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_REQ, CONFIG_SM_EVENT_SET_CONFIGURATION_REQ);
}

void HdkCdbManager_ConfigSmConfigurationCfm(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_CONFIG_SM, CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_CFM, CONFIG_SM_EVENT_SET_CONFIGURATION_CFM);
}
/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
void HdkCdbManagerConfigSm(uint8 eventGeneralType, K_MSG* pMsg)
{
	HdkCdbManagerConfigMsg_t* pRecivedMsgParams = (HdkCdbManagerConfigMsg_t*) pK_MSG_DATA(pMsg);
	CdbManagerConfigSmDb_t* pconfigSmDb = &HdkCdbManagerDb.configSmDb;
	bool sequenceEnd;
	HdkCdbManager_ConfigSmEvents_e event = (HdkCdbManager_ConfigSmEvents_e)eventGeneralType;
	BandId_e configuredBand;
	
	switch (pconfigSmDb->state)
	{
 		case CONFIG_SM_STATE_IDLE:
		{
			switch (event)
			{
				case CONFIG_SM_EVENT_SET_CONFIGURATION_REQ:
					
					/*Save configuration request message parameters*/
					MEMCPY(&pconfigSmDb->msgReqParams,pRecivedMsgParams, sizeof(HdkCdbManagerConfigMsg_t));
					sendConfigMessageToBands(pconfigSmDb, TRUE);
					/*Change state*/
					configSmChangeState(CONFIG_SM_STATE_CONFIG_STAGE_START);
					break;
					
				case CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_REQ:
					MEMCPY(&pconfigSmDb->msgReqParams,pRecivedMsgParams, sizeof(HdkCdbManagerConfigMsg_t));
					sendConfigMessageToBands(pconfigSmDb, FALSE);
					/*Change state*/
					configSmChangeState(CONFIG_SM_STATE_CONFIG_STAGE_START);
					break;
				default:
					ASSERT(0);
			}
			break;
 		}
 		case CONFIG_SM_STATE_CONFIG_STAGE_START:
		{
			switch (event)
			{
				case CONFIG_SM_EVENT_SET_CONFIGURATION_CFM:
					
					configuredBand = extractBandFromConfigSmMsg(pMsg);
					CdbManagerHandleReceivedMsgFromBand(&pconfigSmDb->waitForBandRspBitmap,configuredBand);
					if (pconfigSmDb->waitForBandRspBitmap == 0)
					{
						sequenceEnd = incrementStageCounter(pconfigSmDb, TRUE);
						if (sequenceEnd == FALSE)
						{
							sendConfigMessageToBands(pconfigSmDb, TRUE);
						}
					}
					else
					{
						/*Change state*/
						configSmChangeState(CONFIG_SM_STATE_WAIT_FOR_SEC_BAND_CFM);
					}
					break;
					
				case CONFIG_SM_EVENT_SET_CONFIGURATION_SINGLE_BAND_CFM:
					configuredBand = extractBandFromConfigSmMsg(pMsg);
					CdbManagerHandleReceivedMsgFromBand(&pconfigSmDb->waitForBandRspBitmap,configuredBand);
					ASSERT(pconfigSmDb->waitForBandRspBitmap == 0);
					sequenceEnd = incrementStageCounter(pconfigSmDb, FALSE);
					if (sequenceEnd == FALSE)
					{
						sendConfigMessageToBands(pconfigSmDb,FALSE);
					}
					break;
				default:
					ASSERT(0);
			}
			break;
 		}
#ifdef HDK_CDB_SUPPORT
		case CONFIG_SM_STATE_WAIT_FOR_SEC_BAND_CFM:
		{
			switch (event)
			{
				case CONFIG_SM_EVENT_SET_CONFIGURATION_CFM:
					configuredBand = extractBandFromConfigSmMsg(pMsg);
					CdbManagerHandleReceivedMsgFromBand(&pconfigSmDb->waitForBandRspBitmap,configuredBand);

					if (pconfigSmDb->waitForBandRspBitmap == 0)
					{
						sequenceEnd = incrementStageCounter(pconfigSmDb, TRUE);

						if (sequenceEnd == FALSE)
						{
							sendConfigMessageToBands(pconfigSmDb,TRUE);
							/*Change state*/
							configSmChangeState(CONFIG_SM_STATE_CONFIG_STAGE_START);
						}
					}
					break;
				default:
					ASSERT(0);
			}
			break;
 		}
#endif

		default:
			ASSERT(0);
			break;
	}	
}

static void configSmChangeState(HdkCdbManagerConfigSmStates_e state)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("HdkCdbManager_ConfigSmChangeState, state = %d", state);
#endif	
	HdkCdbManagerDb.configSmDb.state = state;
}

static void configSmSendMsgToBand (CdbManagerConfigSmDb_t* pConfigSmDb, BandId_e band, K_MSG_TYPE reqMsg,K_TASKID taskId, K_MSG_TYPE retMsg, uint8* pWaitForBandRspBitmap)
{
	BandId_e bandInProcess;
	K_MSG *pMsgToBand;
	HdkCdbManagerConfigBandReq_t* pHdkCdbManagerConfigReq;

	if (reqMsg != HDK_CDB_MAN_INVALID_MSG)
	{
		bandInProcess = band;
		/*Set band control*/
		CDB_MAN_SET_BIT_IN_BYTE(bandInProcess, *pWaitForBandRspBitmap);
		/*Send band configration request to LM*/
		pMsgToBand = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigBandReq_t));
		pHdkCdbManagerConfigReq = (HdkCdbManagerConfigBandReq_t *)pK_MSG_DATA(pMsgToBand);
		pHdkCdbManagerConfigReq->retMsg = retMsg;
		pHdkCdbManagerConfigReq->retTask = TASK_HDK_CDB_MANAGER;
		pHdkCdbManagerConfigReq->requesterKmsg = pConfigSmDb->msgReqParams.hostMsgAddress;
		pHdkCdbManagerConfigReq->param = pConfigSmDb->msgReqParams.param;

		OSAL_SEND_MESSAGE(reqMsg, taskId, pMsgToBand, ConfigurationManager_GetFirstVapForBand(bandInProcess)); 
	}
}
static void sendConfigMessageToBands(CdbManagerConfigSmDb_t* pConfigSmDb, bool isDualBand)
{
	BandId_e requiredBand;
	BandId_e otherBand;
	uint8 stageCounter = pConfigSmDb->stageCounter;
	K_MSG_TYPE messageToBand = pConfigSmDb->msgReqParams.stageDb[stageCounter].message;
	K_TASKID taskId = pConfigSmDb->msgReqParams.stageDb[stageCounter].task;
	/*Send pre configuration request to first band*/
	/*Set band control*/
	requiredBand = pConfigSmDb->msgReqParams.stageDb[stageCounter].band;
	/*Send pre configuration request to both bands*/
	configSmSendMsgToBand(pConfigSmDb,requiredBand,messageToBand,taskId ,HDK_CDB_MAN_CONFIG_SM_CONFIG_CFM,&pConfigSmDb->waitForBandRspBitmap);
	if ((isDualBand == TRUE)&&(pConfigSmDb->msgReqParams.stageDb[stageCounter].isDualBandMessgae == TRUE))
	{
		otherBand = GET_OTHER_BAND(requiredBand);
		configSmSendMsgToBand(pConfigSmDb,otherBand,messageToBand, taskId, HDK_CDB_MAN_CONFIG_SM_CONFIG_CFM,&pConfigSmDb->waitForBandRspBitmap);
	}
}
static bool incrementStageCounter(CdbManagerConfigSmDb_t* pConfigSmDb, bool isDualBand)
{
	bool sequenceEnd = FALSE;

	pConfigSmDb->stageCounter++;
	sequenceEnd = checkIfLastStage(pConfigSmDb);

	if ((sequenceEnd == FALSE) && 
		(isDualBand == FALSE) && 
		(pConfigSmDb->msgReqParams.stageDb[pConfigSmDb->stageCounter].band == CONFIGURATION_MANAGER_BAND_1))
	{
		/*If single band and band == CONFIGURATION_MANAGER_BAND_1, skip for next stage*/
		pConfigSmDb->stageCounter++;
		checkIfLastStage(pConfigSmDb);
	}
	
	return sequenceEnd;
}
static bool checkIfLastStage(CdbManagerConfigSmDb_t* pConfigSmDb)
{
	bool sequenceEnd =FALSE;
	
	if (pConfigSmDb->stageCounter >= (pConfigSmDb->msgReqParams.numberOfStages))
	{
		/*Send message to requester task*/
		configSmSendReqDoneMsgToRequester();
		configSmChangeState(CONFIG_SM_STATE_IDLE);
		pConfigSmDb->stageCounter = 0;
		sequenceEnd = TRUE;
	}
	return sequenceEnd;
}
static void configSmSendReqDoneMsgToRequester(void)
{
	K_MSG *pMsgToRequester;
	HdkCdbManagerConfigMsg_t* pMsgDoneParams;
	HdkCdbManagerConfigMsg_t* pRequesterMsgParams = &HdkCdbManagerDb.configSmDb.msgReqParams;
	
	pMsgToRequester = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pMsgDoneParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pMsgToRequester);
	MEMCPY(pMsgDoneParams, pRequesterMsgParams, sizeof(HdkCdbManagerConfigMsg_t));

	/*Send callback message to requester*/
	OSAL_SEND_MESSAGE(pMsgDoneParams->cbMessage, pMsgDoneParams->cbTask, pMsgToRequester, pRequesterMsgParams->cbVapId); 
}
static BandId_e extractBandFromConfigSmMsg(K_MSG* pConfigSmMsg)
{
	BandId_e band = ConfigurationManager_GetBandForVap(pConfigSmMsg->header.vapId);
	
	return band;
}
