/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "HdkCdbManagerTask.h"
#include "HdkCdbManagerTask_api.h"
#include "loggerAPI.h"



#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 4




/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void offlineSmSendMsgToBand(BandId_e band, K_MSG_TYPE reqMsgType, K_MSG_TYPE retMsgType);
static void offlineCalSmChangeState(HdkCdbManagerOfflineCalStates_e state);
#ifdef HDK_CDB_SUPPORT
static void offlineCalSmHandlerSetMaxAntEvent(BandId_e band);
static void offlineCalSmHandlerResumeAntConfigInBands(BandId_e band);
#endif

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/


HdkCdbManagerEventTypeTable_t HdkCdbManagerOfflineCalEventModeTable = 
{
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE*/
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_INIT*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_READY*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
};

void HdkCdbManager_SmHandlerRunOfflnieCalReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION_SINGLE_BAND, OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION);
}

void HdkCdbManager_SmHandlerOfflineCalFinishedOnOneCh(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH,OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH);
}
void HdkCdbManager_SmHandlerOfflineCalFinishedOnLastCh(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH_SINGLE_BAND,OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH);
}
void HdkCdbManager_SmHandlerPauseDone(K_MSG* pMsg)
{
	/*This event handling always as dual band message it shouldn't be sent in single band CDB mode*/
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_NON_CALIBRATING_BAND_PAUSE_DONE, OFFLINE_CAL_SM_EVENT_NON_CALIBRATING_BAND_PAUSE_DONE);
}
void HdkCdbManager_SmHandlerResumeDone(K_MSG* pMsg)
{
	/*This event handling always as dual band message it shouldn't be sent in single band CDB mode*/
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_RESUME_NON_CALIBRATING_BAND_DONE, OFFLINE_CAL_SM_EVENT_RESUME_NON_CALIBRATING_BAND_DONE);
}
void HdkCdbManager_SmHandlerChangeToMaxAntsDone(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_CHANGE_TO_MAX_ANTS_DONE, OFFLINE_CAL_SM_EVENT_CHANGE_TO_MAX_ANTS_DONE);
}
void HdkCdbManager_SmHandlerResumeCalibratingBandCfm(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_CFM, OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_CFM);
}
void HdkCdbManager_SmHandlerResumeCalibratingBandDone(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_OFFLINE_CAL_SM, OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE_SINGLE_BAND, OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE);
}




/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
void HdkCdbManagerOfflineCalSm(uint8 eventGeneralType, K_MSG* pmsg)
{
#ifdef HDK_CDB_SUPPORT
	BandId_e otherBand;
#endif
	HdkCdbManagerOfflineCalSmMsg_t* pOfflineCalMsg;
	HdkCdbManagerOfflineCalEvents_e event = (HdkCdbManagerOfflineCalEvents_e)eventGeneralType;
	pOfflineCalMsg = (HdkCdbManagerOfflineCalSmMsg_t*)pK_MSG_DATA(pmsg);
		
	switch (HdkCdbManagerDb.offlineCalSmDb.state)
	{
 		case OFFLINE_CAL_SM_STATE_IDLE:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION:
					/*Schedule pause in other band*/
					HdkCdbManagerDb.offlineCalSmDb.requester = pOfflineCalMsg->requester;
					HdkCdbManagerDb.offlineCalSmDb.calibratingBand = pOfflineCalMsg->band;
					HdkCdbManagerDb.offlineCalSmDb.hostMsg = pOfflineCalMsg->requesterKmsgPtr;
					HdkCdbManagerDb.offlineCalSmDb.calCdbType = pOfflineCalMsg->dualBandOfflineCalType;
					otherBand = GET_OTHER_BAND(HdkCdbManagerDb.offlineCalSmDb.calibratingBand);
					offlineSmSendMsgToBand(otherBand, HDK_PAUSE_NON_CALIBRATING_BAND_REQ, HDK_CDB_MAN_NON_CALIBRATING_BAND_PAUSE_DONE);
					offlineCalSmChangeState(OFFLLINE_CAL_SM_STATE_WAIT_FOR_NON_CALIBRATING_BAND_PAUSE_DONE);
					break;
#endif
				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION_SINGLE_BAND:
					HdkCdbManagerDb.offlineCalSmDb.requester = pOfflineCalMsg->requester;
					HdkCdbManagerDb.offlineCalSmDb.calibratingBand = pOfflineCalMsg->band;
					HdkCdbManagerDb.offlineCalSmDb.hostMsg = pOfflineCalMsg->requesterKmsgPtr;
					HdkCdbManagerDb.offlineCalSmDb.calCdbType = pOfflineCalMsg->dualBandOfflineCalType;

					if(HdkCdbManagerDb.offlineCalSmDb.requester == OFFLINE_CAL_CALIBRATE_REQUESTER)
					{
						/*in single band there is no need to set max antennas hust go to OFLLINE_CAL_SM_WAIT_FOR_CALIBRATION_REQ_FROM_BAND*/
						//offlineCalSmHandlerSetMaxAntEvent(HdkCdbManagerDb.offlineCalSmDb.calibratingBand);
						offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_ON_FIRST_CHANNEL_REQ, HDK_CDB_MAN_INVALID_MSG);
						offlineCalSmChangeState(OFLLINE_CAL_SM_WAIT_FOR_CALIBRATION_REQ_FROM_BAND);
					}
					else
					{
						offlineSmSendMsgToBand(pOfflineCalMsg->band, HDK_RUN_OFFLINE_CALIBRATION_REQ, HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH);
						offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING);
					}

					break;
				default:
					ASSERT(0);
			}
			break;
 		}
#ifdef HDK_CDB_SUPPORT
		case OFFLLINE_CAL_SM_STATE_WAIT_FOR_NON_CALIBRATING_BAND_PAUSE_DONE:
		{
			switch (event)
			{
				case OFFLINE_CAL_SM_EVENT_NON_CALIBRATING_BAND_PAUSE_DONE:
					if(HdkCdbManagerDb.offlineCalSmDb.requester == OFFLINE_CAL_CALIBRATE_REQUESTER)
					{
						offlineCalSmHandlerSetMaxAntEvent(HdkCdbManagerDb.offlineCalSmDb.calibratingBand);
						offlineCalSmChangeState(OFFLLINE_CAL_SM_STATE_CHANGING_TO_MAX_ANT_CONFIG);
					}
					else
					{
						offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_REQ, HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH);
						offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING);
					}
					break;
				default:
					ASSERT(0);
			}
			break;
		}
#endif
		case OFFLLINE_CAL_SM_STATE_CHANGING_TO_MAX_ANT_CONFIG:
		{
			switch (event)
			{
				case OFFLINE_CAL_SM_EVENT_CHANGE_TO_MAX_ANTS_DONE:
						offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_ON_FIRST_CHANNEL_REQ, HDK_CDB_MAN_INVALID_MSG);
						offlineCalSmChangeState(OFLLINE_CAL_SM_WAIT_FOR_CALIBRATION_REQ_FROM_BAND);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case OFLLINE_CAL_SM_WAIT_FOR_CALIBRATION_REQ_FROM_BAND:
		{
			switch (event)
			{
 				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION:
				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION_SINGLE_BAND:
					ASSERT(pOfflineCalMsg->requester == OFFLINE_CAL_CALIBRATE_REQUESTER); // in this state only OFFLINE_CAL_CALIBRATE_REQUESTER should sent this event
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_REQ, HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH);
					offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING);
					break;
 				default:
					ASSERT(0);
			}
			break;
		}

		case OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING:
		{
			switch (event)
			{
 				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION:
				case OFFLINE_CAL_SM_EVENT_RUN_OFFLINE_CALIBRATION_SINGLE_BAND:
					ASSERT(pOfflineCalMsg->requester == OFFLINE_CAL_CALIBRATE_REQUESTER); // in this state only OFFLINE_CAL_CALIBRATE_REQUESTER should sent this event
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_REQ, HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH);
					offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_RUNNNING);
					break;
				case OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH:
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RUN_OFFLINE_CALIBRATION_ON_NEXT_CHANNEL_REQ, HDK_CDB_MAN_INVALID_MSG);
					break;
#ifdef HDK_CDB_SUPPORT
				case OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH:
					if(HdkCdbManagerDb.offlineCalSmDb.requester != OFFLINE_CAL_CALIBRATE_REQUESTER)
					{
						otherBand = GET_OTHER_BAND(pOfflineCalMsg->band);
						offlineSmSendMsgToBand(otherBand, HDK_RESUME_NON_CALIBRATING_BAND_REQ, HDK_CDB_MAN_NON_CALIBRATING_BAND_RESUME_DONE);
						offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_FINISHED);
  					}

					else
					{
 						offlineCalSmHandlerResumeAntConfigInBands(HdkCdbManagerDb.offlineCalSmDb.calibratingBand);
					}
					break;
#endif
				case OFFLINE_CAL_SM_EVENT_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH_SINGLE_BAND:
					if(HdkCdbManagerDb.offlineCalSmDb.requester != OFFLINE_CAL_CALIBRATE_REQUESTER)
					{
 						offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_FINISH_OFFLINE_CALIBRATION_REQ, TASK_HDK_CDB_MAN_END);
						offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_IDLE);
					}

					else
					{
						offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RESUME_CALIBRATING_BAND_REQ, HDK_CDB_MAN_INVALID_MSG);
						offlineCalSmChangeState(OFFLLINE_CAL_SM_WAIT_FOR_RESUME_CALIBRATING_BAND);
					}
					break;
 				case OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_CFM:
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_RESUME_CALIBRATING_BAND_REQ, HDK_CDB_MAN_INVALID_MSG);
					offlineCalSmChangeState(OFFLLINE_CAL_SM_WAIT_FOR_RESUME_CALIBRATING_BAND);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case OFFLLINE_CAL_SM_WAIT_FOR_RESUME_CALIBRATING_BAND:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE:
					/*Resume none calibrating band*/
					offlineSmSendMsgToBand(GET_OTHER_BAND(HdkCdbManagerDb.offlineCalSmDb.calibratingBand), HDK_RESUME_NON_CALIBRATING_BAND_REQ, HDK_CDB_MAN_NON_CALIBRATING_BAND_RESUME_DONE);
					offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_FINISHED);
					break;
#endif					
				case OFFLINE_CAL_SM_EVENT_RESUME_CALIBRATING_BAND_DONE_SINGLE_BAND:
					/*Return msg is invalid here - no msg should be return therefor ret message = TASK_HDK_CDB_MAN_END */
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_FINISH_OFFLINE_CALIBRATION_REQ, TASK_HDK_CDB_MAN_END);
					offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_IDLE);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
#ifdef HDK_CDB_SUPPORT
		case OFFLINE_CAL_SM_STATE_OFFLINE_CALIBRATION_FINISHED:
		{
			switch (event)
			{
				case OFFLINE_CAL_SM_EVENT_RESUME_NON_CALIBRATING_BAND_DONE:
					/*Resume calibrating band*/
					/*Return msg is invalid here - no msg should be return*/
					offlineSmSendMsgToBand(HdkCdbManagerDb.offlineCalSmDb.calibratingBand, HDK_FINISH_OFFLINE_CALIBRATION_REQ, TASK_HDK_CDB_MAN_END);
					offlineCalSmChangeState(OFFLINE_CAL_SM_STATE_IDLE);
					break;
				default:
					ASSERT(0);
			}
			break;
		}
#endif
	}
}


static void offlineSmSendMsgToBand(BandId_e band, K_MSG_TYPE reqMsgType, K_MSG_TYPE retMsgType)
{
	K_MSG* pMsgToBand;
	HdkCdbManagerOfflineCalSmMsg_t* pOfflineCalMsgtoBand;
	
	pMsgToBand = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerOfflineCalSmMsg_t));
	pOfflineCalMsgtoBand = (HdkCdbManagerOfflineCalSmMsg_t *)pK_MSG_DATA(pMsgToBand);
	pOfflineCalMsgtoBand->retMsg = retMsgType;
	pOfflineCalMsgtoBand->retTask = TASK_HDK_CDB_MANAGER;
	pOfflineCalMsgtoBand->band = band;
	pOfflineCalMsgtoBand->requester = HdkCdbManagerDb.offlineCalSmDb.requester;
	pOfflineCalMsgtoBand->dualBandOfflineCalType = DUAL_BAND_OFFLINE_CAL; //default value - depand also in CDB offline cal SM
	pOfflineCalMsgtoBand->requesterKmsgPtr = HdkCdbManagerDb.offlineCalSmDb.hostMsg;
	OSAL_SEND_MESSAGE(reqMsgType, TASK_HDK, pMsgToBand, ConfigurationManager_GetFirstVapForBand(band)); 
}
static void offlineCalSmChangeState(HdkCdbManagerOfflineCalStates_e state)
{
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("offlineCalSmChangeState, state = %d", state);
#endif	
	HdkCdbManagerDb.offlineCalSmDb.state = state;
}

#ifdef HDK_CDB_SUPPORT

static void offlineCalSmHandlerSetMaxAntEvent(BandId_e band)
{
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	/*Send message to configuration SM to set add vap common configuration in bands*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_SET_MAX_ANTS_CFM;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 2;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_DISABLE_ALL_ANTS_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = band;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_SET_MAX_ANTS_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = band;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = band;
	pConfigSmParams->hostMsgAddress = NULL;
	pConfigSmParams->configureVapId = ConfigurationManager_GetFirstVapForBand(band);
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,pConfigSmParams->configureVapId); 
}
static void offlineCalSmHandlerResumeAntConfigInBands(BandId_e band)
{
	K_MSG *pConfigSmMsg;
	HdkCdbManagerConfigMsg_t* pConfigSmParams;
	/*Send message to configuration SM to set add vap common configuration in bands*/
	pConfigSmMsg = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerConfigMsg_t));
	pConfigSmParams = (HdkCdbManagerConfigMsg_t *)pK_MSG_DATA(pConfigSmMsg);
	pConfigSmParams->cbMessage = HDK_CDB_MAN_RESUME_CALIBRATING_BAND_CFM;
	pConfigSmParams->cbTask = TASK_HDK_CDB_MANAGER;
	pConfigSmParams->cbVapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
	pConfigSmParams->numberOfStages = 1;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].message = HDK_SET_OPERATIONAL_ANT_CONFIG_REQ;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].isDualBandMessgae = TRUE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_0].band = band;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].message = HDK_CDB_MAN_INVALID_MSG;;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_1].band = band;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].message = HDK_CDB_MAN_INVALID_MSG;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].task = TASK_HDK;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].isDualBandMessgae = FALSE;
	pConfigSmParams->stageDb[CONFIG_SM_STAGE_2].band = band;
	pConfigSmParams->hostMsgAddress = NULL;
	pConfigSmParams->configureVapId = ConfigurationManager_GetFirstVapForBand(band);
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ, TASK_HDK_CDB_MANAGER,pConfigSmMsg,pConfigSmParams->configureVapId); 
}
#endif

