/***********************************************************************************
 File:			
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "Hdk_Api.h"
#include "HdkTask.h"
#include "kernel.h"
#include "stringLibApi.h"
#include "HdkCdbManagerTask.h"
#include "CtsManager_Api.h"
#include "loggerAPI.h"



#define LOG_LOCAL_GID   GLOBAL_GID_HDK_CDB_MANAGER
#define LOG_LOCAL_FID 3




/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void onlineCalSmHandleOnlineCalTimer(void);
static void enableDisableOnlineCal(K_MSG* pEnDisOnlineMsg);
static void calculateDelayTime(void);
static bool HdkCdbManager_SetOnlineCalTimingParams(void);
static void onlineCalSmSendMsgToBand(BandId_e band, K_MSG_TYPE reqMsgType,K_TASKID taskId, K_MSG_TYPE retMsgType, bool forceRunCal);
static void onlineCalSmChangeState(HdkCdbManagerOnlineCalStates_e state);
static BandId_e extractBandFromSyncServiceMsg(K_MSG* syncServiceMsg);
static BandId_e extractBandFromOnlineCalSmMsg(K_MSG* onlineCalSmMsg);
static BandId_e extractOnlineMsgParams(K_MSG* onlineCalSmMsg, bool* runImmediate, bool* processAbortBeforeRun);
static void setOnlineCalMode(void);


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
uint16 onlineTimerEventId;


HdkCdbManagerEventTypeTable_t HdkCdbManagerOnlineCalEventModeTable = 
{
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE*/
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_INVALID_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_INIT*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_READY*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_DUAL_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
	/*Current core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE*/
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_IDLE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_INIT
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_READY
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE
	HDK_CDB_MAN_SINGLE_BAND_EVENT, // other core state HDK_CDB_MAN_MAIN_SM_STATE_DISABLE
};


/*Online calibration messages handler*/
void HdkCdbManager_SmEnDisOnlineCalReq(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_EN_DIS_CAL, ONLINE_CAL_SM_EVENT_EN_DIS_CAL);
}

void HdkCdbManager_SmHandlerOnlineTimerExpired(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND, ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED);
}

void HdkCdbManager_SmHandlerOnlineProcessSchedInd(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND_SINGLE_BAND, ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND);
}
void HdkCdbManager_SmHandlerCtsSendInd(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_CTS2SELF_SENT_SINGLE_BAND, ONLINE_CAL_SM_EVENT_CTS2SELF_SENT);
}

void HdkCdbManager_SmHandlerOnlineCalibrationEnded(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND_SINGLE_BAND, ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND);
}


void HdkCdbManager_SmHandlerOnlineProcessEnded(K_MSG* pMsg)
{
	sendEventToSm(pMsg,HDK_CDB_MAN_ONLINE_CAL_SM, ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND, ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND);
}

void HdkCdbManagerOnlineCalSetMainState(BandId_e band, HdkCdbManagerMainSmBandState_e BandMainstate)
{
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
	if (pOnlineCalSmDb->state == ONLINE_CAL_SM_STATE_IDLE)
	{
		pOnlineCalSmDb->BandMainstate[band] = BandMainstate;
	}
}

void HdkCdbManagerOnlineCalSm(uint8 eventGeneralType, K_MSG* pMsg)
{
	BandId_e band;
	BandId_e otherBand;
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
	HdkCdbManagerOnlineCalEvents_e event = (HdkCdbManagerOnlineCalEvents_e)eventGeneralType;
	bool runImmediateCal;
	bool forceRunCal = FALSE;
	bool processAbortBeforeRun = FALSE;
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_DD("HdkCdbManagerOnlineCalSm. state %d event %d", pOnlineCalSmDb->state, event);
#endif
	switch (pOnlineCalSmDb->state)
	{
 		case ONLINE_CAL_SM_STATE_IDLE:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
					pOnlineCalSmDb->timingParams.onlineTimerActive = FALSE;
					if (checkIfVapsAreReadyForOnlineCal() == TRUE)
					{
						forceRunCal = HdkCdbManager_SetOnlineCalTimingParams();
						onlineCalSmSendMsgToBand(CONFIGURATION_MANAGER_BAND_0, HDK_SCHED_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_INVALID_MSG, forceRunCal);
						CDB_MAN_SET_BIT_IN_BYTE(CONFIGURATION_MANAGER_BAND_0, pOnlineCalSmDb->onlineCalibrationInProcessBitMap);
						onlineCalSmSendMsgToBand(CONFIGURATION_MANAGER_BAND_1, HDK_SCHED_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_INVALID_MSG, forceRunCal);
						CDB_MAN_SET_BIT_IN_BYTE(CONFIGURATION_MANAGER_BAND_1, pOnlineCalSmDb->onlineCalibrationInProcessBitMap);
						onlineCalSmChangeState(ONLINE_CAL_SM_STATE_WAIT_FOR_CALIBRATION_SCHEDULED);

					}
					break;
#endif
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND: 
					if (pOnlineCalSmDb->onlineCalibrationEnabledBitMap != 0)
					{
						band = CDB_IS_BIT_SET_IN_BYTE(CONFIGURATION_MANAGER_BAND_0, pOnlineCalSmDb->onlineCalibrationEnabledBitMap)?
								CONFIGURATION_MANAGER_BAND_0: CONFIGURATION_MANAGER_BAND_1;
						pOnlineCalSmDb->timingParams.onlineTimerActive = FALSE;
						if ((HdkCdbManagerDb.mainSmDb.state.bandState[band] == HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE) && (HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[band] == TRUE))
						{
							forceRunCal = HdkCdbManager_SetOnlineCalTimingParams();
							/*Perform online calibration only in active state*/
							CDB_MAN_SET_BIT_IN_BYTE(band, pOnlineCalSmDb->onlineCalibrationInProcessBitMap);
							onlineCalSmSendMsgToBand(band, HDK_SCHED_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_INVALID_MSG, forceRunCal);
							onlineCalSmChangeState(ONLINE_CAL_SM_STATE_WAIT_FOR_CALIBRATION_SCHEDULED);
						}
					}
					break;
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
					enableDisableOnlineCal(pMsg);
					extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					setOnlineCalMode(); //set single band / dual band mode according to next calibration
					/*After set channel, run online calibration immediatly without waiting for timer expired */
					if(runImmediateCal == TRUE)
					{
						HdkCdbManagerDb.onlineCalSmDb.runOnlineImmediate = TRUE;
						// Initialize Online schedule params after Set Channel
						HdkCdbManager_onlineSchedParamsInit();
						OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED, TASK_HDK_CDB_MANAGER, VAP_ID_DO_NOT_CARE);
					}
					else
					{
						onlineCalSmHandleOnlineCalTimer();
					}
					break;
				
				default:
					ASSERT(0);
			}
			break;
 		}
		case ONLINE_CAL_SM_STATE_WAIT_FOR_CALIBRATION_SCHEDULED:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND:
					/*Get process scheduled msg (sync service) from process manager - this event received before service ran*/
					band = extractBandFromOnlineCalSmMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					if(pOnlineCalSmDb->waitForBandRspBitmap == 0)
					{
						/*Process scheduled in two bands -> go to next state otherwize wait*/
						/*Send service res - > upon res received by process manager pre process (pause TX, send Cts2Self will start to run */
						onlineCalSmSendMsgToBand(GET_OTHER_BAND(band), PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
						if (pOnlineCalSmDb->calibrationMode == CDB_ONLINE_CAL_SERIAL_MODE)
						{
							onlineCalSmChangeState(ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_FIRST_BAND_SERIAL_MODE);
						}
						else //parallel mode
						{
							onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
							onlineCalSmChangeState(ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_PARALLEL_MODE);
						}
					}
					break;
				
#endif
				case ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_SCHEDULED_IN_BAND_SINGLE_BAND:
					band = extractBandFromOnlineCalSmMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
					/*In single band we alwyas work in serial mode but set state on sending cts 2 self second band*/
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_SECOND_BAND_SERIAL_MODE);
					break;
					
				case ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND: /*Online calibrtation aborted by HDK */
					SLOG0(0, 0, CdbManagerOnlineCalDb_t, pOnlineCalSmDb);
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					if(CDB_IS_BIT_SET_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap))
					{
						/*If one of the bands abort process change to single mode*/
						CDB_MAN_CLR_BIT_IN_BYTE(band, pOnlineCalSmDb->waitForBandRspBitmap);
						CDB_MAN_CLR_BIT_IN_BYTE(band, pOnlineCalSmDb->onlineCalibrationInProcessBitMap);
						HdkCdbManagerOnlineCalEventModeTable.HdkCdbManagerEventModeTable[HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE][HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE] = HDK_CDB_MAN_SINGLE_BAND_EVENT;
					}
					if(pOnlineCalSmDb->onlineCalibrationInProcessBitMap == 0) 

					{
						/*online cal aborted in two bands*/
						if((processAbortBeforeRun == TRUE) || (CDB_IS_BIT_SET_IN_BYTE(GET_OTHER_BAND(band),pOnlineCalSmDb->waitForBandRspBitmap) == FALSE))
						{
							/*Process abort by HDK before process req for all bands - arm timer and change to idle state*/
							onlineCalSmHandleOnlineCalTimer();
							onlineCalSmChangeState(ONLINE_CAL_SM_STATE_IDLE);
						}
						else //aborted after process reject
						{ /*Online process rejected by procee manager for two bands wait for ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND event*/
							onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED);// execuation finished already sent to PM
						}
					}
					else if(pOnlineCalSmDb->waitForBandRspBitmap == 0) 
					{
						/*First band process scheduled, second aborted, continue with other band in single mode*/
						otherBand = GET_OTHER_BAND(band);
						onlineCalSmSendMsgToBand(otherBand, PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
						/*In single band we alwyas work in serial mode*/
						onlineCalSmChangeState(ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_SECOND_BAND_SERIAL_MODE);
						
					}
					break;
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
						
				default:
					ASSERT(0);
			}
			break;
		}
#ifdef HDK_CDB_SUPPORT
		case ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_FIRST_BAND_SERIAL_MODE:
		{
			switch (event)
			{
				case ONLINE_CAL_SM_EVENT_CTS2SELF_SENT:
					/*Cts2Self sent from first band, continue with run calibration*/
					band = extractBandFromSyncServiceMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_FIRST_BAND_SERIAL_MODE);
					break;
				
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_FIRST_BAND_SERIAL_MODE:
		{
			switch (event)
			{
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND:
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					/*Trigger process manager to continue with pre process services in second band (pause TX, aend Cts2Self)*/
					onlineCalSmSendMsgToBand(GET_OTHER_BAND(band), PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_SECOND_BAND_SERIAL_MODE);
					break;
				
			case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
					/*Ignore this message here - it should be handled only when calibration is not running,
					for enable disable calibration and for setting first calibration after system goes up*/
				break;
			case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
			case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
				/*During online calibration process we should ignore timer expired event*/
				break;
			default:
				ASSERT(0);
			}
			break;
		}
#endif
		case ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_SECOND_BAND_SERIAL_MODE:
		{
			switch (event)
			{
				case ONLINE_CAL_SM_EVENT_CTS2SELF_SENT:
				case ONLINE_CAL_SM_EVENT_CTS2SELF_SENT_SINGLE_BAND:
					/*Cts2Self sent from second band, continue with run calibration*/
					band = extractBandFromOnlineCalSmMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_SECOND_BAND_SERIAL_MODE);
					break;
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		
		case ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_SECOND_BAND_SERIAL_MODE:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND:
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					ASSERT(pOnlineCalSmDb->waitForBandRspBitmap == 0);//Online calibration ended in two bands
					/*Send message to HdkBand to finish online calibration process in two bands*/
					onlineCalSmSendMsgToBand(band, HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);
					onlineCalSmSendMsgToBand(GET_OTHER_BAND(band), HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED);
					break;
#endif					
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND_SINGLE_BAND:
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					/*Send message to HdkBand to finish online calibration process in band*/
					onlineCalSmSendMsgToBand(band, HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED);
					break;
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);

			}
			break;
		}
		case ONLINE_CAL_SM_STATE_SENDING_CTS2SELF_PARALLEL_MODE:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case ONLINE_CAL_SM_EVENT_CTS2SELF_SENT:
					band = extractBandFromSyncServiceMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					if (pOnlineCalSmDb->waitForBandRspBitmap ==0) //Cts2Self sent in two bands=> send res to process manager and continue with calibrations
					{
						onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
						onlineCalSmSendMsgToBand(GET_OTHER_BAND(band), PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);		
						onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_PARALLEL_MODE);
					}
					break;
#endif				
				case ONLINE_CAL_SM_EVENT_CTS2SELF_SENT_SINGLE_BAND:
					band = extractBandFromSyncServiceMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					ASSERT(pOnlineCalSmDb->waitForBandRspBitmap == 0); //Cts2Self sent in band
					/*Send response to process manager and continue with calibrations*/
					onlineCalSmSendMsgToBand(band, PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES, TASK_PROCESS_MANAGER, HDK_CDB_MAN_INVALID_MSG,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_PARALLEL_MODE);
					break;
				
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		
		case ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_RUNNING_PARALLEL_MODE:
		{
			switch (event)
			{
#ifdef HDK_CDB_SUPPORT
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND:
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					if (pOnlineCalSmDb->waitForBandRspBitmap == 0) //Online calibration finished in two bands
					{
						/*Send message to HdkBand to finish calibration process*/
						onlineCalSmSendMsgToBand(band, HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);
						onlineCalSmSendMsgToBand(GET_OTHER_BAND(band), HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);		
						onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED);
					}
					break;
#endif
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_FINISHED_IN_BAND_SINGLE_BAND:
					band = extractOnlineMsgParams(pMsg, &runImmediateCal, &processAbortBeforeRun);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					ASSERT(pOnlineCalSmDb->waitForBandRspBitmap == 0); //Online ccalibration ended in band
					onlineCalSmSendMsgToBand(band, HDK_FINISH_ONLINE_CALIBRATION_REQ, TASK_HDK, HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,FALSE);
					onlineCalSmChangeState(ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED);
					break;
				
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL: 
						/*Ignore this message here - it should be handled only when calibration is not running,
						for enable disable calibration and for setting first calibration after system goes up*/
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		case ONLINE_CAL_SM_STATE_ONLINE_CALIBRATION_ENDED:
		{
			switch (event)
			{
				case ONLINE_CAL_SM_EVENT_ONLINE_PROCESS_FINISHED_IN_BAND:
					band = extractBandFromOnlineCalSmMsg(pMsg);
					CDB_MAN_CLR_BIT_IN_BYTE(band,pOnlineCalSmDb->waitForBandRspBitmap);
					CDB_MAN_CLR_BIT_IN_BYTE(band, pOnlineCalSmDb->onlineCalibrationInProcessBitMap);
					if (pOnlineCalSmDb->waitForBandRspBitmap == 0) //Msg received from all bands
					{
						onlineCalSmHandleOnlineCalTimer();
						onlineCalSmChangeState(ONLINE_CAL_SM_STATE_IDLE);
					}
					break;
				
				case ONLINE_CAL_SM_EVENT_EN_DIS_CAL:
					enableDisableOnlineCal(pMsg);
					break;
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED:
				case ONLINE_CAL_SM_EVENT_ONLINE_CALIBRATION_TIMER_EXPIRED_SINGLE_BAND:
					/*During online calibration process we should ignore timer expired event*/
					break;
				default:
					ASSERT(0);
			}
			break;
		}
		default:
			ASSERT(0);
	}
}
static void onlineCalSmSendMsgToBand(BandId_e band, K_MSG_TYPE reqMsgType,K_TASKID taskId, K_MSG_TYPE retMsgType, bool forceRunCal)
{
	K_MSG* pMsgToBand;
	HdkCdbManagerOnlineCalSmMsg_t* pOnlineCalSmMsg;

	CDB_MAN_SET_BIT_IN_BYTE(band, HdkCdbManagerDb.onlineCalSmDb.waitForBandRspBitmap);
	pMsgToBand = OSAL_GET_MESSAGE(sizeof(HdkCdbManagerOnlineCalSmMsg_t));
	pOnlineCalSmMsg = (HdkCdbManagerOnlineCalSmMsg_t *)pK_MSG_DATA(pMsgToBand);
	pOnlineCalSmMsg->band = band;
	pOnlineCalSmMsg->runForceCal = forceRunCal; // run frag with no temp dependent
	pOnlineCalSmMsg->retMsg = retMsgType;
	pOnlineCalSmMsg->retTask = TASK_HDK_CDB_MANAGER;
	pOnlineCalSmMsg->ctsDurMode = (HdkCdbManagerDb.onlineCalSmDb.calibrationMode == CDB_ONLINE_CAL_SERIAL_MODE) ?
									CTS2SELF_DURATION_MSEC_EXPANDED_MODE : CTS2SELF_DURATION_MSEC_NORMAL_MODE;
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_DD("onlineCalSmSendMsgToBand, reqMsgType = %d, band = %d", reqMsgType,band);
#endif	
	OSAL_SEND_MESSAGE(reqMsgType, taskId, pMsgToBand, ConfigurationManager_GetFirstVapForBand(band)); 
}
static void onlineCalSmChangeState(HdkCdbManagerOnlineCalStates_e state)
{
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
#ifdef HDK_CDB_DEBUG_LOGGER
	ILOG0_D("onlineCalSmChangeState, state = %d", state);
#endif	
	HdkCdbManagerDb.onlineCalSmDb.state = state;
	if(state == ONLINE_CAL_SM_STATE_IDLE)
	{
		/*Event mode can change during calibration to single mode, 
			when changing to idle state we should change it back to dual band mode*/
		HdkCdbManagerOnlineCalEventModeTable.HdkCdbManagerEventModeTable[HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE][HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE] = HDK_CDB_MAN_DUAL_BAND_EVENT;

		pOnlineCalSmDb->BandMainstate[CONFIGURATION_MANAGER_BAND_0] = HdkCdbManagerDb.mainSmDb.state.bandState[CONFIGURATION_MANAGER_BAND_0];
		pOnlineCalSmDb->BandMainstate[CONFIGURATION_MANAGER_BAND_1] = HdkCdbManagerDb.mainSmDb.state.bandState[CONFIGURATION_MANAGER_BAND_1];
		
	}
}
static BandId_e extractBandFromSyncServiceMsg(K_MSG* syncServiceMsg)
{
	HdkCdbManagerSyncServiceMsg_t* pSyncServiceMsgParams = (HdkCdbManagerSyncServiceMsg_t*)pK_MSG_DATA(syncServiceMsg);

	return (pSyncServiceMsgParams->band);
}
static BandId_e extractBandFromOnlineCalSmMsg(K_MSG* onlineCalSmMsg)
{
	HdkCdbManagerOnlineCalSmMsg_t* onlineCalSmMsgParams = (HdkCdbManagerOnlineCalSmMsg_t*)pK_MSG_DATA(onlineCalSmMsg);

	return (onlineCalSmMsgParams->band);
}
static BandId_e extractOnlineMsgParams(K_MSG* onlineCalSmMsg, bool* runImmediate, bool* processAbortBeforeRun)
{
	HdkCdbManagerOnlineCalSmMsg_t* onlineCalSmMsgParams = (HdkCdbManagerOnlineCalSmMsg_t*)pK_MSG_DATA(onlineCalSmMsg);
	BandId_e band = onlineCalSmMsgParams->band;
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
	ASSERT(band < HDK_NUM_OF_BANDS);

	pOnlineCalSmDb->moreFrags[band] = onlineCalSmMsgParams->moreFrags;
	pOnlineCalSmDb->wasCalibrated[band] = onlineCalSmMsgParams->wasCalibrated;
	pOnlineCalSmDb->nextCalibration[band] = onlineCalSmMsgParams->nextCalibration;
	*runImmediate = onlineCalSmMsgParams->runImmediateOnlineCal;
	*processAbortBeforeRun = onlineCalSmMsgParams->processAbortBeforeRun;

	return band;
}
static void setOnlineCalMode(void)
{
	/*set single band / dual band mode according to next calibration*/

	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;

	if ((pOnlineCalSmDb->nextCalibration[CONFIGURATION_MANAGER_BAND_0] == CLBR_PROC_TYPE_BEAM_FORMING) || 
		((pOnlineCalSmDb->nextCalibration[CONFIGURATION_MANAGER_BAND_1] == CLBR_PROC_TYPE_BEAM_FORMING)))
	{
		pOnlineCalSmDb->calibrationMode = CDB_ONLINE_CAL_SERIAL_MODE;
	}
	else
	{
		pOnlineCalSmDb->calibrationMode = CDB_ONLINE_CAL_PARALLEL_MODE;
	}
}
void HdkCdbManager_onlineSchedParamsInit(void)
{

	OnlineCalSM_TimingParams_t* pOnlineTimingParams = &HdkCdbManagerDb.onlineCalSmDb.timingParams;

	pOnlineTimingParams->timerValInFastMode = CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_FAST_MODE;
	pOnlineTimingParams->timerValInRegularMode = CLBRSCHEDSM_TIMER_VAL_BETWEEN_ONLINE_CALIB_IN_REGULAR_MODE;
	pOnlineTimingParams->delayAmountInRegularMode = CLBRSCHEDSM_NUMBER_OF_DELAYS_FOR_NEXT_CALIB_IN_REGULAR_MODE;
	pOnlineTimingParams->modeCount = CLBRSCHEDSM_ONLINE_CALIB_FAST_MODE_DELAYS;
	pOnlineTimingParams->delayCount      = 0;
    pOnlineTimingParams->delayTime       = 0;
    pOnlineTimingParams->calibModeCount  = 0;
    pOnlineTimingParams->delayAmount     = 0;
    pOnlineTimingParams->onlineTimerActive = FALSE;
	pOnlineTimingParams->m_onlineTimerValue = CLBRSCHEDSM_TIMER_VAL_AFTER_OFFLINE_ST;
}
void HdkCdbManager_onlineCalSmInit(void)
{
	HdkCdbManager_onlineSchedParamsInit();
}



/**********************************************************************************

ClbrMngr_StartOnlineCalibrationProcess 

Description:
------------
<Description of the purpose of the function>

Input:
-----
	K_MSG * in_psMsg
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/

static bool HdkCdbManager_SetOnlineCalTimingParams()
{
	bool forceRunCal = FALSE;
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
#ifdef HDK_CDB_SUPPORT
	BandId_e band;
#endif
#ifdef HDK_CDB_DEBUG_LOGGER
	SLOG0(0, 0, CdbManagerOnlineCalDb_t, &HdkCdbManagerDb.onlineCalSmDb);
#endif
	if ((((pOnlineCalSmDb->moreFrags[CONFIGURATION_MANAGER_BAND_0] ) & (CDB_IS_BIT_SET_IN_BYTE((CONFIGURATION_MANAGER_BAND_0),pOnlineCalSmDb->onlineCalibrationEnabledBitMap))) == FALSE) && 
	   (((pOnlineCalSmDb->moreFrags[CONFIGURATION_MANAGER_BAND_1] ) & (CDB_IS_BIT_SET_IN_BYTE(CONFIGURATION_MANAGER_BAND_1,pOnlineCalSmDb->onlineCalibrationEnabledBitMap))) == FALSE))
	{
#ifdef HDK_CDB_SUPPORT
			if (pOnlineCalSmDb->enabledBitmapOverride == TRUE)
			{
				pOnlineCalSmDb->enabledBitmapOverride = FALSE;
				CDB_MODIFY_BITS_IN_BITMAP(pOnlineCalSmDb->onlineCalibrationEnabledBitMap, CDB_MAN_MASK_ONE_BIT, pOnlineCalSmDb->origEnabledBand,pOnlineCalSmDb->origEnabledState);
			}
#endif
			if (pOnlineCalSmDb->runOnlineImmediate == FALSE)
			{
				calculateDelayTime();
			}		
			if ((pOnlineCalSmDb->timingParams.delayCount > pOnlineCalSmDb->timingParams.delayAmount) || (pOnlineCalSmDb->runOnlineImmediate == TRUE))
			{  
				pOnlineCalSmDb->runOnlineImmediate = FALSE;
				/* Time for a new calibration cycle */				
				pOnlineCalSmDb->timingParams.delayCount = 0;
				pOnlineCalSmDb->timingParams.m_onlineTimerValue = CLBRSCHEDSM_TIMER_VAL_DURING_ONLINE_CALIB;
				forceRunCal = TRUE;				
			}
			else
			{	
				/* wait for the next calibration session */
				pOnlineCalSmDb->timingParams.m_onlineTimerValue = pOnlineCalSmDb->timingParams.delayTime;
			}
	}
	else 
	{
#ifdef HDK_CDB_SUPPORT
		for (band = CONFIGURATION_MANAGER_BAND_0; band < HDK_NUM_OF_BANDS; band++)
		{
			if (pOnlineCalSmDb->moreFrags[band] == FALSE)
			{
				if (CDB_IS_BIT_SET_IN_BYTE(GET_OTHER_BAND(band),pOnlineCalSmDb->onlineCalibrationEnabledBitMap) == 1) 
				{
					/* one band has moreFrags == FALSE, other band is in Online Calibration enabled - disable the first one, and let the other one finish */
					pOnlineCalSmDb->enabledBitmapOverride = TRUE;
					pOnlineCalSmDb->origEnabledBand = band;
					pOnlineCalSmDb->origEnabledState = CDB_IS_BIT_SET_IN_BYTE(band, pOnlineCalSmDb->onlineCalibrationEnabledBitMap);
					CDB_MODIFY_BITS_IN_BITMAP(pOnlineCalSmDb->onlineCalibrationEnabledBitMap, CDB_MAN_MASK_ONE_BIT, band, FALSE);
				}
			}
		}
#endif
		/* In online calibration cycle */
		pOnlineCalSmDb->timingParams.m_onlineTimerValue = CLBRSCHEDSM_TIMER_VAL_DURING_ONLINE_CALIB;
		forceRunCal = TRUE;
	}
	return forceRunCal;
}
static void calculateDelayTime(void)
{
	OnlineCalSM_TimingParams_t* pOnlineTimingParams = &HdkCdbManagerDb.onlineCalSmDb.timingParams;

	 pOnlineTimingParams->delayCount++;
	 
    if (pOnlineTimingParams->calibModeCount >= pOnlineTimingParams->modeCount)
    {   //Regular calibration mode
        pOnlineTimingParams->delayAmount = pOnlineTimingParams->delayAmountInRegularMode;
        pOnlineTimingParams->delayTime = pOnlineTimingParams->timerValInRegularMode;
    }
    else
    {   //Fast calibration mode     
        pOnlineTimingParams->calibModeCount++;
        pOnlineTimingParams->delayAmount = CLBRSCHEDSM_NUMBER_OF_DELAYS_FOR_NEXT_CALIB_IN_FAST_MODE;
        pOnlineTimingParams->delayTime = pOnlineTimingParams->timerValInFastMode;
    }
}
static void onlineCalSmHandleOnlineCalTimer(void)
{
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;

	if (pOnlineCalSmDb->onlineCalibrationEnabledBitMap != 0)
	{
		if (pOnlineCalSmDb->timingParams.onlineTimerActive == FALSE)
		{
			pOnlineCalSmDb->timingParams.onlineTimerActive = TRUE;
			// Set online calibration timer 
#ifdef ENET_INC_UMAC
			OSAL_SET_TIMER_EXPLICIT(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED, OSAL_TIMERS_MS_TO_K_TICKS(pOnlineCalSmDb->timingParams.m_onlineTimerValue), TASK_HDK_CDB_MANAGER);
#else //ENET_INC_UMAC
			onlineTimerEventId = TimerUtiltyAddEvent(pOnlineCalSmDb->timingParams.m_onlineTimerValue,isr_HdkCdbManOnlineTimerExpired, 0);
#endif 
		}
	}
	else
	{
		if (pOnlineCalSmDb->timingParams.onlineTimerActive == TRUE)
		{
			// reSet online calibration timer
#ifdef ENET_INC_UMAC
			OSAL_RESET_TIMER_EXPLICIT(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED, TASK_HDK_CDB_MANAGER);
#else
			TimerUtiltyRemoveEvent(&onlineTimerEventId);
#endif
			pOnlineCalSmDb->timingParams.onlineTimerActive = FALSE;
		}
	}
}
static void enableDisableOnlineCal(K_MSG* pEnDisOnlineMsg)
{
	CdbManagerOnlineCalDb_t* pOnlineCalSmDb = &HdkCdbManagerDb.onlineCalSmDb;
	HdkCdbManagerOnlineCalSmMsg_t* onlineCalMsgParams = (HdkCdbManagerOnlineCalSmMsg_t*)pK_MSG_DATA(pEnDisOnlineMsg);
	BandId_e band = onlineCalMsgParams->band;

#ifdef HDK_CDB_SUPPORT
	if ((pOnlineCalSmDb->enabledBitmapOverride == TRUE) && (band == pOnlineCalSmDb->origEnabledBand) && (onlineCalMsgParams->enableDisableCal == TRUE))
	{
		pOnlineCalSmDb->origEnabledState = onlineCalMsgParams->enableDisableCal;
	}
	else
#endif
	{
		CDB_MODIFY_BITS_IN_BITMAP(pOnlineCalSmDb->onlineCalibrationEnabledBitMap, CDB_MAN_MASK_ONE_BIT, band,onlineCalMsgParams->enableDisableCal);
	}
	if (pOnlineCalSmDb->onlineCalibrationEnabledBitMap != 0)
	{
		if(pOnlineCalSmDb->onlineCalibrationEnabledBitMap == TWO_BANDS_ACTIVE_MASK)
		{
			/*Two bands active -> switch to dual band mode*/
			HdkCdbManagerOnlineCalEventModeTable.HdkCdbManagerEventModeTable[HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE][HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE] = HDK_CDB_MAN_DUAL_BAND_EVENT;
		}	
		else
		{
			/*Only one band active-> switch to single band mode*/
			HdkCdbManagerOnlineCalEventModeTable.HdkCdbManagerEventModeTable[HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE][HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE] = HDK_CDB_MAN_SINGLE_BAND_EVENT;
		}
	}
	
}
void  isr_HdkCdbManOnlineTimerExpired(uint32 param)
{
	UNUSED_PARAM(param);	
	onlineTimerEventId = MAX_UINT16;
	OSAL_SEND_NO_DATA_MESSAGE(HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED, TASK_HDK_CDB_MANAGER, VAP_ID_DO_NOT_CARE);	
}

bool checkIfVapsAreReadyForOnlineCal(void)
{
	bool vapsAreReady = FALSE;

	if (HdkCdbManagerDb.onlineCalSmDb.onlineCalibrationEnabledBitMap != 0)
	{
		if (HdkCdbManagerDb.mainSmDb.mode == HDK_CDB_DUAL_BAND)
		{
			vapsAreReady = (HdkCdbManagerDb.mainSmDb.state.bandState[0] == HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE) && (HdkCdbManagerDb.mainSmDb.state.bandState[1] == HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE) && (HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[0] == TRUE) && (HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[1] == TRUE);
		}
		else
		{
			vapsAreReady = (HdkCdbManagerDb.mainSmDb.state.bandState[0] == HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE) && (HdkCdbManagerDb.mainSmDb.state.postVapActivationDone[0] == TRUE);
		}
	}
	return vapsAreReady;
}
