/*
 * Afe.h
 *
 *  Created on: 23/03/2011
 *      Author: yahav
 */

#ifndef AFE_H_
#define AFE_H_
#include "AFEDefines.h"
//AFE registers:
#define AFE_DYN_CTRL          0x00010104
#define AFE_PDN_CTRL          0x00010114
#define AFE_AUX_CTRL          0x0001011C

#define AFE_MIN_ADDRESS       AFE_DYN_CTRL
#define AFE_MAX_ADDRESS       AFE_AUX_CTRL
#define AFE_FCSI_MIN_ADDRESS  REG_AFE_L0_SSI_ADCREG0
#define AFE_FCSI_MAX_ADDRESS  REG_AFE_L28_AR10_BIAS_TRIM + 1


/*****************************************************************/
// AFE_DYN_CTRL: Controls the DACs/ADCs
/*****************************************************************/
#define AFE_DYN_RX0_ADC_STANDBY_MODE            0x00000001
#define AFE_DYN_RX0_ADC_STANDBY_MODE_MASK       0x00000001
#define AFE_DYN_RX0_ADC_STANDBY_MODE_BIT        0

#define AFE_DYN_RX1_ADC_STANDBY_MODE            0x00000002
#define AFE_DYN_RX1_ADC_STANDBY_MODE_MASK       0x00000002
#define AFE_DYN_RX1_ADC_STANDBY_MODE_BIT        1

#define AFE_DYN_RX2_ADC_STANDBY_MODE            0x00000004
#define AFE_DYN_RX2_ADC_STANDBY_MODE_MASK       0x00000004
#define AFE_DYN_RX2_ADC_STANDBY_MODE_BIT        2

#define AFE_DYN_RX3_ADC_STANDBY_MODE            0x00000008
#define AFE_DYN_RX3_ADC_STANDBY_MODE_MASK       0x00000008
#define AFE_DYN_RX3_ADC_STANDBY_MODE_BIT        3

#define AFE_DYN_TX3_DAC_STANDBY_MODE            0x00000080
#define AFE_DYN_TX3_DAC_STANDBY_MODE_MASK       0x00000080
#define AFE_DYN_TX3_DAC_STANDBY_MODE_BIT        7

#define AFE_DYN_TX2_DAC_STANDBY_MODE            0x00000040
#define AFE_DYN_TX2_DAC_STANDBY_MODE_MASK       0x00000040
#define AFE_DYN_TX2_DAC_STANDBY_MODE_BIT        6

#define AFE_DYN_TX0_DAC_STANDBY_MODE            0x00000010
#define AFE_DYN_TX0_DAC_STANDBY_MODE_MASK       0x00000010
#define AFE_DYN_TX0_DAC_STANDBY_MODE_BIT        4

#define AFE_DYN_TX1_DAC_STANDBY_MODE            0x00000020
#define AFE_DYN_TX1_DAC_STANDBY_MODE_MASK       0x00000020
#define AFE_DYN_TX1_DAC_STANDBY_MODE_BIT        5

#define AFE_DYN_AUX0_STANDBY_MODE               0x00001000
#define AFE_DYN_AUX0_STANDBY_MODE_MASK          0x00001000
#define AFE_DYN_AUX0_STANDBY_MODE_BIT           12

#define AFE_DYN_AUX1_STANDBY_MODE               0x00002000
#define AFE_DYN_AUX1_STANDBY_MODE_MASK          0x00002000
#define AFE_DYN_AUX1_STANDBY_MODE_BIT           13

#define AFE_DYN_AUX2_STANDBY_MODE               0x00004000
#define AFE_DYN_AUX2_STANDBY_MODE_MASK          0x00004000
#define AFE_DYN_AUX2_STANDBY_MODE_BIT           14

#define AFE_DYN_AUX3_STANDBY_MODE               0x00008000
#define AFE_DYN_AUX3_STANDBY_MODE_MASK          0x00008000
#define AFE_DYN_AUX3_STANDBY_MODE_BIT           15

/*****************************************************************/

/*****************************************************************/
// AFE_PDN_CTRL: Power Down control
/*****************************************************************/
#define AFE_PDN_CTRL_RX_0_PD              0x00000001
#define AFE_PDN_CTRL_RX_0_PD_MASK         0x00000001
#define AFE_PDN_CTRL_RX_0_PD_BIT          0

#define AFE_PDN_CTRL_RX_1_PD              0x00000002
#define AFE_PDN_CTRL_RX_1_PD_MASK         0x00000002
#define AFE_PDN_CTRL_RX_1_PD_BIT          1

#define AFE_PDN_CTRL_RX_2_PD              0x00000004
#define AFE_PDN_CTRL_RX_2_PD_MASK         0x00000004
#define AFE_PDN_CTRL_RX_2_PD_BIT          2

#define AFE_PDN_CTRL_RX_3_PD              0x00000008
#define AFE_PDN_CTRL_RX_3_PD_MASK         0x00000008
#define AFE_PDN_CTRL_RX_3_PD_BIT          3


#define AFE_PDN_CTRL_TX_0_PD              0x00000010
#define AFE_PDN_CTRL_TX_0_PD_MASK         0x00000010
#define AFE_PDN_CTRL_TX_0_PD_BIT          4

#define AFE_PDN_CTRL_TX_1_PD              0x00000020
#define AFE_PDN_CTRL_TX_1_PD_MASK         0x00000020
#define AFE_PDN_CTRL_TX_1_PD_BIT          5

#define AFE_PDN_CTRL_TX_2_PD              0x00000040
#define AFE_PDN_CTRL_TX_2_PD_MASK         0x00000040
#define AFE_PDN_CTRL_TX_2_PD_BIT          6

#define AFE_PDN_CTRL_TX_3_PD              0x00000080
#define AFE_PDN_CTRL_TX_3_PD_MASK         0x00000080
#define AFE_PDN_CTRL_TX_3_PD_BIT          7

#define AFE_PDN_CTRL_AUX_ADC_0_PD         0x00001000
#define AFE_PDN_CTRL_AUX_ADC_0_PD_MASK    0x00001000
#define AFE_PDN_CTRL_AUX_ADC_0_PD_BIT     12

#define AFE_PDN_CTRL_AUX_ADC_1_PD         0x00002000
#define AFE_PDN_CTRL_AUX_ADC_1_PD_MASK    0x00002000
#define AFE_PDN_CTRL_AUX_ADC_1_PD_BIT     13

#define AFE_PDN_CTRL_AUX_ADC_2_PD         0x00004000
#define AFE_PDN_CTRL_AUX_ADC_2_PD_MASK    0x00004000
#define AFE_PDN_CTRL_AUX_ADC_2_PD_BIT     14

#define AFE_PDN_CTRL_AUX_ADC_3_PD         0x00008000
#define AFE_PDN_CTRL_AUX_ADC_3_PD_MASK    0x00008000
#define AFE_PDN_CTRL_AUX_ADC_3_PD_BIT     15

/*****************************************************************/

/*****************************************************************/
// AFE_AUX_CTRL: Aux ADC channel enables
/*****************************************************************/
/*****************************************************************/
#define AUX0_CH_EN          0x00000001
#define AUX0_CH_EN_MASK     0x00000001
#define AUX0_CH_EN_BIT      0

#define AUX1_CH_EN          0x00000002
#define AUX1_CH_EN_MASK     0x00000002
#define AUX1_CH_EN_BIT      1

#define AUX2_CH_EN          0x00000004
#define AUX2_CH_EN_MASK     0x00000004
#define AUX2_CH_EN_BIT      2

#define AUX3_CH_EN          0x00000008
#define AUX3_CH_EN_MASK     0x00000008
#define AUX3_CH_EN_BIT      3

/*****************************************************************/
// Global defines
/*****************************************************************/

#define AFE_DAC0_STANDBY_MODE(x)      (x | AFE_DYN_TX0_DAC_STANDBY_MODE)
#define AFE_DAC0_ACTIVE_MODE(x)       (x & ~AFE_DYN_TX0_DAC_STANDBY_MODE)
#define AFE_DAC1_STANDBY_MODE(x)      (x | AFE_DYN_TX1_DAC_STANDBY_MODE)
#define AFE_DAC1_ACTIVE_MODE(x)       (x & ~AFE_DYN_TX1_DAC_STANDBY_MODE)
#define AFE_DAC2_STANDBY_MODE(x)      (x | AFE_DYN_TX2_DAC_STANDBY_MODE)
#define AFE_DAC2_ACTIVE_MODE(x)       (x & ~AFE_DYN_TX2_DAC_STANDBY_MODE)
#define AFE_DAC3_STANDBY_MODE(x)      (x | AFE_DYN_TX3_DAC_STANDBY_MODE)
#define AFE_DAC3_ACTIVE_MODE(x)       (x & ~AFE_DYN_TX3_DAC_STANDBY_MODE)

#define AFE_DAC0_POWER_DOWN(x)        (x | AFE_PDN_CTRL_TX_0_PD)
#define AFE_DAC0_POWER_UP(x)          (x & ~AFE_PDN_CTRL_TX_0_PD)
#define AFE_DAC1_POWER_DOWN(x)        (x | AFE_PDN_CTRL_TX_1_PD)
#define AFE_DAC1_POWER_UP(x)          (x & ~AFE_PDN_CTRL_TX_1_PD)
#define AFE_DAC2_POWER_DOWN(x)        (x | AFE_PDN_CTRL_TX_2_PD)
#define AFE_DAC2_POWER_UP(x)          (x & ~AFE_PDN_CTRL_TX_2_PD)
#define AFE_DAC3_POWER_DOWN(x)        (x | AFE_PDN_CTRL_TX_3_PD)
#define AFE_DAC3_POWER_UP(x)          (x & ~AFE_PDN_CTRL_TX_3_PD)


#define AFE_ADC0_STANDBY_MODE(x)      (x | AFE_DYN_RX0_ADC_STANDBY_MODE)
#define AFE_ADC0_ACTIVE_MODE(x)       (x & ~AFE_DYN_RX0_ADC_STANDBY_MODE)
#define AFE_ADC1_STANDBY_MODE(x)      (x | AFE_DYN_RX1_ADC_STANDBY_MODE)
#define AFE_ADC1_ACTIVE_MODE(x)       (x & ~AFE_DYN_RX1_ADC_STANDBY_MODE)
#define AFE_ADC2_STANDBY_MODE(x)      (x | AFE_DYN_RX2_ADC_STANDBY_MODE)
#define AFE_ADC2_ACTIVE_MODE(x)       (x & ~AFE_DYN_RX2_ADC_STANDBY_MODE)
#define AFE_ADC3_STANDBY_MODE(x)      (x | AFE_DYN_RX3_ADC_STANDBY_MODE)
#define AFE_ADC3_ACTIVE_MODE(x)       (x & ~AFE_DYN_RX3_ADC_STANDBY_MODE)


#define AFE_ADC0_POWER_DOWN(x)        (x | AFE_PDN_CTRL_RX_0_PD)
#define AFE_ADC0_POWER_UP(x)          (x & ~AFE_PDN_CTRL_RX_0_PD)
#define AFE_ADC1_POWER_DOWN(x)        (x | AFE_PDN_CTRL_RX_1_PD)
#define AFE_ADC1_POWER_UP(x)          (x & ~AFE_PDN_CTRL_RX_1_PD)
#define AFE_ADC2_POWER_DOWN(x)        (x | AFE_PDN_CTRL_RX_2_PD)
#define AFE_ADC2_POWER_UP(x)          (x & ~AFE_PDN_CTRL_RX_2_PD)
#define AFE_ADC3_POWER_DOWN(x)        (x | AFE_PDN_CTRL_RX_3_PD)
#define AFE_ADC3_POWER_UP(x)          (x & ~AFE_PDN_CTRL_RX_3_PD)


#define AFE_AUX_ADC0_STANDBY_MODE(x)  (x | AFE_DYN_AUX0_STANDBY_MODE)
#define AFE_AUX_ADC0_ACTIVE_MODE(x)   (x & ~AFE_DYN_AUX0_STANDBY_MODE)
#define AFE_AUX_ADC1_STANDBY_MODE(x)  (x | AFE_DYN_AUX1_STANDBY_MODE)
#define AFE_AUX_ADC1_ACTIVE_MODE(x)   (x & ~AFE_DYN_AUX1_STANDBY_MODE)
#define AFE_AUX_ADC2_STANDBY_MODE(x)  (x | AFE_DYN_AUX2_STANDBY_MODE)
#define AFE_AUX_ADC2_ACTIVE_MODE(x)   (x & ~AFE_DYN_AUX2_STANDBY_MODE)
#define AFE_AUX_ADC3_STANDBY_MODE(x)  (x | AFE_DYN_AUX3_STANDBY_MODE)
#define AFE_AUX_ADC3_ACTIVE_MODE(x)   (x & ~AFE_DYN_AUX3_STANDBY_MODE)


#define AFE_AUX_ADC0_POWER_DOWN(x)    (x | AFE_PDN_CTRL_AUX_ADC_0_PD)
#define AFE_AUX_ADC0_POWER_UP(x)      (x & ~AFE_PDN_CTRL_AUX_ADC_0_PD)
#define AFE_AUX_ADC1_POWER_DOWN(x)    (x | AFE_PDN_CTRL_AUX_ADC_1_PD)
#define AFE_AUX_ADC1_POWER_UP(x)      (x & ~AFE_PDN_CTRL_AUX_ADC_1_PD)
#define AFE_AUX_ADC2_POWER_DOWN(x)    (x | AFE_PDN_CTRL_AUX_ADC_2_PD)
#define AFE_AUX_ADC2_POWER_UP(x)      (x & ~AFE_PDN_CTRL_AUX_ADC_2_PD)
#define AFE_AUX_ADC3_POWER_DOWN(x)    (x | AFE_PDN_CTRL_AUX_ADC_3_PD)
#define AFE_AUX_ADC3_POWER_UP(x)      (x & ~AFE_PDN_CTRL_AUX_ADC_3_PD)

#define REG_MIPS_SECURE_WRITE				(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR + 0x68)
#define REG_MIPS_PLL_CLOCK_3				(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR + 0x44)
#define REG_MIPS_SECURE_WRITE_FIRST_WRITE	(0x0000AAAA)
#define REG_MIPS_SECURE_WRITE_SECOND_WRITE	(0x00005555)
#define REG_MIPS_PLL_CLOCK_3_ENABLE			(0x01)
#define REG_MIPS_PLL_CLOCK_3_DISABLE		(0x11)

#endif /* AFE_H_ */
