/*******************************************************************************
*
*   Source File:
*       Fcsi.c
*
*  AUTHOR: Oshri Yahav
*
*   Description: Low Level Driver for the FCSI module.  
*
*   Copyright:
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any
*       form whatsoever is not permitted without written authority from the
*       copyright owner. Issued by Metalink Transmission Devices Ltd in
*       Israel - 11/94.
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***                        Include Files                                   ***/
/******************************************************************************/
#include "OSAL_Api.h"
#include "Indirect_API.h"
#include "PhyRegsIncluder.h"
#include "HdkGlobalDefs.h"
#include "RegAccess_Api.h"
#include "PhyRxTdIfRegs.h"
#include "PhyRxFdIfRegs.h"
#include "PhyRxTdRegs.h"
#include "PhyTxRegs.h"
#include "mt_sysrst.h"
#include "PhyDriver_API.h"
#include "phy_lib.h"
#include "loggerAPI.h"

/******************************************************************************/
/***                        Internal Constants                              ***/
/******************************************************************************/
#define RISC_ARBITER_GCLK_BYPASS_ENABLE 0x00800000
#define FCSI_CLOCK_DIVIDERS_VALUES		0x0F02

#define FCSI_DONE_DELAY 300 // the delay time to checking the indirect command completion

#define FCSI_DATA_A		0
#define FCSI_DATA_B		1
#define FCSI_DATA_C		2
#define FCSI_DATA_D		3
#define FCSI_DATA_E		4

#define FCSI_ADRESS_A	0
#define FCSI_ADRESS_B	1
#define FCSI_ADRESS_C	2
#define FCSI_ADRESS_D	3
#define FCSI_ADRESS_E	4

#define FCSI_READ_BIT   (1) /* when using multiple read, we need to turn this bit on in address A's register */
#define FCSI_WRITE_BIT  (0) /* when using multiple write, we set the read/write bit to 0 in address A's register */
/******************************************************************************/
/***                     Internal Data Structures                           ***/
/******************************************************************************/

typedef enum FcsiReadWrite
{
    FCSI_WRITE = 0,
    FCSI_READ = 1,
} FcsiReadWrite_e;

/******************************************************************************/
/***                                Macros                                  ***/
/******************************************************************************/




/******************************************************************************/
/***                      Static Function Declaration                       ***/
/******************************************************************************/
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void configureFcsiAdressRegisters(IN INDIRECT_BLOCK_e block,IN uint32 *addr, IN FcsiReadWrite_e readOrWrite);
static RetVal_e waitFcsiIdle(void);
#endif

/******************************************************************************/
/***                           Static Variables                             ***/
/******************************************************************************/

/******************************************************************************/
/***                             Debug Section                              ***/
/******************************************************************************/

/******************************************************************************/
/***                        Public Functions Definitions                    ***/
/******************************************************************************/

/*********************************************************************************
Method:       IndirectGetType
Description:  Return the indirect bus type (currently FCSI or PIF)
Parameter:    None
Returns:      INDIRECT_BUS_TYPE_e
*********************************************************************************/
INDIRECT_BUS_TYPE_e IndirectGetType( void )
{
  return INDIRECT_ACCESS_BUS_FCSI;
}

/*********************************************************************************
Method:       IndirectReset
Description:  Reset the indirect access bus controller to default values.
Parameter:    void* conf_seg - part of the prog-model the F/W receives at init
              time.
Returns:      Status_e - success or failure
*********************************************************************************/
RetVal_e IndirectReset( void* conf_seg )
{
	UNUSED_PARAM(conf_seg);	
	FCSI_RESET_CENTRAL();
	return RET_VAL_SUCCESS;
}
/*********************************************************************************
Method:       IndirectReset
Description:  Reset the indirect access bus controller to default values.
Parameter:    void* conf_seg - part of the prog-model the F/W receives at init
              time.
Returns:      Status_e - success or failure
*********************************************************************************/
void IndirectResetAnt(void)
{
	FCSI_RESET_ANT();
}

/*********************************************************************************
Method:       IndirectSingleWrite
Description:  Set a single indirect register .
Parameter:    IN INDIRECT_BLOCK_e block - AFE, RF external or RF internal.
              IN uint32 address  register address in the block.
              IN uint32 value  the value to be set.
Returns:      Status_e - success or failure
*********************************************************************************/
RetVal_e IndirectSingleWrite( IN INDIRECT_BLOCK_e block, IN uint32 address, IN uint32 value)
{
	UNUSED_PARAM(block);	
	UNUSED_PARAM(address);	
	UNUSED_PARAM(value);	
	return RET_VAL_NOT_SUPPORTED;
}

/*********************************************************************************
Method:       IndirectMultipleWrite
Description:  Set 3 indirect registers simultaneously.
Parameter:    IN INDIRECT_BLOCK_e block - AFE, RF external or RF internal.
              IN INDIRECT_MULTI_ARG_t arg - pointer to a struct that will
                contain the 3 addresses and the values
Returns:      Status_e - success or failure
*********************************************************************************/
RetVal_e IndirectMultipleWrite( IN INDIRECT_BLOCK_e block, IN INDIRECT_MULTI_ARG_t *arg)
{
	UNUSED_PARAM(block);	
	UNUSED_PARAM(arg);	
	return RET_VAL_SUCCESS;
}

/*********************************************************************************
Method:       IndirectSingleRead
Description:  Get a single indirect register.  
Parameter:    IN INDIRECT_BLOCK_e block - AFE, RF external or RF internal.
              IN uint32 address  register address in this module.
              OUT uint32 *value  the return value.
Returns:      Status_e - success or failure.
*********************************************************************************/
RetVal_e IndirectSingleRead( IN INDIRECT_BLOCK_e block, IN uint32 address, OUT uint32 *value)
{
	UNUSED_PARAM(block);	
	UNUSED_PARAM(address);	
	UNUSED_PARAM(value);
	return RET_VAL_NOT_SUPPORTED;
}



/*********************************************************************************
Method:       IndirectMultipleRead
Description:  Get a single indirect register.
Parameter:    IN INDIRECT_BLOCK_e block - AFE, RF external,  
              INOUT INDIRECT_MULTI_ARG_t *arg - pointer to a struct that will
                contain the 3 addresses and the values
Returns:      Status_e - success or failure.
*********************************************************************************/
RetVal_e IndirectMultipleRead( IN INDIRECT_BLOCK_e block, INOUT INDIRECT_MULTI_ARG_t *arg)
{
	UNUSED_PARAM(block);	
	UNUSED_PARAM(arg);	
	return RET_VAL_SUCCESS;
}
#ifdef SDL_IGNORE_UNUSED_FUNCTION
/*********************************************************************************
Method:       configureAdressRegisters
Description:  
Parameter:    IN INDIRECT_BLOCK_e block
Parameter:    IN uint32 * addr
Parameter:    IN FcsiReadWrite_e readOrWrite
Returns:      void
*********************************************************************************/
static void configureFcsiAdressRegisters(IN INDIRECT_BLOCK_e block,IN uint32 *addr, IN FcsiReadWrite_e readOrWrite)
{
}

/*********************************************************************************
Method:       waitFcsiIdle
Description:  
Parameter:    void
Returns:      RetVal_e
*********************************************************************************/
static RetVal_e waitFcsiIdle(void)
{
	return RET_VAL_SUCCESS;
}
#endif



