/*******************************************************************
*                                                                  
*  PHY_RX_FD.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef PHY_RX_FD_regs_H_FILE
#define PHY_RX_FD_regs_H_FILE

/* PHY_RXFD_REG02_BIST_DONE_LOW */
/* bist done low part */
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW          0x00008
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_SHIFT    0
#define REG_PHY_RXFD_REG02_BIST_DONE_LOW_WIDTH    32

/* PHY_RXFD_REG03_BIST_DONE_HIGH */
/* bist done high part */
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH          0x0000C
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_MASK     0x00007FFF
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_SHIFT    0
#define REG_PHY_RXFD_REG03_BIST_DONE_HIGH_WIDTH    15

/* PHY_RXFD_REG04_BIST_RESULT_LOW */
/* bist result low part */
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW          0x00010
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_MASK     0xFFFFFFFF
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_SHIFT    0
#define REG_PHY_RXFD_REG04_BIST_RESULT_LOW_WIDTH    32

/* PHY_RXFD_REG05_BIST_RESULT_HIGH */
/* bist result high part */
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH          0x00014
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_MASK     0x00007FFF
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_SHIFT    0
#define REG_PHY_RXFD_REG05_BIST_RESULT_HIGH_WIDTH    15

/* PHY_RXFD_REG06_PT_BYPASS */
/* phase tracking bypass - zero outputs */
#define REG_PHY_RXFD_REG06_PT_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_PT_BYPASS_MASK     0x00000001
#define REG_PHY_RXFD_REG06_PT_BYPASS_SHIFT    0
#define REG_PHY_RXFD_REG06_PT_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_NCO_FUNC_BYPASS */
/* nco functional bypass (force phase addr to zero) */
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_MASK     0x00000002
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_SHIFT    1
#define REG_PHY_RXFD_REG06_NCO_FUNC_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN */
/* enable update ch in read write mode */
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN          0x00018
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_MASK     0x00000010
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_SHIFT    4
#define REG_PHY_RXFD_REG06_RW_CH_MODE_UP_CH_EN_WIDTH    1

/* PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN */
/* enable update ch in update mode */
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN          0x00018
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_MASK     0x00000020
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_SHIFT    5
#define REG_PHY_RXFD_REG06_UP_CH_MODE_UP_CH_EN_WIDTH    1

/* PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS */
/* independent noise estimation sw bypass */
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_MASK     0x00000040
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_SHIFT    6
#define REG_PHY_RXFD_REG06_INDPNDT_NE_SW_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS */
/* dependent noise estimation sw bypass */
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS          0x00018
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_MASK     0x00000080
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_SHIFT    7
#define REG_PHY_RXFD_REG06_DPNDT_NE_SW_BYPASS_WIDTH    1

/* PHY_RXFD_REG06_RX_ENABLE_OVERRIDE */
/* GSM - test mode */
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE          0x00018
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_MASK     0x00000200
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_SHIFT    9
#define REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_WIDTH    1

/* PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE */
/* dpndt_ne_symmetric_mode */
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE          0x00018
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_MASK     0x00000400
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_SHIFT    10
#define REG_PHY_RXFD_REG06_DPNDT_NE_SYMMETRIC_MODE_WIDTH    1

/* PHY_RXFD_REG06_BC_OUT_2TB */
/* connect bin chooser output to MID  test plug 0 (len0_tp0). 001-fft_0, 010-fft_1 100-fft_2 */
#define REG_PHY_RXFD_REG06_BC_OUT_2TB          0x00018
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_MASK     0x70000000
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_SHIFT    28
#define REG_PHY_RXFD_REG06_BC_OUT_2TB_WIDTH    3

/* PHY_RXFD_REG07_FFT_OLA_SELECT */
/* fft_ola_select[2],fft_ola_select[1],fft_ola_select[0] */
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT          0x0001C
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_MASK     0x00000007
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_SHIFT    0
#define REG_PHY_RXFD_REG07_FFT_OLA_SELECT_WIDTH    3

/* PHY_RXFD_REG07_FFT_0_GCLK_BYPASS */
/* fft 0 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_MASK     0x00000010
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_SHIFT    4
#define REG_PHY_RXFD_REG07_FFT_0_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_1_GCLK_BYPASS */
/* fft 1 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_MASK     0x00000020
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_SHIFT    5
#define REG_PHY_RXFD_REG07_FFT_1_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_2_GCLK_BYPASS */
/* fft 2 gated clock bypass */
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS          0x0001C
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_MASK     0x00000040
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_SHIFT    6
#define REG_PHY_RXFD_REG07_FFT_2_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG07_FFT_RND */
/* fft output round */
#define REG_PHY_RXFD_REG07_FFT_RND          0x0001C
#define REG_PHY_RXFD_REG07_FFT_RND_MASK     0x00000300
#define REG_PHY_RXFD_REG07_FFT_RND_SHIFT    8
#define REG_PHY_RXFD_REG07_FFT_RND_WIDTH    2

/* PHY_RXFD_REG07_FFT_START_WADDR */
/* fft_start_waddr */
#define REG_PHY_RXFD_REG07_FFT_START_WADDR          0x0001C
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_MASK     0x0007F000
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_SHIFT    12
#define REG_PHY_RXFD_REG07_FFT_START_WADDR_WIDTH    7

/* PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT */
/* short cyclic prefix timing shift - full channel bonding */
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT          0x0001C
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_MASK     0x00F00000
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_SHIFT    20
#define REG_PHY_RXFD_REG07_FCB_SHORT_CP_TIM_SHIFT_WIDTH    4

/* PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT */
/* short cyclic prefix timing shift - non channel bonding */
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT          0x0001C
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_MASK     0x0F000000
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_SHIFT    24
#define REG_PHY_RXFD_REG07_NCB_SHORT_CP_TIM_SHIFT_WIDTH    4

/* PHY_RXFD_REG09_FCB_NPILOT */
/* full channel bonding - number of pilots bins */
#define REG_PHY_RXFD_REG09_FCB_NPILOT          0x00024
#define REG_PHY_RXFD_REG09_FCB_NPILOT_MASK     0x00000007
#define REG_PHY_RXFD_REG09_FCB_NPILOT_SHIFT    0
#define REG_PHY_RXFD_REG09_FCB_NPILOT_WIDTH    3

/* PHY_RXFD_REG09_NCB_NPILOT */
/* non channel bonding - number of pilots bins */
#define REG_PHY_RXFD_REG09_NCB_NPILOT          0x00024
#define REG_PHY_RXFD_REG09_NCB_NPILOT_MASK     0x00000070
#define REG_PHY_RXFD_REG09_NCB_NPILOT_SHIFT    4
#define REG_PHY_RXFD_REG09_NCB_NPILOT_WIDTH    3

/* PHY_RXFD_REG09_FCB_NDATA */
/* full channel bonding - number of data bins */
#define REG_PHY_RXFD_REG09_FCB_NDATA          0x00024
#define REG_PHY_RXFD_REG09_FCB_NDATA_MASK     0x00007F00
#define REG_PHY_RXFD_REG09_FCB_NDATA_SHIFT    8
#define REG_PHY_RXFD_REG09_FCB_NDATA_WIDTH    7

/* PHY_RXFD_REG09_NCB_NDATA */
/* non channel bonding - number of data bins */
#define REG_PHY_RXFD_REG09_NCB_NDATA          0x00024
#define REG_PHY_RXFD_REG09_NCB_NDATA_MASK     0x007F0000
#define REG_PHY_RXFD_REG09_NCB_NDATA_SHIFT    16
#define REG_PHY_RXFD_REG09_NCB_NDATA_WIDTH    7

/* PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE */
/* phase init mode */
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE          0x00028
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_MASK     0x00000030
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_SHIFT    4
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_PHASE_INIT_MODE_WIDTH    2

/* PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE */
/* timing init mode */
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE          0x00028
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_MASK     0x00000300
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_SHIFT    8
#define REG_PHY_RXFD_REG0A_PT_SMOOTHING_TIMING_INIT_MODE_WIDTH    2

/* PHY_RXFD_REG0A_FT_ENABLE */
/* frequency tracking enable */
#define REG_PHY_RXFD_REG0A_FT_ENABLE          0x00028
#define REG_PHY_RXFD_REG0A_FT_ENABLE_MASK     0x00001000
#define REG_PHY_RXFD_REG0A_FT_ENABLE_SHIFT    12
#define REG_PHY_RXFD_REG0A_FT_ENABLE_WIDTH    1

/* PHY_RXFD_REG0A_NUM_OF_SYM_MASK */
/* frequency tracking symbol mask */
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK          0x00028
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_MASK     0x7FF00000
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_SHIFT    20
#define REG_PHY_RXFD_REG0A_NUM_OF_SYM_MASK_WIDTH    11

/* PHY_RXFD_REG0A_RF_DATA_TYPE */
/* frequency tracking data type */
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE          0x00028
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_MASK     0x80000000
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_SHIFT    31
#define REG_PHY_RXFD_REG0A_RF_DATA_TYPE_WIDTH    1

/* PHY_RXFD_REG0B_CT_GCLK_DIS */
/* channel tracking gated clock disable */
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS          0x0002C
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_MASK     0x00000001
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_SHIFT    0
#define REG_PHY_RXFD_REG0B_CT_GCLK_DIS_WIDTH    1

/* PHY_RXFD_REG0B_CT_HARD_DECISION_INV */
/* channel tracking hard decision invert */
#define REG_PHY_RXFD_REG0B_CT_HARD_DECISION_INV          0x0002C
#define REG_PHY_RXFD_REG0B_CT_HARD_DECISION_INV_MASK     0x00000010
#define REG_PHY_RXFD_REG0B_CT_HARD_DECISION_INV_SHIFT    4
#define REG_PHY_RXFD_REG0B_CT_HARD_DECISION_INV_WIDTH    1

/* PHY_RXFD_REG0B_CT_2_TB_EN */
/* channel (pilot & data) to test bus en (at end of packet) */
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN          0x0002C
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_MASK     0x00000020
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_SHIFT    5
#define REG_PHY_RXFD_REG0B_CT_2_TB_EN_WIDTH    1

/* PHY_RXFD_REG0C_TABLE_1_START */
/* channel estimation full channel bonding table start address */
#define REG_PHY_RXFD_REG0C_TABLE_1_START          0x00030
#define REG_PHY_RXFD_REG0C_TABLE_1_START_MASK     0x000001FF
#define REG_PHY_RXFD_REG0C_TABLE_1_START_SHIFT    0
#define REG_PHY_RXFD_REG0C_TABLE_1_START_WIDTH    9

/* PHY_RXFD_REG0D_CE_H0_SET */
/* channel estimation ho coefficients */
#define REG_PHY_RXFD_REG0D_CE_H0_SET          0x00034
#define REG_PHY_RXFD_REG0D_CE_H0_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0D_CE_H0_SET_SHIFT    0
#define REG_PHY_RXFD_REG0D_CE_H0_SET_WIDTH    10

/* PHY_RXFD_REG0D_CE_H1_SET */
/* channel estimation h1 coefficients */
#define REG_PHY_RXFD_REG0D_CE_H1_SET          0x00034
#define REG_PHY_RXFD_REG0D_CE_H1_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0D_CE_H1_SET_SHIFT    16
#define REG_PHY_RXFD_REG0D_CE_H1_SET_WIDTH    10

/* PHY_RXFD_REG0E_CE_H2_SET */
/* channel estimation h2 coefficients */
#define REG_PHY_RXFD_REG0E_CE_H2_SET          0x00038
#define REG_PHY_RXFD_REG0E_CE_H2_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0E_CE_H2_SET_SHIFT    0
#define REG_PHY_RXFD_REG0E_CE_H2_SET_WIDTH    10

/* PHY_RXFD_REG0E_CE_H3_SET */
/* channel estimation h3 coefficients */
#define REG_PHY_RXFD_REG0E_CE_H3_SET          0x00038
#define REG_PHY_RXFD_REG0E_CE_H3_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0E_CE_H3_SET_SHIFT    16
#define REG_PHY_RXFD_REG0E_CE_H3_SET_WIDTH    10

/* PHY_RXFD_REG0F_CE_H4_SET */
/* channel estimation h4 coefficients */
#define REG_PHY_RXFD_REG0F_CE_H4_SET          0x0003C
#define REG_PHY_RXFD_REG0F_CE_H4_SET_MASK     0x000003FF
#define REG_PHY_RXFD_REG0F_CE_H4_SET_SHIFT    0
#define REG_PHY_RXFD_REG0F_CE_H4_SET_WIDTH    10

/* PHY_RXFD_REG0F_CE_H5_SET */
/* channel estimation h5 coefficients */
#define REG_PHY_RXFD_REG0F_CE_H5_SET          0x0003C
#define REG_PHY_RXFD_REG0F_CE_H5_SET_MASK     0x03FF0000
#define REG_PHY_RXFD_REG0F_CE_H5_SET_SHIFT    16
#define REG_PHY_RXFD_REG0F_CE_H5_SET_WIDTH    10

/* PHY_RXFD_REG10_SLICER_USE_GCLK */
/* if active slicer work with gclk, else bypass slicer gated clock  */
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK          0x00040
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_MASK     0x00000001
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_SHIFT    0
#define REG_PHY_RXFD_REG10_SLICER_USE_GCLK_WIDTH    1

/* PHY_RXFD_REG10_QR_USE_GCLK */
/* if active QR work with gclk, else bypass QR gated clock  */
#define REG_PHY_RXFD_REG10_QR_USE_GCLK          0x00040
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_MASK     0x00000002
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_SHIFT    1
#define REG_PHY_RXFD_REG10_QR_USE_GCLK_WIDTH    1

/* PHY_RXFD_REG10_SLICER_IF_CNT_VALUE */
/* slicer_if_cnt_value */
#define REG_PHY_RXFD_REG10_SLICER_IF_CNT_VALUE          0x00040
#define REG_PHY_RXFD_REG10_SLICER_IF_CNT_VALUE_MASK     0x000000F0
#define REG_PHY_RXFD_REG10_SLICER_IF_CNT_VALUE_SHIFT    4
#define REG_PHY_RXFD_REG10_SLICER_IF_CNT_VALUE_WIDTH    4

/* PHY_RXFD_REG10_SLICER_QUALITY_DATA_TYPE */
/* slicer_quality : 0= mean 1= threshold */
#define REG_PHY_RXFD_REG10_SLICER_QUALITY_DATA_TYPE          0x00040
#define REG_PHY_RXFD_REG10_SLICER_QUALITY_DATA_TYPE_MASK     0x00000200
#define REG_PHY_RXFD_REG10_SLICER_QUALITY_DATA_TYPE_SHIFT    9
#define REG_PHY_RXFD_REG10_SLICER_QUALITY_DATA_TYPE_WIDTH    1

/* PHY_RXFD_REG10_SLICER_TEST_BUS_LEN */
/* slicer test bus local enable */
#define REG_PHY_RXFD_REG10_SLICER_TEST_BUS_LEN          0x00040
#define REG_PHY_RXFD_REG10_SLICER_TEST_BUS_LEN_MASK     0x1FF00000
#define REG_PHY_RXFD_REG10_SLICER_TEST_BUS_LEN_SHIFT    20
#define REG_PHY_RXFD_REG10_SLICER_TEST_BUS_LEN_WIDTH    9

/* PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL */
/* long1_scrm_init_val */
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL          0x00044
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_MASK     0x0000007F
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_SHIFT    0
#define REG_PHY_RXFD_REG11_LONG1_SCRM_INIT_VAL_WIDTH    7

/* PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK */
/* two_band_prank1_mask */
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_MASK     0x000000FF
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_SHIFT    0
#define REG_PHY_RXFD_REG12_TWO_BAND_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK */
/* long3_fcb_prank1_mask */
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_MASK     0x0000FF00
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_SHIFT    8
#define REG_PHY_RXFD_REG12_LONG3_FCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK */
/* long3_ncb_prank1_mask */
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK          0x00048
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_MASK     0x00FF0000
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_SHIFT    16
#define REG_PHY_RXFD_REG12_LONG3_NCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG13_FCB_PRANK1_MASK */
/* fcb_prank1_mask */
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK          0x0004C
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_MASK     0x000000FF
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_SHIFT    0
#define REG_PHY_RXFD_REG13_FCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG13_NCB_PRANK1_MASK */
/* ncb_prank1_mask */
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK          0x0004C
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_MASK     0x0000FF00
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_SHIFT    8
#define REG_PHY_RXFD_REG13_NCB_PRANK1_MASK_WIDTH    8

/* PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0 */
/* fcb_prank2_mask_an0 */
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0          0x00050
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_MASK     0x000000FF
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_SHIFT    0
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1 */
/* fcb_prank2_mask_an1 */
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1          0x00050
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_MASK     0x0000FF00
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_SHIFT    8
#define REG_PHY_RXFD_REG14_FCB_PRANK2_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0 */
/* ncb_prank2_mask_an0 */
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0          0x00050
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_MASK     0x00FF0000
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_SHIFT    16
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN0_WIDTH    8

/* PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1 */
/* ncb_prank2_mask_an1 */
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1          0x00050
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_MASK     0xFF000000
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_SHIFT    24
#define REG_PHY_RXFD_REG14_NCB_PRANK2_MASK_AN1_WIDTH    8

/* PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD */
/* td_ht_mode_add */
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_MASK     0x0000000F
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_SHIFT    0
#define REG_PHY_RXFD_REG15_TD_HT_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD */
/* td_legacy_mode_add */
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_MASK     0x000000F0
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_SHIFT    4
#define REG_PHY_RXFD_REG15_TD_HT_LTF2_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD */
/* td_rank_cp_00_add */
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG15_TD_HT_CP_1_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD */
/* td_rank_cp_01_add */
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD          0x00054
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_MASK     0x0000F000
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_SHIFT    12
#define REG_PHY_RXFD_REG15_TD_HT_CP_0_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD */
/* td_ht_mode_add */
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_MASK     0x0000000F
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_SHIFT    0
#define REG_PHY_RXFD_REG16_FD_HT_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD */
/* td_legacy_mode_add */
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_MASK     0x000000F0
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_SHIFT    4
#define REG_PHY_RXFD_REG16_FD_HT_LTF2_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD */
/* extra ltf mode */
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD          0x00058
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG16_FD_HT_BF_LTF_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG16_CB_HALF_ENABLE */
/* channel bonding half band enable */
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE          0x00058
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_MASK     0x01000000
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_SHIFT    24
#define REG_PHY_RXFD_REG16_CB_HALF_ENABLE_WIDTH    1

/* PHY_RXFD_REG1B_GSM_ABORT_THR */
/* gsm_abort_thr */
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR          0x0006C
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_MASK     0x0000FFFF
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_SHIFT    0
#define REG_PHY_RXFD_REG1B_GSM_ABORT_THR_WIDTH    16

/* PHY_RXFD_REG1C_LEN_TP0 */
/* enable nco output to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP0          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP0_MASK     0x00000007
#define REG_PHY_RXFD_REG1C_LEN_TP0_SHIFT    0
#define REG_PHY_RXFD_REG1C_LEN_TP0_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP1 */
/* enable phase tracking input to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP1          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP1_MASK     0x00000070
#define REG_PHY_RXFD_REG1C_LEN_TP1_SHIFT    4
#define REG_PHY_RXFD_REG1C_LEN_TP1_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP2 */
/* enable phase tracking output to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP2          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP2_MASK     0x00000700
#define REG_PHY_RXFD_REG1C_LEN_TP2_SHIFT    8
#define REG_PHY_RXFD_REG1C_LEN_TP2_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP3 */
/* enable channel to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP3          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP3_MASK     0x00007000
#define REG_PHY_RXFD_REG1C_LEN_TP3_SHIFT    12
#define REG_PHY_RXFD_REG1C_LEN_TP3_WIDTH    3

/* PHY_RXFD_REG1C_LEN_TP4 */
/* enable slicer output or fifo_4_2bnad  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP4          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP4_MASK     0x00070000
#define REG_PHY_RXFD_REG1C_LEN_TP4_SHIFT    16
#define REG_PHY_RXFD_REG1C_LEN_TP4_WIDTH    3

/* PHY_RXFD_REG1C_SLICER_2TB */
/* select slicer or fifo to test bus (1- slicer) */
#define REG_PHY_RXFD_REG1C_SLICER_2TB          0x00070
#define REG_PHY_RXFD_REG1C_SLICER_2TB_MASK     0x00080000
#define REG_PHY_RXFD_REG1C_SLICER_2TB_SHIFT    19
#define REG_PHY_RXFD_REG1C_SLICER_2TB_WIDTH    1

/* PHY_RXFD_REG1C_LEN_TP5 */
/* enable timing estimation and csm information  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP5          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP5_MASK     0x00700000
#define REG_PHY_RXFD_REG1C_LEN_TP5_SHIFT    20
#define REG_PHY_RXFD_REG1C_LEN_TP5_WIDTH    3

/* PHY_RXFD_REG1C_TE_ACCUM_2TB */
/* select source to tb unit 5 high: 0 - data from fd_csm 1-timing estimation accumulaotr output */
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB          0x00070
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_MASK     0x00800000
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_SHIFT    23
#define REG_PHY_RXFD_REG1C_TE_ACCUM_2TB_WIDTH    1

/* PHY_RXFD_REG1C_LEN_TP6 */
/* enable gsm information  to test bus */
#define REG_PHY_RXFD_REG1C_LEN_TP6          0x00070
#define REG_PHY_RXFD_REG1C_LEN_TP6_MASK     0x07000000
#define REG_PHY_RXFD_REG1C_LEN_TP6_SHIFT    24
#define REG_PHY_RXFD_REG1C_LEN_TP6_WIDTH    3

/* PHY_RXFD_REG1C_GSM_2_TB_RATE */
/* gsm information strobe rate(+1)  to the test bus */
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE          0x00070
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_MASK     0xF0000000
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_SHIFT    28
#define REG_PHY_RXFD_REG1C_GSM_2_TB_RATE_WIDTH    4

/* PHY_RXFD_REG1D_SPARE_REG */
/* spare register */
#define REG_PHY_RXFD_REG1D_SPARE_REG          0x00074
#define REG_PHY_RXFD_REG1D_SPARE_REG_MASK     0x0000FFFF
#define REG_PHY_RXFD_REG1D_SPARE_REG_SHIFT    0
#define REG_PHY_RXFD_REG1D_SPARE_REG_WIDTH    16

/* PHY_RXFD_REG21_SISO_INTEGRATOR_IMAGE_I */
/* siso - integrator counter real part */
#define REG_PHY_RXFD_REG21_SISO_INTEGRATOR_IMAGE_I          0x00084
#define REG_PHY_RXFD_REG21_SISO_INTEGRATOR_IMAGE_I_MASK     0x007FFFFF
#define REG_PHY_RXFD_REG21_SISO_INTEGRATOR_IMAGE_I_SHIFT    0
#define REG_PHY_RXFD_REG21_SISO_INTEGRATOR_IMAGE_I_WIDTH    23

/* PHY_RXFD_REG2E_SISO_INTEGRATOR_IMAGE_Q */
/* siso - integrator counter image part */
#define REG_PHY_RXFD_REG2E_SISO_INTEGRATOR_IMAGE_Q          0x000B8
#define REG_PHY_RXFD_REG2E_SISO_INTEGRATOR_IMAGE_Q_MASK     0x007FFFFF
#define REG_PHY_RXFD_REG2E_SISO_INTEGRATOR_IMAGE_Q_SHIFT    0
#define REG_PHY_RXFD_REG2E_SISO_INTEGRATOR_IMAGE_Q_WIDTH    23

/* PHY_RXFD_REG30_MIMO_INTEGRATOR_IMAGE_I */
/* mimo - integrator counter real part */
#define REG_PHY_RXFD_REG30_MIMO_INTEGRATOR_IMAGE_I          0x000C0
#define REG_PHY_RXFD_REG30_MIMO_INTEGRATOR_IMAGE_I_MASK     0x007FFFFF
#define REG_PHY_RXFD_REG30_MIMO_INTEGRATOR_IMAGE_I_SHIFT    0
#define REG_PHY_RXFD_REG30_MIMO_INTEGRATOR_IMAGE_I_WIDTH    23

/* PHY_RXFD_REG32_MIMO_INTEGRATOR_IMAGE_Q */
/* mimo - integrator counter image part */
#define REG_PHY_RXFD_REG32_MIMO_INTEGRATOR_IMAGE_Q          0x000C8
#define REG_PHY_RXFD_REG32_MIMO_INTEGRATOR_IMAGE_Q_MASK     0x007FFFFF
#define REG_PHY_RXFD_REG32_MIMO_INTEGRATOR_IMAGE_Q_SHIFT    0
#define REG_PHY_RXFD_REG32_MIMO_INTEGRATOR_IMAGE_Q_WIDTH    23

/* PHY_RXFD_REG34_SW_HT_DETECTOR_EN */
/* 1 - force detector output to be as sw_ht_detector_11n */
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN          0x000D0
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_MASK     0x00010000
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_SHIFT    16
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_EN_WIDTH    1

/* PHY_RXFD_REG34_SW_HT_DETECTOR_11N */
/* force ht_detector output :
0 - 11a,
1- 11n */
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N          0x000D0
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_MASK     0x00020000
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_SHIFT    17
#define REG_PHY_RXFD_REG34_SW_HT_DETECTOR_11N_WIDTH    1

/* PHY_RXFD_REG34_CDD_POLARITY */
/* 00 - bypass
01 - positive
10- negative */
#define REG_PHY_RXFD_REG34_CDD_POLARITY          0x000D0
#define REG_PHY_RXFD_REG34_CDD_POLARITY_MASK     0x000C0000
#define REG_PHY_RXFD_REG34_CDD_POLARITY_SHIFT    18
#define REG_PHY_RXFD_REG34_CDD_POLARITY_WIDTH    2

/* PHY_RXFD_REG34_CE_UPDATE_CH */
/* channel estimation - write back to channel */
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH          0x000D0
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_MASK     0x00200000
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_SHIFT    21
#define REG_PHY_RXFD_REG34_CE_UPDATE_CH_WIDTH    1

/* PHY_RXFD_REG34_OLA_MODE */
/* ola mode */
#define REG_PHY_RXFD_REG34_OLA_MODE          0x000D0
#define REG_PHY_RXFD_REG34_OLA_MODE_MASK     0x00400000
#define REG_PHY_RXFD_REG34_OLA_MODE_SHIFT    22
#define REG_PHY_RXFD_REG34_OLA_MODE_WIDTH    1

/* PHY_RXFD_REG34_OLA_FFT_DONE */
/* fft done in ola mode */
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE          0x000D0
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_MASK     0x00800000
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_SHIFT    23
#define REG_PHY_RXFD_REG34_OLA_FFT_DONE_WIDTH    1

/* PHY_RXFD_REG34_OLA_SW_FFT_P */
/* ola  mode - switch between the fft */
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P          0x000D0
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_MASK     0x01000000
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_SHIFT    24
#define REG_PHY_RXFD_REG34_OLA_SW_FFT_P_WIDTH    1

/* PHY_RXFD_REG34_GREENFIELD_DTCTR_EN */
/* enable green field detector */
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN          0x000D0
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_MASK     0x02000000
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_SHIFT    25
#define REG_PHY_RXFD_REG34_GREENFIELD_DTCTR_EN_WIDTH    1

/* PHY_RXFD_REG34_MAC_CONTROL_CHANNEL */
/* mac mips control channel 
0-usb    1-lsb */
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL          0x000D0
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_MASK     0x04000000
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_SHIFT    26
#define REG_PHY_RXFD_REG34_MAC_CONTROL_CHANNEL_WIDTH    1

/* PHY_RXFD_REG34_ENABLE_ERROR_EVENT */
/* enable error event */
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT          0x000D0
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_MASK     0x08000000
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_SHIFT    27
#define REG_PHY_RXFD_REG34_ENABLE_ERROR_EVENT_WIDTH    1

/* PHY_RXFD_REG35_TABLE_2_START */
/* channel_estimation high throughput non channel bonding mode start address */
#define REG_PHY_RXFD_REG35_TABLE_2_START          0x000D4
#define REG_PHY_RXFD_REG35_TABLE_2_START_MASK     0x000001FF
#define REG_PHY_RXFD_REG35_TABLE_2_START_SHIFT    0
#define REG_PHY_RXFD_REG35_TABLE_2_START_WIDTH    9

/* PHY_RXFD_REG35_TABLE_2_END */
/* channel_estimation high throughput non channel bonding mode end address */
#define REG_PHY_RXFD_REG35_TABLE_2_END          0x000D4
#define REG_PHY_RXFD_REG35_TABLE_2_END_MASK     0x001FF000
#define REG_PHY_RXFD_REG35_TABLE_2_END_SHIFT    12
#define REG_PHY_RXFD_REG35_TABLE_2_END_WIDTH    9

/* PHY_RXFD_REG35_DCMTR_TB_OP_MODE */
/* decimated test bus operation mode:
0 - normal mode (nco output)
1- decimated nco output */
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_SHIFT    21
#define REG_PHY_RXFD_REG35_DCMTR_TB_OP_MODE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE */
/* decimated test bus zipper mode:
all the data directed to one of the test bus */
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_MASK     0x00400000
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_SHIFT    22
#define REG_PHY_RXFD_REG35_DCMTR_TB_ZIPPER_MODE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE */
/* decimated test bus data bins rate:
0 - 1/4
1- 1/8 */
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_MASK     0x00800000
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_SHIFT    23
#define REG_PHY_RXFD_REG35_DCMTR_TB_DATA_BINS_RATE_WIDTH    1

/* PHY_RXFD_REG35_DCMTR_TB_SYM_RATE */
/* decimated test bus symbol rate:
0 - 1/1
1- 1/2
2- 1/4 */
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE          0x000D4
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_MASK     0x03000000
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_SHIFT    24
#define REG_PHY_RXFD_REG35_DCMTR_TB_SYM_RATE_WIDTH    2

/* PHY_RXFD_REG36_SW_BIST_START */
/* sw_bist_start */
#define REG_PHY_RXFD_REG36_SW_BIST_START          0x000D8
#define REG_PHY_RXFD_REG36_SW_BIST_START_MASK     0x00100000
#define REG_PHY_RXFD_REG36_SW_BIST_START_SHIFT    20
#define REG_PHY_RXFD_REG36_SW_BIST_START_WIDTH    1

/* PHY_RXFD_REG36_CLEAR_RAM_MODE */
/* clear_ram_mode */
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE          0x000D8
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_SHIFT    21
#define REG_PHY_RXFD_REG36_CLEAR_RAM_MODE_WIDTH    1

/* PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL */
/* test_bus_low_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_MASK     0x00c00000
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_SHIFT    22
#define REG_PHY_RXFD_REG36_TEST_BUS_LOW_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL */
/* test_bus_mid_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_MASK     0x03000000
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_SHIFT    24
#define REG_PHY_RXFD_REG36_TEST_BUS_MID_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL */
/* test_bus_high_mux_ctrl */
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL          0x000D8
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_MASK     0x0c000000
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_SHIFT    26
#define REG_PHY_RXFD_REG36_TEST_BUS_HIGH_MUX_CTRL_WIDTH    2

/* PHY_RXFD_REG37_SLICER_GCLK_BYPASS */
/* slicer_gclk_bypass */
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS          0x000DC
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_MASK     0xf0000000
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_SHIFT    28
#define REG_PHY_RXFD_REG37_SLICER_GCLK_BYPASS_WIDTH    4

/* PHY_RXFD_REG38_SLICER_SW_BIST_START */
/* slicer_sw_bist_start */
#define REG_PHY_RXFD_REG38_SLICER_SW_BIST_START          0x000E0
#define REG_PHY_RXFD_REG38_SLICER_SW_BIST_START_MASK     0x00000001
#define REG_PHY_RXFD_REG38_SLICER_SW_BIST_START_SHIFT    0
#define REG_PHY_RXFD_REG38_SLICER_SW_BIST_START_WIDTH    1

/* PHY_RXFD_REG38_SLICER_CLEAR_RAM_MODE */
/* slicer_clear_ram_mode */
#define REG_PHY_RXFD_REG38_SLICER_CLEAR_RAM_MODE          0x000E0
#define REG_PHY_RXFD_REG38_SLICER_CLEAR_RAM_MODE_MASK     0x00000002
#define REG_PHY_RXFD_REG38_SLICER_CLEAR_RAM_MODE_SHIFT    1
#define REG_PHY_RXFD_REG38_SLICER_CLEAR_RAM_MODE_WIDTH    1

/* PHY_RXFD_REG38_ SLICER_TEST_BUS_LOW_OUT_SELECT */
/*  slicer_test_bus_low_out_select */
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_LOW_OUT_SELECT          0x000E0
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_LOW_OUT_SELECT_MASK     0x0000000c
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_LOW_OUT_SELECT_SHIFT    2
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_LOW_OUT_SELECT_WIDTH    2

/* PHY_RXFD_REG38_ SLICER_TEST_BUS_MID_OUT_SELECT */
/*  slicer_test_bus_mid_out_select */
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_MID_OUT_SELECT          0x000E0
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_MID_OUT_SELECT_MASK     0x00000030
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_MID_OUT_SELECT_SHIFT    4
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_MID_OUT_SELECT_WIDTH    2

/* PHY_RXFD_REG38_ SLICER_TEST_BUS_HIGH_OUT_SELECT */
/*  slicer_test_bus_high_out_select */
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_HIGH_OUT_SELECT          0x000E0
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_HIGH_OUT_SELECT_MASK     0x000000c0
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_HIGH_OUT_SELECT_SHIFT    6
#define REG_PHY_RXFD_REG38_SLICER_TEST_BUS_HIGH_OUT_SELECT_WIDTH    2

/* PHY_RXFD_REG38_ FD_GF_LSIG_MODE_JUMP_ADD */
/* fd (lsig) next address in case of greenfield (default htsig1) */
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD          0x000E0
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_MASK     0x00000F00
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_SHIFT    8
#define REG_PHY_RXFD_REG38_FD_GF_LSIG_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG38_ FD_GF_HTSIG2_MODE_JUMP_ADD */
/* fd (htsig2) next address in case of greenfield (default data) */
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD          0x000E0
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_MASK     0x0000F000
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_SHIFT    12
#define REG_PHY_RXFD_REG38_FD_GF_HTSIG2_MODE_JUMP_ADD_WIDTH    4

/* PHY_RXFD_REG3A_SLICER_FIFO_PIPE_5STEP_RM */
/* slicer_fifo_pipe_5step_rm in qr  */
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_5STEP_RM          0x000E8
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_5STEP_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_5STEP_RM_SHIFT    8
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_5STEP_RM_WIDTH    3

/* PHY_RXFD_REG3A_SLICER_FIFO_PIPE_16STEP_RM */
/* slicer_fifo_pipe_16step_rm in qr  */
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_16STEP_RM          0x000E8
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_16STEP_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_16STEP_RM_SHIFT    12
#define REG_PHY_RXFD_REG3A_SLICER_FIFO_PIPE_16STEP_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM */
/* hyp_rxfd_ne_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3A_HYP_RXFD_NE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM */
/* hyp_rxfd_phase_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_MASK     0x00700000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_SHIFT    20
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM */
/* hyp_rxfd_phase_smoothing_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_SHIFT    24
#define REG_PHY_RXFD_REG3A_HYP_RXFD_PHASE_SMOOTHING_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM */
/* hyp_rxfd_timing_smoothing_ram_rm */
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM          0x000E8
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3A_HYP_RXFD_TIMING_SMOOTHING_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM */
/* hyp_rxfd_data_0_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_SHIFT    0
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_0_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM */
/* hyp_rxfd_data_1_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_MASK     0x00000070
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_SHIFT    4
#define REG_PHY_RXFD_REG3B_HYP_RXFD_DATA_1_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM */
/* hyp_rxfd_pilot_0_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_SHIFT    8
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_0_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM */
/* hyp_rxfd_pilot_1_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_SHIFT    12
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_1_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM */
/* hyp_rxfd_fft_0_image_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_0_IMAGE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_FFT_1_IMAGE_RAM_RM */
/* hyp_rxfd_fft_1_image_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_1_IMAGE_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_1_IMAGE_RAM_RM_MASK     0x00700000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_1_IMAGE_RAM_RM_SHIFT    20
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_1_IMAGE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_FFT_2_IMAGE_RAM_RM */
/* hyp_rxfd_fft_2_image_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_2_IMAGE_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_2_IMAGE_RAM_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_2_IMAGE_RAM_RM_SHIFT    24
#define REG_PHY_RXFD_REG3B_HYP_RXFD_FFT_2_IMAGE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM */
/* hyp_rxfd_pilot_2_ch_ram_rm */
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM          0x000EC
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3B_HYP_RXFD_PILOT_2_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM */
/* hyp_rxfd_gsm_ram_style_rm */
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM          0x000F0
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_SHIFT    0
#define REG_PHY_RXFD_REG3C_HYP_RXFD_GSM_RAM_STYLE_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_H_SHIFTER_RAM_RM */
/* slicer_h_shifter_ram_rm */
#define REG_PHY_RXFD_REG3C_SLICER_H_SHIFTER_RAM_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_H_SHIFTER_RAM_RM_MASK     0x00000070
#define REG_PHY_RXFD_REG3C_SLICER_H_SHIFTER_RAM_RM_SHIFT    4
#define REG_PHY_RXFD_REG3C_SLICER_H_SHIFTER_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_R_SHIFTER_RAM_RM */
/* slicer_r_shifter_ram_rm */
#define REG_PHY_RXFD_REG3C_SLICER_R_SHIFTER_RAM_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_R_SHIFTER_RAM_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3C_SLICER_R_SHIFTER_RAM_RM_SHIFT    8
#define REG_PHY_RXFD_REG3C_SLICER_R_SHIFTER_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_THETA_RAM_1_RM */
/* slicer_theta_ram_1_rm */
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_1_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_1_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_1_RM_SHIFT    12
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_1_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_THETA_RAM_2_RM */
/* slicer_theta_ram_2_rm */
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_2_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_2_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_2_RM_SHIFT    16
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_2_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_THETA_RAM_3_RM */
/* slicer_theta_ram_3_rm */
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_3_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_3_RM_MASK     0x00700000
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_3_RM_SHIFT    20
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_3_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_THETA_RAM_4_RM */
/* slicer_theta_ram_4_rm */
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_4_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_4_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_4_RM_SHIFT    24
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_4_RM_WIDTH    3

/* PHY_RXFD_REG3C_SLICER_THETA_RAM_5_RM */
/* slicer_theta_ram_5_rm */
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_5_RM          0x000F0
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_5_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_5_RM_SHIFT    28
#define REG_PHY_RXFD_REG3C_SLICER_THETA_RAM_5_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_THETA_RAM_6_RM */
/* slicer_theta_ram_6_rm */
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_6_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_6_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_6_RM_SHIFT    0
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_6_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_THETA_RAM_7_RM */
/* slicer_theta_ram_7_rm */
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_7_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_7_RM_MASK     0x00000070
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_7_RM_SHIFT    4
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_7_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_THETA_RAM_8_RM */
/* slicer_theta_ram_8_rm */
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_8_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_8_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_8_RM_SHIFT    8
#define REG_PHY_RXFD_REG3D_SLICER_THETA_RAM_8_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_PIPE_0_RM */
/* slicer_pipe_0_rm */
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_0_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_0_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_0_RM_SHIFT    12
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_0_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_PIPE_1_RM */
/* slicer_pipe_1_rm */
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_1_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_1_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_1_RM_SHIFT    16
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_1_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_PIPE_2_RM */
/* slicer_pipe_2_rm */
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_2_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_2_RM_MASK     0x00700000
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_2_RM_SHIFT    20
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_2_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_PIPE_3_RM */
/* slicer_pipe_3_rm */
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_3_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_3_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_3_RM_SHIFT    24
#define REG_PHY_RXFD_REG3D_SLICER_PIPE_3_RM_WIDTH    3

/* PHY_RXFD_REG3D_SLICER_R11_RAM_RM */
/* slicer_r11_ram_rm */
#define REG_PHY_RXFD_REG3D_SLICER_R11_RAM_RM          0x000F4
#define REG_PHY_RXFD_REG3D_SLICER_R11_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3D_SLICER_R11_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3D_SLICER_R11_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_SLICER_R22_RAM_RM */
/* slicer_r22_ram_rm */
#define REG_PHY_RXFD_REG3E_SLICER_R22_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_SLICER_R22_RAM_RM_MASK     0x00000007
#define REG_PHY_RXFD_REG3E_SLICER_R22_RAM_RM_SHIFT    0
#define REG_PHY_RXFD_REG3E_SLICER_R22_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_SLICER_H12_RAM_RM */
/* slicer_h12_ram_rm */
#define REG_PHY_RXFD_REG3E_SLICER_H12_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_SLICER_H12_RAM_RM_MASK     0x00000070
#define REG_PHY_RXFD_REG3E_SLICER_H12_RAM_RM_SHIFT    4
#define REG_PHY_RXFD_REG3E_SLICER_H12_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_SLICER_H1_RAM_RM */
/* slicer_h1_ram_rm */
#define REG_PHY_RXFD_REG3E_SLICER_H1_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_SLICER_H1_RAM_RM_MASK     0x00000700
#define REG_PHY_RXFD_REG3E_SLICER_H1_RAM_RM_SHIFT    8
#define REG_PHY_RXFD_REG3E_SLICER_H1_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_SLICER_H2_RAM_RM */
/* slicer_h2_ram_rm */
#define REG_PHY_RXFD_REG3E_SLICER_H2_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_SLICER_H2_RAM_RM_MASK     0x00007000
#define REG_PHY_RXFD_REG3E_SLICER_H2_RAM_RM_SHIFT    12
#define REG_PHY_RXFD_REG3E_SLICER_H2_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM */
/* hyp_rxfd_data_2_ch_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_MASK     0x00070000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_SHIFT    16
#define REG_PHY_RXFD_REG3E_HYP_RXFD_DATA_2_CH_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM */
/* hyp_rxfd_impl_chann_pre_phase_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_MASK     0x07000000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_SHIFT    24
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_PHASE_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM */
/* hyp_rxfd_impl_chann_pre_tx_rx_ram_rm */
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM          0x000F8
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_MASK     0x70000000
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_SHIFT    28
#define REG_PHY_RXFD_REG3E_HYP_RXFD_IMPL_CHANN_PRE_TX_RX_RAM_RM_WIDTH    3

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_RANK0          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_RANK0_MASK     0x000001ff
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_1_RANK0_WIDTH    9

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_RANK0          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_RANK0_MASK     0x0003fe00
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_RANK0_SHIFT    9
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_2_3_RANK0_WIDTH    9

/* PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_RANK0          0x000FC
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_RANK0_MASK     0x07fc0000
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_RANK0_SHIFT    18
#define REG_PHY_RXFD_REG3F_EFFECTIVE_SNR_BETA_INV_4_5_RANK0_WIDTH    9

/* PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK0          0x00100
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK0_MASK     0x000001ff
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK0_WIDTH    9

/* PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_1_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_1_RANK1          0x00100
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_1_RANK1_MASK     0x0003fe00
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_1_RANK1_SHIFT    9
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_1_RANK1_WIDTH    9

/* PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_2_3_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_2_3_RANK1          0x00100
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_2_3_RANK1_MASK     0x07fc0000
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_2_3_RANK1_SHIFT    18
#define REG_PHY_RXFD_REG40_EFFECTIVE_SNR_BETA_INV_2_3_RANK1_WIDTH    9

/* PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_4_5_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_4_5_RANK1          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_4_5_RANK1_MASK     0x000001ff
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_4_5_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_4_5_RANK1_WIDTH    9

/* PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK1          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK1_MASK     0x0003fe00
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK1_SHIFT    9
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_BETA_INV_6_7_8_RANK1_WIDTH    9

/* PHY_RXFD_REG41_EFFECTIVE_SNR_GCLK_BYPASS */
/* effective_snr_gclk_bypass */
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_GCLK_BYPASS          0x00104
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_GCLK_BYPASS_MASK     0x80000000
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_GCLK_BYPASS_SHIFT    31
#define REG_PHY_RXFD_REG41_EFFECTIVE_SNR_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_MASK     0x00001fff
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH0_RANK0_WIDTH    13

/* PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0          0x00108
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_MASK     0x1fff0000
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG42_EFFECTIVE_SNR_TH1_RANK0_WIDTH    13

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH2_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH2_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH2_RANK0_MASK     0x00001fff
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH2_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH2_RANK0_WIDTH    13

/* PHY_RXFD_REG43_EFFECTIVE_SNR_TH3_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH3_RANK0          0x0010C
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH3_RANK0_MASK     0x1fff0000
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH3_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG43_EFFECTIVE_SNR_TH3_RANK0_WIDTH    13

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH4_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH4_RANK0          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH4_RANK0_MASK     0x00001fff
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH4_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH4_RANK0_WIDTH    13

/* PHY_RXFD_REG44_EFFECTIVE_SNR_TH5_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH5_RANK0          0x00110
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH5_RANK0_MASK     0x1fff0000
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH5_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG44_EFFECTIVE_SNR_TH5_RANK0_WIDTH    13

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK0          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK0_MASK     0x00001fff
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK0_SHIFT    0
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH6_RANK0_WIDTH    13

/* PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK0 */
/* effective_snr */
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK0          0x00114
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK0_MASK     0x1fff0000
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK0_SHIFT    16
#define REG_PHY_RXFD_REG45_EFFECTIVE_SNR_TH7_RANK0_WIDTH    13

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH0_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH0_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH0_RANK1_MASK     0x00001fff
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH0_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH0_RANK1_WIDTH    13

/* PHY_RXFD_REG46_EFFECTIVE_SNR_TH1_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH1_RANK1          0x00118
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH1_RANK1_MASK     0x1fff0000
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH1_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG46_EFFECTIVE_SNR_TH1_RANK1_WIDTH    13

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH2_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH2_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH2_RANK1_MASK     0x00001fff
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH2_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH2_RANK1_WIDTH    13

/* PHY_RXFD_REG47_EFFECTIVE_SNR_TH3_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH3_RANK1          0x0011C
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH3_RANK1_MASK     0x1fff0000
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH3_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG47_EFFECTIVE_SNR_TH3_RANK1_WIDTH    13

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH4_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH4_RANK1          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH4_RANK1_MASK     0x00001fff
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH4_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH4_RANK1_WIDTH    13

/* PHY_RXFD_REG48_EFFECTIVE_SNR_TH5_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH5_RANK1          0x00120
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH5_RANK1_MASK     0x1fff0000
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH5_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG48_EFFECTIVE_SNR_TH5_RANK1_WIDTH    13

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK1          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK1_MASK     0x00001fff
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK1_SHIFT    0
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH6_RANK1_WIDTH    13

/* PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK1 */
/* effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK1          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK1_MASK     0x1fff0000
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK1_SHIFT    16
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_TH7_RANK1_WIDTH    13

/* PHY_RXFD_REG49_DILUTION_EN */
/* effective_snr_dilution_en */
#define REG_PHY_RXFD_REG49_DILUTION_EN          0x00124
#define REG_PHY_RXFD_REG49_DILUTION_EN_MASK     0x20000000
#define REG_PHY_RXFD_REG49_DILUTION_EN_SHIFT    29
#define REG_PHY_RXFD_REG49_DILUTION_EN_WIDTH    1

/* PHY_RXFD_REG49_EFFECTIVE_SNR_EN */
/* enable effective_snr */
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_EN          0x00124
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_EN_MASK     0x40000000
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_EN_SHIFT    30
#define REG_PHY_RXFD_REG49_EFFECTIVE_SNR_EN_WIDTH    1

/* PHY_RXFD_REG49_IMPL_CHANN_PRE_GCLK_BYPASS */
/* impl_chann_pre_gclk_bypass */
#define REG_PHY_RXFD_REG49_IMPL_CHANN_PRE_GCLK_BYPASS          0x00124
#define REG_PHY_RXFD_REG49_IMPL_CHANN_PRE_GCLK_BYPASS_MASK     0x80000000
#define REG_PHY_RXFD_REG49_IMPL_CHANN_PRE_GCLK_BYPASS_SHIFT    31
#define REG_PHY_RXFD_REG49_IMPL_CHANN_PRE_GCLK_BYPASS_WIDTH    1

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_NUMBER_OF_GROUPS */
/* impl_chann_pre_cb or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_NUMBER_OF_GROUPS          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_NUMBER_OF_GROUPS_MASK     0x0000001f
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_NUMBER_OF_GROUPS_SHIFT    0
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_OFFSET */
/* impl_chann_pre_cb or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_OFFSET          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_OFFSET_MASK     0x000000e0
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_OFFSET_SHIFT    5
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_GROUP_OFFSET */
/* impl_chann_pre_cb or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_GROUP_OFFSET          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_GROUP_OFFSET_MASK     0x00000f00
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_GROUP_OFFSET_SHIFT    8
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_JUMP */
/* impl_chann_pre_cb or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_JUMP          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_JUMP_MASK     0x0000f000
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_JUMP_SHIFT    12
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_CB_NCB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_NUMBER_OF_GROUPS */
/* impl_chann_pre_leg_dup1 or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_NUMBER_OF_GROUPS          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_NUMBER_OF_GROUPS_MASK     0x001f0000
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_NUMBER_OF_GROUPS_SHIFT    16
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_OFFSET */
/* impl_chann_pre_leg_dup1 or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_OFFSET          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_OFFSET_MASK     0x00e00000
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_OFFSET_SHIFT    21
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_GROUP_OFFSET */
/* impl_chann_pre_leg_dup1 or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_GROUP_OFFSET          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_GROUP_OFFSET_MASK     0x0f000000
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_GROUP_OFFSET_SHIFT    24
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_JUMP */
/* impl_chann_pre_leg_dup1 or ncb */
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_JUMP          0x00128
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_JUMP_MASK     0xf0000000
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_JUMP_SHIFT    28
#define REG_PHY_RXFD_REG4A_IMPL_CHANN_PRE_LEG_DUP1_NCB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_NUMBER_OF_GROUPS */
/* impl_chann_pre_leg_dup2 */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_NUMBER_OF_GROUPS          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_NUMBER_OF_GROUPS_MASK     0x0000001f
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_NUMBER_OF_GROUPS_SHIFT    0
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_OFFSET */
/* impl_chann_pre_leg_dup2 */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_OFFSET          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_OFFSET_MASK     0x000000e0
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_OFFSET_SHIFT    5
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_GROUP_OFFSET */
/* impl_chann_pre_leg_dup2 */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_GROUP_OFFSET          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_GROUP_OFFSET_MASK     0x00000f00
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_GROUP_OFFSET_SHIFT    8
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_JUMP */
/* impl_chann_pre_leg_dup2 */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_JUMP          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_JUMP_MASK     0x0000f000
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_JUMP_SHIFT    12
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_LEG_DUP2_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_NUMBER_OF_GROUPS */
/* impl_chann_pre_ht_usb */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_NUMBER_OF_GROUPS          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_NUMBER_OF_GROUPS_MASK     0x001f0000
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_NUMBER_OF_GROUPS_SHIFT    16
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_OFFSET */
/* impl_chann_pre_ht_usb */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_OFFSET          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_OFFSET_MASK     0x00e00000
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_OFFSET_SHIFT    21
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_GROUP_OFFSET */
/* impl_chann_pre_ht_usb */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_GROUP_OFFSET          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_GROUP_OFFSET_MASK     0x0f000000
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_GROUP_OFFSET_SHIFT    24
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_JUMP */
/* impl_chann_pre_ht_usb */
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_JUMP          0x0012C
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_JUMP_MASK     0xf0000000
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_JUMP_SHIFT    28
#define REG_PHY_RXFD_REG4B_IMPL_CHANN_PRE_HT_USB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_NUMBER_OF_GROUPS */
/* impl_chann_pre_ht_lsb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_NUMBER_OF_GROUPS          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_NUMBER_OF_GROUPS_MASK     0x0000001f
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_NUMBER_OF_GROUPS_SHIFT    0
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_OFFSET */
/* impl_chann_pre_ht_lsb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_OFFSET          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_OFFSET_MASK     0x000000e0
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_OFFSET_SHIFT    5
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_GROUP_OFFSET */
/* impl_chann_pre_ht_lsb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_GROUP_OFFSET          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_GROUP_OFFSET_MASK     0x00000f00
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_GROUP_OFFSET_SHIFT    8
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_JUMP */
/* impl_chann_pre_ht_lsb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_JUMP          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_JUMP_MASK     0x0000f000
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_JUMP_SHIFT    12
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_HT_LSB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_NUMBER_OF_GROUPS */
/* impl_chann_pre_leg_usb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_NUMBER_OF_GROUPS          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_NUMBER_OF_GROUPS_MASK     0x001f0000
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_NUMBER_OF_GROUPS_SHIFT    16
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_OFFSET */
/* impl_chann_pre_leg_usb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_OFFSET          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_OFFSET_MASK     0x00e00000
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_OFFSET_SHIFT    21
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_GROUP_OFFSET */
/* impl_chann_pre_leg_usb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_GROUP_OFFSET          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_GROUP_OFFSET_MASK     0x0f000000
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_GROUP_OFFSET_SHIFT    24
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_JUMP */
/* impl_chann_pre_leg_usb */
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_JUMP          0x00130
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_JUMP_MASK     0xf0000000
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_JUMP_SHIFT    28
#define REG_PHY_RXFD_REG4C_IMPL_CHANN_PRE_LEG_USB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_NUMBER_OF_GROUPS */
/* impl_chann_pre_leg_lsb */
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_NUMBER_OF_GROUPS          0x00134
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_NUMBER_OF_GROUPS_MASK     0x0000001f
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_NUMBER_OF_GROUPS_SHIFT    0
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_NUMBER_OF_GROUPS_WIDTH    5

/* PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_OFFSET */
/* impl_chann_pre_leg_lsb */
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_OFFSET          0x00134
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_OFFSET_MASK     0x000000e0
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_OFFSET_SHIFT    5
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_OFFSET_WIDTH    3

/* PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_GROUP_OFFSET */
/* impl_chann_pre_leg_lsb */
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_GROUP_OFFSET          0x00134
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_GROUP_OFFSET_MASK     0x00000f00
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_GROUP_OFFSET_SHIFT    8
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_GROUP_OFFSET_WIDTH    4

/* PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_JUMP */
/* impl_chann_pre_leg_lsb */
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_JUMP          0x00134
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_JUMP_MASK     0x0000f000
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_JUMP_SHIFT    12
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_LEG_LSB_CARRIER_JUMP_WIDTH    4

/* PHY_RXFD_REG4D_IMPL_CHANN_PRE_DUP_NUM_OF_GROUP_CHANGE */
/* impl_chann_pre_dup_num_of_group_change */
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_DUP_NUM_OF_GROUP_CHANGE          0x00134
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_DUP_NUM_OF_GROUP_CHANGE_MASK     0x001f0000
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_DUP_NUM_OF_GROUP_CHANGE_SHIFT    16
#define REG_PHY_RXFD_REG4D_IMPL_CHANN_PRE_DUP_NUM_OF_GROUP_CHANGE_WIDTH    5

/* PHY_RXFD_REG4D_LEGACY_DISABLE_QR_SNIFF_FIX  */
/* bug fix in hyp3_5 qr sniif  */
#define REG_PHY_RXFD_REG4D_LEGACY_DISABLE_QR_SNIFF_FIX           0x00134
#define REG_PHY_RXFD_REG4D_LEGACY_DISABLE_QR_SNIFF_FIX_MASK     0x00400000
#define REG_PHY_RXFD_REG4D_LEGACY_DISABLE_QR_SNIFF_FIX_SHIFT    22
#define REG_PHY_RXFD_REG4D_LEGACY_DISABLE_QR_SNIFF_FIX_WIDTH    1

/* PHY_RXFD_REG4D_CH_PRE_GROUP_DILUTION */
/* ch_pre_group_dilution */
#define REG_PHY_RXFD_REG4D_CH_PRE_GROUP_DILUTION          0x00134
#define REG_PHY_RXFD_REG4D_CH_PRE_GROUP_DILUTION_MASK     0x00800000
#define REG_PHY_RXFD_REG4D_CH_PRE_GROUP_DILUTION_SHIFT    23
#define REG_PHY_RXFD_REG4D_CH_PRE_GROUP_DILUTION_WIDTH    1

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_11          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_11_MASK     0x00000007
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_11_SHIFT    0
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_11_WIDTH    3

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_21          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_21_MASK     0x00000070
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_21_SHIFT    4
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_21_WIDTH    3

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_31          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_31_MASK     0x00000700
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_31_SHIFT    8
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_31_WIDTH    3

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_12          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_12_MASK     0x00007000
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_12_SHIFT    12
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_12_WIDTH    3

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_22          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_22_MASK     0x00070000
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_22_SHIFT    16
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_22_WIDTH    3

/* PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_32          0x0013C
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_32_MASK     0x00700000
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_32_SHIFT    20
#define REG_PHY_RXFD_REG4F_SPMAP_RANK2_MATRIX0_32_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_11          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_11_MASK     0x00000007
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_11_SHIFT    0
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_11_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_21          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_21_MASK     0x00000070
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_21_SHIFT    4
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_21_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_31          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_31_MASK     0x00000700
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_31_SHIFT    8
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_31_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_12          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_12_MASK     0x00007000
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_12_SHIFT    12
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_12_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_22          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_22_MASK     0x00070000
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_22_SHIFT    16
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_22_WIDTH    3

/* PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_32          0x00140
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_32_MASK     0x00700000
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_32_SHIFT    20
#define REG_PHY_RXFD_REG50_SPMAP_RANK2_MATRIX1_32_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_11          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_11_MASK     0x00000007
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_11_SHIFT    0
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_11_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_21          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_21_MASK     0x00000070
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_21_SHIFT    4
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_21_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_31          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_31_MASK     0x00000700
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_31_SHIFT    8
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_31_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_12          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_12_MASK     0x00007000
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_12_SHIFT    12
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_12_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_22          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_22_MASK     0x00070000
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_22_SHIFT    16
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_22_WIDTH    3

/* PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_32          0x00144
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_32_MASK     0x00700000
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_32_SHIFT    20
#define REG_PHY_RXFD_REG51_SPMAP_RANK2_MATRIX2_32_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_11          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_11_MASK     0x00000007
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_11_SHIFT    0
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_11_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_21          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_21_MASK     0x00000070
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_21_SHIFT    4
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_21_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_31          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_31_MASK     0x00000700
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_31_SHIFT    8
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_31_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_12          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_12_MASK     0x00007000
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_12_SHIFT    12
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_12_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_22          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_22_MASK     0x00070000
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_22_SHIFT    16
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_22_WIDTH    3

/* PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_32          0x00148
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_32_MASK     0x00700000
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_32_SHIFT    20
#define REG_PHY_RXFD_REG52_SPMAP_RANK2_MATRIX3_32_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_11          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_11_MASK     0x00000007
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_11_SHIFT    0
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_11_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_21          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_21_MASK     0x00000070
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_21_SHIFT    4
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_21_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_31          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_31_MASK     0x00000700
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_31_SHIFT    8
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_31_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_12          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_12_MASK     0x00007000
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_12_SHIFT    12
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_12_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_22          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_22_MASK     0x00070000
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_22_SHIFT    16
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_22_WIDTH    3

/* PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_32          0x0014C
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_32_MASK     0x00700000
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_32_SHIFT    20
#define REG_PHY_RXFD_REG53_SPMAP_RANK2_MATRIX4_32_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_11          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_11_MASK     0x00000007
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_11_SHIFT    0
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_11_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_21          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_21_MASK     0x00000070
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_21_SHIFT    4
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_21_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_31          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_31_MASK     0x00000700
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_31_SHIFT    8
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_31_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_12          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_12_MASK     0x00007000
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_12_SHIFT    12
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_12_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_22          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_22_MASK     0x00070000
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_22_SHIFT    16
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_22_WIDTH    3

/* PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_32          0x00150
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_32_MASK     0x00700000
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_32_SHIFT    20
#define REG_PHY_RXFD_REG54_SPMAP_RANK2_MATRIX5_32_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_11          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_11_MASK     0x00000007
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_11_SHIFT    0
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_11_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_21          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_21_MASK     0x00000070
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_21_SHIFT    4
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_21_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_31          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_31_MASK     0x00000700
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_31_SHIFT    8
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_31_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_12          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_12_MASK     0x00007000
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_12_SHIFT    12
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_12_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_22          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_22_MASK     0x00070000
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_22_SHIFT    16
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_22_WIDTH    3

/* PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_32          0x00154
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_32_MASK     0x00700000
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_32_SHIFT    20
#define REG_PHY_RXFD_REG55_SPMAP_RANK2_MATRIX6_32_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_11          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_11_MASK     0x00000007
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_11_SHIFT    0
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_11_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_21          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_21_MASK     0x00000070
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_21_SHIFT    4
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_21_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_31          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_31_MASK     0x00000700
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_31_SHIFT    8
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_31_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_12          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_12_MASK     0x00007000
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_12_SHIFT    12
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_12_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_22          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_22_MASK     0x00070000
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_22_SHIFT    16
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_22_WIDTH    3

/* PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_32          0x00158
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_32_MASK     0x00700000
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_32_SHIFT    20
#define REG_PHY_RXFD_REG56_SPMAP_RANK2_MATRIX7_32_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_11          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_11_MASK     0x00000007
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_11_SHIFT    0
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_11_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_21          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_21_MASK     0x00000070
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_21_SHIFT    4
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_21_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_31          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_31_MASK     0x00000700
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_31_SHIFT    8
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_31_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_12          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_12_MASK     0x00007000
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_12_SHIFT    12
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_12_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_22          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_22_MASK     0x00070000
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_22_SHIFT    16
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_22_WIDTH    3

/* PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_32          0x0015C
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_32_MASK     0x00700000
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_32_SHIFT    20
#define REG_PHY_RXFD_REG57_SPMAP_RANK2_MATRIX8_32_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_11          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_11_MASK     0x00000007
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_11_SHIFT    0
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_11_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_21          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_21_MASK     0x00000070
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_21_SHIFT    4
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_21_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_31          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_31_MASK     0x00000700
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_31_SHIFT    8
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_31_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_12          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_12_MASK     0x00007000
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_12_SHIFT    12
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_12_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_22          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_22_MASK     0x00070000
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_22_SHIFT    16
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_22_WIDTH    3

/* PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_32          0x00160
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_32_MASK     0x00700000
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_32_SHIFT    20
#define REG_PHY_RXFD_REG58_SPMAP_RANK2_MATRIX9_32_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_11          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_11_MASK     0x00000007
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_11_SHIFT    0
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_11_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_21          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_21_MASK     0x00000070
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_21_SHIFT    4
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_21_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_31          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_31_MASK     0x00000700
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_31_SHIFT    8
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_31_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_12          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_12_MASK     0x00007000
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_12_SHIFT    12
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_12_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_22          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_22_MASK     0x00070000
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_22_SHIFT    16
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_22_WIDTH    3

/* PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_32          0x00164
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_32_MASK     0x00700000
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_32_SHIFT    20
#define REG_PHY_RXFD_REG59_SPMAP_RANK2_MATRIX10_32_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_11          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_11_SHIFT    0
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_11_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_21          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_21_SHIFT    4
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_21_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_31          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_31_SHIFT    8
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_31_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_12          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_12_MASK     0x00007000
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_12_SHIFT    12
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_12_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_22          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_22_MASK     0x00070000
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_22_SHIFT    16
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_22_WIDTH    3

/* PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_32          0x00168
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_32_MASK     0x00700000
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_32_SHIFT    20
#define REG_PHY_RXFD_REG5A_SPMAP_RANK2_MATRIX11_32_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_11          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_11_SHIFT    0
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_11_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_21          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_21_SHIFT    4
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_21_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_31          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_31_SHIFT    8
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_31_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_12          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_12_MASK     0x00007000
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_12_SHIFT    12
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_12_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_22          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_22_MASK     0x00070000
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_22_SHIFT    16
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_22_WIDTH    3

/* PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_32          0x0016C
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_32_MASK     0x00700000
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_32_SHIFT    20
#define REG_PHY_RXFD_REG5B_SPMAP_RANK2_MATRIX12_32_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_11          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_11_SHIFT    0
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_11_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_21          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_21_SHIFT    4
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_21_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_31          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_31_SHIFT    8
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_31_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_12          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_12_MASK     0x00007000
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_12_SHIFT    12
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_12_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_22          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_22_MASK     0x00070000
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_22_SHIFT    16
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_22_WIDTH    3

/* PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_32          0x00170
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_32_MASK     0x00700000
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_32_SHIFT    20
#define REG_PHY_RXFD_REG5C_SPMAP_RANK2_MATRIX13_32_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_11          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_11_SHIFT    0
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_11_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_21          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_21_SHIFT    4
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_21_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_31          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_31_SHIFT    8
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_31_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_12          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_12_MASK     0x00007000
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_12_SHIFT    12
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_12_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_22          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_22_MASK     0x00070000
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_22_SHIFT    16
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_22_WIDTH    3

/* PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_32          0x00174
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_32_MASK     0x00700000
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_32_SHIFT    20
#define REG_PHY_RXFD_REG5D_SPMAP_RANK2_MATRIX14_32_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_11          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_11_SHIFT    0
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_11_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_21          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_21_SHIFT    4
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_21_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_31          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_31_SHIFT    8
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_31_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_12 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_12          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_12_MASK     0x00007000
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_12_SHIFT    12
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_12_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_22 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_22          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_22_MASK     0x00070000
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_22_SHIFT    16
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_22_WIDTH    3

/* PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_32 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_32          0x00178
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_32_MASK     0x00700000
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_32_SHIFT    20
#define REG_PHY_RXFD_REG5E_SPMAP_RANK2_MATRIX15_32_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_11          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_11_MASK     0x00000007
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_11_SHIFT    0
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_11_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_21          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_21_MASK     0x00000070
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_21_SHIFT    4
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_21_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_31          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_31_MASK     0x00000700
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_31_SHIFT    8
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX0_31_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_11          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_11_MASK     0x00007000
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_11_SHIFT    12
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_11_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_21          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_21_MASK     0x00070000
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_21_SHIFT    16
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_21_WIDTH    3

/* PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_31          0x0017C
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_31_MASK     0x00700000
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_31_SHIFT    20
#define REG_PHY_RXFD_REG5F_SPMAP_RANK1_MATRIX1_31_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_11          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_11_MASK     0x00000007
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_11_SHIFT    0
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_11_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_21          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_21_MASK     0x00000070
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_21_SHIFT    4
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_21_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_31          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_31_MASK     0x00000700
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_31_SHIFT    8
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX2_31_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_11          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_11_MASK     0x00007000
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_11_SHIFT    12
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_11_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_21          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_21_MASK     0x00070000
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_21_SHIFT    16
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_21_WIDTH    3

/* PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_31          0x00180
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_31_MASK     0x00700000
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_31_SHIFT    20
#define REG_PHY_RXFD_REG60_SPMAP_RANK1_MATRIX3_31_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_11          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_11_MASK     0x00000007
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_11_SHIFT    0
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_11_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_21          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_21_MASK     0x00000070
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_21_SHIFT    4
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_21_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_31          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_31_MASK     0x00000700
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_31_SHIFT    8
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX4_31_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_11          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_11_MASK     0x00007000
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_11_SHIFT    12
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_11_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_21          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_21_MASK     0x00070000
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_21_SHIFT    16
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_21_WIDTH    3

/* PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_31          0x00184
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_31_MASK     0x00700000
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_31_SHIFT    20
#define REG_PHY_RXFD_REG61_SPMAP_RANK1_MATRIX5_31_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_11          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_11_MASK     0x00000007
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_11_SHIFT    0
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_11_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_21          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_21_MASK     0x00000070
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_21_SHIFT    4
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_21_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_31          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_31_MASK     0x00000700
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_31_SHIFT    8
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX6_31_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_11          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_11_MASK     0x00007000
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_11_SHIFT    12
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_11_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_21          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_21_MASK     0x00070000
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_21_SHIFT    16
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_21_WIDTH    3

/* PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_31          0x00188
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_31_MASK     0x00700000
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_31_SHIFT    20
#define REG_PHY_RXFD_REG62_SPMAP_RANK1_MATRIX7_31_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_11          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_11_MASK     0x00000007
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_11_SHIFT    0
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_11_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_21          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_21_MASK     0x00000070
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_21_SHIFT    4
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_21_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_31          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_31_MASK     0x00000700
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_31_SHIFT    8
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX8_31_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_11          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_11_MASK     0x00007000
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_11_SHIFT    12
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_11_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_21          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_21_MASK     0x00070000
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_21_SHIFT    16
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_21_WIDTH    3

/* PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_31          0x0018C
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_31_MASK     0x00700000
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_31_SHIFT    20
#define REG_PHY_RXFD_REG63_SPMAP_RANK1_MATRIX9_31_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_11          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_11_MASK     0x00000007
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_11_SHIFT    0
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_11_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_21          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_21_MASK     0x00000070
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_21_SHIFT    4
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_21_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_31          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_31_MASK     0x00000700
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_31_SHIFT    8
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX10_31_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_11          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_11_MASK     0x00007000
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_11_SHIFT    12
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_11_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_21          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_21_MASK     0x00070000
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_21_SHIFT    16
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_21_WIDTH    3

/* PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_31          0x00190
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_31_MASK     0x00700000
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_31_SHIFT    20
#define REG_PHY_RXFD_REG64_SPMAP_RANK1_MATRIX11_31_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_11          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_11_MASK     0x00000007
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_11_SHIFT    0
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_11_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_21          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_21_MASK     0x00000070
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_21_SHIFT    4
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_21_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_31          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_31_MASK     0x00000700
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_31_SHIFT    8
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX12_31_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_11          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_11_MASK     0x00007000
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_11_SHIFT    12
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_11_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_21          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_21_MASK     0x00070000
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_21_SHIFT    16
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_21_WIDTH    3

/* PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_31          0x00194
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_31_MASK     0x00700000
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_31_SHIFT    20
#define REG_PHY_RXFD_REG65_SPMAP_RANK1_MATRIX13_31_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_11          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_11_MASK     0x00000007
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_11_SHIFT    0
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_11_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_21          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_21_MASK     0x00000070
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_21_SHIFT    4
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_21_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_31          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_31_MASK     0x00000700
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_31_SHIFT    8
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX14_31_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_11 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_11          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_11_MASK     0x00007000
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_11_SHIFT    12
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_11_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_21 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_21          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_21_MASK     0x00070000
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_21_SHIFT    16
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_21_WIDTH    3

/* PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_31 */
/* spmap matrix index  */
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_31          0x00198
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_31_MASK     0x00700000
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_31_SHIFT    20
#define REG_PHY_RXFD_REG66_SPMAP_RANK1_MATRIX15_31_WIDTH    3

/* PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_1SS_2TX */
/* sounding matrix index0 1SS */
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_1SS_2TX          0x0019C
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_1SS_2TX_MASK     0x00000007
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_1SS_2TX_SHIFT    0
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_1SS_2TX_WIDTH    3

/* PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_1SS_2TX */
/* sounding matrix index1 1SS */
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_1SS_2TX          0x0019C
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_1SS_2TX_MASK     0x00000070
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_1SS_2TX_SHIFT    4
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_1SS_2TX_WIDTH    3

/* PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_2SS_2TX */
/* sounding matrix index0 2SS */
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_2SS_2TX          0x0019C
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_2SS_2TX_MASK     0x00007000
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_2SS_2TX_SHIFT    12
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX0_2SS_2TX_WIDTH    3

/* PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_2SS_2TX */
/* sounding matrix index1 2SS */
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_2SS_2TX          0x0019C
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_2SS_2TX_MASK     0x00070000
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_2SS_2TX_SHIFT    16
#define REG_PHY_RXFD_REG67_SOUNDING_MTRX_IDX1_2SS_2TX_WIDTH    3

/* PHY_RXFD_REG67_CARRIER_TO_SOUNDING_GROUP_MULT */
/* const mult value for explicit rx mode  */
#define REG_PHY_RXFD_REG67_CARRIER_TO_SOUNDING_GROUP_MULT          0x0019C
#define REG_PHY_RXFD_REG67_CARRIER_TO_SOUNDING_GROUP_MULT_MASK     0x07f00000
#define REG_PHY_RXFD_REG67_CARRIER_TO_SOUNDING_GROUP_MULT_SHIFT    20
#define REG_PHY_RXFD_REG67_CARRIER_TO_SOUNDING_GROUP_MULT_WIDTH    7

/* PHY_RXFD_REG67_USE_ELTF_GAIN_FACTOR  */
/* gain extra ltf factor explicit rx mode  */
#define REG_PHY_RXFD_REG67_USE_ELTF_GAIN_FACTOR           0x0019C
#define REG_PHY_RXFD_REG67_USE_ELTF_GAIN_FACTOR_MASK     0x08000000
#define REG_PHY_RXFD_REG67_USE_ELTF_GAIN_FACTOR_SHIFT    27
#define REG_PHY_RXFD_REG67_USE_ELTF_GAIN_FACTOR_WIDTH    1

/* PHY_RXFD_REG68_NUM_OF_LNA_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_MASK     0x00000003
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_SHIFT    0
#define REG_PHY_RXFD_REG68_NUM_OF_LNA_VALUES_WIDTH    2

/* PHY_RXFD_REG68_NUM_OF_PGC1_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_MASK     0x000000fc
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_SHIFT    2
#define REG_PHY_RXFD_REG68_NUM_OF_PGC1_VALUES_WIDTH    6

/* PHY_RXFD_REG68_NUM_OF_PGC2_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_MASK     0x00003f00
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_SHIFT    8
#define REG_PHY_RXFD_REG68_NUM_OF_PGC2_VALUES_WIDTH    6

/* PHY_RXFD_REG68_NUM_OF_PGC3_VALUES */
/* sounding group decimation shift value for sounding matrix selection */
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES          0x001A0
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_MASK     0x000fc000
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_SHIFT    14
#define REG_PHY_RXFD_REG68_NUM_OF_PGC3_VALUES_WIDTH    6

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_1SS_3TX */
/* sounding matrix index0 1SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_1SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_1SS_3TX_MASK     0x00000007
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_1SS_3TX_SHIFT    0
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_1SS_3TX_WIDTH    3

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_1SS_3TX */
/* sounding matrix index1 1SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_1SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_1SS_3TX_MASK     0x00000070
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_1SS_3TX_SHIFT    4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_1SS_3TX_WIDTH    3

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_1SS_3TX */
/* sounding matrix index1 1SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_1SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_1SS_3TX_MASK     0x00000700
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_1SS_3TX_SHIFT    8
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_1SS_3TX_WIDTH    3

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_2SS_3TX */
/* sounding matrix index0 2SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_2SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_2SS_3TX_MASK     0x00007000
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_2SS_3TX_SHIFT    12
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX0_2SS_3TX_WIDTH    3

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_2SS_3TX */
/* sounding matrix index1 2SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_2SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_2SS_3TX_MASK     0x00070000
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_2SS_3TX_SHIFT    16
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX1_2SS_3TX_WIDTH    3

/* PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_2SS_3TX */
/* sounding matrix index2 2SS */
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_2SS_3TX          0x001A4
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_2SS_3TX_MASK     0x00700000
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_2SS_3TX_SHIFT    20
#define REG_PHY_RXFD_REG69_SOUNDING_MTRX_IDX2_2SS_3TX_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K1 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K1          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K1_MASK     0x00000007
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K1_SHIFT    0
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K1_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K2 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K2          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K2_MASK     0x00000038
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K2_SHIFT    3
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K2_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K3 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K3          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K3_MASK     0x000001c0
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K3_SHIFT    6
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K3_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K4 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K4          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K4_MASK     0x00000e00
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K4_SHIFT    9
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K4_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K5 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K5          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K5_MASK     0x00007000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K5_SHIFT    12
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K5_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K6 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K6          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K6_MASK     0x00038000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K6_SHIFT    15
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K6_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K7 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K7          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K7_MASK     0x001c0000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K7_SHIFT    18
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K7_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K8 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K8          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K8_MASK     0x00e00000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K8_SHIFT    21
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K8_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K9 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K9          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K9_MASK     0x07000000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K9_SHIFT    24
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K9_WIDTH    3

/* PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K10 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K10          0x001A8
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K10_MASK     0x38000000
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K10_SHIFT    27
#define REG_PHY_RXFD_REG6A_EXPL_HT_CB_NCB_K10_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K11 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K11          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K11_MASK     0x00000007
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K11_SHIFT    0
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K11_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K12 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K12          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K12_MASK     0x00000038
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K12_SHIFT    3
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K12_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K13 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K13          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K13_MASK     0x000001c0
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K13_SHIFT    6
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K13_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K14 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K14          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K14_MASK     0x00000e00
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K14_SHIFT    9
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K14_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K15 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K15          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K15_MASK     0x00007000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K15_SHIFT    12
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K15_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K16 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K16          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K16_MASK     0x00038000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K16_SHIFT    15
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K16_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K17 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K17          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K17_MASK     0x001c0000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K17_SHIFT    18
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K17_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K18 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K18          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K18_MASK     0x00e00000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K18_SHIFT    21
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K18_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K19 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K19          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K19_MASK     0x07000000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K19_SHIFT    24
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K19_WIDTH    3

/* PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K20 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K20          0x001AC
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K20_MASK     0x38000000
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K20_SHIFT    27
#define REG_PHY_RXFD_REG6B_EXPL_HT_CB_NCB_K20_WIDTH    3

/* PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K21 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K21          0x001B0
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K21_MASK     0x00000007
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K21_SHIFT    0
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K21_WIDTH    3

/* PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K22 */
/* const value of the cb ncb mode per group  */
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K22          0x001B0
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K22_MASK     0x00000038
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K22_SHIFT    3
#define REG_PHY_RXFD_REG6C_EXPL_HT_CB_NCB_K22_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K1 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K1          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K1_MASK     0x00000007
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K1_SHIFT    0
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K1_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K2 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K2          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K2_MASK     0x00000038
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K2_SHIFT    3
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K2_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K3 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K3          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K3_MASK     0x000001c0
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K3_SHIFT    6
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K3_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K4 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K4          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K4_MASK     0x00000e00
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K4_SHIFT    9
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K4_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K5 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K5          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K5_MASK     0x00007000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K5_SHIFT    12
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K5_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K6 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K6          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K6_MASK     0x00038000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K6_SHIFT    15
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K6_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K7 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K7          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K7_MASK     0x001c0000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K7_SHIFT    18
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K7_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K8 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K8          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K8_MASK     0x00e00000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K8_SHIFT    21
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K8_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K9 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K9          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K9_MASK     0x07000000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K9_SHIFT    24
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K9_WIDTH    3

/* PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K10 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K10          0x001B4
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K10_MASK     0x38000000
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K10_SHIFT    27
#define REG_PHY_RXFD_REG6D_EXPL_LEG_DUP_NCB_K10_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K11 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K11          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K11_MASK     0x00000007
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K11_SHIFT    0
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K11_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K12 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K12          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K12_MASK     0x00000038
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K12_SHIFT    3
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K12_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K13 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K13          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K13_MASK     0x000001c0
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K13_SHIFT    6
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K13_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K14 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K14          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K14_MASK     0x00000e00
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K14_SHIFT    9
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K14_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K15 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K15          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K15_MASK     0x00007000
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K15_SHIFT    12
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K15_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K16 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K16          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K16_MASK     0x00038000
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K16_SHIFT    15
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K16_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K17 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K17          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K17_MASK     0x001c0000
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K17_SHIFT    18
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K17_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K18 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K18          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K18_MASK     0x00e00000
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K18_SHIFT    21
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K18_WIDTH    3

/* PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K19 */
/* const value of the leg dup or  ncb mode per group  */
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K19          0x001B8
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K19_MASK     0x07000000
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K19_SHIFT    24
#define REG_PHY_RXFD_REG6E_EXPL_LEG_DUP_NCB_K19_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K1 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K1          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K1_MASK     0x00000007
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K1_SHIFT    0
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K1_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K2 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K2          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K2_MASK     0x00000038
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K2_SHIFT    3
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K2_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K3 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K3          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K3_MASK     0x000001c0
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K3_SHIFT    6
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K3_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K4 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K4          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K4_MASK     0x00000e00
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K4_SHIFT    9
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K4_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K5 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K5          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K5_MASK     0x00007000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K5_SHIFT    12
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K5_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K6 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K6          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K6_MASK     0x00038000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K6_SHIFT    15
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K6_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K7 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K7          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K7_MASK     0x001c0000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K7_SHIFT    18
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K7_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K8 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K8          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K8_MASK     0x00e00000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K8_SHIFT    21
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K8_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K9 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K9          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K9_MASK     0x07000000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K9_SHIFT    24
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K9_WIDTH    3

/* PHY_RXFD_REG6F_EXPL_HT_USB_K10 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K10          0x001BC
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K10_MASK     0x38000000
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K10_SHIFT    27
#define REG_PHY_RXFD_REG6F_EXPL_HT_USB_K10_WIDTH    3

/* PHY_RXFD_REG70_EXPL_HT_USB_K11 */
/* const value of the lht usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_HT_USB_K11          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_HT_USB_K11_MASK     0x00000007
#define REG_PHY_RXFD_REG70_EXPL_HT_USB_K11_SHIFT    0
#define REG_PHY_RXFD_REG70_EXPL_HT_USB_K11_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K1 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K1          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K1_MASK     0x00000038
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K1_SHIFT    3
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K1_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K2 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K2          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K2_MASK     0x000001c0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K2_SHIFT    6
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K2_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K3 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K3          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K3_MASK     0x00000e00
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K3_SHIFT    9
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K3_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K4 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K4          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K4_MASK     0x00007000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K4_SHIFT    12
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K4_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K5 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K5          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K5_MASK     0x00038000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K5_SHIFT    15
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K5_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K6 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K6          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K6_MASK     0x001c0000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K6_SHIFT    18
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K6_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K7 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K7          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K7_MASK     0x00e00000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K7_SHIFT    21
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K7_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K8 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K8          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K8_MASK     0x07000000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K8_SHIFT    24
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K8_WIDTH    3

/* PHY_RXFD_REG70_EXPL_LEG_USB_K9 */
/* const value of the leg usb  mode per group  */
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K9          0x001C0
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K9_MASK     0x38000000
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K9_SHIFT    27
#define REG_PHY_RXFD_REG70_EXPL_LEG_USB_K9_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K1 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K1          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K1_MASK     0x00000007
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K1_SHIFT    0
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K1_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K2 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K2          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K2_MASK     0x00000038
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K2_SHIFT    3
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K2_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K3 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K3          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K3_MASK     0x000001c0
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K3_SHIFT    6
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K3_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K4 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K4          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K4_MASK     0x00000e00
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K4_SHIFT    9
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K4_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K5 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K5          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K5_MASK     0x00007000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K5_SHIFT    12
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K5_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K6 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K6          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K6_MASK     0x00038000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K6_SHIFT    15
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K6_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K7 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K7          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K7_MASK     0x001c0000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K7_SHIFT    18
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K7_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K8 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K8          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K8_MASK     0x00e00000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K8_SHIFT    21
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K8_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K9 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K9          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K9_MASK     0x07000000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K9_SHIFT    24
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K9_WIDTH    3

/* PHY_RXFD_REG71_EXPL_HT_LSB_K10 */
/* const value of the lht lsb  mode per group  */
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K10          0x001C4
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K10_MASK     0x38000000
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K10_SHIFT    27
#define REG_PHY_RXFD_REG71_EXPL_HT_LSB_K10_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K1 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K1          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K1_MASK     0x00000007
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K1_SHIFT    0
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K1_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K2 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K2          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K2_MASK     0x00000038
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K2_SHIFT    3
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K2_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K3 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K3          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K3_MASK     0x000001c0
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K3_SHIFT    6
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K3_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K4 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K4          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K4_MASK     0x00000e00
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K4_SHIFT    9
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K4_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K5 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K5          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K5_MASK     0x00007000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K5_SHIFT    12
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K5_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K6 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K6          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K6_MASK     0x00038000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K6_SHIFT    15
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K6_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K7 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K7          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K7_MASK     0x001c0000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K7_SHIFT    18
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K7_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K8 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K8          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K8_MASK     0x00e00000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K8_SHIFT    21
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K8_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K9 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K9          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K9_MASK     0x07000000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K9_SHIFT    24
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K9_WIDTH    3

/* PHY_RXFD_REG72_EXPL_LEG_LSB_K10 */
/* const value of the leg lsb  mode per group  */
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K10          0x001C8
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K10_MASK     0x38000000
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K10_SHIFT    27
#define REG_PHY_RXFD_REG72_EXPL_LEG_LSB_K10_WIDTH    3

/* PHY_RXFD_REG73_QR_GCLK_DISABLE */
/* qr_gclk_disable */
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE          0x001CC
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_MASK     0x0000007f
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_SHIFT    0
#define REG_PHY_RXFD_REG73_QR_GCLK_DISABLE_WIDTH    7

/* PHY_RXFD_REG73_SLICER_GCLK_DISABLE */
/* slicer_gclk_disable */
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE          0x001CC
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_MASK     0x00ffff80
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_SHIFT    7
#define REG_PHY_RXFD_REG73_SLICER_GCLK_DISABLE_WIDTH    17

/* PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE */
/* hyp_rxfd_gclk_disable */
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE          0x001D0
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_MASK     0x0003fffe
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_SHIFT    1
#define REG_PHY_RXFD_REG74_HYP_RXFD_GCLK_DISABLE_WIDTH    17

/* PHY_RXFD_REG74_MEM_GLOBAL_RM */
/* mem_global_rm */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_MASK     0x000c0000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_SHIFT    18
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RM_WIDTH    2

/* PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS */
/* mem_global_bist_scr_bypass */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_MASK     0x00100000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_SHIFT    20
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_BIST_SCR_BYPASS_WIDTH    1

/* PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE */
/* mem_global_ram_test_mode */
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE          0x001D0
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_MASK     0x00200000
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_SHIFT    21
#define REG_PHY_RXFD_REG74_MEM_GLOBAL_RAM_TEST_MODE_WIDTH    1
#endif 
