/*******************************************************************
*                                                                  
*  PHY_RX_TD_IF_Risc_Page_0_txb.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef PHY_RX_TD_IF_Risc_Page_0_txb_regs_H_FILE
#define PHY_RX_TD_IF_Risc_Page_0_txb_regs_H_FILE

/* PHY_TXB_RISC_REG1C0_TRC_N1 */
/* Scaling fix parameters */
#define REG_PHY_TXB_RISC_REG1C0_TRC_N1          0x10700
#define REG_PHY_TXB_RISC_REG1C0_TRC_N1_MASK     0x00000007
#define REG_PHY_TXB_RISC_REG1C0_TRC_N1_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C0_TRC_N1_WIDTH    3

/* PHY_TXB_RISC_REG1C0_TRC_MULT_3 */
/* TRC mult 3 of fix input */
#define REG_PHY_TXB_RISC_REG1C0_TRC_MULT_3          0x10700
#define REG_PHY_TXB_RISC_REG1C0_TRC_MULT_3_MASK     0x00000008
#define REG_PHY_TXB_RISC_REG1C0_TRC_MULT_3_SHIFT    3
#define REG_PHY_TXB_RISC_REG1C0_TRC_MULT_3_WIDTH    1

/* PHY_TXB_RISC_REG1C0_RRC_N1_ANT0 */
/* Scaling fix parameters */
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT0          0x10700
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT0_MASK     0x00000070
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT0_SHIFT    4
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT0_WIDTH    3

/* PHY_TXB_RISC_REG1C0_RRC_N1_ANT1 */
/* Scaling fix parameters */
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT1          0x10700
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT1_MASK     0x00000700
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT1_SHIFT    8
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT1_WIDTH    3

/* PHY_TXB_RISC_REG1C0_RRC_N1_ANT2 */
/* Scaling fix parameters */
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT2          0x10700
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT2_MASK     0x00007000
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT2_SHIFT    12
#define REG_PHY_TXB_RISC_REG1C0_RRC_N1_ANT2_WIDTH    3

/* PHY_TXB_RISC_REG1C1_DCC_STEP */
/* Step size */
#define REG_PHY_TXB_RISC_REG1C1_DCC_STEP          0x10704
#define REG_PHY_TXB_RISC_REG1C1_DCC_STEP_MASK     0x0000001f
#define REG_PHY_TXB_RISC_REG1C1_DCC_STEP_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C1_DCC_STEP_WIDTH    5

/* PHY_TXB_RISC_REG1C1_DCC_MODE */
/* Noram, Silent or Freeze */
#define REG_PHY_TXB_RISC_REG1C1_DCC_MODE          0x10704
#define REG_PHY_TXB_RISC_REG1C1_DCC_MODE_MASK     0x000000c0
#define REG_PHY_TXB_RISC_REG1C1_DCC_MODE_SHIFT    6
#define REG_PHY_TXB_RISC_REG1C1_DCC_MODE_WIDTH    2

/* PHY_TXB_RISC_REG1C1_DCC_UPDATE_RATE */
/* log2(rate) */
#define REG_PHY_TXB_RISC_REG1C1_DCC_UPDATE_RATE          0x10704
#define REG_PHY_TXB_RISC_REG1C1_DCC_UPDATE_RATE_MASK     0x00000f00
#define REG_PHY_TXB_RISC_REG1C1_DCC_UPDATE_RATE_SHIFT    8
#define REG_PHY_TXB_RISC_REG1C1_DCC_UPDATE_RATE_WIDTH    4

/* PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_EN */
/* Enable frequency shift */
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_EN          0x10704
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_EN_MASK     0x00004000
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_EN_SHIFT    14
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_EN_WIDTH    1

/* PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_MODE */
/* Shift requency by +10MHZ/-10MHz */
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_MODE          0x10704
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_MODE_MASK     0x00008000
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_MODE_SHIFT    15
#define REG_PHY_TXB_RISC_REG1C1_RX_FREQ_SHIFT_MODE_WIDTH    1

/* PHY_TXB_RISC_REG1C2_DCC_REF */
/* unsigned */
#define REG_PHY_TXB_RISC_REG1C2_DCC_REF          0x10708
#define REG_PHY_TXB_RISC_REG1C2_DCC_REF_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1C2_DCC_REF_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C2_DCC_REF_WIDTH    16

/* PHY_TXB_RISC_REG1C4_DETECTOR_THRESHOLD */
/* Detectors threshold. */
#define REG_PHY_TXB_RISC_REG1C4_DETECTOR_THRESHOLD          0x10710
#define REG_PHY_TXB_RISC_REG1C4_DETECTOR_THRESHOLD_MASK     0x0000007f
#define REG_PHY_TXB_RISC_REG1C4_DETECTOR_THRESHOLD_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C4_DETECTOR_THRESHOLD_WIDTH    7

/* PHY_TXB_RISC_REG1C4_DET_11B_EN_BYPASS */
/* Enables activating the 11b detectors using GenRisc - in Rx mode */
#define REG_PHY_TXB_RISC_REG1C4_DET_11B_EN_BYPASS          0x10710
#define REG_PHY_TXB_RISC_REG1C4_DET_11B_EN_BYPASS_MASK     0x00000100
#define REG_PHY_TXB_RISC_REG1C4_DET_11B_EN_BYPASS_SHIFT    8
#define REG_PHY_TXB_RISC_REG1C4_DET_11B_EN_BYPASS_WIDTH    1

/* PHY_TXB_RISC_REG1C4_RISC_IF2BIU_GCLK_BYPASS_EN */
/* Enables gclk bypass on the gclk of risc_if2biu module */
#define REG_PHY_TXB_RISC_REG1C4_RISC_IF2BIU_GCLK_BYPASS_EN          0x10710
#define REG_PHY_TXB_RISC_REG1C4_RISC_IF2BIU_GCLK_BYPASS_EN_MASK     0x00000200
#define REG_PHY_TXB_RISC_REG1C4_RISC_IF2BIU_GCLK_BYPASS_EN_SHIFT    9
#define REG_PHY_TXB_RISC_REG1C4_RISC_IF2BIU_GCLK_BYPASS_EN_WIDTH    1

/* PHY_TXB_RISC_REG1C5_SW_RESET_N_REG */
/* Control which module is in reset state: 
[0] -detectors_11b 
[1] -modem_11b
[2] -modem_11b_rx
[3] -modem_11b_tx
[4] -tx_env
[5] -rx_env0  // Enable / Disable Rx antenna bit
[6] -rx_env1  // Not used
[7] -rx_env2  // Not used
[8] -rx_env_global
[9] -best_ras
[10]- risc_if2biu */
#define REG_PHY_TXB_RISC_REG1C5_SW_RESET_N_REG          0x10714
#define REG_PHY_TXB_RISC_REG1C5_SW_RESET_N_REG_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1C5_SW_RESET_N_REG_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C5_SW_RESET_N_REG_WIDTH    10

/* PHY_TXB_RISC_REG1C6_SUBLOCK_ENABLE */
/* Block enable to Modem 11b TX,RX, Detector 0, Detector 1, Detector 2 
[0] -detectors_11b 
[1] -modem_11b
[2] -modem_11b_rx
[3] -modem_11b_tx
[4] -tx_env
[5] -rx_env0
[6] -rx_env1
[7] -rx_env2
[8] -rx_env_global
[9] -best_ras
[10]- risc_if2biu */
#define REG_PHY_TXB_RISC_REG1C6_SUBLOCK_ENABLE          0x10718
#define REG_PHY_TXB_RISC_REG1C6_SUBLOCK_ENABLE_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1C6_SUBLOCK_ENABLE_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C6_SUBLOCK_ENABLE_WIDTH    10

/* PHY_TXB_RISC_REG1C7_SW_RESET_N_GEN */
/* Control which module will be reset when SW reset cycle is generated:
[0] -detectors_11b 
[1] -modem_11b
[2] -modem_11b_rx
[3] -modem_11b_tx
[4] -tx_env
[5] -rx_env0
[6] -rx_env1
[7] -rx_env2
[8] -rx_env_global
[9] -best_ras
[10]- risc_if2biu */
#define REG_PHY_TXB_RISC_REG1C7_SW_RESET_N_GEN          0x1071C
#define REG_PHY_TXB_RISC_REG1C7_SW_RESET_N_GEN_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1C7_SW_RESET_N_GEN_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C7_SW_RESET_N_GEN_WIDTH    10

/* PHY_TXB_RISC_REG1C8_GSM_RESET_GEN_44 */
/* Control which module will be reset when GSM reset cycle is generated.
[0] -detectors_11b
[1] -modem_11b
[2] -modem_11b_rx
[3] -modem_11b_tx */
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_GEN_44          0x10720
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_GEN_44_MASK     0x0000000f
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_GEN_44_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_GEN_44_WIDTH    4

/* PHY_TXB_RISC_REG1C8_GSM_RESET_TX_GEN */
/* Control which module will be reset when tx GSM reset cycle is generated.
[0] -tx_env
[1] -rx_env0
[2] -rx_env1
[3] -rx_env2
[4] -rx_env_global
[5] -best_ras */
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_TX_GEN          0x10720
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_TX_GEN_MASK     0x000003f0
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_TX_GEN_SHIFT    4
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_TX_GEN_WIDTH    6

/* PHY_TXB_RISC_REG1C8_GSM_RESET_RX_GEN */
/* Control which module will be reset when rx GSM reset cycle is generated.
[0] -tx_env
[1] -rx_env0
[2] -rx_env1
[3] -rx_env2
[4] -rx_env_global
[5] -best_ras */
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_RX_GEN          0x10720
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_RX_GEN_MASK     0x0000fc00
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_RX_GEN_SHIFT    10
#define REG_PHY_TXB_RISC_REG1C8_GSM_RESET_RX_GEN_WIDTH    6

/* PHY_TXB_RISC_REG1C9_TXB_RISC_INT_ENABLE */
/* Inerrupts:
[0]   = RAS detection
[1]   = Detector 0 detection
[2]   = Detector 1 detection
[3]   = Detector 2 detection
[4]   = phy_mac_rx_start_p
[5]   = phy_mac_rx_end_p
[6]   = SFD found
[7]   = EVM valid
[8]   = rrc_scale_sat
[9]   = trc_scale_sat
[10] = dcc_flag
[11] = phy_mac_tx_start_p
[12] = phy_mac_tx_end_p
[13] = phy_be_signal_11b_valid
[14] = phy_be_11b_end_of_packet
[15] = RAS finished */
#define REG_PHY_TXB_RISC_REG1C9_TXB_RISC_INT_ENABLE          0x10724
#define REG_PHY_TXB_RISC_REG1C9_TXB_RISC_INT_ENABLE_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1C9_TXB_RISC_INT_ENABLE_SHIFT    0
#define REG_PHY_TXB_RISC_REG1C9_TXB_RISC_INT_ENABLE_WIDTH    16

/* PHY_TXB_RISC_REG1CA_TXB_RISC_INT_STATUS */
/* Inerrupts:
[0]   = RAS detection
[1]   = Detector 0 detection
[2]   = Detector 1 detection
[3]   = Detector 2 detection
[4]   = phy_mac_rx_start_p
[5]   = phy_mac_rx_end_p
[6]   = SFD found
[7]   = EVM valid
[8]   = rrc_scale_sat
[9]   = trc_scale_sat
[10] = dcc_flag
[11] = phy_mac_tx_start_p
[12] = phy_mac_tx_end_p
[13] = phy_be_signal_11b_valid
[14] = phy_be_11b_end_of_packet
[15] = RAS finished */
#define REG_PHY_TXB_RISC_REG1CA_TXB_RISC_INT_STATUS          0x10728
#define REG_PHY_TXB_RISC_REG1CA_TXB_RISC_INT_STATUS_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1CA_TXB_RISC_INT_STATUS_SHIFT    0
#define REG_PHY_TXB_RISC_REG1CA_TXB_RISC_INT_STATUS_WIDTH    16

/* PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT */
/* Indicate RAS to choose antenna */
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT          0x1072C
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_MASK     0x00000010
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_SHIFT    4
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_WIDTH    1

/* PHY_TXB_RISC_REG1CB_DT_RAS_BLACKOUT_EN */
/* Indicate RAS to Enter into blackout period before each operation */
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_BLACKOUT_EN          0x1072C
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_BLACKOUT_EN_MASK     0x00000020
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_BLACKOUT_EN_SHIFT    5
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_BLACKOUT_EN_WIDTH    1

/* PHY_TXB_RISC_REG1CB_DT_BEST_EN */
/* Enable RAS best detection. */
#define REG_PHY_TXB_RISC_REG1CB_DT_BEST_EN          0x1072C
#define REG_PHY_TXB_RISC_REG1CB_DT_BEST_EN_MASK     0x00000040
#define REG_PHY_TXB_RISC_REG1CB_DT_BEST_EN_SHIFT    6
#define REG_PHY_TXB_RISC_REG1CB_DT_BEST_EN_WIDTH    1

/* PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_TH */
/* switch antennas after timeout usec after ras detection */
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_TH          0x1072C
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_TH_MASK     0x00000f80
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_TH_SHIFT    7
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_CHOOSE_ANT_TH_WIDTH    5

/* PHY_TXB_RISC_REG1CB_DT_RAS_PRE_DET_THR */
/* Threshold of number of samples (0-6) - should be less than thr2 */
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_PRE_DET_THR          0x1072C
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_PRE_DET_THR_MASK     0x00007000
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_PRE_DET_THR_SHIFT    12
#define REG_PHY_TXB_RISC_REG1CB_DT_RAS_PRE_DET_THR_WIDTH    3

/* PHY_TXB_RISC_REG1CC_DT_RAS_BLACKOUT_PERIOD */
/* from first detection to start of RAS (in 1/22 us) -max value 21 */
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_BLACKOUT_PERIOD          0x10730
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_BLACKOUT_PERIOD_MASK     0x0000001f
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_BLACKOUT_PERIOD_SHIFT    0
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_BLACKOUT_PERIOD_WIDTH    5

/* PHY_TXB_RISC_REG1CC_DT_RAS_TIMEOUT_TH */
/* Threshold (in us) for max duration with no detection before returning to IDLE */
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_TIMEOUT_TH          0x10730
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_TIMEOUT_TH_MASK     0x000003e0
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_TIMEOUT_TH_SHIFT    5
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_TIMEOUT_TH_WIDTH    5

/* PHY_TXB_RISC_REG1CC_DT_RAS_THR2 */
/* Threshold of number of samples (0-6) */
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_THR2          0x10730
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_THR2_MASK     0x00001c00
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_THR2_SHIFT    10
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_THR2_WIDTH    3

/* PHY_TXB_RISC_REG1CC_DT_RAS_SUM_NUM */
/* Number of last samples to be summed and compared to thr2 (2-6) */
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_SUM_NUM          0x10730
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_SUM_NUM_MASK     0x0000e000
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_SUM_NUM_SHIFT    13
#define REG_PHY_TXB_RISC_REG1CC_DT_RAS_SUM_NUM_WIDTH    3

/* PHY_TXB_RISC_REG1CD_MAC_TX_11B */
/* MAC TX 802.11B mode enable */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_11B          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_11B_MASK     0x00000001
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_11B_SHIFT    0
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_11B_WIDTH    1

/* PHY_TXB_RISC_REG1CD_MAC_TX_SOUNDING */
/* MAC sounding packet indication */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_SOUNDING          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_SOUNDING_MASK     0x00000002
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_SOUNDING_SHIFT    1
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_SOUNDING_WIDTH    1

/* PHY_TXB_RISC_REG1CD_MAC_TX_ANT_MODE */
/* MAC TX antenna mode */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_ANT_MODE          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_ANT_MODE_MASK     0x00000004
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_ANT_MODE_SHIFT    2
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_ANT_MODE_WIDTH    1

/* PHY_TXB_RISC_REG1CD_MAC_TX_MIMO_PS_STATE */
/* MAC TX MIMO PowerSave state */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_MIMO_PS_STATE          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_MIMO_PS_STATE_MASK     0x00000008
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_MIMO_PS_STATE_SHIFT    3
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_MIMO_PS_STATE_WIDTH    1

/* PHY_TXB_RISC_REG1CD_MAC_TX_POWER */
/* MAC TX power */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_POWER          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_POWER_MASK     0x000000f0
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_POWER_SHIFT    4
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_POWER_WIDTH    4

/* PHY_TXB_RISC_REG1CD_MAC_ANT_SELECT */
/* MAC antenna selection */
#define REG_PHY_TXB_RISC_REG1CD_MAC_ANT_SELECT          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_ANT_SELECT_MASK     0x00003f00
#define REG_PHY_TXB_RISC_REG1CD_MAC_ANT_SELECT_SHIFT    8
#define REG_PHY_TXB_RISC_REG1CD_MAC_ANT_SELECT_WIDTH    6

/* PHY_TXB_RISC_REG1CD_MAC_TX_NUM_ELTF */
/* MAC number of ELTF */
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_NUM_ELTF          0x10734
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_NUM_ELTF_MASK     0x0000c000
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_NUM_ELTF_SHIFT    14
#define REG_PHY_TXB_RISC_REG1CD_MAC_TX_NUM_ELTF_WIDTH    2

/* PHY_TXB_RISC_REG1CE_GRISC_STATE_IND */
/* Controls the internal state machine according to GenRISC:
0 - IDLE
1 - RX
2 - TX
3 - DETECT */
#define REG_PHY_TXB_RISC_REG1CE_GRISC_STATE_IND          0x10738
#define REG_PHY_TXB_RISC_REG1CE_GRISC_STATE_IND_MASK     0x00000003
#define REG_PHY_TXB_RISC_REG1CE_GRISC_STATE_IND_SHIFT    0
#define REG_PHY_TXB_RISC_REG1CE_GRISC_STATE_IND_WIDTH    2

/* PHY_TXB_RISC_REG1CE_CLK_CTRL_11B_STATE */
/* Read 11B clock control state:
0 - IDLE
1 - RX
2 - TX
3 - DETECT */
#define REG_PHY_TXB_RISC_REG1CE_CLK_CTRL_11B_STATE          0x10738
#define REG_PHY_TXB_RISC_REG1CE_CLK_CTRL_11B_STATE_MASK     0x00000030
#define REG_PHY_TXB_RISC_REG1CE_CLK_CTRL_11B_STATE_SHIFT    4
#define REG_PHY_TXB_RISC_REG1CE_CLK_CTRL_11B_STATE_WIDTH    2

/* PHY_TXB_RISC_REG1CE_MAC_TX_ANT */
/* MAC TX antenna select */
#define REG_PHY_TXB_RISC_REG1CE_MAC_TX_ANT          0x10738
#define REG_PHY_TXB_RISC_REG1CE_MAC_TX_ANT_MASK     0x00000300
#define REG_PHY_TXB_RISC_REG1CE_MAC_TX_ANT_SHIFT    8
#define REG_PHY_TXB_RISC_REG1CE_MAC_TX_ANT_WIDTH    2

/* PHY_TXB_RISC_REG1CE_TX_11B_ANT */
/* Selected 11b tx antenna */
#define REG_PHY_TXB_RISC_REG1CE_TX_11B_ANT          0x10738
#define REG_PHY_TXB_RISC_REG1CE_TX_11B_ANT_MASK     0x00000c00
#define REG_PHY_TXB_RISC_REG1CE_TX_11B_ANT_SHIFT    10
#define REG_PHY_TXB_RISC_REG1CE_TX_11B_ANT_WIDTH    2

/* PHY_TXB_RISC_REG1D0_DT_SIGNAL_Q0_HIGH */
/* antenna 0 signal quality high bits */
#define REG_PHY_TXB_RISC_REG1D0_DT_SIGNAL_Q0_HIGH          0x10740
#define REG_PHY_TXB_RISC_REG1D0_DT_SIGNAL_Q0_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1D0_DT_SIGNAL_Q0_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D0_DT_SIGNAL_Q0_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1D1_DT_SIGNAL_Q0_LOW */
/* antenna 0 signal quality low bits */
#define REG_PHY_TXB_RISC_REG1D1_DT_SIGNAL_Q0_LOW          0x10744
#define REG_PHY_TXB_RISC_REG1D1_DT_SIGNAL_Q0_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1D1_DT_SIGNAL_Q0_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D1_DT_SIGNAL_Q0_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1D2_DT_SIGNAL_Q1_HIGH */
/* antenna 1 signal quality high bits */
#define REG_PHY_TXB_RISC_REG1D2_DT_SIGNAL_Q1_HIGH          0x10748
#define REG_PHY_TXB_RISC_REG1D2_DT_SIGNAL_Q1_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1D2_DT_SIGNAL_Q1_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D2_DT_SIGNAL_Q1_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1D3_DT_SIGNAL_Q1_LOW */
/* antenna 1 signal quality low bits */
#define REG_PHY_TXB_RISC_REG1D3_DT_SIGNAL_Q1_LOW          0x1074C
#define REG_PHY_TXB_RISC_REG1D3_DT_SIGNAL_Q1_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1D3_DT_SIGNAL_Q1_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D3_DT_SIGNAL_Q1_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1D4_DT_SIGNAL_Q2_HIGH */
/* antenna 2 signal quality high bits */
#define REG_PHY_TXB_RISC_REG1D4_DT_SIGNAL_Q2_HIGH          0x10750
#define REG_PHY_TXB_RISC_REG1D4_DT_SIGNAL_Q2_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1D4_DT_SIGNAL_Q2_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D4_DT_SIGNAL_Q2_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1D5_DT_SIGNAL_Q2_LOW */
/* antenna 2 signal quality low bits */
#define REG_PHY_TXB_RISC_REG1D5_DT_SIGNAL_Q2_LOW          0x10754
#define REG_PHY_TXB_RISC_REG1D5_DT_SIGNAL_Q2_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1D5_DT_SIGNAL_Q2_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D5_DT_SIGNAL_Q2_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1D6_DT_POWER_0_HIGH */
/* antenna 0 detected power high bits */
#define REG_PHY_TXB_RISC_REG1D6_DT_POWER_0_HIGH          0x10758
#define REG_PHY_TXB_RISC_REG1D6_DT_POWER_0_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1D6_DT_POWER_0_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D6_DT_POWER_0_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1D7_DT_POWER_0_LOW */
/* antenna 0 detected power low bits */
#define REG_PHY_TXB_RISC_REG1D7_DT_POWER_0_LOW          0x1075C
#define REG_PHY_TXB_RISC_REG1D7_DT_POWER_0_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1D7_DT_POWER_0_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D7_DT_POWER_0_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1D8_DT_POWER_1_HIGH */
/* antenna 1 detected power high bits */
#define REG_PHY_TXB_RISC_REG1D8_DT_POWER_1_HIGH          0x10760
#define REG_PHY_TXB_RISC_REG1D8_DT_POWER_1_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1D8_DT_POWER_1_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D8_DT_POWER_1_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1D9_DT_POWER_1_LOW */
/* antenna 1 detected power low bits */
#define REG_PHY_TXB_RISC_REG1D9_DT_POWER_1_LOW          0x10764
#define REG_PHY_TXB_RISC_REG1D9_DT_POWER_1_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1D9_DT_POWER_1_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1D9_DT_POWER_1_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1DA_DT_POWER_2_HIGH */
/* antenna 2 detected power high bits */
#define REG_PHY_TXB_RISC_REG1DA_DT_POWER_2_HIGH          0x10768
#define REG_PHY_TXB_RISC_REG1DA_DT_POWER_2_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1DA_DT_POWER_2_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1DA_DT_POWER_2_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1DB_DT_POWER_2_LOW */
/* antenna 2 detected power low bits */
#define REG_PHY_TXB_RISC_REG1DB_DT_POWER_2_LOW          0x1076C
#define REG_PHY_TXB_RISC_REG1DB_DT_POWER_2_LOW_MASK     0x0000003f
#define REG_PHY_TXB_RISC_REG1DB_DT_POWER_2_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1DB_DT_POWER_2_LOW_WIDTH    6

/* PHY_TXB_RISC_REG1DC_BEST_DT_SIGNAL_Q */
/* Best antenna signal quality (log) */
#define REG_PHY_TXB_RISC_REG1DC_BEST_DT_SIGNAL_Q          0x10770
#define REG_PHY_TXB_RISC_REG1DC_BEST_DT_SIGNAL_Q_MASK     0x000001ff
#define REG_PHY_TXB_RISC_REG1DC_BEST_DT_SIGNAL_Q_SHIFT    0
#define REG_PHY_TXB_RISC_REG1DC_BEST_DT_SIGNAL_Q_WIDTH    9

/* PHY_TXB_RISC_REG1DE_BEST_DT_POWER */
/* Best antenna detected power(log) */
#define REG_PHY_TXB_RISC_REG1DE_BEST_DT_POWER          0x10778
#define REG_PHY_TXB_RISC_REG1DE_BEST_DT_POWER_MASK     0x000001ff
#define REG_PHY_TXB_RISC_REG1DE_BEST_DT_POWER_SHIFT    0
#define REG_PHY_TXB_RISC_REG1DE_BEST_DT_POWER_WIDTH    9

/* PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT0 */
/* calibration gain number */
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT0          0x1077C
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT0_MASK     0x0000000f
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT0_SHIFT    0
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT0_WIDTH    4

/* PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT1 */
/* calibration gain number */
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT1          0x1077C
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT1_MASK     0x000000f0
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT1_SHIFT    4
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT1_WIDTH    4

/* PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT2 */
/* calibration gain number */
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT2          0x1077C
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT2_MASK     0x00000f00
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT2_SHIFT    8
#define REG_PHY_TXB_RISC_REG1DF_BF_CAL_GAIN_INDEX_ANT2_WIDTH    4

/* PHY_TXB_RISC_REG1E0_BEST_DT_TX_ANT */
/* Best antenna for TX 11b */
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_TX_ANT          0x10780
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_TX_ANT_MASK     0x00000001
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_TX_ANT_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_TX_ANT_WIDTH    1

/* PHY_TXB_RISC_REG1E0_BEST_DT_RX_ANT */
/* Best antenna for RX 11b */
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_RX_ANT          0x10780
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_RX_ANT_MASK     0x00000006
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_RX_ANT_SHIFT    1
#define REG_PHY_TXB_RISC_REG1E0_BEST_DT_RX_ANT_WIDTH    2

/* PHY_TXB_RISC_REG1E0_PHY_BE_RX_B_ERRORSTAT */
/* The Error status from the modem Backend */
#define REG_PHY_TXB_RISC_REG1E0_PHY_BE_RX_B_ERRORSTAT          0x10780
#define REG_PHY_TXB_RISC_REG1E0_PHY_BE_RX_B_ERRORSTAT_MASK     0x00000030
#define REG_PHY_TXB_RISC_REG1E0_PHY_BE_RX_B_ERRORSTAT_SHIFT    4
#define REG_PHY_TXB_RISC_REG1E0_PHY_BE_RX_B_ERRORSTAT_WIDTH    2

/* PHY_TXB_RISC_REG1E1_TPC_0_ANALOG_GAIN */
/* Tx 0 analog again  */
#define REG_PHY_TXB_RISC_REG1E1_TPC_0_ANALOG_GAIN          0x10784
#define REG_PHY_TXB_RISC_REG1E1_TPC_0_ANALOG_GAIN_MASK     0x0000001f
#define REG_PHY_TXB_RISC_REG1E1_TPC_0_ANALOG_GAIN_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E1_TPC_0_ANALOG_GAIN_WIDTH    5

/* PHY_TXB_RISC_REG1E1_TPC_1_ANALOG_GAIN */
/* Tx 1 analog again  */
#define REG_PHY_TXB_RISC_REG1E1_TPC_1_ANALOG_GAIN          0x10784
#define REG_PHY_TXB_RISC_REG1E1_TPC_1_ANALOG_GAIN_MASK     0x000003E0
#define REG_PHY_TXB_RISC_REG1E1_TPC_1_ANALOG_GAIN_SHIFT    5
#define REG_PHY_TXB_RISC_REG1E1_TPC_1_ANALOG_GAIN_WIDTH    5

/* PHY_TXB_RISC_REG1E1_TPC_2_ANALOG_GAIN */
/* Tx 2 analog again  */
#define REG_PHY_TXB_RISC_REG1E1_TPC_2_ANALOG_GAIN          0x10784
#define REG_PHY_TXB_RISC_REG1E1_TPC_2_ANALOG_GAIN_MASK     0x00007C00
#define REG_PHY_TXB_RISC_REG1E1_TPC_2_ANALOG_GAIN_SHIFT    10
#define REG_PHY_TXB_RISC_REG1E1_TPC_2_ANALOG_GAIN_WIDTH    5

/* PHY_TXB_RISC_REG1E2_LDPC_N_CW */
/* Standard LDPC number of codewords */
#define REG_PHY_TXB_RISC_REG1E2_LDPC_N_CW          0x10788
#define REG_PHY_TXB_RISC_REG1E2_LDPC_N_CW_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1E2_LDPC_N_CW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E2_LDPC_N_CW_WIDTH    10

/* PHY_TXB_RISC_REG1E2_LDPC_CW_TYPE */
/* Standard LDPC Codeword type 0 - (Z = 27), 1 - (Z = 54), 2 - (Z = 81)
 */
#define REG_PHY_TXB_RISC_REG1E2_LDPC_CW_TYPE          0x10788
#define REG_PHY_TXB_RISC_REG1E2_LDPC_CW_TYPE_MASK     0x00003000
#define REG_PHY_TXB_RISC_REG1E2_LDPC_CW_TYPE_SHIFT    12
#define REG_PHY_TXB_RISC_REG1E2_LDPC_CW_TYPE_WIDTH    2

/* PHY_TXB_RISC_REG1E2_LDPC_PARAM_READY */
/* Standard LDPC parmeters ready pulse indication */
#define REG_PHY_TXB_RISC_REG1E2_LDPC_PARAM_READY          0x10788
#define REG_PHY_TXB_RISC_REG1E2_LDPC_PARAM_READY_MASK     0x00008000
#define REG_PHY_TXB_RISC_REG1E2_LDPC_PARAM_READY_SHIFT    15
#define REG_PHY_TXB_RISC_REG1E2_LDPC_PARAM_READY_WIDTH    1

/* PHY_TXB_RISC_REG1E3_LDPC_N_DATA */
/* Standard LDPC number of data bits in the first ldpc_rem_nshrt_ncw codewords */
#define REG_PHY_TXB_RISC_REG1E3_LDPC_N_DATA          0x1078C
#define REG_PHY_TXB_RISC_REG1E3_LDPC_N_DATA_MASK     0x000007ff
#define REG_PHY_TXB_RISC_REG1E3_LDPC_N_DATA_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E3_LDPC_N_DATA_WIDTH    11

/* PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_EN */
/* Enable frequency shift */
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_EN          0x10790
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_EN_MASK     0x00000001
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_EN_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_EN_WIDTH    1

/* PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_MODE */
/* Shift requency by +10MHZ/-10MHz */
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_MODE          0x10790
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_MODE_MASK     0x00000002
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_MODE_SHIFT    1
#define REG_PHY_TXB_RISC_REG1E4_DCC_FREQ_SHIFT_MODE_WIDTH    1

/* PHY_TXB_RISC_REG1E5_CORE_EVM_I */
/* Core EVM I */
#define REG_PHY_TXB_RISC_REG1E5_CORE_EVM_I          0x10794
#define REG_PHY_TXB_RISC_REG1E5_CORE_EVM_I_MASK     0x00003fff
#define REG_PHY_TXB_RISC_REG1E5_CORE_EVM_I_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E5_CORE_EVM_I_WIDTH    14

/* PHY_TXB_RISC_REG1E6_CORE_EVM_Q */
/* Core EVM Q */
#define REG_PHY_TXB_RISC_REG1E6_CORE_EVM_Q          0x10798
#define REG_PHY_TXB_RISC_REG1E6_CORE_EVM_Q_MASK     0x00003fff
#define REG_PHY_TXB_RISC_REG1E6_CORE_EVM_Q_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E6_CORE_EVM_Q_WIDTH    14

/* PHY_TXB_RISC_REG1E7_CORE_PSDU */
/* Core PSDU duration */
#define REG_PHY_TXB_RISC_REG1E7_CORE_PSDU          0x1079C
#define REG_PHY_TXB_RISC_REG1E7_CORE_PSDU_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1E7_CORE_PSDU_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E7_CORE_PSDU_WIDTH    16

/* PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F */
/* Gain scaling factor number 16 (f) */
#define REG_PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F          0x107A0
#define REG_PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F_MASK     0x000001ff
#define REG_PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F_WIDTH    9

/* PHY_TXB_RISC_REG1E9_HYP_TX_GPO */
/* spare registers */
#define REG_PHY_TXB_RISC_REG1E9_HYP_TX_GPO          0x107A4
#define REG_PHY_TXB_RISC_REG1E9_HYP_TX_GPO_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1E9_HYP_TX_GPO_SHIFT    0
#define REG_PHY_TXB_RISC_REG1E9_HYP_TX_GPO_WIDTH    16

/* PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET */
/* AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET          0x107A8
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET_MASK     0x000000ff
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET_SHIFT    0
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1EA_TX0_AFE_I_OFFSET */
/* AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_I_OFFSET          0x107A8
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_I_OFFSET_MASK     0x0000ff00
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_I_OFFSET_SHIFT    8
#define REG_PHY_TXB_RISC_REG1EA_TX0_AFE_I_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1EB_TX1_AFE_Q_OFFSET */
/* AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_Q_OFFSET          0x107AC
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_Q_OFFSET_MASK     0x000000ff
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_Q_OFFSET_SHIFT    0
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_Q_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1EB_TX1_AFE_I_OFFSET */
/* AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_I_OFFSET          0x107AC
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_I_OFFSET_MASK     0x0000ff00
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_I_OFFSET_SHIFT    8
#define REG_PHY_TXB_RISC_REG1EB_TX1_AFE_I_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY */
/* time, in system clocks from DETECT to RX state transition, after ras_finish indication */
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY          0x107B0
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_MASK     0x000000ff
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_SHIFT    0
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_WIDTH    8

/* PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_EN */
/* enable automatic transition from DETECT to RX state after ras_finish indication */
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_EN          0x107B0
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_EN_MASK     0x00000100
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_EN_SHIFT    8
#define REG_PHY_TXB_RISC_REG1EC_RAS_FINISH_TO_RX_DLY_EN_WIDTH    1

/* PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F */
/* Gain scaling factor number 16 (f) */
#define REG_PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F          0x107B4
#define REG_PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F_MASK     0x000001ff
#define REG_PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F_SHIFT    0
#define REG_PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F_WIDTH    9

/* PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F */
/* Gain scaling factor number 16 (f) */
#define REG_PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F          0x107B8
#define REG_PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F_MASK     0x000001ff
#define REG_PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F_SHIFT    0
#define REG_PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F_WIDTH    9

/* PHY_TXB_RISC_REG1EF_PHY_MAC_IF_TX_STATE */
/* States:
IDLE = 4'h0;
ENABLE_DLY = 4'h1;
ENABLE_PHY = 4'h3;
PHY_READY= 4'h2;
START_TRANSFER = 4'h6;
SAMPLE_MAC_DATA = 4'h7;
PHY_DATA_REQ_ST = 4'h5;
WAIT_PHY_DATA_CONF = 4'h4;
PHY_DATA_CONF_ST = 4'hc; 
CHECK_ENABLE = 4'he;
MAC_DISABLED = 4'hf;
DISABLE_PHY = 4'ha;
PHY_DISABLED = 4'h9;
PHY_DISABLED_STB = 4'h8;
 */
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_TX_STATE          0x107BC
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_TX_STATE_MASK     0x0000000f
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_TX_STATE_SHIFT    0
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_TX_STATE_WIDTH    4

/* PHY_TXB_RISC_REG1EF_PHY_MAC_IF_RX_STATE */
/* States:
IDLE = 4'h0;
ERROR_CHK = 4'h1;
PHY_STARTED = 4'h3;
PHY_STARTED_STB = 4'h2;
WAIT_PHY_DATA = 4'h6;
SMPL_PHY_DATA = 4'h7;
SEND_DATA_2_MAC = 4'h5;
DATA_FINISHED = 4'h4;
END_PACKET = 4'hc;
END_PACKET_STB = 4'h8;
 */
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_RX_STATE          0x107BC
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_RX_STATE_MASK     0x000000f0
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_RX_STATE_SHIFT    4
#define REG_PHY_TXB_RISC_REG1EF_PHY_MAC_IF_RX_STATE_WIDTH    4

/* PHY_TXB_RISC_REG1F0_MAC_TX_LENGTH */
/* MAC TX Packet Length */
#define REG_PHY_TXB_RISC_REG1F0_MAC_TX_LENGTH          0x107C0
#define REG_PHY_TXB_RISC_REG1F0_MAC_TX_LENGTH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1F0_MAC_TX_LENGTH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F0_MAC_TX_LENGTH_WIDTH    16

/* PHY_TXB_RISC_REG1F1_MAC_TX_CODE_RATE */
/* MAC TX Packet Code Rate */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CODE_RATE          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CODE_RATE_MASK     0x00000003
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CODE_RATE_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CODE_RATE_WIDTH    2

/* PHY_TXB_RISC_REG1F1_MAC_TX_MODULATION */
/* MAC TX Packet Modulation */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_MODULATION          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_MODULATION_MASK     0x0000000c
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_MODULATION_SHIFT    2
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_MODULATION_WIDTH    2

/* PHY_TXB_RISC_REG1F1_MAC_LDPC_MODE */
/* MAC TX Packet LDPC Mode Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_MODE          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_MODE_MASK     0x00000010
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_MODE_SHIFT    4
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_MODE_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_LDPC_TYPE */
/* MAC TX Packet LDPC Type (0-Legacy 1-Standard) */
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_TYPE          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_TYPE_MASK     0x00000020
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_TYPE_SHIFT    5
#define REG_PHY_TXB_RISC_REG1F1_MAC_LDPC_TYPE_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_TX_STBC */
/* MAC TX Packet STBC Mode Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_STBC          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_STBC_MASK     0x00000040
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_STBC_SHIFT    6
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_STBC_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_TX_RANK */
/* MAC TX Packet Rand 2 Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_RANK          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_RANK_MASK     0x00000080
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_RANK_SHIFT    7
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_RANK_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_TX_HT_MODE */
/* MAC TX Packet HT Mode Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_HT_MODE          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_HT_MODE_MASK     0x00000100
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_HT_MODE_SHIFT    8
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_HT_MODE_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_TX_DUPLICATE */
/* MAC TX Packet Duplicate Mode Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_DUPLICATE          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_DUPLICATE_MASK     0x00000200
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_DUPLICATE_SHIFT    9
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_DUPLICATE_WIDTH    1

/* PHY_TXB_RISC_REG1F1_MAC_TX_CH_BOND */
/* MAC TX Packet Channel Bonding Enable */
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CH_BOND          0x107C4
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CH_BOND_MASK     0x00000400
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CH_BOND_SHIFT    10
#define REG_PHY_TXB_RISC_REG1F1_MAC_TX_CH_BOND_WIDTH    1

/* PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_1 */
/* MAC TX packet - cdd offset for ant 1 */
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_1          0x107C8
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_1_MASK     0x0000000F
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_1_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_1_WIDTH    4

/* PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_2 */
/* MAC TX packet - cdd offset for ant 2 */
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_2          0x107C8
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_2_MASK     0x000000F0
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_2_SHIFT    4
#define REG_PHY_TXB_RISC_REG1F2_MAC_CDD_OFST_2_WIDTH    4

/* PHY_TXB_RISC_REG1F2_MAC_SM_INDEX */
/* MAC TX packet - spatial matrix index */
#define REG_PHY_TXB_RISC_REG1F2_MAC_SM_INDEX          0x107C8
#define REG_PHY_TXB_RISC_REG1F2_MAC_SM_INDEX_MASK     0x00000F00
#define REG_PHY_TXB_RISC_REG1F2_MAC_SM_INDEX_SHIFT    8
#define REG_PHY_TXB_RISC_REG1F2_MAC_SM_INDEX_WIDTH    4

/* PHY_TXB_RISC_REG1F2_MAC_TX_IS_QBF */
/* MAC is QBF */
#define REG_PHY_TXB_RISC_REG1F2_MAC_TX_IS_QBF          0x107C8
#define REG_PHY_TXB_RISC_REG1F2_MAC_TX_IS_QBF_MASK     0x00001000
#define REG_PHY_TXB_RISC_REG1F2_MAC_TX_IS_QBF_SHIFT    12
#define REG_PHY_TXB_RISC_REG1F2_MAC_TX_IS_QBF_WIDTH    1

/* PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET */
/* Tx2 AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET          0x107CC
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET_MASK     0x000000FF
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1F3_TX2_AFE_Q_OFFSET */
/* Tx2 AFE offset on Magnitude Limit output */
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_Q_OFFSET          0x107CC
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_Q_OFFSET_MASK     0x0000FF00
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_Q_OFFSET_SHIFT    8
#define REG_PHY_TXB_RISC_REG1F3_TX2_AFE_Q_OFFSET_WIDTH    8

/* PHY_TXB_RISC_REG1F4_LDPC_REM_NSHRT_NCW */
/* Standard LDPC Shortening: Remainder of Nshrt/Ncw */
#define REG_PHY_TXB_RISC_REG1F4_LDPC_REM_NSHRT_NCW          0x107D0
#define REG_PHY_TXB_RISC_REG1F4_LDPC_REM_NSHRT_NCW_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1F4_LDPC_REM_NSHRT_NCW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F4_LDPC_REM_NSHRT_NCW_WIDTH    10

/* PHY_TXB_RISC_REG1F5_LDPC_N_PARITY */
/* Standard LDPC number of parity bits in the first ldpc_rem_npunc_ncw codewords  */
#define REG_PHY_TXB_RISC_REG1F5_LDPC_N_PARITY          0x107D4
#define REG_PHY_TXB_RISC_REG1F5_LDPC_N_PARITY_MASK     0x000007ff
#define REG_PHY_TXB_RISC_REG1F5_LDPC_N_PARITY_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F5_LDPC_N_PARITY_WIDTH    11

/* PHY_TXB_RISC_REG1F6_LDPC_REM_NPUNC_NCW */
/* Standard LDPC Puncturing: Remainder of Npunc/Ncw */
#define REG_PHY_TXB_RISC_REG1F6_LDPC_REM_NPUNC_NCW          0x107D8
#define REG_PHY_TXB_RISC_REG1F6_LDPC_REM_NPUNC_NCW_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1F6_LDPC_REM_NPUNC_NCW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F6_LDPC_REM_NPUNC_NCW_WIDTH    10

/* PHY_TXB_RISC_REG1F7_LDPC_N_REPEAT */
/* Standard LDPC number of repeat bits in the first ldpc_rem_nrep_ncw codewords  */
#define REG_PHY_TXB_RISC_REG1F7_LDPC_N_REPEAT          0x107DC
#define REG_PHY_TXB_RISC_REG1F7_LDPC_N_REPEAT_MASK     0x000007ff
#define REG_PHY_TXB_RISC_REG1F7_LDPC_N_REPEAT_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F7_LDPC_N_REPEAT_WIDTH    11

/* PHY_TXB_RISC_REG1F8_LDPC_REM_NREP_NCW */
/* Standard LDPC Repeating: Remainder of Nrep/Ncw */
#define REG_PHY_TXB_RISC_REG1F8_LDPC_REM_NREP_NCW          0x107E0
#define REG_PHY_TXB_RISC_REG1F8_LDPC_REM_NREP_NCW_MASK     0x000003ff
#define REG_PHY_TXB_RISC_REG1F8_LDPC_REM_NREP_NCW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F8_LDPC_REM_NREP_NCW_WIDTH    10

/* PHY_TXB_RISC_REG1F9_GEN_RISC_CLEAR */
/* gen_risc_clear */
#define REG_PHY_TXB_RISC_REG1F9_GEN_RISC_CLEAR          0x107E4
#define REG_PHY_TXB_RISC_REG1F9_GEN_RISC_CLEAR_MASK     0x00000001
#define REG_PHY_TXB_RISC_REG1F9_GEN_RISC_CLEAR_SHIFT    0
#define REG_PHY_TXB_RISC_REG1F9_GEN_RISC_CLEAR_WIDTH    1

/* PHY_TXB_RISC_REG1F9_MAC_SERVICE_DATA */
/* MAC TX 11b service */
#define REG_PHY_TXB_RISC_REG1F9_MAC_SERVICE_DATA          0x107E4
#define REG_PHY_TXB_RISC_REG1F9_MAC_SERVICE_DATA_MASK     0x00000ff0
#define REG_PHY_TXB_RISC_REG1F9_MAC_SERVICE_DATA_SHIFT    4
#define REG_PHY_TXB_RISC_REG1F9_MAC_SERVICE_DATA_WIDTH    8

/* PHY_TXB_RISC_REG1F9_MAC_PACKET_RATE */
/* MAC TX 11b packet rate */
#define REG_PHY_TXB_RISC_REG1F9_MAC_PACKET_RATE          0x107E4
#define REG_PHY_TXB_RISC_REG1F9_MAC_PACKET_RATE_MASK     0x00007000
#define REG_PHY_TXB_RISC_REG1F9_MAC_PACKET_RATE_SHIFT    12
#define REG_PHY_TXB_RISC_REG1F9_MAC_PACKET_RATE_WIDTH    3

/* PHY_TXB_RISC_REG1FA_GEN_RISC_WRITE_DATA_LOW */
/* data low from genrisc to reg file */
#define REG_PHY_TXB_RISC_REG1FA_GEN_RISC_WRITE_DATA_LOW          0x107E8
#define REG_PHY_TXB_RISC_REG1FA_GEN_RISC_WRITE_DATA_LOW_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FA_GEN_RISC_WRITE_DATA_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FA_GEN_RISC_WRITE_DATA_LOW_WIDTH    16

/* PHY_TXB_RISC_REG1FB_GEN_RISC_WRITE_DATA_HIGH */
/* data high from genrisc to reg file */
#define REG_PHY_TXB_RISC_REG1FB_GEN_RISC_WRITE_DATA_HIGH          0x107EC
#define REG_PHY_TXB_RISC_REG1FB_GEN_RISC_WRITE_DATA_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FB_GEN_RISC_WRITE_DATA_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FB_GEN_RISC_WRITE_DATA_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1FC_GEN_RISC_READ_DATA_LOW */
/* data low to genrisc from reg file */
#define REG_PHY_TXB_RISC_REG1FC_GEN_RISC_READ_DATA_LOW          0x107F0
#define REG_PHY_TXB_RISC_REG1FC_GEN_RISC_READ_DATA_LOW_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FC_GEN_RISC_READ_DATA_LOW_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FC_GEN_RISC_READ_DATA_LOW_WIDTH    16

/* PHY_TXB_RISC_REG1FD_GEN_RISC_READ_DATA_HIGH */
/* data high to genrisc from reg file */
#define REG_PHY_TXB_RISC_REG1FD_GEN_RISC_READ_DATA_HIGH          0x107F4
#define REG_PHY_TXB_RISC_REG1FD_GEN_RISC_READ_DATA_HIGH_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FD_GEN_RISC_READ_DATA_HIGH_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FD_GEN_RISC_READ_DATA_HIGH_WIDTH    16

/* PHY_TXB_RISC_REG1FE_GEN_RISC_READ_ADDRESS */
/* address from genrisc for toread from reg file */
#define REG_PHY_TXB_RISC_REG1FE_GEN_RISC_READ_ADDRESS          0x107F8
#define REG_PHY_TXB_RISC_REG1FE_GEN_RISC_READ_ADDRESS_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FE_GEN_RISC_READ_ADDRESS_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FE_GEN_RISC_READ_ADDRESS_WIDTH    16

/* PHY_TXB_RISC_REG1FF_GEN_RISC_WRITE_ADDRESS */
/* address from genrisc for to write to reg file */
#define REG_PHY_TXB_RISC_REG1FF_GEN_RISC_WRITE_ADDRESS          0x107FC
#define REG_PHY_TXB_RISC_REG1FF_GEN_RISC_WRITE_ADDRESS_MASK     0x0000ffff
#define REG_PHY_TXB_RISC_REG1FF_GEN_RISC_WRITE_ADDRESS_SHIFT    0
#define REG_PHY_TXB_RISC_REG1FF_GEN_RISC_WRITE_ADDRESS_WIDTH    16
#endif 
