/*******************************************************************
*                                                                  
*  PHY_Tx_MAC_Emu.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef PHY_Tx_MAC_Emu_regs_H_FILE
#define PHY_Tx_MAC_Emu_regs_H_FILE

/* TX_MAC_EMU_REG00_EMU_RUN */
/* Start MAC Emualtor transmit */
#define REG_TX_MAC_EMU_REG00_EMU_RUN          0x38000
#define REG_TX_MAC_EMU_REG00_EMU_RUN_MASK     0x00000001
#define REG_TX_MAC_EMU_REG00_EMU_RUN_SHIFT    0
#define REG_TX_MAC_EMU_REG00_EMU_RUN_WIDTH    1

/* TX_MAC_EMU_REG00_EMU_TX_DONE */
/* Start MAC Emualtor transmit Done */
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE          0x38000
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_MASK     0x00000002
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_SHIFT    1
#define REG_TX_MAC_EMU_REG00_EMU_TX_DONE_WIDTH    1

/* TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS */
/* Number of packets to transmit in every session. */
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS          0x38004
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_SHIFT    0
#define REG_TX_MAC_EMU_REG01_EMU_NUM_OF_PACKETS_WIDTH    24

/* TX_MAC_EMU_REG02_ENDLESS_MODE */
/* Transmit as if number of packets equal infinity */
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE          0x38008
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_MASK     0x00000001
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_SHIFT    0
#define REG_TX_MAC_EMU_REG02_ENDLESS_MODE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_IN_MODE */
/* Enable including of CRC word at end of data. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_MASK     0x00000002
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_SHIFT    1
#define REG_TX_MAC_EMU_REG02_EMU_CRC_IN_MODE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_INVERT */
/* Enable curruption of the CRC word. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_MASK     0x00000004
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_SHIFT    2
#define REG_TX_MAC_EMU_REG02_EMU_CRC_INVERT_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_CRC_REVERSE */
/* Insert the CRC bits from MSB to LSB. */
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_MASK     0x00000008
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_SHIFT    3
#define REG_TX_MAC_EMU_REG02_EMU_CRC_REVERSE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE */
/* Enable that the first N bytes will be taken  from the Prefix RAM */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_MASK     0x00000010
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_SHIFT    4
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_ENABLE_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_SET */
/* There are 2 sets of prefix data in the RAM. This selects which set. */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_MASK     0x00000020
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_SHIFT    5
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_SET_WIDTH    1

/* TX_MAC_EMU_REG02_EMU_PREFIX_LEN */
/* The number of prefix words to use. 0-63. 0=1 word, 63=64 words. */
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN          0x38008
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_MASK     0x00003F00
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_SHIFT    8
#define REG_TX_MAC_EMU_REG02_EMU_PREFIX_LEN_WIDTH    6

/* TX_MAC_EMU_REG03_EMU_LENGTH */
/* The length (in bytes) of the packet */
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH          0x3800C
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_MASK     0x0000FFFF
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_SHIFT    0
#define REG_TX_MAC_EMU_REG03_EMU_LENGTH_WIDTH    16

/* TX_MAC_EMU_REG04_EMU_CODE_RATE */
/* Set the next packets code rate */
#define REG_TX_MAC_EMU_REG04_EMU_CODE_RATE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_CODE_RATE_MASK     0x00000003
#define REG_TX_MAC_EMU_REG04_EMU_CODE_RATE_SHIFT    0
#define REG_TX_MAC_EMU_REG04_EMU_CODE_RATE_WIDTH    2

/* TX_MAC_EMU_REG04_EMU_MODULATION */
/* Set the next packets modulation */
#define REG_TX_MAC_EMU_REG04_EMU_MODULATION          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_MODULATION_MASK     0x0000000c
#define REG_TX_MAC_EMU_REG04_EMU_MODULATION_SHIFT    2
#define REG_TX_MAC_EMU_REG04_EMU_MODULATION_WIDTH    2

/* TX_MAC_EMU_REG04_EMU_TX_POWER */
/* select the TX power value */
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_MASK     0x000000F0
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_SHIFT    4
#define REG_TX_MAC_EMU_REG04_EMU_TX_POWER_WIDTH    4

/* TX_MAC_EMU_REG04_EMU_LDPC_MODE */
/* select the TX FEC Mode */
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_MASK     0x00000100
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_SHIFT    8
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_MODE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_SHORT_CP */
/* Enable packet with short cyclic prefix */
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_MASK     0x00000200
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_SHIFT    9
#define REG_TX_MAC_EMU_REG04_EMU_SHORT_CP_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_STBC */
/* Enable TX in STBC */
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_MASK     0x00000400
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_SHIFT    10
#define REG_TX_MAC_EMU_REG04_EMU_TX_STBC_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_RANK */
/* Enable Rank 2 */
#define REG_TX_MAC_EMU_REG04_EMU_TX_RANK          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_RANK_MASK     0x00000800
#define REG_TX_MAC_EMU_REG04_EMU_TX_RANK_SHIFT    11
#define REG_TX_MAC_EMU_REG04_EMU_TX_RANK_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_HT_MODE */
/* Enable TX in HT mode */
#define REG_TX_MAC_EMU_REG04_EMU_TX_HT_MODE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_HT_MODE_MASK     0x00001000
#define REG_TX_MAC_EMU_REG04_EMU_TX_HT_MODE_SHIFT    12
#define REG_TX_MAC_EMU_REG04_EMU_TX_HT_MODE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_DUPLICATE */
/* Enable TX in Duplicate mode */
#define REG_TX_MAC_EMU_REG04_EMU_TX_DUPLICATE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_DUPLICATE_MASK     0x00002000
#define REG_TX_MAC_EMU_REG04_EMU_TX_DUPLICATE_SHIFT    13
#define REG_TX_MAC_EMU_REG04_EMU_TX_DUPLICATE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_CH_BOND */
/* Enable TX Channel Bonding */
#define REG_TX_MAC_EMU_REG04_EMU_TX_CH_BOND          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_CH_BOND_MASK     0x00004000
#define REG_TX_MAC_EMU_REG04_EMU_TX_CH_BOND_SHIFT    14
#define REG_TX_MAC_EMU_REG04_EMU_TX_CH_BOND_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_11B_RATE */
/* Select 802.11B rate */
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_RATE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_RATE_MASK     0x00038000
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_RATE_SHIFT    15
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_RATE_WIDTH    3

/* TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE */
/* Enable TX MIMO Power save */
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_MASK     0x00040000
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_SHIFT    18
#define REG_TX_MAC_EMU_REG04_EMU_TX_MIMO_PS_STATE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_ANT_SELECT */
/* General Purpose IF bits */
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_MASK     0x01f80000
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_SHIFT    19
#define REG_TX_MAC_EMU_REG04_EMU_ANT_SELECT_WIDTH    6

/* TX_MAC_EMU_REG04_EMU_TX_11B */
/* Enable TX in 802.11B */
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_MASK     0x08000000
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_SHIFT    27
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_TX_11B_ANT */
/* Select the TX antenna */
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MASK     0x30000000
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_SHIFT    28
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_WIDTH    2

/* TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MODE */
/* TX Antenna select mode */
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MODE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MODE_MASK     0x40000000
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MODE_SHIFT    30
#define REG_TX_MAC_EMU_REG04_EMU_TX_11B_ANT_MODE_WIDTH    1

/* TX_MAC_EMU_REG04_EMU_LDPC_TYPE */
/* LDPC Type (0-Legacy 1-Standard) */
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_TYPE          0x38010
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_TYPE_MASK     0x80000000
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_TYPE_SHIFT    31
#define REG_TX_MAC_EMU_REG04_EMU_LDPC_TYPE_WIDTH    1

/* TX_MAC_EMU_REG05_EMU_CDD_OFST_1 */
/* TX cdd offset Antenna 1 */
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_MASK     0x0000000F
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_SHIFT    0
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_1_WIDTH    4

/* TX_MAC_EMU_REG05_EMU_CDD_OFST_2 */
/* TX cdd offset Antenna 2 */
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_MASK     0x000000F0
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_SHIFT    4
#define REG_TX_MAC_EMU_REG05_EMU_CDD_OFST_2_WIDTH    4

/* TX_MAC_EMU_REG05_EMU_SM_INDEX */
/* TX MAC Emulator - spatial matrix index */
#define REG_TX_MAC_EMU_REG05_EMU_SM_INDEX          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_SM_INDEX_MASK     0x00000F00
#define REG_TX_MAC_EMU_REG05_EMU_SM_INDEX_SHIFT    8
#define REG_TX_MAC_EMU_REG05_EMU_SM_INDEX_WIDTH    4

/* TX_MAC_EMU_REG05_EMU_IS_QBF */
/* TX MAC Emulator - is QBF indication */
#define REG_TX_MAC_EMU_REG05_EMU_IS_QBF          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_IS_QBF_MASK     0x00002000
#define REG_TX_MAC_EMU_REG05_EMU_IS_QBF_SHIFT    13
#define REG_TX_MAC_EMU_REG05_EMU_IS_QBF_WIDTH    1

/* TX_MAC_EMU_REG05_EMU_NUM_ELTF */
/* TX MAC Emulator - Extra LTF num */
#define REG_TX_MAC_EMU_REG05_EMU_NUM_ELTF          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_NUM_ELTF_MASK     0x0000c000
#define REG_TX_MAC_EMU_REG05_EMU_NUM_ELTF_SHIFT    14
#define REG_TX_MAC_EMU_REG05_EMU_NUM_ELTF_WIDTH    2

/* TX_MAC_EMU_REG05_EMU_SOUNDING */
/* TX MAC Emulator - sounding packet indication */
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING          0x38014
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_MASK     0x00010000
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_SHIFT    16
#define REG_TX_MAC_EMU_REG05_EMU_SOUNDING_WIDTH    1

/* TX_MAC_EMU_REG07_EMU_SIGNAL1 */
/* Set the next packets Signal #1 */
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1          0x3801C
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_SHIFT    0
#define REG_TX_MAC_EMU_REG07_EMU_SIGNAL1_WIDTH    24

/* TX_MAC_EMU_REG08_EMU_SIGNAL2 */
/* Set the next packets Signal #2 */
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2          0x38020
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_SHIFT    0
#define REG_TX_MAC_EMU_REG08_EMU_SIGNAL2_WIDTH    24

/* TX_MAC_EMU_REG09_EMU_SIGNAL3 */
/* Set the next packets Signal #3 */
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3          0x38024
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_SHIFT    0
#define REG_TX_MAC_EMU_REG09_EMU_SIGNAL3_WIDTH    24

/* TX_MAC_EMU_REG0A_EMU_PATTERN_MODE */
/* Set the next packets data pattern mode */
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_MASK     0x00000003
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_SHIFT    0
#define REG_TX_MAC_EMU_REG0A_EMU_PATTERN_MODE_WIDTH    2

/* TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR */
/* Enable insertion of PRBS Errors */
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_MASK     0x00000010
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_SHIFT    4
#define REG_TX_MAC_EMU_REG0A_EMU_INS_PRBS_ERR_WIDTH    1

/* TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM */
/* Set the error insertino rate */
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM          0x38028
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_MASK     0x0001FF00
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_SHIFT    8
#define REG_TX_MAC_EMU_REG0A_EMU_INS_ERR_NUM_WIDTH    9

/* TX_MAC_EMU_REG0B_EMU_PRBS_TYPE */
/* PRBS Polynom */
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE          0x3802C
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_SHIFT    0
#define REG_TX_MAC_EMU_REG0B_EMU_PRBS_TYPE_WIDTH    32

/* TX_MAC_EMU_REG0C_EMU_PRBS_INIT */
/* The PRBS init data word */
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT          0x38030
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_SHIFT    0
#define REG_TX_MAC_EMU_REG0C_EMU_PRBS_INIT_WIDTH    32

/* TX_MAC_EMU_REG0D_EMU_FIXED_DATA */
/* The TX Data for Fixed pattern mode */
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA          0x38034
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_SHIFT    0
#define REG_TX_MAC_EMU_REG0D_EMU_FIXED_DATA_WIDTH    32

/* TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY */
/* Delay (in clock cycles) between PHY Enable rize and Wait for PHY Ready state */
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY          0x38038
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_MASK     0x0000FFFF
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_SHIFT    0
#define REG_TX_MAC_EMU_REG0E_EMU_INIT2RDY_DLY_WIDTH    16

/* TX_MAC_EMU_REG0E_EMU_IPG_DLY */
/* Delay (in clock cycles) between a packet TX end to the next packet start. */
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY          0x38038
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_MASK     0xFFFF0000
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_SHIFT    16
#define REG_TX_MAC_EMU_REG0E_EMU_IPG_DLY_WIDTH    16

/* TX_MAC_EMU_REG10_PAC_PHY_TX_LENGTH_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG10_PAC_PHY_TX_LENGTH_D          0x38040
#define REG_TX_MAC_EMU_REG10_PAC_PHY_TX_LENGTH_D_MASK     0x0000FFFF
#define REG_TX_MAC_EMU_REG10_PAC_PHY_TX_LENGTH_D_SHIFT    0
#define REG_TX_MAC_EMU_REG10_PAC_PHY_TX_LENGTH_D_WIDTH    16

/* TX_MAC_EMU_REG11_PAC_PHY_TX_CODE_RATE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CODE_RATE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CODE_RATE_D_MASK     0x00000003
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CODE_RATE_D_SHIFT    0
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CODE_RATE_D_WIDTH    2

/* TX_MAC_EMU_REG11_PAC_PHY_TX_MODULATION_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MODULATION_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MODULATION_D_MASK     0x0000000c
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MODULATION_D_SHIFT    2
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MODULATION_D_WIDTH    2

/* TX_MAC_EMU_REG11_PAC_PHY_TX_POWER_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_POWER_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_POWER_D_MASK     0x000000F0
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_POWER_D_SHIFT    4
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_POWER_D_WIDTH    4

/* TX_MAC_EMU_REG11_PAC_PHY_LDPC_MODE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_MODE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_MODE_D_MASK     0x00000100
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_MODE_D_SHIFT    8
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_MODE_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_SHORT_CP_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_SHORT_CP_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_SHORT_CP_D_MASK     0x00000200
#define REG_TX_MAC_EMU_REG11_PAC_PHY_SHORT_CP_D_SHIFT    9
#define REG_TX_MAC_EMU_REG11_PAC_PHY_SHORT_CP_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_STBC_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_STBC_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_STBC_D_MASK     0x00000400
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_STBC_D_SHIFT    10
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_STBC_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_RANK_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_RANK_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_RANK_D_MASK     0x00000800
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_RANK_D_SHIFT    11
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_RANK_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_HT_MODE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_HT_MODE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_HT_MODE_D_MASK     0x00001000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_HT_MODE_D_SHIFT    12
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_HT_MODE_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_DUPLICATE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_DUPLICATE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_DUPLICATE_D_MASK     0x00002000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_DUPLICATE_D_SHIFT    13
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_DUPLICATE_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_CH_BOND_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CH_BOND_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CH_BOND_D_MASK     0x00004000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CH_BOND_D_SHIFT    14
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_CH_BOND_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_11B_RATE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_RATE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_RATE_D_MASK     0x00038000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_RATE_D_SHIFT    15
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_RATE_D_WIDTH    3

/* TX_MAC_EMU_REG11_PAC_PHY_TX_MIMO_PS_STATE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MIMO_PS_STATE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MIMO_PS_STATE_D_MASK     0x00040000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MIMO_PS_STATE_D_SHIFT    18
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_MIMO_PS_STATE_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_ANT_SELECT_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_ANT_SELECT_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_ANT_SELECT_D_MASK     0x01F80000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_ANT_SELECT_D_SHIFT    19
#define REG_TX_MAC_EMU_REG11_PAC_PHY_ANT_SELECT_D_WIDTH    6

/* TX_MAC_EMU_REG11_PAC_PHY_LDPC_TYPE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_TYPE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_TYPE_D_MASK     0x02000000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_TYPE_D_SHIFT    25
#define REG_TX_MAC_EMU_REG11_PAC_PHY_LDPC_TYPE_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_11B_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_D_MASK     0x08000000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_D_SHIFT    27
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_D_WIDTH    1

/* TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_D_MASK     0x30000000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_D_SHIFT    28
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_D_WIDTH    2

/* TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_MODE_D */
/* MAC TX Packet Configuration of the last packet, as sampled in the PHY. */
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_MODE_D          0x38044
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_MODE_D_MASK     0x40000000
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_MODE_D_SHIFT    30
#define REG_TX_MAC_EMU_REG11_PAC_PHY_TX_11B_ANT_MODE_D_WIDTH    1

/* TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC */
/* the synchronized version of pac_phy_tx_phy_enable */
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC          0x38044
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_MASK     0x80000000
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_SHIFT    31
#define REG_TX_MAC_EMU_REG11_MAC_PHY_ENABLE_SYNC_WIDTH    1

/* TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_1_D */
/* MAC Packet Config - cdd offset for ant1 */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_1_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_1_D_MASK     0x0000000F
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_1_D_SHIFT    0
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_1_D_WIDTH    4

/* TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_2_D */
/* MAC Packet Config - cdd offset for ant2 */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_2_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_2_D_MASK     0x000000F0
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_2_D_SHIFT    4
#define REG_TX_MAC_EMU_REG12_PAC_PHY_CDD_OFST_2_D_WIDTH    4

/* TX_MAC_EMU_REG12_PAC_PHY_SM_INDEX_D */
/* MAC Packet Config - spatial matrix index */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SM_INDEX_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SM_INDEX_D_MASK     0x00000F00
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SM_INDEX_D_SHIFT    8
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SM_INDEX_D_WIDTH    4

/* TX_MAC_EMU_REG12_PAC_PHY_IS_QBF_D */
/* MAC Packet Config - is QBF indication */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_IS_QBF_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_IS_QBF_D_MASK     0x00002000
#define REG_TX_MAC_EMU_REG12_PAC_PHY_IS_QBF_D_SHIFT    13
#define REG_TX_MAC_EMU_REG12_PAC_PHY_IS_QBF_D_WIDTH    1

/* TX_MAC_EMU_REG12_PAC_PHY_NUM_ELTF_D */
/* MAC Packet Config - number of extra LTF */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_NUM_ELTF_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_NUM_ELTF_D_MASK     0x0000c000
#define REG_TX_MAC_EMU_REG12_PAC_PHY_NUM_ELTF_D_SHIFT    14
#define REG_TX_MAC_EMU_REG12_PAC_PHY_NUM_ELTF_D_WIDTH    2

/* TX_MAC_EMU_REG12_PAC_PHY_SOUNDING_D */
/* MAC Packet Config - sounding packet indication */
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SOUNDING_D          0x38048
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SOUNDING_D_MASK     0x00010000
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SOUNDING_D_SHIFT    16
#define REG_TX_MAC_EMU_REG12_PAC_PHY_SOUNDING_D_WIDTH    1

/* TX_MAC_EMU_REG13_EMU_QBF_VECTOR0 */
/* TX MAC Emulator - QBF vecotor [31:0] */
#define REG_TX_MAC_EMU_REG13_EMU_QBF_VECTOR0          0x3804c
#define REG_TX_MAC_EMU_REG13_EMU_QBF_VECTOR0_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG13_EMU_QBF_VECTOR0_SHIFT    0
#define REG_TX_MAC_EMU_REG13_EMU_QBF_VECTOR0_WIDTH    32

/* TX_MAC_EMU_REG14_EMU_QBF_VECTOR1 */
/* TX MAC Emulator - QBF vecotor [63:32] */
#define REG_TX_MAC_EMU_REG14_EMU_QBF_VECTOR1          0x38050
#define REG_TX_MAC_EMU_REG14_EMU_QBF_VECTOR1_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG14_EMU_QBF_VECTOR1_SHIFT    0
#define REG_TX_MAC_EMU_REG14_EMU_QBF_VECTOR1_WIDTH    32

/* TX_MAC_EMU_REG15_EMU_QBF_VECTOR2 */
/* TX MAC Emulator - QBF vecotor [87:64] */
#define REG_TX_MAC_EMU_REG15_EMU_QBF_VECTOR2          0x38054
#define REG_TX_MAC_EMU_REG15_EMU_QBF_VECTOR2_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG15_EMU_QBF_VECTOR2_SHIFT    0
#define REG_TX_MAC_EMU_REG15_EMU_QBF_VECTOR2_WIDTH    24

/* TX_MAC_EMU_REG16_PAC_PHY_QBF_VECTOR0 */
/* MAC Packet Config - QBF vecotor [31:0] */
#define REG_TX_MAC_EMU_REG16_PAC_PHY_QBF_VECTOR0          0x38058
#define REG_TX_MAC_EMU_REG16_PAC_PHY_QBF_VECTOR0_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG16_PAC_PHY_QBF_VECTOR0_SHIFT    0
#define REG_TX_MAC_EMU_REG16_PAC_PHY_QBF_VECTOR0_WIDTH    32

/* TX_MAC_EMU_REG17_PAC_PHY_QBF_VECTOR1 */
/* MAC Packet Config - QBF vecotor [63:32] */
#define REG_TX_MAC_EMU_REG17_PAC_PHY_QBF_VECTOR1          0x3805c
#define REG_TX_MAC_EMU_REG17_PAC_PHY_QBF_VECTOR1_MASK     0xFFFFFFFF
#define REG_TX_MAC_EMU_REG17_PAC_PHY_QBF_VECTOR1_SHIFT    0
#define REG_TX_MAC_EMU_REG17_PAC_PHY_QBF_VECTOR1_WIDTH    32

/* TX_MAC_EMU_REG18_PAC_PHY_QBF_VECTOR2 */
/* MAC Packet Config - QBF vecotor [87:64] */
#define REG_TX_MAC_EMU_REG18_PAC_PHY_QBF_VECTOR2          0x38060
#define REG_TX_MAC_EMU_REG18_PAC_PHY_QBF_VECTOR2_MASK     0x00FFFFFF
#define REG_TX_MAC_EMU_REG18_PAC_PHY_QBF_VECTOR2_SHIFT    0
#define REG_TX_MAC_EMU_REG18_PAC_PHY_QBF_VECTOR2_WIDTH    24
#endif 
