/*******************************************************************
*                                                                  
*  PHY_Tx_Regs.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef PHY_Tx_Regs_regs_H_FILE
#define PHY_Tx_Regs_regs_H_FILE

/* TX_BE_REG_00_SW_RESET_N_REG */
/* One bit per sub block. Resets only the core logic. Programming model is unchaged. Writing "0" resets the sub block and holds it reset. Writing "1" resets the sub block and releases the resets autumaticaly. */
#define REG_TX_BE_REG_00_SW_RESET_N_REG          0x00000
#define REG_TX_BE_REG_00_SW_RESET_N_REG_MASK     0x01FFFFFF
#define REG_TX_BE_REG_00_SW_RESET_N_REG_SHIFT    0
#define REG_TX_BE_REG_00_SW_RESET_N_REG_WIDTH    25

/* TX_BE_REG_01_TX_SUBLOCK_ENABLE */
/* Sub blocks enable. One bit per sub block. Enables or disables the sub block clock. */
#define REG_TX_BE_REG_01_TX_SUBLOCK_ENABLE          0x00004
#define REG_TX_BE_REG_01_TX_SUBLOCK_ENABLE_MASK     0x01FFFFFF
#define REG_TX_BE_REG_01_TX_SUBLOCK_ENABLE_SHIFT    0
#define REG_TX_BE_REG_01_TX_SUBLOCK_ENABLE_WIDTH    25

/* TX_BE_REG_02_SW_RESET_GENERATE */
/* A SW reset procedure will be initiated by writing to this register to the bits that equal 1l */
#define REG_TX_BE_REG_02_SW_RESET_GENERATE          0x00008
#define REG_TX_BE_REG_02_SW_RESET_GENERATE_MASK     0x01FFFFFF
#define REG_TX_BE_REG_02_SW_RESET_GENERATE_SHIFT    0
#define REG_TX_BE_REG_02_SW_RESET_GENERATE_WIDTH    25

/* TX_BE_REG_03_MAC_SW_RESET_MASK */
/* Which block to software reset after pac_phy_tx_phy_enable fall */
#define REG_TX_BE_REG_03_MAC_SW_RESET_MASK          0x0000C
#define REG_TX_BE_REG_03_MAC_SW_RESET_MASK_MASK     0x01FFFFFF
#define REG_TX_BE_REG_03_MAC_SW_RESET_MASK_SHIFT    0
#define REG_TX_BE_REG_03_MAC_SW_RESET_MASK_WIDTH    25

/* TX_BE_REG_04_NO_INTERPOLATION_MODE */
/* in this mode the interpolators and mixer will be bypassed and the windowing mux will be output from the TX filter */
#define REG_TX_BE_REG_04_NO_INTERPOLATION_MODE          0x00010
#define REG_TX_BE_REG_04_NO_INTERPOLATION_MODE_MASK     0x00000001
#define REG_TX_BE_REG_04_NO_INTERPOLATION_MODE_SHIFT    0
#define REG_TX_BE_REG_04_NO_INTERPOLATION_MODE_WIDTH    1

/* TX_BE_REG_04_INTLVR_BYPASS_MODE */
/* Directs permutation RAM to take bypass interleaver permutation. */
#define REG_TX_BE_REG_04_INTLVR_BYPASS_MODE          0x00010
#define REG_TX_BE_REG_04_INTLVR_BYPASS_MODE_MASK     0x00000002
#define REG_TX_BE_REG_04_INTLVR_BYPASS_MODE_SHIFT    1
#define REG_TX_BE_REG_04_INTLVR_BYPASS_MODE_WIDTH    1

/* TX_BE_REG_04_MAC_EMU_MODE_EN */
/* Directs permutation RAM to take bypass interleaver permutation. */
#define REG_TX_BE_REG_04_MAC_EMU_MODE_EN          0x00010
#define REG_TX_BE_REG_04_MAC_EMU_MODE_EN_MASK     0x00000004
#define REG_TX_BE_REG_04_MAC_EMU_MODE_EN_SHIFT    2
#define REG_TX_BE_REG_04_MAC_EMU_MODE_EN_WIDTH    1

/* TX_BE_REG_04_TUNING_MODE */
/* Enable Tuning mode so TX control does not stop at MAC packet done. */
#define REG_TX_BE_REG_04_TUNING_MODE          0x00010
#define REG_TX_BE_REG_04_TUNING_MODE_MASK     0x00000008
#define REG_TX_BE_REG_04_TUNING_MODE_SHIFT    3
#define REG_TX_BE_REG_04_TUNING_MODE_WIDTH    1

/* TX_BE_REG_04_TX_ANT_EXCHANGE */
/* Enable antenna exchange in Rank 1 only. Does not work in rank 2. Only switches between tx0_enable and tx1_enable from style RAM. */
#define REG_TX_BE_REG_04_TX_ANT_EXCHANGE          0x00010
#define REG_TX_BE_REG_04_TX_ANT_EXCHANGE_MASK     0x00000010
#define REG_TX_BE_REG_04_TX_ANT_EXCHANGE_SHIFT    4
#define REG_TX_BE_REG_04_TX_ANT_EXCHANGE_WIDTH    1

/* TX_BE_REG_04_ANALOG_LPBK_EN */
/* Enable loop back from RX analog interface to TX analog interface */
#define REG_TX_BE_REG_04_ANALOG_LPBK_EN          0x00010
#define REG_TX_BE_REG_04_ANALOG_LPBK_EN_MASK     0x00000020
#define REG_TX_BE_REG_04_ANALOG_LPBK_EN_SHIFT    5
#define REG_TX_BE_REG_04_ANALOG_LPBK_EN_WIDTH    1

/* TX_BE_REG_04_ANALOG_LPBK_CLK_EN */
/* Enable clock for analog loopback */
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_EN          0x00010
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_EN_MASK     0x00000040
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_EN_SHIFT    6
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_EN_WIDTH    1

/* TX_BE_REG_04_ANALOG_LPBK_CLK_DIV */
/* Devision rate for analog loopback clock. */
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_DIV          0x00010
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_DIV_MASK     0x00000f80
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_DIV_SHIFT    7
#define REG_TX_BE_REG_04_ANALOG_LPBK_CLK_DIV_WIDTH    5

/* TX_BE_REG_04_MODEM_11B_STB_40_ENABLE */
/* Modem 11b strobe 40 disable */
#define REG_TX_BE_REG_04_MODEM_11B_STB_40_ENABLE          0x00010
#define REG_TX_BE_REG_04_MODEM_11B_STB_40_ENABLE_MASK     0x00001000
#define REG_TX_BE_REG_04_MODEM_11B_STB_40_ENABLE_SHIFT    12
#define REG_TX_BE_REG_04_MODEM_11B_STB_40_ENABLE_WIDTH    1

/* TX_BE_REG_04_CLK_44_GEN_ENABLE */
/* Modem 11b clk gen enable */
#define REG_TX_BE_REG_04_CLK_44_GEN_ENABLE          0x00010
#define REG_TX_BE_REG_04_CLK_44_GEN_ENABLE_MASK     0x00002000
#define REG_TX_BE_REG_04_CLK_44_GEN_ENABLE_SHIFT    13
#define REG_TX_BE_REG_04_CLK_44_GEN_ENABLE_WIDTH    1

/* TX_BE_REG_04_CLK_44_GEN_DIV_0 */
/* Modem 11b clk gen div 0 */
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_0          0x00010
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_0_MASK     0x000f0000
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_0_SHIFT    16
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_0_WIDTH    4

/* TX_BE_REG_04_CLK_44_GEN_DIV_1 */
/* Modem 11b clk gen div 1 */
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_1          0x00010
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_1_MASK     0x00f00000
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_1_SHIFT    20
#define REG_TX_BE_REG_04_CLK_44_GEN_DIV_1_WIDTH    4

/* TX_BE_REG_04_CLK_44_GEN_LENGTH */
/* Modem 11b clk gen length */
#define REG_TX_BE_REG_04_CLK_44_GEN_LENGTH          0x00010
#define REG_TX_BE_REG_04_CLK_44_GEN_LENGTH_MASK     0x0f000000
#define REG_TX_BE_REG_04_CLK_44_GEN_LENGTH_SHIFT    24
#define REG_TX_BE_REG_04_CLK_44_GEN_LENGTH_WIDTH    4

/* TX_BE_REG_05_SW_BIST_START */
/* Run BIST by User */
#define REG_TX_BE_REG_05_SW_BIST_START          0x00014
#define REG_TX_BE_REG_05_SW_BIST_START_MASK     0x00000001
#define REG_TX_BE_REG_05_SW_BIST_START_SHIFT    0
#define REG_TX_BE_REG_05_SW_BIST_START_WIDTH    1

/* TX_BE_REG_05_CLEAR_RAM_MODE */
/* Enalbe BIST Clear RAM mode */
#define REG_TX_BE_REG_05_CLEAR_RAM_MODE          0x00014
#define REG_TX_BE_REG_05_CLEAR_RAM_MODE_MASK     0x00000002
#define REG_TX_BE_REG_05_CLEAR_RAM_MODE_SHIFT    1
#define REG_TX_BE_REG_05_CLEAR_RAM_MODE_WIDTH    1

/* TX_BE_REG_07_TX0_ENABLE */
/* Enable TX0 data path */
#define REG_TX_BE_REG_07_TX0_ENABLE          0x0001C
#define REG_TX_BE_REG_07_TX0_ENABLE_MASK     0x00000001
#define REG_TX_BE_REG_07_TX0_ENABLE_SHIFT    0
#define REG_TX_BE_REG_07_TX0_ENABLE_WIDTH    1

/* TX_BE_REG_07_TX1_ENABLE */
/* Enable TX1 data path */
#define REG_TX_BE_REG_07_TX1_ENABLE          0x0001C
#define REG_TX_BE_REG_07_TX1_ENABLE_MASK     0x00000002
#define REG_TX_BE_REG_07_TX1_ENABLE_SHIFT    1
#define REG_TX_BE_REG_07_TX1_ENABLE_WIDTH    1

/* TX_BE_REG_07_TX_IS_OPEN_40_MHZ */
/* TX is open to 40 MHz */
#define REG_TX_BE_REG_07_TX_IS_OPEN_40_MHZ          0x0001C
#define REG_TX_BE_REG_07_TX_IS_OPEN_40_MHZ_MASK     0x00000004
#define REG_TX_BE_REG_07_TX_IS_OPEN_40_MHZ_SHIFT    2
#define REG_TX_BE_REG_07_TX_IS_OPEN_40_MHZ_WIDTH    1

/* TX_BE_REG_07_TX_IS_HALF_BAND */
/* TX is in Half Band */
#define REG_TX_BE_REG_07_TX_IS_HALF_BAND          0x0001C
#define REG_TX_BE_REG_07_TX_IS_HALF_BAND_MASK     0x00000008
#define REG_TX_BE_REG_07_TX_IS_HALF_BAND_SHIFT    3
#define REG_TX_BE_REG_07_TX_IS_HALF_BAND_WIDTH    1

/* TX_BE_REG_07_TX0_AFE_OUT_SWAP_I_Q_EN */
/* TX0 swap I and Q enable */
#define REG_TX_BE_REG_07_TX0_AFE_OUT_SWAP_I_Q_EN          0x0001C
#define REG_TX_BE_REG_07_TX0_AFE_OUT_SWAP_I_Q_EN_MASK     0x00000010
#define REG_TX_BE_REG_07_TX0_AFE_OUT_SWAP_I_Q_EN_SHIFT    4
#define REG_TX_BE_REG_07_TX0_AFE_OUT_SWAP_I_Q_EN_WIDTH    1

/* TX_BE_REG_07_TX1_AFE_OUT_SWAP_I_Q_EN */
/* TX0 swap I and Q enable */
#define REG_TX_BE_REG_07_TX1_AFE_OUT_SWAP_I_Q_EN          0x0001C
#define REG_TX_BE_REG_07_TX1_AFE_OUT_SWAP_I_Q_EN_MASK     0x00000020
#define REG_TX_BE_REG_07_TX1_AFE_OUT_SWAP_I_Q_EN_SHIFT    5
#define REG_TX_BE_REG_07_TX1_AFE_OUT_SWAP_I_Q_EN_WIDTH    1

/* TX_BE_REG_07_WINDOWING_EN */
/* Enable windowing mechanism */
#define REG_TX_BE_REG_07_WINDOWING_EN          0x0001C
#define REG_TX_BE_REG_07_WINDOWING_EN_MASK     0x00000040
#define REG_TX_BE_REG_07_WINDOWING_EN_SHIFT    6
#define REG_TX_BE_REG_07_WINDOWING_EN_WIDTH    1

/* TX_BE_REG_07_R1_PILOTS_MODE */
/* Enable Rank 1 Pilots mode */
#define REG_TX_BE_REG_07_R1_PILOTS_MODE          0x0001C
#define REG_TX_BE_REG_07_R1_PILOTS_MODE_MASK     0x00000080
#define REG_TX_BE_REG_07_R1_PILOTS_MODE_SHIFT    7
#define REG_TX_BE_REG_07_R1_PILOTS_MODE_WIDTH    1

/* TX_BE_REG_07_AFE_TX_DEBUG_MODE_EN */
/* Enable TX directly from the MAC shared RAM to the AFE TX interface */
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_EN          0x0001C
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_EN_MASK     0x00000100
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_EN_SHIFT    8
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_EN_WIDTH    1

/* TX_BE_REG_07_AFE_TX_DEBUG_MODE_P_START */
/* Packet start for AFE TX debug mode */
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_P_START          0x0001C
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_P_START_MASK     0x00000200
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_P_START_SHIFT    9
#define REG_TX_BE_REG_07_AFE_TX_DEBUG_MODE_P_START_WIDTH    1

/* TX_BE_REG_07_SSB_128_MODE */
/* SSB works in 128 bins mode - mapping is done to usb or lsb  */
#define REG_TX_BE_REG_07_SSB_128_MODE          0x0001C
#define REG_TX_BE_REG_07_SSB_128_MODE_MASK     0x00000400
#define REG_TX_BE_REG_07_SSB_128_MODE_SHIFT    10
#define REG_TX_BE_REG_07_SSB_128_MODE_WIDTH    1

/* TX_BE_REG_07_TX0_FE_ENABLE */
/* tx0 frontend enable  */
#define REG_TX_BE_REG_07_TX0_FE_ENABLE          0x0001C
#define REG_TX_BE_REG_07_TX0_FE_ENABLE_MASK     0x00000800
#define REG_TX_BE_REG_07_TX0_FE_ENABLE_SHIFT    11
#define REG_TX_BE_REG_07_TX0_FE_ENABLE_WIDTH    1

/* TX_BE_REG_07_TX1_FE_ENABLE */
/* tx1 frontend enable  */
#define REG_TX_BE_REG_07_TX1_FE_ENABLE          0x0001C
#define REG_TX_BE_REG_07_TX1_FE_ENABLE_MASK     0x00001000
#define REG_TX_BE_REG_07_TX1_FE_ENABLE_SHIFT    12
#define REG_TX_BE_REG_07_TX1_FE_ENABLE_WIDTH    1

/* TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_0 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_0          0x00020
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_0_MASK     0x0000FFFF
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_0_SHIFT    0
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_0_WIDTH    16

/* TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_1 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_1          0x00020
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_1_MASK     0xFFFF0000
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_1_SHIFT    16
#define REG_TX_BE_REG_08_TX_CNTRL_SYMBOL_LENGTH_1_WIDTH    16

/* TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_2 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_2          0x00024
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_2_MASK     0x0000FFFF
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_2_SHIFT    0
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_2_WIDTH    16

/* TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_3 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_3          0x00024
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_3_MASK     0xFFFF0000
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_3_SHIFT    16
#define REG_TX_BE_REG_09_TX_CNTRL_SYMBOL_LENGTH_3_WIDTH    16

/* TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_4 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_4          0x00028
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_4_MASK     0x0000FFFF
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_4_SHIFT    0
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_4_WIDTH    16

/* TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_5 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_5          0x00028
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_5_MASK     0xFFFF0000
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_5_SHIFT    16
#define REG_TX_BE_REG_0A_TX_CNTRL_SYMBOL_LENGTH_5_WIDTH    16

/* TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_6 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_6          0x0002C
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_6_MASK     0x0000FFFF
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_6_SHIFT    0
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_6_WIDTH    16

/* TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_7 */
/* The number of clock cycles between 2 symbol storbes. */
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_7          0x0002C
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_7_MASK     0xFFFF0000
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_7_SHIFT    16
#define REG_TX_BE_REG_0B_TX_CNTRL_SYMBOL_LENGTH_7_WIDTH    16

/* TX_BE_REG_0C_TX_CNTRL_PSTART_TO_SYM_STRB_DELAY */
/* The number of clock cycles between the "packet start" and the first symbol strobe out. */
#define REG_TX_BE_REG_0C_TX_CNTRL_PSTART_TO_SYM_STRB_DELAY          0x00030
#define REG_TX_BE_REG_0C_TX_CNTRL_PSTART_TO_SYM_STRB_DELAY_MASK     0x000000FF
#define REG_TX_BE_REG_0C_TX_CNTRL_PSTART_TO_SYM_STRB_DELAY_SHIFT    0
#define REG_TX_BE_REG_0C_TX_CNTRL_PSTART_TO_SYM_STRB_DELAY_WIDTH    8

/* TX_BE_REG_0D_TX_REQUEST_LENGTH */
/* Pulse length of the phy_pac_tx_phy_data_req signal in clock cycles units. */
#define REG_TX_BE_REG_0D_TX_REQUEST_LENGTH          0x00034
#define REG_TX_BE_REG_0D_TX_REQUEST_LENGTH_MASK     0x0000003F
#define REG_TX_BE_REG_0D_TX_REQUEST_LENGTH_SHIFT    0
#define REG_TX_BE_REG_0D_TX_REQUEST_LENGTH_WIDTH    6

/* TX_BE_REG_0D_TX_IDLE_LENGTH */
/* Delay between two consecutive pulses of  phy_pac_tx_phy_data_req signal, in clock cycles units. */
#define REG_TX_BE_REG_0D_TX_IDLE_LENGTH          0x00034
#define REG_TX_BE_REG_0D_TX_IDLE_LENGTH_MASK     0x003F0000
#define REG_TX_BE_REG_0D_TX_IDLE_LENGTH_SHIFT    16
#define REG_TX_BE_REG_0D_TX_IDLE_LENGTH_WIDTH    6

/* TX_BE_REG_0E_START_READ_DEL */
/* Delay between the rise of pac_phy_tx_phy_enable signal to the response rise of phy_pac_tx_phy_ready signal, in clock cycles units. */
#define REG_TX_BE_REG_0E_START_READ_DEL          0x00038
#define REG_TX_BE_REG_0E_START_READ_DEL_MASK     0x0000FFFF
#define REG_TX_BE_REG_0E_START_READ_DEL_SHIFT    0
#define REG_TX_BE_REG_0E_START_READ_DEL_WIDTH    16

/* TX_BE_REG_0E_END_DELAY_LEN */
/* Delay between the indication of control done signal to the response drop of phy_pac_tx_phy_ready signal, in clock cycles units. */
#define REG_TX_BE_REG_0E_END_DELAY_LEN          0x00038
#define REG_TX_BE_REG_0E_END_DELAY_LEN_MASK     0xFFFF0000
#define REG_TX_BE_REG_0E_END_DELAY_LEN_SHIFT    16
#define REG_TX_BE_REG_0E_END_DELAY_LEN_WIDTH    16

/* GCLK_CONTROL_GCLK_EN_BYPASS */
/* bypass gclk enable of submodules thus operating their clock freely.
 */
#define REG_GCLK_CONTROL_GCLK_EN_BYPASS          0x0003C
#define REG_GCLK_CONTROL_GCLK_EN_BYPASS_MASK     0x03FFFFFF
#define REG_GCLK_CONTROL_GCLK_EN_BYPASS_SHIFT    0
#define REG_GCLK_CONTROL_GCLK_EN_BYPASS_WIDTH    26

/* TX_BE_REG_10_SCR_TYPE */
/* Scrambler polynom setup */
#define REG_TX_BE_REG_10_SCR_TYPE          0x00040
#define REG_TX_BE_REG_10_SCR_TYPE_MASK     0x0000FFFF
#define REG_TX_BE_REG_10_SCR_TYPE_SHIFT    0
#define REG_TX_BE_REG_10_SCR_TYPE_WIDTH    16

/* TX_BE_REG_11_SCR_ALLONE */
/* Set Scrambler Input to "all ones". Scramble ones overides scamble zeros. */
#define REG_TX_BE_REG_11_SCR_ALLONE          0x00044
#define REG_TX_BE_REG_11_SCR_ALLONE_MASK     0x00000001
#define REG_TX_BE_REG_11_SCR_ALLONE_SHIFT    0
#define REG_TX_BE_REG_11_SCR_ALLONE_WIDTH    1

/* TX_BE_REG_11_SCR_ALLZERO */
/* Set Scrambler Input to "all zeros". Scramble ones overides scamble zeros. */
#define REG_TX_BE_REG_11_SCR_ALLZERO          0x00044
#define REG_TX_BE_REG_11_SCR_ALLZERO_MASK     0x00000002
#define REG_TX_BE_REG_11_SCR_ALLZERO_SHIFT    1
#define REG_TX_BE_REG_11_SCR_ALLZERO_WIDTH    1

/* TX_BE_REG_11_SCR_INIT_SEL */
/* Select PRBS mode (AutoGen) / bypass mode (register) init  */
#define REG_TX_BE_REG_11_SCR_INIT_SEL          0x00044
#define REG_TX_BE_REG_11_SCR_INIT_SEL_MASK     0x00000008
#define REG_TX_BE_REG_11_SCR_INIT_SEL_SHIFT    3
#define REG_TX_BE_REG_11_SCR_INIT_SEL_WIDTH    1

/* TX_BE_REG_11_SCRM_TAIL_MODE */
/* Control scrambler function when tail bits. Bit [0] control output, bit [1] control shift reg. */
#define REG_TX_BE_REG_11_SCRM_TAIL_MODE          0x00044
#define REG_TX_BE_REG_11_SCRM_TAIL_MODE_MASK     0x00000030
#define REG_TX_BE_REG_11_SCRM_TAIL_MODE_SHIFT    4
#define REG_TX_BE_REG_11_SCRM_TAIL_MODE_WIDTH    2

/* TX_BE_REG_11_SCRM_PADDING_MODE */
/* Controls if to scramble the pad bits or not. "0" = scramble, "1" = dont scramble. */
#define REG_TX_BE_REG_11_SCRM_PADDING_MODE          0x00044
#define REG_TX_BE_REG_11_SCRM_PADDING_MODE_MASK     0x00000040
#define REG_TX_BE_REG_11_SCRM_PADDING_MODE_SHIFT    6
#define REG_TX_BE_REG_11_SCRM_PADDING_MODE_WIDTH    1

/* TX_BE_REG_11_PRBSLEN */
/* Init value PRBS generator length. */
#define REG_TX_BE_REG_11_PRBSLEN          0x00044
#define REG_TX_BE_REG_11_PRBSLEN_MASK     0x00000F80
#define REG_TX_BE_REG_11_PRBSLEN_SHIFT    7
#define REG_TX_BE_REG_11_PRBSLEN_WIDTH    5

/* TX_BE_REG_12_SW_SCR_INIT */
/* Scrambler init value in N packet new mode */
#define REG_TX_BE_REG_12_SW_SCR_INIT          0x00048
#define REG_TX_BE_REG_12_SW_SCR_INIT_MASK     0x0000FFFF
#define REG_TX_BE_REG_12_SW_SCR_INIT_SHIFT    0
#define REG_TX_BE_REG_12_SW_SCR_INIT_WIDTH    16

/* TX_BE_REG_16_CONV_BYPASS */
/* Data in is shifted right. MSB is the newer bit. */
#define REG_TX_BE_REG_16_CONV_BYPASS          0x00058
#define REG_TX_BE_REG_16_CONV_BYPASS_MASK     0x00000001
#define REG_TX_BE_REG_16_CONV_BYPASS_SHIFT    0
#define REG_TX_BE_REG_16_CONV_BYPASS_WIDTH    1

/* TX_BE_REG_16_CONV_TYPE_A */
/* Data in is shifted right. MSB is the newer bit. */
#define REG_TX_BE_REG_16_CONV_TYPE_A          0x00058
#define REG_TX_BE_REG_16_CONV_TYPE_A_MASK     0x000003FE
#define REG_TX_BE_REG_16_CONV_TYPE_A_SHIFT    1
#define REG_TX_BE_REG_16_CONV_TYPE_A_WIDTH    9

/* TX_BE_REG_16_CONV_TYPE_B */
#define REG_TX_BE_REG_16_CONV_TYPE_B          0x00058
#define REG_TX_BE_REG_16_CONV_TYPE_B_MASK     0x0007FC00
#define REG_TX_BE_REG_16_CONV_TYPE_B_SHIFT    10
#define REG_TX_BE_REG_16_CONV_TYPE_B_WIDTH    9

/* TX_BE_REG_16_CONV_INIT */
#define REG_TX_BE_REG_16_CONV_INIT          0x00058
#define REG_TX_BE_REG_16_CONV_INIT_MASK     0x07F80000
#define REG_TX_BE_REG_16_CONV_INIT_SHIFT    19
#define REG_TX_BE_REG_16_CONV_INIT_WIDTH    8

/* TX_BE_REG_1C_SIGNAL_ONE_VALUE */
/* Signal output mapping value for '1' (I,Q) */
#define REG_TX_BE_REG_1C_SIGNAL_ONE_VALUE          0x00070
#define REG_TX_BE_REG_1C_SIGNAL_ONE_VALUE_MASK     0x000000FF
#define REG_TX_BE_REG_1C_SIGNAL_ONE_VALUE_SHIFT    0
#define REG_TX_BE_REG_1C_SIGNAL_ONE_VALUE_WIDTH    8

/* TX_BE_REG_1C_SIGNAL_ZERO_VALUE */
/* Signal output mapping value for '0' (I,Q) */
#define REG_TX_BE_REG_1C_SIGNAL_ZERO_VALUE          0x00070
#define REG_TX_BE_REG_1C_SIGNAL_ZERO_VALUE_MASK     0x0000FF00
#define REG_TX_BE_REG_1C_SIGNAL_ZERO_VALUE_SHIFT    8
#define REG_TX_BE_REG_1C_SIGNAL_ZERO_VALUE_WIDTH    8

/* TX_BE_REG_1D_SIGNAL_CONV_TYPE_A */
/* A branch Polynomial type of Signal Convolution Encoder */
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_A          0x00074
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_A_MASK     0x000001FF
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_A_SHIFT    0
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_A_WIDTH    9

/* TX_BE_REG_1D_SIGNAL_CONV_TYPE_B */
/* B branch Polynomial type of Signal Convolution Encoder */
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_B          0x00074
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_B_MASK     0x0003FE00
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_B_SHIFT    9
#define REG_TX_BE_REG_1D_SIGNAL_CONV_TYPE_B_WIDTH    9

/* TX_BE_REG_1E_INTRL_BINSTEP_0 */
/* legacy NRows / Nbpsc */
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_0          0x00078
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_0_MASK     0x00000007
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_0_SHIFT    0
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_0_WIDTH    3

/* TX_BE_REG_1E_INTRL_BINSTEP_1 */
/* non-legacy NRows / Nbpsc */
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_1          0x00078
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_1_MASK     0x00000070
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_1_SHIFT    4
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_1_WIDTH    3

/* TX_BE_REG_1E_INTRL_BINSTEP_2 */
/* full CB NRows / Nbpsc */
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_2          0x00078
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_2_MASK     0x00000700
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_2_SHIFT    8
#define REG_TX_BE_REG_1E_INTRL_BINSTEP_2_WIDTH    3

/* TX_BE_REG_1E_INTRL_M_0 */
/* Sp. parser No. of bits - BPSK */
#define REG_TX_BE_REG_1E_INTRL_M_0          0x00078
#define REG_TX_BE_REG_1E_INTRL_M_0_MASK     0x00007000
#define REG_TX_BE_REG_1E_INTRL_M_0_SHIFT    12
#define REG_TX_BE_REG_1E_INTRL_M_0_WIDTH    3

/* TX_BE_REG_1E_INTRL_M_1 */
/* Sp. parser No. of bits - QPSK */
#define REG_TX_BE_REG_1E_INTRL_M_1          0x00078
#define REG_TX_BE_REG_1E_INTRL_M_1_MASK     0x00070000
#define REG_TX_BE_REG_1E_INTRL_M_1_SHIFT    16
#define REG_TX_BE_REG_1E_INTRL_M_1_WIDTH    3

/* TX_BE_REG_1E_INTRL_M_2 */
/* Sp. parser No. of bits - QAM16 */
#define REG_TX_BE_REG_1E_INTRL_M_2          0x00078
#define REG_TX_BE_REG_1E_INTRL_M_2_MASK     0x00700000
#define REG_TX_BE_REG_1E_INTRL_M_2_SHIFT    20
#define REG_TX_BE_REG_1E_INTRL_M_2_WIDTH    3

/* TX_BE_REG_1E_INTRL_M_3 */
/* Sp. parser No. of bits - QAM64 */
#define REG_TX_BE_REG_1E_INTRL_M_3          0x00078
#define REG_TX_BE_REG_1E_INTRL_M_3_MASK     0x07000000
#define REG_TX_BE_REG_1E_INTRL_M_3_SHIFT    24
#define REG_TX_BE_REG_1E_INTRL_M_3_WIDTH    3

/* TX_BE_REG_1F_INTRL_SIZE_0 */
/* legacy No. of bins */
#define REG_TX_BE_REG_1F_INTRL_SIZE_0          0x0007C
#define REG_TX_BE_REG_1F_INTRL_SIZE_0_MASK     0x0000007f
#define REG_TX_BE_REG_1F_INTRL_SIZE_0_SHIFT    0
#define REG_TX_BE_REG_1F_INTRL_SIZE_0_WIDTH    7

/* TX_BE_REG_1F_INTRL_SIZE_1 */
/* non-legacy No. of bins */
#define REG_TX_BE_REG_1F_INTRL_SIZE_1          0x0007C
#define REG_TX_BE_REG_1F_INTRL_SIZE_1_MASK     0x00007f00
#define REG_TX_BE_REG_1F_INTRL_SIZE_1_SHIFT    8
#define REG_TX_BE_REG_1F_INTRL_SIZE_1_WIDTH    7

/* TX_BE_REG_1F_INTRL_SIZE_2 */
/* full CB No. of bins */
#define REG_TX_BE_REG_1F_INTRL_SIZE_2          0x0007C
#define REG_TX_BE_REG_1F_INTRL_SIZE_2_MASK     0x007f0000
#define REG_TX_BE_REG_1F_INTRL_SIZE_2_SHIFT    16
#define REG_TX_BE_REG_1F_INTRL_SIZE_2_WIDTH    7

/* TX_BE_REG_20_INTRL_BIN1_INIT_0 */
/* legacy No. of bins - NRotateAnt#1 */
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_0          0x00080
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_0_MASK     0x0000007f
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_0_SHIFT    0
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_0_WIDTH    7

/* TX_BE_REG_20_INTRL_BIN1_INIT_1 */
/* non-legacy No. of bins - NRotateAnt#1 */
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_1          0x00080
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_1_MASK     0x00007f00
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_1_SHIFT    8
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_1_WIDTH    7

/* TX_BE_REG_20_INTRL_BIN1_INIT_2 */
/* full CB No. of bins - NRotateAnt#1 */
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_2          0x00080
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_2_MASK     0x007f0000
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_2_SHIFT    16
#define REG_TX_BE_REG_20_INTRL_BIN1_INIT_2_WIDTH    7

/* TX_BE_REG_21_TX_PHY_MAC_IF_WR_STM */
/* TX OFDM PHY-MAC I/F Write STM */
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_WR_STM          0x00084
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_WR_STM_MASK     0x0000000f
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_WR_STM_SHIFT    0
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_WR_STM_WIDTH    4

/* TX_BE_REG_21_TX_PHY_MAC_IF_RD_STM */
/* TX OFDM PHY-MAC I/F Read STM */
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_RD_STM          0x00084
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_RD_STM_MASK     0x000001f0
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_RD_STM_SHIFT    4
#define REG_TX_BE_REG_21_TX_PHY_MAC_IF_RD_STM_WIDTH    5

/* TX_BE_REG_21_TX_CTRL_DATA_DONE_LONG */
/* TX OFDM Control Data Done */
#define REG_TX_BE_REG_21_TX_CTRL_DATA_DONE_LONG          0x00084
#define REG_TX_BE_REG_21_TX_CTRL_DATA_DONE_LONG_MASK     0x00001000
#define REG_TX_BE_REG_21_TX_CTRL_DATA_DONE_LONG_SHIFT    12
#define REG_TX_BE_REG_21_TX_CTRL_DATA_DONE_LONG_WIDTH    1

/* TX_BE_REG_21_TX_CTRL_COMMAND_RD_ADDR */
/* TX OFDM Control Style RAM Read Address */
#define REG_TX_BE_REG_21_TX_CTRL_COMMAND_RD_ADDR          0x00084
#define REG_TX_BE_REG_21_TX_CTRL_COMMAND_RD_ADDR_MASK     0x007f0000
#define REG_TX_BE_REG_21_TX_CTRL_COMMAND_RD_ADDR_SHIFT    16
#define REG_TX_BE_REG_21_TX_CTRL_COMMAND_RD_ADDR_WIDTH    7

/* TX_BE_REG_21_TX0_AFE_IF_WR_AFTER_P_END */
/* TX Ant0 AFE I/F Write after Packet End */
#define REG_TX_BE_REG_21_TX0_AFE_IF_WR_AFTER_P_END          0x00084
#define REG_TX_BE_REG_21_TX0_AFE_IF_WR_AFTER_P_END_MASK     0x01000000
#define REG_TX_BE_REG_21_TX0_AFE_IF_WR_AFTER_P_END_SHIFT    24
#define REG_TX_BE_REG_21_TX0_AFE_IF_WR_AFTER_P_END_WIDTH    1

/* TX_BE_REG_21_TX1_AFE_IF_WR_AFTER_P_END */
/* TX Ant1 AFE I/F Write after Packet End */
#define REG_TX_BE_REG_21_TX1_AFE_IF_WR_AFTER_P_END          0x00084
#define REG_TX_BE_REG_21_TX1_AFE_IF_WR_AFTER_P_END_MASK     0x10000000
#define REG_TX_BE_REG_21_TX1_AFE_IF_WR_AFTER_P_END_SHIFT    28
#define REG_TX_BE_REG_21_TX1_AFE_IF_WR_AFTER_P_END_WIDTH    1

/* TX_BE_REG_23_TX_CNTRL_STYLE_ADDR_LGC */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_23_TX_CNTRL_STYLE_ADDR_LGC          0x0008C
#define REG_TX_BE_REG_23_TX_CNTRL_STYLE_ADDR_LGC_MASK     0x0000007F
#define REG_TX_BE_REG_23_TX_CNTRL_STYLE_ADDR_LGC_SHIFT    0
#define REG_TX_BE_REG_23_TX_CNTRL_STYLE_ADDR_LGC_WIDTH    7

/* TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_0 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_0          0x00090
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_0_MASK     0x0000007F
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_0_SHIFT    0
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_0_WIDTH    7

/* TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_1 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_1          0x00090
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_1_MASK     0x00007f00
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_1_SHIFT    8
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_1_WIDTH    7

/* TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_2 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_2          0x00090
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_2_MASK     0x007F0000
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_2_SHIFT    16
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_2_WIDTH    7

/* TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_3 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_3          0x00090
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_3_MASK     0x7F000000
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_3_SHIFT    24
#define REG_TX_BE_REG_24_TX_CNTRL_STYLE_ADDR_HT_3_WIDTH    7

/* TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_4 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_4          0x00094
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_4_MASK     0x0000007F
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_4_SHIFT    0
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_4_WIDTH    7

/* TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_5 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_5          0x00094
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_5_MASK     0x00007f00
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_5_SHIFT    8
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_5_WIDTH    7

/* TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_6 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_6          0x00094
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_6_MASK     0x007F0000
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_6_SHIFT    16
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_6_WIDTH    7

/* TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_7 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_7          0x00094
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_7_MASK     0x7F000000
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_7_SHIFT    24
#define REG_TX_BE_REG_25_TX_CNTRL_STYLE_ADDR_HT_7_WIDTH    7

/* TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_0 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_0          0x00098
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_0_MASK     0x0000007F
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_0_SHIFT    0
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_0_WIDTH    7

/* TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_1 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_1          0x00098
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_1_MASK     0x00007f00
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_1_SHIFT    8
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_1_WIDTH    7

/* TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_2 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_2          0x00098
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_2_MASK     0x007F0000
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_2_SHIFT    16
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_2_WIDTH    7

/* TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_3 */
/* The start address of style in the style RAM */
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_3          0x00098
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_3_MASK     0x7F000000
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_3_SHIFT    24
#define REG_TX_BE_REG_26_TX_CNTRL_STYLE_ADDR_DUP_3_WIDTH    7

/* TX_BE_REG_29_SW_SERVICE_DATA */
/* Debug mode SW service data */
#define REG_TX_BE_REG_29_SW_SERVICE_DATA          0x000A4
#define REG_TX_BE_REG_29_SW_SERVICE_DATA_MASK     0x000001FF
#define REG_TX_BE_REG_29_SW_SERVICE_DATA_SHIFT    0
#define REG_TX_BE_REG_29_SW_SERVICE_DATA_WIDTH    9

/* TX_BE_REG_32_PILOT_0_MAP */
/* Pilot mapping value for bit equal zero {I,Q} */
#define REG_TX_BE_REG_32_PILOT_0_MAP          0x000C8
#define REG_TX_BE_REG_32_PILOT_0_MAP_MASK     0x000000FF
#define REG_TX_BE_REG_32_PILOT_0_MAP_SHIFT    0
#define REG_TX_BE_REG_32_PILOT_0_MAP_WIDTH    8

/* TX_BE_REG_32_PILOT_1_MAP */
/* Pilot mapping value for bit equal one */
#define REG_TX_BE_REG_32_PILOT_1_MAP          0x000C8
#define REG_TX_BE_REG_32_PILOT_1_MAP_MASK     0x0000FF00
#define REG_TX_BE_REG_32_PILOT_1_MAP_SHIFT    8
#define REG_TX_BE_REG_32_PILOT_1_MAP_WIDTH    8

/* TX_BE_REG_33_ROTATE_TX_SELECT */
/* Select which TX Antenna to rotate if rotate bit signal is high. Default is Rotate Antenna 2. */
#define REG_TX_BE_REG_33_ROTATE_TX_SELECT          0x000CC
#define REG_TX_BE_REG_33_ROTATE_TX_SELECT_MASK     0x00000001
#define REG_TX_BE_REG_33_ROTATE_TX_SELECT_SHIFT    0
#define REG_TX_BE_REG_33_ROTATE_TX_SELECT_WIDTH    1

/* TX_BE_REG_33_ROTATE_TX_BYPASS */
/* Disable rotation */
#define REG_TX_BE_REG_33_ROTATE_TX_BYPASS          0x000CC
#define REG_TX_BE_REG_33_ROTATE_TX_BYPASS_MASK     0x00000002
#define REG_TX_BE_REG_33_ROTATE_TX_BYPASS_SHIFT    1
#define REG_TX_BE_REG_33_ROTATE_TX_BYPASS_WIDTH    1

/* TX_BE_REG_33_ROT_HT_SIG_EN */
/* Enable rotation of HT Signals */
#define REG_TX_BE_REG_33_ROT_HT_SIG_EN          0x000CC
#define REG_TX_BE_REG_33_ROT_HT_SIG_EN_MASK     0x00000004
#define REG_TX_BE_REG_33_ROT_HT_SIG_EN_SHIFT    2
#define REG_TX_BE_REG_33_ROT_HT_SIG_EN_WIDTH    1

/* TX_BE_REG_33_LONG_PRE_CALIBRATE_MODE */
/* Enable taking Long preamble bins from calibration RAM */
#define REG_TX_BE_REG_33_LONG_PRE_CALIBRATE_MODE          0x000CC
#define REG_TX_BE_REG_33_LONG_PRE_CALIBRATE_MODE_MASK     0x00000008
#define REG_TX_BE_REG_33_LONG_PRE_CALIBRATE_MODE_SHIFT    3
#define REG_TX_BE_REG_33_LONG_PRE_CALIBRATE_MODE_WIDTH    1

/* TX_BE_REG_33_FILTER_CALIBRATE_MODE */
/* Enable shift of the band by more than 10 MHz */
#define REG_TX_BE_REG_33_FILTER_CALIBRATE_MODE          0x000CC
#define REG_TX_BE_REG_33_FILTER_CALIBRATE_MODE_MASK     0x00000010
#define REG_TX_BE_REG_33_FILTER_CALIBRATE_MODE_SHIFT    4
#define REG_TX_BE_REG_33_FILTER_CALIBRATE_MODE_WIDTH    1

/* TX_BE_REG_33_SB_ROTATE_SELECT */
/* Select if to rotate upper band or lower band. "0"=rotate lower, "1"=rotate upper. */
#define REG_TX_BE_REG_33_SB_ROTATE_SELECT          0x000CC
#define REG_TX_BE_REG_33_SB_ROTATE_SELECT_MASK     0x00000020
#define REG_TX_BE_REG_33_SB_ROTATE_SELECT_SHIFT    5
#define REG_TX_BE_REG_33_SB_ROTATE_SELECT_WIDTH    1

/* TX_BE_REG_33_LONG_PRE_BPSK_VAL */
/* Long Preamble BPSK value. BPSK value for +6 */
#define REG_TX_BE_REG_33_LONG_PRE_BPSK_VAL          0x000CC
#define REG_TX_BE_REG_33_LONG_PRE_BPSK_VAL_MASK     0x000f0000
#define REG_TX_BE_REG_33_LONG_PRE_BPSK_VAL_SHIFT    16
#define REG_TX_BE_REG_33_LONG_PRE_BPSK_VAL_WIDTH    4

/* TX_BE_REG_33_LONG_CAL_QPSK_VAL */
/* Long Preamble Calibration mode QPSK value. QPSK value for +4 */
#define REG_TX_BE_REG_33_LONG_CAL_QPSK_VAL          0x000CC
#define REG_TX_BE_REG_33_LONG_CAL_QPSK_VAL_MASK     0x00f00000
#define REG_TX_BE_REG_33_LONG_CAL_QPSK_VAL_SHIFT    20
#define REG_TX_BE_REG_33_LONG_CAL_QPSK_VAL_WIDTH    4

/* TX_BE_REG_34_PILOT_INI_CB0R1 */
/* HT pilot init for no CB and Rank1 */
#define REG_TX_BE_REG_34_PILOT_INI_CB0R1          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB0R1_MASK     0x0000000f
#define REG_TX_BE_REG_34_PILOT_INI_CB0R1_SHIFT    0
#define REG_TX_BE_REG_34_PILOT_INI_CB0R1_WIDTH    4

/* TX_BE_REG_34_PILOT_INI_CB0R2_A0 */
/* HT pilot init for no CB and Rank2 for antenna 0 */
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A0          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A0_MASK     0x000000f0
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A0_SHIFT    4
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A0_WIDTH    4

/* TX_BE_REG_34_PILOT_INI_CB0R2_A1 */
/* HT pilot init for no CB and Rank2 for antenna 1 */
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A1          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A1_MASK     0x00000f00
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A1_SHIFT    8
#define REG_TX_BE_REG_34_PILOT_INI_CB0R2_A1_WIDTH    4

/* TX_BE_REG_34_PILOT_INI_CB1R1 */
/* HT pilot init for CB and Rank1 */
#define REG_TX_BE_REG_34_PILOT_INI_CB1R1          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB1R1_MASK     0x0003f000
#define REG_TX_BE_REG_34_PILOT_INI_CB1R1_SHIFT    12
#define REG_TX_BE_REG_34_PILOT_INI_CB1R1_WIDTH    6

/* TX_BE_REG_34_PILOT_INI_CB1R2_A0 */
/* HT pilot init for CB and Rank2 for antenna 0 */
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A0          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A0_MASK     0x00fc0000
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A0_SHIFT    18
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A0_WIDTH    6

/* TX_BE_REG_34_PILOT_INI_CB1R2_A1 */
/* HT pilot init for CB and Rank2 for antenna 1 */
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A1          0x000D0
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A1_MASK     0x3f000000
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A1_SHIFT    24
#define REG_TX_BE_REG_34_PILOT_INI_CB1R2_A1_WIDTH    6

/* TX_BE_REG_35_PILOT_SQ_FCB */
/* HT Pilot sequence for Full CB */
#define REG_TX_BE_REG_35_PILOT_SQ_FCB          0x000D4
#define REG_TX_BE_REG_35_PILOT_SQ_FCB_MASK     0x0003ffff
#define REG_TX_BE_REG_35_PILOT_SQ_FCB_SHIFT    0
#define REG_TX_BE_REG_35_PILOT_SQ_FCB_WIDTH    18

/* TX_BE_REG_36_PILOT_SQ_NCB */
/* HT Pilot sequence for Non CB and ssb */
#define REG_TX_BE_REG_36_PILOT_SQ_NCB          0x000D8
#define REG_TX_BE_REG_36_PILOT_SQ_NCB_MASK     0x000000ff
#define REG_TX_BE_REG_36_PILOT_SQ_NCB_SHIFT    0
#define REG_TX_BE_REG_36_PILOT_SQ_NCB_WIDTH    8

/* TX_BE_REG_36_PILOT_SQ_DUP */
/* HT Pilot sequence for Non CB and duplicate mode */
#define REG_TX_BE_REG_36_PILOT_SQ_DUP          0x000D8
#define REG_TX_BE_REG_36_PILOT_SQ_DUP_MASK     0x0000ff00
#define REG_TX_BE_REG_36_PILOT_SQ_DUP_SHIFT    8
#define REG_TX_BE_REG_36_PILOT_SQ_DUP_WIDTH    8

/* TX_BE_REG_3C_DATA_EQUALIZER_SET0 */
/* Data equalizer multiplication value set number 0. */
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET0          0x000F0
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET0_MASK     0x000000FF
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET0_SHIFT    0
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET0_WIDTH    8

/* TX_BE_REG_3C_DATA_EQUALIZER_SET1 */
/* Data equalizer multiplication value set number 1. */
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET1          0x000F0
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET1_MASK     0x0000FF00
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET1_SHIFT    8
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET1_WIDTH    8

/* TX_BE_REG_3C_DATA_EQUALIZER_SET2 */
/* Data equalizer multiplication value set number 2. */
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET2          0x000F0
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET2_MASK     0x00FF0000
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET2_SHIFT    16
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET2_WIDTH    8

/* TX_BE_REG_3C_DATA_EQUALIZER_SET3 */
/* Data equalizer multiplication value set number 3. */
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET3          0x000F0
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET3_MASK     0xFF000000
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET3_SHIFT    24
#define REG_TX_BE_REG_3C_DATA_EQUALIZER_SET3_WIDTH    8

/* TX_BE_REG_3D_PILOT_EQUALIZER_SET0 */
/* Pilot equalizer multiplication value set 0 */
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET0          0x000F4
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET0_MASK     0x000001FF
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET0_SHIFT    0
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET0_WIDTH    9

/* TX_BE_REG_3D_PILOT_EQUALIZER_SET1 */
/* Pilot equalizer multiplication value set 1 */
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET1          0x000F4
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET1_MASK     0x0007FC00
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET1_SHIFT    10
#define REG_TX_BE_REG_3D_PILOT_EQUALIZER_SET1_WIDTH    9

/* TX_BE_REG_3E_PILOT_INIT_VAL_P_START */
/* Pilot PRBS shift reg value at packet start */
#define REG_TX_BE_REG_3E_PILOT_INIT_VAL_P_START          0x000F8
#define REG_TX_BE_REG_3E_PILOT_INIT_VAL_P_START_MASK     0x0000007F
#define REG_TX_BE_REG_3E_PILOT_INIT_VAL_P_START_SHIFT    0
#define REG_TX_BE_REG_3E_PILOT_INIT_VAL_P_START_WIDTH    7

/* TX_BE_REG_46_BIST_DONE */
/* Current assembly of all BIST result signals. */
#define REG_TX_BE_REG_46_BIST_DONE          0x00118
#define REG_TX_BE_REG_46_BIST_DONE_MASK     0xFFFFFFFF
#define REG_TX_BE_REG_46_BIST_DONE_SHIFT    0
#define REG_TX_BE_REG_46_BIST_DONE_WIDTH    32

/* TX_BE_REG_47_BIST_RESULT */
/* Current assembly of all BIST result signals. */
#define REG_TX_BE_REG_47_BIST_RESULT          0x0011C
#define REG_TX_BE_REG_47_BIST_RESULT_MASK     0xFFFFFFFF
#define REG_TX_BE_REG_47_BIST_RESULT_SHIFT    0
#define REG_TX_BE_REG_47_BIST_RESULT_WIDTH    32

/* TX_BE_REG_48_TX_FILTER_FLIP */
/* TX Filter select USB/LSB. 0=USB 1=LSB */
#define REG_TX_BE_REG_48_TX_FILTER_FLIP          0x00120
#define REG_TX_BE_REG_48_TX_FILTER_FLIP_MASK     0x00000001
#define REG_TX_BE_REG_48_TX_FILTER_FLIP_SHIFT    0
#define REG_TX_BE_REG_48_TX_FILTER_FLIP_WIDTH    1

/* TX_BE_REG_48_FIX_EQU_BYPASS */
/* Fix Equalizer Bypass */
#define REG_TX_BE_REG_48_FIX_EQU_BYPASS          0x00120
#define REG_TX_BE_REG_48_FIX_EQU_BYPASS_MASK     0x00000002
#define REG_TX_BE_REG_48_FIX_EQU_BYPASS_SHIFT    1
#define REG_TX_BE_REG_48_FIX_EQU_BYPASS_WIDTH    1

/* TX_BE_REG_48_LONG_PRE_INV_SELECT */
/* Selects which antenna's long preamble is inverted. */
#define REG_TX_BE_REG_48_LONG_PRE_INV_SELECT          0x00120
#define REG_TX_BE_REG_48_LONG_PRE_INV_SELECT_MASK     0x00000004
#define REG_TX_BE_REG_48_LONG_PRE_INV_SELECT_SHIFT    2
#define REG_TX_BE_REG_48_LONG_PRE_INV_SELECT_WIDTH    1

/* TX_BE_REG_4B_HYP_TX_GPR */
/* Spare reserved register */
#define REG_TX_BE_REG_4B_HYP_TX_GPR          0x0012C
#define REG_TX_BE_REG_4B_HYP_TX_GPR_MASK     0xFFFFFFFF
#define REG_TX_BE_REG_4B_HYP_TX_GPR_SHIFT    0
#define REG_TX_BE_REG_4B_HYP_TX_GPR_WIDTH    32

/* TX_BE_REG_4C_HYP_TX_GPI */
/* Spare reserved register */
#define REG_TX_BE_REG_4C_HYP_TX_GPI          0x00130
#define REG_TX_BE_REG_4C_HYP_TX_GPI_MASK     0x0000FFFF
#define REG_TX_BE_REG_4C_HYP_TX_GPI_SHIFT    0
#define REG_TX_BE_REG_4C_HYP_TX_GPI_WIDTH    16

/* TX_BE_REG_4D_HYP_TX_GPI2 */
/* Spare reserved register */
#define REG_TX_BE_REG_4D_HYP_TX_GPI2          0x00134
#define REG_TX_BE_REG_4D_HYP_TX_GPI2_MASK     0x0000FFFF
#define REG_TX_BE_REG_4D_HYP_TX_GPI2_SHIFT    0
#define REG_TX_BE_REG_4D_HYP_TX_GPI2_WIDTH    16

/* TX_BE_REG_50_LDPC_ANT_EXCHANGE */
/* Write TX0 data to Port #1 and TX1 data to Port #0 */
#define REG_TX_BE_REG_50_LDPC_ANT_EXCHANGE          0x00140
#define REG_TX_BE_REG_50_LDPC_ANT_EXCHANGE_MASK     0x00000001
#define REG_TX_BE_REG_50_LDPC_ANT_EXCHANGE_SHIFT    0
#define REG_TX_BE_REG_50_LDPC_ANT_EXCHANGE_WIDTH    1

/* TX_BE_REG_51_LDPC_PERM_ADRS_PRE_0 */
/* LDPC Address permutating: Address to permutate number 0 */
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_0          0x00144
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_0_MASK     0x000000FF
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_0_SHIFT    0
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_0_WIDTH    8

/* TX_BE_REG_51_LDPC_PERM_ADRS_PRE_1 */
/* LDPC Address permutating: Address to permutate number 1 */
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_1          0x00144
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_1_MASK     0x0000FF00
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_1_SHIFT    8
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_1_WIDTH    8

/* TX_BE_REG_51_LDPC_PERM_ADRS_PRE_2 */
/* LDPC Address permutating: Address to permutate number 2 */
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_2          0x00144
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_2_MASK     0x00FF0000
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_2_SHIFT    16
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_2_WIDTH    8

/* TX_BE_REG_51_LDPC_PERM_ADRS_PRE_3 */
/* LDPC Address permutating: Address to permutate number 3 */
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_3          0x00144
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_3_MASK     0xFF000000
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_3_SHIFT    24
#define REG_TX_BE_REG_51_LDPC_PERM_ADRS_PRE_3_WIDTH    8

/* TX_BE_REG_52_LDPC_PERM_ADRS_POST_0 */
/* LDPC Address permutating: Permutated address permutate number 0 */
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_0          0x00148
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_0_MASK     0x000000FF
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_0_SHIFT    0
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_0_WIDTH    8

/* TX_BE_REG_52_LDPC_PERM_ADRS_POST_1 */
/* LDPC Address permutating: Permutated address permutate number 1 */
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_1          0x00148
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_1_MASK     0x0000FF00
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_1_SHIFT    8
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_1_WIDTH    8

/* TX_BE_REG_52_LDPC_PERM_ADRS_POST_2 */
/* LDPC Address permutating: Permutated address permutate number 2 */
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_2          0x00148
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_2_MASK     0x00FF0000
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_2_SHIFT    16
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_2_WIDTH    8

/* TX_BE_REG_52_LDPC_PERM_ADRS_POST_3 */
/* LDPC Address permutating: Permutated address permutate number 3 */
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_3          0x00148
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_3_MASK     0xFF000000
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_3_SHIFT    24
#define REG_TX_BE_REG_52_LDPC_PERM_ADRS_POST_3_WIDTH    8

/* TX_BE_REG_53_LDPC_NUM_OF_ADRS_PERM */
/* LDPC number of address permutations */
#define REG_TX_BE_REG_53_LDPC_NUM_OF_ADRS_PERM          0x0014C
#define REG_TX_BE_REG_53_LDPC_NUM_OF_ADRS_PERM_MASK     0x00000003
#define REG_TX_BE_REG_53_LDPC_NUM_OF_ADRS_PERM_SHIFT    0
#define REG_TX_BE_REG_53_LDPC_NUM_OF_ADRS_PERM_WIDTH    2

/* TX_BE_REG_53_LDPC_PUNC_START_ADDRESS */
/* LDPC Puncture start address */
#define REG_TX_BE_REG_53_LDPC_PUNC_START_ADDRESS          0x0014C
#define REG_TX_BE_REG_53_LDPC_PUNC_START_ADDRESS_MASK     0x00000FF0
#define REG_TX_BE_REG_53_LDPC_PUNC_START_ADDRESS_SHIFT    4
#define REG_TX_BE_REG_53_LDPC_PUNC_START_ADDRESS_WIDTH    8

/* TX_BE_REG_53_LDPC_PUNC_ADDRESS_JUMP */
/* LDPC Puncture address jump */
#define REG_TX_BE_REG_53_LDPC_PUNC_ADDRESS_JUMP          0x0014C
#define REG_TX_BE_REG_53_LDPC_PUNC_ADDRESS_JUMP_MASK     0x00030000
#define REG_TX_BE_REG_53_LDPC_PUNC_ADDRESS_JUMP_SHIFT    16
#define REG_TX_BE_REG_53_LDPC_PUNC_ADDRESS_JUMP_WIDTH    2

/* TX_BE_REG_57_MODEM_11B_PHY_DIS_DLY */
/* number of system delay cycles from PHY TX end to MAC TX not ready */
#define REG_TX_BE_REG_57_MODEM_11B_PHY_DIS_DLY          0x0015C
#define REG_TX_BE_REG_57_MODEM_11B_PHY_DIS_DLY_MASK     0x00000FFF
#define REG_TX_BE_REG_57_MODEM_11B_PHY_DIS_DLY_SHIFT    0
#define REG_TX_BE_REG_57_MODEM_11B_PHY_DIS_DLY_WIDTH    12

/* TX_BE_REG_57_MODEM_11B_PHY_ENA_DLY */
/* number of system delay cycles from MAC TX enable to PHY TX start req */
#define REG_TX_BE_REG_57_MODEM_11B_PHY_ENA_DLY          0x0015C
#define REG_TX_BE_REG_57_MODEM_11B_PHY_ENA_DLY_MASK     0x0FFF0000
#define REG_TX_BE_REG_57_MODEM_11B_PHY_ENA_DLY_SHIFT    16
#define REG_TX_BE_REG_57_MODEM_11B_PHY_ENA_DLY_WIDTH    12

/* TX_BE_REG_58_MODEM_11B_SERVICE_DATA */
/* Modem 802.11B Sevice data */
#define REG_TX_BE_REG_58_MODEM_11B_SERVICE_DATA          0x00160
#define REG_TX_BE_REG_58_MODEM_11B_SERVICE_DATA_MASK     0x000000FF
#define REG_TX_BE_REG_58_MODEM_11B_SERVICE_DATA_SHIFT    0
#define REG_TX_BE_REG_58_MODEM_11B_SERVICE_DATA_WIDTH    8

/* TX_BE_REG_58_MODEM_11B_PHY_END_DLY */
/* number of u sec (resolution 1us) from PHY RX packet end (PSDU) to MAC RX not ready (default 1us) */
#define REG_TX_BE_REG_58_MODEM_11B_PHY_END_DLY          0x00160
#define REG_TX_BE_REG_58_MODEM_11B_PHY_END_DLY_MASK     0x000F0000
#define REG_TX_BE_REG_58_MODEM_11B_PHY_END_DLY_SHIFT    16
#define REG_TX_BE_REG_58_MODEM_11B_PHY_END_DLY_WIDTH    4

/* TX_BE_REG_58_MODEM_11B_RAS_TX_ANT_EN */
/* Only 2 bits should be set (3'b011 / 3'b101 / 3'b101) */
#define REG_TX_BE_REG_58_MODEM_11B_RAS_TX_ANT_EN          0x00160
#define REG_TX_BE_REG_58_MODEM_11B_RAS_TX_ANT_EN_MASK     0x00700000
#define REG_TX_BE_REG_58_MODEM_11B_RAS_TX_ANT_EN_SHIFT    20
#define REG_TX_BE_REG_58_MODEM_11B_RAS_TX_ANT_EN_WIDTH    3

/* TX_BE_REG_59_MODEM_11B_TP_MODE */
/* Modem 802.11B test plugs mode control:
MODEM_DIAG_0_TP  = 4'b0000
MODEM_DIAG_1_TP  = 4'b0001
MODEM_DIAG_2_TP  = 4'b0010
DETECTOR_0_TP       = 4'b0011
DETECTOR_1_TP       = 4'b0100
DETECTOR_2_TP       = 4'b0101
DCC_TP                     = 4'b0110
RX_ENV_TP               = 4'b0111
ADC_IN_TP                = 4'b1000
TX_OUT_TP                = 4'b1001
RX_PHY_MAC_TP      = 4'b1010
TX_PHY_MAC_TP      = 4'b1011
 */
#define REG_TX_BE_REG_59_MODEM_11B_TP_MODE          0x00164
#define REG_TX_BE_REG_59_MODEM_11B_TP_MODE_MASK     0x0000000f
#define REG_TX_BE_REG_59_MODEM_11B_TP_MODE_SHIFT    0
#define REG_TX_BE_REG_59_MODEM_11B_TP_MODE_WIDTH    4

/* TX_BE_REG_59_MODEM_11B_RAS_POWER_TH */
/* Threshold for minimum power in detection (filters detections from detector) */
#define REG_TX_BE_REG_59_MODEM_11B_RAS_POWER_TH          0x00164
#define REG_TX_BE_REG_59_MODEM_11B_RAS_POWER_TH_MASK     0x03fffff0
#define REG_TX_BE_REG_59_MODEM_11B_RAS_POWER_TH_SHIFT    4
#define REG_TX_BE_REG_59_MODEM_11B_RAS_POWER_TH_WIDTH    22

/* TX_BE_REG_59_MODEM_11B_BYPASS_STB_BALANCER */
/* Bypass the balance machine for the razor strobe */
#define REG_TX_BE_REG_59_MODEM_11B_BYPASS_STB_BALANCER          0x00164
#define REG_TX_BE_REG_59_MODEM_11B_BYPASS_STB_BALANCER_MASK     0x10000000
#define REG_TX_BE_REG_59_MODEM_11B_BYPASS_STB_BALANCER_SHIFT    28
#define REG_TX_BE_REG_59_MODEM_11B_BYPASS_STB_BALANCER_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00_MASK     0x00000001
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00_SHIFT    0
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_01 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_01          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_01_MASK     0x00000002
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_01_SHIFT    1
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_01_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_02 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_02          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_02_MASK     0x00000004
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_02_SHIFT    2
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_02_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_03 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_03          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_03_MASK     0x00000008
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_03_SHIFT    3
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_03_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_04 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_04          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_04_MASK     0x00000010
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_04_SHIFT    4
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_04_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_05 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_05          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_05_MASK     0x00000020
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_05_SHIFT    5
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_05_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_06 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_06          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_06_MASK     0x00000040
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_06_SHIFT    6
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_06_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_07 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_07          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_07_MASK     0x00000080
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_07_SHIFT    7
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_07_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_08 */
/* Enable local test plug number.
Refer to Test Bus Documentation. */
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_08          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_08_MASK     0x00000100
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_08_SHIFT    8
#define REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_08_WIDTH    1

/* TX_BE_REG_5A_TX0_FE_TEST_PLUG_MUX_CONTROL */
/* Tx0 Front End Test Plug Mux Control */
#define REG_TX_BE_REG_5A_TX0_FE_TEST_PLUG_MUX_CONTROL          0x00168
#define REG_TX_BE_REG_5A_TX0_FE_TEST_PLUG_MUX_CONTROL_MASK     0x00030000
#define REG_TX_BE_REG_5A_TX0_FE_TEST_PLUG_MUX_CONTROL_SHIFT    16
#define REG_TX_BE_REG_5A_TX0_FE_TEST_PLUG_MUX_CONTROL_WIDTH    2

/* TX_BE_REG_5A_TX1_FE_TEST_PLUG_MUX_CONTROL */
/* Tx1 Front End Test Plug Mux Control */
#define REG_TX_BE_REG_5A_TX1_FE_TEST_PLUG_MUX_CONTROL          0x00168
#define REG_TX_BE_REG_5A_TX1_FE_TEST_PLUG_MUX_CONTROL_MASK     0x000C0000
#define REG_TX_BE_REG_5A_TX1_FE_TEST_PLUG_MUX_CONTROL_SHIFT    18
#define REG_TX_BE_REG_5A_TX1_FE_TEST_PLUG_MUX_CONTROL_WIDTH    2

/* TX_BE_REG_5A_TEST_PLUG_STB_40_80_EN */
/* Eanbles MAC-PHY IF output at a constant rate of 40 or 80 Mhz */
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_EN          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_EN_MASK     0x00100000
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_EN_SHIFT    20
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_EN_WIDTH    1

/* TX_BE_REG_5A_TEST_PLUG_STB_40_80_SEL */
/* Selects MAC-PHY IF output rate of 40 or 80 Mhz */
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_SEL          0x00168
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_SEL_MASK     0x00200000
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_SEL_SHIFT    21
#define REG_TX_BE_REG_5A_TEST_PLUG_STB_40_80_SEL_WIDTH    1

/* TX_BE_REG_5A_TX2_FE_TEST_PLUG_MUX_CONTROL */
/* Tx2 Front End Test Plug Mux Control */
#define REG_TX_BE_REG_5A_TX2_FE_TEST_PLUG_MUX_CONTROL          0x00168
#define REG_TX_BE_REG_5A_TX2_FE_TEST_PLUG_MUX_CONTROL_MASK     0x00C00000
#define REG_TX_BE_REG_5A_TX2_FE_TEST_PLUG_MUX_CONTROL_SHIFT    22
#define REG_TX_BE_REG_5A_TX2_FE_TEST_PLUG_MUX_CONTROL_WIDTH    2

/* TX_BE_REG_5A_FILTER_2_TB */
/* choose first interpolation filter to test bus else amp_gain_scale */
#define REG_TX_BE_REG_5A_FILTER_2_TB          0x00168
#define REG_TX_BE_REG_5A_FILTER_2_TB_MASK     0x01000000
#define REG_TX_BE_REG_5A_FILTER_2_TB_SHIFT    24
#define REG_TX_BE_REG_5A_FILTER_2_TB_WIDTH    1

/* TX_BE_REG_5B_TEST_BUS_LOW_OUT_SELECT */
/* Test Bus chain output mux select low, mid or high to low */
#define REG_TX_BE_REG_5B_TEST_BUS_LOW_OUT_SELECT          0x0016C
#define REG_TX_BE_REG_5B_TEST_BUS_LOW_OUT_SELECT_MASK     0x00000003
#define REG_TX_BE_REG_5B_TEST_BUS_LOW_OUT_SELECT_SHIFT    0
#define REG_TX_BE_REG_5B_TEST_BUS_LOW_OUT_SELECT_WIDTH    2

/* TX_BE_REG_5B_TEST_BUS_MID_OUT_SELECT */
/* Test Bus chain output mux select low, mid or high to mid */
#define REG_TX_BE_REG_5B_TEST_BUS_MID_OUT_SELECT          0x0016C
#define REG_TX_BE_REG_5B_TEST_BUS_MID_OUT_SELECT_MASK     0x0000000c
#define REG_TX_BE_REG_5B_TEST_BUS_MID_OUT_SELECT_SHIFT    2
#define REG_TX_BE_REG_5B_TEST_BUS_MID_OUT_SELECT_WIDTH    2

/* TX_BE_REG_5B_TEST_BUS_HIGH_OUT_SELECT */
/* Test Bus chain output mux select low, mid or high to hign */
#define REG_TX_BE_REG_5B_TEST_BUS_HIGH_OUT_SELECT          0x0016C
#define REG_TX_BE_REG_5B_TEST_BUS_HIGH_OUT_SELECT_MASK     0x00000030
#define REG_TX_BE_REG_5B_TEST_BUS_HIGH_OUT_SELECT_SHIFT    4
#define REG_TX_BE_REG_5B_TEST_BUS_HIGH_OUT_SELECT_WIDTH    2

/* TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_0 */
/* Modem 802.11B Detectors K coefficent 0 */
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_0          0x00170
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_0_MASK     0x0000003F
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_0_SHIFT    0
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_0_WIDTH    6

/* TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_1 */
/* Modem 802.11B Detectors K coefficent 1 */
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_1          0x00170
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_1_MASK     0x00000FC0
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_1_SHIFT    6
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_1_WIDTH    6

/* TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_2 */
/* Modem 802.11B Detectors K coefficent 2 */
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_2          0x00170
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_2_MASK     0x0003F000
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_2_SHIFT    12
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_2_WIDTH    6

/* TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_3 */
/* Modem 802.11B Detectors K coefficent 3 */
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_3          0x00170
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_3_MASK     0x00FC0000
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_3_SHIFT    18
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_3_WIDTH    6

/* TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_4 */
/* Modem 802.11B Detectors K coefficent 4 */
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_4          0x00170
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_4_MASK     0x3F000000
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_4_SHIFT    24
#define REG_TX_BE_REG_5C_MODEM_11B_DT_COEFF_K_4_WIDTH    6

/* TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_5 */
/* Modem 802.11B Detectors K coefficent 5 */
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_5          0x00174
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_5_MASK     0x0000003F
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_5_SHIFT    0
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_5_WIDTH    6

/* TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_6 */
/* Modem 802.11B Detectors K coefficent 6 */
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_6          0x00174
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_6_MASK     0x00000FC0
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_6_SHIFT    6
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_6_WIDTH    6

/* TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_7 */
/* Modem 802.11B Detectors K coefficent 7 */
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_7          0x00174
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_7_MASK     0x0003F000
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_7_SHIFT    12
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_7_WIDTH    6

/* TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_8 */
/* Modem 802.11B Detectors K coefficent 8 */
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_8          0x00174
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_8_MASK     0x00FC0000
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_8_SHIFT    18
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_8_WIDTH    6

/* TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_9 */
/* Modem 802.11B Detectors K coefficent 9 */
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_9          0x00174
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_9_MASK     0x3F000000
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_9_SHIFT    24
#define REG_TX_BE_REG_5D_MODEM_11B_DT_COEFF_K_9_WIDTH    6

/* TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_0 */
/* Modem 802.11B Detectors G coefficent 0 */
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_0          0x00178
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_0_MASK     0x0000003F
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_0_SHIFT    0
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_0_WIDTH    6

/* TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_1 */
/* Modem 802.11B Detectors G coefficent 1 */
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_1          0x00178
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_1_MASK     0x00000FC0
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_1_SHIFT    6
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_1_WIDTH    6

/* TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_2 */
/* Modem 802.11B Detectors G coefficent 2 */
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_2          0x00178
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_2_MASK     0x0003F000
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_2_SHIFT    12
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_2_WIDTH    6

/* TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_3 */
/* Modem 802.11B Detectors G coefficent 3 */
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_3          0x00178
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_3_MASK     0x00FC0000
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_3_SHIFT    18
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_3_WIDTH    6

/* TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_4 */
/* Modem 802.11B Detectors G coefficent 4 */
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_4          0x00178
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_4_MASK     0x3F000000
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_4_SHIFT    24
#define REG_TX_BE_REG_5E_MODEM_11B_DT_COEFF_G_4_WIDTH    6

/* TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_5 */
/* Modem 802.11B Detectors G coefficent 5 */
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_5          0x0017C
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_5_MASK     0x0000003F
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_5_SHIFT    0
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_5_WIDTH    6

/* TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_6 */
/* Modem 802.11B Detectors G coefficent 6 */
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_6          0x0017C
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_6_MASK     0x00000FC0
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_6_SHIFT    6
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_6_WIDTH    6

/* TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_7 */
/* Modem 802.11B Detectors G coefficent 7 */
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_7          0x0017C
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_7_MASK     0x0003F000
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_7_SHIFT    12
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_7_WIDTH    6

/* TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_8 */
/* Modem 802.11B Detectors G coefficent 8 */
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_8          0x0017C
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_8_MASK     0x00FC0000
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_8_SHIFT    18
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_8_WIDTH    6

/* TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_9 */
/* Modem 802.11B Detectors G coefficent 9 */
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_9          0x0017C
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_9_MASK     0x3F000000
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_9_SHIFT    24
#define REG_TX_BE_REG_5F_MODEM_11B_DT_COEFF_G_9_WIDTH    6

/* TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_0 */
/* Modem 802.11B Detectors corelator coefficent 0 */
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_0          0x00180
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_0_MASK     0x0000001f
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_0_SHIFT    0
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_0_WIDTH    5

/* TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_1 */
/* Modem 802.11B Detectors corelator coefficent 1 */
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_1          0x00180
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_1_MASK     0x000003e0
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_1_SHIFT    5
#define REG_TX_BE_REG_60_MODEM_11B_DT_COEFF_CORREL_1_WIDTH    5

/* TX_BE_REG_60_MODEM_11B_DUP_MOD_GAIN_SEL */
/* Select Gain factor for 11b duplicate mode */
#define REG_TX_BE_REG_60_MODEM_11B_DUP_MOD_GAIN_SEL          0x00180
#define REG_TX_BE_REG_60_MODEM_11B_DUP_MOD_GAIN_SEL_MASK     0x0000F000
#define REG_TX_BE_REG_60_MODEM_11B_DUP_MOD_GAIN_SEL_SHIFT    12
#define REG_TX_BE_REG_60_MODEM_11B_DUP_MOD_GAIN_SEL_WIDTH    4

/* TX_BE_REG_60_MODEM_11B_CH_BOND_GAIN_SEL */
/* Select Gain factor for 11b normal channel bonding mode */
#define REG_TX_BE_REG_60_MODEM_11B_CH_BOND_GAIN_SEL          0x00180
#define REG_TX_BE_REG_60_MODEM_11B_CH_BOND_GAIN_SEL_MASK     0x000f0000
#define REG_TX_BE_REG_60_MODEM_11B_CH_BOND_GAIN_SEL_SHIFT    16
#define REG_TX_BE_REG_60_MODEM_11B_CH_BOND_GAIN_SEL_WIDTH    4

/* TX_BE_REG_61_R1_PILOTS_LONG_NCB_TBL */
/* Select the Bins mapping table address for Rank 1 pilots mode in Long preamble and in non CB mode */
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_NCB_TBL          0x00184
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_NCB_TBL_MASK     0x00000003
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_NCB_TBL_SHIFT    0
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_NCB_TBL_WIDTH    2

/* TX_BE_REG_61_R1_PILOTS_LONG_FCB_TBL */
/* Select the Bins mapping table address for Rank 1 pilots mode in Long preamble and in Full CB mode */
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_FCB_TBL          0x00184
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_FCB_TBL_MASK     0x00000030
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_FCB_TBL_SHIFT    4
#define REG_TX_BE_REG_61_R1_PILOTS_LONG_FCB_TBL_WIDTH    2

/* TX0_FE_REG_00_TX0_AFE_OUT_AT_NEGEDGE */
/* If set the output from the AFE interface will be changed every ACLK negedge */
#define REG_TX0_FE_REG_00_TX0_AFE_OUT_AT_NEGEDGE          0x00400
#define REG_TX0_FE_REG_00_TX0_AFE_OUT_AT_NEGEDGE_MASK     0x00000001
#define REG_TX0_FE_REG_00_TX0_AFE_OUT_AT_NEGEDGE_SHIFT    0
#define REG_TX0_FE_REG_00_TX0_AFE_OUT_AT_NEGEDGE_WIDTH    1

/* TX0_FE_REG_07_TX0_ROUND_INIT */
/* Scaling on Interpolation filter output. */
#define REG_TX0_FE_REG_07_TX0_ROUND_INIT          0x0041C
#define REG_TX0_FE_REG_07_TX0_ROUND_INIT_MASK     0x0000000F
#define REG_TX0_FE_REG_07_TX0_ROUND_INIT_SHIFT    0
#define REG_TX0_FE_REG_07_TX0_ROUND_INIT_WIDTH    4

/* TX0_FE_REG_07_TX_FILTER_11B_ROUND_INIT */
/* Scaling on Interpolation filter output, when TX 11B packets */
#define REG_TX0_FE_REG_07_TX_FILTER_11B_ROUND_INIT          0x0041C
#define REG_TX0_FE_REG_07_TX_FILTER_11B_ROUND_INIT_MASK     0x000000F0
#define REG_TX0_FE_REG_07_TX_FILTER_11B_ROUND_INIT_SHIFT    4
#define REG_TX0_FE_REG_07_TX_FILTER_11B_ROUND_INIT_WIDTH    4

/* TX0_FE_REG_0B_TX0_PN_Q_PRBS_INIT */
/* Q-phase data PN noise generator init value. */
#define REG_TX0_FE_REG_0B_TX0_PN_Q_PRBS_INIT          0x0042C
#define REG_TX0_FE_REG_0B_TX0_PN_Q_PRBS_INIT_MASK     0x0000FFFF
#define REG_TX0_FE_REG_0B_TX0_PN_Q_PRBS_INIT_SHIFT    0
#define REG_TX0_FE_REG_0B_TX0_PN_Q_PRBS_INIT_WIDTH    16

/* TX0_FE_REG_0B_TX0_PN_I_PRBS_INIT */
/* I-phase data PN noise generator init value. */
#define REG_TX0_FE_REG_0B_TX0_PN_I_PRBS_INIT          0x0042C
#define REG_TX0_FE_REG_0B_TX0_PN_I_PRBS_INIT_MASK     0xFFFF0000
#define REG_TX0_FE_REG_0B_TX0_PN_I_PRBS_INIT_SHIFT    16
#define REG_TX0_FE_REG_0B_TX0_PN_I_PRBS_INIT_WIDTH    16

/* TX0_FE_REG_0C_TX0_PN_MAP_0_VAL */
/* PN noise generator mapping value for input bit = "0". */
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_0_VAL          0x00430
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_0_VAL_MASK     0x00000FFF
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_0_VAL_SHIFT    0
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_0_VAL_WIDTH    12

/* TX0_FE_REG_0C_TX0_PN_MAP_1_VAL */
/* PN noise generator mapping value for input bit = "1". */
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_1_VAL          0x00430
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_1_VAL_MASK     0x00FFF000
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_1_VAL_SHIFT    12
#define REG_TX0_FE_REG_0C_TX0_PN_MAP_1_VAL_WIDTH    12

/* TX0_FE_REG_0D_TX0_PN_GEN_MODE */
/* PN noise generator active if "1". */
#define REG_TX0_FE_REG_0D_TX0_PN_GEN_MODE          0x00434
#define REG_TX0_FE_REG_0D_TX0_PN_GEN_MODE_MASK     0x00000001
#define REG_TX0_FE_REG_0D_TX0_PN_GEN_MODE_SHIFT    0
#define REG_TX0_FE_REG_0D_TX0_PN_GEN_MODE_WIDTH    1

/* TX0_FE_REG_0E_TX0_AFE_IDLE_I_DATA */
/* AFE output data when not packet and not PN Noise generator mode */
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_I_DATA          0x00438
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_I_DATA_MASK     0x0FFF0000
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_I_DATA_SHIFT    16
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_I_DATA_WIDTH    12

/* TX0_FE_REG_0E_TX0_AFE_IDLE_Q_DATA */
/* AFE output data when not packet and not PN Noise generator mode */
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_Q_DATA          0x00438
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_Q_DATA_MASK     0x00000FFF
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_Q_DATA_SHIFT    0
#define REG_TX0_FE_REG_0E_TX0_AFE_IDLE_Q_DATA_WIDTH    12

/* TX0_FE_REG_0F_TX0_AFE_MAG_LIMIT_TRESHOLD */
/* AFE Magnitude Limit Treshold value */
#define REG_TX0_FE_REG_0F_TX0_AFE_MAG_LIMIT_TRESHOLD          0x0043C
#define REG_TX0_FE_REG_0F_TX0_AFE_MAG_LIMIT_TRESHOLD_MASK     0x000000FF
#define REG_TX0_FE_REG_0F_TX0_AFE_MAG_LIMIT_TRESHOLD_SHIFT    0
#define REG_TX0_FE_REG_0F_TX0_AFE_MAG_LIMIT_TRESHOLD_WIDTH    8

/* TX1_FE_REG_00_TX1_AFE_OUT_AT_NEGEDGE */
/* If set the output from the AFE interface will be changed every ACLK negedge */
#define REG_TX1_FE_REG_00_TX1_AFE_OUT_AT_NEGEDGE          0x00800
#define REG_TX1_FE_REG_00_TX1_AFE_OUT_AT_NEGEDGE_MASK     0x00000001
#define REG_TX1_FE_REG_00_TX1_AFE_OUT_AT_NEGEDGE_SHIFT    0
#define REG_TX1_FE_REG_00_TX1_AFE_OUT_AT_NEGEDGE_WIDTH    1

/* TX1_FE_REG_07_TX1_ROUND_INIT */
/* Scaling on Interpolation filter output. */
#define REG_TX1_FE_REG_07_TX1_ROUND_INIT          0x0081C
#define REG_TX1_FE_REG_07_TX1_ROUND_INIT_MASK     0x0000000F
#define REG_TX1_FE_REG_07_TX1_ROUND_INIT_SHIFT    0
#define REG_TX1_FE_REG_07_TX1_ROUND_INIT_WIDTH    4

/* TX1_FE_REG_0B_TX1_PN_Q_PRBS_INIT */
/* Q-phase data PN noise generator init value. */
#define REG_TX1_FE_REG_0B_TX1_PN_Q_PRBS_INIT          0x0082C
#define REG_TX1_FE_REG_0B_TX1_PN_Q_PRBS_INIT_MASK     0x0000FFFF
#define REG_TX1_FE_REG_0B_TX1_PN_Q_PRBS_INIT_SHIFT    0
#define REG_TX1_FE_REG_0B_TX1_PN_Q_PRBS_INIT_WIDTH    16

/* TX1_FE_REG_0B_TX1_PN_I_PRBS_INIT */
/* I-phase data PN noise generator init value. */
#define REG_TX1_FE_REG_0B_TX1_PN_I_PRBS_INIT          0x0082C
#define REG_TX1_FE_REG_0B_TX1_PN_I_PRBS_INIT_MASK     0xFFFF0000
#define REG_TX1_FE_REG_0B_TX1_PN_I_PRBS_INIT_SHIFT    16
#define REG_TX1_FE_REG_0B_TX1_PN_I_PRBS_INIT_WIDTH    16

/* TX1_FE_REG_0C_TX1_PN_MAP_0_VAL */
/* PN noise generator mapping value for input bit = "0". */
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_0_VAL          0x00830
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_0_VAL_MASK     0x00000FFF
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_0_VAL_SHIFT    0
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_0_VAL_WIDTH    12

/* TX1_FE_REG_0C_TX1_PN_MAP_1_VAL */
/* PN noise generator mapping value for input bit = "1". */
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_1_VAL          0x00830
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_1_VAL_MASK     0x00FFF000
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_1_VAL_SHIFT    12
#define REG_TX1_FE_REG_0C_TX1_PN_MAP_1_VAL_WIDTH    12

/* TX1_FE_REG_0D_TX1_PN_GEN_MODE */
/* PN noise generator active if "1". */
#define REG_TX1_FE_REG_0D_TX1_PN_GEN_MODE          0x00834
#define REG_TX1_FE_REG_0D_TX1_PN_GEN_MODE_MASK     0x00000001
#define REG_TX1_FE_REG_0D_TX1_PN_GEN_MODE_SHIFT    0
#define REG_TX1_FE_REG_0D_TX1_PN_GEN_MODE_WIDTH    1

/* TX1_FE_REG_0E_TX1_AFE_IDLE_I_DATA */
/* AFE output data when not packet and not PN Noise generator mode */
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_I_DATA          0x00838
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_I_DATA_MASK     0x0FFF0000
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_I_DATA_SHIFT    16
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_I_DATA_WIDTH    12

/* TX1_FE_REG_0E_TX1_AFE_IDLE_Q_DATA */
/* AFE output data when not packet and not PN Noise generator mode */
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_Q_DATA          0x00838
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_Q_DATA_MASK     0x00000FFF
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_Q_DATA_SHIFT    0
#define REG_TX1_FE_REG_0E_TX1_AFE_IDLE_Q_DATA_WIDTH    12

/* TX1_FE_REG_0F_TX1_AFE_MAG_LIMIT_TRESHOLD */
/* AFE Magnitude Limit Treshold value */
#define REG_TX1_FE_REG_0F_TX1_AFE_MAG_LIMIT_TRESHOLD          0x0083C
#define REG_TX1_FE_REG_0F_TX1_AFE_MAG_LIMIT_TRESHOLD_MASK     0x000000FF
#define REG_TX1_FE_REG_0F_TX1_AFE_MAG_LIMIT_TRESHOLD_SHIFT    0
#define REG_TX1_FE_REG_0F_TX1_AFE_MAG_LIMIT_TRESHOLD_WIDTH    8

/* TX_BE_RAM_RM_REG_TPC_RAM_RM */
#define REG_TX_BE_RAM_RM_REG_TPC_RAM_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_TPC_RAM_RM_MASK     0x00000007
#define REG_TX_BE_RAM_RM_REG_TPC_RAM_RM_SHIFT    0
#define REG_TX_BE_RAM_RM_REG_TPC_RAM_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_LDPC_BUFF_0_RM */
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_0_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_0_RM_MASK     0x00000070
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_0_RM_SHIFT    4
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_0_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_LDPC_BUFF_1_RM */
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_1_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_1_RM_MASK     0x00000700
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_1_RM_SHIFT    8
#define REG_TX_BE_RAM_RM_REG_LDPC_BUFF_1_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_INTER_RAM_0_0_RM */
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_0_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_0_RM_MASK     0x00007000
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_0_RM_SHIFT    12
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_0_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_INTER_RAM_0_1_RM */
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_1_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_1_RM_MASK     0x00070000
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_1_RM_SHIFT    16
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_0_1_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_INTER_RAM_1_0_RM */
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_0_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_0_RM_MASK     0x00700000
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_0_RM_SHIFT    20
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_0_RM_WIDTH    3

/* TX_BE_RAM_RM_REG_INTER_RAM_1_1_RM */
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_1_RM          0x00840
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_1_RM_MASK     0x07000000
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_1_RM_SHIFT    24
#define REG_TX_BE_RAM_RM_REG_INTER_RAM_1_1_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_BIN_CHOOSER_RAM_RM */
#define REG_TX0_FE_RAM_RM_REG0_TX0_BIN_CHOOSER_RAM_RM          0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_BIN_CHOOSER_RAM_RM_MASK     0x00000070
#define REG_TX0_FE_RAM_RM_REG0_TX0_BIN_CHOOSER_RAM_RM_SHIFT    4
#define REG_TX0_FE_RAM_RM_REG0_TX0_BIN_CHOOSER_RAM_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_RIPPLE_RAM_RM */
#define REG_TX0_FE_RAM_RM_REG0_TX0_RIPPLE_RAM_RM          0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_RIPPLE_RAM_RM_MASK     0x00000700
#define REG_TX0_FE_RAM_RM_REG0_TX0_RIPPLE_RAM_RM_SHIFT    8
#define REG_TX0_FE_RAM_RM_REG0_TX0_RIPPLE_RAM_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_IQ_RAM_RM */
#define REG_TX0_FE_RAM_RM_REG0_TX0_IQ_RAM_RM          0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_IQ_RAM_RM_MASK     0x00007000
#define REG_TX0_FE_RAM_RM_REG0_TX0_IQ_RAM_RM_SHIFT    12
#define REG_TX0_FE_RAM_RM_REG0_TX0_IQ_RAM_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM0_RM  */
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM0_RM           0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM0_RM_MASK     0x00070000
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM0_RM_SHIFT    16
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM0_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM1_RM  */
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM1_RM           0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM1_RM_MASK     0x00700000
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM1_RM_SHIFT    20
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_O_RAM1_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM0_RM  */
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM0_RM           0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM0_RM_MASK     0x07000000
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM0_RM_SHIFT    24
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM0_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM1_RM  */
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM1_RM           0x00844
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM1_RM_MASK     0x70000000
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM1_RM_SHIFT    28
#define REG_TX0_FE_RAM_RM_REG0_TX0_FFT_FFT4_E_RAM1_RM_WIDTH    3

/* TX0_FE_RAM_RM_REG1_TX0_CYC_EXT_PREAMBLE_RAM_RM */
#define REG_TX0_FE_RAM_RM_REG1_TX0_CYC_EXT_PREAMBLE_RAM_RM          0x00848
#define REG_TX0_FE_RAM_RM_REG1_TX0_CYC_EXT_PREAMBLE_RAM_RM_MASK     0x00000007
#define REG_TX0_FE_RAM_RM_REG1_TX0_CYC_EXT_PREAMBLE_RAM_RM_SHIFT    0
#define REG_TX0_FE_RAM_RM_REG1_TX0_CYC_EXT_PREAMBLE_RAM_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_BIN_CHOOSER_RAM_RM */
#define REG_TX1_FE_RAM_RM_REG0_TX1_BIN_CHOOSER_RAM_RM          0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_BIN_CHOOSER_RAM_RM_MASK     0x00000070
#define REG_TX1_FE_RAM_RM_REG0_TX1_BIN_CHOOSER_RAM_RM_SHIFT    4
#define REG_TX1_FE_RAM_RM_REG0_TX1_BIN_CHOOSER_RAM_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_RIPPLE_RAM_RM */
#define REG_TX1_FE_RAM_RM_REG0_TX1_RIPPLE_RAM_RM          0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_RIPPLE_RAM_RM_MASK     0x00000700
#define REG_TX1_FE_RAM_RM_REG0_TX1_RIPPLE_RAM_RM_SHIFT    8
#define REG_TX1_FE_RAM_RM_REG0_TX1_RIPPLE_RAM_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_IQ_RAM_RM */
#define REG_TX1_FE_RAM_RM_REG0_TX1_IQ_RAM_RM          0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_IQ_RAM_RM_MASK     0x00007000
#define REG_TX1_FE_RAM_RM_REG0_TX1_IQ_RAM_RM_SHIFT    12
#define REG_TX1_FE_RAM_RM_REG0_TX1_IQ_RAM_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM0_RM  */
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM0_RM           0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM0_RM_MASK     0x00070000
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM0_RM_SHIFT    16
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM0_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM1_RM  */
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM1_RM           0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM1_RM_MASK     0x00700000
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM1_RM_SHIFT    20
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_O_RAM1_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM0_RM  */
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM0_RM           0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM0_RM_MASK     0x07000000
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM0_RM_SHIFT    24
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM0_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM1_RM  */
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM1_RM           0x0084C
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM1_RM_MASK     0x70000000
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM1_RM_SHIFT    28
#define REG_TX1_FE_RAM_RM_REG0_TX1_FFT_FFT4_E_RAM1_RM_WIDTH    3

/* TX1_FE_RAM_RM_REG1_TX1_CYC_EXT_PREAMBLE_RAM_RM */
#define REG_TX1_FE_RAM_RM_REG1_TX1_CYC_EXT_PREAMBLE_RAM_RM          0x00850
#define REG_TX1_FE_RAM_RM_REG1_TX1_CYC_EXT_PREAMBLE_RAM_RM_MASK     0x00000007
#define REG_TX1_FE_RAM_RM_REG1_TX1_CYC_EXT_PREAMBLE_RAM_RM_SHIFT    0
#define REG_TX1_FE_RAM_RM_REG1_TX1_CYC_EXT_PREAMBLE_RAM_RM_WIDTH    3

/* TX_GLBL_RAM_RM_REG_LONG_PREAMBLE_RAM_RM */
#define REG_TX_GLBL_RAM_RM_REG_LONG_PREAMBLE_RAM_RM          0x00854
#define REG_TX_GLBL_RAM_RM_REG_LONG_PREAMBLE_RAM_RM_MASK     0x00000007
#define REG_TX_GLBL_RAM_RM_REG_LONG_PREAMBLE_RAM_RM_SHIFT    0
#define REG_TX_GLBL_RAM_RM_REG_LONG_PREAMBLE_RAM_RM_WIDTH    3

/* TX_GLBL_RAM_RM_REG_COMMAND_RAM_RM */
#define REG_TX_GLBL_RAM_RM_REG_COMMAND_RAM_RM          0x00854
#define REG_TX_GLBL_RAM_RM_REG_COMMAND_RAM_RM_MASK     0x00000070
#define REG_TX_GLBL_RAM_RM_REG_COMMAND_RAM_RM_SHIFT    4
#define REG_TX_GLBL_RAM_RM_REG_COMMAND_RAM_RM_WIDTH    3

/* TX_2ND_FILTER_TX_2ND_FILTER_C0 */
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C0          0x00858
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C0_MASK     0x000003FF
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C0_SHIFT    0
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C0_WIDTH    10

/* TX_2ND_FILTER_TX_2ND_FILTER_C1 */
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C1          0x00858
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C1_MASK     0x000FFC00
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C1_SHIFT    10
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C1_WIDTH    10

/* TX_2ND_FILTER_TX_2ND_FILTER_C2 */
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C2          0x00858
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C2_MASK     0x3FF00000
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C2_SHIFT    20
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_C2_WIDTH    10

/* TX_2ND_FILTER_TX_2ND_FILTER_BYPASS */
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_BYPASS          0x00858
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_BYPASS_MASK     0x40000000
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_BYPASS_SHIFT    30
#define REG_TX_2ND_FILTER_TX_2ND_FILTER_BYPASS_WIDTH    1

/* TX_SYNC_FIFO_DCMTR_STRB_MODE */
#define REG_TX_SYNC_FIFO_DCMTR_STRB_MODE          0x0085C
#define REG_TX_SYNC_FIFO_DCMTR_STRB_MODE_MASK     0x00000001
#define REG_TX_SYNC_FIFO_DCMTR_STRB_MODE_SHIFT    0
#define REG_TX_SYNC_FIFO_DCMTR_STRB_MODE_WIDTH    1

/* TX_SYNC_FIFO_SEL_ODD_STRB */
#define REG_TX_SYNC_FIFO_SEL_ODD_STRB          0x0085C
#define REG_TX_SYNC_FIFO_SEL_ODD_STRB_MASK     0x00000002
#define REG_TX_SYNC_FIFO_SEL_ODD_STRB_SHIFT    1
#define REG_TX_SYNC_FIFO_SEL_ODD_STRB_WIDTH    1

/* TX_SYNC_FIFO_FIFO_INPUT_2TB */
#define REG_TX_SYNC_FIFO_FIFO_INPUT_2TB          0x0085C
#define REG_TX_SYNC_FIFO_FIFO_INPUT_2TB_MASK     0x00000004
#define REG_TX_SYNC_FIFO_FIFO_INPUT_2TB_SHIFT    2
#define REG_TX_SYNC_FIFO_FIFO_INPUT_2TB_WIDTH    1

/* TX_SYNC_FIFO_GEN_11B_EVEN_STRB_EN */
#define REG_TX_SYNC_FIFO_GEN_11B_EVEN_STRB_EN          0x0085C
#define REG_TX_SYNC_FIFO_GEN_11B_EVEN_STRB_EN_MASK     0x00000008
#define REG_TX_SYNC_FIFO_GEN_11B_EVEN_STRB_EN_SHIFT    3
#define REG_TX_SYNC_FIFO_GEN_11B_EVEN_STRB_EN_WIDTH    1

/* TX_SYNC_FIFO_FIFO_0_STATUS */
#define REG_TX_SYNC_FIFO_FIFO_0_STATUS          0x0085C
#define REG_TX_SYNC_FIFO_FIFO_0_STATUS_MASK     0x00000070
#define REG_TX_SYNC_FIFO_FIFO_0_STATUS_SHIFT    4
#define REG_TX_SYNC_FIFO_FIFO_0_STATUS_WIDTH    3

/* TX_SYNC_FIFO_FIFO_1_STATUS */
#define REG_TX_SYNC_FIFO_FIFO_1_STATUS          0x0085C
#define REG_TX_SYNC_FIFO_FIFO_1_STATUS_MASK     0x00000380
#define REG_TX_SYNC_FIFO_FIFO_1_STATUS_SHIFT    7
#define REG_TX_SYNC_FIFO_FIFO_1_STATUS_WIDTH    3

/* TX_SYNC_FIFO_FIFO_2_STATUS */
#define REG_TX_SYNC_FIFO_FIFO_2_STATUS          0x0085C
#define REG_TX_SYNC_FIFO_FIFO_2_STATUS_MASK     0x00001c00
#define REG_TX_SYNC_FIFO_FIFO_2_STATUS_SHIFT    10
#define REG_TX_SYNC_FIFO_FIFO_2_STATUS_WIDTH    3

/* TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL */
#define REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL          0x00860
#define REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL_MASK     0x00000001
#define REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL_SHIFT    0
#define REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL_WIDTH    1

/* TX_FFT_SHARING_FFT0_CONTROL_RX */
#define REG_TX_FFT_SHARING_FFT0_CONTROL_RX          0x00860
#define REG_TX_FFT_SHARING_FFT0_CONTROL_RX_MASK     0x00000010
#define REG_TX_FFT_SHARING_FFT0_CONTROL_RX_SHIFT    4
#define REG_TX_FFT_SHARING_FFT0_CONTROL_RX_WIDTH    1

/* TX_FFT_SHARING_FFT1_CONTROL_RX */
#define REG_TX_FFT_SHARING_FFT1_CONTROL_RX          0x00860
#define REG_TX_FFT_SHARING_FFT1_CONTROL_RX_MASK     0x00000020
#define REG_TX_FFT_SHARING_FFT1_CONTROL_RX_SHIFT    5
#define REG_TX_FFT_SHARING_FFT1_CONTROL_RX_WIDTH    1

/* TX_FFT_SHARING_FFT2_CONTROL_RX */
#define REG_TX_FFT_SHARING_FFT2_CONTROL_RX          0x00860
#define REG_TX_FFT_SHARING_FFT2_CONTROL_RX_MASK     0x00000040
#define REG_TX_FFT_SHARING_FFT2_CONTROL_RX_SHIFT    6
#define REG_TX_FFT_SHARING_FFT2_CONTROL_RX_WIDTH    1

/* TX_FFT_SHARING_FFT3_CONTROL_RX */
#define REG_TX_FFT_SHARING_FFT3_CONTROL_RX          0x00860
#define REG_TX_FFT_SHARING_FFT3_CONTROL_RX_MASK     0x00000080
#define REG_TX_FFT_SHARING_FFT3_CONTROL_RX_SHIFT    7
#define REG_TX_FFT_SHARING_FFT3_CONTROL_RX_WIDTH    1


/* TX_FFT_SHARING_FFT_GEN3_SAT_FIX_EN */
#define REG_TX_FFT_SHARING_FFT_GEN3_SAT_FIX_EN          0x00860
#define REG_TX_FFT_SHARING_FFT_GEN3_SAT_FIX_EN_MASK     0x00000100
#define REG_TX_FFT_SHARING_FFT_GEN3_SAT_FIX_EN_SHIFT    8
#define REG_TX_FFT_SHARING_FFT_GEN3_SAT_FIX_EN_WIDTH    1

/* DEFAULT_MATRIX_DEFAULT_MATRIX */
#define REG_DEFAULT_MATRIX_DEFAULT_MATRIX          0x00880
#define REG_DEFAULT_MATRIX_DEFAULT_MATRIX_MASK     0x3F000000
#define REG_DEFAULT_MATRIX_DEFAULT_MATRIX_SHIFT    24
#define REG_DEFAULT_MATRIX_DEFAULT_MATRIX_WIDTH    6

/* TX2_CONTROL_TX2_ENABLE */
#define REG_TX2_CONTROL_TX2_ENABLE          0x00884
#define REG_TX2_CONTROL_TX2_ENABLE_MASK     0x00000001
#define REG_TX2_CONTROL_TX2_ENABLE_SHIFT    0
#define REG_TX2_CONTROL_TX2_ENABLE_WIDTH    1

/* TX2_CONTROL_SM_BYPASS */
#define REG_TX2_CONTROL_SM_BYPASS          0x00884
#define REG_TX2_CONTROL_SM_BYPASS_MASK     0x00000002
#define REG_TX2_CONTROL_SM_BYPASS_SHIFT    1
#define REG_TX2_CONTROL_SM_BYPASS_WIDTH    1

/* TX2_CONTROL_CSD_BYPASS */
#define REG_TX2_CONTROL_CSD_BYPASS          0x00884
#define REG_TX2_CONTROL_CSD_BYPASS_MASK     0x00000004
#define REG_TX2_CONTROL_CSD_BYPASS_SHIFT    2
#define REG_TX2_CONTROL_CSD_BYPASS_WIDTH    1

/* TX2_CONTROL_TX2_AFE_IF_WR_AFTER_P_END */
#define REG_TX2_CONTROL_TX2_AFE_IF_WR_AFTER_P_END          0x00884
#define REG_TX2_CONTROL_TX2_AFE_IF_WR_AFTER_P_END_MASK     0x00000008
#define REG_TX2_CONTROL_TX2_AFE_IF_WR_AFTER_P_END_SHIFT    3
#define REG_TX2_CONTROL_TX2_AFE_IF_WR_AFTER_P_END_WIDTH    1

/* TX2_CONTROL_TX2_PN_GEN_MODE */
#define REG_TX2_CONTROL_TX2_PN_GEN_MODE          0x00884
#define REG_TX2_CONTROL_TX2_PN_GEN_MODE_MASK     0x00000010
#define REG_TX2_CONTROL_TX2_PN_GEN_MODE_SHIFT    4
#define REG_TX2_CONTROL_TX2_PN_GEN_MODE_WIDTH    1

/* TX2_CONTROL_TX2_AFE_OUT_SWAP_I_Q_EN */
#define REG_TX2_CONTROL_TX2_AFE_OUT_SWAP_I_Q_EN          0x00884
#define REG_TX2_CONTROL_TX2_AFE_OUT_SWAP_I_Q_EN_MASK     0x00000020
#define REG_TX2_CONTROL_TX2_AFE_OUT_SWAP_I_Q_EN_SHIFT    5
#define REG_TX2_CONTROL_TX2_AFE_OUT_SWAP_I_Q_EN_WIDTH    1

/* TX2_CONTROL_TX2_AFE_OUT_AT_NEGEDGE */
#define REG_TX2_CONTROL_TX2_AFE_OUT_AT_NEGEDGE          0x00884
#define REG_TX2_CONTROL_TX2_AFE_OUT_AT_NEGEDGE_MASK     0x00000040
#define REG_TX2_CONTROL_TX2_AFE_OUT_AT_NEGEDGE_SHIFT    6
#define REG_TX2_CONTROL_TX2_AFE_OUT_AT_NEGEDGE_WIDTH    1

/* TX2_CONTROL_TX2_ROUND_INIT */
#define REG_TX2_CONTROL_TX2_ROUND_INIT          0x00884
#define REG_TX2_CONTROL_TX2_ROUND_INIT_MASK     0x00000F00
#define REG_TX2_CONTROL_TX2_ROUND_INIT_SHIFT    8
#define REG_TX2_CONTROL_TX2_ROUND_INIT_WIDTH    4

/* TX2_CONTROL_HT_SHORT_EQUALIZER */
#define REG_TX2_CONTROL_HT_SHORT_EQUALIZER          0x00884
#define REG_TX2_CONTROL_HT_SHORT_EQUALIZER_MASK     0x00FFF000
#define REG_TX2_CONTROL_HT_SHORT_EQUALIZER_SHIFT    12
#define REG_TX2_CONTROL_HT_SHORT_EQUALIZER_WIDTH    12

/* TX2_CONTROL_TX2_AFE_MAG_LIMIT_TRESHOLD */
#define REG_TX2_CONTROL_TX2_AFE_MAG_LIMIT_TRESHOLD          0x00884
#define REG_TX2_CONTROL_TX2_AFE_MAG_LIMIT_TRESHOLD_MASK     0xFF000000
#define REG_TX2_CONTROL_TX2_AFE_MAG_LIMIT_TRESHOLD_SHIFT    24
#define REG_TX2_CONTROL_TX2_AFE_MAG_LIMIT_TRESHOLD_WIDTH    8

/* TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_I_DATA */
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_I_DATA          0x00888
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_I_DATA_MASK     0x00000FFF
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_I_DATA_SHIFT    0
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_I_DATA_WIDTH    12

/* TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_Q_DATA */
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_Q_DATA          0x00888
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_Q_DATA_MASK     0x00FFF000
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_Q_DATA_SHIFT    12
#define REG_TX2_AFE_IDLE_DATA_TX2_AFE_IDLE_Q_DATA_WIDTH    12

/* TX2_PN_MAP_TX2_PN_MAP_0_VAL */
#define REG_TX2_PN_MAP_TX2_PN_MAP_0_VAL          0x0088C
#define REG_TX2_PN_MAP_TX2_PN_MAP_0_VAL_MASK     0x00000FFF
#define REG_TX2_PN_MAP_TX2_PN_MAP_0_VAL_SHIFT    0
#define REG_TX2_PN_MAP_TX2_PN_MAP_0_VAL_WIDTH    12

/* TX2_PN_MAP_TX2_PN_MAP_1_VAL */
#define REG_TX2_PN_MAP_TX2_PN_MAP_1_VAL          0x0088C
#define REG_TX2_PN_MAP_TX2_PN_MAP_1_VAL_MASK     0x00FFF000
#define REG_TX2_PN_MAP_TX2_PN_MAP_1_VAL_SHIFT    12
#define REG_TX2_PN_MAP_TX2_PN_MAP_1_VAL_WIDTH    12

/* TX2_AFE_IF_PRBS_INIT_TX2_PN_I_PRBS_INIT */
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_I_PRBS_INIT          0x00890
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_I_PRBS_INIT_MASK     0x0000FFFF
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_I_PRBS_INIT_SHIFT    0
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_I_PRBS_INIT_WIDTH    16

/* TX2_AFE_IF_PRBS_INIT_TX2_PN_Q_PRBS_INIT */
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_Q_PRBS_INIT          0x00890
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_Q_PRBS_INIT_MASK     0xFFFF0000
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_Q_PRBS_INIT_SHIFT    16
#define REG_TX2_AFE_IF_PRBS_INIT_TX2_PN_Q_PRBS_INIT_WIDTH    16

/* DEBUG_AFE_TX_STREAMER_MODE */
#define REG_DEBUG_AFE_TX_STREAMER_MODE          0x00894
#define REG_DEBUG_AFE_TX_STREAMER_MODE_MASK     0x00000030
#define REG_DEBUG_AFE_TX_STREAMER_MODE_SHIFT    4
#define REG_DEBUG_AFE_TX_STREAMER_MODE_WIDTH    2

/* DEBUG_TX2_RIPPLE_RAM_RM */
#define REG_DEBUG_TX2_RIPPLE_RAM_RM          0x00894
#define REG_DEBUG_TX2_RIPPLE_RAM_RM_MASK     0x00000700
#define REG_DEBUG_TX2_RIPPLE_RAM_RM_SHIFT    8
#define REG_DEBUG_TX2_RIPPLE_RAM_RM_WIDTH    3

/* DEBUG_TX2_IQ_RAM_RM */
#define REG_DEBUG_TX2_IQ_RAM_RM          0x00894
#define REG_DEBUG_TX2_IQ_RAM_RM_MASK     0x00003800
#define REG_DEBUG_TX2_IQ_RAM_RM_SHIFT    11
#define REG_DEBUG_TX2_IQ_RAM_RM_WIDTH    3

/* DEBUG_TX2_FFT_FFT4_O_RAM0_RM */
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM0_RM          0x00894
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM0_RM_MASK     0x0001C000
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM0_RM_SHIFT    14
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM0_RM_WIDTH    3

/* DEBUG_TX2_FFT_FFT4_O_RAM1_RM */
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM1_RM          0x00894
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM1_RM_MASK     0x000E0000
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM1_RM_SHIFT    17
#define REG_DEBUG_TX2_FFT_FFT4_O_RAM1_RM_WIDTH    3

/* DEBUG_TX2_FFT_FFT4_E_RAM0_RM */
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM0_RM          0x00894
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM0_RM_MASK     0x00700000
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM0_RM_SHIFT    20
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM0_RM_WIDTH    3

/* DEBUG_TX2_FFT_FFT4_E_RAM1_RM */
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM1_RM          0x00894
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM1_RM_MASK     0x03800000
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM1_RM_SHIFT    23
#define REG_DEBUG_TX2_FFT_FFT4_E_RAM1_RM_WIDTH    3

/* DEBUG_TX2_CYC_EXT_PREAMBLE_RAM_RM */
#define REG_DEBUG_TX2_CYC_EXT_PREAMBLE_RAM_RM          0x00894
#define REG_DEBUG_TX2_CYC_EXT_PREAMBLE_RAM_RM_MASK     0x1C000000
#define REG_DEBUG_TX2_CYC_EXT_PREAMBLE_RAM_RM_SHIFT    26
#define REG_DEBUG_TX2_CYC_EXT_PREAMBLE_RAM_RM_WIDTH    3

/* TX2_BIST_DONE_TX2_BIST_DONE_BUS */
#define REG_TX2_BIST_DONE_TX2_BIST_DONE_BUS          0x00898
#define REG_TX2_BIST_DONE_TX2_BIST_DONE_BUS_MASK     0x0000007F
#define REG_TX2_BIST_DONE_TX2_BIST_DONE_BUS_SHIFT    0
#define REG_TX2_BIST_DONE_TX2_BIST_DONE_BUS_WIDTH    7

/* TX2_BIST_RESULT_TX2_BIST_RESULT_BUS */
#define REG_TX2_BIST_RESULT_TX2_BIST_RESULT_BUS          0x0089C
#define REG_TX2_BIST_RESULT_TX2_BIST_RESULT_BUS_MASK     0x0000007F
#define REG_TX2_BIST_RESULT_TX2_BIST_RESULT_BUS_SHIFT    0
#define REG_TX2_BIST_RESULT_TX2_BIST_RESULT_BUS_WIDTH    7

/* BEAM_FORMING0_LEGACY_STF_BOOST */
#define REG_BEAM_FORMING0_LEGACY_STF_BOOST          0x008A0
#define REG_BEAM_FORMING0_LEGACY_STF_BOOST_MASK     0x00000001
#define REG_BEAM_FORMING0_LEGACY_STF_BOOST_SHIFT    0
#define REG_BEAM_FORMING0_LEGACY_STF_BOOST_WIDTH    1

/* BEAM_FORMING0_INVERSE_CARRIER_JUMP */
#define REG_BEAM_FORMING0_INVERSE_CARRIER_JUMP          0x008A0
#define REG_BEAM_FORMING0_INVERSE_CARRIER_JUMP_MASK     0x00000FF0
#define REG_BEAM_FORMING0_INVERSE_CARRIER_JUMP_SHIFT    4
#define REG_BEAM_FORMING0_INVERSE_CARRIER_JUMP_WIDTH    8

/* BEAM_FORMING0_SOUNDING_SCALE_1SS_SEL */
#define REG_BEAM_FORMING0_SOUNDING_SCALE_1SS_SEL          0x008A0
#define REG_BEAM_FORMING0_SOUNDING_SCALE_1SS_SEL_MASK     0x00004000
#define REG_BEAM_FORMING0_SOUNDING_SCALE_1SS_SEL_SHIFT    14
#define REG_BEAM_FORMING0_SOUNDING_SCALE_1SS_SEL_WIDTH    1

/* BEAM_FORMING0_SOUNDING_SCALE_2SS_SEL */
#define REG_BEAM_FORMING0_SOUNDING_SCALE_2SS_SEL          0x008A0
#define REG_BEAM_FORMING0_SOUNDING_SCALE_2SS_SEL_MASK     0x00008000
#define REG_BEAM_FORMING0_SOUNDING_SCALE_2SS_SEL_SHIFT    15
#define REG_BEAM_FORMING0_SOUNDING_SCALE_2SS_SEL_WIDTH    1

/* BEAM_FORMING0_CARRIER_TO_SOUNDING_GROUP */
#define REG_BEAM_FORMING0_CARRIER_TO_SOUNDING_GROUP          0x008A0
#define REG_BEAM_FORMING0_CARRIER_TO_SOUNDING_GROUP_MASK     0x007f0000
#define REG_BEAM_FORMING0_CARRIER_TO_SOUNDING_GROUP_SHIFT    16
#define REG_BEAM_FORMING0_CARRIER_TO_SOUNDING_GROUP_WIDTH    7

/* BEAM_FORMING0_BF_CALIBRATION_MODE */
#define REG_BEAM_FORMING0_BF_CALIBRATION_MODE          0x008A0
#define REG_BEAM_FORMING0_BF_CALIBRATION_MODE_MASK     0x00800000
#define REG_BEAM_FORMING0_BF_CALIBRATION_MODE_SHIFT    23
#define REG_BEAM_FORMING0_BF_CALIBRATION_MODE_WIDTH    1

/* BEAM_FORMING1_SOUNDING_MTRX_IDX0_1SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_1SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_1SS_MASK     0x00000007
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_1SS_SHIFT    0
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_1SS_WIDTH    3

/* BEAM_FORMING1_SOUNDING_MTRX_IDX1_1SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_1SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_1SS_MASK     0x00000070
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_1SS_SHIFT    4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_1SS_WIDTH    3

/* BEAM_FORMING1_SOUNDING_MTRX_IDX2_1SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_1SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_1SS_MASK     0x00000700
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_1SS_SHIFT    8
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_1SS_WIDTH    3

/* BEAM_FORMING1_SOUNDING_MTRX_IDX0_2SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_2SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_2SS_MASK     0x00007000
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_2SS_SHIFT    12
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX0_2SS_WIDTH    3

/* BEAM_FORMING1_SOUNDING_MTRX_IDX1_2SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_2SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_2SS_MASK     0x00070000
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_2SS_SHIFT    16
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX1_2SS_WIDTH    3

/* BEAM_FORMING1_SOUNDING_MTRX_IDX2_2SS */
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_2SS          0x008A4
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_2SS_MASK     0x00700000
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_2SS_SHIFT    20
#define REG_BEAM_FORMING1_SOUNDING_MTRX_IDX2_2SS_WIDTH    3

/* TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM1_RM */
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM1_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM1_RM_MASK     0x00000007
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM1_RM_SHIFT    0
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM1_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM2_RM */
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM2_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM2_RM_MASK     0x00000070
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM2_RM_SHIFT    4
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_ERAM2_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF1_RM */
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF1_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF1_RM_MASK     0x00000700
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF1_RM_SHIFT    8
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF1_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF2_RM */
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF2_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF2_RM_MASK     0x00007000
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF2_RM_SHIFT    12
#define REG_TX_BE_RAM_RM_REG1_LDPC_STANDARD_OUT_BUFF2_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_0_RM */
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_0_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_0_RM_MASK     0x00070000
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_0_RM_SHIFT    16
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_0_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_1_RM */
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_1_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_1_RM_MASK     0x00700000
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_1_RM_SHIFT    20
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_1_RM_WIDTH    3

/* TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_2_RM */
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_2_RM          0x008A8
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_2_RM_MASK     0x07000000
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_2_RM_SHIFT    24
#define REG_TX_BE_RAM_RM_REG1_TX_CAL_RAM_ANT_2_RM_WIDTH    3

/* GCLK_CONTROL2_GCLK_DIS_BYPASS */
/* bypass gclk enable of submodules thus stopping their clock 
 */
#define REG_GCLK_CONTROL2_GCLK_DIS_BYPASS          0x008AC
#define REG_GCLK_CONTROL2_GCLK_DIS_BYPASS_MASK     0x03FFFFFF
#define REG_GCLK_CONTROL2_GCLK_DIS_BYPASS_SHIFT    0
#define REG_GCLK_CONTROL2_GCLK_DIS_BYPASS_WIDTH    26

/* MEMORY_CONTROL_MEM_GLOBAL_RM */
/* Global RM value for rams */
#define REG_MEMORY_CONTROL_MEM_GLOBAL_RM          0x008B0
#define REG_MEMORY_CONTROL_MEM_GLOBAL_RM_MASK     0x00000003
#define REG_MEMORY_CONTROL_MEM_GLOBAL_RM_SHIFT    0
#define REG_MEMORY_CONTROL_MEM_GLOBAL_RM_WIDTH    2

/* MEMORY_CONTROL_MEM_GLOBAL_TEST_MODE */
/* Global test mode for rams */
#define REG_MEMORY_CONTROL_MEM_GLOBAL_TEST_MODE          0x008B0
#define REG_MEMORY_CONTROL_MEM_GLOBAL_TEST_MODE_MASK     0x00000004
#define REG_MEMORY_CONTROL_MEM_GLOBAL_TEST_MODE_SHIFT    2
#define REG_MEMORY_CONTROL_MEM_GLOBAL_TEST_MODE_WIDTH    1

/* MEMORY_CONTROL_BIST_SCR_BYPASS */
/* Global bist scrambler bypass for rams */
#define REG_MEMORY_CONTROL_BIST_SCR_BYPASS          0x008B0
#define REG_MEMORY_CONTROL_BIST_SCR_BYPASS_MASK     0x00000008
#define REG_MEMORY_CONTROL_BIST_SCR_BYPASS_SHIFT    3
#define REG_MEMORY_CONTROL_BIST_SCR_BYPASS_WIDTH    1
#endif 
