#ifndef PhyRegsIncluder_h__
#define PhyRegsIncluder_h__

#ifdef ENET_INC_ARCH_WAVE600D2	
#include "PhyRxtdAnt0Regs.h"
#include "PhyRxtdAnt1Regs.h"
#include "PhyRxtdAnt2Regs.h"
#include "PhyRxtdAnt3Regs.h"
#else
#include "PhyRxTdAnt0Regs.h"
#include "PhyRxTdAnt1Regs.h"
#include "PhyRxTdAnt2Regs.h"
#include "PhyRxTdAnt3Regs.h"
#endif
#include "PhyTxRegs.h"
#include "HwMemoryMap.h"

/******************************************************************************/
/***						RAMs Addresses									***/
/******************************************************************************/
/**************************/
/***	GenRisc Iram	***/
/**************************/
#define REG_PHY_GEN_RISC_IRAM_ADDR			0x8000

#define RAM_GEN_RISC_VERSION_FIRST_WORD		0x8040
#define RAM_GEN_RISC_VERSION_SECOND_WORD	0x8044

#define REG_PHY_TD_RISC_STOP_OPR			0x8060

// Version Definitions
#define RAM_GEN_RISC_REVISION_MASK			0xFFFFF
#define RAM_GEN_RISC_REVISION_SHIFT			0	
#define RAM_GEN_RISC_BRANCH_ID_MASK			0x3F00000
#define RAM_GEN_RISC_BRANCH_ID_SHIFT		20
#define RAM_GEN_RISC_RELEASED_MASK			0x40000000
#define RAM_GEN_RISC_RELEASED_SHIFT			30
#define RAM_GEN_RISC_MODIFIED_MASK			0x80000000
#define RAM_GEN_RISC_MODIFIED_SHIFT			31
#define RAM_GEN_RISC_MINOR_MASK				0xFFFF //RAM_GEN_RISC_VERSION_SECOND
#define RAM_GEN_RISC_MINOR_SHIFT			0


#define	ANT0_CAL_LONG_PREAMBLE				0x16200

#define RSSI_TABLE_ANT0						0x18000

#define	REG_PHY_AUX_BLOCK_ENABLE			0x20280
#define REG_PHY_TD_LNA_ACTIVE_VALUES		0x202B0  /*The values are written in nibbles of 4bit*/
/* This registers intructs the GenRisc which RF Tx antenna to open
Value is 0 by default. If you need to shut down antennas put 1 in their bit location (0/1/2). */
#define REG_PHY_GENRISC_TX_ANT_ENABLE		0x202CC  
#define REG_PHY_GENRISC_TX_ANT_ENABLE_MASK	0xF  
#define DCTABLE1_ANT0						0x21000

/* TPC Registers*/
#define VALID_FOR_TPC						0x201BC // Genrisc address = 0x200 + (0x1BC / 4 =) 0x6f = 0x26f
#define FEEDBACK_FROM_TPC					0x201c0
#define FEEDBACK_FROM_TPC_ANT2				0x20200

// Tx RAM
#define TXIQ_ANT0							0x15000
#define TXIQ_ANT1							0x25000
#define TXIQ_ANT2							0x35000
#define TXIQ_ANT3							0x31000


// Test Bus
#define RXTD_TB_FIFO_Low					0x38000
#define RXTD_TB_FIFO_Mid					0x3c000
#define RXTD_TB_FIFO_high					0x3e000

#define STYLE_ENDLESS_nCB					0x301e8
#define STYLE_ENDLESS_CB					0x301f8

#define ANT0_STYLE_OFFSET					0x1b000
#define ANT0_FILT_OUT_AMP_GAIN_0			0x1B0E0
#define ANT1_STYLE_OFFSET					0x2b000
#define ANT1_FILT_OUT_AMP_GAIN_0			0x2B0E0
#define ANT2_STYLE_OFFSET					0x37000
#define ANT2_FILT_OUT_AMP_GAIN_0			0x370E0

#define REG_PHY_STOP_PHY_BY_GENRISC			0x2027C

/* ANT_SELECTION_CTR register 0
	Address:0xaf20108
	structure:
		{ENABLE [15],DEFAULT[5:0] }  
		DEFAULT	- Default TX\RX Antenna Set
		ENABLE  - Enable R metric record in phy */
#define REG_PHY_ANT_SELECTION_CONTROL				0x20108 
#define REG_PHY_ANT_SELECTION_CONTROL_DEFAULT_MASK	0x3F
#define REG_PHY_ANT_SELECTION_CONTROL_ENABLE_MASK	0x8000		
#define REG_PHY_ANT_SELECTION_CONTROL_DEFAULT_VALUE 0x1A//(011010)

#define SW_RESET_N_REG_ENABLE_BIT						0x3
#define SW_RESET_N_REG_SHIFT_RX_ENV						5

//Rate (CB) - Shift is within the rate: 
#define TCR2_RATE_CB_NUMOFBITS		1
#define TCR2_RATE_CB_SHIFT			7
#define TCR2_RATE_CB_MASK	 		MASK(TCR2_RATE_CB_NUMOFBITS,TCR2_RATE_CB_SHIFT,uint32)

/******************************************************************************/
/***						Related Defs									***/
/******************************************************************************/
#define ANT_REGS_OFFSET			(PHY_RXTD_ANT1_BASE_ADDRESS - PHY_RXTD_ANT0_BASE_ADDRESS)  
#define BAND_OFFSET				(BAND1_INTERNAL_SIZE)

#define IQ_CORR_CFG_ANT0		(0x18)
#define IQ_CORR_N_SAMPLES		(0x30)
#define IQ_CORR_CTRL_ANT0		(0x34)
#define iq_AN1_OFFSET			(0x200)
#define DCTABLE1_ANT1_OFFSET	(32)
#define RSSI_TABLE_ANT_OFFSET	(0X400)
#define IQ_BYPASS_ANT_OFFSET	(0x200) // Offset in TD between each antennas registers
#define DEFAULT_W1				(1<<12)
#define DEFAULT_W2				(0)

#define TEST_BUS_GCLK_ENABLE	(REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN_MASK | REG_PHY_RXTD_REG7F_BE_TEST_BUS_GCLK_EN_MASK | REG_PHY_RXTD_REG7F_SLICER_TEST_BUS_GCLK_EN_MASK | REG_PHY_RXTD_REG7F_FD_TEST_BUS_GCLK_EN_MASK | REG_PHY_RXTD_REG7F_TX_TEST_BUS_GCLK_EN_MASK)
#define ENABLE_PHY_RX_1X1		(0x1 << REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_SHIFT)
#define ENABLE_PHY_RX_2X2		(0x3 << REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_SHIFT)
#define ENABLE_PHY_RX_3X3		(0x7 << REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_SHIFT)
#define DISABLE_ALL_PHY_RX_ANT	(0x0)

#define GLOBAL_EN_STOP_PHY					(REG_PHY_RXFD_IF10D_RISC_TD_GLOBAL_EN_SEL_MASK | REG_PHY_RXFD_IF10D_RISC_FD_GLOBAL_EN_SEL_MASK | REG_PHY_RXFD_IF10D_RISC_BE_GLOBAL_EN_SEL_MASK)
#define GLOBAL_EN_DEFAULT					0x0

#define	RX_TD_INITIAL_VALUE_RESET_N_REG		0x6F8
#define	RX_TD_INITIAL_VALUE_SW_RESET_N_REG	0x1202

#define TB_FIFO_ENABLE_MASK					0x200
#define PIF_ENABLE_MASK						0x6
#define FCSI_ENABLE_MASK					0x80

#define PHY_ERYLUS_RCV_MODE				(REG_AFE_DYN_CTRL_TX0_STBY_MASK | REG_AFE_DYN_CTRL_TX1_STBY_MASK | REG_AFE_DYN_CTRL_TX2_STBY_MASK)   // Configure Erylus: All ADC's on & DAC's are off, AUX ADC is set to rssi
#define PHY_RF_PA_TR_SWITCH_RCV_MODE	(REG_AFE_RF_DYN_CTRL_AFE_RT_SW0_MASK | REG_AFE_RF_DYN_CTRL_AFE_RT_SW1_MASK | REG_AFE_RF_DYN_CTRL_AFE_RT_SW2_MASK)	//0x0  | PHY_FERONIA_AUX_ACTIVE // TX in STBY, RX enabled.

/* RX detector correlator parameters*/
#define CORRELATOR_LOW_4		(0x4 << REG_PHY_RXTD_REG2E_DET_CORR_D_L_SHIFT)
#define CORRELATOR_LOW_5		(0x5 << REG_PHY_RXTD_REG2E_DET_CORR_D_L_SHIFT)
#define CORRELATOR_LOW_7		(0x7 << REG_PHY_RXTD_REG2E_DET_CORR_D_L_SHIFT)
#define CORRELATOR_HIGH_10		(0xa << REG_PHY_RXTD_REG2E_DET_CORR_D_H_SHIFT)
#define CORRELATOR_HIGH_11		(0xb << REG_PHY_RXTD_REG2E_DET_CORR_D_H_SHIFT)

#define STOP_PHY_BY_GENRISC_ENABLE			(1)
#define STOP_PHY_BY_GENRISC_CLEAR			(0)
/******************************************************************************/
/***						RX Threshold Defs								***/
/******************************************************************************/
#define REG_DETECTOR_POWER_THRESHOLD	(0x20ae4)
#define REG_DET_TH_ON_TIMER				(0x20ae8)
#define REG_DET_TH_OFF_TIMER			(0x20aec)
#define REG_PHY_MIN_RSSI				(0x20b14)

#define DET_POWER_TH_SHIFT				24
#define RX_TH_PHY_REPORT_SHIFT			24

/******************************************************************************/
/***						Structured Registers							***/
/******************************************************************************/
typedef struct CorrCfg{
	union Config1 //0x18
	{
		struct  
		{
			uint32	IIR_Mu_I	:	2;	//0-9bits, 1-10bits,2-11bits
			int32	unused0		:	2;
			uint32	IIR_Mu_Q	:	2;
			int32	unused1		:	2;
			int32	unused2		:	12;
			uint32	Corr_Round	:	2;	//0-8bits, 1-9bits,2-10bits
			int32	unused3		:	2;
			uint32	IsAcc_I		:	1;
			int32	unused4		:	3;
			uint32	IsAcc_Q		:	1;
			int32	unused5		:	3;	
		};
		uint32 reg;
	}Cfg;
	int	NumOfSamples;	// 0x30
}sCorrCfg_T;

typedef union CorrCtrl{
	struct
	{
		uint32	unused0		:	4;
		uint32	StartWork	:	1;
		uint32	unused1		:	3;
		uint32	Reset		:	1;
		uint32	unused2		:	3;
		uint32	IsValid		:	1;
		uint32  unused3		:	19;
	};
	uint32 reg;
}sCorrCtrl_T;

typedef union DeCorrW1
{
	struct  
	{
		uint32	Value	:	14;
		uint32	unused	:	18;		
	};
	uint32 reg;
}sDecorrW1_T;

typedef union DeCorrW2
{
	struct  
	{
		int	Value	:	15;
		int	unused	:	17;	
	};
	uint32 reg;
}sDecorrW2_T;

typedef struct AntDeCorrValues
{
	sDecorrW1_T	W1;
	sDecorrW2_T	W2;
}sAntDeCorrValues_T;

typedef struct AntTxIndex_0_DigitalGain_T
{
	uint32	DigitalGain;

}sAntTxIndex_0_DigitalGain_T;

typedef struct BypassCtrl{
	uint32	bypass_iq_all			:	1;
	uint32	bypass_dec_all			:	1;
	uint32	unused0					:	2;
	uint32	bypass_iq_all_for_agc	:	1;
	uint32	unused1					:	4;
	uint32	bypass_dc_all			:	1;
}sBypassCtrl_T;

//Goertzel block:
typedef union GoertzelCtrl
{
	struct{
		uint32	Branch				:	1;
		uint32  unused0				:	3;
		uint32	Reset				:	1;
		uint32  unused1				:	3;
		uint32	Antenna				:	4;
		uint32  unused2				:	20;
	};
	uint32 reg;
}sGoertzelCtrl_T;

typedef struct GoertzelCfg{
	sGoertzelCtrl_T Ctrl;
	int32	Mul_I;
	int32	Mul_Q;
	int32	NumOfCycles;
}sGoertzelCfg_T;

typedef union DCTable1Acc{
	struct {
		uint32	LNA		:	1;
		uint32	Mixer	:	1;
		uint32	LPF1	:	3;
		uint32	Unused0	:	27;
	};
	uint32 reg;
}sDCTable1Acc_T;

typedef union DCTable1Entry{
	struct {
		uint32	ErrorCorrection_Q	:	5;
		uint32	ErrorCorrection_I	:	5;
		uint32	DC_Correction_Q		:	6;
		uint32	DC_Correction_I		:	6;
		uint32	Unused0				:	10;
	};
	uint32 reg;
}sDCTable1Entry_T;

typedef union DCTable2Entry{
	struct{
		uint32	DC_Correction_Q		:	5;
		uint32	DC_Correction_I		:	5;
		uint32	Unused0				:	22;
	};
	uint32 reg;
}sDCTable2Entry_T;

typedef union TxIQCoeffsEntry{
	struct{
		int32	b		:	10;
		int32	a		:	10;
		int32	Unused0	:	12;
	};
	uint32 reg;
}sTxIQCoeffsEntry_T;

#endif // PhyRegsIncluder_h__
