#ifndef _PHY_CAL_DRIVER_
#define _PHY_CAL_DRIVER_

//#if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)

#include "System_GlobalDefinitions.h"
#include "mt_cnfg.h"
#include "CalibrationDefs.h"
#include "HdkGlobalDefs.h"
#include "calibrationsParamsOtf.h"
#include "mhi_hdk.h"
#include "mhi_dut.h"
//#include "RxIQMismatchClbrHndlr.h"

//#define WRX600_BU_LOGS
/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
#define THREE_DB_FACTOR				3
#define DERESOLUTION_NUM_BITS		4
#define ACCUM_SHIFT                 8
#define ADAPTIVE_GAIN_SAMPLES   	1024//4096 for gen6
//
//                                  1    2            1                  2
// SAMPLE_POWER:   ( ---)     *   ( ---)      [Volt]   * [Ohm] 
//                                  2                 50
//
//      Square(A/D max value)   *    A/D Resistance





#define ADC_RES						12 //14 for gen6

#define ADAPTIVE_GAIN_SAMPLE_POWER                      (((2<<1)*50)*20)/21/*21/20 = 1.05v WAVE 500 ADC FULL SCALE*/
//#define ADAPTIVE_GAIN_SAMPLE_POWER                      (((2<<1)*50)*20)/30/*30/20 = 1.5v WAVE 600 ADC FULL SCALE for gen6*/

#define ADAPTIVE_GAIN_DENOMINATOR_VALUE     ((ADAPTIVE_GAIN_SAMPLES>>DERESOLUTION_NUM_BITS)*ADAPTIVE_GAIN_SAMPLE_POWER*(1<<((2*(ADC_RES-1))- RX_IQ_ROUND)))

#define CW_OFFSET_IN_DB 64
#define MAX_NUM_OF_TX_ANTENNAS		3

#define DELAY_AFTER_PHY_TX_CHANGE   4
#define RX_IQ_BW_OFFSET				(0x10)




// Tone generator toggle
#define TONE_GEN_TOGGLE_ON	(1)
#define TONE_GEN_TOGGLE_OFF	(0)

/*	Analog and Digital gains are stored in Ram(Ram Size 16x42) as described below
	------------------------------------------------------------------------------------------	
	|    41:37		|	 36:28     |	27:23    |	  22:14		|	13:9	  |		8:0		 |
	------------------------------------------------------------------------------------------
	| Ant0 Analog	| Ant0 Digital | Ant1 Analog | Ant1 Digital | Ant2 Analog | Ant0 Digital |
	|	Gain		|	Gain	   |	Gain	 |	  Gain	    |	Gain	  |		Gain	 |
	------------------------------------------------------------------------------------------
	Ram base address is 0xaf508000 
	
	Write Access:
		 In order to write to the TPC-Ram Via host we need to write 2 accesses:
		 Even access stores the Ant2 TPC in a temporary registers of 14 bits.
		 Odd access writes the whole 42 bits to Ram Odd Data is concatenated to the temporary register.
	Read Access:
		When reading the Even address Ram content, the Hw Reads the whole 42 bits 
		from the Ram and the Low part (Ant2 digital and analog) is being read.
		Even address Read Data to host = {18'h0, Ant2 Analog Gain, Ant2 Digital Gain}
		Odd  address Read Data to host = {4'h0, Ant0 Analog Gain, Ant0 Digital Gain, Ant1 Analog Gain, Ant1 Digital Gain}
*/

#define MT_PHY_ANALOG_GAIN_MASK				0x1F
#define MT_PHY_DIGITAL_GAIN_MASK			0x1FF

#define MT_PHY_ANALOG_GAIN_OFFSET           9

#define MT_PHY_GAIN_VALUE_LENGTH			14
#define MT_PHY_NUM_OF_ADDRESSES_PER_INDEX	2

#define PHY_CAL_DRV_IGNORE_IQ_SWAP          (0) /*  */

#define ADAPTIVE_GAIN_LOG_ROUND         	16 // [(2^5)/2] 5bit 10log10 resolution  
#define ADAPTIVE_GAIN_ROUND         		8 // (2^4)/2
#define ADAPTIVE_GAIN_RES           		4
#define ADAPTIVE_GAIN_OFFSET        		30
#define Difi_GAIN							3


#define PWR_TO_GAIN_INDEX(pwr)     			MAX((MIN(pwr,ADAPTIVE_GAIN_TABLE_SIZE-1)),0);
 

#define PGC1                        		0
#define PGC2                        		1
#define PGC3                        		2
#define NUM_OF_PGCS                 		3

#define ADAPTIVE_GAIN_TABLE_SIZE   			27  

#define TONEGEN_FILT_ANT01_VAL_LSB			(0x143)

#define ADAPTIVE_GAIN_LOG_RESOLUTION		5


// TxIQTD masks and shifts

#define IQTD_F00_MASK	0x3FF   
#define IQTD_F00_SHIFT	0

#define IQTD_F01_MASK	0xFFC00 
#define IQTD_F01_SHIFT	10

#define IQTD_F10_MASK	0x3FF	 
#define IQTD_F10_SHIFT	0

#define IQTD_F11_MASK	0x3FF0000 
#define IQTD_F11_SHIFT	16

/******************************************************************************/
/***						Type Definitions								***/
///******************************************************************************/
typedef struct CorrResultsRxIq_tag
{
	uint32	II;
	uint32	QQ;
	int32	IQ;
}CorrResRxIq_t;

typedef struct GoertzelRes{
	int32	Res_I_Real;
	int32	Res_I_Im; // for gen6
	int32	Res_Q_Real;
	int32	Res_Q_Im; // for gen6
}GoertzelRes_t;

typedef struct CorrOverflow
{
	uint8 iiOf;
	uint8 qqOf;
	uint8 iqOf;
}CorrOverflow_t;

typedef enum Goertzel
{
	GOERTZEL_0,
	GOERTZEL_1,
	GOERTZEL_2,
	GOERTZEL_3,
	TOTAL_GOERTZELS
}Goertzel_e;

enum 
{
	DC_MODE		=	1,
	CORR_MODE	=	0
};

// Tone generator shifts
typedef enum ToneGenShiftMode
{
	TONE_GEN_SHIFT_NONE,
	TONE_GEN_SHIFT_UP,
	TONE_GEN_SHIFT_DOWN
}ToneGenShiftMode_e;

typedef enum PhyCalDrv_DifiBypassState
{
    PHY_CAL_DRV_DIFI_BP_OFF = 0x0,
    PHY_CAL_DRV_DIFI_BP_ON  = 0x7
} PhyCalDrv_DifiBypassState_e;



/********************************************************************************
PHYCal_SetLoopBackMode:

Description:
------------

1)This function is the main entry function to set all the required PHY parameters for
each calibration. Based on the calibration type and the antenna the required blocks are enabled.
The unneeded blocks are disabled.

2)In addition the AFE loopbacks are turned on. 
	For Athena ( FPGA sets the actual mode of operation ).
	For Feronia, all ADCs and DACs are enabled.
	For Erylius, ADCs and DACs are enabled according to the antenna.

Input:
------
	CalType : calibration type from enumerator.
	Antenna : Calibrated antenna ( relevant only for FPGA ).
	DebugOn : boolean value determining whether to turn on RF PAs or not.

********************************************************************************/
void PhyCalDrv_SetLoopBackMode(ClbrProcType_e Type,short Antenna);
/********************************************************************************
PhyCalDrv_bypassForRssiCalibration:

Description:
------------
set bypass for rssi calibration
********************************************************************************/
void PhyCalDrv_bypassForRssiCalibration(void);

/********************************************************************************
PHYCal_RestoreOperational:

Description:
------------

Restores the PHY to operational state:
	1) Restore the bypass register.
	2) restore W1,W2.
	3) Disable rx-override.
********************************************************************************/
void PhyCalDrv_RestoreOperationalTx(void);
void PhyCalDrv_RestoreOperationalRx(void);


/********************************************************************************
PhyCalDrv_GetBbicCdd:

Description:
------------

Get the Bbic CDD values:
********************************************************************************/
void PhyCalDrv_GetBbicCdd(dutGetBbicCdd_t * dutGetBbicCdd_p);
/********************************************************************************
PhyCalDrv_SetBbicCdd:

Description:
------------

Set the Bbic CDD:
********************************************************************************/

void PhyCalDrv_SetBbicCdd(dutSetBbicCdd_t * dutSetBbicCdd_p);
/********************************************************************************
Measure_AdcPower:

Description:
------------
measure the Adc power:

Input:
------
********************************************************************************/

void Measure_AdcPower(CorrRes_t Results[MAX_NUM_OF_ANTENNAS], uint8 inRxAntMask, uint32 numSamples);

void setS2dGainAndOffset(int32 ioffs, int32 s2dGain, uint32 antenna, uint8 regionIndex);

void RssiPath_measureRssi(uint16 numberOfSamples, uint16 rssiResult[MAX_NUM_OF_ANTENNAS],uint8 inRxAntMask);
void RssiPath_getDB(RssiDBPower_t *rssiDB );


/********************************************************************************
PhyCalDev_SetToneGenAmplitude:

Description:
------------
Sets the amplitude level of the Tone generator:

Input:
------
	Amplitude : Tone amplitude for shift offset.
********************************************************************************/
void PhyCalDev_SetToneGenAmplitude(int8 Amplitude);
int8 PhyCalDrv_GetToneGenAmplitude(void);

/********************************************************************************
PhyCalDrv_ToneGenInitAfe:

Description:
------------
init the AFE for the Tone generator

Input:
------
	none
********************************************************************************/
void PhyCalDrv_ToneGenInitAfe(void);
/********************************************************************************
PHYCal_ToneGenInit:

Description:
------------
Initializes the transmitter to Tone generator mode:
	1) First backup style registers and Tx registers to be overwritten.
	2) Write Style predefined values.
	3) Write registers values.

Input:
------
	Amplitude : Tone amplitude for shift offset.
********************************************************************************/
void PhyCalDrv_ToneGenInit(int8 Amplitude);
/********************************************************************************
PhyCalDrv_SetToneGenParams:

Description:
------------
set Tone Generator parameters
Input:
------
	Amplitude : Tone amplitude for shift offset.
********************************************************************************/
void PhyCalDrv_SetToneGenParams(bool lstfMode,uint8 outOfBand, uint8 antMask, uint32 numCycles);
/********************************************************************************
PHYCal_ToggleTxTone:

Description:
------------
Toggles or aborts transmission of a tone based on input parameters:

Input:
------
	k :	Tone to start/stop.
	On:	'1' for start transmitting, '0' to stop.
********************************************************************************/
void PhyCalDrv_ToggleTxTone(int8 k, int8 On);
/********************************************************************************
PHYCal_ToggleTxTone_Extend:

Description:
------------
Toggles or aborts transmission of a tone based on input parameters:

Input:
------
	bin				:	Tone to start/stop.
	toggle			:	'1' for start transmitting, '0' to stop.
	shiftMode		:	shift the bins by 20M/10M (CB/nCB) ,even if they are in the regular Zone(-64:64)/(-32:32) ,(CB/nCB)
						'0' id for no change,'1' is for shift up,'2' is for shift down
********************************************************************************/
void PhyCalDrv_ToggleTxToneExtended(int8 bin,int8 toggle, ToneGenShiftMode_e shiftMode);
/********************************************************************************
PHYCal_ToneGenSetOutputPower:

Description:
------------
Sets the digital gain and scaler to achieve a specific output power in dBV.
Calculates the gains required and uses the scaler ( 6dB step )and gain (1dB step).
Input:
------
	OutputPower : Requried output power in dBV( Range -70 to -1).
********************************************************************************/
void PhyCalDrv_ToneGenSetOutputPower(int8 OutputPower);
/********************************************************************************
PHYCal_ToneGenRestart:

Description:
------------
Restarts the tone generator.
Used when setting IQ coefficients.
Input:
-----
None.

Output:
-------
none.
*******************************************************************************/
void PhyCalDrv_ToneGenRestart(void);
/********************************************************************************
PHYCal_ToneGenExit:

Description:
------------
Restores the transmitter to operational state:
	1) Restores style registers.
	2) Restores transmitter registers.
********************************************************************************/
void PhyCalDrv_ToneGenRestore(void);
/********************************************************************************
PHYCal_SetTxIQCoefficients:

Description:
------------

Sets the [a,b] coefficient at a specific antenna bin.
Input:
-----
	Ant	 : Required antenna ( 0 or 1).
	k	:  Bin index ( 0-128).
	a,b:	IQ coefficients.
Output:
-------
none.
*******************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_SetTxIQCoefficients(uint8 antMask, int16 bin, int16* a, int16* b);
void PhyCalDrv_SetTxIQCoefficientsAllBinsFullCal(uint8 antMask,int16* a, int16* b,int16 binStartIndex,int16 binEndIndex );
void PhyCalDrv_SetTxIQCoefficientsAllBins(uint8 antMask,int16* a, int16* b,int16 binStartIndex,int16 binEndIndex );
void PhyCalDrv_SetTxToneGen(void);

#else
void PhyCalDrv_SetTxIQCoefficients(int8 Ant, int8 k, int16 a, int16 b);
#endif

/********************************************************************************
PHYCal_GetTxIQCoefficients:

Description:
------------

Reads the [a,b] coefficient at a specific antenna bin.
Input:
-----
	Ant	 : Required antenna ( 0 or 1).
	k	:  Bin index ( 0-128).
Output:
-------
	a,b:	IQ coefficients.
*******************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_GetTxIQCoefficients(uint8 antMask, int16 bin, int16* a, int16* b);
#else
void PHYCalDrv_GetTxIQCoefficients( int8 Ant, int8 k, int16* a, int16* b );
#endif
void PhyCalDrv_ClearTxIQCoefficients(uint8 antMask);

/********************************************************************************
PHYCal_GoertzelInit:

Description:
------------

Initialize the Goertzel based on the required parameters.
Input:
-----
	Ant	 : Required antenna to init.
	branch:  I or Q branch ( 1 for I , 0 for Q)
    isIqSwapped: TRUE when IQ is swapped for Ant and FALSE otherwise
	Num Of cycles: Num of cycles to accumulate.
Output:
-------
none.
********************************************************************************/
void PhyCalDrv_GoertzelInit(Goertzel_e GoertzelNum, int8 Ant, int8 branch, bool isIqSwapped, int8 NumOfCycles);
/********************************************************************************
PHYCal_GoertzelMeasure:

Description:
------------

Performs a single Goertzel measurement.
Input:
-----
	k	:	Bin to measure at.(+/-256 for CB, +/-128 for nCB).
	Delay_us : Delay before triggering measurement.
Output:
-------
 Results : I and Q of the result. The results are 24 bits, sign extended by the function.

********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_resetChannelFilter(void);
void PhyCalDrv_txFFTInScale(int8 AntMsk, uint8 ScaleFactor);
void PhyCalDrv_setValidCoeffs(uint8 antMask, uint32 NumOfEnabledCoeffs);
void PhyCalDrv_setBypassRamCoeffs (uint8 AntMsk, bool enable);
void PhyCalDrv_enableToneGen (bool isEnabled);
void PhyCalDrv_writeRamXtalk(uint8 AntMsk, uint8 BwIdx, int8 CoeffArrayKa[RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS], int8 CoeffArrayKb[RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS]);
void PhyCalDrv_setXTalkCoeffs(uint8 AntMsk, uint8 Ka[MAX_NUM_OF_ANTENNAS], uint8 Kb[MAX_NUM_OF_ANTENNAS]);
void PhyCalDrv_setAdc(bool enable);
void PhyCalDrv_GoertzelMeasureEnergy(uint8 antMask, uint32* loMeasure, uint8 energyShift, uint16 timeout);
void PhyCalDrv_RunMultiToneGen(int16* tones, int8 numOfTones, int8 scale, int16 digGain[MAX_NUM_OF_ANTENNAS], uint8 AntMsk);
void PhyCalDrv_EnableTpcAccelerator(uint8 AntMsk, bool IsEnabled);
void PhyCalDrv_SetPgc2Gain(uint8 AntMsk, int8 tpcgainidx);
void PhyCalDrv_getLmsErrorIndicator(uint8 AntMsk, uint32 pErrorInd_rtrn[MAX_NUM_OF_ANTENNAS], uint8 pErrorValid_rtrn[MAX_NUM_OF_ANTENNAS]);
void PhyCalDrv_readRamFirCoeffs(uint8 AntMsk, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS], uint8 iBW, uint8 PgcSetting);
void PhyCalDrv_writeRamFirCoeffs(uint8 AntMsk, uint32 pCoeffs[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS], uint8 iBW, uint8 PgcSetting);
void PhyCalDrv_setFirCoeffsToProgmodel(uint8 AntMsk, uint32 pCoeffs[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]);
void PhyCalDrv_LmsReset(void);
void PhyCalDrv_getFirCoeffs(uint8 AntMsk, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]);
void PhyCalDrv_setLmsParams (uint8 AntMsk, bool CalMode , uint32 NumOfSteps, uint8 Mu, uint8 Alpha);
void PhyCalDrv_setLmsCalMode (uint8 AntMsk, bool NlmsCalMode);
void PhyCalDrv_enableADC(bool enable);
void PhyCalDrv_startLmsCycle (uint8 AntMsk);
void PhyCalDrv_setIqDelays(uint8 AntMsk, uint8 EqLength_q, uint8 IqFirDelay );
void PhyCalDrv_GoertzelMeasure(uint8 antMask, uint16 timeout, GoertzelRes_t *Results);
#else
void PhyCalDrv_GoertzelMeasure(uint8 goertzelMask, GoertzelRes_t *Results, int16 k, int8 Delay_us );
#endif
void PhyCalDrv_GoertzelSetTone(uint8 antMask, int16 tone);
void PhyCalDrv_GoertzelConfig(uint8 antMask, uint32* length, uint8* numOfCycles, int16* tone0, int16* tone1);
void PhyCalDrv_GoertzelSetLengthAndCycles(uint8 antMask, uint32* length, uint8* numOfCycles);
void PhyCalDrv_ToneGenClearAndDisable(uint8 antMask);
void PhyCalDrv_SetToneGenScale(uint8 antMask, int8 scale);
uint32 PhyCalDrv_GetToneGenScale(void);

void PhyCalDrv_RunToneGen(uint8 antMask, int16 bin, int8 scale, int16* digGain);
void PhyCalDrv_EnableGclkBypass(bool enable);

/********************************************************************************
PHYCal_CorrInit:

Description:
------------

Initialize the Correlators/Accumulators block as well as the IIR block.
Input:
-----
	Mode : DC_MODE or CORR_MODE.
	Ant	 : Required antenna to init.
	NumOfSamples: Samples to accumulate.
	Round : bits to round after multiplication, relevant for CORR_MODE only ( 0-8bits, 1-9bits,2-10bits)
	IIR_mu: IIR loop coefficient  ( 0:2^-9, 1:2^-10bits,2:2^-11bits
Output:
-------
none.
********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_CorrInit(uint8 antMask, uint32* nos, uint8* dcMode, uint8* rssiMode, uint8* rate, uint8* shift);
void PhyCalDrv_SetCorrNos(uint8 antMask, uint32 nos);
#else
void PhyCalDrv_CorrInit(int8 Mode, uint8 antMask, int32 NumOfSamples, int8 Round,int8 IIR_mu);
#endif
void PhyCalDrv_setAccumTo80Mh(void);
void PhyCalDrv_setDecorrelatorMode(uint8 antMask, bool enable);
void PhyCalDrv_setIIRMode(uint8 antMask, bool enable);
void PhyCalDrv_setIIRShift(uint8 antMask, uint8 shift);
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_resetRxtd(bool enable);
void PhyCalDrv_enableRxtdFifo(bool enable);
void PhyCalDrv_enableDetector(bool enable);
void PhyCalDrv_enableCalMode(bool enable);
void PhyCalDrv_setFirMode(uint8 antMask, bool enable);
void PhyCalDrv_setFdlMode(uint8 antMask, bool enable);
void PhyCalDrv_setXtalkMode(uint8 antMask, bool enable);
void PhyCalDrv_resetDifiGain(uint8 antmask);
void PhyCalDrv_enableDifiGain(uint8 antmask, bool enable);
#else
void PhyCalDrv_setFirInBypass(uint32 iirEnable,uint32 firEnable,uint32 fdlEnable);
void PhyCalDrv_setFdlNotInBypass(uint32 fdlRamBypassMode);
#endif



/********************************************************************************
PhyCalDrv_CorrMeasureAll:

Description:
------------

Triggers an IQ measurement on all enabled antennas in parallel.
Mainly used with DC calibration.
Input:
-----
	none
Output:
-------
	Results: pointer to a result structure array where the results shall be updated.
********************************************************************************/
void PhyCalDrv_CorrMeasureAll(CorrRes_t Results[MAX_NUM_OF_ANTENNAS],int8 Delay_us,bool isIqSwapped);
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_CorrMeasureRxIq(uint8 antMask, uint16 timeout, CorrResRxIq_t *ResultsRxiq, CorrOverflow_t* corrOf);
void PhyCalDrv_CorrMeasure(uint8 antMask, uint16 timeout, CorrRes_t *Results, CorrOverflow_t* corrOf);
void PhyCalDrv_CorrDcMeasureDcAvg(uint8 antMask, uint16 timeout, int16* dcI, int16* dcQ, CorrOverflow_t* accumOF);
void PhyCalDrv_readRamDC(uint8 AntMsk, int16 pDcRegsI_rtrn[MAX_NUM_OF_ANTENNAS], int16 pDcRegsQ_rtrn[MAX_NUM_OF_ANTENNAS], uint8 Pgc_Gain_dB, uint8 lnagainidx, uint8 iBW);
void PhyCalDrv_writeRamDCAll(uint8 AntMsk, int16 pDcRegsI[MAX_NUM_OF_ANTENNAS], int16 pDcRegsQ[MAX_NUM_OF_ANTENNAS], uint8 Pgc_Gain_dB, uint8 lnagainidx, uint8 iBW);
#else
void PhyCalDrv_CorrMeasure(int8 ant, CorrRes_t* Result,int8 Delay_us,bool isIqSwapped);
#endif
void PhyCalDrv_SetDcResultsToPm(uint8 antMask, int16* dcI, int16* dcQ);

/********************************************************************************
PhyCalDrv_RxIQSetWCoeffs():

Description:
------------

Sets the W1,W2 parameters for the required antenna.
The mirrored values are set as well.
********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_RxIQSetWCoeffs(uint8 antMask, uint8 bw, uint16* w1, int16* w2);
#else
void PhyCalDrv_RxIQSetWCoeffs(uint8 BandNum, int8 Ant, int16 W1,int16 W2,uint32 index);
#endif
/********************************************************************************
PhyCalDrv_RxIQGetWCoeffs():

Description:
------------

Returns W coefficients for IQ calibration
********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_RxIQGetWCoeffs(uint8 antMask, uint8 bw, uint16* w1, int16* w2);
#else
void PhyCalDrv_RxIQGetWCoeffs( uint8 BandNum, uint8 Ant, int16 * W1,int16  * W2);
#endif
//************************************
// Method:    PhyCalDrv_RSSITableSet
// Purpose:   TBD
// Parameter: uint8 Ant
// Parameter: uint8 Pos
// Parameter: int8 Value
// Returns:   void
//************************************
void PhyCalDrv_RSSITableSet(uint8 Ant, uint8 Pos,int8 Value);
//************************************
// Method:    PhyCalDrv_RSSITableGet
// Purpose:   TBD
// Parameter: uint8 Ant
// Parameter: uint8 Pos
// Returns:   uint8
//************************************
uint8 PhyCalDrv_RSSITableGet(uint8 Ant, uint8 Pos);
//************************************
// Method:    PhyCalDriver_ResetDcTables
// Purpose:   reset RxdC DAC tables
// Parameter: void 
// Returns: void  
//************************************
void PhyCalDriver_ResetDcTables(void);
void PhyCalDriver_ResetDcDigTable(uint8 bw);
void PhyCalDriver_LoadDcDigTable(uint8 ant, uint8 bw, uint32* Value);
void PhyCalDriver_StoreDcDigTable(uint8 ant, uint8 bw, uint32* Value);


/********************************************************************************
PHYCal_DCTable2Set:

Description:
------------

Sets the DC correction value based on the antenna index and the gain of the LPF2.
Input:
-----
	Ant: Required antenna (0,1,2).
	LPF2: LPF1 gain in dB, -3 to 18.
	Value : DC offset values array of 2  : -16 to +15. [0] points to I, [1] points to Q.

Output:
-------
	None.
********************************************************************************/
void PhyCalDrv_DCTable2Set(uint8 Ant, uint8 bw, int8 pgc2Gain, int8 *Value );
/********************************************************************************
PHYCal_DCTable2Get:

Description:
------------

Reads the DC correction value based on the antenna index and the gain of the LPF2.
Input:
-----
	Ant: Required antenna (0,1,2).
	LPF2: LPF1 gain in dB, -3 to 18.

Output:
-------
	Value : DC offset values array of 2  : -16 to +15. [0] points to I, [1] points to Q.
********************************************************************************/
void PhyCalDrv_DCTable2Get(uint8 Ant, uint8 bw, int8 pgc2,int8 *Value );
/********************************************************************************
PHYCal_DCTable2GetAll:

Description:
------------
All antennas

********************************************************************************/
void PhyCalDrv_DCTable2GetAll(int8 LPF2,int8 Value[TOTAL_ANTENNAS][2]);
//************************************
// Method:    PhyCalDrv_DCTable2SetAll
// Purpose:   TBD
// Parameter: int8 LPF2
// Parameter: int8 Value[TOTAL_ANTENNAS][2]
// Returns:   void
//************************************
void PhyCalDrv_DCTable2SetAll(int8 LPF2,int8 Value[TOTAL_ANTENNAS][2]);
/********************************************************************************
PHYCal_DCTable1Set:

Description:
------------

Sets the DC correction value based on the antenna index and the gains of the [LNA , pgc1].
Both the DC offset and correction value are set.
Input:
-----
	Ant: Required antenna (0,1,2).
	LPF1: LPF1 gain in dB, -3 to 18.
	LNA Index: Either High (0), Mid (1) or Low (2) gain.
	Value : DC offset values array of 2  : -16 to +15. [0] points to I, [1] points to Q.
	Correction : Error correction values array: -16 to +15. [0] points to I, [1] points to Q.

Output:
-------
	None.
********************************************************************************/
void PhyCalDrv_DCTable1Set(uint8 ant, uint8 bw, int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[2],int8 correction[2]);
/********************************************************************************
PHYCal_DCTable1Get:

Description:
------------

Reads the DC correction value based on the antenna index and the gains of the [LNA , pgc1].

Input:
-----
	Ant: Required antenna (0,1,2).
	LPF1: LPF1 gain in dB, -3 to 18.
	LNA Index: Either High (0), Mid (1) or Low (2) gain.

Output:
-------
	Value : DC offset values array of 2  : -16 to +15. [0] points to I, [1] points to Q.
	Correction : Error correction values array: -16 to +15. [0] points to I, [1] points to Q.
********************************************************************************/
void PhyCalDrv_DCTable1Get(uint8 ant, uint8 bw, int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[2],int8 correction[2]);
//************************************
// Method:    PhyCalDrv_DCTable1GetAll
// Purpose:   TBD
// Parameter: int8 LPF1
// Parameter: int8 lnaIndex
// Parameter: int8 Value[TOTAL_ANTENNAS][2]
// Parameter: int8 Correction[TOTAL_ANTENNAS][2]
// Returns:   void
//************************************
void PhyCalDrv_DCTable1GetAll(int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[TOTAL_ANTENNAS][2], int8 correction[TOTAL_ANTENNAS][2]);
/********************************************************************************
PHYCal_DCTable1SetAll and PHYCal_DCTable1GetAll:

Description:
------------
All antennas

********************************************************************************/
void PhyCalDrv_DCTable1SetAll(int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[TOTAL_ANTENNAS][2], int8 correction[TOTAL_ANTENNAS][2]);
/********************************************************************************
PhyCalDrv_GetDigitalGain:

Description:
------------
extracts the digital gain from the registers .

Input:
-----
			1. index - which of the 16 TxPower gain (0-15)
			2. TxAnt   - which antenna (Tx0,Tx1,Tx2)
			
Output:
-------
			1. Gain - the requested gain

********************************************************************************/
uint16 PhyCalDrv_GetDigitalGain(uint8 TxAnt,uint8 index);
/********************************************************************************
PHYCal_SetDigitalLoCancel:

Description:
------------
Set the register value of the digital "DAC" for the LO cancellation at the base-band

Input:
-----
			1.	branch - which branch is that ('0' for I, '1' for Q )
			2.	TxAnt   - which antenna (Tx0,Tx1 )
			3.	Value - the value that we want to set	
			
Output:
-------
			None. 

********************************************************************************/
void PhyCalDrv_SetDigitalLoCancel(uint8 branch,int8 TxAnt,int8 value);
/********************************************************************************
PHYCal_SetDigitalLoCancelPair:

Description:
------------
Set the register value of the digital "DAC" for the LO cancellation at the base-band

Input:
-----
			1.	TxAnt   - which antenna (Tx0,Tx1 )
			2.  ValueI - the I value that we want to set	
			3.  ValueQ - the Q value that we want to set	
			
Output:
-------
			None. 

********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_SetDigitalLoCancelPair(uint8 antMask, int16* dacI, int16* dacQ, uint8 tcpIndex);
#else
void PhyCalDrv_SetDigitalLoCancelPair(int8 TxAnt,int8 valueI,int8 valueQ);
#endif
/********************************************************************************
PHYCal_GetDigitalLoCancelPair:

Description:
------------
get the register value of the digital "DAC" for the LO cancellation

Input:
-----
			1.	TxAnt   - which antenna (Tx0,Tx1 )
			2.	the requested valueI
			3.	the requested valueQ
			
Output:
-------

********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_GetDigitalLoCancelPair(uint8 antMask, int16* dacI, int16* dacQ, uint8 tcpIndex);
#else
void PhyCalDrv_GetDigitalLoCancelPair(int8 TxAnt,int8 *valueI_p, int8 *valueQ_p);
#endif
/********************************************************************************

PHYCal_ResetValidTpc:

Description:
------------
Reset the valid vector,meaning there are no samples for any of the Tx_power .

Input:
-----
			None.
					
Output:
-------
			None.

********************************************************************************/
void PhyCalDrv_ResetValidTpc(void);
/********************************************************************************
PHYCal_GetValidTpc:

Description:
------------
shows for which Tx_power there are valid samples .

Input:
-----
			none.
			
			
Output:
-------
			2. Valid - valid Tx_power samples

********************************************************************************/
uint16 PhyCalDrv_GetValidTpc(void);
/********************************************************************************
PHYCal_GetFeedBackTpc:

Description:
------------
get the feed-back from the Tpc gauge

Input:
-----
			1. Tx_power_index - which of the 16 TxPower gain (0-15)
			2. ant   - which antenna (Tx0,Tx1 )
			
			
Output:
-------
			1. FeedBack - the requested gain

********************************************************************************/
uint16 PhyCalDrv_GetFeedBackTpc(uint8, uint8);
//************************************
// Method:    PhyCalDrv_WriteAntFiltOutAmpGainRegMask
// Purpose:   Write the data to the specified register
// Parameter: uint32 antenna
// Parameter: uint32 mask
// Parameter: uint32 data
// Returns:   void
//************************************
void PhyCalDrv_WriteAntFiltOutAmpGainRegMask(uint32 antenna, uint32 mask, uint32 data);
//************************************
// Method:    PhyCalDrv_GetRssiDataAll
// Purpose:   Get the RSSI data value per antenna. Average is made due to the volatile nature of the value.
// Parameter: uint32 inNumOfSamples - read iterations
// Parameter: uint8 *outDataAllAntennas -  the average of numOfSamples reads of the RSSI data
// Returns:   void
//************************************
void PhyCalDrv_GetRssiDataAll(uint8 inRxAntMask, uint32 inNumOfSamples, uint16 *outDataAllAntennas );

/********************************************************************************
PhyCalDrv_SetDifiBypass:

Description:
------------

Sets and resets the Difi bypass in the PHY, according to input
Input:
-----
	state	 : PHY_CAL_DRV_DIFI_BP_OFF or PHY_CAL_DRV_DIFI_BP_ON
Output:
-------
None.
********************************************************************************/
//************************************
// Method:    PhyCalDrv_SetDifiBypass
// Purpose:   Sets and resets the Difi bypass in the PHY, according to input.
// Parameter: PhyCalDrv_DifiBypassState_e state - PHY_CAL_DRV_DIFI_BP_OFF or PHY_CAL_DRV_DIFI_BP_ON
// Returns:   void
//************************************
void PhyCalDrv_SetDifiBypass(PhyCalDrv_DifiBypassState_e state);
void PhyCalDrv_setDifi2Gain(uint8 antMask, uint8* difiGain);
void PhyCalDrv_getDifi2Gain(uint8 antMask, uint8* difiGain);
void PhyCalDrv_setDcCancellationMode(uint8 antMask, bool mode);
void PhyCalDrv_setDcAccMode(uint8 antMask, bool mode);
uint8 PhyCalDrv_RunDcVerification(uint8 antMask, int16* dcI, int16* dcQ, uint16 successVal, uint8 pgcGain, uint8 lnaIndex);
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_SetDigitalGain(uint8 antMask , int16* digGain);
#else
void PhyCalDrv_SetDigitalGain(uint8 TxAnt , uint8 index, uint16 Gain);
#endif
void PhyCalDrv_GetTxDigitalGain(uint8 antMask , int16* digGain);

//*************************************
// Method:    RxIQ_adaptiveGain
// Purpose:   In Noise environment run adaptive Gain
// Parameter: CorrRes_t Results[MAX_NUM_OF_ANTENNAS], RxIQRF_elements_t* inElements_p, uint8 inRxAntMask, int8 Delay_us
// Returns:   void
//************************************
#ifndef ENET_INC_ARCH_WAVE600
void RxIQ_adaptiveGain(CorrRes_t Results[MAX_NUM_OF_ANTENNAS], RxIQRF_elements_t* inElements_p, uint8 inRxAntMask, int8 Delay_us);
void PhyCalDrv_Set_IQTD_Matrix(TxIq_elements_t* outElements_p, uint8 spectrum, uint8 ant);
#endif

void PhyCalDrv_Write_Register_Clipping(uint32 value);

/********************************************************************************
Method:	FdlWriteValueToFdlAdressSpace

Description: write fdl value per antenna to memory
------------
Input: RxAntenna 0-3, FdlAddressRegister , fdlDelay Value
********************************************************************************/

void FdlWriteValueToFdlAdressSpace(uint32 rxAntenna,uint32 FdlAddress,int8 fdlDelay);

//#endif /* #if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)  */
#endif

/********************************************************************************
PhyCalDrv_SetSpacelessTransmission:

Description:
------------
Set Spaceless Transmission

Input:
	bool
------
	
********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
void PhyCalDrv_SetSpacelessTransmission(bool);
void PhyCalDrv_BypassFrc(uint8 AntMsk, bool BypassFRCMode);
void PhyCalDrv_GetBypassFrcStatus(uint8 AntMsk, bool Frc_status_rtrn[MAX_NUM_OF_ANTENNAS]);
void PhyCalDrv_BypassFdl(uint8 AntMsk, bool BypassPhyFDLMode);
void PhyCalDrv_GetBypassFdlStatus(uint8 AntMsk, bool PhyFDL_status_rtrn[MAX_NUM_OF_ANTENNAS]);
void PhyCalDrv_SetDetectorResetTh(uint8 DetectorThreshold);
uint8 PhyCalDrv_GetDetectorResetTh(void);
void PhyCalDrv_Enable11bDetector(uint8 Enable_Detector_11b);
uint8 PhyCalDrv_Get11bDetectorState(void);

#endif


