/*******************************************************************************
*    
*   Source File:
*       PhyCalDriver.c
*	
*	AUTHOR: 
* 
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <lmi.h>
#include "mt_cnfg.h"	
#include "RegAccess_Api.h"
#include "PhyCalDriver_API.h"
#include "PhyRegsIncluder.h"
#include <mt_sysrst.h>
#include "PhyDriver_API.h"
#include "TpcClbrHndlr.h"
#include "HdkGlobalDefs.h"
#include "ErrorHandler_Api.h"
#include "RegAccess_Api.h"
#include "PhyRxTdRegs.h"
#include "PhyTxRegsRegs.h"
#include "PhyTxMacEmuRegs.h"
#include "PhyrxTdIfRiscPage0TdRegs.h"
#include "SharedDbTypes.h"
#include "LmHdk_API.h"
#include "HwMemoryMap.h"
#include "lib_rf_4x4_api.h"
#include "loggerAPI.h"
#include "RxIQMismatchClbrHndlr.h"
#include "Afe_API.h"
#include "MT_Math.h"
#include "mt_sysdefs.h"
#include "RficDriver_API.h"
#include "fast_mem_psd2mips.h"
#include "stringLibApi.h"
#include "PhyRxTdRegs.h"
#include "RegAccess_Api.h"




#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 8

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/	
#define BASE_OUTPUT_POWER		(-25)
#define BASE_SCALER				(9)
#define EQ_BYPASS_ON			(1)
#define IIR_BYPASS_ON			(1)
#define TX_IQ_CAL_BYPASS_ON		(1)
#define EQ_BYPASS_OFF			(0)
#define IIR_BYPASS_OFF			(0)
#define TX_IQ_CAL_BYPASS_OFF	(0)
#define W1W2_IQ_CAL_BYPASS_OFF	(0)
#define W1W2_IQ_CAL_BYPASS_ON	(1)
#define GOERTZEL_BRANCH_Q       (0)
#define GOERTZEL_BRANCH_I       (1)
#define RSSI_ROUND				(6)
#define EXTENDED_SIGN_TO_10BIT  0x300
#define SIGN_BIT 		  		0x80


enum 
{
	RESET_RSSI			=	1,		
	RESET_ATHENA		=	2,
	RESET_PROMETHEUS	=	4,
	RESET_GERZOEL		=	8,
	RESET_DELTA_F		=	16,
	RESET_NOISE_EST		=	32,
	RESET_GENRISC		=	64,
	RESET_RISC_LOGIC	=	128,
	RESET_TB_FIFO		=	256,
	RESET_ARBITER		=	512
};

enum 
{
	RESET_ADC					=	1,
	RESET_IQ					=	2,
	RESET_DECIMATOR				=	4,
	RESET_BAND_SELECT			=	8,
	RESET_DET_LONG				=	16,
	RESET_DET					=	32,
	RESET_FIFO					=	64,
	RESET_NCO					=	128,
	RESET_OLA					=	256,
	RESET_TD_CSM				=	512,
	RESET_RXAGC					=	1024,
	RESET_CCA					=	2048,
	RESET_DET_TOP				=	4096, 
	RESET_BB_RSSI_EXELERATOR	=	8192, 
	RESET_RSSI_EXELERATOR		=	16384 
};

#define REG_TX_FFT_SHARING_ALL_RX  (REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL_MASK | \
									REG_TX_FFT_SHARING_FFT0_CONTROL_RX_MASK | \
									REG_TX_FFT_SHARING_FFT1_CONTROL_RX_MASK | \
									REG_TX_FFT_SHARING_FFT2_CONTROL_RX_MASK | \
									REG_TX_FFT_SHARING_FFT3_CONTROL_RX_MASK)

#define DIFI_DPD_TOGGLE_ALL_ANT     (REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS_MASK | REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS_MASK | \
									 REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS_MASK )

#define DIFI_DPD_BYPASS_ON          (REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS_MASK | REG_PHY_RXTD_REG186_DIFI_DPD1_BYPASS_MASK | \
							         REG_PHY_RXTD_REG186_DIFI_DPD2_BYPASS_MASK )

#define DIFI_DPD_BYPASS_OFF          (0)
#define FDL_BYPASS_OFF          	 (0)
#define FDL_BYPASS_ON          	 (1)


#define NUM_COS_BINS				(128)
#define FFT_LEN_20_80				512
#define FFT_LEN_40_80				512
#define FFT_LEN_80					(512)

#define TONEGEN_BINS_START_ADDR				(0x16000 + PHY_TX_BASE_ADDR)
#define TONEGEN_NUM_BINS					(32)
#define TONEGEN_BIN_MASK					(0xFF)
#define TONEGEN_BINS_BYTE_WIDTH				(4)
#define TONEGEN_MAC_EMULATOR_DISBALE_MASK	(0xFFF)
#define TONEGEN_DPD_DISBALE_MASK			(0x1)
#define TONEGEN_WINDOWING_DISBALE_MASK		(0x400)
#define TONEGEN_IQTD_BYPASS_MASK			(0x300000)
#define TONEGEN_MAC_EMULATOR_BW_MASK		(0xC)
#define TONEGEN_BF_DISBALE_MASK				(0x400000)
#define TONEGEN_MAC_EMULATOR_ENABLE_MASK	(0x4)
#define TONEGEN_IQ_BYPASS_MASK				(0x200000)
#define TONEGEN_TONE_GEN_ENABLE_MASK		(0x1)
#define TONEGEN_ACC_OFF_MASK				(0x1)
#define TONEGEN_DIGITAL_GAIN_ENABLE_MASK	(0x200000)
#define TONEGEN_IQFD_BYPASS_MASK			(0x2)
#define TONEGEN_ANT_MASK					(0x3c000)
#define TONEGEN_ANT_SHIFT					(14)
#define TONEGEN_AFE_ANT_MASK				(0xF0)
#define TONEGEN_AFE_ANT_SHIFT				(4)
#define TONEGEN_MAC_EMULATOR_STOP_MASK		(0x1)
#define TONEGEN_MAC_EMULATOR_CDD_MASK		(0xFF)
#define TONEGEN_MAC_EMULATOR_CDD_VAL		(0x42)
#define TONEGEN_MAC_EMULATOR_TONE_VAL		(0x1E0)
#define TONEGEN_TX_ROUND_MASK				(0xFF)
#define TONEGEN_TX_ROUND_VAL				(0xA9)
#define TONEGEN_FILT_ANT01_MASK				(0x1FF1FF)
#define TONEGEN_FILT_ANT01_VAL				(0x143000 | TONEGEN_FILT_ANT01_VAL_LSB)
#define TONEGEN_FILT_ANT23_MASK				(0x3FFFF)
#define TONEGEN_FILT_ANT23_VAL				(0x28743)
#define TONEGEN_NUMCYCLES_MASK				(0xFFFFFFE0)
#define TONEGEN_MAC_EMULATOR_TONE_MASK		(TONEGEN_TONE_GEN_ENABLE_MASK | TONEGEN_MAC_EMULATOR_ENABLE_MASK | TONEGEN_NUMCYCLES_MASK)
#define TONEGEN_BIN_FACTOR					(8)
#define TONEGEN_AMP_MASK					(0xF)

#define RX_ENABLE_VALUE 		(0xFFFF)
#define TX_ENABLE_VALUE 		(0xFFFFFFFF)
#define TX_DISABLE_VALUE 0

#define TXIQ_BIN_BYTE_WIDTH		4
#define TXIQ_NUM_BINS			256

#define IFFT_SB_VAL_DEFAULT		(0x15551555)
#define IFFT_SB_VAL_0			(0x10001555)
#define DBW_TO_DBM_FACTOR        30
#define LOG_ACCURACY_BIT 		(5)



#ifdef RFIC_WRX300
int8 adaptive_gainTable[ADAPTIVE_GAIN_TABLE_SIZE][NUM_OF_PGCS] = 
{
  /*dBm*/        /*PGC1*/                    /*PGC2*/                           /*PGC3*/
   /*  0*/       {RX_IQ_PGC1,          RX_IQ_PGC2-2*RX_IQ_PGC2_STEP,        RX_IQ_PGC3-RX_IQ_PGC3_STEP},    
   /*-1*/       {RX_IQ_PGC1,          RX_IQ_PGC2-2*RX_IQ_PGC2_STEP,        RX_IQ_PGC3},                   
   /*-2*/       {RX_IQ_PGC1,          RX_IQ_PGC2-2*RX_IQ_PGC2_STEP,        RX_IQ_PGC3+RX_IQ_PGC3_STEP},        
   /*-3*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3-4*RX_IQ_PGC3_STEP},              
   /*-4*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3-3*RX_IQ_PGC3_STEP},   
   /*-5*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3-2*RX_IQ_PGC3_STEP},   
   /*-6*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3-RX_IQ_PGC3_STEP},   
   /*-7*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3},               
   /*-8*/       {RX_IQ_PGC1,          RX_IQ_PGC2-RX_IQ_PGC2_STEP,          RX_IQ_PGC3+RX_IQ_PGC3_STEP}, 
   /*-9*/       {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3-4*RX_IQ_PGC3_STEP},
   /*-10*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3-3*RX_IQ_PGC3_STEP},    
   /*-11*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3-2*RX_IQ_PGC3_STEP},   
   /*-12*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3-RX_IQ_PGC3_STEP},   
   /*-13*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3},               
   /*-14*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3+RX_IQ_PGC3_STEP}, 
   /*-15*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3+2*RX_IQ_PGC3_STEP}, 
   /*-16*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3+3*RX_IQ_PGC3_STEP}, 
   /*-17*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3+4*RX_IQ_PGC3_STEP}, 
   /*-18*/      {RX_IQ_PGC1,          RX_IQ_PGC2,                          RX_IQ_PGC3+5*RX_IQ_PGC3_STEP}, 
   /*-19*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3},                   
   /*-20*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+RX_IQ_PGC3_STEP},     
   /*-21*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+2*RX_IQ_PGC3_STEP},    
   /*-22*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+3*RX_IQ_PGC3_STEP},               
   /*-23*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+4*RX_IQ_PGC3_STEP}, 
   /*-24*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+5*RX_IQ_PGC3_STEP}, 
   /*-25*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3},                 
   /*-26*/      {RX_IQ_PGC1,          RX_IQ_PGC2+RX_IQ_PGC2_STEP,          RX_IQ_PGC3+RX_IQ_PGC3_STEP}, 
};
#endif

/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/ 
typedef struct StyleEntry 
{
	uint32	Value	;
	uint32	offset	;
}Style_Entry_T;

typedef struct RegBackup 
{
	uint32	Unit	;
	uint32	Address	;
	uint32	Value	;
}RegBackup_T;

typedef struct ToneGenParams
{
	bool lstfMode;
	uint8 outOfBand;
	uint8 antMask;
	uint16 digitalGain;
	uint32 storedAntMask;
	uint32 storedWindowing;
	uint32 storedTx0round;
	uint32 storedTx1round;
	uint32 storedTx2round;
	uint32 storedTx3round;
	uint32 storedTx0round_eight;
	uint32 storedTx1round_eight;
	uint32 storedTx2round_eight;
	uint32 storedTx3round_eight;
	uint32 storedBF;
	uint32 storedDPD;
	uint32 numCycles;
} ToneGenParams_t;




/******************************************************************************/
/***						Static Variables								***/
/******************************************************************************/
static int8				m_CalIsCBMode;
static ClbrProcType_e	m_CurCalType = CLBR_PROC_TYPE_INVALID;
#if  defined(RFIC_WRX500)||defined(RFIC_WRX514)
static uint32			m_TxIQTableOffsets[MAX_NUM_OF_ANTENNAS] =	{TXIQ_ANT0, TXIQ_ANT1, TXIQ_ANT2, TXIQ_ANT3};
#else
static uint32			m_TxIQTableOffsets[MAX_NUM_OF_ANTENNAS] =	{TXIQ_ANT0, TXIQ_ANT1, TXIQ_ANT2};
#endif

//Mirrored Registers - Registers that are backed up and restored after calibration:
static RegPhyRxTdPhyRxtdReg25F_u m_DeCorrValues[MAX_NUM_OF_BW][MAX_NUM_OF_ANTENNAS];
static sAntTxIndex_0_DigitalGain_T m_TxIndexDigitalGain;

static uint32 m_Bypasses[MAX_NUM_OF_ANTENNAS];
static uint32 m_BypassesTx;
static uint32 m_BypassesFdl;
static uint32 m_BypassesDpd;
static uint32 m_BypassesW1W2;
static uint32 m_fftRegV;

#define NUM_OF_TX_REGISTERS_BKP sizeof(m_txBackupRegisters)/sizeof(RegBackup_T)	

ToneGenParams_t toneGenDB;

int16 CosValues[NUM_COS_BINS] =
{
	8192,
	8191,
	8190,
	8186,
	8182,
	8177,
	8170,
	8162,
	8153,
	8142,
	8130,
	8117,
	8103,
	8088,
	8071,
	8054,
	8035,
	8014,
	7993,
	7970,
	7946,
	7921,
	7895,
	7868,
	7839,
	7809,
	7779,
	7746,
	7713,
	7679,
	7643,
	7606,
	7568,
	7529,
	7489,
	7448,
	7405,
	7362,
	7317,
	7272,
	7225,
	7177,
	7128,
	7078,
	7027,
	6974,
	6921,
	6867,
	6811,
	6755,
	6698,
	6639,
	6580,
	6519,
	6458,
	6396,
	6332,
	6268,
	6203,
	6137,
	6070,
	6002,
	5933,
	5863,
	5793,
	5721,
	5649,
	5575,
	5501,
	5426,
	5351,
	5274,
	5197,
	5119,
	5040,
	4960,
	4880,
	4799,
	4717,
	4634,
	4551,
	4467,
	4383,
	4297,
	4212,
	4125,
	4038,
	3950,
	3862,
	3773,
	3683,
	3593,
	3503,
	3411,
	3320,
	3228,
	3135,
	3042,
	2948,
	2854,
	2760,
	2665,
	2570,
	2474,
	2378,
	2282,
	2185,
	2088,
	1990,
	1893,
	1795,
	1697,
	1598,
	1499,
	1400,
	1301,
	1202,
	1102,
	1003,
	903,
	803,
	703,
	603,
	502,
	402,
	301,
	201,
	100 
};

/******************************************************************************/
/***					Static Function Declaration							***/
/******************************************************************************/
static void SetCalDefaultParametersTx(int8 BypassIIR,int8 BypassEQ,int8 BypassTx_IQ, uint32 BypassDPD, uint8 antenna);
static void SetCalDefaultParametersRx(int8 BypassIIR,int8 BypassEQ,int8 BypassW1W2_IQ, uint32 BypassFDL);
static void	Corr_ReadResults(uint8 Ant,CorrRes_t *Results,bool isIqSwapped);
static void	Corr_TriggerMeasurement(int8 AntMask,int8 Delay);
static int16	GetCosValue(int16 BinIndex, uint8 bw);
static int16	GetSinValue(int16 BinIndex,int8 IsCB);
/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#define SIGN_EXTEND(value, Bits)	if(value  >= (1<< (Bits-1) ) ) value-=(1<<Bits)

void PhyCalDrv_SetLoopBackMode(ClbrProcType_e procType,short Antenna)
{
	uint8 iirBypass;
#ifdef RFIC_WRX300
	iirBypass = IIR_BYPASS_ON; 
#else
	iirBypass = IIR_BYPASS_OFF;
#endif

	m_CurCalType=procType;
//	m_CalIsCBMode = HDK_getChannelWidth();

	switch(m_CurCalType)
	{
		case CLBR_PROC_TYPE_RX_DC_OFFSET: //Rx DC/SSI ADC calibrations, EQ and IIR are bypassed.
		case CLBR_PROC_TYPE_MS_SSI_ADC:
			SetCalDefaultParametersTx(IIR_BYPASS_ON,EQ_BYPASS_ON,TX_IQ_CAL_BYPASS_OFF,DIFI_DPD_BYPASS_OFF, Antenna);
		break;
		case CLBR_PROC_TYPE_TX_IQ_MISMATCH:
		case CLBR_PROC_TYPE_TX_LO_LEAKAGE:
			SetCalDefaultParametersTx(iirBypass,EQ_BYPASS_ON,TX_IQ_CAL_BYPASS_OFF,DIFI_DPD_BYPASS_ON, Antenna);
	         break;
		case CLBR_PROC_TYPE_LPF: //Tx/LPF calibration, EQ and IIR are bypassed.
			SetCalDefaultParametersTx(IIR_BYPASS_ON,EQ_BYPASS_ON,TX_IQ_CAL_BYPASS_ON,DIFI_DPD_BYPASS_OFF, Antenna); // we need to bypass the Tx_iq cal results because of problem with the shifter at the ToneGen
		break;
		case CLBR_PROC_TYPE_RSSI_PATH_CALIB:
			SetCalDefaultParametersTx(IIR_BYPASS_ON,EQ_BYPASS_ON,TX_IQ_CAL_BYPASS_OFF,DIFI_DPD_BYPASS_OFF, Antenna);
		break;
		case CLBR_PROC_TYPE_RX_IQ_MISMATCH:
			SetCalDefaultParametersRx(IIR_BYPASS_OFF,EQ_BYPASS_ON,W1W2_IQ_CAL_BYPASS_OFF,TRUE);// Bypass IIR ,W1W2 ,FDL ON, EQ ON
		break;
		default:
			break;
	}
	
}
void PhyCalDrv_bypassForRssiCalibration(void)
{
	SetCalDefaultParametersRx(IIR_BYPASS_OFF,EQ_BYPASS_ON,W1W2_IQ_CAL_BYPASS_ON,FDL_BYPASS_ON);
}

void PhyCalDrv_RestoreOperationalTx()
{
	int8 i;
	//Restore mirrored registers:
	//1.bypass register:
	//2. W1,W2
    //3.digital gain of Tx power index #0 (used for tone generator) 
	for(i=0;i<MAX_NUM_OF_ANTENNAS;++i)
	{
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG05+i*IQ_BYPASS_ANT_OFFSET,m_Bypasses[i]);
    }
    
    PhyCalDrv_SetDigitalGain(0,0,m_TxIndexDigitalGain.DigitalGain);
	
	//4. Restore Tx_IQ bypass
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_BE_REG_48_TX_FILTER_FLIP,m_BypassesTx);
	
	//5. Disable loopbacks:
	MT_WrReg(PHY_TD_BASE_ADDR,	REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE,0);
	MT_WrRegMask(PHY_FD_BASE_ADDR,	REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE,REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_MASK,0);

	MT_WrRegMask(PHY_TX_BASE_ADDR,REG_TX_FFT_SHARING_FFT_SHARE_OVERRIDE_CONTROL,0xFF,0);
	m_CurCalType	=	CLBR_PROC_TYPE_INVALID;

	//6. Resotre Dpd bypass
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS,m_BypassesDpd);
	
	//	4.Restore FFT Register

	RegAccess_Write(REG_PHY_TX_REGS_TX_FFT_SHARING,m_fftRegV);
}
void PhyCalDrv_RestoreOperationalRx()
{
	int8 i;
	uint32 Ant,bw,wreg,offset;
	//Restore mirrored registers:
	//bypass register:
	//1. IRR
	//2. FDL
	//3. FFT
	//4.Do not restore Bypass register W1W2
	for(Ant = 0;Ant < MAX_NUM_OF_ANTENNAS; ++Ant)
	{
		for(bw = 0;bw < MAX_NUM_OF_BW; ++bw)
		{
			wreg=REG_PHY_RX_TD_PHY_RXTD_REG257+(bw*RX_IQ_BW_OFFSET);
			offset=(wreg+Ant*4);
			RegAccess_Write(offset,m_DeCorrValues[bw][Ant].val);
		}
	}
    
	for(i=0;i<MAX_NUM_OF_ANTENNAS;++i)
	{
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG05+i*IQ_BYPASS_ANT_OFFSET,m_Bypasses[i]);
    }
    
	//	2. Restore FDL bypass
	
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG252,m_BypassesFdl);

	//	3.Restore FFT Register

	RegAccess_Write(REG_PHY_TX_REGS_TX_FFT_SHARING,m_fftRegV);

}

void PhyCalDrv_ToneGenInitAfe()
{
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_AFE_DYN_CTRL, AFE_LOOPBACK_REGISTER_MASK, 0x0F);//tx4b rx4b 0=on 1=off
}


void PhyCalDrv_ToneGenInit( int8 Amplitude )
{
	uint8 index;
	uint8 bw;
	uint32 addr;
	uint32 val;
	RegPhyTxMacEmuToneGen_u regVal;
		
	bw = HDK_getChannelWidth();

	//store values to write back on tone gen restore
	RegAccess_Read(REG_PHY_TX_REGS_TX_BE_REG_07, &val);
	toneGenDB.storedAntMask = val & TONEGEN_ANT_MASK;
	toneGenDB.storedWindowing = val & TONEGEN_WINDOWING_DISBALE_MASK;
	
	RegAccess_Read(REG_PHY_TX_REGS_TX0_FE_REG_07, &val);
	toneGenDB.storedTx0round = val & TONEGEN_TX_ROUND_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX1_FE_REG_07, &val);
	toneGenDB.storedTx1round = val & TONEGEN_TX_ROUND_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX2_FE_REG_07, &val);
	toneGenDB.storedTx2round = val & TONEGEN_TX_ROUND_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX3_FE_REG_07, &val);
	toneGenDB.storedTx3round = val & TONEGEN_TX_ROUND_MASK;

	RegAccess_Read(REG_PHY_TX_REGS_TX0_FE_REG_14F, &val);
	toneGenDB.storedTx0round_eight= val & TONEGEN_AMP_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX1_FE_REG_14F, &val);
	toneGenDB.storedTx1round_eight= val & TONEGEN_AMP_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX2_FE_REG_14F, &val);
	toneGenDB.storedTx2round_eight= val & TONEGEN_AMP_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_TX3_FE_REG_14F, &val);
	toneGenDB.storedTx3round_eight= val & TONEGEN_AMP_MASK;

	RegAccess_Read(REG_PHY_TX_REGS_BEAM_FORMING0, &val);
	toneGenDB.storedBF = val & TONEGEN_BF_DISBALE_MASK;
	RegAccess_Read(REG_PHY_TX_REGS_CYCLIC_INTERPOLATION_DPD0, &val);
	toneGenDB.storedDPD = val & TONEGEN_DPD_DISBALE_MASK;
	toneGenDB.digitalGain = PhyCalDrv_GetDigitalGain(0,0);
	
	for (index = 0; index < TONEGEN_NUM_BINS; index++)
	{
		addr = TONEGEN_BINS_START_ADDR + (index * TONEGEN_BINS_BYTE_WIDTH);
		RegAccess_WriteMasked(addr, TONEGEN_BIN_MASK, 0);
	}

	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_15, IFFT_SB_VAL_0);
	
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, TX_DISABLE_VALUE);
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, TX_ENABLE_VALUE);

	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR2, TONEGEN_MAC_EMULATOR_DISBALE_MASK, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_CYCLIC_INTERPOLATION_DPD0, TONEGEN_DPD_DISBALE_MASK, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_07, TONEGEN_WINDOWING_DISBALE_MASK, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR0, TONEGEN_MAC_EMULATOR_BW_MASK, bw);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_BEAM_FORMING0, TONEGEN_BF_DISBALE_MASK, TX_DISABLE_VALUE);

	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_04, TONEGEN_MAC_EMULATOR_ENABLE_MASK, TONEGEN_MAC_EMULATOR_ENABLE_MASK);
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TONE_GEN, TONEGEN_TONE_GEN_ENABLE_MASK, TONEGEN_TONE_GEN_ENABLE_MASK);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TPC_ACC, TONEGEN_ACC_OFF_MASK, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, TONEGEN_DIGITAL_GAIN_ENABLE_MASK, TONEGEN_DIGITAL_GAIN_ENABLE_MASK);

	RegAccess_Read(REG_PHY_TX_MAC_EMU_TONE_GEN, &regVal.val);
	if (toneGenDB.lstfMode == TRUE)
	{
		regVal.bitFields.toneGenLstfMode = 1;
	}
	else
	{
		regVal.bitFields.toneGenLstfMode = 0;
	}

	if (toneGenDB.outOfBand > 0)
	{
		RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_48, TONEGEN_IQFD_BYPASS_MASK, TONEGEN_IQFD_BYPASS_MASK);
		regVal.bitFields.toneGenMixerMode = toneGenDB.outOfBand;
	}
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TONE_GEN, regVal.val);

	val = toneGenDB.antMask << TONEGEN_ANT_SHIFT;
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_07, TONEGEN_ANT_MASK, val);

	val = (~(toneGenDB.antMask) & ANTENNA_BITMAP_ALL_ANTENNAS_GEN5) << TONEGEN_AFE_ANT_SHIFT;
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_AFE_DYN_CTRL, TONEGEN_AFE_ANT_MASK, val);

	PhyCalDev_SetToneGenAmplitude(Amplitude);

	MT_DELAY(10);
}

void PhyCalDrv_SetToneGenParams(bool lstfMode,uint8 outOfBand, uint8 antMask, uint32 numCycles)
{
	toneGenDB.lstfMode = lstfMode;
	toneGenDB.outOfBand = outOfBand;
	toneGenDB.antMask = antMask;
	toneGenDB.numCycles = numCycles;
}

void PhyCalDrv_ToneGenRestore()
{
	
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_15, IFFT_SB_VAL_DEFAULT);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR2, TONEGEN_MAC_EMULATOR_CDD_MASK, TONEGEN_MAC_EMULATOR_CDD_VAL);
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TONE_GEN, TONEGEN_MAC_EMULATOR_TONE_MASK, TONEGEN_MAC_EMULATOR_TONE_VAL);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_04, TONEGEN_MAC_EMULATOR_ENABLE_MASK, TX_DISABLE_VALUE);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_07, TONEGEN_WINDOWING_DISBALE_MASK, toneGenDB.storedWindowing);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_07, TONEGEN_ANT_MASK, toneGenDB.storedAntMask);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX0_FE_REG_07, TONEGEN_TX_ROUND_MASK, toneGenDB.storedTx0round);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX1_FE_REG_07, TONEGEN_TX_ROUND_MASK, toneGenDB.storedTx1round);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX2_FE_REG_07, TONEGEN_TX_ROUND_MASK, toneGenDB.storedTx2round);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX3_FE_REG_07, TONEGEN_TX_ROUND_MASK, toneGenDB.storedTx3round);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX0_FE_REG_14F, TONEGEN_AMP_MASK, toneGenDB.storedTx0round_eight);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX1_FE_REG_14F, TONEGEN_AMP_MASK, toneGenDB.storedTx1round_eight);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX2_FE_REG_14F, TONEGEN_AMP_MASK, toneGenDB.storedTx2round_eight);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX3_FE_REG_14F, TONEGEN_AMP_MASK, toneGenDB.storedTx3round_eight);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_BEAM_FORMING0, TONEGEN_BF_DISBALE_MASK, toneGenDB.storedBF);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_CYCLIC_INTERPOLATION_DPD0, TONEGEN_DPD_DISBALE_MASK, toneGenDB.storedDPD);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TPC_ACC, TONEGEN_ACC_OFF_MASK, TONEGEN_ACC_OFF_MASK);
//CALTBD	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG00, RX_ENABLE_VALUE);
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG01, RX_ENABLE_VALUE);
	PhyCalDrv_SetDigitalGain(0,0,toneGenDB.digitalGain);
	MT_DELAY(10);
}

void PhyCalDrv_ToneGenSetOutputPower( int8 OutputPower )
{
	
}


void PhyCalDrv_ToggleTxToneExtended(int8 bin,int8 toggle, ToneGenShiftMode_e shiftMode)
{
	uint32 addr;
	int32 binLocation;
	int32 binOffset;
	uint32 mask;
	
	//set num of cycles
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TONE_GEN, TONEGEN_NUMCYCLES_MASK, toneGenDB.numCycles);

	//set bin
	binOffset = (uint8)bin / TONEGEN_BIN_FACTOR;
	addr = TONEGEN_BINS_START_ADDR + (binOffset * TONEGEN_BINS_BYTE_WIDTH);
	binLocation = (uint8)bin - (binOffset * TONEGEN_BIN_FACTOR);

	mask = 1;

	while (binLocation > 0)
	{
		mask <<= 1;
		binLocation--;
	}

	//turn on tone gen
	if (toggle != FALSE)
	{
		RegAccess_WriteMasked(addr, mask, mask);
		RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TONE_GEN, TONEGEN_MAC_EMULATOR_ENABLE_MASK, TONEGEN_MAC_EMULATOR_ENABLE_MASK);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, TX_DISABLE_VALUE);
		RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, TX_DISABLE_VALUE);
		RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, TX_DISABLE_VALUE);
		MT_DELAY(1);
		RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, TX_ENABLE_VALUE);
		RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, TX_ENABLE_VALUE);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, TONEGEN_TONE_GEN_ENABLE_MASK);
	}
	else //turn off
	{
		RegAccess_WriteMasked(addr, mask, 0);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, TX_DISABLE_VALUE);
		RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TONE_GEN, TONEGEN_MAC_EMULATOR_ENABLE_MASK, TX_DISABLE_VALUE);
	}

	MT_DELAY(100);
}


void PhyCalDrv_ToggleTxTone(IN int8 bin, IN int8 toggle )
{
	PhyCalDrv_ToggleTxToneExtended(bin,toggle,TONE_GEN_SHIFT_NONE);
}

void PhyCalDrv_ToneGenRestart( void )
{
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_MAC_EMU_REG00_EMU_RUN,0);
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_BE_REG_00_SW_RESET_N_REG,0);
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, TX_DISABLE_VALUE);
	MT_DELAY(1);
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_BE_REG_00_SW_RESET_N_REG,0xffffffff);
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, TX_ENABLE_VALUE);
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_MAC_EMU_REG00_EMU_RUN,1);
	MT_DELAY(10);
}

void PhyCalDrv_SetTxIQCoefficients( int8 Ant,int8 k,int16 a,int16 b )
{
	uint32 TableAddress;	
	sTxIQCoeffsEntry_T	TxIQCorr;

	TableAddress = m_TxIQTableOffsets[Ant]+ ((uint8)k * TXIQ_BIN_BYTE_WIDTH);

	TxIQCorr.reg	=	0;
	TxIQCorr.a		=	(a & 0x3ff);
	TxIQCorr.b		=	(b & 0x3ff);

	TableAddress += PHY_TX_BASE_ADDR;

	RegAccess_Write(TableAddress, TxIQCorr.reg);
	//duplicate writes for all BB gains
	TableAddress += (TXIQ_NUM_BINS * TXIQ_BIN_BYTE_WIDTH);
	RegAccess_Write(TableAddress, TxIQCorr.reg);
	TableAddress += (TXIQ_NUM_BINS * TXIQ_BIN_BYTE_WIDTH);
	RegAccess_Write(TableAddress, TxIQCorr.reg);
}

void PHYCalDrv_GetTxIQCoefficients( int8 Ant, int8 k, int16* a, int16* b )
{
	uint32 TableAddress;	
	sTxIQCoeffsEntry_T	TxIQCorr;

	TableAddress = m_TxIQTableOffsets[Ant]+ ((uint8)k * TXIQ_BIN_BYTE_WIDTH);

	TxIQCorr.reg = MT_RdReg(PHY_TX_BASE_ADDR,TableAddress);
	
	*a	= (int16)TxIQCorr.a;
	SIGN_EXTEND(*a,10);
	
	*b	=(int16)TxIQCorr.b;
	SIGN_EXTEND(*b,10);
}

void PhyCalDrv_GoertzelInit(Goertzel_e goertzelNum, int8 Ant, int8 branch, bool isIqSwapped, int8 NumOfCycles)
{
	RegPhyRxTdPhyRxtdReg053_u inputSelectReg;
	RegPhyRxTdPhyRxtdReg058_u validThReg;
	uint16 inputSelect;
	uint8 tempAnt = Ant;
	
	DEBUG_ASSERT((goertzelNum & 2) == (Ant & 2));
	DEBUG_ASSERT((branch == RFIC_PATH_TYPE_I) || (branch == RFIC_PATH_TYPE_Q));

	if (goertzelNum >= GOERTZEL_2)
	{
		tempAnt -= 2;
	}
	
	inputSelect = 1 << ((tempAnt << 1) + branch);
	
	RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG053,&inputSelectReg.val);
	RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG058,&validThReg.val);

	switch (goertzelNum)
	{
		case GOERTZEL_0:
			inputSelectReg.bitFields.geortzel0InputSelect = inputSelect;
			validThReg.bitFields.geortzel0ValidThr = NumOfCycles;
			break;
		case GOERTZEL_1:
			inputSelectReg.bitFields.geortzel1InputSelect = inputSelect;
			validThReg.bitFields.geortzel1ValidThr = NumOfCycles;
			break;
		case GOERTZEL_2:
			inputSelectReg.bitFields.geortzel2InputSelect = inputSelect;
			validThReg.bitFields.geortzel2ValidThr = NumOfCycles;
			break;
		case GOERTZEL_3:
			inputSelectReg.bitFields.geortzel3InputSelect = inputSelect;
			validThReg.bitFields.geortzel3ValidThr = NumOfCycles;
			break;
		default:
			DEBUG_ASSERT(0);
			break;
	}

	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG053, inputSelectReg.val);
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG058, validThReg.val);
}

void PhyCalDrv_GoertzelMeasure(uint8 goertzelMask, GoertzelRes_t *Results, int16 k, int8 Delay_us )
{
	Goertzel_e goertzel;
	RegPhyRxTdPhyRxtdReg054_u goertzel0MulReg;
	RegPhyRxTdPhyRxtdReg2Ae_u goertzel0IResultsReg;
	RegPhyRxTdPhyRxtdReg2Af_u goertzel0QResultsReg;
	RegPhyRxTdPhyRxtdReg052_u resetAccReg;
	int8 isValid;
	uint32 Start_Cal_Time = 0,End_Cal_Time;
	
	goertzel0MulReg.val = 0;
	
	goertzel0IResultsReg.val = 0;
	goertzel0QResultsReg.val = 0;
	
	resetAccReg.val = 0;
	
	goertzel0MulReg.bitFields.geortzel0MulI = GetCosValue(k,m_CalIsCBMode);
	goertzel0MulReg.bitFields.geortzel0MulQ = GetSinValue(k,m_CalIsCBMode);

	resetAccReg.bitFields.geortzelResetAcum = goertzelMask;
	
	for (goertzel = GOERTZEL_0; goertzel < TOTAL_GOERTZELS; goertzel++)
	{
		if ((1 << goertzel) & goertzelMask)
		{
			RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG054 + (goertzel << 2), goertzel0MulReg.val);
		}
	}
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG052, resetAccReg.val);

	//Wait for end:
	for (goertzel = GOERTZEL_0; goertzel < TOTAL_GOERTZELS; goertzel++)
	{
		Results[goertzel].Res_I_Real = 0;
		Results[goertzel].Res_Q_Real = 0;
		
		if ((1 << goertzel) & goertzelMask)
		{
			isValid = 0;
			Start_Cal_Time = TIME_STAMP(0,Start_Cal_Time);
			while(!isValid)
			{
				RegAccess_Read((REG_PHY_RX_TD_PHY_RXTD_REG2AF + (goertzel << 3)), &goertzel0QResultsReg.val);
				isValid =  goertzel0QResultsReg.bitFields.geortzel0DataValid;
				End_Cal_Time = TIME_STAMP(1,Start_Cal_Time);
				ASSERT(End_Cal_Time <= PHY_VALID_DELAY)		
			}
			
			RegAccess_Read((REG_PHY_RX_TD_PHY_RXTD_REG2AE + (goertzel << 3)), &goertzel0IResultsReg.val);
			Results[goertzel].Res_I_Real = goertzel0IResultsReg.bitFields.geortzel0IResult;
			
			RegAccess_Read((REG_PHY_RX_TD_PHY_RXTD_REG2AF + (goertzel << 3)), &goertzel0QResultsReg.val);
			Results[goertzel].Res_Q_Real = goertzel0QResultsReg.bitFields.geortzel0QResult;
				
			//Sign extension to 32 bits.
			SIGN_EXTEND(Results[goertzel].Res_I_Real,REG_PHY_RXTD_REG056_GEORTZEL_I_RESULT_WIDTH);
			SIGN_EXTEND(Results[goertzel].Res_Q_Real,REG_PHY_RXTD_REG057_GEORTZEL_Q_RESULT_WIDTH);
		}
	}

	return;
}
	

void PhyCalDrv_CorrInit(int8 Mode, uint8 antMask, int32 NumOfSamples, int8 Round,int8 IIR_mu)
{
	RegPhyRxTdPhyRxtdReg06_u  CorrInit;
	RegPhyRxTdPhyRxtdReg263_u Accumulator;
	RegPhyRxTdPhyRxtdReg0C_u  AccSample;
	uint32 offset;
	uint8 ant;
	uint8 maxAnts;
	uint8 activeAntMsk;

	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &activeAntMsk);
	
	if(Mode==DC_MODE)
	{
		CorrInit.bitFields.iqMismatchEstRegularISumAn0  =	1;		
		CorrInit.bitFields.iqMismatchEstRegularQSumAn0	=	1;
		
		Accumulator.bitFields.iqMismatchEstShiftAnt0 	=	0;
		Accumulator.bitFields.iqMismatchEstShiftAnt1	=	0;
		Accumulator.bitFields.iqMismatchEstShiftAnt2 	=	0;
		Accumulator.bitFields.iqMismatchEstShiftAnt3	=	0;
		
		CorrInit.bitFields.iqMismatchIirMuIAn0			=	0;
		CorrInit.bitFields.iqMismatchIirMuQAn0			=	0;
	}
	else
	{
		Accumulator.bitFields.iqMismatchEstShiftAnt0 	=	Round;
		Accumulator.bitFields.iqMismatchEstShiftAnt1	=	Round;
		Accumulator.bitFields.iqMismatchEstShiftAnt2 	=	Round;
		Accumulator.bitFields.iqMismatchEstShiftAnt3 	=	Round;
		
		CorrInit.bitFields.iqMismatchEstRegularISumAn0  =	0;		
		CorrInit.bitFields.iqMismatchEstRegularQSumAn0	=	0;
				
		CorrInit.bitFields.iqMismatchIirMuIAn0			=	IIR_mu;
		CorrInit.bitFields.iqMismatchIirMuQAn0			=	IIR_mu;
	}

	Accumulator.bitFields.iqMismatchEst160Mhz			=	1;

	AccSample.bitFields.iqMismatchEstAccCounterAn0	=	NumOfSamples;
	
	//Set accumulators/estimator to 80MHz domain
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG263, Accumulator.val);
	//Update registers:
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if ((1<<ant) & antMask) /* masking so we will run the calibration only on active antennas */
		{
			offset = iq_AN1_OFFSET*ant;

			//Set IIR Shift according to RFIC BW 7(80M)/8(40M)/9(20M)
			RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG06+offset,CorrInit.val);
			
			//Set Number of samples 
			RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG0C+offset,AccSample.val);
		}
	}
}

void PhyCalDrv_setAccumTo80Mh(void)
{
	RegPhyRxTdPhyRxtdReg263_u Accumulator;
	Accumulator.val = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263);
	Accumulator.bitFields.iqMismatchEst160Mhz = 0;
	Accumulator.bitFields.iqMismatchAccumRssi = 0;
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263) = Accumulator.val;
}
void PhyCalDrv_setFirInBypass(uint32 iirEnable,uint32 firEnable,uint32 fdlEnable)
{
	
	RegPhyRxTdPhyRxtdReg05_u regVal_fir;
	uint8  antNum; 
	PhyCalDrv_setFdlNotInBypass(fdlEnable);
	for (antNum = 0; antNum < MAX_NUM_OF_ANTENNAS; antNum++)
	{
		/*put fir in bypass*/
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG05 + antNum*IQ_BYPASS_ANT_OFFSET, &regVal_fir.val);//Backup register	
		regVal_fir.bitFields.iqMismatchBypassIirAn0	= !iirEnable;
		regVal_fir.bitFields.iqMismatchBypassEqAn0	= !firEnable;
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG05 + antNum*IQ_BYPASS_ANT_OFFSET,regVal_fir.val);
	}
}

void PhyCalDrv_setFdlNotInBypass(uint32 fdlRamBypassMode)
{
	RegPhyRxTdPhyRxtdReg252_u regVal_fdl;
	RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG252, &regVal_fdl.val);//Backup register
	regVal_fdl.bitFields.iqFdlBypass = 0x0;
	regVal_fdl.bitFields.iqFdlBypassRam = fdlRamBypassMode;// fdl take value from register not from ram
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG252,regVal_fdl.val);
	
}

void PhyCalDrv_CorrMeasureAll(CorrRes_t Results[MAX_NUM_OF_ANTENNAS],int8 Delay_us,bool isIqSwapped)
{
	Antenna_e ant;
    uint8 rxAntMask, numOfAnts;
	
	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &rxAntMask);

	Corr_TriggerMeasurement(rxAntMask,Delay_us);
	
	//Read results:	
	for(ant=ANTENNA_0;ant<MAX_NUM_OF_ANTENNAS;++ant)
	{
		Corr_ReadResults(ant,&Results[ant],isIqSwapped);
	}
}

void PhyCalDrv_CorrMeasure(int8 ant, CorrRes_t* Result,int8 Delay_us,bool isIqSwapped)
{
	AntennaBitmaps_e antMask = (AntennaBitmaps_e)(1 << ant);
	
	 // Restart tone generator
    PhyCalDrv_ToneGenRestart();

	Corr_TriggerMeasurement(antMask,Delay_us);
	
	//Read results:	
	Corr_ReadResults(ant, Result, isIqSwapped);
}

void PhyCalDrv_RxIQSetWCoeffs(uint8 BandNum, int8 Ant, int16 W1,int16 W2,uint32 index)
{
	uint32 wreg=REG_PHY_RX_TD_PHY_RXTD_REG257+(BandNum*RX_IQ_BW_OFFSET);
	RegPhyRxTdPhyRxtdReg25F_u regVal;
	uint32 offset;
	
	offset=(wreg+Ant*4);
	m_DeCorrValues[BandNum][Ant].bitFields.iqW1Cb80An0 =W1;
	m_DeCorrValues[BandNum][Ant].bitFields.iqW2Cb80An0 =W2;
	regVal.bitFields.iqW1Cb80An0 = W1;
	regVal.bitFields.iqW2Cb80An0 = W2;
	
	RegAccess_Write(offset,regVal.val);
	
}

void PhyCalDrv_RxIQGetWCoeffs( uint8 BandNum, uint8 Ant, int16 * W1,int16  * W2)
{
	RegPhyRxTdPhyRxtdReg25F_u regVal;
	uint32 wreg=REG_PHY_RX_TD_PHY_RXTD_REG257+(BandNum*RX_IQ_BW_OFFSET);	
	uint32 offset;
	
	offset=(wreg+Ant*4);// find register's address. (2 - W1,W2 - each size is 4 total jump is 8)

	RegAccess_Read(offset,&regVal.val);

	*W1 = regVal.bitFields.iqW1Cb80An0;
	*W2 = regVal.bitFields.iqW2Cb80An0;
}

void PhyCalDrv_RSSITableSet(uint8 Ant, uint8 Pos,int8 Value)
{
	//Write register:
	MT_WrReg(PHY_TD_BASE_ADDR,RSSI_TABLE_ANT0+RSSI_TABLE_ANT_OFFSET*Ant+(Pos<<2),Value);
}

uint8 PhyCalDrv_RSSITableGet(uint8 Ant, uint8 Pos)
{
	int32 value;
	
	//Read register
	value=MT_RdReg(PHY_TD_BASE_ADDR, RSSI_TABLE_ANT0+RSSI_TABLE_ANT_OFFSET*Ant+(Pos<<2));
	
	return (uint8)(value & 0x3f);
}

void PhyCalDriver_ResetDcTables()
{
	uint32 add_offset;
	uint32 antenna_offset =0;
	uint8 ant;
	
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)//reset only table 1, doesn't reset dc digital cancelation
	{
		for (add_offset = 0; add_offset < ((RXDC_TABLE1_SECTION_LEN) * MAX_NUM_OF_BW  * RXDC_TABLE1_BYTE_WIDTH); add_offset += RXDC_TABLE1_BYTE_WIDTH)
		{
			RegAccess_Write(RXDC_TABLE1_START_ADDRESS + add_offset + antenna_offset, 0);
		}
		antenna_offset += ((RXDC_TABLE1_SECTION_LEN+RXDC_TABLE1_CORRECTION_LEN) * MAX_NUM_OF_BW  * RXDC_TABLE1_BYTE_WIDTH);
	}
	
	add_offset = RXDC_TABLE2_START_ADDRESS;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		memset32((void*)add_offset, 0, (RXDC_TABLE2_SECTION_LEN * MAX_NUM_OF_BW));
		add_offset += ((RXDC_TABLE2_SECTION_LEN * MAX_NUM_OF_BW) + RXDC_TABLE2_LNA_LUT_SECTION_LEN) * RXDC_TABLE2_BYTE_WIDTH;
	}
}

void PhyCalDriver_ResetDcDigTable(uint8 bw)
{
	uint32 add_offset;
	uint32 ant ;
	uint32 antenna_offset =0;
	uint32 start = RXDC_TABLE1_START_ADDRESS +(bw * RXDC_TABLE1_CORRECTION_LEN * RXDC_TABLE1_BYTE_WIDTH)+ (MAX_NUM_OF_BW * RXDC_TABLE1_SECTION_LEN * RXDC_TABLE1_BYTE_WIDTH);//= RXDC_TABLE1_START_ADDRESS + ((MAXIMUM_BANDWIDTHS * RXDC_TABLE1_SECTION_LEN)+%ANTsel*MAXIMUM_BANDWIDTHS*(RXDC_TABLE1_SECTION_LEN+RXDC_TABLE1_CORRECTION_LEN)+bw*RXDC_TABLE1_CORRECTION_LEN)* MAX_NUM_OF_ANTENNAS ;

	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		for (add_offset = 0; add_offset < ((RXDC_TABLE1_CORRECTION_LEN) * RXDC_TABLE1_BYTE_WIDTH); add_offset += RXDC_TABLE1_BYTE_WIDTH)
		{
			RegAccess_Write(start + add_offset + antenna_offset, 0);
		}
		antenna_offset += ((RXDC_TABLE1_SECTION_LEN+RXDC_TABLE1_CORRECTION_LEN) * MAX_NUM_OF_BW  * RXDC_TABLE1_BYTE_WIDTH);
	}
}
void PhyCalDriver_StoreDcDigTable(uint8 ant, uint8 bw, uint32* Value)
{
	uint32 add_offset;
	uint32 antenna_offset =0;
	uint32 val;
	uint32 start = RXDC_TABLE1_START_ADDRESS +(bw * RXDC_TABLE1_CORRECTION_LEN * RXDC_TABLE1_BYTE_WIDTH)+ (MAX_NUM_OF_BW * RXDC_TABLE1_SECTION_LEN * RXDC_TABLE1_BYTE_WIDTH);
	antenna_offset = ant * ((RXDC_TABLE1_SECTION_LEN+RXDC_TABLE1_CORRECTION_LEN) * MAX_NUM_OF_BW  * RXDC_TABLE1_BYTE_WIDTH);
	for (add_offset = 0; add_offset < ((RXDC_TABLE1_CORRECTION_LEN) * RXDC_TABLE1_BYTE_WIDTH); add_offset += RXDC_TABLE1_BYTE_WIDTH)
	{
		RegAccess_Read(start + add_offset + antenna_offset, &val);
		Value[(add_offset/RXDC_TABLE1_BYTE_WIDTH)]=val;
	}
}
void PhyCalDriver_LoadDcDigTable(uint8 ant, uint8 bw, uint32* Value)
{
	uint32 add_offset;
	uint32 antenna_offset =0;
	uint32 start = RXDC_TABLE1_START_ADDRESS +(bw * RXDC_TABLE1_CORRECTION_LEN * RXDC_TABLE1_BYTE_WIDTH)+ (MAX_NUM_OF_BW * RXDC_TABLE1_SECTION_LEN * RXDC_TABLE1_BYTE_WIDTH);
	antenna_offset = ant * ((RXDC_TABLE1_SECTION_LEN+RXDC_TABLE1_CORRECTION_LEN) * MAX_NUM_OF_BW  * RXDC_TABLE1_BYTE_WIDTH);
	for (add_offset = 0; add_offset < ((RXDC_TABLE1_CORRECTION_LEN) * RXDC_TABLE1_BYTE_WIDTH); add_offset += RXDC_TABLE1_BYTE_WIDTH)
	{
		RegAccess_Write(start + add_offset + antenna_offset, Value[(add_offset/RXDC_TABLE1_BYTE_WIDTH)]);
	}
}


void PhyCalDrv_DCTable2Set( uint8 Ant, uint8 bw, int8 pgc2Gain, int8 *Value )
{

	uint32				TableAddress;
	uint32				TableOffset;
	sDCTable2Entry_T	TableEntry;
	uint8				mappedBW;
	uint8				pgc2index;

	pgc2index = pgc2Gain;
	mappedBW = bw;
	
	TableEntry.reg = 0;

	TableEntry.DC_Correction_I	=	(Value[0] & RXDC_TABLE2_FIELD_MASK);
	TableEntry.DC_Correction_Q	=	(Value[1] & RXDC_TABLE2_FIELD_MASK);

	TableOffset = (Ant * ((MAXIMUM_BANDWIDTHS_GEN5 * RXDC_TABLE2_SECTION_LEN) + RXDC_TABLE2_LNA_LUT_SECTION_LEN)) +
					(mappedBW * RXDC_TABLE2_SECTION_LEN) +
					pgc2index;
	
	TableAddress = RXDC_TABLE2_START_ADDRESS + (RXDC_TABLE2_BYTE_WIDTH * TableOffset);

	RegAccess_Write(TableAddress, TableEntry.reg);
}

void  PhyCalDrv_DCTable2Get(uint8 Ant, uint8 bw, int8 pgc2,int8 Value[2])
{
	uint32				TableAddress;
	uint32				TableOffset;
	sDCTable2Entry_T	TableEntry;
	uint8				mappedBW;
	uint8				pgc2index;

	pgc2index = pgc2;
	mappedBW = bw;

	TableOffset = (Ant * ((MAXIMUM_BANDWIDTHS_GEN5 * RXDC_TABLE2_SECTION_LEN) + RXDC_TABLE2_LNA_LUT_SECTION_LEN)) +
					(mappedBW * RXDC_TABLE2_SECTION_LEN) +
					pgc2index;
	
	TableAddress = RXDC_TABLE2_START_ADDRESS + (RXDC_TABLE2_BYTE_WIDTH * TableOffset);

	RegAccess_Read(TableAddress, &TableEntry.reg);

	Value[0]	=	(int8)TableEntry.DC_Correction_I;
	SIGN_EXTEND(Value[0], RXDC_TABLE2_FIELD_BIT_WIDTH);
	
	Value[1]	=	(int8)TableEntry.DC_Correction_Q;
	SIGN_EXTEND(Value[1], RXDC_TABLE2_FIELD_BIT_WIDTH);
}

void  PhyCalDrv_DCTable2GetAll(int8 LPF2,int8 Value[TOTAL_ANTENNAS][2])
{
	uint8 i;

	for(i=0;i<TOTAL_ANTENNAS;++i)
	{
		PhyCalDrv_DCTable2Get(i,HDK_getChannelWidth(), LPF2, Value[i]);
	}
}

void PhyCalDrv_DCTable2SetAll(int8 LPF2,int8 Value[TOTAL_ANTENNAS][2])
{
	uint8 i;

	for(i=0;i<TOTAL_ANTENNAS;++i)
	{
		PhyCalDrv_DCTable2Set(i, HDK_getChannelWidth(), LPF2, Value[i]);
	}
}


void PhyCalDrv_DCTable1Set(uint8 ant, uint8 bw, int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[2],int8 correction[2])
{
	uint32				TableOffset_AntBw;
	uint32				TableOffset_Pgc1Lna;
	uint32				TableAddress;
	uint32				tableLine;
	uint8				mappedBW;
	uint8				pgc1index;
	uint8				lnaTableIndex;

	pgc1index = (pgc1 + PGC1_INDEX_TO_GAIN_BIAS) / PGC1_INDEX_TO_GAIN_FACTOR;

	mappedBW = bw;

	PhyDrv_GetLnaActiveValue(lnaIndex, &lnaTableIndex);

	tableLine = ((value[RFIC_PATH_TYPE_Q] & RXDC_TABLE1_DAC1_FIELD_MASK) << (RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH << 1)) |
				((value[RFIC_PATH_TYPE_I] & RXDC_TABLE1_DAC1_FIELD_MASK) << ((RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH << 1)+RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH)) |
				(correction[RFIC_PATH_TYPE_Q] & RXDC_TABLE1_DAC2_FIELD_MASK) |
				((correction[RFIC_PATH_TYPE_I] & RXDC_TABLE1_DAC2_FIELD_MASK) << RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH);


	TableOffset_AntBw = ant * (MAXIMUM_BANDWIDTHS_GEN5 * (RXDC_TABLE1_SECTION_LEN + RXDC_TABLE1_CORRECTION_LEN)) +
						(mappedBW * RXDC_TABLE1_SECTION_LEN);

	TableOffset_Pgc1Lna = (pgc1index * RXDC_TABLE1_LNA_NUM) + lnaTableIndex;

	TableAddress = RXDC_TABLE1_START_ADDRESS +
					(RXDC_TABLE1_BYTE_WIDTH * (TableOffset_AntBw + TableOffset_Pgc1Lna));

	RegAccess_Write(TableAddress, tableLine);
}

void PhyCalDrv_DCTable1Get(uint8 ant, uint8 bw, int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[2], int8 correction[2])
{
	uint32				TableOffset_AntBw;
	uint32				TableOffset_Pgc1Lna;
	uint32				TableAddress;
	uint32				tableLine;
	uint8				mappedBW;
	uint8				pgc1index;
	uint8				lnaTableIndex;

	pgc1index = (pgc1 + PGC1_INDEX_TO_GAIN_BIAS) / PGC1_INDEX_TO_GAIN_FACTOR;

	mappedBW = bw;

	PhyDrv_GetLnaActiveValue(lnaIndex, &lnaTableIndex);

    /* We use the active value here because in AR10 and W400 DC Table 1 has entries for */
    /* all LNA indexes, but uses only the entries corresponding to active LNA values    */
	/* 6 == PGC1 step size (-6..24), 4 == LNA range (0..3) */
	TableOffset_AntBw = ant * (MAXIMUM_BANDWIDTHS_GEN5 * (RXDC_TABLE1_SECTION_LEN + RXDC_TABLE1_CORRECTION_LEN)) +
						(mappedBW * RXDC_TABLE1_SECTION_LEN);

	TableOffset_Pgc1Lna = (pgc1index * RXDC_TABLE1_LNA_NUM) + lnaTableIndex;

	TableAddress = RXDC_TABLE1_START_ADDRESS +
					(RXDC_TABLE1_BYTE_WIDTH * (TableOffset_AntBw + TableOffset_Pgc1Lna));
	
	RegAccess_Read(TableAddress, &tableLine);

	//Update return value + sign extension.
	value[RFIC_PATH_TYPE_Q] 	=	(int8)((tableLine >> (RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH << 1)) & RXDC_TABLE1_DAC1_FIELD_MASK);
	SIGN_EXTEND(value[RFIC_PATH_TYPE_Q],RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH);
	
	value[RFIC_PATH_TYPE_I] 	=	(int8)((tableLine >> ((RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH << 1)+RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH)) & RXDC_TABLE1_DAC1_FIELD_MASK);
	SIGN_EXTEND(value[RFIC_PATH_TYPE_I],RXDC_TABLE1_DAC1_FIELD_BIT_WIDTH);
	
	correction[RFIC_PATH_TYPE_Q] 	=	(int8)(tableLine & RXDC_TABLE1_DAC2_FIELD_MASK);
	SIGN_EXTEND(correction[RFIC_PATH_TYPE_Q],RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH);
	
	correction[RFIC_PATH_TYPE_I] 	=	(int8)((tableLine >> RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH) & RXDC_TABLE1_DAC2_FIELD_MASK);
	SIGN_EXTEND(correction[RFIC_PATH_TYPE_I],RXDC_TABLE1_DAC2_FIELD_BIT_WIDTH);		

}

void PhyCalDrv_DCTable1SetAll(int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[TOTAL_ANTENNAS][2], int8 correction[TOTAL_ANTENNAS][2])
{
	int8 i;
	uint8 bw;

	bw = HDK_getChannelWidth();

	for(i=0;i<TOTAL_ANTENNAS;++i)
	{
		PhyCalDrv_DCTable1Set(i, bw, pgc1, lnaIndex, value[i], correction[i]);
	}
}

void PhyCalDrv_DCTable1GetAll(int8 pgc1, HdkLnaIndex_e lnaIndex, int8 value[TOTAL_ANTENNAS][2], int8 correction[TOTAL_ANTENNAS][2])
{
	int8 i;

	for(i=0;i<TOTAL_ANTENNAS;++i)
	{
		PhyCalDrv_DCTable1Get(i, 0, pgc1, lnaIndex, value[i], correction[i]);
	}
}

uint16 PhyCalDrv_GetDigitalGain(uint8 TxAnt , uint8 index)
{
	RegPhyTxRegsTx0Tx1AmpGainF_u val01;

	RegAccess_Read(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, &val01.val);

	return val01.bitFields.filt0OutAmpGainF;
}

#define TSSI_REG_ADDRESS_ANT_0 (0x2031c)
#define TSSI_BYTE_WIDTH			(4)
uint16 PhyCalDrv_GetFeedBackTpc(uint8 Tx_power_index,uint8 ant)
{
	uint32 FeedBack = 0;
	uint32 addr = PHY_RX_TD_BASE_ADDRESS + TSSI_REG_ADDRESS_ANT_0 + (ant * TSSI_BYTE_WIDTH);

	RegAccess_Read(addr, &FeedBack);

	return (uint16)FeedBack;
}

uint16 PhyCalDrv_GetValidTpc()
{
	uint16 Valid = MAX_UINT16;

	return Valid;
}

void PhyCalDrv_ResetValidTpc()
{
}

void PhyCalDrv_SetDigitalLoCancel(uint8 branch,int8 TxAnt,int8 value)
{
	uint32 Mask,reg_value;
	if(TxAnt != ANTENNA_2)
	{
		Mask = 0xFF << (8*(1-branch));
		reg_value = value << (8*(1-branch));
		MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET+4*TxAnt,Mask,reg_value);	
	}
	else
	{
		reg_value = value << (8*(branch));
		Mask = 0xFF<<(8*branch);
		MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET,Mask,reg_value);	
	}
}
void PhyCalDrv_SetDigitalLoCancelPair(int8 TxAnt,int8 valueI,int8 valueQ)
{
	uint32 reg_value;

	if(TxAnt != ANTENNA_2)
	{
		reg_value = ((uint32)valueI << 8) + (valueQ);
		MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET+4*TxAnt,0xFFFF,reg_value);	
	}
	else
	{
		reg_value = ((uint32)valueQ << 8) + (valueI);
		MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET,0xFFFF,reg_value);	
	}
}
void PhyCalDrv_GetDigitalLoCancelPair(int8 TxAnt,int8 *valueI_p, int8 *valueQ_p)
{
	uint32	DcAddition;

	if(TxAnt != ANTENNA_2)
	{
		DcAddition=MT_RdReg(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1EA_TX0_AFE_Q_OFFSET+TxAnt*4); // read the value antenna 0/1

		// I , the result is in bits [15-8] so we need to shift them to the right 
		// Q , the result is in bits [7-0]
		*valueI_p = ((DcAddition) & 0xFF00) >> 8;
		*valueQ_p = DcAddition & 0xFF;
	}
	else
	{
		DcAddition=MT_RdReg(PHY_TD_BASE_ADDR, REG_PHY_TXB_RISC_REG1F3_TX2_AFE_I_OFFSET); // read the value antenna 0/1

		// I , the result is in bits [0] 
		// Q , the result is in bits [15-8] so we need to shift them to the right
		*valueI_p = DcAddition & 0xFF;
		*valueQ_p = ((DcAddition) & 0xFF00) >> 8;
	}
}

void PhyCalDrv_WriteAntFiltOutAmpGainRegMask(uint32 antenna, uint32 mask, uint32 data)
{
	if (antenna == 0)
	{
		MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_TXB_RISC_REG1ED_FILT_0_OUT_AMP_GAIN_F,mask,data);
	} 
	else if (antenna == 1)
	{
		MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_TXB_RISC_REG1EE_FILT_1_OUT_AMP_GAIN_F,mask,data);
	} 
	else if (antenna == 2)
	{
		MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_TXB_RISC_REG1E8_FILT_2_OUT_AMP_GAIN_F,mask,data);
	} 
	else
	{
		DEBUG_ASSERT(0)
	}
}


void PhyCalDrv_GetRssiDataAll(uint8 inRxAntMask, uint32 inNumOfSamples, uint16 *outDataAllAntennas )
{
	uint32 j;
	uint32 antOffset;
	uint32 readresult;

	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) |= 0x10;//enable Gclock to RxIqEstimator
	for(j=0;j<TOTAL_ANTENNAS;j++)
	{
		antOffset = j*0x200;
		// Only enabled antennas are of interest
		if ((0x1<<j) & inRxAntMask)
		{
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263)| 0x2;//Accumulator choose rSSI  rx on FOR ALL ANTENNAS
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG06 + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG06 + antOffset)| 0X01000000 | 0X10000000;//ENABLE DC
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0C + antOffset) = inNumOfSamples;//ENTER NUMBER OF SAMPLES
			
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0XFFFFFFEF;//DISABLING BIT 4 START
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) | 0X100;//ENABLING BIT 8 RESET
			MT_DELAY(1);
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0XFFFFFEFF;//DISABLING BIT 8 RESET // wait 30 clocks
			MT_DELAY(10);
			REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) | 0x10;//enabling bit 4 start
			
		}
	}
	

	for(j=0;j<TOTAL_ANTENNAS;j++)
	{
		antOffset = j*0x200;
		// Only enabled antennas are of interest
		if ((0x1<<j) & inRxAntMask)
		{
			while(!(REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0x1000))//READ BIT 12 UNTIL IS 0
			{
			}
			readresult = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0F + antOffset);
			// Calculate the average
			outDataAllAntennas[j] = readresult/inNumOfSamples;
		}
	}
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) &= 0xffffffef;//disable Gclock to RxIqEstimator
	return;
}

/********************************************************************************
setDigitalGain:

Description:
------------
set the digital gain to registers .

Input:
-----
			1.	index - which of the 16 TxPower gain (0-15)
			2.	TxAnt   - which antenna (Tx0,Tx1,Tx2)
			3.	TpcGain - the required gain	

Output:
-------
			None.

********************************************************************************/
void PhyCalDrv_SetDigitalGain(uint8 TxAnt , uint8 index, uint16 Gain)
{
	RegPhyTxRegsTx0Tx1AmpGainF_u val01;
	RegPhyTxRegsTx2Tx3AmpGainF_u val23;

	RegAccess_Read(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, &val01.val);
	RegAccess_Read(REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F, &val23.val);

	val01.bitFields.filt0OutAmpGainF = Gain;
	val01.bitFields.filt1OutAmpGainF = Gain;
	val23.bitFields.filt2OutAmpGainF = Gain;
	val23.bitFields.filt3OutAmpGainF = Gain;

	RegAccess_Write(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, val01.val);
	RegAccess_Write(REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F, val23.val);
}

/******************************************************************************/
/***						Static Functions Definitions					***/
/******************************************************************************/

/********************************************************************************
SetCalDefaultParametersRx():

Description:
------------

Sets the required PHY parameters for DC calibration:
1. Bypass  IIR & LMS based on required information.
2. Bypass W1W2_IQ calibration
3. BypassFDL
4. Backup W1,W2 for the IQ block.
6. Enable all calibration blocks and required TD blocks(Goertzel & OLA, AFE I/F, Decimator, IQ mismatch)
7. Enable loopback mode.
8. Trigger Rx ( e8=1).
********************************************************************************/
static void SetCalDefaultParametersRx(int8 BypassIIR,int8 BypassEQ,int8 BypassW1W2_IQ, uint32 BypassFDL)
{
	uint8 bw=0;
	uint32 Ant,wreg,offset=0;
	RegPhyRxTdPhyRxtdReg05_u regVal;
	RegPhyRxTdPhyRxtdReg256_u regVal_w1w2;
	RegPhyRxTdPhyRxtdReg25F_u regVal_default_w1w2;
	RegPhyRxTdPhyRxtdReg252_u regVal_fdl;
	RegPhyTxRegsTxFftSharing_u fftRegValue;

	//1.Bypass IIR and LMS:
	
	for(Ant = 0;Ant < MAX_NUM_OF_ANTENNAS; ++Ant)
	{
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG05 + Ant*IQ_BYPASS_ANT_OFFSET, &m_Bypasses[Ant]);//Backup register	
		regVal.val = m_Bypasses[Ant];
		regVal.bitFields.iqMismatchBypassIirAn0	 = BypassIIR;
		regVal.bitFields.iqMismatchBypassEqAn0	 = BypassEQ;
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG05+Ant*IQ_BYPASS_ANT_OFFSET,regVal.val);
	}
	
	//2.Bypass FDL:
	
	RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG252, &m_BypassesFdl);//Backup register
	regVal_fdl.val = m_BypassesFdl; 
	regVal_fdl.bitFields.iqFdlBypass = BypassFDL;
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG252,regVal_fdl.val);
	
	//3.Bypass w1/w2:
	
	RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG256, &m_BypassesW1W2);//Backup register
	regVal_w1w2.val = m_BypassesW1W2;
	regVal_w1w2.bitFields.iqW12Bypass = BypassW1W2_IQ;		
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG256,regVal_w1w2.val);
	
	//4,5.Backup Decorrelator and set defaults:
	
	for(Ant = 0;Ant < MAX_NUM_OF_ANTENNAS; ++Ant)
	{
		for(bw = 0;bw < MAX_NUM_OF_BW; ++bw)
		{
			wreg=REG_PHY_RX_TD_PHY_RXTD_REG257+(bw*RX_IQ_BW_OFFSET);
			offset=(wreg+Ant*4);

			RegAccess_Read(offset,&m_DeCorrValues[bw][Ant].val);
			regVal_default_w1w2.val = m_DeCorrValues[bw][Ant].val;
			regVal_default_w1w2.bitFields.iqW1Cb80An0 = DEFAULT_W1;
			regVal_default_w1w2.bitFields.iqW2Cb80An0 = DEFAULT_W2;
			RegAccess_Write(offset,regVal_default_w1w2.val);
		}
	}

	//	FFT Register Backup

	RegAccess_Read(REG_PHY_TX_REGS_TX_FFT_SHARING,&m_fftRegV);

	/* Override FFT - Force FFT to work in Tx or Rx mode
				   0 - set FFT to Tx, 1- set FFT to Rx */
				   
	fftRegValue.val = m_fftRegV;
	fftRegValue.bitFields.fftShareOverrideControl	= 1;
	fftRegValue.bitFields.fft0ControlRx				= 1;
	fftRegValue.bitFields.fft1ControlRx				= 1;
	fftRegValue.bitFields.fft2ControlRx				= 1;
	fftRegValue.bitFields.fft3ControlRx				= 1;
	
	RegAccess_Write(REG_PHY_TX_REGS_TX_FFT_SHARING,fftRegValue.val);

}
static void SetCalDefaultParametersTx(int8 BypassIIR,int8 BypassEQ,int8 BypassTx_IQ, uint32 BypassDPD, uint8 antenna)
{
	int Bypasses;
	int i=0;
	uint32 fftRegValue;
	
	//1.Bypass IIR and LMS:
	for(i=0;i<TOTAL_ANTENNAS;++i)
	{
		m_Bypasses[i]	=	MT_RdReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0+i*IQ_BYPASS_ANT_OFFSET);
		Bypasses		=	(BypassIIR << REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0_SHIFT )+ (BypassEQ << REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_EQ_AN0_SHIFT);
		MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05_IQ_MISMATCH_BYPASS_IIR_AN0+i*IQ_BYPASS_ANT_OFFSET,	Bypasses);
	}

	//2. Bypass Tx_IQ calibration
	m_BypassesTx =	MT_RdReg(PHY_TX_BASE_ADDR,REG_TX_BE_REG_48_TX_FILTER_FLIP);
	Bypasses = BypassTx_IQ<<1;
	MT_WrReg(PHY_TX_BASE_ADDR,REG_TX_BE_REG_48_TX_FILTER_FLIP, Bypasses);

	//3. BypassDPD
	m_BypassesDpd = MT_RdReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS);
	MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG186_DIFI_DPD0_BYPASS,DIFI_DPD_TOGGLE_ALL_ANT,BypassDPD);
    
    m_TxIndexDigitalGain.DigitalGain = PhyCalDrv_GetDigitalGain(0,0);
	
    PhyCalDrv_SetDigitalGain(0,0,DIGITAL_GAIN_0DB);

    
	//6.Enable all calibration/TD blocks:
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG01_BLOCK_EN, REG_PHY_RXTD_REG01_BLOCK_EN_MASK);
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG00_SW_RESET_N_REG, REG_PHY_RXTD_REG00_SW_RESET_N_REG_MASK);
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_IF90_BLOCK_EN, REG_PHY_RXTD_IF90_BLOCK_EN_MASK);
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_IF8F_SW_RESET_N_REG, REG_PHY_RXTD_IF8F_SW_RESET_N_REG_MASK);

	//7. Enable loopbacks:
	MT_WrReg(PHY_TD_BASE_ADDR,	REG_PHY_RXTD_IF1B_TD_ENABLE_OVERRIDE,1);
	MT_WrRegMask(PHY_FD_BASE_ADDR,	REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE,REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_MASK,REG_PHY_RXFD_REG06_RX_ENABLE_OVERRIDE_MASK);
	//MT_WrRegMask(MT_REMOTE_MIPS_BASE_ADDRESS,0x94,0x1FF0,0x0);

	//8. Trigger Rx:
	MT_WrReg(PHY_TD_BASE_ADDR,	REG_PHY_RXTD_REG3A_ADC_ACTIVE_REG,1);

	//9.Make sure the GenRISC's antenna mask doesn't affect the enabled antennas.
	MT_WrRegMask(PHY_TD_BASE_ADDR,	REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID,REG_PHY_RXTD_IF76_SANITY_RISC_ANTENNA_EN_VALID_MASK,0);

	//	FFT Register Backup

	RegAccess_Read(REG_PHY_TX_REGS_TX_FFT_SHARING,&m_fftRegV);
	
	// Override FFT - Force FFT to work in Tx or Rx mode
	//			   bit 0 - Enable override, bit 4 - Ant0 ,bit 5 - Ant1,bit 6 - Ant2 
	//			   0 - set FFT to Tx, 1- set FFT to Rx
	// configure all antennas for RX except for the TxLoopbackAnt 
	
	fftRegValue = REG_TX_FFT_SHARING_ALL_RX & (~(0x10 << antenna));
	RegAccess_Write(REG_PHY_TX_REGS_TX_FFT_SHARING,fftRegValue);
}

/********************************************************************************
Corr_TriggerMeasurement:

Description:
------------

Triggers an IQ measurement on all the antennas in the AntMask.
1) Reset the block.
2) Start.
3) Poll for end.
Input:
-----
	AntMask : Antennas to trigger.
	Delay  : Delay before triggering meaqsurements. One delay before triggering before all antennas.
Output:
-------
	Status : results were ready and no timeout has occured.
********************************************************************************/
void Corr_TriggerMeasurement(int8 AntMask,int8 Delay_us)
{
	RegPhyRxTdPhyRxtdReg0D_u Ctrl;
	int i;
	
	//Wait 10us/20us/30us for the IIR to settle, according to RFIC BW 
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) |= 0x10;//enable Gclock to RxIqEstimator
	MT_DELAY(Delay_us);
	
	for(i=0;i<MAX_NUM_OF_ANTENNAS;++i)
	{
		if( (1<<i) & AntMask)
		{
			uint32 offset = REG_PHY_RX_TD_PHY_RXTD_REG0D+i*iq_AN1_OFFSET;
			Ctrl.val = 0;
			//Reset Reg
			Ctrl.bitFields.iqMismatchEstStartWorkAn0	=	0;
			Ctrl.bitFields.iqMismatchEstResetRegsAn0	=	1;
			RegAccess_Write(offset,Ctrl.val);

			//Set Reg, Start work
			Ctrl.bitFields.iqMismatchEstResetRegsAn0	=	0;
			Ctrl.bitFields.iqMismatchEstStartWorkAn0	=	1;
			RegAccess_Write(offset,Ctrl.val);
		}
	}
	
	//Poll for end:
	for(i=0;i<MAX_NUM_OF_ANTENNAS;++i)
	{
		if( (1<<i) & AntMask)
		{
        	uint32 startTime=0,endTime=0;
        	startTime = TIME_STAMP(0,startTime);
			Ctrl.val= 0;
        	//poll on counter
			while(Ctrl.bitFields.iqMismatchEstValidIqAn0==0)
        	{
				RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG0D+i*iq_AN1_OFFSET,&Ctrl.val);
   				endTime = TIME_STAMP(1,startTime);
				ASSERT(endTime <= PHY_VALID_DELAY)
        	}
			
 			//Stop:
 			Ctrl.bitFields.iqMismatchEstStartWorkAn0	=	0;
			RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG0D+i*iq_AN1_OFFSET,Ctrl.val);
		}
	}
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) &= 0xffffffef;//disable Gclock to RxIqEstimator
}
/********************************************************************************
Corr_ReadResults:

Description:
------------

Reads the result for a specific antenna in to a result structure.
Input:
-----
	Ant:	reuired results
Output:
-------
	Results: pointer to storage structure.
********************************************************************************/
static void	Corr_ReadResults(uint8 Ant,CorrRes_t *Results ,bool isIqSwapped)
{
	uint32 offset = Ant*iq_AN1_OFFSET;

	if(isIqSwapped ==TRUE)
	{
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG0F+offset,(uint32*)&Results->QQ);
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG11+offset,(uint32*)&Results->II);
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG13+offset,(uint32*)&Results->IQ);
	}
	else
	{
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG0F+offset,(uint32*)&Results->II);
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG11+offset,(uint32*)&Results->QQ);
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG13+offset,(uint32*)&Results->IQ);
	}
}

/********************************************************************************
GetCosValue:

Description:
------------

Calculates 2*pi*k/N in 12 bits using look up table.
Input:
-----
	BinIndex:	reuired results
	IsCb : use CB or nCB mode.
Output:
-------
	Results: cos value
********************************************************************************/
static int16	GetCosValue(int16 BinIndex, uint8 bw)
{
	int16 N;
	int16 k; 
	int16 Sign = 1;
	int16 Result = 0;

	switch (bw)
	{
		case BANDWIDTH_TWENTY:
			N = FFT_LEN_20_80;
			break;
		case BANDWIDTH_FOURTY:
			N = FFT_LEN_40_80;
			break;
		case BANDWIDTH_EIGHTY:
			N = FFT_LEN_80;
			break;
		default:
			break;
	}

	while( BinIndex <0 )
		BinIndex+=N;
	while( BinIndex >=N )
		BinIndex-=N;
	
	if(BinIndex <= (N/4))
	{
		k=BinIndex;
	}
	else if(BinIndex <= (N/2))
	{
		k=N/2-BinIndex;
		Sign=-1;
	}
	else if(BinIndex <= (3*(N/4)))
	{
		k=BinIndex-(N/2);
		Sign=-1;
	}
	else
	{
		k=N-BinIndex;
	}
	
	switch (bw)
	{
		case BANDWIDTH_TWENTY:
			Result=CosValues[k * (FFT_LEN_80 / FFT_LEN_20_80)];
			break;
		case BANDWIDTH_FOURTY:
			Result=CosValues[k * (FFT_LEN_80 / FFT_LEN_40_80)];
			break;
		case BANDWIDTH_EIGHTY:
			Result=CosValues[k];
			break;
		default:
			break;
	}
	
	return Result*Sign;
}

/********************************************************************************
GetsinValue:

Description:
------------

Calculates 2*pi*k/N in 12 bits using the cos function.
Input:
-----
	BinIndex:	reuired results
	IsCb : use CB or nCB mode.
Output:
-------
	Results: sin value
********************************************************************************/
static int16	GetSinValue(int16 BinIndex,int8 IsCB)
{
	int16 N = FFT_LEN_80;

	return  GetCosValue((int16)(BinIndex-(N >> 2)),IsCB);
}

/********************************************************************************
PhyCalDrv_SetDifiBypass:

Description:
------------

Sets and resets the Difi bypass in the PHY, according to input
Input:
-----
	state	 : PHY_CAL_DRV_DIFI_BP_OFF or PHY_CAL_DRV_DIFI_BP_ON
Output:
-------
None.
********************************************************************************/
void PhyCalDrv_SetDifiBypass(PhyCalDrv_DifiBypassState_e state)
{
	MT_WrRegMask(PHY_TD_BASE_ADDR,	REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS,REG_PHY_RXTD_IF13_DIFI_F3TO1_TX_BYPASS_MASK,state);
}

/********************************************************************************
RxIQ_adaptiveGain:

Description:
------------
Dummy function for WRX500
Input:
-----

Output:
-------

********************************************************************************/
void RxIQ_adaptiveGain(CorrRes_t Results[MAX_NUM_OF_ANTENNAS], RxIQRF_elements_t* inElements_p, uint8 inRxAntMask, int8 Delay_us)
{
#ifdef RFIC_WRX300
    int32 Pwr;//,DBGPwr,DBGtest;
    uint8 antNum;
    int32 numerator,denominator; 

	PhyCalDrv_CorrInit(CORR_MODE,inRxAntMask,ADAPTIVE_GAIN_SAMPLES,RX_IQ_ROUND,inElements_p->params.iir_mu);
	PhyCalDrv_setAccumTo80Mh();//only to wave500

    PhyCalDrv_CorrMeasureAll(Results,Delay_us,PHY_CAL_DRV_IGNORE_IQ_SWAP);

    for (antNum=0;antNum<MAX_NUM_OF_ANTENNAS;antNum++)
    {  
        if(1<<antNum & inRxAntMask)
        {
            if(Results[antNum].II<0)
                return;
            
            numerator = MATH_10Log10Res((uint32)Results[antNum].II,ADAPTIVE_GAIN_LOG_RESOLUTION);
            denominator = THREE_DB_FACTOR*DERESOLUTION_NUM_BITS*(1<<ADAPTIVE_GAIN_LOG_RESOLUTION)+ MATH_10Log10Res(ADAPTIVE_GAIN_DENOMINATOR_VALUE,ADAPTIVE_GAIN_LOG_RESOLUTION);//12=3dB*4
            Pwr = (numerator-denominator);
            //DBGPwr = Pwr;
            Pwr = ((Pwr +ADAPTIVE_GAIN_LOG_ROUND)>>ADAPTIVE_GAIN_LOG_RESOLUTION)+ ADAPTIVE_GAIN_OFFSET-Difi_GAIN;// Factor of -3db needed to compensate wave504 DiFi gain of 3dB
            Pwr = -(Pwr+10);//Additional 3dB backoff due to wave504 ADC clipping problem
            //DBGtest = Pwr;
            Pwr = PWR_TO_GAIN_INDEX(Pwr);
            
            SetRxGains((AntennaBitmaps_e)(1<<antNum),inElements_p->params.lnaIndex,adaptive_gainTable[Pwr][PGC1],adaptive_gainTable[Pwr][PGC2],adaptive_gainTable[Pwr][PGC3]);
        }
    }  
    

    PhyCalDrv_CorrInit(CORR_MODE,inRxAntMask,inElements_p->params.numSamples,inElements_p->params.round,inElements_p->params.iir_mu);   
#endif
}

#define LOG_ACCURACY_BIT (5)

void Measure_AdcPower(CorrRes_t Results[MAX_NUM_OF_ANTENNAS], uint8 inRxAntMask, uint32 numSamples)
{
    //int32 Pwr;//,DBGPwr,DBGtest;
    uint8 antNum;
    int32 numerator[2];
	int32 denominator; 
	uint32 accumShift = 6; 
	uint32 adaptiveGainDenominatorValue = 
		((numSamples>>DERESOLUTION_NUM_BITS)*ADAPTIVE_GAIN_SAMPLE_POWER*(1<<((2*(ADC_RES-1))- accumShift)));

	//ASSERT(0);
	PhyDrv_preCal();
	PhyDrv_ResetBB();
	PhyDrv_preCal();
	
	PhyCalDrv_CorrInit(CORR_MODE, inRxAntMask, numSamples, accumShift, RX_IQ_IIR_MU);
	PhyCalDrv_setAccumTo80Mh();
    PhyCalDrv_CorrMeasureAll(Results, DELAY_AFTER_PHY_RFIC_CHANGE, PHY_CAL_DRV_IGNORE_IQ_SWAP);

    for (antNum = 0; antNum < MAX_NUM_OF_ANTENNAS; antNum++)
    {  
        if((1 << antNum) & inRxAntMask)
        {
            numerator[0] = MATH_10Log10Res((uint32)Results[antNum].II,LOG_ACCURACY_BIT);
			numerator[1] = MATH_10Log10Res((uint32)Results[antNum].QQ,LOG_ACCURACY_BIT);
            denominator = THREE_DB_FACTOR*DERESOLUTION_NUM_BITS*(1<<LOG_ACCURACY_BIT)+ MATH_10Log10Res(adaptiveGainDenominatorValue,LOG_ACCURACY_BIT);//12=3dB*4
            Results[antNum].II = (numerator[0]-denominator);
            Results[antNum].II = Results[antNum].II + ((DBW_TO_DBM_FACTOR-Difi_GAIN)<<LOG_ACCURACY_BIT);// Factor of -3db needed to compensate wave504 DiFi gain of 3dB
            
            Results[antNum].QQ = (numerator[1]-denominator);
			Results[antNum].QQ = Results[antNum].QQ + ((DBW_TO_DBM_FACTOR-Difi_GAIN)<<LOG_ACCURACY_BIT);// Factor of -3db needed to compensate wave504 DiFi gain of 3dB
        }
    }  

	PhyDrv_postCal();
	//PhyDrv_ReActivateBB();
}


void PhyCalDev_SetToneGenAmplitude(int8 Amplitude)
{
	uint32	power;

	power = Amplitude | (Amplitude << 4);
	
	RegAccess_Write(REG_PHY_TX_REGS_TX0_FE_REG_07, power);
	RegAccess_Write(REG_PHY_TX_REGS_TX1_FE_REG_07, power);
	RegAccess_Write(REG_PHY_TX_REGS_TX2_FE_REG_07, power);
	RegAccess_Write(REG_PHY_TX_REGS_TX3_FE_REG_07, power);
	
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX0_FE_REG_14F, TONEGEN_AMP_MASK, Amplitude);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX1_FE_REG_14F, TONEGEN_AMP_MASK, Amplitude);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX2_FE_REG_14F, TONEGEN_AMP_MASK, Amplitude);
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX3_FE_REG_14F, TONEGEN_AMP_MASK, Amplitude);
}

int8 PhyCalDrv_GetToneGenAmplitude(void)
{
	uint32 amplitude;

	// Get ToneGen amplitude for  ant0 in 80MHz	
	
	RegAccess_Read(REG_PHY_TX_REGS_TX0_FE_REG_07, &amplitude);
		
	return (amplitude & 0xF);
}

void PhyCalDrv_Set_IQTD_Matrix(TxIq_elements_t* outElements_p, uint8 spectrum, uint8 ant)
{
	RegPhyTxRegsTx0FeReg151_u iqTd0F1F2_20_Reg;
	RegPhyTxRegsTx0FeReg152_u iqTd0F3F4_20_Reg;
	RegPhyTxRegsTx0FeReg153_u iqTd0F1F2_40_Reg;
	RegPhyTxRegsTx0FeReg154_u iqTd0F3F4_40_Reg;
	
	iqTd0F1F2_20_Reg.val = 0;
	iqTd0F3F4_20_Reg.val = 0;
	iqTd0F1F2_40_Reg.val = 0;
	iqTd0F3F4_40_Reg.val = 0;

	iqTd0F1F2_20_Reg.bitFields.tx0IqTdF120 = outElements_p->results.SSB_F_20M[ant][0][0];
	iqTd0F1F2_20_Reg.bitFields.tx0IqTdF220 = outElements_p->results.SSB_F_20M[ant][0][1];
	iqTd0F3F4_20_Reg.bitFields.tx0IqTdF320 = outElements_p->results.SSB_F_20M[ant][1][0];
	iqTd0F3F4_20_Reg.bitFields.tx0IqTdF420 = outElements_p->results.SSB_F_20M[ant][1][1];

	RegAccess_Write(REG_PHY_TX_REGS_TX0_FE_REG_151 + (ant << 9), iqTd0F1F2_20_Reg.val);
	RegAccess_Write(REG_PHY_TX_REGS_TX0_FE_REG_152 + (ant << 9), iqTd0F3F4_20_Reg.val);

	if (spectrum == BANDWIDTH_EIGHTY)
	{
		iqTd0F1F2_40_Reg.bitFields.tx0IqTdF140 = outElements_p->results.SSB_F_40M[ant][0][0];
		iqTd0F1F2_40_Reg.bitFields.tx0IqTdF240 = outElements_p->results.SSB_F_40M[ant][0][1];
		iqTd0F3F4_40_Reg.bitFields.tx0IqTdF340 = outElements_p->results.SSB_F_40M[ant][1][0];
		iqTd0F3F4_40_Reg.bitFields.tx0IqTdF440 = outElements_p->results.SSB_F_40M[ant][1][1];

		RegAccess_Write(REG_PHY_TX_REGS_TX0_FE_REG_153 + (ant << 9), iqTd0F1F2_40_Reg.val);
		RegAccess_Write(REG_PHY_TX_REGS_TX0_FE_REG_154 + (ant << 9), iqTd0F3F4_40_Reg.val);
	}
}

void PhyCalDrv_Write_Register_Clipping(uint32 value)
{
	REGISTER(Clipping_trigger) = value;
}
/********************************************************************************

Method:	FdlWriteValueToFdlAdressSpace

Description: write fdl value per antena to memory
------------
********************************************************************************/
void FdlWriteValueToFdlAdressSpace(uint32 rxAntenna,uint32 FdlAddress,int8 fdlDelay)
 {
	uint32	newFdlValue = 0;
	uint32	signExtension = 0;
	uint32	antOffset = (10 * (rxAntenna & 1)); //Antenna bits offset (either 0 or 10 bits)
	uint32	mask10Bits = 0x3ff; // Each antenna uses 10 bits

	FdlAddress += 4 * (rxAntenna / 2); // Increment address (by DWORD) for every pair of antennas

	if(fdlDelay & SIGN_BIT)/*msb 1*/
	{
		signExtension = EXTENDED_SIGN_TO_10BIT;/*extending sign to 10 bit*/
	}
	
	newFdlValue = (REGISTER(FdlAddress) & ~(mask10Bits << antOffset)) | 		// Clear the relevant antenna bits
					(((signExtension | fdlDelay) & mask10Bits) << antOffset); // Set new antenna bits in correct offset


	REGISTER(FdlAddress) = newFdlValue;	// Write new register value
					
 }

//#endif /* #if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)*/



