/*******************************************************************************
*    
*   Source File:
*       PhyCalDriver.c
*	
*	AUTHOR: 
* 
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <lmi.h>
#include "mt_cnfg.h"	
#include "RegAccess_Api.h"
#include "PhyCalDriver_API.h"
#include "PhyRegsIncluder.h"
#include <mt_sysrst.h>
#include "PhyDriver_API.h"
#include "TpcClbrHndlr.h"
#include "HdkGlobalDefs.h"
#include "ErrorHandler_Api.h"
#include "RegAccess_Api.h"
#include "PhyRxTdRegs.h"
#ifdef ENET_INC_ARCH_WAVE600D2	
#include "PhyRxtdAnt0Regs.h"
#include "PhyRxtdAnt1Regs.h"
#include "PhyRxtdAnt2Regs.h"
#include "PhyRxtdAnt3Regs.h"
#else
#include "PhyRxTdAnt0Regs.h"
#include "PhyRxTdAnt1Regs.h"
#include "PhyRxTdAnt2Regs.h"
#include "PhyRxTdAnt3Regs.h"
#endif
#include "PhyTxRegs.h"
#include "PhyTxMacEmuRegs.h"
#include "PhyRxTdIfRegs.h"
#include "SharedDbTypes.h"
#include "LmHdk_API.h"
#include "HwMemoryMap.h"
#include "lib_wrx654_api.h"
#include "loggerAPI.h"
#include "Afe_API.h"
#include "MT_Math.h"
#include "mt_sysdefs.h"
#include "RficDriver_API.h"
#include "fast_mem_psd2mips.h"
#include "stringLibApi.h"
#include "ConfigurationManager_api.h"
#include "HDK_utils.h"
#include "lib_wav600_api.h"
#include "RxDcOffsetClbrHndlr.h"
#include "PhyAgcAnt0Regs.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 9

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/	

/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/ 
typedef struct RegBackup 
{
	uint32	Unit	;
	uint32	Address	;
	uint32	Value	;
}RegBackup_T;

/******************************************************************************/
/***					Static Function Declaration							***/
/******************************************************************************/
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void SetCalDefaultParametersTx(int8 BypassIIR,int8 BypassEQ,int8 BypassTx_IQ, uint32 BypassDPD, uint8 antenna);
static void SetCalDefaultParametersRx(int8 BypassIIR,int8 BypassEQ,int8 BypassW1W2_IQ, uint32 BypassFDL);
static void	Corr_ReadResults(uint8 Ant,CorrRes_t *Results,bool isIqSwapped);
static void	Corr_TriggerMeasurement(int8 AntMask,int8 Delay);
static int16	GetCosValue(int16 BinIndex, uint8 bw);
static int16	GetSinValue(int16 BinIndex,int8 IsCB);
#endif

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#define SIGN_EXTEND(value, Bits)	if(value  >= (1<< (Bits-1) ) ) value-=(1<<Bits)

void PhyCalDrv_SetLoopBackMode(ClbrProcType_e procType,short Antenna)
{
	UNUSED_PARAM(procType);	
	UNUSED_PARAM(Antenna);	
	//CALTBD
}
void PhyCalDrv_bypassForRssiCalibration(void)
{	
	PhyDrv_preCal();
	PhyDrv_ResetBB();
	PhyDrv_preCal();
	
}

void PhyCalDrv_RestoreOperationalTx()
{
	//CALTBD
}
void PhyCalDrv_RestoreOperationalRx()
{
	PhyDrv_postCal();
	PhyDrv_ReActivateBB();
}

void PhyCalDrv_ToneGenClearAndDisable(uint8 antMask)
{
#ifdef WRX600_BU_LOGS
	ILOG0_V("PhyCalDrv_ToneGenClearAndDisable");
#endif
	bbic_clear_and_disable_tone_gen(antMask);
}

void PhyCalDrv_SetToneGenScale(uint8 antMask, int8 scale)
{
	bbic_set_tx_scale(antMask, scale);
}

uint32 PhyCalDrv_GetToneGenScale(void)
{
	return bbic_get_tx_scale();
}

void PhyCalDrv_RunMultiToneGen(int16* tones, int8 numOfTones, int8 scale, int16 digGain[MAX_NUM_OF_ANTENNAS], uint8 AntMsk)
{
	bool timeout;
#ifdef WRX600_BU_LOGS
	ILOG0_DDDD("PhyCalDrv_RunToneGen. antMask 0x%x scale %d numOfTones %d digGain[0] %d", AntMsk, scale, numOfTones, digGain[0]);
#endif
	timeout = bbic_generate_multi_tone_gen(tones, numOfTones, scale, digGain, AntMsk);
	DEBUG_ASSERT(!timeout);//maybe dont have enogh time to be stabilized
}

void PhyCalDrv_RunToneGen(uint8 antMask, int16 bin, int8 scale, int16* digGain)
{
	bool timeout;
#ifdef WRX600_BU_LOGS
	ILOG0_DDDD("PhyCalDrv_RunToneGen. antMask 0x%x scale %d bin %d digGain[0] %d", antMask, scale, bin, digGain[0]);
#endif
	timeout = bbic_generate_tone_gen(bin, scale, digGain, antMask);
	DEBUG_ASSERT(!timeout);
}
void PhyCalDrv_txFFTInScale(int8 AntMsk, uint8 ScaleFactor)
{
	bbic_tx_fft_in_scale( AntMsk, ScaleFactor);
}

void PhyCalDrv_EnableGclkBypass(bool enable)
{
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_EnableGclkBypass enable %d", enable);
#endif
	bbic_enable_clk_bypass(enable);
}

void PhyCalDrv_SetTxIQCoefficientsAllBins(uint8 antMask,int16* a, int16* b,int16 binStartIndex,int16 binEndIndex )
{
	int bin;
	ILOG0_DDDD("PhyCalDrv_SetTxIQCoefficientsAllBins. binStartIndex %d binEndIndex %d a[0] %d b[0] %d", binStartIndex, binEndIndex, a[0], b[0]);
	for (bin = binStartIndex;bin<binEndIndex;bin++)
	{
		bbic_set_tx_iq_coefficients(antMask, bin, a, b);
	}
}

void PhyCalDrv_SetTxIQCoefficientsAllBinsFullCal(uint8 antMask,int16* a, int16* b,int16 binStartIndex,int16 binEndIndex )
{
	PhyCalDrv_SetTxIQCoefficientsAllBins(antMask, a, b,binStartIndex,binEndIndex);
	
	PhyCalDrv_SetTxToneGen();
}


void PhyCalDrv_SetTxIQCoefficients(uint8 antMask, int16 bin, int16* a, int16* b )
{
	uint8 ant;
	int16 aTemp[MAX_NUM_OF_ANTENNAS];
	int16 bTemp[MAX_NUM_OF_ANTENNAS];
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			aTemp[ant] = a[ant];
			bTemp[ant] = b[ant];
		}
	}
	bbic_set_tx_iq_coefficients(antMask, bin, aTemp, bTemp);
	PhyCalDrv_SetTxToneGen();
}

void PhyCalDrv_SetTxToneGen(void)
{
	bbic_set_tx_reset();
	bbic_release_tx_reset();
	bbic_enable_tone_gen(TRUE);
	bbic_start_tone_gen();
	
	ASSERT(bbic_wait_tone_gen(100) == 0);
	MT_DELAY(10);
}


void PhyCalDrv_GetTxIQCoefficients(uint8 antMask, int16 bin, int16* a, int16* b )
{
	bbic_get_tx_iq_coefficients(antMask, bin, a, b);
}
void PhyCalDrv_ClearTxIQCoefficients(uint8 antMask)
{
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_ClearTxIQCoefficients. antMask 0x%x",antMask);
#endif
	bbic_clear_all_tx_iq_coefficients(antMask);
}

void PhyCalDrv_GoertzelConfig(uint8 antMask, uint32* length, uint8* numOfCycles, int16* tone0, int16* tone1)
{
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_GoertzelConfig. antMask 0x%x",antMask);
#endif
	bbic_set_goert_params(antMask, length, numOfCycles, tone0, tone1);
}

void PhyCalDrv_GoertzelSetLengthAndCycles(uint8 antMask, uint32* length, uint8* numOfCycles)
{
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_GoertzelSetLengthAndCycles. antMask 0x%x",antMask);
#endif
	bbic_set_goert_length(antMask, length);
	bbic_set_goert_cycles(antMask, numOfCycles);
}

void PhyCalDrv_GoertzelSetTone(uint8 antMask, int16 tone)
{
	uint8 ant;
	int16 toneArr[ANT_NUM];
	
#ifdef WRX600_BU_LOGS
	ILOG0_DD("PhyCalDrv_GoertzelSetTone. antMask 0x%x tone %d",antMask, tone);
#endif

	for (ant = 0; ant < ANT_NUM; ant++)
	{
		toneArr[ant] = tone;
	}
	bbic_set_goert_tone(antMask,toneArr);
}

void PhyCalDrv_GoertzelMeasureEnergy(uint8 antMask, uint32* energy, uint8 energyShift, uint16 timeout)
{
	GoertzelRes_t goertzelResult[MAX_NUM_OF_ANTENNAS];	
	uint8 ant;
	
#ifdef WRX600_BU_LOGS
	ILOG0_V("measureEnergy");
#endif

	// Measure Goertzel
	PhyCalDrv_GoertzelMeasure(antMask, timeout, goertzelResult);
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{		
		if (antMask & (1 << ant))
		{
			energy[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im)) >> energyShift;
#ifdef WRX600_BU_LOGS
			ILOG0_DDD("energy[%d] = %d. shifted by %d",ant,energy[ant], energyShift);
#endif
		}
	}
}

void PhyCalDrv_GoertzelMeasure(uint8 antMask, uint16 timeout, GoertzelRes_t *Results)
{
	GoertzelResults_t GoertResult[ANT_NUM] = {0};
	uint8 ant;
	uint8 validMask;
	
	validMask = bbic_read_goert(antMask, timeout, GoertResult);
#ifdef WRX600_BU_LOGS
			ILOG0_DD("PhyCalDrv_GoertzelMeasure. antMask 0x%x, valid:0x%x",antMask,validMask);
#endif
	DEBUG_ASSERT(validMask == antMask);
	
	for (ant = 0; ant < ANT_NUM; ant++)
	{
		MEMCPY(&Results[ant], &GoertResult[ant], sizeof(GoertzelRes_t));
#ifdef WRX600_BU_LOGS
		SLOG0(0, 0, GoertzelRes_t, &Results[ant]);
#endif
	}
}
	
void PhyCalDrv_CorrInit(uint8 antMask, uint32* nos, uint8* dcMode, uint8* rssiMode, uint8* rate, uint8* shift)
{
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_CorrInit. antMask 0x%x",antMask);

#endif
	bbic_set_accum_params(antMask, nos, dcMode, rssiMode, rate, shift);
}
void PhyCalDrv_SetCorrNos(uint8 antMask, uint32 nos)
{
	uint8 ant;
	uint32 nosArr[ANT_NUM];
	
#ifdef WRX600_BU_LOGS
	ILOG0_DD("PhyCalDrv_CorrNosInit. antMask 0x%x nos %d",antMask, nos);
#endif

	for (ant = 0; ant < ANT_NUM; ant++)
	{
		nosArr[ant] = nos;
	}
	bbic_set_accum_nos(antMask, nosArr);
}

void PhyCalDrv_CorrMeasureRxIq(uint8 antMask, uint16 timeout, CorrResRxIq_t *ResultsRxiq, CorrOverflow_t* corrOf)
{
	CorrRes_t Results[ANT_NUM];

	PhyCalDrv_CorrMeasure( antMask, timeout, Results, corrOf);
	uint8 ant;

	for (ant = 0; ant < ANT_NUM; ant++)
	{
		MEMCPY(&ResultsRxiq[ant], &Results[ant], sizeof(CorrRes_t));		
	}
	
}

void PhyCalDrv_CorrMeasure(uint8 antMask, uint16 timeout, CorrRes_t *Results, CorrOverflow_t* corrOf)
{
	CorrResults_t corrResult[ANT_NUM] = {0};
	CorrOF_t pAccumOF[ANT_NUM] = {0};
	uint8 ant;
	uint8 validMask;
	
	validMask = bbic_read_accum(antMask, timeout, corrResult, pAccumOF);

#ifdef WRX600_BU_LOGS
	ILOG0_DD("PhyCalDrv_CorrMeasure. antMask 0x%x, validMask = %d",antMask, validMask);
	ILOG0_DD("IF validMask!= AntMask should ASSERT. for debug the assert removed. antMask 0x%x, validMask = %d",antMask, validMask);

#endif
		
	DEBUG_ASSERT(validMask == antMask);
	for (ant = 0; ant < ANT_NUM; ant++)
	{
		MEMCPY(&Results[ant], &corrResult[ant], sizeof(CorrRes_t));		
		MEMCPY(&corrOf[ant], &pAccumOF[ant], sizeof(CorrOverflow_t));
#ifdef WRX600_BU_LOGS
		
		ILOG0_DDDD("IIResults[0].II=%d, Results[1].II=%d, Results[2].II=%d,Results[3].II%d",Results[0].II, Results[1].II, Results[2].II,Results[3].II);
		
		ILOG0_DDDD("QQResults[0].Q=%d, Results[1].=%d, Results[2].=%d,Results[3].I%d",Results[0].QQ, Results[1].QQ, Results[2].QQ,Results[3].QQ);
		
		ILOG0_DDDD("IQResults[0].IQ=%d, Results[1]=%d, Results[2].=%d,Results[3].%d",Results[0].IQ, Results[1].IQ, Results[2].IQ,Results[3].IQ);

		SLOG0(0, 0, CorrRes_t, &Results[ant]);
		SLOG0(0, 0, CorrOverflow_t, &corrOf[ant]);
#endif
	}
}

void PhyCalDrv_setDecorrelatorMode(uint8 antMask, bool enable)
{
	bbic_enable_decorr(antMask, enable);
}
void PhyCalDrv_setIIRMode(uint8 antMask, bool enable)
{
	bbic_enable_iir(antMask, enable);
}
void PhyCalDrv_setIIRShift(uint8 antMask, uint8 shift)
{
	uint8 iirShift[MAX_NUM_OF_ANTENNAS] = {shift, shift, shift, shift};
	
	bbic_set_iir_shift(antMask, iirShift);
}
void PhyCalDrv_resetRxtd(bool enable)
{
	bbic_reset_rxtd(enable);
}
void PhyCalDrv_resetChannelFilter(void)
{
	void bbic_reset_channel_filter(void);
}

void PhyCalDrv_enableRxtdFifo(bool enable)
{
	bbic_enable_rxtd_fifo(enable);
}

void PhyCalDrv_enableDetector(bool enable)
{
	bbic_enable_detector(enable);
}
void PhyCalDrv_enableCalMode(bool enable)
{
	bbic_enable_cal_mode(enable);
}

void PhyCalDrv_setFirCoeffsToProgmodel(uint8 AntMsk, uint32 pCoeffs[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS])
{
	bbic_set_fir_coeffs_to_progmodel( AntMsk,  pCoeffs);
}

void PhyCalDrv_LmsReset()
{
	bbic_lms_reset();
}
void PhyCalDrv_getLmsErrorIndicator(uint8 AntMsk, uint32 pErrorInd_rtrn[MAX_NUM_OF_ANTENNAS], uint8 pErrorValid_rtrn[MAX_NUM_OF_ANTENNAS])
{
	bbic_get_lms_error_indicator( AntMsk, pErrorInd_rtrn, pErrorValid_rtrn);
}
void PhyCalDrv_writeRamFirCoeffs(uint8 AntMsk, uint32 pCoeffs[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS], uint8 iBW, uint8 PgcSetting)
{
	bbic_write_ram_fir_coeffs( AntMsk, pCoeffs, iBW, PgcSetting);
}
void PhyCalDrv_readRamFirCoeffs(uint8 AntMsk, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS], uint8 iBW, uint8 PgcSetting)
{
	bbic_read_ram_fir_coeffs( AntMsk, pCoeffs_rtrn, iBW, PgcSetting);
}
void PhyCalDrv_EnableTpcAccelerator(uint8 AntMsk, bool IsEnabled)
{
	bbic_enable_tpc_accelerator( AntMsk, IsEnabled);
}

void PhyCalDrv_SetPgc2Gain(uint8 AntMsk, int8 tpcgainidx)
{
	bbic_set_tx_pgc2_gain_select( AntMsk, tpcgainidx);
}

void PhyCalDrv_setLmsParams (uint8 AntMsk, bool CalMode , uint32 NumOfSteps, uint8 Mu, uint8 Alpha)
{
	bbic_set_lms_params ( AntMsk,  CalMode, NumOfSteps, Mu, Alpha);
}
void PhyCalDrv_setLmsCalMode (uint8 AntMsk, bool NlmsCalMode)
{
	bbic_set_lms_cal_mode (AntMsk, NlmsCalMode);
}

void PhyCalDrv_startLmsCycle (uint8 AntMsk)
{
	bbic_start_lms_cycle (AntMsk);
}

void PhyCalDrv_enableADC(bool enable)
{
	bbic_adc_onoff(enable);
}

void PhyCalDrv_getFirCoeffs(uint8 AntMsk, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS])
{
	bbic_get_fir_coeffs( AntMsk,  pCoeffs_rtrn);
}
void PhyCalDrv_setIqDelays(uint8 AntMsk, uint8 EqLength_q, uint8 IqFirDelay )
{
	bbic_set_iq_delays( AntMsk, EqLength_q, IqFirDelay);
}

void PhyCalDrv_setFirMode(uint8 antMask, bool enable)
{
	bbic_enable_fir(antMask, enable);
}


void PhyCalDrv_setFdlMode(uint8 antMask, bool enable)
{
	bbic_enable_fdl(antMask, enable);
}
void PhyCalDrv_setXtalkMode(uint8 antMask, bool enable)
{
	bbic_enable_xtalk(antMask, enable);
}

void PhyCalDrv_setValidCoeffs(uint8 antMask, uint32 NumOfEnabledCoeffs)
{
	bbic_set_valid_coeffs(antMask, NumOfEnabledCoeffs);
}

void PhyCalDrv_setBypassRamCoeffs (uint8 AntMsk, bool enable)
{
	bbic_set_bypass_ram_coeffs (AntMsk, enable);
}

void PhyCalDrv_enableToneGen (bool isEnabled)
{
	bbic_enable_tone_gen (isEnabled);
}

void PhyCalDrv_writeRamXtalk(uint8 AntMsk, uint8 BwIdx, int8 CoeffArrayKa[RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS], int8 CoeffArrayKb[RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS])
{
	bbic_write_ram_xtalk(AntMsk, BwIdx, CoeffArrayKa, CoeffArrayKb);
}

void PhyCalDrv_setXTalkCoeffs(uint8 AntMsk, uint8 Ka[MAX_NUM_OF_ANTENNAS], uint8 Kb[MAX_NUM_OF_ANTENNAS])
{
	bbic_set_xtalk_coeffs(AntMsk, Ka, Kb);
}

void PhyCalDrv_setAdc(bool enable)
{
	bbic_adc_onoff(enable);
}

void PhyCalDrv_resetDifiGain(uint8 antmask)
{
	uint8 difigain[MAX_NUM_OF_ANTENNAS] = {0, 0, 0, 0};

	bbic_set_difi2_gain(antmask, difigain);
}

void PhyCalDrv_enableDifiGain(uint8 antmask,bool enable)
{
	bbic_enable_difi2_gain_agc(antmask, enable);
}

void PhyCalDrv_RxIQSetWCoeffs(uint8 antMask, uint8 bw, uint16* w1, int16* w2)
{
	bbic_set_decorr_coeffs(antMask, w1, w2, bw);
}
void PhyCalDrv_RxIQGetWCoeffs(uint8 antMask, uint8 bw, uint16* w1, int16* w2)
{
	bbic_get_decorr_coeffs(antMask, w1, w2, bw);
}

void PhyCalDrv_RSSITableSet(uint8 Ant, uint8 Pos,int8 Value)
{
	UNUSED_PARAM(Ant);	
	UNUSED_PARAM(Pos);	
	UNUSED_PARAM(Value);	
	//CALTBD
}

uint8 PhyCalDrv_RSSITableGet(uint8 Ant, uint8 Pos)
{
	UNUSED_PARAM(Ant);
	UNUSED_PARAM(Pos);	
	//CALTBD
	return 0;
}

uint16 PhyCalDrv_GetDigitalGain(uint8 TxAnt , uint8 index)
{
	UNUSED_PARAM(TxAnt);	
	UNUSED_PARAM(index);	

	//CALTBD
	return 0;
}

#define TSSI_REG_ADDRESS_ANT_0 (0x2031c)
#define TSSI_BYTE_WIDTH			(4)
uint16 PhyCalDrv_GetFeedBackTpc(uint8 Tx_power_index,uint8 ant)
{
	uint32 FeedBack = 0;
	//uint32 addr = REG_PHY_AGC_ANT0_RF_RSSI_DEC_OUT_STS + (ant * (B0_PHY_AGC_ANT1_BASE_ADDR-B0_PHY_AGC_ANT0_BASE_ADDR));
	uint32 addr = (TSSI0_backup +ant*4);
	UNUSED_PARAM(Tx_power_index);	

	RegAccess_Read(addr, &FeedBack);

	return (uint16)FeedBack;
}

uint16 PhyCalDrv_GetValidTpc()
{
	uint16 Valid = MAX_UINT16;

	return Valid;
}

void PhyCalDrv_ResetValidTpc()
{
}

void PhyCalDrv_SetDigitalLoCancelPair(uint8 antMask, int16* dacI, int16* dacQ, uint8 tpcIndex)
{
#ifdef WRX600_BU_LOGS
	ILOG0_DD("PhyCalDrv_SetDigitalLoCancelPair. antMask 0x%x tpcIndex %d",antMask, tpcIndex);
#endif
	bbic_set_tx_dc_to_progmodel(antMask,dacI,dacQ, tpcIndex);
}
void PhyCalDrv_GetDigitalLoCancelPair(uint8 antMask, int16* dacI, int16* dacQ, uint8 tpcIndex)
{
#ifdef WRX600_BU_LOGS
	ILOG0_DD("PhyCalDrv_GetDigitalLoCancelPair. antMask 0x%x tpcIndex %d",antMask, tpcIndex);
#endif
	bbic_get_tx_dc_from_progmodel(antMask, dacI, dacQ, tpcIndex);
}


void PhyCalDrv_GetRssiDataAll(uint8 inRxAntMask, uint32 inNumOfSamples, uint16 *outDataAllAntennas )
{
	UNUSED_PARAM(inRxAntMask);	
	UNUSED_PARAM(inNumOfSamples);	
	UNUSED_PARAM(outDataAllAntennas);	
}

/********************************************************************************
setDigitalGain:

Description:
------------
set the digital gain to registers .

Input:
-----

Output:
-------
			None.

********************************************************************************/
void PhyCalDrv_GetTxDigitalGain(uint8 antMask , int16* digGain)
{
	bbic_get_tx_diggain(antMask,digGain);
}

void PhyCalDrv_SetDigitalGain(uint8 antMask , int16* digGain)
{
	bbic_set_tx_diggain(antMask, digGain);
}

void PhyCalDrv_SetDifiBypass(PhyCalDrv_DifiBypassState_e state)
{
	UNUSED_PARAM(state);	
	//CALTBD
}

void PhyCalDrv_setDifi2Gain(uint8 antMask, uint8* difiGain)
{
#ifdef WRX600_BU_LOGS
	ILOG0_V("PhyCalDrv_setDifi2Gain");
#endif
	bbic_set_difi2_gain(antMask, difiGain);
}

void PhyCalDrv_getDifi2Gain(uint8 antMask, uint8* difiGain)
{
	bbic_read_difi2_gain(antMask, difiGain);
}

void PhyCalDrv_setDcCancellationMode(uint8 antMask, bool mode)
{
	bbic_set_dc_cancellation_mode(antMask, mode);
}

void PhyCalDrv_setDcAccMode(uint8 antMask, bool mode)
{
	bbic_enable_dc_accelerator(antMask, mode);
}

uint8 PhyCalDrv_RunDcVerification(uint8 antMask, int16* dcI, int16* dcQ, uint16 successVal, uint8 pgcGain, uint8 lnaIndex)
{
	int16 dcIVer[MAX_NUM_OF_ANTENNAS];
	int16 dcQVer[MAX_NUM_OF_ANTENNAS];
	CorrOF_t pAccumOF[MAX_NUM_OF_ANTENNAS];
	DCVerificationResults_t verResults[MAX_NUM_OF_ANTENNAS];
	uint8 successMask;
	
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_RunDcVerification success TH: %d",successVal);
#endif

	PhyCalDrv_CorrDcMeasureDcAvg(antMask, rxDcParams.RxDCconfiguration.accumTimeout, dcIVer, dcQVer, (CorrOverflow_t*)pAccumOF);
	successMask = bbic_verify_DC_results(antMask, dcIVer, dcQVer, pAccumOF, verResults, successVal);
	bbic_write_ram_DC(antMask, dcI, dcQ, verResults, pgcGain, lnaIndex, HDK_getChannelWidth());	

	return successMask;
}
void PhyCalDrv_writeRamDCAll(uint8 AntMsk, int16 pDcRegsI[MAX_NUM_OF_ANTENNAS], int16 pDcRegsQ[MAX_NUM_OF_ANTENNAS], uint8 Pgc_Gain_dB, uint8 lnagainidx, uint8 iBW)
{
	DCVerificationResults_t pDCVer[MAX_NUM_OF_ANTENNAS] = {{TRUE,TRUE},{TRUE,TRUE},{TRUE,TRUE},{TRUE,TRUE}};
	bbic_write_ram_DC(AntMsk, pDcRegsI, pDcRegsQ, pDCVer, Pgc_Gain_dB, lnagainidx, iBW); 
}
void PhyCalDrv_readRamDC(uint8 AntMsk, int16 pDcRegsI_rtrn[MAX_NUM_OF_ANTENNAS], int16 pDcRegsQ_rtrn[MAX_NUM_OF_ANTENNAS], uint8 Pgc_Gain_dB, uint8 lnagainidx, uint8 iBW)
{
	bbic_read_ram_DC(AntMsk, pDcRegsI_rtrn, pDcRegsQ_rtrn, Pgc_Gain_dB, lnagainidx, iBW);
}


void PhyCalDrv_CorrDcMeasureDcAvg(uint8 antMask, uint16 timeout, int16* dcI, int16* dcQ, CorrOverflow_t* accumOF)
{
	CorrResults_t corrResult[MAX_NUM_OF_ANTENNAS] = {0};
	uint8 ant;
	uint8 validMask;
	uint32 nos[MAX_NUM_OF_ANTENNAS] = {rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos};
	CorrOF_t pAccumOF[MAX_NUM_OF_ANTENNAS] = {0};
	
#ifdef WRX600_BU_LOGS
	ILOG0_D("PhyCalDrv_CorrDcMeasureDcAvg. antMask 0x%x",antMask);
#endif
	
	validMask = bbic_read_accum(antMask, timeout, corrResult, pAccumOF);
	DEBUG_ASSERT(validMask == antMask);

	bbic_accum_avg_DC(antMask, corrResult, dcI, dcQ, nos);
	for (ant = 0; ant < ANT_NUM; ant++)
	{
		if (antMask & (1 << ant))
		{
			MEMCPY(&accumOF[ant], &pAccumOF[ant], sizeof(CorrOverflow_t));
#ifdef WRX600_BU_LOGS	
			//SLOG0(0, 0, CorrResults_t, &corrResult[ant]);
			ILOG0_DD("PhyCalDrv_CorrDcMeasureDcAvg. dcI_avg[%d] = %d",ant, dcI[ant]);		
			ILOG0_DD("PhyCalDrv_CorrDcMeasureDcAvg. dcQ_avg[%d] = %d",ant, dcQ[ant]);
#endif
		}
	}
}

void PhyCalDrv_SetDcResultsToPm(uint8 antMask, int16* dcI, int16* dcQ)
{
#ifdef WRX600_BU_LOGS
	ILOG0_V("PhyCalDrv_SetDcResultsToPm");
#endif
	/* Convert Accumulator results to mV */
	bbic_write_dc_values_to_pm(antMask, dcI, dcQ);
}

#define LOG_ACCURACY_BIT (5)
#define DBW_TO_DBM_FACTOR        30

void Measure_AdcPower(CorrRes_t Results[MAX_NUM_OF_ANTENNAS], uint8 inRxAntMask, uint32 numSamples)
{
	/* NOS - number of samples to accumulate*/
	uint8 antMaskOf = 0;
	uint8 dcMode = 0; /*DCMode - accumulate sample values (1-DC mode) or squared values (0-PWR mode) */
	uint8 rssiMode = 0; /*RssiMode - connect I-accumulator to RSSI signal (1) or to I/Q inputs (0)*/
	uint8 rate = 1; /* Rate - connect accumulators before dec chan filter (1) or after dec chan filter (0) */
	uint8 antNum;
    int32 numerator[2];
	int32 denominator; 
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS];
	uint8 accumShift = 8; // AccumShift - bits to round after squaring (active in PWR mode only)
	uint32 adaptive_gain_sample_power = 30;
	uint32 adaptiveGainDenominatorValue = 0;
	uint32 adc_resulotion = 14;
	uint32 difi_gain = 0;
	uint32_t NOS[ANT_NUM];
	uint8_t DCMode[ANT_NUM];
	uint8_t Rate[ANT_NUM];
	uint8_t AccumShift[ANT_NUM];
	uint8_t RssiMode[ANT_NUM];
	int i=0;

	adaptiveGainDenominatorValue = ((numSamples)*adaptive_gain_sample_power*(1<<((2*(adc_resulotion-1))- accumShift)));
		//((numSamples>>DERESOLUTION_NUM_BITS)*ADAPTIVE_GAIN_SAMPLE_POWER*(1<<((2*(ADC_RES-1))- accumShift)));
#ifdef WRX600_BU_LOGS
	ILOG0_DD("inRxAntMask=%d, numSamples =%d",inRxAntMask, numSamples);
	ILOG0_D("adaptiveGainDenominatorValue=%ld",adaptiveGainDenominatorValue);
#endif
	for(i =0; i<ANT_NUM; i++)
	{
		NOS[i] = numSamples;
		DCMode[i] = dcMode;
		RssiMode[i] = rssiMode;
		Rate[i] = rate;
		AccumShift[i] = accumShift ;
	}
	
	PhyCalDrv_CorrInit(inRxAntMask,NOS,DCMode,RssiMode,Rate,AccumShift); //Orit please check the params.

	PhyCalDrv_CorrMeasure(inRxAntMask, 10000/*rxiqParams.accumTimeout*/, Results, corrOf); //find TO 

	for (antNum = 0; antNum < MAX_NUM_OF_ANTENNAS; antNum++)
    {  
        if((1 << antNum) & inRxAntMask)
        {
            numerator[0] = MATH_10Log10Res((uint32)Results[antNum].II,LOG_ACCURACY_BIT);
			numerator[1] = MATH_10Log10Res((uint32)Results[antNum].QQ,LOG_ACCURACY_BIT);
            //denominator = THREE_DB_FACTOR*DERESOLUTION_NUM_BITS*(1<<LOG_ACCURACY_BIT)+ MATH_10Log10Res(adaptiveGainDenominatorValue,LOG_ACCURACY_BIT);//12=3dB*4
            denominator =  MATH_10Log10Res(adaptiveGainDenominatorValue,LOG_ACCURACY_BIT);
#ifdef WRX600_BU_LOGS			
			ILOG0_DDDD("Results[antNum].II %d, Results[antNum].QQ=%d, Results[antNum].IQ =%d, antNum=%d",Results[antNum].II, Results[antNum].QQ, Results[antNum].IQ, antNum);		
			ILOG0_DDD("denominator %d, numerator[0]=%d, numerator[1] =%d",denominator, numerator[0], numerator[1]);
#endif			
 			Results[antNum].II = (numerator[0]-denominator);
            Results[antNum].II = Results[antNum].II + ((DBW_TO_DBM_FACTOR-difi_gain)<<LOG_ACCURACY_BIT) - CW_OFFSET_IN_DB;
            Results[antNum].QQ = (numerator[1]-denominator);
			Results[antNum].QQ = Results[antNum].QQ + ((DBW_TO_DBM_FACTOR-difi_gain)<<LOG_ACCURACY_BIT) - CW_OFFSET_IN_DB;
        }
    }  
	
	for (antNum = 0; antNum < MAX_NUM_OF_ANTENNAS; antNum++)
	{
		if (inRxAntMask & (1 << antNum))
		{
			// Check for overflow
			if ((corrOf[antNum].iiOf) || (corrOf[antNum].qqOf) || (corrOf[antNum].iqOf))
			{
				antMaskOf |= (1 << antNum);
			}
		}
	}
	if(antMaskOf != 0)	
	{
#ifdef WRX600_BU_LOGS	
		ILOG0_D("PhyCalDrv ++++++ OVERFLOW!!!!!: %d",antMaskOf);
#endif
	}

}
	
 



void PhyCalDev_SetToneGenAmplitude(int8 Amplitude)
{
	UNUSED_PARAM(Amplitude);	
	//CALTBD
}

int8 PhyCalDrv_GetToneGenAmplitude(void)
{
	//CALTBD
	return 0;
}


void PhyCalDrv_ToneGenInitAfe()
{ 
	uint8 rxAntMask = Hdk_GetRxAntMask();
	uint8 txAntMask = Hdk_GetTxAntMask();
	bbic_rxoff(rxAntMask); //can change to AFE_RxOff when afe is compiled
	bbic_txon(txAntMask);
}

void PhyCalDrv_SetSpacelessTransmission(bool enable)
{ 
	if(enable)
		{
			REGISTER(MEM_STAY_AT_TX) = 0x1;
			bbic_mac_emu_set_endless(1);
		}
	else
	{
		REGISTER(MEM_STAY_AT_TX) = 0x0;
		bbic_mac_emu_set_endless(0);
		bbic_set_tx_reset();//genrisc end packets
		  //HW said to remove.  bbic_release_tx_reset();
	}
}

void PhyCalDrv_BypassFrc(uint8 AntMsk, bool BypassFRCMode)
{
	bbic_bypass_phy_frc(AntMsk, BypassFRCMode);
}
void PhyCalDrv_GetBypassFrcStatus(uint8 AntMsk, bool Frc_status_rtrn[MAX_NUM_OF_ANTENNAS])
{
	bbic_get_bypass_phy_frc_status(AntMsk, Frc_status_rtrn);
}

void PhyCalDrv_BypassFdl(uint8 AntMsk, bool BypassPhyFDLMode)
{
	bbic_bypass_phy_fdl(AntMsk, BypassPhyFDLMode);
}

void PhyCalDrv_GetBypassFdlStatus(uint8 AntMsk, bool PhyFDL_status_rtrn[MAX_NUM_OF_ANTENNAS])
{
	bbic_get_bypass_phy_fdl_status( AntMsk, PhyFDL_status_rtrn);
}

void PhyCalDrv_SetDetectorResetTh(uint8 DetectorThreshold)
{
	bbic_set_detector_reset_th(DetectorThreshold);
}


uint8 PhyCalDrv_GetDetectorResetTh(void)
{
	return bbic_get_detector_reset_th();
}

void PhyCalDrv_Enable11bDetector(uint8 Enable_Detector_11b)
{
	bbic_enable_11b_detector(Enable_Detector_11b);
}

uint8 PhyCalDrv_Get11bDetectorState()
{
	return bbic_get_11b_detector_state();
}

void PhyCalDrv_GetBbicCdd(dutGetBbicCdd_t * dutGetBbicCdd_p)
{
	ASSERT(dutGetBbicCdd_p->antNum <= TOTAL_ANTENNAS);
	bbic_get_cdd(dutGetBbicCdd_p->antNum,&dutGetBbicCdd_p->offset1_rtrn,&dutGetBbicCdd_p->offset2_rtrn,&dutGetBbicCdd_p->offset3_rtrn);
}

void PhyCalDrv_SetBbicCdd(dutSetBbicCdd_t * dutSetBbicCdd_p)
{
	ASSERT(dutSetBbicCdd_p->antNum <= TOTAL_ANTENNAS);
	bbic_set_cdd(dutSetBbicCdd_p->antNum,(uint8_t)dutSetBbicCdd_p->offset1_rtrn,(uint8_t)dutSetBbicCdd_p->offset2_rtrn,(uint8_t)dutSetBbicCdd_p->offset3_rtrn);
}

