/*****************************************************************************
*    
*   Source File:
*       PhyDriver_API.h
*	
*	AUTHOR: 
*
*   Description: API of PHY Digital Modules Driver  
*       
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*****************************************************************************/
#ifndef PHY_DRIVER_API_H
#define PHY_DRIVER_API_H
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "mt_cnfg.h"
#include "HdkGlobalDefs.h"
#include "System_Configuration.h"
#include "calibrationsParamsOtf.h"
#include "Protocol_PhyAttributes.h"
#include "OSAL_Kmsg.h"
#include "ConfigurationManager_api.h"
/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
/*** GenRisc ***/
#define PHY_VALID_DELAY                         100000

// This bit informs that PHY about a link-adaptation packet (sounding).
// This bit may be set to zero when MRQ is set in the HTC field (under discussion in the LB).
#define TCR3_NOT_SOUNDING_NUMOFBITS 1
#define TCR3_NOT_SOUNDING_SHIFT	    1
#define TCR3_NOT_SOUNDING_MASK 	    MASK(TCR3_NOT_SOUNDING_NUMOFBITS,TCR3_NOT_SOUNDING_SHIFT,uint32)
//Smoothing
#define TCR3_SMOOTH_NUMOFBITS	    1
#define TCR3_SMOOTH_SHIFT		    2
#define TCR3_SMOOTH_MASK 		    MASK(TCR3_SMOOTH_NUMOFBITS,TCR3_SMOOTH_SHIFT,uint32)

#define REG_PHY_RISC_INIT_STATUS	(PHY_RX_TD_BASE_ADDRESS + 0x20D78)

#define RISC_INIT_TIMEOUT			(1000)

/******************************************************************************/
/***						MACROs											***/
/******************************************************************************/

/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/
typedef enum PhyRxHalfBandType
{
	RX_HALF_BAND_TYPE_FULL_CB_80 = 0,
	RX_HALF_BAND_TYPE_NA,
	RX_HALF_BAND_TYPE_20,
	RX_HALF_BAND_TYPE_40
} PhyRxHalfBandType_e;

typedef enum PhyRxPrimaryChType
{
	RX_PRIMARY_TYPE_USB_40_USB_20 = 0x0,
	RX_PRIMARY_TYPE_USB_40_LSB_20 = 0x800000,
	RX_PRIMARY_TYPE_LSB_40_USB_20 = 0x1000000,
	RX_PRIMARY_TYPE_LSB_40_LSB_20 = 0x1800000
} PhyRxPrimaryChType_e;

#define RX_PRIMARY_TYPE_MASK (0x1800000)

typedef enum PhyTxHalfBandType
{
	TX_HALF_BAND_TYPE_CB80 = 0,
	TX_HALF_BAND_TYPE_20 = 0x40,
	TX_HALF_BAND_TYPE_40 = 0X80
} PhyTxHalfBandType_e;

#define TX_HALF_BAND_TYPE_MASK	(0xC0)

typedef enum PhyTxPrimaryChType
{
	TX_PRIMARY_TYPE_USB_40_USB_20 = 0,
	TX_PRIMARY_TYPE_USB_40_LSB_20 = 0x4,
	TX_PRIMARY_TYPE_LSB_40_USB_20 = 0x1,
	TX_PRIMARY_TYPE_LSB_40_LSB_20 = 0x5
} PhyTxPrimaryChType_e;

//11B Ant selection definition
typedef enum PhyDrv_11BAntSelection
{
	ANT_0,
	ANT_1,
	ANT_2,
	ANT_3,
	ROUNDROBIN
} PhyDrv_11BAntSelection_e;

#define TX_PRIMARY_TYPE_MASK	(0x5)

#define TX_PORT_ENABLE_MASK		(0x3C000)
#define TX_PORT_ENABLE_SHIFT	14

typedef struct PhyVersion
{
	uint32	revision;
	uint8	branchId;
	uint8	released;
	uint8	modified;
	uint8	Tx3Enabled;
	uint32	minor;
} PhyVersion_t;
/******************************************************************************/
/***						Public Function Declaration						***/
/******************************************************************************/
/***************************************************************************
** NAME         PhyDrv_Init
** PARAMETERS   None
** RETURNS      na
** DESCRIPTION  Initialisation
****************************************************************************/
void PhyDrv_Init(void);
//************************************
// Method:    PhyDrv_ResetAndEnable
// Purpose:   TBD
// Returns:   void
//************************************
void PhyDrv_ResetAndEnable(void);
//************************************
// Method:    PhyDrv_DisablePhy
// Purpose:   TBD
// Returns:   void
//************************************
void PhyDrv_DisablePhy(void);

/***************************************************************************
** NAME         EnableSequence of MAC/PHY
** PARAMETERS  
** RETURNS      
** DESCRIPTION  Main entry point to Mac/Phy enable sequence.
**              At this point, PHY should be disabled.
****************************************************************************/
RetVal_e PhyDrv_EnableBB(void);
/***************************************************************************
** NAME         DisableSequence of MAC/PHY
** PARAMETERS  
** RETURNS      
** DESCRIPTION  Main entry point to PHY/MAC disable sequence.
****************************************************************************/
RetVal_e PhyDrv_DisableBB(void);
/***************************************************************************
** NAME         SetTxAntOperationSet
** PARAMETERS   opSet - desired operational set
** RETURNS      
** DESCRIPTION  Sets Tx antenna set according to type requested
****************************************************************************/
void PhyDrv_SetTxAntOperationSet(uint8 opSet);
/***************************************************************************
** NAME         SetRxAntOperationSet
** PARAMETERS   opSet - desired operational set
** RETURNS      
** DESCRIPTION  Sets Rx antenna set according to type requested
****************************************************************************/
void    PhyDrv_SetRxAntOperationSet(uint8 opSet);
/***************************************************************************
** NAME         vPHY_MT_SetBand
** PARAMETERS  none
** RETURNS      Set 2.4/5Ghz band
** DESCRIPTION
****************************************************************************/
//************************************
// Method:    PhyDrv_GetRxEnabledAntennas
// Purpose:   TBD
// Returns:   uint8
//************************************
uint8 PhyDrv_GetRxEnabledAntennas(void);
//************************************
// Method:    PhyDrv_GetTxEnabledAntennas
// Purpose:   TBD
// Returns:   uint8
//************************************
uint8 PhyDrv_GetTxEnabledAntennas(void);
//************************************
// Method:    PhyDrv_GetLnaActiveValue
// Purpose:   Returns the LNA active value corresponding to the given LNA index
// Parameter: inLnaIndex   - The LNA index
// Parameter: outnLnaValue - The LNA active value corresponding to the given LNA index
// Returns:   na
//************************************
void PhyDrv_GetLnaActiveValue(HdkLnaIndex_e inLnaIndex, uint8 *outLnaValue);
/***************************************************************************
** NAME         PhyDrv_SetRFMtype()
** PARAMETERS   uint8
** RETURNS      na
** DESCRIPTION  
****************************************************************************/
void PhyDrv_UpdatePrimaryChannel(uint8 band, uint8 u8SpectrumMode, uint8 primary_chan_idx);
/***************************************************************************
** NAME         PhyDrv_Set11bScaler
** PARAMETERS   uint32 inGainValue
** RETURNS      void
** DESCRIPTION  
****************************************************************************/
void PhyDrv_Set11bScaler(uint32 inScalerValue);
/***************************************************************************
** NAME         PhyDrv_SetSpectrum
** PARAMETERS  uint8 band, uint8 chanWidth, uint8 upperLower
** RETURNS      void
** DESCRIPTION  
****************************************************************************/
void PhyDrv_SetSpectrum(uint8 band, uint8 chanWidth, uint8 primary_chan_idx, bool isBWChanged);


//Dut unique functions
//************************************
// Method:    PhyDrv_StopRisc
// Description:
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_StopRisc(void);
//************************************
// Method:    PhyDrv_StartRisc
// Description:
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_StartRisc(void);
//************************************
// Method:    PhyDrv_ReadVersion
// Description:
// Parameter: PhyVersion_t * outPhyVersion
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_ReadVersion(PhyVersion_t *outPhyVersion);
//************************************
// Method:    PhyDrv_SetSpacelessTransmission
// Description:
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_SetSpacelessTransmission(uint8 value);

/*********************************************************************************
Method:			PhyDrv_SetScramblerMode
Description:  
Parameter:    	uint8 mode
Returns:      	void
Remarks:		None
*********************************************************************************/
void PhyDrv_SetScramblerMode(uint8 mode);

//************************************
// Method:    PhyDrv_ReadRssi
// Description:
// Parameter: OUT uint8 * rssiValues
// Parameter: OUT uint8 * energyEstNumOfSamples
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_ReadRssi(OUT uint8 *rssiValues, OUT uint8 *energyEstNumOfSamples);
//************************************
// Method:    PhyDrv_ReadPacketCounter
// Description:
// Parameter: OUT uint32 * rxPacketCounter
// Parameter: OUT uint32 * rxCrcErrorPacketCounter
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_ReadPacketCounter(OUT uint32 *rxPacketCounter,OUT uint32 *rxCrcErrorPacketCounter);
//************************************
// Method:    PhyDrv_ResetPacketCounter
// Description:
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_ResetPacketCounter(void);

//************************************
// Method:    PhyDrv_WriteMinRssiToPhy
// Description:
// Parameter: min rssi val
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_WriteMinRssiToPhy(uint8 regVal);
//************************************
// Method:    PhyDrv_WriteRxDutyCycleReq
// Description:
// Parameter: min rssi val
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_WriteRxDutyCycleReq(uint32 onTime, uint32 offTime);
//************************************
// Method:    PhyDrv_WriteRxThToPhy
// Description:
// Parameter: rx threshold val
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_WriteRxThToPhy(int THval);
//************************************
// Method:    PhyDrv_SetRxHalfBand
// Description: Set Rx hald band mode - 20, 40, 80
// Parameter: IN halfBandType
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_SetRxHalfBand(PhyRxHalfBandType_e halfBandType);

//************************************
// Method:    PhyDrv_SetTxHalfBand
// Description: Set Tx hald band mode - 20, 40, 80
// Parameter: IN halfBandType
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_SetTxHalfBand(PhyTxHalfBandType_e halfBandType);

//************************************
// Method:    PhyDrv_SetRxPrimary
// Description: set Rx primary channel - 20 lsb, 20 usb, 40 lsb, 40 usb
// Parameter: IN rxPrimaryType
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_SetRxPrimary(PhyRxPrimaryChType_e rxPrimaryType);

//************************************
// Method:    PhyDrv_SetTxPrimary
// Description: set Tx primary channel - 20 lsb, 20 usb, 40 lsb, 40 usb
// Parameter: IN rxPrimaryType
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_SetTxPrimary(PhyTxPrimaryChType_e txPrimaryType);
void PhyDrv_SetBand(uint8 phyType,uint8 *band);
uint8 PhyDrv_GetTxPrimary(void);

//************************************
// Method:    PhyDrv_ReleaseSWreset
// Description: enables al PHY modules, apart from risc activation
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_ReleaseSWreset(void);

//disbale & release SW reset
void PhyDrv_ResetBB(void);

//disable & enable
void PhyDrv_ReActivateBB(void);
//Set antenna configuration reg
void PhyDrv_SetMacAntConfig(uint8 antMask);

//pre calibration actions
void PhyDrv_preCal(void);

//post calibrations actions
void PhyDrv_postCal(void);

void PhyDrv_SWresetViaRisc(void);


//************************************
// Method:    PhyDrv_RFICreset
// Description: resets RFIC
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_RFICreset(void);

//************************************
// Method:    PhyDrv_RFICreset
// Description: releases RFIC reset
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_RFICreleaseReset(void);

//************************************
// Method:    PhyDrv_SWresetViaRisc
// Description: reset PHY via GenRisc
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_EnableRx(void);
bool PhyDrv_IsAcMode(void);

void PhyDrv_ActivateSemaphoreForAocs(uint32 activate);
void PhyDrvRadarDetection_SetRssiTh(int32 value);
int32 PhyDrvRadarDetection_GetRssiTh(void);
void PhyDrvInterfererDetection_SetChannelRequest(uint8 newChannel, uint8 isRadarDetectionNeeded, uint8 isContinuousInterfererDetectionNeeded);
void PhyDrvInterfererDetection_FlushRadarDetectionFifo(void);
void PhyDrvInterfererDetection_FlushContinuousInterfererDetectionFifo(uint8 isNotificationNeeded);
void PhyDrvInterfererDetection_Initialize(void);
void PhyDrv_ClearPhyInterrupts(void);
void PhyDrv_ReActivateBB(void);
void PhyDrv_LockReActivateBB(bool lock);
uint8 PhyDrv_ReadMacAntConfig(void);
void isr_PhyDrv_PhyInterrupt(void);

void PhyDrv_SetMuGroupUsp(uint16 vapIdx, uint16 groupIdx, uint16 userPosition, bool enable);

void PhyDrv_SetCcaTh(K_MSG* psMsg);
void PhyDrv_GetCcaTh(K_MSG* psMsg);

void PhyDrv_GetRxEvm(OUT uint8 *rxEvm_p);

//************************************
// Method:    PhyDrv_RestoreRegsAfterStartRisc
// Description: restores digital which are reset during start RISC
// Parameter: void
// Returns:   void
// Remarks:   None
//************************************
void PhyDrv_RestoreRegsAfterStartRisc(void);

void PhyDrv_Set_11B_roundRobinSelection(uint8 rate);
void PhyDrv_SetVhtNonAggregate(uint8 enable);


void PhyDrv_Set_11B_RxAntSelection(PhyDrv_11BAntSelection_e Ant_selection);

void PhyDrv_Set_11B_TxAntSelection(PhyDrv_11BAntSelection_e Ant_selection);
void PhyDrv_PowerSave_RadioOff(void);
void PhyDrv_SetFrequency(void);
void PhyDrv_SetCompressedFourierPhases(uint8 numOfAnts);
void PhyDrv_SetBssColor(uint8 vapId, uint8 bssColor);
uint32 PhyDrv_GetRxAbortCounter(void);
void PhyDrv_BandEdgeFix(SetChannelParams_t* channelReqParams);
void phyDrv_SetBandEdgeFixForTxWindow(uint32* windowFixsTable);
void phyDrv_SetTxWindow(uint8 windowLenMode);
void PhyDrv_SetConnectedSTAind(uint8 isSTAConnected);
void PhyDrv_SetPowerSave(uint8 enableDisable);
void PhyDrv_PowerSaveInit(void);
void PhyDrv_macEmuStop(void);
void PhyDrv_macEmuRun(uint8 antMask, uint8 RfPow, uint16 bw, uint8 packet_format, uint8 mcs, uint8 nss, uint32 packet_length, uint8 ldpc, uint8 gap, uint16 repeats);
void PhyDrv_setPgcFiltLut(int8 AntMsk , uint8 PgcFiltLUT_local[5][11]);

#endif //(PHY_DRIVER_API_H)

