/****************************************************************************
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         PhyDriverCommon.h
 **
 ** DESCRIPTION:    PHY header internal for module, for all PHY types 
 **
 ****************************************************************************/
#ifndef PHY_DRIVER_COMMON_H
#define PHY_DRIVER_COMMON_H

#include "System_GlobalDefinitions.h"
#include "HdkGlobalDefs.h"

/***************************************************************************/
/***                              Defines                                ***/
/***************************************************************************/
#define PHY_SCRAMBLER_MODE_ON           (0x5D)
#define PHY_SCRAMBLER_MODE_OFF          (0)

/***************************************************************************/
/***                          Type Definition                            ***/
/***************************************************************************/
typedef struct PhyConfigParams 
{
    uint8	txEnabledAntennas;
    uint8	rxEnabledAntennas;
    uint8	reserved[2];
} PhyConfigParams_t;

#ifndef ENET_INC_ARCH_WAVE600
typedef enum
{
	PHY_ERROR_CAUSE_TX_TCR0_ERROR = 0,
	PHY_ERROR_CAUSE_TX_TCR1_AND_TCR2_ERROR,
	PHY_ERROR_CAUSE_TX_TCR3_ERROR,
	PHY_ERROR_CAUSE_TX_TCR4_ERROR,
	PHY_ERROR_CAUSE_TX_BF_ERROR_PACKET_STBC_AND_BF_MOVING_TO_FLAT,
	PHY_ERROR_CAUSE_TX_BF_ERROR_TIMEOUT_DURING_HEADER,
	PHY_ERROR_CAUSE_TX_BF_ERROR_TIMEOUT_DURING_BODY,
	PHY_ERROR_CAUSE_TX_BF_ERROR_HEADER_LENGTH_IS_ZERO,
	PHY_ERROR_CAUSE_TX_BF_ERROR_IMPLICIT_AND_REPORT_NR_SMALLER_THAN_ACTIVE_ANTENNAS,
	PHY_ERROR_CAUSE_TX_BF_ERROR_BF_REPORT_NC_SMALLER_THAN_TX_NSS,
	PHY_ERROR_CAUSE_TX_BF_ERROR_REPORT_BW_IS_LESS_THAN_TCR_BW,
	PHY_ERROR_CAUSE_TX_BF_ERROR_REPORT_BW_IS_MORE_THAN_ACTUAL_TX_BW,
	PHY_ERROR_CAUSE_TX_BF_ERROR_REPORT_BW_IS_80_AND_PACKET_LEGACY,
	PHY_ERROR_CAUSE_TX_AIR_TIME_ERROR,
	PHY_ERROR_CAUSE_TX_ANTENNA_SELECTION_ERROR_ACTIVE_ANTENNAS_ARE_LESS_THAN_NUMBER_OF_SPATIAL_STREAMS,
	PHY_ERROR_CAUSE_TX_ANTENNA_SELECTION_ERROR_NUMBER_OF_PROG_MODEL_ANTENNAS_ARE_LESS_THAN_ACTIVE_ANTENNAS,
	PHY_ERROR_NUM_OF_CAUSE_TX_ERROR,
	PHY_ERROR_MAX_NUM_OF_CAUSE_TX_ERROR = 0xFF,	
} PhyErrorCause_e;
#endif
#define TX_ANT_REGS_OFFSET			(B0_PHY_TXTD_ANT1_BASE_ADDR - B0_PHY_TXTD_ANT0_BASE_ADDR)  

#endif /* PHY_DRIVER_COMMON_H */
