
/***********************************************************************************
 File:			PhyTestBus_API.h
 Module:		test bus
 Purpose: 	
 Description:	This file contains all definitions and the structures of the test bus  
 				
************************************************************************************/

#ifndef PhyTestBus_API_h__
#define PhyTestBus_API_h__

#include "System_GlobalDefinitions.h"
#include "HdkGlobalDefs.h"


#ifdef ENET_INC_ARCH_WAVE600

typedef enum _TestBusMode_e
{
	CBD_BAND0_AND_BAND1					= 0x0,
	CBD_BAND0_ONLY						= 0x1,
	CBD_BAND1_ONLY						= 0x2,
	CBD_BAND0_AND_BAND1_EXTRA_BF_BUFFER	= 0x3,
} TestBusMode_e;

void PhyTestBus_Open(void);
void PhyTestBus_Stop(void);
void PhyTestBus_Close(void);
void PhyTestBus_CdbSetMode(uint8 RiscTrace,TestBusMode_e mode );

#else

typedef enum TestBusType 
{
	RSSI,
	ADC
}TestBusType_E;

/********************************************************************************
PHYCal_TestBusOpen:

Description:
------------
Config Test Bus Fifo As follows:
1. Backup register.
2. Write the same plug value (TestBusType) to each of the test bus.
3. Mux each plug to the fifo next to it.

Input:
-----
	TestBusType: RSSI, ADC, ...
	
Output:
-------

********************************************************************************/
void PhyTestBus_Open(TestBusType_E type);


#if defined (ANALYZE_DISABLE_INTERRUPT)
void AAA_DebugStopTestBus(void);
#endif



/********************************************************************************
PHYCal_TestBusRecord:

Description:
------------
Record samples

Input:
-----
	num_of_samples: 1-250
	
Output:
-------

********************************************************************************/
void PhyTestBus_Record(uint8 num_of_samples);
/********************************************************************************
PHYCal_TestBusRead:

Description:
------------
Read recorded sample. If more than 1 sample then need to call the function again.

Input:
-----
	fifo_num: 0-low, 1-mid, 2-high
	sample_num: 
	
Output:
-------

********************************************************************************/
uint32   PhyTestBus_Read(uint8 fifo_num, uint8 sample_num);
/********************************************************************************
PHYCal_TestBusClose:

Description:
------------
Restore registers 

Input:
-----
	
Output:
-------

********************************************************************************/
void PhyTestBus_Close(void);
#endif
#endif // PhyTestBus_API_h__

