#include "PhyTestBus_API.h"
#include "System_GlobalDefinitions.h"
#include "PhyRegsIncluder.h"
#include "PhyDriver_API.h"
#include "RegAccess_Api.h"
#include "mt_sysrst.h"
#include "RegAccess_Api.h"
#include "HwMemoryMap.h"
#include "OSAL_Api.h"
#include "ErrorHandler_Api.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 13


#



/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/	
#define FD_PLUG						0x070
#define FD_TEST_BUS_LOCAL_ENABLE	0x040
#define BE_PLUG						0x010

typedef struct RegBackup 
{
	uint32	Unit	;
	uint32	Address	;
	uint32	Value	;
}RegBackup_T;

static RegBackup_T	m_testBusBackupRegisters[]=
{
	{PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0,0},
	{PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1,0},
	{PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2,0},
	{PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL,0},
	{PHY_FD_BASE_ADDR,FD_PLUG,0},
	{PHY_FD_BASE_ADDR,FD_TEST_BUS_LOCAL_ENABLE,0},
	{PHY_TX_BASE_ADDR,REG_TX_BE_REG_5A_TEST_PLUG_LOCAL_EN_00,0},
	{PHY_BE_BASE_ADDR,BE_PLUG,0}
};

#define NUM_OF_TEST_BUS_REGISTERS_BKP sizeof(m_testBusBackupRegisters)/sizeof(RegBackup_T)	

/*********************************************************************************/
/* The following functions related to the test bus,
   when merged 2.3.10 consider merging these function to the test bus general functions
*/
/*********************************************************************************/
void PhyTestBus_Open(TestBusType_E type)
{
	 int8 i;
	 int32 plug_value;


	 MT_WrReg(PHY_TD_BASE_ADDR, REG_PHY_RXTD_REG7F_TD_TEST_BUS_GCLK_EN, TEST_BUS_GCLK_ENABLE);

	//backup registers
	 for(i=0;i<NUM_OF_TEST_BUS_REGISTERS_BKP;++i)
	{
		m_testBusBackupRegisters[i].Value	=	MT_RdReg(m_testBusBackupRegisters[i].Unit,m_testBusBackupRegisters[i].Address);
	}

	
	//zero all TB Regs (Do we need to zero all test plug FD,BE,Tx)??
	for(i=0;i<NUM_OF_TEST_BUS_REGISTERS_BKP;++i)
	{
		MT_WrReg(m_testBusBackupRegisters[i].Unit,m_testBusBackupRegisters[i].Address,0);
	}

	//config register
	switch(type)
	{
	case RSSI:
		plug_value = 0x100000;
        //wave300
		//Add to AFE driver
		//MT_WrRegMask(PHY_TD_BASE_ADDR,REG_AFE_DYN_CTRL_AUX_ADC0_SEL,0xfc0,0); //aux adc0,1,2 selector
		break;
	case ADC:
		plug_value = 0x1;
		//MT_WrRegMask(PHY_TD_BASE_ADDR,REG_AFE_DYN_CTRL_AUX_ADC0_SEL,0xfc0,0); //aux adc0,1,2 selector
		break;
	default:
	    break;
	}
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05E_TD_TEST_PLUG_LEN_AN0, plug_value);
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG05F_TD_TEST_PLUG_LEN_AN1, plug_value);
	MT_WrReg(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG060_TD_TEST_PLUG_LEN_AN2, plug_value);
	
	//connect each plug to each fifo 
	MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL, REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL_MASK, 0x00);	//low	
	MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL, REG_PHY_RXTD_REG84_TEST_BUS_MID_MUX_CTRL_MASK, 0x100);	//mid
	MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL, REG_PHY_RXTD_REG84_TEST_BUS_HIGH_MUX_CTRL_MASK,0x2000);	//high
	MT_WrRegMask(PHY_TD_BASE_ADDR, REG_PHY_RXTD_REG84_TEST_BUS_LOW_MUX_CTRL,    0x7,   0x3);	// set to capture mode + cyclic enable.	
}

#if defined (ANALYZE_DISABLE_INTERRUPT)
void AAA_DebugStopTestBus(void)
{
	//write 0 to stop genrisc 4k trace
	MT_WrReg(PHY_TD_BASE_ADDR, REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN, 0);
}
#endif

void PhyTestBus_Record(uint8 num_of_samples)
{
	uint16 counter=0;

	DEBUG_ASSERT(num_of_samples<250);

	//stop recording
	MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_MASK,0);

	//Reset FIFOs counters and pointers:
    MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG81_TB_FIFO_CLEAR,0x10,0x10);
    MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_REG81_TB_FIFO_CLEAR,0x10,0x00);

	//Enable operation:
    MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_MASK,0x7);    
	{  
    	uint32        Start_Cal_Time=0,End_Cal_Time=0;
    	Start_Cal_Time = TIME_STAMP(0,Start_Cal_Time);

    	//poll on counter
    	while (counter<=num_of_samples)
    	{
		    counter=(uint16)(MT_RdReg(PHY_TD_BASE_ADDR, REG_PHY_RXTD_IF81_BYTES_IN_FIFO0) & 0x1fff);
   			End_Cal_Time = TIME_STAMP(1,Start_Cal_Time);
			ASSERT(End_Cal_Time <= PHY_VALID_DELAY);
    	}
   }
	//stop recording
	 MT_WrRegMask(PHY_TD_BASE_ADDR,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN,REG_PHY_RXTD_IF3D_GEN_RISC_TEST_BUS_EN_MASK,0);

   return;
}

uint32 PhyTestBus_Read(uint8 fifo_num, uint8 sample_num)
{
	 uint32 fifo_address = RXTD_TB_FIFO_Low;
	 switch(fifo_num)
	 {
	 case 0:
		fifo_address = RXTD_TB_FIFO_Low;
	 	break;
	 case 1:
		fifo_address = RXTD_TB_FIFO_Mid;
	 	break;
	 case 2:
	    fifo_address = RXTD_TB_FIFO_high;
		break;
	 default:
	 	FATAL("PhyTestBus_Read, illegal case");
		break;
	 }
	 return MT_RdReg(PHY_TD_BASE_ADDR,fifo_address + sample_num*4) & 0xffffff;
}

void PhyTestBus_Close(void)
{
	int8 i;

	 //Restore registers:
	for(i=0;i<NUM_OF_TEST_BUS_REGISTERS_BKP;++i)
	{
		MT_WrReg(m_testBusBackupRegisters[i].Unit,m_testBusBackupRegisters[i].Address,m_testBusBackupRegisters[i].Value);
	}
}










