//#include "PhyTestBus_API.h"
#include "System_GlobalDefinitions.h"
#include "PhyRegsIncluder.h"
#include "PhyDriver_API.h"
#include "RegAccess_Api.h"
#include "mt_sysrst.h"
#include "RegAccess_Api.h"
#include "HwMemoryMap.h"
#include "OSAL_Api.h"
#include "ErrorHandler_Api.h"
#include "PhyRxTdIfRegs.h"
#include "PhyRxTdRegs.h"
#ifdef ENET_INC_ARCH_WAVE600D2	
#include "PhyRxBeRegs.h"
#else
#include "PhyRxbeRegs.h"
#endif
#include "PhyTxRegs.h"
#include "PhyTxMacEmuRegs.h"
#include "stringLibApi.h"
#include "loggerAPI.h"
#include "ConfigurationManager_api.h"
#include "phy_access_definitions.h"
#include "PhyRxFdIfRegs.h"
#include "PhyTestBus_API.h"
#include "HdkTask.h"
#include "PhyRxBeIfRegs.h"

#define LOG_LOCAL_GID   GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 14



typedef struct phyDbg_
{
	//word 0
	RegPhyRxBePhyRxbeReg76_u 		RegPhyRxBePhyRxbeReg76;
	//word 1
	RegPhyRxBePhyRxbeReg74_u		RegPhyRxBePhyRxbeReg74;
	//word 2
	RegPhyRxBePhyRxbeReg75_u		RegPhyRxBePhyRxbeReg75;
	//word 3
	RegPhyRxBePhyRxbeReg71_u		RegPhyRxBePhyRxbeReg71;
	//word 4
	RegPhyRxBePhyRxbeReg72_u		RegPhyRxBePhyRxbeReg72;
	//word 5
	RegPhyRxBePhyRxbeReg98_u		RegPhyRxBePhyRxbeReg98;
	//word 6
	RegPhyRxBePhyRxbeReg99_u		RegPhyRxBePhyRxbeReg99;
	//word 7
	RegPhyRxFdIfPhyRxfdIf10E_u		RegPhyRxFdIfPhyRxfdIf10E;
	//word 8
	RegPhyRxTdPhyRxtdReg096_u		RegPhyRxTdPhyRxtdReg096;
	//word 9
	uint32							testBusstoped;
	//word 10
	uint32							phyRiscPC_1;
	//word 10
	uint32							phyRiscPC_2;
	//word 10
	uint32							phyRiscPC_3;
	//word 11
	RegPhyTxTxSwReset_u				RegPhyTxTxSwReset;
	//word 12
	RegPhyRxFdIfPhyRxfdIfRiscCauseInt_u	RegPhyRxFdIfPhyRxfdIfRiscCauseInt;
	//word 13
	RegPhyRxBeIfPhyRxbeIfRiscInt_u	RegPhyRxBeIfPhyRxbeIfRiscInt;
	//word 14
	RegPhyRxBeIfPhyRxbeIf1C1_u		RegPhyRxBeIfPhyRxbeIf1C1;
	//word 15
	RegPhyRxBeIfPhyRxbeIf1C0_u		RegPhyRxBeIfPhyRxbeIf1C0;
	//word 16
	RegPhyRxFdIfPhyRxfdIf160_u		RegPhyRxFdIfPhyRxfdIf160;
	//word 17
	RegPhyRxFdIfPhyRxfdIf161_u		RegPhyRxFdIfPhyRxfdIf161;
	//word 18
	RegPhyRxFdIfPhyRxfdIf162_u		RegPhyRxFdIfPhyRxfdIf162;
	//word 19
	RegPhyRxFdIfPhyRxfdIf163_u		RegPhyRxFdIfPhyRxfdIf163;

	//word 20
	RegPhyTxMacEmuTcr0Data0_u	RegPhyTxMacEmuTcr0Data0;
	//word 21
	RegPhyTxMacEmuTcr0Data1_u	RegPhyTxMacEmuTcr0Data1;
	//word 22
	RegPhyTxMacEmuTcr0Data2_u	RegPhyTxMacEmuTcr0Data2;
	//word 23
	RegPhyTxMacEmuTcr0Data3_u	RegPhyTxMacEmuTcr0Data3;
	//word 24
	RegPhyTxMacEmuTcr1Data0_u	RegPhyTxMacEmuTcr1Data0;
	//word 25
	RegPhyTxMacEmuTcr1Data1_u	RegPhyTxMacEmuTcr1Data1;
	//word 26
	RegPhyTxMacEmuTcr1Data2_u	RegPhyTxMacEmuTcr1Data2;
	//word 27
	RegPhyTxMacEmuTcr1Data3_u	RegPhyTxMacEmuTcr1Data3;

	//word 28
	RegPhyTxMacEmuTcrCommonPhyMode_u	RegPhyTxMacEmuTcrCommonPhyMode;
	//word 29-94
	RegPhyTxMacEmuTcrUserSelectData0_u	aRegPhyTxMacEmuTcrUserSelectData[HE_MU_MAX_NUM_OF_USERS_PER_GROUP][4];

	uint32 RcrRam[18];

	uint32 phyBusError;
	

}phyDbg_t;

typedef struct testBusInfo
{
	uint8 			withRiscTrace;
	TestBusMode_e 	testBusMode;
}testBusInfo_t;


phyDbg_t phyDbg;

testBusInfo_t testBusInfoDB = {TRUE,CBD_BAND0_AND_BAND1};

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/	
void PhyTestBus_Open(void)
{
#ifndef	ENET_INC_HW_FPGA

	//enable the phy record buff

	phyDbg.testBusstoped = 0;

	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG30,0x00000010,0x00000010);	//B0_PHY_RX_TD:td_test_bus_reset
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG30,0x00000010,0x00000000);	//B0_PHY_RX_TD:td_test_bus_out_of_reset
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG2E,0x00000001,0x00000001);	//B0_PHY_RX_TD:td_test_bus_gclk_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG2E,0x00000002,0x00000002);	//B0_PHY_RX_TD:be_test_bus_gclk_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG2E,0x00000004,0x00000004);	//B0_PHY_RX_TD:slicer_test_bus_gclk_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG2E,0x00000008,0x00000008);	//B0_PHY_RX_TD:fd_test_bus_gclk_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG2E,0x00000010,0x00000010);	//B0_PHY_RX_TD:tx_test_bus_gclk_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG31,0x00000001,0x00);		//B0_PHY_RX_TD:test_fifo_capture_mode
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG31,0x00000030,0x00);		//B0_PHY_RX_TD:test_bus_low_mux_ctrl
	RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG31,0x00000300,0x00000100);	//B0_PHY_RX_TD:test_bus_mid_mux_ctrl
	
	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_SINGLE_BAND)
	{
		RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x03);//B0_PHY_RX_TD:test_bus_fifo_config
		RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0xFFF8);//B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
	}
	else
	{
		if (testBusInfoDB.testBusMode == CBD_BAND0_AND_BAND1)
		{
#if defined (ENET_INC_LMAC0)
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x01);//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0x7FF8);//B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
#if defined (ENET_INC_LMAC1)
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x02);//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0x7FF8);//B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
		}
		else if (testBusInfoDB.testBusMode == CBD_BAND0_ONLY)
		{
#if defined (ENET_INC_LMAC0)
			//in order to record test bus in CDB mode and use the all buffer for band 0  - 
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x03);		//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0xFFF8);	//B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
		}
		else if (testBusInfoDB.testBusMode == CBD_BAND1_ONLY)
		{
#if defined (ENET_INC_LMAC1)
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x03); 	//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0xFFF8); //B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
		}
		else if (testBusInfoDB.testBusMode == CBD_BAND0_AND_BAND1_EXTRA_BF_BUFFER)
		{
#if defined (ENET_INC_LMAC1)
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x03);	//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0xFFF8); //B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
#if defined (ENET_INC_LMAC0)
			//in order to record test bus in CDB mode and use the BF  buffer for band 0  - 
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x04);	//B0_PHY_RX_TD:test_bus_fifo_config
			RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF151,0x0000fffe,0xFFF8); //B0_PHY_RX_TD_IF:test_bus_fifo_high_thr
#endif
		}
	}
	
	//mac-phy i/f trace
	RegAccess_WriteMasked(REG_PHY_RX_BE_PHY_RXBE_REG04,0x00000001,0x00000001);//B0_PHY_RX_BE:tp_phy_mac_event_len
	RegAccess_WriteMasked(REG_PHY_TX_TX_BE_REG_5A,0x00000003,0x00000002);//B0_PHY_TX:test_plug_local_en_00

#ifdef ENET_INC_ARCH_WAVE600B

	if (testBusInfoDB.withRiscTrace == TRUE)
	{
		RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG025,0xFFFFFFFF,0x00400000);//risc trace
	}
	else
	{
		RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG025,0xFFFFFFFF,0x00000000);//risc trace

	}
	//To start record the phy:
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF3D,0x0000000f,0x00);//B0_PHY_RX_TD_IF:gen_risc_test_bus_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF3D,0x0000000f,0x0f);//B0_PHY_RX_TD_IF:gen_risc_test_bus_en
#else //if wave600 (and not wave600b)  
	if (testBusInfoDB.withRiscTrace == TRUE)
	{
		RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG024,0xFFFFFFFF,0x00400000);//risc trace
	}
	else
	{
		RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG024,0xFFFFFFFF,0x00000000);//risc trace

	}
	//To start record the phy:
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF3D,0x0000000f,0x00);//B0_PHY_RX_TD_IF:gen_risc_test_bus_en
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF3D,0x0000000f,0x0b);//B0_PHY_RX_TD_IF:gen_risc_test_bus_en
#endif

#endif //#ifndef	ENET_INC_HW_FPGA

}




void PhyTestBus_Stop(void)
{	
#ifndef	ENET_INC_HW_FPGA
	uint32 SW_reset;
	RegPhyRxTdPhyRxtdReg021_u riscPageReg;
	RegPhyTxMacEmuTcrUserSelect_u RegPhyTxMacEmuTcrUserSelect;
	int i = 0;

	if (phyDbg.testBusstoped == 0)
	{
		phyDbg.testBusstoped = 1; // the test bus stoped
		//stop record mac i/f:

		// Read genrisc registers (registers + PC + some more). can be seen in SoC online.
		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG021, &riscPageReg.val);
		riscPageReg.bitFields.riscPage = 1;
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG021, riscPageReg.val);

		PhyTestBus_Close();

		RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF152,0x1,0x1); //test_bus_dump_all_data_strb

		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG096,&phyDbg.RegPhyRxTdPhyRxtdReg096.val); 		//Read testBusBufferFifoIndex

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG76,&phyDbg.RegPhyRxBePhyRxbeReg76.val); 		//Read LSIG:0xb00000 + 0x1d8

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG74,&phyDbg.RegPhyRxBePhyRxbeReg74.val); 		//Read HT-SIG2: 0xb00000 + 0x1d0

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG75,&phyDbg.RegPhyRxBePhyRxbeReg75.val); 		//Read HT-SIG3: 0xb00000 + 0x1d4

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG71,&phyDbg.RegPhyRxBePhyRxbeReg71.val); 		//Read VHT-SIGA1: 0xb00000 + 0x1c4

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG72,&phyDbg.RegPhyRxBePhyRxbeReg72.val); 		//Read VHT-SIGA2: 0xb00000 + 0x1c8

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG98,&phyDbg.RegPhyRxBePhyRxbeReg98.val); 		//Read HE-SIGA1: 0xb00000 + 0x230

		RegAccess_Read(REG_PHY_RX_BE_PHY_RXBE_REG99,&phyDbg.RegPhyRxBePhyRxbeReg99.val); 		//Read HE-SIGA2: 0xb00000 + 0x234

		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF10E,&phyDbg.RegPhyRxFdIfPhyRxfdIf10E.val); 	//Read PHY MODE: 0xb80000 + 0x1438

		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF_RISC_CAUSE_INT, &phyDbg.RegPhyRxFdIfPhyRxfdIfRiscCauseInt.val);

		RegAccess_Read(REG_PHY_RX_BE_IF_PHY_RXBE_IF_RISC_INT, &phyDbg.RegPhyRxBeIfPhyRxbeIfRiscInt.val);

		RegAccess_Read(REG_PHY_RX_BE_IF_PHY_RXBE_IF1C1, &phyDbg.RegPhyRxBeIfPhyRxbeIf1C1.val);

		RegAccess_Read(REG_PHY_RX_BE_IF_PHY_RXBE_IF1C0, &phyDbg.RegPhyRxBeIfPhyRxbeIf1C0.val);

		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF160, &phyDbg.RegPhyRxFdIfPhyRxfdIf160.val);
		
		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF161, &phyDbg.RegPhyRxFdIfPhyRxfdIf161.val);
		
		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF162, &phyDbg.RegPhyRxFdIfPhyRxfdIf162.val);
		
		RegAccess_Read(REG_PHY_RX_FD_IF_PHY_RXFD_IF163, &phyDbg.RegPhyRxFdIfPhyRxfdIf163.val);

		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR0_DATA_0, &phyDbg.RegPhyTxMacEmuTcr0Data0.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR0_DATA_1, &phyDbg.RegPhyTxMacEmuTcr0Data1.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR0_DATA_2, &phyDbg.RegPhyTxMacEmuTcr0Data2.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR0_DATA_3, &phyDbg.RegPhyTxMacEmuTcr0Data3.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR1_DATA_0, &phyDbg.RegPhyTxMacEmuTcr1Data0.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR1_DATA_1, &phyDbg.RegPhyTxMacEmuTcr1Data1.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR1_DATA_2, &phyDbg.RegPhyTxMacEmuTcr1Data2.val);
		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR1_DATA_3, &phyDbg.RegPhyTxMacEmuTcr1Data3.val);

		RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_COMMON_PHY_MODE, &phyDbg.RegPhyTxMacEmuTcrCommonPhyMode.val);
		
		if(PHY_MODE_11AX_MU_DL == phyDbg.RegPhyTxMacEmuTcrCommonPhyMode.bitFields.tcrCommonPhyMode)
		{
			for(i = 0 ; i < HE_MU_MAX_NUM_OF_USERS_PER_GROUP ; i++)
			{
				RegPhyTxMacEmuTcrUserSelect.bitFields.tcrUserSelect = i;
				RegAccess_Write(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT, RegPhyTxMacEmuTcrUserSelect.val);
				RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_0, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[i][0].val);
				RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_1, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[i][1].val);
				RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_2, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[i][2].val);
				RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_3, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[i][3].val);
			}
		}
		else
		{
			RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_0, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[0][0].val);
			RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_1, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[0][1].val);
			RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_2, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[0][2].val);
			RegAccess_Read(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT_DATA_3, &phyDbg.aRegPhyTxMacEmuTcrUserSelectData[0][3].val);
		}

		//Return to user 0
		RegPhyTxMacEmuTcrUserSelect.bitFields.tcrUserSelect = 0;
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TCR_USER_SELECT, RegPhyTxMacEmuTcrUserSelect.val);

		//Read RCR RAM
		memcpy32(&phyDbg.RcrRam[0], (uint32*)B0_RX_RCR_RCR_RAM_CDB0, (18*sizeof(uint32)));
	
		phyDbg.phyRiscPC_1 = MT_RdReg(PHY_RX_TD_BASE_ADDRESS, 0x804c);							// Read the PC 3 times
		phyDbg.phyRiscPC_2 = MT_RdReg(PHY_RX_TD_BASE_ADDRESS, 0x804c);							// Read the PC 3 times	
		phyDbg.phyRiscPC_3 = MT_RdReg(PHY_RX_TD_BASE_ADDRESS, 0x804c);							// Read the PC 3 times		

		phyDbg.phyBusError =  MT_RdReg(PHY_RX_TD_BASE_ADDRESS, 0x8054);	

		RegAccess_Read(REG_PHY_RX_TD_PHY_RXTD_REG021, &riscPageReg.val);
		riscPageReg.bitFields.riscPage = 0;
		RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG021, riscPageReg.val);

		RegAccess_Read(REG_PHY_TX_TX_SW_RESET,&phyDbg.RegPhyTxTxSwReset.val); 				//Read TX SW Reset: 0xbc0000 + 0x0
		
		PHY_READ_REG(REG_PHY_RX_TD_PHY_RXTD_REG00, 0, &SW_reset);
		PHY_WRITE_REG(REG_PHY_RX_TD_IF_PHY_RXTD_IF67, 0, 0x0); // disable watchdog done
		PHY_WRITE_REG(REG_PHY_RX_TD_PHY_RXTD_REG00, 0, 0xf7ffffff & SW_reset); // Reset GenRisc done
		PHY_WRITE_REG(REG_PHY_RX_TD_IF_PHY_RXTD_IF67, 0, 0x0); // disable watchdog done
		PHY_WRITE_REG(REG_PHY_RX_TD_IF_PHY_RXTD_IF84, 0, 1); //mask WD interrupt
		PHY_WRITE_REG(REG_PHY_RX_TD_PHY_RXTD_REG00, 0, 0xfFffffff & SW_reset); // out of reset GenRisc done


#if defined (ENET_INC_LMAC0)
		if ((ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND) && (testBusInfoDB.testBusMode == CBD_BAND0_AND_BAND1_EXTRA_BF_BUFFER))
		{
			//use the BF  buffer for band 0
			RegAccess_WriteMasked(REG_PHY_RX_TD_PHY_RXTD_REG091,0x0000000f,0x03);

		}		
#endif //defined (ENET_INC_LMAC0)		
	}

#endif //#ifndef	ENET_INC_HW_FPGA


}

void PhyTestBus_Close(void)
{	
#ifndef	ENET_INC_HW_FPGA
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_PHY_RXTD_IF3D,0x0000000f,0x00);//B0_PHY_RX_TD_IF:gen_risc_test_bus_en
#endif //#ifndef	ENET_INC_HW_FPGA
 
}


void PhyTestBus_CdbSetMode(uint8 RiscTrace,TestBusMode_e mode )
{
#ifndef	ENET_INC_HW_FPGA

	testBusInfoDB.testBusMode = mode;
	testBusInfoDB.withRiscTrace =  RiscTrace;
	PhyTestBus_Close();
	if (Hdk_isTestBusEnable() == TRUE)
	{
		PhyTestBus_Open();
	}
#else
	UNUSED_PARAM(RiscTrace);
	UNUSED_PARAM(mode);
#endif

}





