/*****************************************************************************
*    
*   Source File:
*       RficCommon.h
*
*   AUTHOR: Amir Hitron
*
*   Description:Driver of the Rfic  
*       
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*****************************************************************************/
#ifndef __RFIC_COMMON_H
#define __RFIC_COMMON_H

/******************************************************************************/
/***                        Include Files                                   ***/
/******************************************************************************/

#include "HdkGlobalDefs.h"

/******************************************************************************/
/***                        Constant Defines                                ***/
/******************************************************************************/
#define RFIC_MAX_NUMBER_OF_TUNE_WORD_ENTRIES 10
#define RFIC_INVALID_TUNE_WORD_ENTRIE        (7000)

/* Tx DACs  */ 
#define RFIC_TX_DAC_MAX_VALUE                63
#define RFIC_TX_DAC_MIN_VALUE                (-64)
/* DACs 1 and 2 min/MAX values */
#define RFIC_DAC_MAX_VALUE                   15
#define RFIC_DAC_MIN_VALUE                   (-16)
/* DACs 1 and 2 min/MAX values */
#define RFIC_DAC_0_MAX_VALUE                 31
#define RFIC_DAC_0_MIN_VALUE                 (-32)

/* VCO and Frequency-Setting constants */
#define RFIC_VCO_PLL_LOCK_DELAY              		1000
#define RFIC_FREQ_STARTING_POINT_2_4G        		2407 /* Starting frequency of 2.4GHz band */
#define RFIC_FREQ_STARTING_POINT_2_4G_CHANNEL_14 	2414 /* Starting frequency of 2.4GHz band Ch 14 calculation*/
#define RFIC_FREQ_STARTING_POINT_5G_4        		4000 /* Starting frequency of 5.2GHz band in Japan */
#define RFIC_FREQ_STARTING_POINT_5G_5        		5000 /* Starting frequency of 2.4GHz band in USA and Europe */
#define RFIC_FREQ_FIRST_CHANNEL_5G_4         		181  /* First channel of 5.2GHz band in Japan */
#define RFIC_FREQ_LAST_CHANNEL_5G_4          		200  /* Last  channel of 5.2GHz band in Japan */

/******************************************************************************/
/***                        Type Definition                                 ***/
/******************************************************************************/
typedef struct RficFreqTuneWordPair
{
    uint32 freq:16;
    uint32 word:16;
} RficFreqTuneWordPair_t;
/* This struct is used to describe a collection of tuning words per frequency and per antenna */
typedef struct RficFreqTuneWord
{
    RficFreqTuneWordPair_t tuneWords[RFIC_MAX_NUMBER_OF_TUNE_WORD_ENTRIES];
    uint16                 regAddr;
    uint16                 regMask;
    uint16                 regShift;
} RficFreqTuneWord_t;

/******************************************************************************/
/***                        Macros                                          ***/
/******************************************************************************/


#endif//__RFIC_COMMON_H

