/*******************************************************************
*                                                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro '         
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/


#ifndef __RFIC_DEFINES_H
#define __RFIC_DEFINES_H

/******************************************************************/
/***						Include Files									***/
/******************************************************************/

#include "HdkGlobalDefs.h"
#include "System_GlobalDefinitions.h"
#include "LmHdk_API.h"

#define TPC_NUM_DIGITAL_WORDS		(13)
#define TPC_NUM_PRE_DRV_WORDS		(16)
#define TPC_NUM_PGC_WORDS			(3)

/*********************************************************/
/*                  ChipName: AR10                       */
/*********************************************************/
/* RFIC  address*/
#define REG_RFIC_S0_SHORT_0                           (0x0)
#define REG_RFIC_S1_SHORT_1                           (0x1)
#define REG_RFIC_S2_SHORT_2                           (0x2)
#define REG_RFIC_S3_SHORT_3                           (0x3)
#define REG_RFIC_L0_RSSI_REG1                         (0x40)
#define REG_RFIC_L1_RSSI_REG2                         (0x41)
#define REG_RFIC_L2_RSSI_REG3                         (0x42)
#define REG_RFIC_L3_RSSI_REG4_RX_MIXER_OFFS_2         (0x43)
#define REG_RFIC_L4_ANA_MUX                           (0x44)
#define REG_RFIC_L5_ANA_MUX_PROCMON_TEMPS             (0x45)
#define REG_RFIC_L6_LNA_2G_5G_LNA5G                   (0x46)
#define REG_RFIC_L7_RX_MIXER_OFFS_1                   (0x47)
#define REG_RFIC_L8_RX_MIXER_2G_5G                    (0x48)
#define REG_RFIC_L9_PGC12_REG1                        (0x49)
#define REG_RFIC_L10_PGC12_REG2                       (0x4A)
#define REG_RFIC_L11_PGC2_SSB_DC_OFF                  (0x4B)
#define REG_RFIC_L12_BIAS_LOC1                        (0x4C)
#define REG_RFIC_L13_BIAS_LOC2                        (0x4D)
#define REG_RFIC_L14_LO_GEN_LOC                       (0x4E)
#define REG_RFIC_L15_RX_MIXER_OFFS_0                  (0x4F)
#define REG_RFIC_L16_TPC_OFFSET_0                     (0x50)
#define REG_RFIC_L17_TPC_OFFSET_1                     (0x51)
#define REG_RFIC_L18_TPC_OFFSET_2                     (0x52)
#define REG_RFIC_L19_TPC_OFFSET_3                     (0x53)
#define REG_RFIC_L20_TPC_OFFSET_4                     (0x54)
#define REG_RFIC_L21_TPC_OFFSET_5                     (0x55)
#define REG_RFIC_L22_TPC_OFFSET_6                     (0x56)
#define REG_RFIC_L23_TPC_OFFSET_7                     (0x57)
#define REG_RFIC_L24_TPC_REG                          (0x58)
#define REG_RFIC_L25_PA_2GREG1                        (0x59)
#define REG_RFIC_L26_PA_2GREG2                        (0x5A)
#define REG_RFIC_L27_PD_2G_PD_5G                      (0x5B)
#define REG_RFIC_L28_TXMIXER2G_5G                     (0x5C)
#define REG_RFIC_L29_TSSI_SSB                         (0x5D)
#define REG_RFIC_L30_LDO_1V2RF                        (0x5E)
#define REG_RFIC_L31_LDO_2V5RF                        (0x5F)
#define REG_RFIC_L32_PGC3_REG1                        (0x60)
#define REG_RFIC_L33_PGC3_REG2_SEBUF                  (0x61)
#define REG_RFIC_L34_PGC3_BIAS                        (0x62)
#define REG_RFIC_L35_RF_PLL_MONITOR                   (0x63)
#define REG_RFIC_L36_                                 (0x64)
#define REG_RFIC_L37_                                 (0x65)
#define REG_RFIC_L38_                                 (0x66)
#define REG_RFIC_L39_                                 (0x67)
#define REG_RFIC_L40_CONFIG                           (0x68)
#define REG_RFIC_L41_VERSIONNUMBER                    (0x69)
#define REG_RFIC_L42_                                 (0x6A)
#define REG_RFIC_L43_                                 (0x6B)
#define REG_RFIC_L44_                                 (0x6C)
#define REG_RFIC_L45_                                 (0x6D)
#define REG_RFIC_L46_                                 (0x6E)
#define REG_RFIC_L47_                                 (0x6F)
#define REG_RFIC_L48_RF_PLL_1                         (0x70)
#define REG_RFIC_L49_DCXO_REG1                        (0x71)
#define REG_RFIC_L50_DCXO_REG2_FSYS                   (0x72)
#define REG_RFIC_L51_BIAS_CENTRAL1                    (0x73)
#define REG_RFIC_L52_BIAS_CENTRAL2_RESET_DCXO_LDO     (0x74)
#define REG_RFIC_L53_FCSI_LDO_OTHERS                  (0x75)
#define REG_RFIC_L54_LDO_LOTREE                       (0x76)
#define REG_RFIC_L55_LDO_IQBUF                        (0x77)
#define REG_RFIC_L56_LO_GEN_CENTRAL                   (0x78)
#define REG_RFIC_L57_RF_PLL_2                         (0x79)
#define REG_RFIC_L58_RF_PLL_3                         (0x7A)
#define REG_RFIC_L59_RF_PLL_4                         (0x7B)
#define REG_RFIC_L60_RF_PLL_5                         (0x7C)
#define REG_RFIC_L61_RF_PLL_6                         (0x7D)
#define REG_RFIC_L62_RF_PLL_7                         (0x7E)
#define REG_RFIC_L63_RF_PLL_8                         (0x7F)

/* S0_SSION */
#define REG_RFIC_S0_SSION          (0x0)
#define REG_RFIC_S0_SSION_MASK     (0x3)
#define REG_RFIC_S0_SSION_SHIFT    (0)
#define REG_RFIC_S0_SSION_WIDTH    (2)

/* S0_RXON */
#define REG_RFIC_S0_RXON          (0x0)
#define REG_RFIC_S0_RXON_MASK     (0x4)
#define REG_RFIC_S0_RXON_SHIFT    (2)
#define REG_RFIC_S0_RXON_WIDTH    (1)

/* S0_TXON */
#define REG_RFIC_S0_TXON          (0x0)
#define REG_RFIC_S0_TXON_MASK     (0x8)
#define REG_RFIC_S0_TXON_SHIFT    (3)
#define REG_RFIC_S0_TXON_WIDTH    (1)

/* S0_SPU */
#define REG_RFIC_S0_SPU          (0x0)
#define REG_RFIC_S0_SPU_MASK     (0x70)
#define REG_RFIC_S0_SPU_SHIFT    (4)
#define REG_RFIC_S0_SPU_WIDTH    (3)

/* S0_EN_PA2G */
#define REG_RFIC_S0_EN_PA2G          (0x0)
#define REG_RFIC_S0_EN_PA2G_MASK     (0x80)
#define REG_RFIC_S0_EN_PA2G_SHIFT    (7)
#define REG_RFIC_S0_EN_PA2G_WIDTH    (1)

/* S0_RFFECTL_RXTXSW_N */
#define REG_RFIC_S0_RFFECTL_RXTXSW_N          (0x0)
#define REG_RFIC_S0_RFFECTL_RXTXSW_N_MASK     (0x100)
#define REG_RFIC_S0_RFFECTL_RXTXSW_N_SHIFT    (8)
#define REG_RFIC_S0_RFFECTL_RXTXSW_N_WIDTH    (1)

/* S0_RFFECTL_RXTXSW_P */
#define REG_RFIC_S0_RFFECTL_RXTXSW_P          (0x0)
#define REG_RFIC_S0_RFFECTL_RXTXSW_P_MASK     (0x200)
#define REG_RFIC_S0_RFFECTL_RXTXSW_P_SHIFT    (9)
#define REG_RFIC_S0_RFFECTL_RXTXSW_P_WIDTH    (1)

/* S0_RFFECTL_EXTLNA_2G5G */
#define REG_RFIC_S0_RFFECTL_EXTLNA_2G5G          (0x0)
#define REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_MASK     (0x400)
#define REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_SHIFT    (10)
#define REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_WIDTH    (1)

/* S0_RFFECTL_PAON_5G */
#define REG_RFIC_S0_RFFECTL_PAON_5G          (0x0)
#define REG_RFIC_S0_RFFECTL_PAON_5G_MASK     (0x800)
#define REG_RFIC_S0_RFFECTL_PAON_5G_SHIFT    (11)
#define REG_RFIC_S0_RFFECTL_PAON_5G_WIDTH    (1)

/* S0_RFFECTL_PAON_2G */
#define REG_RFIC_S0_RFFECTL_PAON_2G          (0x0)
#define REG_RFIC_S0_RFFECTL_PAON_2G_MASK     (0x1000)
#define REG_RFIC_S0_RFFECTL_PAON_2G_SHIFT    (12)
#define REG_RFIC_S0_RFFECTL_PAON_2G_WIDTH    (1)

/* S0_RFFECTL_ANT_SEL */
#define REG_RFIC_S0_RFFECTL_ANT_SEL          (0x0)
#define REG_RFIC_S0_RFFECTL_ANT_SEL_MASK     (0x2000)
#define REG_RFIC_S0_RFFECTL_ANT_SEL_SHIFT    (13)
#define REG_RFIC_S0_RFFECTL_ANT_SEL_WIDTH    (1)

/* S0_RFFECTL_WAVE */
#define REG_RFIC_S0_RFFECTL_WAVE          (0x0)
#define REG_RFIC_S0_RFFECTL_WAVE_MASK     (0x4000)
#define REG_RFIC_S0_RFFECTL_WAVE_SHIFT    (14)
#define REG_RFIC_S0_RFFECTL_WAVE_WIDTH    (1)

/* S0_PLLBW */
#define REG_RFIC_S0_PLLBW          (0x0)
#define REG_RFIC_S0_PLLBW_MASK     (0x8000)
#define REG_RFIC_S0_PLLBW_SHIFT    (15)
#define REG_RFIC_S0_PLLBW_WIDTH    (1)

/* S1_PGC1_DCOFF_I */
#define REG_RFIC_S1_PGC1_DCOFF_I          (0x1)
#define REG_RFIC_S1_PGC1_DCOFF_I_MASK     (0x1F)
#define REG_RFIC_S1_PGC1_DCOFF_I_SHIFT    (0)
#define REG_RFIC_S1_PGC1_DCOFF_I_WIDTH    (5)

/* S1_PGC1_DCOFF_Q */
#define REG_RFIC_S1_PGC1_DCOFF_Q          (0x1)
#define REG_RFIC_S1_PGC1_DCOFF_Q_MASK     (0x3E0)
#define REG_RFIC_S1_PGC1_DCOFF_Q_SHIFT    (5)
#define REG_RFIC_S1_PGC1_DCOFF_Q_WIDTH    (5)

/* S1_PGC3GAIN */
#define REG_RFIC_S1_PGC3GAIN          (0x1)
#define REG_RFIC_S1_PGC3GAIN_MASK     (0x3C00)
#define REG_RFIC_S1_PGC3GAIN_SHIFT    (10)
#define REG_RFIC_S1_PGC3GAIN_WIDTH    (4)

/* S1_LNAGAIN */
#define REG_RFIC_S1_LNAGAIN          (0x1)
#define REG_RFIC_S1_LNAGAIN_MASK     (0xC000)
#define REG_RFIC_S1_LNAGAIN_SHIFT    (14)
#define REG_RFIC_S1_LNAGAIN_WIDTH    (2)

/* S2_PGC2_DCOFF_I */
#define REG_RFIC_S2_PGC2_DCOFF_I          (0x2)
#define REG_RFIC_S2_PGC2_DCOFF_I_MASK     (0x1F)
#define REG_RFIC_S2_PGC2_DCOFF_I_SHIFT    (0)
#define REG_RFIC_S2_PGC2_DCOFF_I_WIDTH    (5)

/* S2_PGC2_DCOFF_Q */
#define REG_RFIC_S2_PGC2_DCOFF_Q          (0x2)
#define REG_RFIC_S2_PGC2_DCOFF_Q_MASK     (0x3E0)
#define REG_RFIC_S2_PGC2_DCOFF_Q_SHIFT    (5)
#define REG_RFIC_S2_PGC2_DCOFF_Q_WIDTH    (5)

/* S2_PGC2GAIN */
#define REG_RFIC_S2_PGC2GAIN          (0x2)
#define REG_RFIC_S2_PGC2GAIN_MASK     (0x1C00)
#define REG_RFIC_S2_PGC2GAIN_SHIFT    (10)
#define REG_RFIC_S2_PGC2GAIN_WIDTH    (3)

/* S2_PGC1GAIN */
#define REG_RFIC_S2_PGC1GAIN          (0x2)
#define REG_RFIC_S2_PGC1GAIN_MASK     (0xE000)
#define REG_RFIC_S2_PGC1GAIN_SHIFT    (13)
#define REG_RFIC_S2_PGC1GAIN_WIDTH    (3)

/* S3_TPCGAIN */
#define REG_RFIC_S3_TPCGAIN          (0x3)
#define REG_RFIC_S3_TPCGAIN_MASK     (0x7)
#define REG_RFIC_S3_TPCGAIN_SHIFT    (0)
#define REG_RFIC_S3_TPCGAIN_WIDTH    (3)

/* S3_MIXGAIN */
#define REG_RFIC_S3_MIXGAIN          (0x3)
#define REG_RFIC_S3_MIXGAIN_MASK     (0x8)
#define REG_RFIC_S3_MIXGAIN_SHIFT    (3)
#define REG_RFIC_S3_MIXGAIN_WIDTH    (1)

/* S3_PDGAIN */
#define REG_RFIC_S3_PDGAIN          (0x3)
#define REG_RFIC_S3_PDGAIN_MASK     (0x10)
#define REG_RFIC_S3_PDGAIN_SHIFT    (4)
#define REG_RFIC_S3_PDGAIN_WIDTH    (1)

/* S3_BIAS1 */
#define REG_RFIC_S3_BIAS1          (0x3)
#define REG_RFIC_S3_BIAS1_MASK     (0xE0)
#define REG_RFIC_S3_BIAS1_SHIFT    (5)
#define REG_RFIC_S3_BIAS1_WIDTH    (3)

/* S3_DPTAT1 */
#define REG_RFIC_S3_DPTAT1          (0x3)
#define REG_RFIC_S3_DPTAT1_MASK     (0xF00)
#define REG_RFIC_S3_DPTAT1_SHIFT    (8)
#define REG_RFIC_S3_DPTAT1_WIDTH    (4)

/* S3_CNT_IBIAS */
#define REG_RFIC_S3_CNT_IBIAS          (0x3)
#define REG_RFIC_S3_CNT_IBIAS_MASK     (0x3000)
#define REG_RFIC_S3_CNT_IBIAS_SHIFT    (12)
#define REG_RFIC_S3_CNT_IBIAS_WIDTH    (2)

/* S3_SWC1_MOD2G */
#define REG_RFIC_S3_SWC1_MOD2G          (0x3)
#define REG_RFIC_S3_SWC1_MOD2G_MASK     (0x4000)
#define REG_RFIC_S3_SWC1_MOD2G_SHIFT    (14)
#define REG_RFIC_S3_SWC1_MOD2G_WIDTH    (1)

/* S3_SWC2_MOD2G */
#define REG_RFIC_S3_SWC2_MOD2G          (0x3)
#define REG_RFIC_S3_SWC2_MOD2G_MASK     (0x8000)
#define REG_RFIC_S3_SWC2_MOD2G_SHIFT    (15)
#define REG_RFIC_S3_SWC2_MOD2G_WIDTH    (1)

/* L0_I_RSSI_CAL4 */
#define REG_RFIC_L0_I_RSSI_CAL4          (0x40)
#define REG_RFIC_L0_I_RSSI_CAL4_MASK     (0xF)
#define REG_RFIC_L0_I_RSSI_CAL4_SHIFT    (0)
#define REG_RFIC_L0_I_RSSI_CAL4_WIDTH    (4)

/* L0_I_RSSI_CAL3 */
#define REG_RFIC_L0_I_RSSI_CAL3          (0x40)
#define REG_RFIC_L0_I_RSSI_CAL3_MASK     (0xF0)
#define REG_RFIC_L0_I_RSSI_CAL3_SHIFT    (4)
#define REG_RFIC_L0_I_RSSI_CAL3_WIDTH    (4)

/* L0_I_RSSI_CAL2 */
#define REG_RFIC_L0_I_RSSI_CAL2          (0x40)
#define REG_RFIC_L0_I_RSSI_CAL2_MASK     (0xF00)
#define REG_RFIC_L0_I_RSSI_CAL2_SHIFT    (8)
#define REG_RFIC_L0_I_RSSI_CAL2_WIDTH    (4)

/* L0_I_RSSI_CAL1 */
#define REG_RFIC_L0_I_RSSI_CAL1          (0x40)
#define REG_RFIC_L0_I_RSSI_CAL1_MASK     (0xF000)
#define REG_RFIC_L0_I_RSSI_CAL1_SHIFT    (12)
#define REG_RFIC_L0_I_RSSI_CAL1_WIDTH    (4)

/* L1_Q_RSSI_CAL4 */
#define REG_RFIC_L1_Q_RSSI_CAL4          (0x41)
#define REG_RFIC_L1_Q_RSSI_CAL4_MASK     (0xF)
#define REG_RFIC_L1_Q_RSSI_CAL4_SHIFT    (0)
#define REG_RFIC_L1_Q_RSSI_CAL4_WIDTH    (4)

/* L1_Q_RSSI_CAL3 */
#define REG_RFIC_L1_Q_RSSI_CAL3          (0x41)
#define REG_RFIC_L1_Q_RSSI_CAL3_MASK     (0xF0)
#define REG_RFIC_L1_Q_RSSI_CAL3_SHIFT    (4)
#define REG_RFIC_L1_Q_RSSI_CAL3_WIDTH    (4)

/* L1_Q_RSSI_CAL2 */
#define REG_RFIC_L1_Q_RSSI_CAL2          (0x41)
#define REG_RFIC_L1_Q_RSSI_CAL2_MASK     (0xF00)
#define REG_RFIC_L1_Q_RSSI_CAL2_SHIFT    (8)
#define REG_RFIC_L1_Q_RSSI_CAL2_WIDTH    (4)

/* L1_Q_RSSI_CAL1 */
#define REG_RFIC_L1_Q_RSSI_CAL1          (0x41)
#define REG_RFIC_L1_Q_RSSI_CAL1_MASK     (0xF000)
#define REG_RFIC_L1_Q_RSSI_CAL1_SHIFT    (12)
#define REG_RFIC_L1_Q_RSSI_CAL1_WIDTH    (4)

/* L2_CAL_STEP */
#define REG_RFIC_L2_CAL_STEP          (0x42)
#define REG_RFIC_L2_CAL_STEP_MASK     (0x7)
#define REG_RFIC_L2_CAL_STEP_SHIFT    (0)
#define REG_RFIC_L2_CAL_STEP_WIDTH    (3)

/* L2_CAL_Q */
#define REG_RFIC_L2_CAL_Q          (0x42)
#define REG_RFIC_L2_CAL_Q_MASK     (0x8)
#define REG_RFIC_L2_CAL_Q_SHIFT    (3)
#define REG_RFIC_L2_CAL_Q_WIDTH    (1)

/* L2_CAL_I */
#define REG_RFIC_L2_CAL_I          (0x42)
#define REG_RFIC_L2_CAL_I_MASK     (0x10)
#define REG_RFIC_L2_CAL_I_SHIFT    (4)
#define REG_RFIC_L2_CAL_I_WIDTH    (1)

/* L2_CAL_VDD */
#define REG_RFIC_L2_CAL_VDD          (0x42)
#define REG_RFIC_L2_CAL_VDD_MASK     (0x20)
#define REG_RFIC_L2_CAL_VDD_SHIFT    (5)
#define REG_RFIC_L2_CAL_VDD_WIDTH    (1)

/* L2_SHORT_INPUT */
#define REG_RFIC_L2_SHORT_INPUT          (0x42)
#define REG_RFIC_L2_SHORT_INPUT_MASK     (0x40)
#define REG_RFIC_L2_SHORT_INPUT_SHIFT    (6)
#define REG_RFIC_L2_SHORT_INPUT_WIDTH    (1)

/* L2_CONNECT_DAC */
#define REG_RFIC_L2_CONNECT_DAC          (0x42)
#define REG_RFIC_L2_CONNECT_DAC_MASK     (0x80)
#define REG_RFIC_L2_CONNECT_DAC_SHIFT    (7)
#define REG_RFIC_L2_CONNECT_DAC_WIDTH    (1)

/* L2_Q_RSSI_CAL5 */
#define REG_RFIC_L2_Q_RSSI_CAL5          (0x42)
#define REG_RFIC_L2_Q_RSSI_CAL5_MASK     (0xF00)
#define REG_RFIC_L2_Q_RSSI_CAL5_SHIFT    (8)
#define REG_RFIC_L2_Q_RSSI_CAL5_WIDTH    (4)

/* L2_I_RSSI_CAL5 */
#define REG_RFIC_L2_I_RSSI_CAL5          (0x42)
#define REG_RFIC_L2_I_RSSI_CAL5_MASK     (0xF000)
#define REG_RFIC_L2_I_RSSI_CAL5_SHIFT    (12)
#define REG_RFIC_L2_I_RSSI_CAL5_WIDTH    (4)

/* L3_RX_MIX_DCOFFS2_I */
#define REG_RFIC_L3_RX_MIX_DCOFFS2_I          (0x43)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_I_MASK     (0x3F)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_I_SHIFT    (0)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_I_WIDTH    (6)

/* L3_RX_MIX_DCOFFS2_Q */
#define REG_RFIC_L3_RX_MIX_DCOFFS2_Q          (0x43)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_Q_MASK     (0xFC0)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_Q_SHIFT    (6)
#define REG_RFIC_L3_RX_MIX_DCOFFS2_Q_WIDTH    (6)

/* L3_BIAS_TRIM */
#define REG_RFIC_L3_BIAS_TRIM          (0x43)
#define REG_RFIC_L3_BIAS_TRIM_MASK     (0x7000)
#define REG_RFIC_L3_BIAS_TRIM_SHIFT    (12)
#define REG_RFIC_L3_BIAS_TRIM_WIDTH    (3)

/* L3_EN_RSSI */
#define REG_RFIC_L3_EN_RSSI          (0x43)
#define REG_RFIC_L3_EN_RSSI_MASK     (0x8000)
#define REG_RFIC_L3_EN_RSSI_SHIFT    (15)
#define REG_RFIC_L3_EN_RSSI_WIDTH    (1)

/* L4_SEL_RC */
#define REG_RFIC_L4_SEL_RC          (0x44)
#define REG_RFIC_L4_SEL_RC_MASK     (0x7)
#define REG_RFIC_L4_SEL_RC_SHIFT    (0)
#define REG_RFIC_L4_SEL_RC_WIDTH    (3)

/* L4_SEL_IN */
#define REG_RFIC_L4_SEL_IN          (0x44)
#define REG_RFIC_L4_SEL_IN_MASK     (0x38)
#define REG_RFIC_L4_SEL_IN_SHIFT    (3)
#define REG_RFIC_L4_SEL_IN_WIDTH    (3)

/* L4_TSSI5_EXT_RA */
#define REG_RFIC_L4_TSSI5_EXT_RA          (0x44)
#define REG_RFIC_L4_TSSI5_EXT_RA_MASK     (0x1C0)
#define REG_RFIC_L4_TSSI5_EXT_RA_SHIFT    (6)
#define REG_RFIC_L4_TSSI5_EXT_RA_WIDTH    (3)

/* L4_TSSI2_EXT_RA */
#define REG_RFIC_L4_TSSI2_EXT_RA          (0x44)
#define REG_RFIC_L4_TSSI2_EXT_RA_MASK     (0xE00)
#define REG_RFIC_L4_TSSI2_EXT_RA_SHIFT    (9)
#define REG_RFIC_L4_TSSI2_EXT_RA_WIDTH    (3)

/* L4_SEL_RSSI */
#define REG_RFIC_L4_SEL_RSSI          (0x44)
#define REG_RFIC_L4_SEL_RSSI_MASK     (0xF000)
#define REG_RFIC_L4_SEL_RSSI_SHIFT    (12)
#define REG_RFIC_L4_SEL_RSSI_WIDTH    (4)

/* L5_SEL_PROCMON */
#define REG_RFIC_L5_SEL_PROCMON          (0x45)
#define REG_RFIC_L5_SEL_PROCMON_MASK     (0xF)
#define REG_RFIC_L5_SEL_PROCMON_SHIFT    (0)
#define REG_RFIC_L5_SEL_PROCMON_WIDTH    (4)

/* L5_EN_PROC */
#define REG_RFIC_L5_EN_PROC          (0x45)
#define REG_RFIC_L5_EN_PROC_MASK     (0x10)
#define REG_RFIC_L5_EN_PROC_SHIFT    (4)
#define REG_RFIC_L5_EN_PROC_WIDTH    (1)

/* L5_EN_TEMPS */
#define REG_RFIC_L5_EN_TEMPS          (0x45)
#define REG_RFIC_L5_EN_TEMPS_MASK     (0x20)
#define REG_RFIC_L5_EN_TEMPS_SHIFT    (5)
#define REG_RFIC_L5_EN_TEMPS_WIDTH    (1)

/* L5_SEL_TSSI */
#define REG_RFIC_L5_SEL_TSSI          (0x45)
#define REG_RFIC_L5_SEL_TSSI_MASK     (0xC0)
#define REG_RFIC_L5_SEL_TSSI_SHIFT    (6)
#define REG_RFIC_L5_SEL_TSSI_WIDTH    (2)

/* L5_SEL_FB */
#define REG_RFIC_L5_SEL_FB          (0x45)
#define REG_RFIC_L5_SEL_FB_MASK     (0x300)
#define REG_RFIC_L5_SEL_FB_SHIFT    (8)
#define REG_RFIC_L5_SEL_FB_WIDTH    (2)

/* L5_SEL_RB */
#define REG_RFIC_L5_SEL_RB          (0x45)
#define REG_RFIC_L5_SEL_RB_MASK     (0x1C00)
#define REG_RFIC_L5_SEL_RB_SHIFT    (10)
#define REG_RFIC_L5_SEL_RB_WIDTH    (3)

/* L5_SEL_OFFS */
#define REG_RFIC_L5_SEL_OFFS          (0x45)
#define REG_RFIC_L5_SEL_OFFS_MASK     (0x6000)
#define REG_RFIC_L5_SEL_OFFS_SHIFT    (13)
#define REG_RFIC_L5_SEL_OFFS_WIDTH    (2)

/* L5_EN_ANAMUX */
#define REG_RFIC_L5_EN_ANAMUX          (0x45)
#define REG_RFIC_L5_EN_ANAMUX_MASK     (0x8000)
#define REG_RFIC_L5_EN_ANAMUX_SHIFT    (15)
#define REG_RFIC_L5_EN_ANAMUX_WIDTH    (1)

/* L6_EN_TEST_2GLNA */
#define REG_RFIC_L6_EN_TEST_2GLNA          (0x46)
#define REG_RFIC_L6_EN_TEST_2GLNA_MASK     (0x1)
#define REG_RFIC_L6_EN_TEST_2GLNA_SHIFT    (0)
#define REG_RFIC_L6_EN_TEST_2GLNA_WIDTH    (1)

/* L6_TEST_2GLNA_GAIN */
#define REG_RFIC_L6_TEST_2GLNA_GAIN          (0x46)
#define REG_RFIC_L6_TEST_2GLNA_GAIN_MASK     (0xE)
#define REG_RFIC_L6_TEST_2GLNA_GAIN_SHIFT    (1)
#define REG_RFIC_L6_TEST_2GLNA_GAIN_WIDTH    (3)

/* L6_EN_CLAMP */
#define REG_RFIC_L6_EN_CLAMP          (0x46)
#define REG_RFIC_L6_EN_CLAMP_MASK     (0x10)
#define REG_RFIC_L6_EN_CLAMP_SHIFT    (4)
#define REG_RFIC_L6_EN_CLAMP_WIDTH    (1)

/* L6_BAND_5G */
#define REG_RFIC_L6_BAND_5G          (0x46)
#define REG_RFIC_L6_BAND_5G_MASK     (0xE0)
#define REG_RFIC_L6_BAND_5G_SHIFT    (5)
#define REG_RFIC_L6_BAND_5G_WIDTH    (3)

/* L6_BIAS_5G */
#define REG_RFIC_L6_BIAS_5G          (0x46)
#define REG_RFIC_L6_BIAS_5G_MASK     (0x700)
#define REG_RFIC_L6_BIAS_5G_SHIFT    (8)
#define REG_RFIC_L6_BIAS_5G_WIDTH    (3)

/* L6_BIAS_MODE5G */
#define REG_RFIC_L6_BIAS_MODE5G          (0x46)
#define REG_RFIC_L6_BIAS_MODE5G_MASK     (0x1000)
#define REG_RFIC_L6_BIAS_MODE5G_SHIFT    (12)
#define REG_RFIC_L6_BIAS_MODE5G_WIDTH    (1)

/* L6_WU_LNA5G */
#define REG_RFIC_L6_WU_LNA5G          (0x46)
#define REG_RFIC_L6_WU_LNA5G_MASK     (0x2000)
#define REG_RFIC_L6_WU_LNA5G_SHIFT    (13)
#define REG_RFIC_L6_WU_LNA5G_WIDTH    (1)

/* L6_EN_LNA */
#define REG_RFIC_L6_EN_LNA          (0x46)
#define REG_RFIC_L6_EN_LNA_MASK     (0x8000)
#define REG_RFIC_L6_EN_LNA_SHIFT    (15)
#define REG_RFIC_L6_EN_LNA_WIDTH    (1)

/* L7_RX_MIX_DCOFFS1_I */
#define REG_RFIC_L7_RX_MIX_DCOFFS1_I          (0x47)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_I_MASK     (0x3F)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_I_SHIFT    (0)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_I_WIDTH    (6)

/* L7_RX_MIX_DCOFFS1_Q */
#define REG_RFIC_L7_RX_MIX_DCOFFS1_Q          (0x47)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_Q_MASK     (0xFC0)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_Q_SHIFT    (6)
#define REG_RFIC_L7_RX_MIX_DCOFFS1_Q_WIDTH    (6)

/* L8_EN_SWAP_CAL_MIXER */
#define REG_RFIC_L8_EN_SWAP_CAL_MIXER          (0x48)
#define REG_RFIC_L8_EN_SWAP_CAL_MIXER_MASK     (0x200)
#define REG_RFIC_L8_EN_SWAP_CAL_MIXER_SHIFT    (9)
#define REG_RFIC_L8_EN_SWAP_CAL_MIXER_WIDTH    (1)

/* L8_EN_CAL_MIXER */
#define REG_RFIC_L8_EN_CAL_MIXER          (0x48)
#define REG_RFIC_L8_EN_CAL_MIXER_MASK     (0x400)
#define REG_RFIC_L8_EN_CAL_MIXER_SHIFT    (10)
#define REG_RFIC_L8_EN_CAL_MIXER_WIDTH    (1)

/* L8_EN_ISINK */
#define REG_RFIC_L8_EN_ISINK          (0x48)
#define REG_RFIC_L8_EN_ISINK_MASK     (0x800)
#define REG_RFIC_L8_EN_ISINK_SHIFT    (11)
#define REG_RFIC_L8_EN_ISINK_WIDTH    (1)

/* L8_EN_MIXQ */
#define REG_RFIC_L8_EN_MIXQ          (0x48)
#define REG_RFIC_L8_EN_MIXQ_MASK     (0x1000)
#define REG_RFIC_L8_EN_MIXQ_SHIFT    (12)
#define REG_RFIC_L8_EN_MIXQ_WIDTH    (1)

/* L8_EN_MIXI */
#define REG_RFIC_L8_EN_MIXI          (0x48)
#define REG_RFIC_L8_EN_MIXI_MASK     (0x2000)
#define REG_RFIC_L8_EN_MIXI_SHIFT    (13)
#define REG_RFIC_L8_EN_MIXI_WIDTH    (1)

/* L8_WU_MIXER */
#define REG_RFIC_L8_WU_MIXER          (0x48)
#define REG_RFIC_L8_WU_MIXER_MASK     (0x4000)
#define REG_RFIC_L8_WU_MIXER_SHIFT    (14)
#define REG_RFIC_L8_WU_MIXER_WIDTH    (1)

/* L8_EN_MIXER */
#define REG_RFIC_L8_EN_MIXER          (0x48)
#define REG_RFIC_L8_EN_MIXER_MASK     (0x8000)
#define REG_RFIC_L8_EN_MIXER_SHIFT    (15)
#define REG_RFIC_L8_EN_MIXER_WIDTH    (1)

/* L9_PGC12_Q_FTRIM */
#define REG_RFIC_L9_PGC12_Q_FTRIM          (0x49)
#define REG_RFIC_L9_PGC12_Q_FTRIM_MASK     (0x1F)
#define REG_RFIC_L9_PGC12_Q_FTRIM_SHIFT    (0)
#define REG_RFIC_L9_PGC12_Q_FTRIM_WIDTH    (5)

/* L9_PGC12_I_FTRIM */
#define REG_RFIC_L9_PGC12_I_FTRIM          (0x49)
#define REG_RFIC_L9_PGC12_I_FTRIM_MASK     (0x3E0)
#define REG_RFIC_L9_PGC12_I_FTRIM_SHIFT    (5)
#define REG_RFIC_L9_PGC12_I_FTRIM_WIDTH    (5)

/* L9_EN_OC_FAST2 */
#define REG_RFIC_L9_EN_OC_FAST2          (0x49)
#define REG_RFIC_L9_EN_OC_FAST2_MASK     (0x400)
#define REG_RFIC_L9_EN_OC_FAST2_SHIFT    (10)
#define REG_RFIC_L9_EN_OC_FAST2_WIDTH    (1)

/* L9_EN_OC_FAST1 */
#define REG_RFIC_L9_EN_OC_FAST1          (0x49)
#define REG_RFIC_L9_EN_OC_FAST1_MASK     (0x800)
#define REG_RFIC_L9_EN_OC_FAST1_SHIFT    (11)
#define REG_RFIC_L9_EN_OC_FAST1_WIDTH    (1)

/* L9_SEL_IN_PGC12 */
#define REG_RFIC_L9_SEL_IN_PGC12          (0x49)
#define REG_RFIC_L9_SEL_IN_PGC12_MASK     (0x3000)
#define REG_RFIC_L9_SEL_IN_PGC12_SHIFT    (12)
#define REG_RFIC_L9_SEL_IN_PGC12_WIDTH    (2)

/* L9_NO_CFIX */
#define REG_RFIC_L9_NO_CFIX          (0x49)
#define REG_RFIC_L9_NO_CFIX_MASK     (0x4000)
#define REG_RFIC_L9_NO_CFIX_SHIFT    (14)
#define REG_RFIC_L9_NO_CFIX_WIDTH    (1)

/* L9_FMODE18 */
#define REG_RFIC_L9_FMODE18          (0x49)
#define REG_RFIC_L9_FMODE18_MASK     (0x8000)
#define REG_RFIC_L9_FMODE18_SHIFT    (15)
#define REG_RFIC_L9_FMODE18_WIDTH    (1)

/* L10_OPEN_RF_PGC1 */
#define REG_RFIC_L10_OPEN_RF_PGC1          (0x4A)
#define REG_RFIC_L10_OPEN_RF_PGC1_MASK     (0x1)
#define REG_RFIC_L10_OPEN_RF_PGC1_SHIFT    (0)
#define REG_RFIC_L10_OPEN_RF_PGC1_WIDTH    (1)

/* L10_OPEN_RF_PGC2 */
#define REG_RFIC_L10_OPEN_RF_PGC2          (0x4A)
#define REG_RFIC_L10_OPEN_RF_PGC2_MASK     (0x2)
#define REG_RFIC_L10_OPEN_RF_PGC2_SHIFT    (1)
#define REG_RFIC_L10_OPEN_RF_PGC2_WIDTH    (1)

/* L10_PROG_CUR_OC2_PGC2 */
#define REG_RFIC_L10_PROG_CUR_OC2_PGC2          (0x4A)
#define REG_RFIC_L10_PROG_CUR_OC2_PGC2_MASK     (0xC)
#define REG_RFIC_L10_PROG_CUR_OC2_PGC2_SHIFT    (2)
#define REG_RFIC_L10_PROG_CUR_OC2_PGC2_WIDTH    (2)

/* L10_PROG_CUR_OC1_PGC2 */
#define REG_RFIC_L10_PROG_CUR_OC1_PGC2          (0x4A)
#define REG_RFIC_L10_PROG_CUR_OC1_PGC2_MASK     (0x30)
#define REG_RFIC_L10_PROG_CUR_OC1_PGC2_SHIFT    (4)
#define REG_RFIC_L10_PROG_CUR_OC1_PGC2_WIDTH    (2)

/* L10_PROG_CUR_OC_PGC1 */
#define REG_RFIC_L10_PROG_CUR_OC_PGC1          (0x4A)
#define REG_RFIC_L10_PROG_CUR_OC_PGC1_MASK     (0xC0)
#define REG_RFIC_L10_PROG_CUR_OC_PGC1_SHIFT    (6)
#define REG_RFIC_L10_PROG_CUR_OC_PGC1_WIDTH    (2)

/* L10_EN_OC2_PGC2 */
#define REG_RFIC_L10_EN_OC2_PGC2          (0x4A)
#define REG_RFIC_L10_EN_OC2_PGC2_MASK     (0x100)
#define REG_RFIC_L10_EN_OC2_PGC2_SHIFT    (8)
#define REG_RFIC_L10_EN_OC2_PGC2_WIDTH    (1)

/* L10_EN_OC1_PGC2 */
#define REG_RFIC_L10_EN_OC1_PGC2          (0x4A)
#define REG_RFIC_L10_EN_OC1_PGC2_MASK     (0x200)
#define REG_RFIC_L10_EN_OC1_PGC2_SHIFT    (9)
#define REG_RFIC_L10_EN_OC1_PGC2_WIDTH    (1)

/* L10_EN_OP2_PGC2 */
#define REG_RFIC_L10_EN_OP2_PGC2          (0x4A)
#define REG_RFIC_L10_EN_OP2_PGC2_MASK     (0x400)
#define REG_RFIC_L10_EN_OP2_PGC2_SHIFT    (10)
#define REG_RFIC_L10_EN_OP2_PGC2_WIDTH    (1)

/* L10_EN_OP1_PGC2 */
#define REG_RFIC_L10_EN_OP1_PGC2          (0x4A)
#define REG_RFIC_L10_EN_OP1_PGC2_MASK     (0x800)
#define REG_RFIC_L10_EN_OP1_PGC2_SHIFT    (11)
#define REG_RFIC_L10_EN_OP1_PGC2_WIDTH    (1)

/* L10_EN_OC_PGC1 */
#define REG_RFIC_L10_EN_OC_PGC1          (0x4A)
#define REG_RFIC_L10_EN_OC_PGC1_MASK     (0x1000)
#define REG_RFIC_L10_EN_OC_PGC1_SHIFT    (12)
#define REG_RFIC_L10_EN_OC_PGC1_WIDTH    (1)

/* L10_EN_OFFC_BIAS_CUR */
#define REG_RFIC_L10_EN_OFFC_BIAS_CUR          (0x4A)
#define REG_RFIC_L10_EN_OFFC_BIAS_CUR_MASK     (0x2000)
#define REG_RFIC_L10_EN_OFFC_BIAS_CUR_SHIFT    (13)
#define REG_RFIC_L10_EN_OFFC_BIAS_CUR_WIDTH    (1)

/* L10_EN_OPAMPS_BIAS_CUR */
#define REG_RFIC_L10_EN_OPAMPS_BIAS_CUR          (0x4A)
#define REG_RFIC_L10_EN_OPAMPS_BIAS_CUR_MASK     (0x4000)
#define REG_RFIC_L10_EN_OPAMPS_BIAS_CUR_SHIFT    (14)
#define REG_RFIC_L10_EN_OPAMPS_BIAS_CUR_WIDTH    (1)

/* L10_EN_PGC1 */
#define REG_RFIC_L10_EN_PGC1          (0x4A)
#define REG_RFIC_L10_EN_PGC1_MASK     (0x8000)
#define REG_RFIC_L10_EN_PGC1_SHIFT    (15)
#define REG_RFIC_L10_EN_PGC1_WIDTH    (1)

/* L11_PGC2_SSB_DCOFF_Q */
#define REG_RFIC_L11_PGC2_SSB_DCOFF_Q          (0x4B)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_Q_MASK     (0x3E0)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_Q_SHIFT    (5)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_Q_WIDTH    (5)

/* L11_PGC2_SSB_DCOFF_I */
#define REG_RFIC_L11_PGC2_SSB_DCOFF_I          (0x4B)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_I_MASK     (0x7C00)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_I_SHIFT    (10)
#define REG_RFIC_L11_PGC2_SSB_DCOFF_I_WIDTH    (5)

/* L11_EN_SSBCAL */
#define REG_RFIC_L11_EN_SSBCAL          (0x4B)
#define REG_RFIC_L11_EN_SSBCAL_MASK     (0x8000)
#define REG_RFIC_L11_EN_SSBCAL_SHIFT    (15)
#define REG_RFIC_L11_EN_SSBCAL_WIDTH    (1)

/* L12_CNT_IBIAS */
#define REG_RFIC_L12_CNT_IBIAS          (0x4C)
#define REG_RFIC_L12_CNT_IBIAS_MASK     (0x3FFF)
#define REG_RFIC_L12_CNT_IBIAS_SHIFT    (0)
#define REG_RFIC_L12_CNT_IBIAS_WIDTH    (14)

/* L12_EN_VREF_0P5V */
#define REG_RFIC_L12_EN_VREF_0P5V          (0x4C)
#define REG_RFIC_L12_EN_VREF_0P5V_MASK     (0x4000)
#define REG_RFIC_L12_EN_VREF_0P5V_SHIFT    (14)
#define REG_RFIC_L12_EN_VREF_0P5V_WIDTH    (1)

/* L12_EN_VREF_0P6V */
#define REG_RFIC_L12_EN_VREF_0P6V          (0x4C)
#define REG_RFIC_L12_EN_VREF_0P6V_MASK     (0x8000)
#define REG_RFIC_L12_EN_VREF_0P6V_SHIFT    (15)
#define REG_RFIC_L12_EN_VREF_0P6V_WIDTH    (1)

/* L13_VCM_TRIM */
#define REG_RFIC_L13_VCM_TRIM          (0x4D)
#define REG_RFIC_L13_VCM_TRIM_MASK     (0x3F)
#define REG_RFIC_L13_VCM_TRIM_SHIFT    (0)
#define REG_RFIC_L13_VCM_TRIM_WIDTH    (6)

/* L13_SEL_CONST_PTAT */
#define REG_RFIC_L13_SEL_CONST_PTAT          (0x4D)
#define REG_RFIC_L13_SEL_CONST_PTAT_MASK     (0x3FC0)
#define REG_RFIC_L13_SEL_CONST_PTAT_SHIFT    (6)
#define REG_RFIC_L13_SEL_CONST_PTAT_WIDTH    (8)

/* L13_EN_IREF */
#define REG_RFIC_L13_EN_IREF          (0x4D)
#define REG_RFIC_L13_EN_IREF_MASK     (0x4000)
#define REG_RFIC_L13_EN_IREF_SHIFT    (14)
#define REG_RFIC_L13_EN_IREF_WIDTH    (1)

/* L13_EN_VREF_1P3V */
#define REG_RFIC_L13_EN_VREF_1P3V          (0x4D)
#define REG_RFIC_L13_EN_VREF_1P3V_MASK     (0x8000)
#define REG_RFIC_L13_EN_VREF_1P3V_SHIFT    (15)
#define REG_RFIC_L13_EN_VREF_1P3V_WIDTH    (1)

/* L14_EN */
#define REG_RFIC_L14_EN          (0x4E)
#define REG_RFIC_L14_EN_MASK     (0x1)
#define REG_RFIC_L14_EN_SHIFT    (0)
#define REG_RFIC_L14_EN_WIDTH    (1)

/* L14_SEL_SEL_RXTX */
#define REG_RFIC_L14_SEL_SEL_RXTX          (0x4E)
#define REG_RFIC_L14_SEL_SEL_RXTX_MASK     (0x2)
#define REG_RFIC_L14_SEL_SEL_RXTX_SHIFT    (1)
#define REG_RFIC_L14_SEL_SEL_RXTX_WIDTH    (1)

/* L14_SEL_FREQ_HB */
#define REG_RFIC_L14_SEL_FREQ_HB          (0x4E)
#define REG_RFIC_L14_SEL_FREQ_HB_MASK     (0x8)
#define REG_RFIC_L14_SEL_FREQ_HB_SHIFT    (3)
#define REG_RFIC_L14_SEL_FREQ_HB_WIDTH    (1)

/* L14_IB_CTRL */
#define REG_RFIC_L14_IB_CTRL          (0x4E)
#define REG_RFIC_L14_IB_CTRL_MASK     (0x70)
#define REG_RFIC_L14_IB_CTRL_SHIFT    (4)
#define REG_RFIC_L14_IB_CTRL_WIDTH    (3)

/* L14_LO_STR_HB */
#define REG_RFIC_L14_LO_STR_HB          (0x4E)
#define REG_RFIC_L14_LO_STR_HB_MASK     (0x180)
#define REG_RFIC_L14_LO_STR_HB_SHIFT    (7)
#define REG_RFIC_L14_LO_STR_HB_WIDTH    (2)

/* L15_RX_MIX_DCOFFS0_I */
#define REG_RFIC_L15_RX_MIX_DCOFFS0_I          (0x4F)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_I_MASK     (0x3F)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_I_SHIFT    (0)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_I_WIDTH    (6)

/* L15_RX_MIX_DCOFFS0_Q */
#define REG_RFIC_L15_RX_MIX_DCOFFS0_Q          (0x4F)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_Q_MASK     (0xFC0)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_Q_SHIFT    (6)
#define REG_RFIC_L15_RX_MIX_DCOFFS0_Q_WIDTH    (6)

/* L16_TPC_DCOFF_Q_GAIN0 */
#define REG_RFIC_L16_TPC_DCOFF_Q_GAIN0          (0x50)
#define REG_RFIC_L16_TPC_DCOFF_Q_GAIN0_MASK     (0x7F)
#define REG_RFIC_L16_TPC_DCOFF_Q_GAIN0_SHIFT    (0)
#define REG_RFIC_L16_TPC_DCOFF_Q_GAIN0_WIDTH    (7)

/* L16_TPC_DCOFF_I_GAIN0 */
#define REG_RFIC_L16_TPC_DCOFF_I_GAIN0          (0x50)
#define REG_RFIC_L16_TPC_DCOFF_I_GAIN0_MASK     (0x3F80)
#define REG_RFIC_L16_TPC_DCOFF_I_GAIN0_SHIFT    (7)
#define REG_RFIC_L16_TPC_DCOFF_I_GAIN0_WIDTH    (7)

/* L17_TPC_DCOFF_Q_GAIN1 */
#define REG_RFIC_L17_TPC_DCOFF_Q_GAIN1          (0x51)
#define REG_RFIC_L17_TPC_DCOFF_Q_GAIN1_MASK     (0x7F)
#define REG_RFIC_L17_TPC_DCOFF_Q_GAIN1_SHIFT    (0)
#define REG_RFIC_L17_TPC_DCOFF_Q_GAIN1_WIDTH    (7)

/* L17_TPC_DCOFF_I_GAIN1 */
#define REG_RFIC_L17_TPC_DCOFF_I_GAIN1          (0x51)
#define REG_RFIC_L17_TPC_DCOFF_I_GAIN1_MASK     (0x3F80)
#define REG_RFIC_L17_TPC_DCOFF_I_GAIN1_SHIFT    (7)
#define REG_RFIC_L17_TPC_DCOFF_I_GAIN1_WIDTH    (7)

/* L18_TPC_DCOFF_Q_GAIN2 */
#define REG_RFIC_L18_TPC_DCOFF_Q_GAIN2          (0x52)
#define REG_RFIC_L18_TPC_DCOFF_Q_GAIN2_MASK     (0x7F)
#define REG_RFIC_L18_TPC_DCOFF_Q_GAIN2_SHIFT    (0)
#define REG_RFIC_L18_TPC_DCOFF_Q_GAIN2_WIDTH    (7)

/* L18_TPC_DCOFF_I_GAIN2 */
#define REG_RFIC_L18_TPC_DCOFF_I_GAIN2          (0x52)
#define REG_RFIC_L18_TPC_DCOFF_I_GAIN2_MASK     (0x3F80)
#define REG_RFIC_L18_TPC_DCOFF_I_GAIN2_SHIFT    (7)
#define REG_RFIC_L18_TPC_DCOFF_I_GAIN2_WIDTH    (7)

/* L19_TPC_DCOFF_Q_GAIN3 */
#define REG_RFIC_L19_TPC_DCOFF_Q_GAIN3          (0x53)
#define REG_RFIC_L19_TPC_DCOFF_Q_GAIN3_MASK     (0x7F)
#define REG_RFIC_L19_TPC_DCOFF_Q_GAIN3_SHIFT    (0)
#define REG_RFIC_L19_TPC_DCOFF_Q_GAIN3_WIDTH    (7)

/* L19_TPC_DCOFF_I_GAIN3 */
#define REG_RFIC_L19_TPC_DCOFF_I_GAIN3          (0x53)
#define REG_RFIC_L19_TPC_DCOFF_I_GAIN3_MASK     (0x3F80)
#define REG_RFIC_L19_TPC_DCOFF_I_GAIN3_SHIFT    (7)
#define REG_RFIC_L19_TPC_DCOFF_I_GAIN3_WIDTH    (7)

/* L20_TPC_DCOFF_Q_GAIN4 */
#define REG_RFIC_L20_TPC_DCOFF_Q_GAIN4          (0x54)
#define REG_RFIC_L20_TPC_DCOFF_Q_GAIN4_MASK     (0x7F)
#define REG_RFIC_L20_TPC_DCOFF_Q_GAIN4_SHIFT    (0)
#define REG_RFIC_L20_TPC_DCOFF_Q_GAIN4_WIDTH    (7)

/* L20_TPC_DCOFF_I_GAIN4 */
#define REG_RFIC_L20_TPC_DCOFF_I_GAIN4          (0x54)
#define REG_RFIC_L20_TPC_DCOFF_I_GAIN4_MASK     (0x3F80)
#define REG_RFIC_L20_TPC_DCOFF_I_GAIN4_SHIFT    (7)
#define REG_RFIC_L20_TPC_DCOFF_I_GAIN4_WIDTH    (7)

/* L21_TPC_DCOFF_Q_GAIN5 */
#define REG_RFIC_L21_TPC_DCOFF_Q_GAIN5          (0x55)
#define REG_RFIC_L21_TPC_DCOFF_Q_GAIN5_MASK     (0x7F)
#define REG_RFIC_L21_TPC_DCOFF_Q_GAIN5_SHIFT    (0)
#define REG_RFIC_L21_TPC_DCOFF_Q_GAIN5_WIDTH    (7)

/* L21_TPC_DCOFF_I_GAIN5 */
#define REG_RFIC_L21_TPC_DCOFF_I_GAIN5          (0x55)
#define REG_RFIC_L21_TPC_DCOFF_I_GAIN5_MASK     (0x3F80)
#define REG_RFIC_L21_TPC_DCOFF_I_GAIN5_SHIFT    (7)
#define REG_RFIC_L21_TPC_DCOFF_I_GAIN5_WIDTH    (7)

/* L22_TPC_DCOFF_Q_GAIN6 */
#define REG_RFIC_L22_TPC_DCOFF_Q_GAIN6          (0x56)
#define REG_RFIC_L22_TPC_DCOFF_Q_GAIN6_MASK     (0x7F)
#define REG_RFIC_L22_TPC_DCOFF_Q_GAIN6_SHIFT    (0)
#define REG_RFIC_L22_TPC_DCOFF_Q_GAIN6_WIDTH    (7)

/* L22_TPC_DCOFF_I_GAIN6 */
#define REG_RFIC_L22_TPC_DCOFF_I_GAIN6          (0x56)
#define REG_RFIC_L22_TPC_DCOFF_I_GAIN6_MASK     (0x3F80)
#define REG_RFIC_L22_TPC_DCOFF_I_GAIN6_SHIFT    (7)
#define REG_RFIC_L22_TPC_DCOFF_I_GAIN6_WIDTH    (7)

/* L23_TPC_DCOFF_Q_GAIN7 */
#define REG_RFIC_L23_TPC_DCOFF_Q_GAIN7          (0x57)
#define REG_RFIC_L23_TPC_DCOFF_Q_GAIN7_MASK     (0x7F)
#define REG_RFIC_L23_TPC_DCOFF_Q_GAIN7_SHIFT    (0)
#define REG_RFIC_L23_TPC_DCOFF_Q_GAIN7_WIDTH    (7)

/* L23_TPC_DCOFF_I_GAIN7 */
#define REG_RFIC_L23_TPC_DCOFF_I_GAIN7          (0x57)
#define REG_RFIC_L23_TPC_DCOFF_I_GAIN7_MASK     (0x3F80)
#define REG_RFIC_L23_TPC_DCOFF_I_GAIN7_SHIFT    (7)
#define REG_RFIC_L23_TPC_DCOFF_I_GAIN7_WIDTH    (7)

/* L24_FTRIM_Q */
#define REG_RFIC_L24_FTRIM_Q          (0x58)
#define REG_RFIC_L24_FTRIM_Q_MASK     (0x1F)
#define REG_RFIC_L24_FTRIM_Q_SHIFT    (0)
#define REG_RFIC_L24_FTRIM_Q_WIDTH    (5)

/* L24_FTRIM_I */
#define REG_RFIC_L24_FTRIM_I          (0x58)
#define REG_RFIC_L24_FTRIM_I_MASK     (0x3E0)
#define REG_RFIC_L24_FTRIM_I_SHIFT    (5)
#define REG_RFIC_L24_FTRIM_I_WIDTH    (5)

/* L24_SEL_OPEN_SW_RXTX */
#define REG_RFIC_L24_SEL_OPEN_SW_RXTX          (0x58)
#define REG_RFIC_L24_SEL_OPEN_SW_RXTX_MASK     (0x400)
#define REG_RFIC_L24_SEL_OPEN_SW_RXTX_SHIFT    (10)
#define REG_RFIC_L24_SEL_OPEN_SW_RXTX_WIDTH    (1)

/* L24_SEL_OPEN_SW_DIRECT */
#define REG_RFIC_L24_SEL_OPEN_SW_DIRECT          (0x58)
#define REG_RFIC_L24_SEL_OPEN_SW_DIRECT_MASK     (0x800)
#define REG_RFIC_L24_SEL_OPEN_SW_DIRECT_SHIFT    (11)
#define REG_RFIC_L24_SEL_OPEN_SW_DIRECT_WIDTH    (1)

/* L24_OPEN_SW */
#define REG_RFIC_L24_OPEN_SW          (0x58)
#define REG_RFIC_L24_OPEN_SW_MASK     (0x1000)
#define REG_RFIC_L24_OPEN_SW_SHIFT    (12)
#define REG_RFIC_L24_OPEN_SW_WIDTH    (1)

/* L24_TEST_IQTPC */
#define REG_RFIC_L24_TEST_IQTPC          (0x58)
#define REG_RFIC_L24_TEST_IQTPC_MASK     (0x2000)
#define REG_RFIC_L24_TEST_IQTPC_SHIFT    (13)
#define REG_RFIC_L24_TEST_IQTPC_WIDTH    (1)

/* L24_FMODE18 */
#define REG_RFIC_L24_FMODE18          (0x58)
#define REG_RFIC_L24_FMODE18_MASK     (0x4000)
#define REG_RFIC_L24_FMODE18_SHIFT    (14)
#define REG_RFIC_L24_FMODE18_WIDTH    (1)

/* L24_EN */
#define REG_RFIC_L24_EN          (0x58)
#define REG_RFIC_L24_EN_MASK     (0x8000)
#define REG_RFIC_L24_EN_SHIFT    (15)
#define REG_RFIC_L24_EN_WIDTH    (1)

/* L25_BIAS2 */
#define REG_RFIC_L25_BIAS2          (0x59)
#define REG_RFIC_L25_BIAS2_MASK     (0x38)
#define REG_RFIC_L25_BIAS2_SHIFT    (3)
#define REG_RFIC_L25_BIAS2_WIDTH    (3)

/* L25_BIAS3 */
#define REG_RFIC_L25_BIAS3          (0x59)
#define REG_RFIC_L25_BIAS3_MASK     (0x1C0)
#define REG_RFIC_L25_BIAS3_SHIFT    (6)
#define REG_RFIC_L25_BIAS3_WIDTH    (3)

/* L26_DPTAT2 */
#define REG_RFIC_L26_DPTAT2          (0x5A)
#define REG_RFIC_L26_DPTAT2_MASK     (0xF0)
#define REG_RFIC_L26_DPTAT2_SHIFT    (4)
#define REG_RFIC_L26_DPTAT2_WIDTH    (4)

/* L26_DPTAT3 */
#define REG_RFIC_L26_DPTAT3          (0x5A)
#define REG_RFIC_L26_DPTAT3_MASK     (0xF00)
#define REG_RFIC_L26_DPTAT3_SHIFT    (8)
#define REG_RFIC_L26_DPTAT3_WIDTH    (4)

/* L27_PAD5G_BW */
#define REG_RFIC_L27_PAD5G_BW          (0x5B)
#define REG_RFIC_L27_PAD5G_BW_MASK     (0x7)
#define REG_RFIC_L27_PAD5G_BW_SHIFT    (0)
#define REG_RFIC_L27_PAD5G_BW_WIDTH    (3)

/* L27_EN_PAD */
#define REG_RFIC_L27_EN_PAD          (0x5B)
#define REG_RFIC_L27_EN_PAD_MASK     (0x8)
#define REG_RFIC_L27_EN_PAD_SHIFT    (3)
#define REG_RFIC_L27_EN_PAD_WIDTH    (1)

/* L28_EN_MIX */
#define REG_RFIC_L28_EN_MIX          (0x5C)
#define REG_RFIC_L28_EN_MIX_MASK     (0x2)
#define REG_RFIC_L28_EN_MIX_SHIFT    (1)
#define REG_RFIC_L28_EN_MIX_WIDTH    (1)

/* L28_WU_MIXER */
#define REG_RFIC_L28_WU_MIXER          (0x5C)
#define REG_RFIC_L28_WU_MIXER_MASK     (0x4)
#define REG_RFIC_L28_WU_MIXER_SHIFT    (2)
#define REG_RFIC_L28_WU_MIXER_WIDTH    (1)

/* L28_SEL_TX_LUT */
#define REG_RFIC_L28_SEL_TX_LUT          (0x5C)
#define REG_RFIC_L28_SEL_TX_LUT_MASK     (0x8)
#define REG_RFIC_L28_SEL_TX_LUT_SHIFT    (3)
#define REG_RFIC_L28_SEL_TX_LUT_WIDTH    (1)

/* L28_SWC1_MOD5G */
#define REG_RFIC_L28_SWC1_MOD5G          (0x5C)
#define REG_RFIC_L28_SWC1_MOD5G_MASK     (0x40)
#define REG_RFIC_L28_SWC1_MOD5G_SHIFT    (6)
#define REG_RFIC_L28_SWC1_MOD5G_WIDTH    (1)

/* L28_SWC2_MOD5G */
#define REG_RFIC_L28_SWC2_MOD5G          (0x5C)
#define REG_RFIC_L28_SWC2_MOD5G_MASK     (0x80)
#define REG_RFIC_L28_SWC2_MOD5G_SHIFT    (7)
#define REG_RFIC_L28_SWC2_MOD5G_WIDTH    (1)

/* L29_EN_TSSI */
#define REG_RFIC_L29_EN_TSSI          (0x5D)
#define REG_RFIC_L29_EN_TSSI_MASK     (0x1)
#define REG_RFIC_L29_EN_TSSI_SHIFT    (0)
#define REG_RFIC_L29_EN_TSSI_WIDTH    (1)

/* L29_ATT_TSSI */
#define REG_RFIC_L29_ATT_TSSI          (0x5D)
#define REG_RFIC_L29_ATT_TSSI_MASK     (0x2)
#define REG_RFIC_L29_ATT_TSSI_SHIFT    (1)
#define REG_RFIC_L29_ATT_TSSI_WIDTH    (1)

/* L29_GAIN */
#define REG_RFIC_L29_GAIN          (0x5D)
#define REG_RFIC_L29_GAIN_MASK     (0xC)
#define REG_RFIC_L29_GAIN_SHIFT    (2)
#define REG_RFIC_L29_GAIN_WIDTH    (2)

/* L29_TRIMBIAS */
#define REG_RFIC_L29_TRIMBIAS          (0x5D)
#define REG_RFIC_L29_TRIMBIAS_MASK     (0x70)
#define REG_RFIC_L29_TRIMBIAS_SHIFT    (4)
#define REG_RFIC_L29_TRIMBIAS_WIDTH    (3)

/* L29_EN_SSB_PAD2G */
#define REG_RFIC_L29_EN_SSB_PAD2G          (0x5D)
#define REG_RFIC_L29_EN_SSB_PAD2G_MASK     (0x80)
#define REG_RFIC_L29_EN_SSB_PAD2G_SHIFT    (7)
#define REG_RFIC_L29_EN_SSB_PAD2G_WIDTH    (1)

/* L29_EN_SSB_PAD5G */
#define REG_RFIC_L29_EN_SSB_PAD5G          (0x5D)
#define REG_RFIC_L29_EN_SSB_PAD5G_MASK     (0x100)
#define REG_RFIC_L29_EN_SSB_PAD5G_SHIFT    (8)
#define REG_RFIC_L29_EN_SSB_PAD5G_WIDTH    (1)

/* L29_EN_SSB_PA2G */
#define REG_RFIC_L29_EN_SSB_PA2G          (0x5D)
#define REG_RFIC_L29_EN_SSB_PA2G_MASK     (0x200)
#define REG_RFIC_L29_EN_SSB_PA2G_SHIFT    (9)
#define REG_RFIC_L29_EN_SSB_PA2G_WIDTH    (1)

/* L29_EN_SSI_FAST_CTRL */
#define REG_RFIC_L29_EN_SSI_FAST_CTRL          (0x5D)
#define REG_RFIC_L29_EN_SSI_FAST_CTRL_MASK     (0x400)
#define REG_RFIC_L29_EN_SSI_FAST_CTRL_SHIFT    (10)
#define REG_RFIC_L29_EN_SSI_FAST_CTRL_WIDTH    (1)

/* L30_EN */
#define REG_RFIC_L30_EN          (0x5E)
#define REG_RFIC_L30_EN_MASK     (0x1)
#define REG_RFIC_L30_EN_SHIFT    (0)
#define REG_RFIC_L30_EN_WIDTH    (1)

/* L30_PRG1V0 */
#define REG_RFIC_L30_PRG1V0          (0x5E)
#define REG_RFIC_L30_PRG1V0_MASK     (0xE)
#define REG_RFIC_L30_PRG1V0_SHIFT    (1)
#define REG_RFIC_L30_PRG1V0_WIDTH    (3)

/* L30_PRG_RDG */
#define REG_RFIC_L30_PRG_RDG          (0x5E)
#define REG_RFIC_L30_PRG_RDG_MASK     (0xF0)
#define REG_RFIC_L30_PRG_RDG_SHIFT    (4)
#define REG_RFIC_L30_PRG_RDG_WIDTH    (4)

/* L30_DISABLERPAR */
#define REG_RFIC_L30_DISABLERPAR          (0x5E)
#define REG_RFIC_L30_DISABLERPAR_MASK     (0x100)
#define REG_RFIC_L30_DISABLERPAR_SHIFT    (8)
#define REG_RFIC_L30_DISABLERPAR_WIDTH    (1)

/* L30_PRGGMFF */
#define REG_RFIC_L30_PRGGMFF          (0x5E)
#define REG_RFIC_L30_PRGGMFF_MASK     (0xE00)
#define REG_RFIC_L30_PRGGMFF_SHIFT    (9)
#define REG_RFIC_L30_PRGGMFF_WIDTH    (3)

/* L30_PRGIBIAS */
#define REG_RFIC_L30_PRGIBIAS          (0x5E)
#define REG_RFIC_L30_PRGIBIAS_MASK     (0x3000)
#define REG_RFIC_L30_PRGIBIAS_SHIFT    (12)
#define REG_RFIC_L30_PRGIBIAS_WIDTH    (2)

/* L31_EN */
#define REG_RFIC_L31_EN          (0x5F)
#define REG_RFIC_L31_EN_MASK     (0x1)
#define REG_RFIC_L31_EN_SHIFT    (0)
#define REG_RFIC_L31_EN_WIDTH    (1)

/* L31_PRG1V0 */
#define REG_RFIC_L31_PRG1V0          (0x5F)
#define REG_RFIC_L31_PRG1V0_MASK     (0xE)
#define REG_RFIC_L31_PRG1V0_SHIFT    (1)
#define REG_RFIC_L31_PRG1V0_WIDTH    (3)

/* L31_PRG_RDG */
#define REG_RFIC_L31_PRG_RDG          (0x5F)
#define REG_RFIC_L31_PRG_RDG_MASK     (0xF0)
#define REG_RFIC_L31_PRG_RDG_SHIFT    (4)
#define REG_RFIC_L31_PRG_RDG_WIDTH    (4)

/* L31_DISABLERPAR */
#define REG_RFIC_L31_DISABLERPAR          (0x5F)
#define REG_RFIC_L31_DISABLERPAR_MASK     (0x100)
#define REG_RFIC_L31_DISABLERPAR_SHIFT    (8)
#define REG_RFIC_L31_DISABLERPAR_WIDTH    (1)

/* L31_PRGGMFF */
#define REG_RFIC_L31_PRGGMFF          (0x5F)
#define REG_RFIC_L31_PRGGMFF_MASK     (0xE00)
#define REG_RFIC_L31_PRGGMFF_SHIFT    (9)
#define REG_RFIC_L31_PRGGMFF_WIDTH    (3)

/* L31_PRGIBIAS */
#define REG_RFIC_L31_PRGIBIAS          (0x5F)
#define REG_RFIC_L31_PRGIBIAS_MASK     (0x3000)
#define REG_RFIC_L31_PRGIBIAS_SHIFT    (12)
#define REG_RFIC_L31_PRGIBIAS_WIDTH    (2)

/* L32_SEL40 */
#define REG_RFIC_L32_SEL40          (0x60)
#define REG_RFIC_L32_SEL40_MASK     (0x1)
#define REG_RFIC_L32_SEL40_SHIFT    (0)
#define REG_RFIC_L32_SEL40_WIDTH    (1)

/* L32_FMODE */
#define REG_RFIC_L32_FMODE          (0x60)
#define REG_RFIC_L32_FMODE_MASK     (0x2)
#define REG_RFIC_L32_FMODE_SHIFT    (1)
#define REG_RFIC_L32_FMODE_WIDTH    (1)

/* L32_EN_PGC3 */
#define REG_RFIC_L32_EN_PGC3          (0x60)
#define REG_RFIC_L32_EN_PGC3_MASK     (0x4)
#define REG_RFIC_L32_EN_PGC3_SHIFT    (2)
#define REG_RFIC_L32_EN_PGC3_WIDTH    (1)

/* L32_OPEN_RF_PGC3 */
#define REG_RFIC_L32_OPEN_RF_PGC3          (0x60)
#define REG_RFIC_L32_OPEN_RF_PGC3_MASK     (0x8)
#define REG_RFIC_L32_OPEN_RF_PGC3_SHIFT    (3)
#define REG_RFIC_L32_OPEN_RF_PGC3_WIDTH    (1)

/* L32_SEL_IN_PGC3 */
#define REG_RFIC_L32_SEL_IN_PGC3          (0x60)
#define REG_RFIC_L32_SEL_IN_PGC3_MASK     (0x30)
#define REG_RFIC_L32_SEL_IN_PGC3_SHIFT    (4)
#define REG_RFIC_L32_SEL_IN_PGC3_WIDTH    (2)

/* L32_SEL_OPENRF_RXTX */
#define REG_RFIC_L32_SEL_OPENRF_RXTX          (0x60)
#define REG_RFIC_L32_SEL_OPENRF_RXTX_MASK     (0x40)
#define REG_RFIC_L32_SEL_OPENRF_RXTX_SHIFT    (6)
#define REG_RFIC_L32_SEL_OPENRF_RXTX_WIDTH    (1)

/* L32_SEL_OPENRF_DIRECT */
#define REG_RFIC_L32_SEL_OPENRF_DIRECT          (0x60)
#define REG_RFIC_L32_SEL_OPENRF_DIRECT_MASK     (0x80)
#define REG_RFIC_L32_SEL_OPENRF_DIRECT_SHIFT    (7)
#define REG_RFIC_L32_SEL_OPENRF_DIRECT_WIDTH    (1)

/* L33_FTRIM_I */
#define REG_RFIC_L33_FTRIM_I          (0x61)
#define REG_RFIC_L33_FTRIM_I_MASK     (0x1F)
#define REG_RFIC_L33_FTRIM_I_SHIFT    (0)
#define REG_RFIC_L33_FTRIM_I_WIDTH    (5)

/* L33_FTRIM_Q */
#define REG_RFIC_L33_FTRIM_Q          (0x61)
#define REG_RFIC_L33_FTRIM_Q_MASK     (0x3E0)
#define REG_RFIC_L33_FTRIM_Q_SHIFT    (5)
#define REG_RFIC_L33_FTRIM_Q_WIDTH    (5)

/* L33_SEL_2M5_I */
#define REG_RFIC_L33_SEL_2M5_I          (0x61)
#define REG_RFIC_L33_SEL_2M5_I_MASK     (0x400)
#define REG_RFIC_L33_SEL_2M5_I_SHIFT    (10)
#define REG_RFIC_L33_SEL_2M5_I_WIDTH    (1)

/* L33_EN_SEBUF */
#define REG_RFIC_L33_EN_SEBUF          (0x61)
#define REG_RFIC_L33_EN_SEBUF_MASK     (0x800)
#define REG_RFIC_L33_EN_SEBUF_SHIFT    (11)
#define REG_RFIC_L33_EN_SEBUF_WIDTH    (1)

/* L33_CAL_INV_I */
#define REG_RFIC_L33_CAL_INV_I          (0x61)
#define REG_RFIC_L33_CAL_INV_I_MASK     (0x1000)
#define REG_RFIC_L33_CAL_INV_I_SHIFT    (12)
#define REG_RFIC_L33_CAL_INV_I_WIDTH    (1)

/* L33_SEL1_I */
#define REG_RFIC_L33_SEL1_I          (0x61)
#define REG_RFIC_L33_SEL1_I_MASK     (0x2000)
#define REG_RFIC_L33_SEL1_I_SHIFT    (13)
#define REG_RFIC_L33_SEL1_I_WIDTH    (1)

/* L33_SEL2_I */
#define REG_RFIC_L33_SEL2_I          (0x61)
#define REG_RFIC_L33_SEL2_I_MASK     (0x4000)
#define REG_RFIC_L33_SEL2_I_SHIFT    (14)
#define REG_RFIC_L33_SEL2_I_WIDTH    (1)

/* L33_EN_FAST_CTRL */
#define REG_RFIC_L33_EN_FAST_CTRL          (0x61)
#define REG_RFIC_L33_EN_FAST_CTRL_MASK     (0x8000)
#define REG_RFIC_L33_EN_FAST_CTRL_SHIFT    (15)
#define REG_RFIC_L33_EN_FAST_CTRL_WIDTH    (1)

/* L34_VCM_TRIM */
#define REG_RFIC_L34_VCM_TRIM          (0x62)
#define REG_RFIC_L34_VCM_TRIM_MASK     (0x3)
#define REG_RFIC_L34_VCM_TRIM_SHIFT    (0)
#define REG_RFIC_L34_VCM_TRIM_WIDTH    (2)

/* L34_EN_VCM_BUF */
#define REG_RFIC_L34_EN_VCM_BUF          (0x62)
#define REG_RFIC_L34_EN_VCM_BUF_MASK     (0x4)
#define REG_RFIC_L34_EN_VCM_BUF_SHIFT    (2)
#define REG_RFIC_L34_EN_VCM_BUF_WIDTH    (1)

/* L34_PR_VCMBUF_IB */
#define REG_RFIC_L34_PR_VCMBUF_IB          (0x62)
#define REG_RFIC_L34_PR_VCMBUF_IB_MASK     (0x18)
#define REG_RFIC_L34_PR_VCMBUF_IB_SHIFT    (3)
#define REG_RFIC_L34_PR_VCMBUF_IB_WIDTH    (2)

/* L34_PR_SEBUF_IB */
#define REG_RFIC_L34_PR_SEBUF_IB          (0x62)
#define REG_RFIC_L34_PR_SEBUF_IB_MASK     (0x60)
#define REG_RFIC_L34_PR_SEBUF_IB_SHIFT    (5)
#define REG_RFIC_L34_PR_SEBUF_IB_WIDTH    (2)

/* L34_PR_PGC3_IB */
#define REG_RFIC_L34_PR_PGC3_IB          (0x62)
#define REG_RFIC_L34_PR_PGC3_IB_MASK     (0x180)
#define REG_RFIC_L34_PR_PGC3_IB_SHIFT    (7)
#define REG_RFIC_L34_PR_PGC3_IB_WIDTH    (2)

/* L34_PR_I75PERCENT */
#define REG_RFIC_L34_PR_I75PERCENT          (0x62)
#define REG_RFIC_L34_PR_I75PERCENT_MASK     (0x200)
#define REG_RFIC_L34_PR_I75PERCENT_SHIFT    (9)
#define REG_RFIC_L34_PR_I75PERCENT_WIDTH    (1)

/* L34_EN_MIRROR */
#define REG_RFIC_L34_EN_MIRROR          (0x62)
#define REG_RFIC_L34_EN_MIRROR_MASK     (0x400)
#define REG_RFIC_L34_EN_MIRROR_SHIFT    (10)
#define REG_RFIC_L34_EN_MIRROR_WIDTH    (1)

/* L35_PLL_SEL_VCO_O */
#define REG_RFIC_L35_PLL_SEL_VCO_O          (0x63)
#define REG_RFIC_L35_PLL_SEL_VCO_O_MASK     (0x1F)
#define REG_RFIC_L35_PLL_SEL_VCO_O_SHIFT    (0)
#define REG_RFIC_L35_PLL_SEL_VCO_O_WIDTH    (5)

/* L35_PLL_STARTUP_O */
#define REG_RFIC_L35_PLL_STARTUP_O          (0x63)
#define REG_RFIC_L35_PLL_STARTUP_O_MASK     (0x60)
#define REG_RFIC_L35_PLL_STARTUP_O_SHIFT    (5)
#define REG_RFIC_L35_PLL_STARTUP_O_WIDTH    (2)

/* L35_PLL_FREQLOCK_O */
#define REG_RFIC_L35_PLL_FREQLOCK_O          (0x63)
#define REG_RFIC_L35_PLL_FREQLOCK_O_MASK     (0x80)
#define REG_RFIC_L35_PLL_FREQLOCK_O_SHIFT    (7)
#define REG_RFIC_L35_PLL_FREQLOCK_O_WIDTH    (1)

/* L35_PLL_CP_SEL_MON_O */
#define REG_RFIC_L35_PLL_CP_SEL_MON_O          (0x63)
#define REG_RFIC_L35_PLL_CP_SEL_MON_O_MASK     (0x3F00)
#define REG_RFIC_L35_PLL_CP_SEL_MON_O_SHIFT    (8)
#define REG_RFIC_L35_PLL_CP_SEL_MON_O_WIDTH    (6)

/* L40_SEL_BAND */
#define REG_RFIC_L40_SEL_BAND          (0x68)
#define REG_RFIC_L40_SEL_BAND_MASK     (0x1)
#define REG_RFIC_L40_SEL_BAND_SHIFT    (0)
#define REG_RFIC_L40_SEL_BAND_WIDTH    (1)

/* L40_CH2_OFF */
#define REG_RFIC_L40_CH2_OFF          (0x68)
#define REG_RFIC_L40_CH2_OFF_MASK     (0x2)
#define REG_RFIC_L40_CH2_OFF_SHIFT    (1)
#define REG_RFIC_L40_CH2_OFF_WIDTH    (1)

/* L40_TEST_MODE_SEL */
#define REG_RFIC_L40_TEST_MODE_SEL          (0x68)
#define REG_RFIC_L40_TEST_MODE_SEL_MASK     (0x1C)
#define REG_RFIC_L40_TEST_MODE_SEL_SHIFT    (2)
#define REG_RFIC_L40_TEST_MODE_SEL_WIDTH    (3)

/* L40_DS_FECTRL */
#define REG_RFIC_L40_DS_FECTRL          (0x68)
#define REG_RFIC_L40_DS_FECTRL_MASK     (0xE0)
#define REG_RFIC_L40_DS_FECTRL_SHIFT    (5)
#define REG_RFIC_L40_DS_FECTRL_WIDTH    (3)

/* L40_DS_FCSI_DATA_IO */
#define REG_RFIC_L40_DS_FCSI_DATA_IO          (0x68)
#define REG_RFIC_L40_DS_FCSI_DATA_IO_MASK     (0x100)
#define REG_RFIC_L40_DS_FCSI_DATA_IO_SHIFT    (8)
#define REG_RFIC_L40_DS_FCSI_DATA_IO_WIDTH    (1)

/* L41_VERSION */
#define REG_RFIC_L41_VERSION          (0x69)
#define REG_RFIC_L41_VERSION_MASK     (0x7FF)
#define REG_RFIC_L41_VERSION_SHIFT    (0)
#define REG_RFIC_L41_VERSION_WIDTH    (11)

/* L41_BC_EN_CH2 */
#define REG_RFIC_L41_BC_EN_CH2          (0x69)
#define REG_RFIC_L41_BC_EN_CH2_MASK     (0x800)
#define REG_RFIC_L41_BC_EN_CH2_SHIFT    (11)
#define REG_RFIC_L41_BC_EN_CH2_WIDTH    (1)

/* L41_BC_EN_2G_INTPA */
#define REG_RFIC_L41_BC_EN_2G_INTPA          (0x69)
#define REG_RFIC_L41_BC_EN_2G_INTPA_MASK     (0x1000)
#define REG_RFIC_L41_BC_EN_2G_INTPA_SHIFT    (12)
#define REG_RFIC_L41_BC_EN_2G_INTPA_WIDTH    (1)

/* L41_BC_EN_2G */
#define REG_RFIC_L41_BC_EN_2G          (0x69)
#define REG_RFIC_L41_BC_EN_2G_MASK     (0x2000)
#define REG_RFIC_L41_BC_EN_2G_SHIFT    (13)
#define REG_RFIC_L41_BC_EN_2G_WIDTH    (1)

/* L41_BC_EN_5G */
#define REG_RFIC_L41_BC_EN_5G          (0x69)
#define REG_RFIC_L41_BC_EN_5G_MASK     (0x4000)
#define REG_RFIC_L41_BC_EN_5G_SHIFT    (14)
#define REG_RFIC_L41_BC_EN_5G_WIDTH    (1)

/* L48_LDO_VREF_2V5_SEL_I */
#define REG_RFIC_L48_LDO_VREF_2V5_SEL_I          (0x70)
#define REG_RFIC_L48_LDO_VREF_2V5_SEL_I_MASK     (0x7)
#define REG_RFIC_L48_LDO_VREF_2V5_SEL_I_SHIFT    (0)
#define REG_RFIC_L48_LDO_VREF_2V5_SEL_I_WIDTH    (3)

/* L48_LDO_VREF_1V5_SEL_I */
#define REG_RFIC_L48_LDO_VREF_1V5_SEL_I          (0x70)
#define REG_RFIC_L48_LDO_VREF_1V5_SEL_I_MASK     (0x38)
#define REG_RFIC_L48_LDO_VREF_1V5_SEL_I_SHIFT    (3)
#define REG_RFIC_L48_LDO_VREF_1V5_SEL_I_WIDTH    (3)

/* L48_LDO_VREF_1V2_SEL_I */
#define REG_RFIC_L48_LDO_VREF_1V2_SEL_I          (0x70)
#define REG_RFIC_L48_LDO_VREF_1V2_SEL_I_MASK     (0x1C0)
#define REG_RFIC_L48_LDO_VREF_1V2_SEL_I_SHIFT    (6)
#define REG_RFIC_L48_LDO_VREF_1V2_SEL_I_WIDTH    (3)

/* L48_PON_LDO_1V2 */
#define REG_RFIC_L48_PON_LDO_1V2          (0x70)
#define REG_RFIC_L48_PON_LDO_1V2_MASK     (0x200)
#define REG_RFIC_L48_PON_LDO_1V2_SHIFT    (9)
#define REG_RFIC_L48_PON_LDO_1V2_WIDTH    (1)

/* L48_PON_LDO_1V5 */
#define REG_RFIC_L48_PON_LDO_1V5          (0x70)
#define REG_RFIC_L48_PON_LDO_1V5_MASK     (0x400)
#define REG_RFIC_L48_PON_LDO_1V5_SHIFT    (10)
#define REG_RFIC_L48_PON_LDO_1V5_WIDTH    (1)

/* L48_PON_LDO_2V5 */
#define REG_RFIC_L48_PON_LDO_2V5          (0x70)
#define REG_RFIC_L48_PON_LDO_2V5_MASK     (0x800)
#define REG_RFIC_L48_PON_LDO_2V5_SHIFT    (11)
#define REG_RFIC_L48_PON_LDO_2V5_WIDTH    (1)

/* L48_RFPLL_PON */
#define REG_RFIC_L48_RFPLL_PON          (0x70)
#define REG_RFIC_L48_RFPLL_PON_MASK     (0x1000)
#define REG_RFIC_L48_RFPLL_PON_SHIFT    (12)
#define REG_RFIC_L48_RFPLL_PON_WIDTH    (1)

/* L48_PON_LF */
#define REG_RFIC_L48_PON_LF          (0x70)
#define REG_RFIC_L48_PON_LF_MASK     (0x2000)
#define REG_RFIC_L48_PON_LF_SHIFT    (13)
#define REG_RFIC_L48_PON_LF_WIDTH    (1)

/* L48_PON_REFCLKMUX */
#define REG_RFIC_L48_PON_REFCLKMUX          (0x70)
#define REG_RFIC_L48_PON_REFCLKMUX_MASK     (0x4000)
#define REG_RFIC_L48_PON_REFCLKMUX_SHIFT    (14)
#define REG_RFIC_L48_PON_REFCLKMUX_WIDTH    (1)

/* L48_PON_VREFS */
#define REG_RFIC_L48_PON_VREFS          (0x70)
#define REG_RFIC_L48_PON_VREFS_MASK     (0x8000)
#define REG_RFIC_L48_PON_VREFS_SHIFT    (15)
#define REG_RFIC_L48_PON_VREFS_WIDTH    (1)

/* L49_TRIM_DCXO */
#define REG_RFIC_L49_TRIM_DCXO          (0x71)
#define REG_RFIC_L49_TRIM_DCXO_MASK     (0x1FF)
#define REG_RFIC_L49_TRIM_DCXO_SHIFT    (0)
#define REG_RFIC_L49_TRIM_DCXO_WIDTH    (9)

/* L49_TRIM_SUP15PF */
#define REG_RFIC_L49_TRIM_SUP15PF          (0x71)
#define REG_RFIC_L49_TRIM_SUP15PF_MASK     (0x200)
#define REG_RFIC_L49_TRIM_SUP15PF_SHIFT    (9)
#define REG_RFIC_L49_TRIM_SUP15PF_WIDTH    (1)

/* L49_CFG_BIASREG */
#define REG_RFIC_L49_CFG_BIASREG          (0x71)
#define REG_RFIC_L49_CFG_BIASREG_MASK     (0x7C00)
#define REG_RFIC_L49_CFG_BIASREG_SHIFT    (10)
#define REG_RFIC_L49_CFG_BIASREG_WIDTH    (5)

/* L49_EN_CLK_RFPLL */
#define REG_RFIC_L49_EN_CLK_RFPLL          (0x71)
#define REG_RFIC_L49_EN_CLK_RFPLL_MASK     (0x8000)
#define REG_RFIC_L49_EN_CLK_RFPLL_SHIFT    (15)
#define REG_RFIC_L49_EN_CLK_RFPLL_WIDTH    (1)

/* L50_CFG_DET */
#define REG_RFIC_L50_CFG_DET          (0x72)
#define REG_RFIC_L50_CFG_DET_MASK     (0x3)
#define REG_RFIC_L50_CFG_DET_SHIFT    (0)
#define REG_RFIC_L50_CFG_DET_WIDTH    (2)

/* L50_BIAS_REG_MODE */
#define REG_RFIC_L50_BIAS_REG_MODE          (0x72)
#define REG_RFIC_L50_BIAS_REG_MODE_MASK     (0x4)
#define REG_RFIC_L50_BIAS_REG_MODE_SHIFT    (2)
#define REG_RFIC_L50_BIAS_REG_MODE_WIDTH    (1)

/* L50_CFG_SHAPER */
#define REG_RFIC_L50_CFG_SHAPER          (0x72)
#define REG_RFIC_L50_CFG_SHAPER_MASK     (0x8)
#define REG_RFIC_L50_CFG_SHAPER_SHIFT    (3)
#define REG_RFIC_L50_CFG_SHAPER_WIDTH    (1)

/* L50_CFG_READY */
#define REG_RFIC_L50_CFG_READY          (0x72)
#define REG_RFIC_L50_CFG_READY_MASK     (0x30)
#define REG_RFIC_L50_CFG_READY_SHIFT    (4)
#define REG_RFIC_L50_CFG_READY_WIDTH    (2)

/* L50_CLKFSYS_DISABLE */
#define REG_RFIC_L50_CLKFSYS_DISABLE          (0x72)
#define REG_RFIC_L50_CLKFSYS_DISABLE_MASK     (0x40)
#define REG_RFIC_L50_CLKFSYS_DISABLE_SHIFT    (6)
#define REG_RFIC_L50_CLKFSYS_DISABLE_WIDTH    (1)

/* L50_DIS_FSYS */
#define REG_RFIC_L50_DIS_FSYS          (0x72)
#define REG_RFIC_L50_DIS_FSYS_MASK     (0x80)
#define REG_RFIC_L50_DIS_FSYS_SHIFT    (7)
#define REG_RFIC_L50_DIS_FSYS_WIDTH    (1)

/* L50_CFG_CUR_XO */
#define REG_RFIC_L50_CFG_CUR_XO          (0x72)
#define REG_RFIC_L50_CFG_CUR_XO_MASK     (0x300)
#define REG_RFIC_L50_CFG_CUR_XO_SHIFT    (8)
#define REG_RFIC_L50_CFG_CUR_XO_WIDTH    (2)

/* L50_POR_EN */
#define REG_RFIC_L50_POR_EN          (0x72)
#define REG_RFIC_L50_POR_EN_MASK     (0x400)
#define REG_RFIC_L50_POR_EN_SHIFT    (10)
#define REG_RFIC_L50_POR_EN_WIDTH    (1)

/* L50_TRIM_FSYS */
#define REG_RFIC_L50_TRIM_FSYS          (0x72)
#define REG_RFIC_L50_TRIM_FSYS_MASK     (0x7800)
#define REG_RFIC_L50_TRIM_FSYS_SHIFT    (11)
#define REG_RFIC_L50_TRIM_FSYS_WIDTH    (4)

/* L50_XO_RDY_EN */
#define REG_RFIC_L50_XO_RDY_EN          (0x72)
#define REG_RFIC_L50_XO_RDY_EN_MASK     (0x8000)
#define REG_RFIC_L50_XO_RDY_EN_SHIFT    (15)
#define REG_RFIC_L50_XO_RDY_EN_WIDTH    (1)

/* L51_EN_BGP */
#define REG_RFIC_L51_EN_BGP          (0x73)
#define REG_RFIC_L51_EN_BGP_MASK     (0x1)
#define REG_RFIC_L51_EN_BGP_SHIFT    (0)
#define REG_RFIC_L51_EN_BGP_WIDTH    (1)

/* L51_BGP_TRIM */
#define REG_RFIC_L51_BGP_TRIM          (0x73)
#define REG_RFIC_L51_BGP_TRIM_MASK     (0x1E)
#define REG_RFIC_L51_BGP_TRIM_SHIFT    (1)
#define REG_RFIC_L51_BGP_TRIM_WIDTH    (4)

/* L51_BGP_TEMP_COEFF */
#define REG_RFIC_L51_BGP_TEMP_COEFF          (0x73)
#define REG_RFIC_L51_BGP_TEMP_COEFF_MASK     (0x60)
#define REG_RFIC_L51_BGP_TEMP_COEFF_SHIFT    (5)
#define REG_RFIC_L51_BGP_TEMP_COEFF_WIDTH    (2)

/* L51_CAL_ICONST */
#define REG_RFIC_L51_CAL_ICONST          (0x73)
#define REG_RFIC_L51_CAL_ICONST_MASK     (0xF80)
#define REG_RFIC_L51_CAL_ICONST_SHIFT    (7)
#define REG_RFIC_L51_CAL_ICONST_WIDTH    (5)

/* L51_EN_V2I_CONST */
#define REG_RFIC_L51_EN_V2I_CONST          (0x73)
#define REG_RFIC_L51_EN_V2I_CONST_MASK     (0x1000)
#define REG_RFIC_L51_EN_V2I_CONST_SHIFT    (12)
#define REG_RFIC_L51_EN_V2I_CONST_WIDTH    (1)

/* L51_EN_V2I_CAL */
#define REG_RFIC_L51_EN_V2I_CAL          (0x73)
#define REG_RFIC_L51_EN_V2I_CAL_MASK     (0x2000)
#define REG_RFIC_L51_EN_V2I_CAL_SHIFT    (13)
#define REG_RFIC_L51_EN_V2I_CAL_WIDTH    (1)

/* L51_CAL_ICONST_COMP_O */
#define REG_RFIC_L51_CAL_ICONST_COMP_O          (0x73)
#define REG_RFIC_L51_CAL_ICONST_COMP_O_MASK     (0x4000)
#define REG_RFIC_L51_CAL_ICONST_COMP_O_SHIFT    (14)
#define REG_RFIC_L51_CAL_ICONST_COMP_O_WIDTH    (1)

/* L51_BGP_RDY_O */
#define REG_RFIC_L51_BGP_RDY_O          (0x73)
#define REG_RFIC_L51_BGP_RDY_O_MASK     (0x8000)
#define REG_RFIC_L51_BGP_RDY_O_SHIFT    (15)
#define REG_RFIC_L51_BGP_RDY_O_WIDTH    (1)

/* L52_PRG1V0 */
#define REG_RFIC_L52_PRG1V0          (0x74)
#define REG_RFIC_L52_PRG1V0_MASK     (0x7)
#define REG_RFIC_L52_PRG1V0_SHIFT    (0)
#define REG_RFIC_L52_PRG1V0_WIDTH    (3)

/* L52_PRG_RDG */
#define REG_RFIC_L52_PRG_RDG          (0x74)
#define REG_RFIC_L52_PRG_RDG_MASK     (0x78)
#define REG_RFIC_L52_PRG_RDG_SHIFT    (3)
#define REG_RFIC_L52_PRG_RDG_WIDTH    (4)

/* L52_DISABLERPAR */
#define REG_RFIC_L52_DISABLERPAR          (0x74)
#define REG_RFIC_L52_DISABLERPAR_MASK     (0x80)
#define REG_RFIC_L52_DISABLERPAR_SHIFT    (7)
#define REG_RFIC_L52_DISABLERPAR_WIDTH    (1)

/* L52_PRGGMFF */
#define REG_RFIC_L52_PRGGMFF          (0x74)
#define REG_RFIC_L52_PRGGMFF_MASK     (0x700)
#define REG_RFIC_L52_PRGGMFF_SHIFT    (8)
#define REG_RFIC_L52_PRGGMFF_WIDTH    (3)

/* L52_PRGIBIAS */
#define REG_RFIC_L52_PRGIBIAS          (0x74)
#define REG_RFIC_L52_PRGIBIAS_MASK     (0x1800)
#define REG_RFIC_L52_PRGIBIAS_SHIFT    (11)
#define REG_RFIC_L52_PRGIBIAS_WIDTH    (2)

/* L52_SOFT_RESET */
#define REG_RFIC_L52_SOFT_RESET          (0x74)
#define REG_RFIC_L52_SOFT_RESET_MASK     (0x2000)
#define REG_RFIC_L52_SOFT_RESET_SHIFT    (13)
#define REG_RFIC_L52_SOFT_RESET_WIDTH    (1)

/* L52_PLL_RESET_N */
#define REG_RFIC_L52_PLL_RESET_N          (0x74)
#define REG_RFIC_L52_PLL_RESET_N_MASK     (0x4000)
#define REG_RFIC_L52_PLL_RESET_N_SHIFT    (14)
#define REG_RFIC_L52_PLL_RESET_N_WIDTH    (1)

/* L52_EN_V2I_REF */
#define REG_RFIC_L52_EN_V2I_REF          (0x74)
#define REG_RFIC_L52_EN_V2I_REF_MASK     (0x8000)
#define REG_RFIC_L52_EN_V2I_REF_SHIFT    (15)
#define REG_RFIC_L52_EN_V2I_REF_WIDTH    (1)

/* L53_PROG_FCSI_LDO */
#define REG_RFIC_L53_PROG_FCSI_LDO          (0x75)
#define REG_RFIC_L53_PROG_FCSI_LDO_MASK     (0xF)
#define REG_RFIC_L53_PROG_FCSI_LDO_SHIFT    (0)
#define REG_RFIC_L53_PROG_FCSI_LDO_WIDTH    (4)

/* L53_BYP_RESET_SPIKE_FILTER */
#define REG_RFIC_L53_BYP_RESET_SPIKE_FILTER          (0x75)
#define REG_RFIC_L53_BYP_RESET_SPIKE_FILTER_MASK     (0x10)
#define REG_RFIC_L53_BYP_RESET_SPIKE_FILTER_SHIFT    (4)
#define REG_RFIC_L53_BYP_RESET_SPIKE_FILTER_WIDTH    (1)

/* L53_RESET_USBM */
#define REG_RFIC_L53_RESET_USBM          (0x75)
#define REG_RFIC_L53_RESET_USBM_MASK     (0x20)
#define REG_RFIC_L53_RESET_USBM_SHIFT    (5)
#define REG_RFIC_L53_RESET_USBM_WIDTH    (1)

/* L53_XO_RDY_O */
#define REG_RFIC_L53_XO_RDY_O          (0x75)
#define REG_RFIC_L53_XO_RDY_O_MASK     (0x4000)
#define REG_RFIC_L53_XO_RDY_O_SHIFT    (14)
#define REG_RFIC_L53_XO_RDY_O_WIDTH    (1)

/* L53_BGP_RDY_EN */
#define REG_RFIC_L53_BGP_RDY_EN          (0x75)
#define REG_RFIC_L53_BGP_RDY_EN_MASK     (0x8000)
#define REG_RFIC_L53_BGP_RDY_EN_SHIFT    (15)
#define REG_RFIC_L53_BGP_RDY_EN_WIDTH    (1)

/* L54_EN */
#define REG_RFIC_L54_EN          (0x76)
#define REG_RFIC_L54_EN_MASK     (0x1)
#define REG_RFIC_L54_EN_SHIFT    (0)
#define REG_RFIC_L54_EN_WIDTH    (1)

/* L54_PRG1V0 */
#define REG_RFIC_L54_PRG1V0          (0x76)
#define REG_RFIC_L54_PRG1V0_MASK     (0xE)
#define REG_RFIC_L54_PRG1V0_SHIFT    (1)
#define REG_RFIC_L54_PRG1V0_WIDTH    (3)

/* L54_PRG_RDG */
#define REG_RFIC_L54_PRG_RDG          (0x76)
#define REG_RFIC_L54_PRG_RDG_MASK     (0xF0)
#define REG_RFIC_L54_PRG_RDG_SHIFT    (4)
#define REG_RFIC_L54_PRG_RDG_WIDTH    (4)

/* L54_DISABLERPAR */
#define REG_RFIC_L54_DISABLERPAR          (0x76)
#define REG_RFIC_L54_DISABLERPAR_MASK     (0x100)
#define REG_RFIC_L54_DISABLERPAR_SHIFT    (8)
#define REG_RFIC_L54_DISABLERPAR_WIDTH    (1)

/* L54_PRGGMFF */
#define REG_RFIC_L54_PRGGMFF          (0x76)
#define REG_RFIC_L54_PRGGMFF_MASK     (0xE00)
#define REG_RFIC_L54_PRGGMFF_SHIFT    (9)
#define REG_RFIC_L54_PRGGMFF_WIDTH    (3)

/* L54_PRGIBIAS */
#define REG_RFIC_L54_PRGIBIAS          (0x76)
#define REG_RFIC_L54_PRGIBIAS_MASK     (0x3000)
#define REG_RFIC_L54_PRGIBIAS_SHIFT    (12)
#define REG_RFIC_L54_PRGIBIAS_WIDTH    (2)

/* L55_EN */
#define REG_RFIC_L55_EN          (0x77)
#define REG_RFIC_L55_EN_MASK     (0x1)
#define REG_RFIC_L55_EN_SHIFT    (0)
#define REG_RFIC_L55_EN_WIDTH    (1)

/* L55_PRG1V0 */
#define REG_RFIC_L55_PRG1V0          (0x77)
#define REG_RFIC_L55_PRG1V0_MASK     (0xE)
#define REG_RFIC_L55_PRG1V0_SHIFT    (1)
#define REG_RFIC_L55_PRG1V0_WIDTH    (3)

/* L55_PRG_RDG */
#define REG_RFIC_L55_PRG_RDG          (0x77)
#define REG_RFIC_L55_PRG_RDG_MASK     (0xF0)
#define REG_RFIC_L55_PRG_RDG_SHIFT    (4)
#define REG_RFIC_L55_PRG_RDG_WIDTH    (4)

/* L55_DISABLERPAR */
#define REG_RFIC_L55_DISABLERPAR          (0x77)
#define REG_RFIC_L55_DISABLERPAR_MASK     (0x100)
#define REG_RFIC_L55_DISABLERPAR_SHIFT    (8)
#define REG_RFIC_L55_DISABLERPAR_WIDTH    (1)

/* L55_PRGGMFF */
#define REG_RFIC_L55_PRGGMFF          (0x77)
#define REG_RFIC_L55_PRGGMFF_MASK     (0xE00)
#define REG_RFIC_L55_PRGGMFF_SHIFT    (9)
#define REG_RFIC_L55_PRGGMFF_WIDTH    (3)

/* L55_PRGIBIAS */
#define REG_RFIC_L55_PRGIBIAS          (0x77)
#define REG_RFIC_L55_PRGIBIAS_MASK     (0x3000)
#define REG_RFIC_L55_PRGIBIAS_SHIFT    (12)
#define REG_RFIC_L55_PRGIBIAS_WIDTH    (2)

/* L56_EN */
#define REG_RFIC_L56_EN          (0x78)
#define REG_RFIC_L56_EN_MASK     (0x1)
#define REG_RFIC_L56_EN_SHIFT    (0)
#define REG_RFIC_L56_EN_WIDTH    (1)

/* L56_SEL_BAND */
#define REG_RFIC_L56_SEL_BAND          (0x78)
#define REG_RFIC_L56_SEL_BAND_MASK     (0x2)
#define REG_RFIC_L56_SEL_BAND_SHIFT    (1)
#define REG_RFIC_L56_SEL_BAND_WIDTH    (1)

/* L56_EN_CHANNEL */
#define REG_RFIC_L56_EN_CHANNEL          (0x78)
#define REG_RFIC_L56_EN_CHANNEL_MASK     (0x1C)
#define REG_RFIC_L56_EN_CHANNEL_SHIFT    (2)
#define REG_RFIC_L56_EN_CHANNEL_WIDTH    (3)

/* L56_IB_CTRL */
#define REG_RFIC_L56_IB_CTRL          (0x78)
#define REG_RFIC_L56_IB_CTRL_MASK     (0xE0)
#define REG_RFIC_L56_IB_CTRL_SHIFT    (5)
#define REG_RFIC_L56_IB_CTRL_WIDTH    (3)

/* L56_SEL_SEL_BAND */
#define REG_RFIC_L56_SEL_SEL_BAND          (0x78)
#define REG_RFIC_L56_SEL_SEL_BAND_MASK     (0x100)
#define REG_RFIC_L56_SEL_SEL_BAND_SHIFT    (8)
#define REG_RFIC_L56_SEL_SEL_BAND_WIDTH    (1)

/* L57_TEST_EXTFD_EN */
#define REG_RFIC_L57_TEST_EXTFD_EN          (0x79)
#define REG_RFIC_L57_TEST_EXTFD_EN_MASK     (0x1)
#define REG_RFIC_L57_TEST_EXTFD_EN_SHIFT    (0)
#define REG_RFIC_L57_TEST_EXTFD_EN_WIDTH    (1)

/* L57_SEL_DIGTM */
#define REG_RFIC_L57_SEL_DIGTM          (0x79)
#define REG_RFIC_L57_SEL_DIGTM_MASK     (0x6)
#define REG_RFIC_L57_SEL_DIGTM_SHIFT    (1)
#define REG_RFIC_L57_SEL_DIGTM_WIDTH    (2)

/* L57_SEL_ANATM */
#define REG_RFIC_L57_SEL_ANATM          (0x79)
#define REG_RFIC_L57_SEL_ANATM_MASK     (0x38)
#define REG_RFIC_L57_SEL_ANATM_SHIFT    (3)
#define REG_RFIC_L57_SEL_ANATM_WIDTH    (3)

/* L57_SDM_EN */
#define REG_RFIC_L57_SDM_EN          (0x79)
#define REG_RFIC_L57_SDM_EN_MASK     (0x40)
#define REG_RFIC_L57_SDM_EN_SHIFT    (6)
#define REG_RFIC_L57_SDM_EN_WIDTH    (1)

/* L57_REFCLK_SEL */
#define REG_RFIC_L57_REFCLK_SEL          (0x79)
#define REG_RFIC_L57_REFCLK_SEL_MASK     (0x80)
#define REG_RFIC_L57_REFCLK_SEL_SHIFT    (7)
#define REG_RFIC_L57_REFCLK_SEL_WIDTH    (1)

/* L57_REFCLK_MON_EN */
#define REG_RFIC_L57_REFCLK_MON_EN          (0x79)
#define REG_RFIC_L57_REFCLK_MON_EN_MASK     (0x100)
#define REG_RFIC_L57_REFCLK_MON_EN_SHIFT    (8)
#define REG_RFIC_L57_REFCLK_MON_EN_WIDTH    (1)

/* L57_R3_SEL */
#define REG_RFIC_L57_R3_SEL          (0x79)
#define REG_RFIC_L57_R3_SEL_MASK     (0x200)
#define REG_RFIC_L57_R3_SEL_SHIFT    (9)
#define REG_RFIC_L57_R3_SEL_WIDTH    (1)

/* L57_R2_SEL */
#define REG_RFIC_L57_R2_SEL          (0x79)
#define REG_RFIC_L57_R2_SEL_MASK     (0xC00)
#define REG_RFIC_L57_R2_SEL_SHIFT    (10)
#define REG_RFIC_L57_R2_SEL_WIDTH    (2)

/* L57_PON_FD_INBUFFER */
#define REG_RFIC_L57_PON_FD_INBUFFER          (0x79)
#define REG_RFIC_L57_PON_FD_INBUFFER_MASK     (0x1000)
#define REG_RFIC_L57_PON_FD_INBUFFER_SHIFT    (12)
#define REG_RFIC_L57_PON_FD_INBUFFER_WIDTH    (1)

/* L57_PON_FBDIV */
#define REG_RFIC_L57_PON_FBDIV          (0x79)
#define REG_RFIC_L57_PON_FBDIV_MASK     (0x2000)
#define REG_RFIC_L57_PON_FBDIV_SHIFT    (13)
#define REG_RFIC_L57_PON_FBDIV_WIDTH    (1)

/* L57_PON_DIV2 */
#define REG_RFIC_L57_PON_DIV2          (0x79)
#define REG_RFIC_L57_PON_DIV2_MASK     (0x4000)
#define REG_RFIC_L57_PON_DIV2_SHIFT    (14)
#define REG_RFIC_L57_PON_DIV2_WIDTH    (1)

/* L57_PON_PEAKDET */
#define REG_RFIC_L57_PON_PEAKDET          (0x79)
#define REG_RFIC_L57_PON_PEAKDET_MASK     (0x8000)
#define REG_RFIC_L57_PON_PEAKDET_SHIFT    (15)
#define REG_RFIC_L57_PON_PEAKDET_WIDTH    (1)

/* L58_EXTMMDIVRATIO_EN */
#define REG_RFIC_L58_EXTMMDIVRATIO_EN          (0x7A)
#define REG_RFIC_L58_EXTMMDIVRATIO_EN_MASK     (0x1)
#define REG_RFIC_L58_EXTMMDIVRATIO_EN_SHIFT    (0)
#define REG_RFIC_L58_EXTMMDIVRATIO_EN_WIDTH    (1)

/* L58_EXT_SELVCO_EN */
#define REG_RFIC_L58_EXT_SELVCO_EN          (0x7A)
#define REG_RFIC_L58_EXT_SELVCO_EN_MASK     (0x2)
#define REG_RFIC_L58_EXT_SELVCO_EN_SHIFT    (1)
#define REG_RFIC_L58_EXT_SELVCO_EN_WIDTH    (1)

/* L58_EXTVCOVCTR_MUX_EN */
#define REG_RFIC_L58_EXTVCOVCTR_MUX_EN          (0x7A)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_EN_MASK     (0x4)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_EN_SHIFT    (2)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_EN_WIDTH    (1)

/* L58_EXTVCOVCTR_MUX */
#define REG_RFIC_L58_EXTVCOVCTR_MUX          (0x7A)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_MASK     (0x18)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_SHIFT    (3)
#define REG_RFIC_L58_EXTVCOVCTR_MUX_WIDTH    (2)

/* L58_PFD_FORCE_DW */
#define REG_RFIC_L58_PFD_FORCE_DW          (0x7A)
#define REG_RFIC_L58_PFD_FORCE_DW_MASK     (0x20)
#define REG_RFIC_L58_PFD_FORCE_DW_SHIFT    (5)
#define REG_RFIC_L58_PFD_FORCE_DW_WIDTH    (1)

/* L58_PFD_FORCE_UP */
#define REG_RFIC_L58_PFD_FORCE_UP          (0x7A)
#define REG_RFIC_L58_PFD_FORCE_UP_MASK     (0x40)
#define REG_RFIC_L58_PFD_FORCE_UP_SHIFT    (6)
#define REG_RFIC_L58_PFD_FORCE_UP_WIDTH    (1)

/* L58_SEL_FREF4BWBOOST */
#define REG_RFIC_L58_SEL_FREF4BWBOOST          (0x7A)
#define REG_RFIC_L58_SEL_FREF4BWBOOST_MASK     (0x100)
#define REG_RFIC_L58_SEL_FREF4BWBOOST_SHIFT    (8)
#define REG_RFIC_L58_SEL_FREF4BWBOOST_WIDTH    (1)

/* L58_BWBOOSTMODE */
#define REG_RFIC_L58_BWBOOSTMODE          (0x7A)
#define REG_RFIC_L58_BWBOOSTMODE_MASK     (0x600)
#define REG_RFIC_L58_BWBOOSTMODE_SHIFT    (9)
#define REG_RFIC_L58_BWBOOSTMODE_WIDTH    (2)

/* L58_VCO_VCTRL_WHEN_CT */
#define REG_RFIC_L58_VCO_VCTRL_WHEN_CT          (0x7A)
#define REG_RFIC_L58_VCO_VCTRL_WHEN_CT_MASK     (0x1800)
#define REG_RFIC_L58_VCO_VCTRL_WHEN_CT_SHIFT    (11)
#define REG_RFIC_L58_VCO_VCTRL_WHEN_CT_WIDTH    (2)

/* L58_VCO_SEL */
#define REG_RFIC_L58_VCO_SEL          (0x7A)
#define REG_RFIC_L58_VCO_SEL_MASK     (0x2000)
#define REG_RFIC_L58_VCO_SEL_SHIFT    (13)
#define REG_RFIC_L58_VCO_SEL_WIDTH    (1)

/* L58_PON_BIAS */
#define REG_RFIC_L58_PON_BIAS          (0x7A)
#define REG_RFIC_L58_PON_BIAS_MASK     (0x4000)
#define REG_RFIC_L58_PON_BIAS_SHIFT    (14)
#define REG_RFIC_L58_PON_BIAS_WIDTH    (1)

/* L58_PON_CP */
#define REG_RFIC_L58_PON_CP          (0x7A)
#define REG_RFIC_L58_PON_CP_MASK     (0x8000)
#define REG_RFIC_L58_PON_CP_SHIFT    (15)
#define REG_RFIC_L58_PON_CP_WIDTH    (1)

/* L59_CURSEL_RFMUX */
#define REG_RFIC_L59_CURSEL_RFMUX          (0x7B)
#define REG_RFIC_L59_CURSEL_RFMUX_MASK     (0x3)
#define REG_RFIC_L59_CURSEL_RFMUX_SHIFT    (0)
#define REG_RFIC_L59_CURSEL_RFMUX_WIDTH    (2)

/* L59_EXTMMDIVRATIO */
#define REG_RFIC_L59_EXTMMDIVRATIO          (0x7B)
#define REG_RFIC_L59_EXTMMDIVRATIO_MASK     (0x1C)
#define REG_RFIC_L59_EXTMMDIVRATIO_SHIFT    (2)
#define REG_RFIC_L59_EXTMMDIVRATIO_WIDTH    (3)

/* L59_EXT_SEL_VCO */
#define REG_RFIC_L59_EXT_SEL_VCO          (0x7B)
#define REG_RFIC_L59_EXT_SEL_VCO_MASK     (0x3E0)
#define REG_RFIC_L59_EXT_SEL_VCO_SHIFT    (5)
#define REG_RFIC_L59_EXT_SEL_VCO_WIDTH    (5)

/* L59_MMD */
#define REG_RFIC_L59_MMD          (0x7B)
#define REG_RFIC_L59_MMD_MASK     (0xFC00)
#define REG_RFIC_L59_MMD_SHIFT    (10)
#define REG_RFIC_L59_MMD_WIDTH    (6)

/* L60_BINARYCAL_EN */
#define REG_RFIC_L60_BINARYCAL_EN          (0x7C)
#define REG_RFIC_L60_BINARYCAL_EN_MASK     (0x1)
#define REG_RFIC_L60_BINARYCAL_EN_SHIFT    (0)
#define REG_RFIC_L60_BINARYCAL_EN_WIDTH    (1)

/* L60_MISC_BITS */
#define REG_RFIC_L60_MISC_BITS          (0x7C)
#define REG_RFIC_L60_MISC_BITS_MASK     (0xFFFE)
#define REG_RFIC_L60_MISC_BITS_SHIFT    (1)
#define REG_RFIC_L60_MISC_BITS_WIDTH    (15)

/* L61_C4_SEL */
#define REG_RFIC_L61_C4_SEL          (0x7D)
#define REG_RFIC_L61_C4_SEL_MASK     (0x1)
#define REG_RFIC_L61_C4_SEL_SHIFT    (0)
#define REG_RFIC_L61_C4_SEL_WIDTH    (1)

/* L61_C1_SEL */
#define REG_RFIC_L61_C1_SEL          (0x7D)
#define REG_RFIC_L61_C1_SEL_MASK     (0x2)
#define REG_RFIC_L61_C1_SEL_SHIFT    (1)
#define REG_RFIC_L61_C1_SEL_WIDTH    (1)

/* L61_CP_FORCE_FIXBIAS */
#define REG_RFIC_L61_CP_FORCE_FIXBIAS          (0x7D)
#define REG_RFIC_L61_CP_FORCE_FIXBIAS_MASK     (0x4)
#define REG_RFIC_L61_CP_FORCE_FIXBIAS_SHIFT    (2)
#define REG_RFIC_L61_CP_FORCE_FIXBIAS_WIDTH    (1)

/* L61_CURSEL_CMLDIV */
#define REG_RFIC_L61_CURSEL_CMLDIV          (0x7D)
#define REG_RFIC_L61_CURSEL_CMLDIV_MASK     (0x18)
#define REG_RFIC_L61_CURSEL_CMLDIV_SHIFT    (3)
#define REG_RFIC_L61_CURSEL_CMLDIV_WIDTH    (2)

/* L61_CURSEL_LDO */
#define REG_RFIC_L61_CURSEL_LDO          (0x7D)
#define REG_RFIC_L61_CURSEL_LDO_MASK     (0x60)
#define REG_RFIC_L61_CURSEL_LDO_SHIFT    (5)
#define REG_RFIC_L61_CURSEL_LDO_WIDTH    (2)

/* L61_CURSEL_LF */
#define REG_RFIC_L61_CURSEL_LF          (0x7D)
#define REG_RFIC_L61_CURSEL_LF_MASK     (0x180)
#define REG_RFIC_L61_CURSEL_LF_SHIFT    (7)
#define REG_RFIC_L61_CURSEL_LF_WIDTH    (2)

/* L61_CURSEL_REF_MUX */
#define REG_RFIC_L61_CURSEL_REF_MUX          (0x7D)
#define REG_RFIC_L61_CURSEL_REF_MUX_MASK     (0x600)
#define REG_RFIC_L61_CURSEL_REF_MUX_SHIFT    (9)
#define REG_RFIC_L61_CURSEL_REF_MUX_WIDTH    (2)

/* L61_RF_PLL_DIGTEST_SEL */
#define REG_RFIC_L61_RF_PLL_DIGTEST_SEL          (0x7D)
#define REG_RFIC_L61_RF_PLL_DIGTEST_SEL_MASK     (0xF800)
#define REG_RFIC_L61_RF_PLL_DIGTEST_SEL_SHIFT    (11)
#define REG_RFIC_L61_RF_PLL_DIGTEST_SEL_WIDTH    (5)

/* L62_CONST_SDM */
#define REG_RFIC_L62_CONST_SDM          (0x7E)
#define REG_RFIC_L62_CONST_SDM_MASK     (0xFFFF)
#define REG_RFIC_L62_CONST_SDM_SHIFT    (0)
#define REG_RFIC_L62_CONST_SDM_WIDTH    (16)

/* L63_CP_REF_SEL */
#define REG_RFIC_L63_CP_REF_SEL          (0x7F)
#define REG_RFIC_L63_CP_REF_SEL_MASK     (0x3)
#define REG_RFIC_L63_CP_REF_SEL_SHIFT    (0)
#define REG_RFIC_L63_CP_REF_SEL_WIDTH    (2)

/* L63_CP_SEL */
#define REG_RFIC_L63_CP_SEL          (0x7F)
#define REG_RFIC_L63_CP_SEL_MASK     (0xFC)
#define REG_RFIC_L63_CP_SEL_SHIFT    (2)
#define REG_RFIC_L63_CP_SEL_WIDTH    (6)

/* L63_CONST_SDM */
#define REG_RFIC_L63_CONST_SDM          (0x7F)
#define REG_RFIC_L63_CONST_SDM_MASK     (0xFF00)
#define REG_RFIC_L63_CONST_SDM_SHIFT    (8)
#define REG_RFIC_L63_CONST_SDM_WIDTH    (8)

/* Tx Gain TPC indexes */
typedef enum RficTxGainTpcIndex
{
    RFIC_TX_GAIN_TPC_INDEX_0 = 0,
    RFIC_TX_GAIN_TPC_INDEX_1,
    RFIC_TX_GAIN_TPC_INDEX_2,
	RFIC_TX_GAIN_TPC_INDEX_W500_MAX_INDEX,
	RFIC_TX_GAIN_TPC_INDEX_MAX = RFIC_TX_GAIN_TPC_INDEX_W500_MAX_INDEX,

} RficTxGainTpcIndex_e;

#endif
