/*****************************************************************************
*    
*   Source File:
*       RficLoopBackTypes.h
*	
*	AUTHOR: Amir Hitron
*
*   Description: Loop-Back definitions for RFIC of AR10
*       
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*****************************************************************************/
#ifndef __RFIC_LOOPBACK_TYPES_H
#define __RFIC_LOOPBACK_TYPES_H

#include "HdkGlobalDefs.h"
#include "RFICDefines.h"
#include "RficDriver_API.h"

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
/*************************************************************
 ***    AM Detector loop-back register masks and values    ***
 *************************************************************/
#define RFIC_LOOP_BACK_AMDT_S0_MASK     (REG_RFIC_S0_TXON_MASK |\
                                         REG_RFIC_S0_RXON_MASK |\
                                         REG_RFIC_S0_SSION_MASK |\
										 REG_RFIC_S0_SPU_MASK |\
										 REG_RFIC_S0_EN_PA2G_MASK)
#define RFIC_LOOP_BACK_AMDT_S0_VALUE    (0x00F9) /* Tx on, Rx off and open PA to MAX */

#define RFIC_LOOP_BACK_AMDT_L9_MASK     (REG_RFIC_L9_PGC12_Q_FTRIM_MASK|\
                                         REG_RFIC_L9_PGC12_I_FTRIM_MASK|\
                                         REG_RFIC_L9_NO_CFIX_MASK)
#define RFIC_LOOP_BACK_AMDT_L9_VALUE    (0x43FF) /* Set PGC2 to wide band mode */

#define RFIC_LOOP_BACK_AMDT_L10_MASK    (REG_RFIC_L10_OPEN_RF_PGC2_MASK|\
                                         REG_RFIC_L10_EN_PGC1_MASK|\
                                         REG_RFIC_L10_EN_OPAMPS_BIAS_CUR_MASK|\
                                         REG_RFIC_L10_EN_OFFC_BIAS_CUR_MASK|\
                                         REG_RFIC_L10_EN_OC_PGC1_MASK|\
                                         REG_RFIC_L10_EN_OP1_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OP2_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OC1_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OC2_PGC2_MASK)
#define RFIC_LOOP_BACK_AMDT_L10_VALUE   (0x6502) /* Power Up PGC2 SSB mode and Set PGC2 to wide band mode */

#define RFIC_LOOP_BACK_AMDT_L11_MASK    (REG_RFIC_L11_EN_SSBCAL_MASK)
#define RFIC_LOOP_BACK_AMDT_L11_VALUE   (0x8000) /* Enable SSB loop in PGC2 */

#define RFIC_LOOP_BACK_AMDT_L29_MASK    (REG_RFIC_L29_EN_SSB_PAD5G_MASK|\
                                         REG_RFIC_L29_EN_SSB_PA2G_MASK|\
                                         REG_RFIC_L29_EN_SSB_PAD2G_MASK|\
                                         REG_RFIC_L29_TRIMBIAS_MASK|\
                                         REG_RFIC_L29_GAIN_MASK)
#define RFIC_LOOP_BACK_AMDT_L29_VALUE   (0x020C) /* Set SSB bias and gain to default, Power-Up SSB int.PA, Power-Down SSB 5g. and SSB 2G ext. PA */

#define RFIC_LOOP_BACK_AMDT_L32_MASK    (REG_RFIC_L32_SEL40_MASK|\
                                         REG_RFIC_L32_FMODE_MASK|\
                                         REG_RFIC_L32_EN_PGC3_MASK|\
                                         REG_RFIC_L32_OPEN_RF_PGC3_MASK|\
                                         REG_RFIC_L32_SEL_IN_PGC3_MASK)

#define RFIC_LOOP_BACK_AMDT_L32_SELECT_B_VALUE (0x0027) /* Power Up PGC3, set PGC3 to wide band mode and select input B */
#define RFIC_LOOP_BACK_AMDT_L32_SELECT_C_VALUE (0x0037) /* Power Up PGC3, set PGC3 to wide band mode and select input C */

#define RFIC_LOOP_BACK_AMDT_L33_MASK    (REG_RFIC_L33_FTRIM_I_MASK|\
                                         REG_RFIC_L33_FTRIM_Q_MASK)
#define RFIC_LOOP_BACK_AMDT_L33_VALUE   (0x035A) /* Set PGC3 to wide band mode */

/********************************************************
 ***    Rx LPF loop-back register masks and values    ***
 ********************************************************/
#define RFIC_LOOP_BACK_RX_LPF_RX_ANT_S0_MASK	(REG_RFIC_S0_RXON_MASK|\
												 REG_RFIC_S0_TXON_MASK|\
												 REG_RFIC_S0_SSION_MASK)
#define RFIC_LOOP_BACK_RX_LPF_RX_ANT_S0_VALUE  (0x0000) /* Set loop-back antenna to stand-by mode */

#define RFIC_LOOP_BACK_RX_LPF_TX_ANT_S0_MASK   (REG_RFIC_S0_RXON_MASK|\
												REG_RFIC_S0_TXON_MASK|\
												REG_RFIC_S0_SSION_MASK)
#define RFIC_LOOP_BACK_RX_LPF_TX_ANT_S0_VALUE  (0x0009) /* Set calibrated antenna to Tx ON & Rx OFF mode */

#define RFIC_LOOP_BACK_RX_LPF_L9_MASK   (REG_RFIC_L9_SEL_IN_PGC12_MASK)
#define RFIC_LOOP_BACK_RX_LPF_L9_VALUE  (0x2000) /* Set PGC1 input selector to DAC */

#define RFIC_LOOP_BACK_RX_LPF_L10_MASK  (REG_RFIC_L10_EN_OC2_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OC1_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OP2_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OP1_PGC2_MASK|\
                                         REG_RFIC_L10_EN_OC_PGC1_MASK|\
                                         REG_RFIC_L10_EN_OFFC_BIAS_CUR_MASK|\
                                         REG_RFIC_L10_EN_OPAMPS_BIAS_CUR_MASK|\
                                         REG_RFIC_L10_EN_PGC1_MASK)
#define RFIC_LOOP_BACK_RX_LPF_L10_VALUE (0xFF00) /* Power Up PGC1/2 */

#define RFIC_LOOP_BACK_RX_LPF_L24_MASK  (REG_RFIC_L24_TEST_IQTPC_MASK|\
                                          REG_RFIC_L24_EN_MASK)
#define RFIC_LOOP_BACK_RX_LPF_L24_VALUE (0x0000) /* Disable TPC and set output to mix - in case Tx was set before loop */

#define RFIC_LOOP_BACK_RX_LPF_L32_MASK           (REG_RFIC_L32_EN_PGC3_MASK|\
                                                  REG_RFIC_L32_SEL_IN_PGC3_MASK)
#define RFIC_LOOP_BACK_RX_LPF_L32_SELECT_B_VALUE (0x0024) /* Power Up PGC3 Rx ant, input select B */
#define RFIC_LOOP_BACK_RX_LPF_L32_SELECT_C_VALUE (0x0034) /* Power Up PGC3 Rx ant, input select C */

/********************************************************
 ***    Tx LPF loop-back register masks and values    ***
 ********************************************************/
#define RFIC_LOOP_BACK_TX_LPF_S0_MASK   (REG_RFIC_S0_TXON_MASK)
#define RFIC_LOOP_BACK_TX_LPF_S0_VALUE  (0x0000)

#define RFIC_LOOP_BACK_TX_LPF_L9_MASK   (REG_RFIC_L9_SEL_IN_PGC12_MASK)
#define RFIC_LOOP_BACK_TX_LPF_L9_VALUE  (0x3000)

#define RFIC_LOOP_BACK_TX_LPF_L24_MASK  (REG_RFIC_L24_TEST_IQTPC_MASK|\
                                         REG_RFIC_L24_EN_MASK)
#define RFIC_LOOP_BACK_TX_LPF_L24_VALUE (0xA000)

/******************************************************
 ***    RSSI loop-back register masks and values    ***
 ******************************************************/
#define RFIC_LOOP_BACK_RSSI_S0_MASK     (RFIC_DEFAULT_MASK) /* Set the RF to standby mode */
#define RFIC_LOOP_BACK_RSSI_S0_VALUE    (0x0002) /* Select SSI PATH - RSSI */

#define RFIC_LOOP_BACK_RSSI_L2_MASK     (REG_RFIC_L2_CONNECT_DAC_MASK)
#define RFIC_LOOP_BACK_RSSI_L2_VALUE    (0x0080) /* Select RSSI input - DAC output */

#endif//__RFIC_LOOPBACK_TYPES_H
