/***********************************************************************************
 File:		efuseAccess.c
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "SocRegsRegs.h"
#include "efuseAccess_Api.h"
#include "loggerAPI.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_HDK_MODULE_1
#define LOG_LOCAL_FID 3

#define EFUSE_PD_DISABLE 			(0)
#define EFUSE_PD_ENABLE				(1)
#define EFUSE_PCIE_FSM_OVR_DISABLE 	(0)
#define EFUSE_PCIE_FSM_OVR_ENABLE	(1)
#define EFUSE_CNTRL_READ 			(0)
#define EFUSE_STATUS_BUSY_MASK		(0x1)	
#define EFUSE_STATUS_BUSY_CLEARED	(0 * EFUSE_STATUS_BUSY_MASK)
#define EFUSE_STATUS_INIT_DONE_MASK	(0x2)
#define EFUSE_STATUS_INIT_DONE_VALUE (1 * EFUSE_STATUS_INIT_DONE_MASK)
#define EFUSE_STATUS_READ_MAX		(1000)	/* max number of attempts to read */
#define EFUSE_ADDR_SHIFT 			(3) 	/* byte number to bit number */
#define EFUSE_MAX_SIZE 				(512)
#define EFUSE_DONE_DELAY			(300)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/
	
/*---------------------------------------------------------------------------------
/						Static Function Declaration 								
/----------------------------------------------------------------------------------*/
static void readEfuse(uint8 *bytes, uint32 addr);
static void waitEfuseIdle(bool checkInitDone);
/*---------------------------------------------------------------------------------
/						Static variables Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


void efuseAccess_Read(uint8 *val, uint32 addr)
{
	DEBUG_ASSERT(NULL != val);
	ASSERT(addr <= EFUSE_MAX_SIZE);

  	/* Disable PD bit in efuse_PD register. */
	RegAccess_Write(REG_SOC_REGS_EFUSE_PD, EFUSE_PD_DISABLE);
	RegAccess_Write(REG_SOC_REGS_EFUSE_PCIE_FSM_OVR, EFUSE_PCIE_FSM_OVR_ENABLE);

	/* Check efuse_control_busy (bit 0) bit is cleared and check efuse_init_done (bit 1) bit is set */
	waitEfuseIdle(TRUE);

	/* Read one byte from efuse */
	readEfuse(val, addr);
	
  	/* Enable PD bit in efuse_PD register. */
	RegAccess_Write(REG_SOC_REGS_EFUSE_PCIE_FSM_OVR, EFUSE_PCIE_FSM_OVR_DISABLE);
	RegAccess_Write(REG_SOC_REGS_EFUSE_PD, EFUSE_PD_ENABLE);
}

static void readEfuse(uint8 *byte, uint32 addr)
{
	uint32 val;
	
  	/* Write the Byte Address (Bit Number) */
	RegAccess_Write(REG_SOC_REGS_EFUSE_ADDRESS, (addr << EFUSE_ADDR_SHIFT)); /* bit number */
   
   	/* Write "Read Request" to the efuse_control register. */
  	RegAccess_Write(REG_SOC_REGS_EFUSE_CONTROL, EFUSE_CNTRL_READ);

   	/* Poll the efuse_status register until the efuse_control_busy bit 0 is cleared */
	waitEfuseIdle(FALSE);

	 /* Read the value from the efuse_data register. */
	RegAccess_Read(REG_SOC_REGS_EFUSE_DATA, &val);
	*byte = (uint8)val;
}

static void waitEfuseIdle(bool checkInitDone)
{
	uint8  efuseIdle = 0;
	uint16  delayCounter = 0;
	uint8 idleMask = (EFUSE_STATUS_BUSY_MASK | (EFUSE_STATUS_INIT_DONE_MASK * checkInitDone));
	uint8 idleVal = (EFUSE_STATUS_BUSY_CLEARED | (EFUSE_STATUS_INIT_DONE_VALUE * checkInitDone));

	do
	{
		efuseIdle = ((RegAccess_ReadImmediate(REG_SOC_REGS_EFUSE_STATUS) & idleMask)== idleVal);
	} while ((!efuseIdle) && ((++delayCounter) <= EFUSE_DONE_DELAY));

	// check for timeout
	ASSERT(delayCounter <= EFUSE_DONE_DELAY);
}

