/*******************************************************************
 *
 *    DESCRIPTION:
 *
 *    AUTHOR:
 *
 *    HISTORY:
 *
 *******************************************************************/

#ifndef PSD_H
#define PSD_H

#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"

/**************** Type definitions ****************/

typedef void (*psdFuncPtr_t)(K_MSG *psMsg);

typedef struct PHY_DUMPS_HEADER
{
	uint32 u32StartAddress;
	uint32 u32Length;
} PhyDumpsHeader_t;
typedef enum PhyAntConfigTableId
{
	PHY_FOURIER_PHASES_1X1_TABLE,
	PHY_FOURIER_PHASES_2X2_TABLE,
	PHY_FOURIER_PHASES_3X3_TABLE,
	PHY_FOURIER_PHASES_4X4_TABLE,
	PHY_ANT_CONFIG_TABLE_NUM_OF_OPT
		
}PhyAntConfigTableId_e;
typedef struct PhyCompFourierPhasesTableParams
{
	uint32 address;
	uint32 mask;
	uint32 value;
}PhyCompFourierPhasesTableParams_t;
typedef struct PhyCompFourierPhasesTableDefinition_t
{
	PhyCompFourierPhasesTableParams_t* PhyAntConfigTablePtr;
	uint8 phyAntConfigTableSize;

}PhyCompFourierPhasesTableDefinition_t;


/********* PSD Single Data Fields Definitions *********/

#define PSD_MAX_NUM_OF_DATA_FIELDS 			20
#define PSD_FIELD_ID_MASK 					0xFFFF
#define PSD_LENGTH_INDEX					0

// Fields IDs

#define PSD_FIELD_CHIP_ID				 	0x1
#define PSD_FIELD_CHIP_REV				 	0x2
#define PSD_FIELD_RF_CHIP_ID			 	0x3
#define PSD_FIELD_HW_TYPE				 	0xB
#define PSD_FIELD_HW_VERSION			 	0xC
#define PSD_FIELD_BAND_SUPPORT_2_4G		 	0x4
#define PSD_FIELD_BAND_SUPPORT_5G    	 	0x5
#define PSD_FIELD_TX_ANTS_MASK			 	0x6
#define PSD_FIELD_RX_ANTS_MASK			 	0x7
#define PSD_FIELD_TX_ANT_SELECTION_MASK  	0x8
#define PSD_FIELD_RX_ANT_SELECTION_MASK	 	0x9
#define PSD_FIELD_EXT_PA				 	0xA

// Offsets
#define PSD_FIELD_OFFSET                    2

/************** PSD Tables Definitions **************/

#define PSD_TABLE_FUNC_ARRAY_SIZE 			 80
#define PSD_TABLE_ID_SHIFT					 16
#define PSD_INVALID_TABLE_ID				 0xFF

// Band Dependence 

#define PSD_BAND_2_4GHZ_TABLE				 UMI_PHY_TYPE_BAND_2_4_GHZ 
#define PSD_BAND_5GHZ_TABLE					 UMI_PHY_TYPE_BAND_5_2_GHZ
#define PSD_BAND_INDEPENDENT_TABLE			 MAX_UINT8

// Table size
#define PSD_NUM_OF_ROWS_INDEX				 0
#define PSD_NUM_OF_COLS_INDEX				 1
#define PSD_PHY_FIELDS_TABLE_NUM_OF_COLS	 3
#define PSD_RF_TABLE_NUM_OF_COLS			 6
#define PSD_AFE_TABLE_NUM_OF_COLS	 		 7
#define PSD_PHY_DUMPS_TABLE_NUM_OF_COLS	 	 1
#define PSD_BF_ACTIVATION_BITMAP_NUM_OF_COLS 1
#define PSD_BF_ACTIVATION_BITMAP_NUM_OF_ROWS 1

// Offsets
#define PSD_REG_ADDR_OFFSET					 2
#define PSD_REG_MASK_OFFSET					 3
#define PSD_REG_VALUE_OFFSET				 4
#define PSD_TABLE_START_INDEX				 2

extern uint32 *pShramAddress;

/**************** Public functions ****************/
void PSD_copyPlatformDataFields(uint32 *psDataFields);

void PSD_handlePlatformTable(K_MSG *psMsg);

uint32 PSD_getDataField(uint8 fieldId);

uint8 PSD_findFirstAntInMask(uint8 antMask);
void setPsdShramAddress(uint32* psdProgmodelShramAddress);

void PSD_setNewChannel(uint8 channel);
PhyCompFourierPhasesTableDefinition_t* getCompressedFourierPhasesTable(uint8 numOfAnt);


#endif
