/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

#include "PSD.h"
#include "shram_rx_buffer.h"
#include "RegAccess_Api.h"
#include "RficDriver_API.h"
#include "Afe_API.h"
#include "PhyDriver_API.h"
#include "stringLibApi.h"
#include "RxDcOffsetClbrHndlr.h"
#include "linkAdaptation_api.h"
#include "init_ifmsg.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_HDK_MODULE
#define LOG_LOCAL_FID 18


/******************************************************************************/
/***					Static Function Declaration							***/
/******************************************************************************/
static void handleHwLimitTable(K_MSG *psMsg);
static void handlePhyFieldsTable(K_MSG *psMsg);
static void handlePhyFieldsPerAntennaTable(K_MSG *psMsg);
static void handleRfInitTable(K_MSG *psMsg);
static void handleRfZwdfsTable(K_MSG *psMsg);
static void handleRfRegsTable(K_MSG *psMsg);
static void handleAfeTable(K_MSG *psMsg);
static void handleRxDcGainsTable(K_MSG *psMsg);
static void handlePhyDumpsTable(K_MSG *psMsg);
static void handleBfActivationBitmap(K_MSG *psMsg);

static void handlePower11bHighTable(K_MSG *psMsg);
static void handlePower11agHighTable(K_MSG *psMsg);
static void handlePower11nHighTable(K_MSG *psMsg);
static void handlePower11acHighTable(K_MSG *psMsg);
static void handlePower11bLowTable(K_MSG *psMsg);
static void handlePower11agLowTable(K_MSG *psMsg);
static void handlePower11nLowTable(K_MSG *psMsg);
static void handlePower11acLowTable(K_MSG *psMsg);

static void handlePower11acMuHighTable(K_MSG *psMsg);
static void handlePower11acMuLowTable(K_MSG *psMsg);
static void handlePowerOffsetHighLow(K_MSG *psMsg);
static void handlePowerLimitMUAndBF(K_MSG *psMsg);
static void handlePower11axTable(K_MSG *psMsg);
static void handlePowerProximateStaBackoffTable(K_MSG *psMsg);
static void handlePowerDistantStaBackoffTable(K_MSG *psMsg);
static void handlePowerInternalPowerLowerLimitTable(K_MSG *psMsg);
static void handlePowerExternalPowerLowerLimitTable(K_MSG *psMsg);
static void handleInitialRateAccordingToRssiHtVhtTable(K_MSG *psMsg);
static void handleInitialRateAccordingToRssi11AgTable(K_MSG *psMsg);
static void handleInitialRateAccordingToRssi11bTable(K_MSG *psMsg);
//static void handleCddTable(K_MSG *psMsg);
static void handleIRETable_B(K_MSG *psMsg);
static void handleGPIOTable(K_MSG *psMsg);
static void handleClipping(K_MSG *psMsg);
static void handleRxIqDefault(K_MSG *psMsg);
static void handleBandEdgeTxValueTable(K_MSG * psMsg);
static void handleInvalidTableId(K_MSG *psMsg);
static void handleIgnoredTableId(K_MSG* psMsg);
static void sendPsdPowerAdaptationMsg(PowerAdaptationTableType_e tableType,K_MSG *psMsg);
static void handleAntennaMaskPerChannelTable(K_MSG* psMsg);
uint32 fixAntSelectionMask(uint32 inMask); //WORKAROUND function
static void handleFourierPhases1x1Table(K_MSG *psMsg);
static void handleFourierPhases2x2Table(K_MSG *psMsg);
static void handleFourierPhases3x3Table(K_MSG *psMsg);
static void handleFourierPhases4x4Table(K_MSG *psMsg);
static void handleFourierPhasesTables(K_MSG *psMsg, PhyAntConfigTableId_e antConfigTableId, uint8 tableMaxSize);
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PHY_FOURIER_PHASES_1X1_TABLE_SIZE 6
#define PHY_FOURIER_PHASES_2X2_TABLE_SIZE 6
#define PHY_FOURIER_PHASES_3X3_TABLE_SIZE 6
#define PHY_FOURIER_PHASES_4X4_TABLE_SIZE 6



/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*********************/
/*	     Data Bases	    */
/*********************/
PhyCompFourierPhasesTableParams_t psdCompressedFourierPhases1x1Table[PHY_FOURIER_PHASES_1X1_TABLE_SIZE];
PhyCompFourierPhasesTableParams_t psdCompressedFourierPhases2x2Table[PHY_FOURIER_PHASES_2X2_TABLE_SIZE];
PhyCompFourierPhasesTableParams_t phyCompressedFourierPhases3x3Table[PHY_FOURIER_PHASES_3X3_TABLE_SIZE];
PhyCompFourierPhasesTableParams_t psdCompressedFourierPhases4x4Table[PHY_FOURIER_PHASES_4X4_TABLE_SIZE];

PhyCompFourierPhasesTableDefinition_t psdCompressedFourierPhasesTablesArr[PHY_ANT_CONFIG_TABLE_NUM_OF_OPT] = 
{
	{
		psdCompressedFourierPhases1x1Table,
		0,									//Will be filled according to PSD table
	},
	{
		psdCompressedFourierPhases2x2Table,
		0,									//Will be filled according to PSD table
	},
	{
		phyCompressedFourierPhases3x3Table,
		0,									//Will be filled according to PSD table
	},
	{
		psdCompressedFourierPhases4x4Table,
		0,									//Will be filled according to PSD table
	}
};
uint32 	PsdFieldsDb[PSD_MAX_NUM_OF_DATA_FIELDS] = 
{
	0,0,0,0,0,0,7,7,0x3f,0x3f,0,0,0,0,0,0,0,0,0,0
};

psdFuncPtr_t psdTableFuncArray[PSD_TABLE_FUNC_ARRAY_SIZE] = 
{
	handleInvalidTableId,
	handleHwLimitTable,
	handlePhyFieldsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyFieldsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handleRfInitTable,
	handleRfRegsTable,
	handleAfeTable,
	handleAfeTable,
	handleRxDcGainsTable,
	handleBfActivationBitmap,
	handlePower11bHighTable,
	handlePower11agHighTable,
	handlePower11nHighTable,
	handlePower11acHighTable,
	handlePowerProximateStaBackoffTable,
	handlePowerDistantStaBackoffTable,
	handlePowerInternalPowerLowerLimitTable,
	handlePowerExternalPowerLowerLimitTable,
	handleInitialRateAccordingToRssiHtVhtTable,
	handleInitialRateAccordingToRssi11AgTable,
	handleInitialRateAccordingToRssi11bTable,
	handleIRETable_B,
	handleGPIOTable,
	handleClipping,
	handlePower11bLowTable,
	handlePower11agLowTable,
	handlePower11nLowTable,
	handlePower11acLowTable,
	handlePower11acMuHighTable,
	handlePower11acMuLowTable,
	handlePowerOffsetHighLow,
	handlePowerLimitMUAndBF,
	handleAntennaMaskPerChannelTable,
	handleFourierPhases1x1Table,
	handleFourierPhases2x2Table,
	handleFourierPhases3x3Table,
	handleFourierPhases4x4Table,
	handleIgnoredTableId,
	handlePower11axTable,
	handlePhyFieldsPerAntennaTable,
	handlePhyFieldsPerAntennaTable,
	handleInvalidTableId,
	handleBandEdgeTxValueTable,
	handleRfZwdfsTable,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleInvalidTableId,
	handleRxIqDefault,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyFieldsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable,
	handlePhyDumpsTable
};
uint8 tableBandDependence[PSD_TABLE_FUNC_ARRAY_SIZE] = 
{	
	PSD_INVALID_TABLE_ID,
	PSD_BAND_INDEPENDENT_TABLE,			// HW_Power_Limit
	PSD_BAND_2_4GHZ_TABLE, 				// PHY_regs_2.4
	PSD_BAND_2_4GHZ_TABLE, 
	PSD_BAND_2_4GHZ_TABLE, 
	PSD_BAND_2_4GHZ_TABLE, 			   
	PSD_BAND_2_4GHZ_TABLE, 			   
	PSD_BAND_5GHZ_TABLE,				// PHY_regs_5
	PSD_BAND_5GHZ_TABLE,
	PSD_BAND_5GHZ_TABLE,
	PSD_BAND_5GHZ_TABLE,
	PSD_BAND_5GHZ_TABLE,		 	  
	PSD_BAND_2_4GHZ_TABLE,				//PHY_fields
	PSD_BAND_5GHZ_TABLE,			   
	PSD_BAND_INDEPENDENT_TABLE,			// RF init
	PSD_BAND_INDEPENDENT_TABLE,			// RF
	PSD_BAND_INDEPENDENT_TABLE,			// AFE
	PSD_BAND_INDEPENDENT_TABLE,		    
	PSD_BAND_INDEPENDENT_TABLE,		    // General
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,			
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_5GHZ_TABLE,				// GPIO
	PSD_BAND_INDEPENDENT_TABLE,				
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_2_4GHZ_TABLE,
	PSD_BAND_5GHZ_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE, 		
	PSD_BAND_5GHZ_TABLE,			// RF Zw-dfs
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE, 		
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,
	PSD_BAND_INDEPENDENT_TABLE,	
};																	  

/******************************************************************************/
/***					Internal Data Structures							***/
/******************************************************************************/
#define MAX_NUM_OF_ANTENNA_MASK_REGIONS	8 //maximum number of spectrum regions with different antenna mask
#define NUM_SEGMENTS					1
uint8 AntMaskPerChannelDB[MAX_NUM_OF_ANTENNA_MASK_REGIONS][NUM_SEGMENTS + 1];
uint8 currentAntennaMask;

/******************************************************************************/
/***						Global Variables								***/
/******************************************************************************/
uint32 *pShramAddress = NULL;

#ifdef PSD_DEBUG
uint32 CurrentRowIndex = 0;
RegDebug PhyRegAntDebug[DEBUG_MAX_ANTENNA];
#endif

/******************************************************************************/
/***						Public Functions Definitions					***/
/******************************************************************************/
void PSD_sendCfmToUMI(K_MSG *psMsg);
void PhyRegAntDebuginit(void);

/**********************************************************************************
PhyRegAntDebuginit 

Description:
------------
	init PhyRegAntDebug struct
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
#ifdef PSD_DEBUG
void PhyRegAntDebuginit(void)
{
	uint32 ant;	
	
	for (ant = 0; ant < DEBUG_MAX_ANTENNA; ant++) 	
	{
		memset(&PhyRegAntDebug[ant], 0, sizeof(RegDebug));
	}
}
#endif
/**********************************************************************************
copyPlatformDataFields 

Description:
------------
	Store PSD data fields in database
Input: 
-----
	uint32 *dataFields - Data fields array	
Output:
-------
	None
**********************************************************************************/
void PSD_copyPlatformDataFields(uint32 *dataFields)
{
	uint32 length = dataFields[PSD_LENGTH_INDEX];
	uint8 rowIndex;
	uint32 value, fieldId;

	for (rowIndex = 0; rowIndex < length; rowIndex++)
	{
		// Get fieldId
		fieldId = (dataFields[(rowIndex << 1) + PSD_FIELD_OFFSET]) & PSD_FIELD_ID_MASK;
		ASSERT(fieldId <= PSD_MAX_NUM_OF_DATA_FIELDS);
		
		// Get value
		value = dataFields[(rowIndex << 1) + PSD_FIELD_OFFSET + 1];
		// Store field in database
		PsdFieldsDb[fieldId] = value;
	}

	//WORKAROUND to support antenna selection in TCR with antenna 0 disabled
	if (PsdFieldsDb[PSD_FIELD_TX_ANT_SELECTION_MASK] == 0)
	{
		PsdFieldsDb[PSD_FIELD_TX_ANT_SELECTION_MASK] = fixAntSelectionMask(PsdFieldsDb[PSD_FIELD_TX_ANTS_MASK]);
	}
	if (PsdFieldsDb[PSD_FIELD_RX_ANT_SELECTION_MASK] == 0)
	{
		PsdFieldsDb[PSD_FIELD_RX_ANT_SELECTION_MASK] = fixAntSelectionMask(PsdFieldsDb[PSD_FIELD_RX_ANTS_MASK]);
	}
	//HDK_override11bAntSel((uint8)PsdFieldsDb[PSD_FIELD_TX_ANTS_MASK]);
	currentAntennaMask = PsdFieldsDb[PSD_FIELD_TX_ANTS_MASK];
	AntMaskPerChannelDB[0][0] = 0xff;
	AntMaskPerChannelDB[0][1] = currentAntennaMask;
}

#define DBG_ANT_MASK_MAX_BIT	8
uint32 fixAntSelectionMask(uint32 inMask)
{
	uint32 outMask = 0;
	uint8 bitIndex;
	uint8 bitVal;

	for (bitIndex = 0; bitIndex < DBG_ANT_MASK_MAX_BIT; bitIndex++)
	{
		bitVal = inMask & 0x1;
		outMask |= ((bitVal * 0x3) << (bitIndex << 1));
		inMask >>= 1;
	}

	return outMask;
}



/**********************************************************************************
handlePlatformTable 

Description:
------------
	Choose right PSD handler by tableId.
Input: 
-----
	uint32 tableID	
Output:
-------
	None
**********************************************************************************/
void PSD_handlePlatformTable(K_MSG *psMsg)
{
	uint32 band = 0;
	platformTable_t *psTable_p = (platformTable_t *) pK_MSG_DATA(psMsg);
	uint32 tableID = psTable_p->tableID;

	tableID >>= PSD_TABLE_ID_SHIFT;
#if !defined HDK_CDB_SUPPORT_BY_DRIVER
	band = checkPsdTableType();
#else
	band = HDK_getBand();
#endif
	ASSERT(tableID < PSD_TABLE_FUNC_ARRAY_SIZE);
	ILOG0_DDD("PSD_handlePlatformTabl;e, tableBandDependence[tableID] = %d band = %d tableID = %d", tableBandDependence[tableID],band,tableID);
	if ((tableBandDependence[tableID] == PSD_BAND_INDEPENDENT_TABLE) || (tableBandDependence[tableID] == (uint8)band))
	{
		// Call handler from PSD functions array by tableId
		psdTableFuncArray[tableID](psMsg);
	}
	else
	{
		PSD_sendCfmToUMI(psMsg);
	}
}
uint32 PSD_getDataField(uint8 fieldId)
{
	DEBUG_ASSERT(fieldId <= PSD_MAX_NUM_OF_DATA_FIELDS);

	return PsdFieldsDb[fieldId];
}
/**********************************************************************************
PSD_sendCfmToUMI 

Description:
------------
	
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void PSD_sendCfmToUMI(K_MSG *psMsg)
{
	OSAL_SEND_MESSAGE(UMI_MC_MAN_PLATFORM_TABLE_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/**********************************************************************************
PSD_findFirstAntInMask 

Description:
------------
	
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
uint8 PSD_findFirstAntInMask(uint8 antMask)
{
	uint8 count = 0;
	uint8 ant = 4;
	
	ASSERT(antMask != 0);
	while (ant == 4)
	{
		if ((antMask & 0x1) == 1)
		{
			ant = count;
		}
		else
		{
			antMask >>= 1;
			count++;
		}
	}
	return ant;
}

/**********************************************************************************
handleHwLimitTable 

Description:
------------
	HW limit table handler - Empty function
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleHwLimitTable(K_MSG *psMsg)
{
	PSD_sendCfmToUMI(psMsg);
}

/**********************************************************************************
handlePhyFieldsTable 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handlePhyFieldsTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint32 address, mask, value;    
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_PHY_FIELDS_TABLE_NUM_OF_COLS);

	// Write table's data in registers
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask    = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];
		value   = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET];
		RegAccess_WriteMasked(address, mask , value);
	}
	PSD_sendCfmToUMI(psMsg);
}

/**********************************************************************************
handlePhyFieldsPerAntennaTable 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handlePhyFieldsPerAntennaTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint32 address, mask, value;

	uint32 antMask = Hdk_GetTxAntMask(); 

	#ifdef PSD_DEBUG
	PhyRegAntDebuginit();
	#endif
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_PHY_FIELDS_TABLE_NUM_OF_COLS);

	// Write table's data in phy Antenna registers according to the band antenna mask 
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask    = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];
		value   = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET];

		#ifdef PSD_DEBUG
		CurrentRowIndex = rowIndex;
		#endif
		
		#if defined (ENET_INC_ARCH_WAVE600)	
		RegAccess_WritePerAntMaskMasked(address, mask, antMask, value);
		#else
		RegAccess_WriteMasked(address, mask , value);
		#endif
	}
	PSD_sendCfmToUMI(psMsg);
}


/**********************************************************************************
handleRfInitTable

Description:
------------
	RF init table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleRfInitTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint8 ant;
	uint32 address, mask;
	uint16 values[MAX_NUM_OF_ANTENNAS];
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_RF_TABLE_NUM_OF_COLS);

	// Write table's data in registers
	PhyDrv_StopRisc();
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask    = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];

		// Get values per antenna
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			values[ant] = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET + ant];
		}
		RficDriver_WriteMaskRegister(address, values, mask);
		
	}
	PSD_sendCfmToUMI(psMsg);
}
/**********************************************************************************
handleRfZwdfsTable

Description:
------------
	RF regs table handler. copy table to Zw-dfs DB
Input: 
-----
	None	
Output:
-------
	None

**********************************************************************************/
void handleRfZwdfsTable(K_MSG *psMsg)
{
	
	
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint8 ant;
	uint32 address, mask;
	uint32 values[MAX_NUM_OF_ANTENNAS];

	DEBUG_ASSERT(ConfigurationManager_GetIsDualBandZWDFS());
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_RF_TABLE_NUM_OF_COLS);
	
	// copy table's data to DB
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask    = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];

		// Get values per antenna
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			values[ant] = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET + ant];
		}
	
			RficDriver_copyOneRowFromPsdTable(address, values, mask, rowIndex, RFIC_DRIVER_ZWDFS_PSD_DB);
	}
	PSD_sendCfmToUMI(psMsg);	
	
}

/**********************************************************************************
handleRfRegsTable

Description:
------------
	RF regs table handler. copy table to DB
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleRfRegsTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint8 ant;
	uint32 address, mask;
	uint32 values[MAX_NUM_OF_ANTENNAS];
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_RF_TABLE_NUM_OF_COLS);
	
	// copy table's data to DB
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask    = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];

		// Get values per antenna
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			values[ant] = pShramAddress[PSD_RF_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET + ant];
		}
	
			RficDriver_copyOneRowFromPsdTable(address, values, mask, rowIndex ,RFIC_DRIVER_PSD_DB);
	}
	PSD_sendCfmToUMI(psMsg);

}

/**********************************************************************************
handleAfeTable

Description:
------------
	AFE table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleAfeTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	uint8 channel;
	uint32 address, mask;
	uint32 values[FCSI_TOTAL_CHANNELS];
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_AFE_TABLE_NUM_OF_COLS);

	// Write table's data in registers
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		address = pShramAddress[PSD_AFE_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		mask 	= pShramAddress[PSD_AFE_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];
		
		// Get values per channel
		for (channel = 0; channel < FCSI_TOTAL_CHANNELS; channel++)
		{
			values[channel] = pShramAddress[PSD_AFE_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET + channel];
		}
		AFE_CopyOneRowFromPsd(ANTENNA_BITMAP_ALL_AFE_CHANNELS_GEN5, address,values, mask,rowIndex);//PHYTBD: open after merge with CDB and API lignment 
		//AFE_WriteMaskRegisters(ANTENNA_BITMAP_ALL_AFE_CHANNELS_GEN5, address, values, mask);
	}
	PSD_sendCfmToUMI(psMsg);
}

/**********************************************************************************
handleRxDcGainsTable

Description:
------------
	RxDC Gains table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleRxDcGainsTable(K_MSG *psMsg)
{
#if ((!defined (HDK_REL_2_0)) && !defined (HDK_INTERMEDIATE_UNTIL_API_MERGE))//PHYTBD: open after merge with CDB and API lignment 
	RxDC_ReadPSD();
#endif
	PSD_sendCfmToUMI(psMsg);
}

void handleIRETable_B(K_MSG *psMsg)
{
	RficDriver_handleIRETable_B();
	PSD_sendCfmToUMI(psMsg);
}

void handleClipping(K_MSG *psMsg)
{
	hdk_handleClipping();
	PSD_sendCfmToUMI(psMsg);
}

void handleRxIqDefault(K_MSG *psMsg)
{
	hdk_handleRxIqDefault();
	PSD_sendCfmToUMI(psMsg);
}

void handleGPIOTable(K_MSG *psMsg)
{
	RficDriver_handleZwdfsTable();
	PSD_sendCfmToUMI(psMsg);
}


/**********************************************************************************
handleCddTable

Description:
------------
	Cdd table handler 
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

/*void handleCddTable(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 cols = pShramAddress[PSD_NUM_OF_COLS_INDEX];
	uint16 rowIndex, colIndex;
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(CddPermutationsDb_t));
	CddPermutationsDb_t *cddPsdDb = (CddPermutationsDb_t *)pK_MSG_DATA(kMsg_p);

	ASSERT(rows <= (CDD_MAX_NUMBER_OF_ANTENNAS-1));
	ASSERT(cols <= (CDD_MAX_NUMBER_OF_PERMUTATIONS+1));

	// Fill CDD DB with CDD_INVALID_PERMUTATION in order to support tables that have smaller dimensions
	memset(cddPsdDb, (uint8)CDD_INVALID_PERMUTATION, sizeof(CddPermutationsDb_t));
	
	// Write table's data in DB
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		for (colIndex = 0; colIndex < cols; colIndex++)
		{
			cddPsdDb->cddMatrix[rowIndex].permutations[colIndex] = pShramAddress[PSD_TABLE_START_INDEX + cols * rowIndex + colIndex];
		}
	}
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_CDD_SET_PSD_DATA_REQ, TASK_LINK_ADAPTATION, kMsg_p);

	PSD_sendCfmToUMI(psMsg);

}*/

/**********************************************************************************
handlePhyDumpsTable

Description:
------------
	Phy Dumps table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handlePhyDumpsTable(K_MSG *psMsg)
{
	PhyDumpsHeader_t header;
	uint32 *p32CurAddress;
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	
	DEBUG_ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_PHY_DUMPS_TABLE_NUM_OF_COLS);
	
	p32CurAddress = pShramAddress + PSD_REG_ADDR_OFFSET;
	
	// Read next header:
	MEMCPY(&header, p32CurAddress, sizeof(PhyDumpsHeader_t));

	while ((p32CurAddress) < (pShramAddress + PSD_REG_ADDR_OFFSET + rows))
	{
		p32CurAddress += sizeof(PhyDumpsHeader_t)/sizeof(uint32);
		
		memcpy32((uint32*)header.u32StartAddress, p32CurAddress, header.u32Length);

		//Update address pointer and read next section:
		p32CurAddress += header.u32Length;
		//Read next section data:
		MEMCPY(&header, p32CurAddress, sizeof(PhyDumpsHeader_t));
	}
	PSD_sendCfmToUMI(psMsg);
}
/**********************************************************************************
handleBfActivationBitmap

Description:
------------
	Cdd table handler 
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handleBfActivationBitmap(K_MSG *psMsg)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 cols = pShramAddress[PSD_NUM_OF_COLS_INDEX];

	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(laBfPsdActBitmapMsgParams_t));
	laBfPsdActBitmapMsgParams_t *bfActivationBitmapMsg_p = (laBfPsdActBitmapMsgParams_t *)pK_MSG_DATA(kMsg_p);

	uint16 totalSizeOfTableInBytes = rows*cols;
	
	DEBUG_ASSERT((cols == PSD_BF_ACTIVATION_BITMAP_NUM_OF_COLS) && (rows == PSD_BF_ACTIVATION_BITMAP_NUM_OF_ROWS));
	
	// Write value to local var
	MEMCPY((void*)&bfActivationBitmapMsg_p->activationBitmap, &pShramAddress[PSD_TABLE_START_INDEX], totalSizeOfTableInBytes);
	// Send data to LA
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_ACT_BITMAP_PSD_REQ, TASK_LINK_ADAPTATION, kMsg_p, psMsg->header.vapId);

	PSD_sendCfmToUMI(psMsg);
}
/**********************************************************************************
sendPsdPowerAdaptationMsg

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void sendPsdPowerAdaptationMsg(PowerAdaptationTableType_e tableType, K_MSG * psMsg)
{

	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(laSetPowerAdaptationPsdTablesMsg_t));
	laSetPowerAdaptationPsdTablesMsg_t *powerAdaptationPsdMsg_p = (laSetPowerAdaptationPsdTablesMsg_t *)pK_MSG_DATA(kMsg_p);
	powerAdaptationPsdMsg_p->psMsg = psMsg;
	powerAdaptationPsdMsg_p->psdShramAddress = pShramAddress;
	powerAdaptationPsdMsg_p->tableType = tableType;
	// Send data to LA
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_POWER_ADAPTATION_PSD_REQ, TASK_LINK_ADAPTATION, kMsg_p, psMsg->header.vapId);

}

/**********************************************************************************
handlePower11bTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePower11bHighTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11B_HIGH_TABLE, psMsg);
}
void handlePower11bLowTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11B_LOW_TABLE, psMsg);
}

/**********************************************************************************
handlePower11agTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePower11agHighTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AG_HIGH_TABLE, psMsg);
}
void handlePower11agLowTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AG_LOW_TABLE, psMsg);
}

/**********************************************************************************
handlePower11nTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePower11nHighTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11N_HIGH_TABLE, psMsg);
}
void handlePower11nLowTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11N_LOW_TABLE, psMsg);
}

/**********************************************************************************
handlePower11acTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePower11acHighTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AC_HIGH_TABLE, psMsg);
}
void handlePower11acLowTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AC_LOW_TABLE, psMsg);
}

void handlePower11acMuHighTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AC_MU_HIGH_TABLE, psMsg);
}

void handlePower11acMuLowTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AC_MU_LOW_TABLE, psMsg);
}
void handlePowerOffsetHighLow(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_OFFSET_HIGH_LOW_TABLE, psMsg);
}
void handlePowerLimitMUAndBF(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(POWER_LIMIT_TABLE, psMsg);
}

void handlePower11axTable(K_MSG *psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600
	sendPsdPowerAdaptationMsg(POWER_OFFSET_11AX_TABLE, psMsg);
#else
	handleIgnoredTableId(psMsg);
#endif
}

/**********************************************************************************
handlePowerProximateStaBackoffTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePowerProximateStaBackoffTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(PROXIMATE_STA_BACKOFF_TABLE, psMsg);


}
/**********************************************************************************
handlePowerDistantStaBackoffTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePowerDistantStaBackoffTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(DISTANT_STA_BACKOFF_TABLE, psMsg);
}
/**********************************************************************************
handlePowerInternalPowerLowerLimitTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePowerInternalPowerLowerLimitTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(INTERNAL_POWER_LOWER_LIMIT_TABLE, psMsg);
}
/**********************************************************************************
handleInitialRateAccordingToRssiHtVhtTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handleInitialRateAccordingToRssiHtVhtTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(INITIAL_RATE_11NAC_TABLE, psMsg);
}

/**********************************************************************************
handlePowerInternalPowerLowerLimitTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handleInitialRateAccordingToRssi11AgTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(INITIAL_RATE_11AG_TABLE, psMsg);
}
/**********************************************************************************
handleInitialRateAccordingToRssi11bTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

 void handleInitialRateAccordingToRssi11bTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(INITIAL_RATE_11B_TABLE, psMsg);
}
/**********************************************************************************
handlePowerExternalPowerLowerLimitTable

Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void handlePowerExternalPowerLowerLimitTable(K_MSG *psMsg)
{
	sendPsdPowerAdaptationMsg(EXTERNAL_POWER_LOWER_LIMIT_TABLE, psMsg);
}

/**********************************************************************************
handleAntennaMaskPerChannelTable


Description:
------------
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleAntennaMaskPerChannelTable(K_MSG * psMsg)
{
	SetChannelParams_t* SetChannelParams_p = HDK_getSetChannelParams();
	uint32 index;
	uint8 region;
	uint8 segment;
	uint8 numRows;
	uint32 ZwdfsMask= Hdk_GetMaxTxAntMask(); 

	numRows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	for (region = 0; region < numRows; region++)
	{
		index = PSD_TABLE_START_INDEX + region * (NUM_SEGMENTS + 1);
		AntMaskPerChannelDB[region][0] = pShramAddress[index];
		for (segment = 0; segment < NUM_SEGMENTS; segment++)
		{
			index++;
			AntMaskPerChannelDB[region][segment + 1] = pShramAddress[index];

			if (TRUE == ConfigurationManager_GetIsDualBandZWDFS())
			{
				ZwdfsMask &= AntMaskPerChannelDB[region][segment + 1];
				AntMaskPerChannelDB[region][segment + 1] = PsdFieldsDb[PSD_FIELD_TX_ANTS_MASK];
			}
			else
			{
				ZwdfsMask = 0x0;
			}
		}
		
	}

	SetChannelParams_p->ZwdfsAntMask = ZwdfsMask;

	PSD_sendCfmToUMI(psMsg);
}

/**********************************************************************************
PSD_setNewChannel


Description:
------------
	Invalid table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void PSD_setNewChannel(uint8 channel)
{
	uint8 region = 0;

	while (region != 0xff)
	{
		if (channel <= AntMaskPerChannelDB[region][0])
		{
			currentAntennaMask = AntMaskPerChannelDB[region][1];
			PsdFieldsDb[PSD_FIELD_TX_ANTS_MASK] = currentAntennaMask;
			PsdFieldsDb[PSD_FIELD_RX_ANTS_MASK] = currentAntennaMask;
			region = 0xff; //mark end of loop
		}
		else
		{
			region++;
			ASSERT(region < MAX_NUM_OF_ANTENNA_MASK_REGIONS);
		}
	}
}


/**********************************************************************************
handleBandEdgeTxValueTable

Description:
------------
	read BandEdgeTxValue Table
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleBandEdgeTxValueTable(K_MSG * psMsg)
{
	phyDrv_SetBandEdgeFixForTxWindow(&(pShramAddress[PSD_TABLE_START_INDEX]));
	PSD_sendCfmToUMI(psMsg);
}


/**********************************************************************************
handleInvalidTableId

Description:
------------
	Invalid table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
void handleInvalidTableId(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
	ASSERT(0);
}

/**********************************************************************************
handleIgnoredTableId


Description:
------------
	Ignored table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleIgnoredTableId(K_MSG * psMsg)
{

	PSD_sendCfmToUMI(psMsg);
}

/**********************************************************************************
handleFourierPhases4x4Table 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleFourierPhases1x1Table(K_MSG *psMsg)
{
	
	handleFourierPhasesTables(psMsg, PHY_FOURIER_PHASES_1X1_TABLE, PHY_FOURIER_PHASES_1X1_TABLE_SIZE);

	PSD_sendCfmToUMI(psMsg);
	
}
/**********************************************************************************
handleFourierPhases2x2Table 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleFourierPhases2x2Table(K_MSG *psMsg)
{
	
	handleFourierPhasesTables(psMsg, PHY_FOURIER_PHASES_2X2_TABLE, PHY_FOURIER_PHASES_2X2_TABLE_SIZE);

	PSD_sendCfmToUMI(psMsg);
	
}
/**********************************************************************************
handleFourierPhases3x3Table 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleFourierPhases3x3Table(K_MSG *psMsg)
{
	handleFourierPhasesTables(psMsg, PHY_FOURIER_PHASES_3X3_TABLE, PHY_FOURIER_PHASES_3X3_TABLE_SIZE);

	PSD_sendCfmToUMI(psMsg);
	
}
/**********************************************************************************
handleFourierPhases4x4Table 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleFourierPhases4x4Table(K_MSG *psMsg)
{

	handleFourierPhasesTables(psMsg, PHY_FOURIER_PHASES_4X4_TABLE, PHY_FOURIER_PHASES_4X4_TABLE_SIZE);

	PSD_sendCfmToUMI(psMsg);
	
}

/**********************************************************************************
handleFourierPhasesTables 

Description:
------------
	Phy Fields table handler
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
static void handleFourierPhasesTables(K_MSG *psMsg, PhyAntConfigTableId_e antConfigTableId, uint8 tableMaxSize)
{
	uint16 rows = pShramAddress[PSD_NUM_OF_ROWS_INDEX];
	uint16 rowIndex;
	PhyCompFourierPhasesTableDefinition_t* PhyAntConfigTablesPtr = &psdCompressedFourierPhasesTablesArr[antConfigTableId];
	UNUSED_PARAM(psMsg);	
	
	ASSERT(pShramAddress[PSD_NUM_OF_COLS_INDEX] == PSD_PHY_FIELDS_TABLE_NUM_OF_COLS);
	ASSERT(rows <= tableMaxSize);

	PhyAntConfigTablesPtr->phyAntConfigTableSize = rows;	
	// Write table's data in registers
	for (rowIndex = 0; rowIndex < rows; rowIndex++)
	{
		PhyAntConfigTablesPtr->PhyAntConfigTablePtr[rowIndex].address = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_ADDR_OFFSET];
		PhyAntConfigTablesPtr->PhyAntConfigTablePtr[rowIndex].mask    = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_MASK_OFFSET];
		PhyAntConfigTablesPtr->PhyAntConfigTablePtr[rowIndex].value   = pShramAddress[PSD_PHY_FIELDS_TABLE_NUM_OF_COLS*rowIndex + PSD_REG_VALUE_OFFSET];
	}
}
/**********************************************************************************
setPsdShramAddress 

Description:
------------
	
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/

void setPsdShramAddress(uint32* psdProgmodelShramAddress)
{
	pShramAddress = psdProgmodelShramAddress;
}
/**********************************************************************************
PhyCompFourierPhasesTableDefinition_t 

Description:
------------
	
Input: 
-----
	None	
Output:
-------
	None
**********************************************************************************/
PhyCompFourierPhasesTableDefinition_t* getCompressedFourierPhasesTable(uint8 numOfAnt)
{
	PhyCompFourierPhasesTableDefinition_t* retTable;
	if (numOfAnt > 0)
	{
		PhyAntConfigTableId_e tableId = (PhyAntConfigTableId_e)(numOfAnt-1);
		if (psdCompressedFourierPhasesTablesArr[tableId].phyAntConfigTableSize != 0)
		{
			retTable = &psdCompressedFourierPhasesTablesArr[tableId];
		}
		else
		{
			retTable = NULL;
		}
	}
	else
	{
		retTable = NULL;
	}

	return retTable;
}

