#include <stdint.h>
#include "target.h"
#include "interface_abb.h"
#include "abb_tb_defines.h"
#include "MacGeneralRegs.h"
#include "EmeraldEnvRegs.h"
#include "PhyRxTdAnt0Regs.h"
#include "PhyTxTdAnt0Regs.h"
#include "PhyRxTdAnt1Regs.h"
#include "PhyTxTdAnt1Regs.h"
#include "PhyRxTdAnt2Regs.h"
#include "PhyTxTdAnt2Regs.h"
#include "PhyRxTdAnt3Regs.h"
#include "PhyTxTdAnt3Regs.h"
#include "phy_lib.h"
#include "Afe_API.h"
#include "loggerAPI.h"
// Configuration Section:

//#define USE_FCSI_SINGLE_PORT_ACC


void ABB_vPortWrite (uint32_t P_ulPort, uint32_t P_ulValue)
{
	uint32 antmask;
	RegPhyRxtdAnt0PhyRxtdAntReg4B_u regPhyAnt;
	RegMacGeneralFcsiCtl_u regMacFcsiCtrl;
	RegEmeraldEnvPllCtl_u regPllCtrl;
	RegMacGeneralSpareConfigD2A_u regSpareCfg;
	RegEmeraldEnvPllEn_u regPllEn;
	RegPhyRxtdAnt0RxAbbAntReg71_u rxAbbAntReg;
	RegPhyTxtdAnt0TxAbb30_u       txAbbAntReg;

	antmask = Hdk_GetTxAntMask();
	regPhyAnt.val = 0;

	switch (P_ulPort)
	{
		case FCSI2_RST_N_0:
			if ((antmask & 0x1) != 0)
			{
				regPhyAnt.bitFields.fcsiMsResetAntennasN = P_ulValue;
				regPhyAnt.bitFields.fcsiRfResetN = P_ulValue;
				RegAccess_Write(REG_PHY_RXTD_ANT0_PHY_RXTD_ANT_REG4B, regPhyAnt.val);
			}
			break;
		case FCSI2_RST_N_1:
			if ((antmask & 0x2) != 0)
			{				
				regPhyAnt.bitFields.fcsiMsResetAntennasN = P_ulValue;
				regPhyAnt.bitFields.fcsiRfResetN = P_ulValue;
				RegAccess_Write(REG_PHY_RXTD_ANT1_PHY_RXTD_ANT_REG4B, regPhyAnt.val);
			}
			break;
		case FCSI2_RST_N_2:
			if ((antmask & 0x4) != 0)
			{
				regPhyAnt.bitFields.fcsiMsResetAntennasN = P_ulValue;
				regPhyAnt.bitFields.fcsiRfResetN = P_ulValue;
				RegAccess_Write(REG_PHY_RXTD_ANT2_PHY_RXTD_ANT_REG4B, regPhyAnt.val);
			}
			break;
		case FCSI2_RST_N_3:
			if ((antmask & 0x8) != 0)
			{
				regPhyAnt.bitFields.fcsiMsResetAntennasN = P_ulValue;
				regPhyAnt.bitFields.fcsiRfResetN = P_ulValue;
				RegAccess_Write(REG_PHY_RXTD_ANT3_PHY_RXTD_ANT_REG4B, regPhyAnt.val);
			}
			break;
		case FCSI2_RST_N_C:
			RegAccess_Read(REG_MAC_GENERAL_FCSI_CTL, &regMacFcsiCtrl.val);			
			regMacFcsiCtrl.bitFields.fcsiMsRstqcD2A   = P_ulValue;
			regMacFcsiCtrl.bitFields.fcsiRfResetQcD2A = P_ulValue;
			RegAccess_Write(REG_MAC_GENERAL_FCSI_CTL, regMacFcsiCtrl.val);
			break;
		case lcpll_pup_d2a:
			RegAccess_Read(REG_EMERALD_ENV_PLL_CTL, &regPllCtrl.val);
			regPllCtrl.bitFields.lcpllPupD2A = 1;
			PHY_SECURE_WRITE();
			RegAccess_Write(REG_EMERALD_ENV_PLL_CTL, regPllCtrl.val);
			break;
		case lcpll_resn_d2a:
			RegAccess_Read(REG_EMERALD_ENV_PLL_CTL, &regPllCtrl.val);
			regPllCtrl.bitFields.lcpllResetnD2A = 1;
			PHY_SECURE_WRITE();
			RegAccess_Write(REG_EMERALD_ENV_PLL_CTL, regPllCtrl.val);
			break;
		case lcpll_div_d2a:
			break;
		case spare_config_i_d2a:
			RegAccess_Read(REG_MAC_GENERAL_SPARE_CONFIG_D2A, &regSpareCfg.val);
			regSpareCfg.bitFields.spareConfigD2A = P_ulValue;
			RegAccess_Write(REG_MAC_GENERAL_SPARE_CONFIG_D2A, regSpareCfg.val);
			break;
		case pd_clk_sc_d2a:
			RegAccess_Read(REG_EMERALD_ENV_PLL_EN, &regPllEn.val);
			regPllEn.bitFields.wlanClkPdnD2A = 0;
			PHY_SECURE_WRITE();
			RegAccess_Write(REG_EMERALD_ENV_PLL_EN, regPllEn.val);
			break;		
		case SC2FC_FC2SC:		
			//ANT0
			if ((antmask & 0x1) != 0)
			{
				RegAccess_Read(REG_PHY_RXTD_ANT0_RX_ABB_ANT_REG71, &rxAbbAntReg.val);
				rxAbbAntReg.bitFields.rxSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_RXTD_ANT0_RX_ABB_ANT_REG71, rxAbbAntReg.val);

				RegAccess_Read(REG_PHY_TXTD_ANT0_TX_ABB_30, &txAbbAntReg.val);
				txAbbAntReg.bitFields.txSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_TXTD_ANT0_TX_ABB_30, txAbbAntReg.val);
			}
			//ANT1
			if ((antmask & 0x2) != 0)
			{
				RegAccess_Read(REG_PHY_RXTD_ANT1_RX_ABB_ANT_REG71, &rxAbbAntReg.val);
				rxAbbAntReg.bitFields.rxSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_RXTD_ANT1_RX_ABB_ANT_REG71, rxAbbAntReg.val);

				RegAccess_Read(REG_PHY_TXTD_ANT1_TX_ABB_30, &txAbbAntReg.val);
				txAbbAntReg.bitFields.txSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_TXTD_ANT1_TX_ABB_30, txAbbAntReg.val);
			}
			//ANT2
			if ((antmask & 0x4) != 0)
			{
				RegAccess_Read(REG_PHY_RXTD_ANT2_RX_ABB_ANT_REG71, &rxAbbAntReg.val);
				rxAbbAntReg.bitFields.rxSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_RXTD_ANT2_RX_ABB_ANT_REG71, rxAbbAntReg.val);

				RegAccess_Read(REG_PHY_TXTD_ANT2_TX_ABB_30, &txAbbAntReg.val);
				txAbbAntReg.bitFields.txSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_TXTD_ANT2_TX_ABB_30, txAbbAntReg.val);
			}
			//ANT3
			if ((antmask & 0x8) != 0)
			{
				RegAccess_Read(REG_PHY_RXTD_ANT3_RX_ABB_ANT_REG71, &rxAbbAntReg.val);
				rxAbbAntReg.bitFields.rxSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_RXTD_ANT3_RX_ABB_ANT_REG71, rxAbbAntReg.val);

				RegAccess_Read(REG_PHY_TXTD_ANT3_TX_ABB_30, &txAbbAntReg.val);
				txAbbAntReg.bitFields.txSc2FcPhaseRegfile = 0x2;
				RegAccess_Write(REG_PHY_TXTD_ANT3_TX_ABB_30, txAbbAntReg.val);
			}
			break;
		default:
			//ASSERT(0);
			break;
	}
}

void ABB_vPortsWrite (uint32_t P_ulPort, uint32_t P_ulWidth, uint32_t P_ulValue)
{
	RegEmeraldEnvPllDiv_u regPllDiv;
	UNUSED_PARAM(P_ulWidth);
	switch (P_ulPort)
	{
		case op_freq_sel_sc_d2a:
			RegAccess_Read(REG_EMERALD_ENV_PLL_DIV, &regPllDiv.val);
			regPllDiv.bitFields.wlanClkDivD2A = P_ulValue;
			PHY_SECURE_WRITE();
			RegAccess_Write(REG_EMERALD_ENV_PLL_DIV, regPllDiv.val);
			break;
		default:
			//ASSERT(0);
			break;
	}
}

uint32_t ABB_ulPortRead (uint32_t P_ulPort)
{
	UNUSED_PARAM(P_ulPort);	
	return 0;
}

void ABB_wait_us(uint32_t cnt)
{
	ABB_wait(cnt, 1);
}


// Multiport Implementation
// -----------------------------------


void ABB_vFcsiWrite( void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;
	UNUSED_PARAM(P_pvMirror);
	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}

	AFE_WriteRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values);
}


void ABB_vFcsiRmw(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;
	UNUSED_PARAM(P_pvMirror);

	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}
	
	AFE_WriteMaskRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values, (uint32)(~P_usMask));
}


uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t *P_pusData)
{
	UNUSED_PARAM(P_usAntenna);	
	UNUSED_PARAM(P_pvMirror);
	AFE_ReadRegister((uint32)P_usAddress, P_pusData);

	return 0;
}

// uint16 --> unsigned integer 16bit
// us --> unsigned short endspricht dem unsigned integer
// P --> parameter
// < ...> --> header out of c library
// "..." --> self written header
// ...



