#ifndef _INTERFACE_H
#define _INTERFACE_H

#include <stdint.h>
#include "fcsi_access_functions.h"
#include "fcsi_access_defines.h"

// define for ISR
#define NULL_POINTER 0

// Defines for Antenna Access
#define ABB_ANTENNA0	1 // 0 0001
#define ABB_ANTENNA1   	2 // 0 0010
#define ABB_ANTENNA2	4 // 0 0100
#define ABB_ANTENNA3    8 // 0 1000
#define ABB_CENTRAL 	16 //1 0000

#define NR_OF_ANTENNAS 5

#define ABB_ANT0_INDEX		0
#define ABB_ANT1_INDEX		1
#define ABB_ANT2_INDEX		2
#define ABB_ANT3_INDEX		3
#define ABB_CENTRAL_INDEX       4

// for ISR release: comment out and remove all *mirror* statements
//extern void* ABB_fcsi_mirror;

#define ABB_DIR_CTRL_WRITE(port_name, value)          ABB_vPortWrite(port_name, value)         // direct control of port
#define ABB_DIR_CTRL_READ(port_name)                  ABB_ulPortRead(port_name)         // direct control of port
#define ABB_DIR_CTRL_WRITES(port_name, width, value)  ABB_vPortsWrite(port_name, width, value) // direct control of a bus

#define ABB_FCSI_RMW(antenna, address, mask, value)   ABB_vFcsiRmw(NULL, antenna, address, mask, value)
#define ABB_FCSI_READ(antenna, address, data)         ABB_usFcsiRead(NULL, antenna, address, data)
#define ABB_FCSI_WRITE(antenna, address, value)       ABB_vFcsiWrite(NULL, antenna, address, value)

//#define ABB_FCSI_RMW(antenna, address, mask, value)   ABB_vFcsiRmw(ABB_fcsi_mirror, antenna, address, mask, value)
//#define ABB_FCSI_READ(antenna, address, data)         ABB_usFcsiRead(ABB_fcsi_mirror, antenna, address, data)
//#define ABB_FCSI_WRITE(antenna, address, value)       ABB_vFcsiWrite(ABB_fcsi_mirror, antenna, address, value)

#endif //  _INTERFACE_H

// v: void --> no values returned
// macros & defines are written with capital letters
