#include <math.h>
#include <stdint.h>
#include "lib_wrx654_api.h"
#include "lib_wrx654_sequences.h"
#include "RficDriver_API.h"
#include "loggerAPI.h"

// Debug mode on/off
#define DEBUG 0

void check_parameter(int nParamA, int nParamW);
void RFIC_FCSI_Write_mex(uint16_t AntMsk, uint16_t address, uint16_t value);
void RFIC_FCSI_ParWrite_mex(uint16_t AntMsk, uint16_t address, uint16_t* value);
void RFIC_FCSI_RMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t value);
void RFIC_FCSI_ParRMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t* value);
uint16_t RFIC_FCSI_Read_mex(uint16_t AntMsk, uint16_t address, uint16_t *rdata);


// The gateway function
void check_parameter(int nParamA, int nParamW)
{
	UNUSED_PARAM(nParamA);	
	UNUSED_PARAM(nParamW);	
}

void RFIC_FCSI_Write_mex(uint16_t AntMsk, uint16_t address, uint16_t value)
{
	writeOneValueToAntList((AntennaBitmaps_e)AntMsk, (uint32)address, (uint32)value, RFIC_DEFAULT_MASK, RFIC_NO_SHIFT, TRUE);
}
void RFIC_FCSI_ParWrite_mex(uint16_t AntMsk, uint16_t address, uint16_t* value)
{
	writeToRficRegister((AntennaBitmaps_e)AntMsk, (uint32)address, (uint16*)value, RFIC_DEFAULT_MASK, RFIC_NO_SHIFT, TRUE);
}
void RFIC_FCSI_RMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t value)
{
	writeOneValueToAntList((AntennaBitmaps_e)AntMsk, (uint32)address, (uint32)value, (uint32)(~mask), RFIC_NO_SHIFT, TRUE);
}
void RFIC_FCSI_ParRMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t* value)
{
	writeToRficRegister((AntennaBitmaps_e)AntMsk, (uint32)address, (uint16*)value, (uint32)(~mask), RFIC_NO_SHIFT, TRUE);
}
uint16_t RFIC_FCSI_Read_mex(uint16_t AntMsk, uint16_t address, uint16_t *rdata)
{
	UNUSED_PARAM(AntMsk);	
	RficDriver_ReadRegister((uint32)address, rdata);
	return 0;
}
