

// ISO/IEC 9899:1999  7.18 Integer types <stdint.h>


 #ifndef __STDINT_H_
 #define __STDINT_H_

 #include "System_GlobalDefinitions.h"
 
 /** \file */
 /** \defgroup avr_stdint <stdint.h>: Standard Integer Types
     \code #include <stdint.h> \endcode
 
     Use [u]intN_t if you need exactly N bits.
 
     Since these typedefs are mandated by the C99 standard, they are preferred
     over rolling your own typedefs.  */
 
 /*
  * __USING_MINT8 is defined to 1 if the -mint8 option is in effect.
  */
 #if __INT_MAX__ == 127
 # define __USING_MINT8 1
 #else
 # define __USING_MINT8 0
 #endif
 
 /* Integer types */
 
// #if defined(__DOXYGEN__)
   // 8-bit signed type. 
 typedef int8 int8_t;
 
 // 	8-bit unsigned type. */
 typedef uint8 uint8_t;
 
	 // 16-bit signed type. */
 
 typedef int16 int16_t;
  
 
 // 	16-bit unsigned type. */
 typedef uint16 uint16_t;
 //    32-bit signed type. */
 typedef int32 int32_t;
 //    32-bit unsigned type. */
 typedef uint32 uint32_t;

 typedef uint32 uintptr_t;
 
 //    64-bit signed type.
 typedef int64 int64_t;
 //   64-bit unsigned type.
 
 typedef uint64 uint64_t;
 
typedef double double_t;



 
 
 #endif /* _STDINT_H_ */
