#include <stdint.h>
#include "interface_abb.h"
//#include "fcsvtb_fcsi2_n_dpi.h"
#include "Afe_API.h"
#include "tb_abb11ac_fcsi2_n_defines.h"
// Configuration Section:


#ifdef USE_FCSI_SINGLE_PORT_ACC

void ABB_vFcsiRmw(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;

	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}
	
	AFE_WriteMaskRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values, (uint32)P_usMask);
}



uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress)
{
	uint16 Values[FCSI_TOTAL_CHANNELS];
	
	AFE_ReadRegister((uint32)P_usAddress, Values);

	return Values[P_usAntenna];
}

void ABB_vFcsiWrite( void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;

	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}

	AFE_WriteRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values);
}




#else

// Multiport Implementation
// -----------------------------------


void ABB_vFcsiWrite( void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;

	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}

	AFE_WriteRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values);
}


void ABB_vFcsiRmw(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue)
{
	uint16	Values[FCSI_TOTAL_CHANNELS];
	uint8	index;

	for (index = 0; index < FCSI_TOTAL_CHANNELS; index++)
	{
		Values[index] = P_usValue;
	}
	
	AFE_WriteMaskRegisters((AntennaBitmaps_e)P_usAntenna, (uint32)P_usAddress, Values, (uint32)(~P_usMask));
}


uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t *P_pusData)
{
	AFE_ReadRegister((uint32)P_usAddress, P_pusData);

	return 0;
}

#endif
// uint16 --> unsigned integer 16bit
// us --> unsigned short endspricht dem unsigned integer
// P --> parameter
// < ...> --> header out of c library
// "..." --> self written header
// ...



