#ifndef _INTERFACE_H

#define _INTERFACE_H



#include <stdint.h>



/* register packages */

#include "antenna_fcsi_regpkg.h"

#include "central_fcsi_regpkg.h"

#include "fcsi_access_defines.h"
#include "fcsi_access_functions.h"

/*#include "ant_fcsi_addrmap.h"

#include "antenna_clockbiasldoanamux_fcsi_regpkg.h"

#include "antenna_dac40m_macro_fcsi_regpkg.h"

#include "antenna_sdadc40m_macro_fcsi_regpkg.h"

#include "antenna_ssiadc_fcsi_regpkg.h"



#include "central_fcsi_addrmap.h"

#include "central_centralstuff_fcsi_regpkg.h"

#include "central_lcpll_macro_fcsi_regpkg.h"



#include "fcsi_access_defines.h"
*/


// Defines for Antenna Access
#define ABB_ANT0 		1 //00001
#define ABB_ANT1 		2 //00010
#define ABB_ANT10		3 //00011
#define ABB_ANT2 		4 //00100
#define ABB_ANT20 		5 //00101
#define ABB_ANT21 		6 //00110
#define ABB_ANT210 		7 //00111
#define ABB_ANT3 		8 //01000
#define ABB_ANT30 		9 //01001
#define ABB_ANT31 	       10 //01010
#define ABB_ANT310 	       11 //01011
#define ABB_ANT32 	       12 //01100
#define ABB_ANT320 	       13 //01101
#define ABB_ANT321 	       14 //01110
#define ABB_ANT3210 	       15 //01111

#define ABB_CENTRAL 	       16 //10000

#define NR_OF_ANTENNAS 5

#define ABB_ANT0_INDEX		0
#define ABB_ANT1_INDEX		1
#define ABB_ANT2_INDEX		2
#define ABB_ANT3_INDEX		3
#define ABB_CENTRAL_INDEX       4

#define NULL_POINTER		0


#define ABB_DIR_CTRL_WRITE(port_name, value)         // direct control of port

#define ABB_DIR_CTRL_READ(port_name)                 (0) // direct control of port

#define ABB_DIR_CTRL_WRITES(port_name, width, value) // direct control of a bus


#define ABB_FCSI_RMW(antenna, address, mask, value) ABB_vFcsiRmw(NULL_POINTER, antenna, address, mask, value)

#define ABB_FCSI_Read(antenna, address, data)       ABB_usFcsiRead(NULL_POINTER, antenna, address, data)

#define ABB_FCSI_Write(antenna, address, value)     ABB_vFcsiWrite(NULL_POINTER, antenna, address, value)

#define debug_printf(...)  


#endif //  _INTERFACE_H



// v: void --> no values returned

// macros & defines are written with capital letters

