#include "stdint.h"
#include "RficDriver_API.h"
#include "mt_sysrst.h"

void RFIC_FCSI_Write_mex(uint16_t AntMsk, uint16_t address, uint16_t value)
{
	writeOneValueToAntList((AntennaBitmaps_e)AntMsk, (uint32)address, (uint32)value, RFIC_DEFAULT_MASK, RFIC_NO_SHIFT, TRUE);
}

void RFIC_FCSI_RMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t value)
{
	writeOneValueToAntList((AntennaBitmaps_e)AntMsk, (uint32)address, (uint32)value, (uint32)(~mask), RFIC_NO_SHIFT, TRUE);
}

uint16_t RFIC_FCSI_Read_mex(uint16_t AntMsk, uint16_t address, uint16_t *rdata)
{
	RficDriver_ReadRegister((uint32)address, rdata);
	return 0;
}
