#include <stdint.h>
#include "target.h"
#include "interface_rf_4x4.h"
#include "lib_rf_4x4_api.h"
#include "lib_rf_4x4_sequences.h"

/* register packages */
#include "wrx524_fcsi0_addrmap.h"
#include "rf_antenna0_fcsi_fieldpkg.h"
#include "rf_antenna0_fcsi_regpkg.h"
#include "wrx524_fcsi1_addrmap.h"
#include "rf_antenna1_fcsi_fieldpkg.h"
#include "rf_antenna1_fcsi_regpkg.h"
#include "wrx524_fcsi2_addrmap.h"
#include "rf_antenna2_fcsi_fieldpkg.h"
#include "rf_antenna2_fcsi_regpkg.h"
#include "wrx524_fcsi3_addrmap.h"
#include "rf_antenna3_fcsi_fieldpkg.h"
#include "rf_antenna3_fcsi_regpkg.h"

//-------------------------------------------------------------------------
// Init Sequence (rfic_init_1/2/3/4 and required waits in between)
//-------------------------------------------------------------------------
void rfic_seq_init(void)
{
	// init_1
	rfic_init_1();
	// wait 50ms for band gap settling
	RFIC_Wait(50000);
	// init_2
	rfic_init_2();
	// wait 10us
	RFIC_Wait(10);
	// init_3
	rfic_init_3();
	// wait 10us
	RFIC_Wait(10);
	// init_4
	rfic_init_4();
}
