/***********************************************************************************
 File:			HdkContinuousInterfererDetection.h
 Module:		HDK
 Purpose: 		Detect none wifi interferers
 Description:	This file contains all the definitions and structures of the 
 				HDK continuous interferer detection module which is responsible to 
 				manage the continuous interferer detection PHY genrisc FIFO 
 				processing.
************************************************************************************/
#ifndef HDK_CONTINUOUS_INTERFERER_DETECTION_H_
#define HDK_CONTINUOUS_INTERFERER_DETECTION_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Hdk_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 
//TBD when these values are passed in initialization this section should be removed
#define HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_POLLING_TIMEOUT_IN_MILISECONDS 50
#define HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_POLLING_TIMEOUT_IN_TICKS  (OSAL_TIMERS_MS_TO_K_TICKS(HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_POLLING_TIMEOUT_IN_MILISECONDS))
#define HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_POLLING_TIMEOUT_IN_MILISECONDS 20
#define HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_POLLING_TIMEOUT_IN_TICKS  (OSAL_TIMERS_MS_TO_K_TICKS(HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_POLLING_TIMEOUT_IN_MILISECONDS))
#define HDK_CONTINUOUS_INTERFERER_DETECTION_NORMAL_NOTIFICATION_TIMEOUT 100
#define HDK_CONTINUOUS_INTERFERER_DETECTION_SCAN_NOTIFICATION_TIMEOUT 1
////

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct HdkContinuousInterfererDetectionParameters_s
{
	uint32	normalPollingTimeout;
	uint32	scanPollingTimeout;
	uint32	normalNotificationTimeout;
	uint32	scanNotificationTimeout;
	uint32	currentPollingTimeout;
	uint32	currentNotificationTimeout;
	uint32  pollingTimeoutCounter;
	
	uint8   isContinuousInterfererDetectionEnabled;
	uint8   reserved[3];
}HdkContinuousInterfererDetectionParameters_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void HdkContinuousInterfererDetection_TimerExpired(void);
void HdkContinuousInterfererDetection_SetChannelRequest(HdkSetChannelReqParams_t *setChannelRequestParameters);
void HdkContinuousInterfererDetection_Initialize(void);

#endif /* HDK_CONTINUOUS_INTERFERER_DETECTION_H_ */

