/***********************************************************************************
 File:			HdkRadarDetection.h
 Module:		HDK
 Purpose: 		Detect none wifi interferers
 Description:	This file contains all the definitions and structures of the 
 				HDK radar detection module which is responsible to manage the radar
 			    detection PHY genrisc FIFO processing.
************************************************************************************/
#ifndef HDK_RADAR_DETECTION_H_
#define HDK_RADAR_DETECTION_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Hdk_Api.h"


//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 
#define HDK_RADAR_DETECTION_TIMER_IN_MICROSECONDS (5000)
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct HdkRadarDetectionParameters_s
{
	uint8   isRadarDetectionSupported;
	uint8   isRadarDetectionEnabled;
	uint16  reserved;
}HdkRadarDetectionParameters_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void HdkRadarDetection_TimerExpired(void);
void HdkRadarDetection_SetChannelRequest(HdkSetChannelReqParams_t *setChannelRequestParameters);
void HdkRadarDetection_Initialize(void);
bool HdkRadarDetectionIsRadarDetectionEnabled(void);

#endif /* HDK_RADAR_DETECTION_H_ */

