
#ifndef __CLBR_PARAMS_ON_THE_FLY_H
#define __CLBR_PARAMS_ON_THE_FLY_H

#include "CalibrationsDefines.h"
#include "RFICDefines.h"
#include "mhi_mib_id.h"
#include "HdkGlobalDefs.h"

typedef enum CalStatus
{
	CAL_STATUS_INIT = 0,
	CAL_STATUS_PASS,
	CAL_STATUS_IN_PROCESS,
	CAL_STATUS_FAIL,
	CAL_STATUS_STUCK
} CalStatus_e;

#ifndef ENET_INC_ARCH_WAVE600

#define MAX_NUMBER_OF_ANTENNAS_IN_PROJECT  4
/*
 * Calibration return status. Lower 3 bits are the enum result.
 * Higher bits convey error status according to specific calibrations
 */


typedef struct RficLoopbackAntennas
{
    Antenna_e RfCalibAnt;       /* input */
    Antenna_e RxLoopbackAnt;    /* output */
    Antenna_e TxLoopbackAnt;    /* output */
} RficLoopbackAntennas_t;

/*******************************************************************************/
/*********************************RxIq*******************************************/
/*******************************************************************************/
typedef struct 
{
	CalStatus_e status[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int16		w1[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];		// w1 calibration result
	int16		w2[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];		// w2 calibration result
	int16		w1_err[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];	// for debug,need to check in how much we were far from Margin
	int16		w2_err[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];	// for debug,need to check in how much we were far from Margin
	uint32		lastRunTime;
} RxIQRF_results_t;

typedef struct RxIQRF_params
{
	int32		numSamples;	
	uint8		errorPercentageW;				// error percentage allowed for w1,w2
	HdkLnaIndex_e	lnaIndex;
	int8		pgc1;		
	int8		pgc2;
	int8		pgc3;
	int8		round;
	int8		iir_mu;
} RxIQRF_params_t;

typedef struct 
{
	RxIQRF_results_t	results;
	RxIQRF_params_t		params;
} RxIQRF_elements_t;


/*******************************************************************/
/***						Constant Definitions							***/
/*******************************************************************/ 

#define W1_NUM_FRAC_BITS		(12)	// number of bits used after the decimal point for W1
#define W_ERROR_PERCENTAGE		(3)		// percentage of allowed error - changed in gen 3 from (2% error) to (3% error)
#define INITIAL_W1_VALUE		(4096)	// 1 = 2^12 = 4096 - 1 for fixed point with W1_NUM_OF_FRAC_BITS(12)
#define INITIAL_W2_VALUE		(0)		// 0
#define RX_IQ_PGC2_STEP			(6)






/*******************************************************************************/
/*********************************RxDC******************************************/
/*******************************************************************************/

typedef enum DcState
{
	DC_STATE_DAC2 = 0,
	DC_STATE_DAC1,
	DC_STATE_DAC0,
	DC_STATE_VERIFY_TX,
	DC_STATE_VERIFY_TX_HIGH_PGC3,
	DC_STATE_VERIFY_RX,
	DC_STATE_VERIFY_ONLINE
}DcState_e;

// This structure serves as the scratch pad for algorithm sessions.
// Thus, pay attention that values are not passed between algo sessions and also within the session between states
typedef struct DcDataSet
{
	int32	bestResult[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int32	minReferenceZero[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int8	residueReference[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int8	residualCorrection[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int8	correction[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int8	pgc1; 
	int8	pgc2; 
	int8	pgc3; 
	HdkLnaIndex_e	lnaIndex;
	uint8	statesToRun; // How many states of the algorithm can be visited in the current algo session F(online/offline, LNA value)
	uint8	stateCnt; // How many states have been visited during the current algo session
}DcDataSet_t;

typedef struct DcResults
{
	uint32		lastRunTime;
	uint8		errorBitmap[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	CalStatus_e	calStatus[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX]; 
}DcResults_t;

typedef struct DcParams
{
	int32	minReference[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int32	minReference1stGain[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int32	minReference2ndGain[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
	int8	linearDirection[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX]; // MUST belong to {-1, 1}, the direction of the function's linear slope
	uint32	numOfSamples; // Number of samples to be averaged by the correlator. used also for approx. of mV values
	int16	maxDcOffsetDuringCalibration;
	int16	maxDcOffsetAfterTxVerify;
	int16	maxDcOffsetAfterTxVerifyWithHighPgc3;
	int16	maxDcOffsetAfterRxVerify;
	int16	maxDcOffsetAtOnline;
	uint8	numOfDeviationFromMaxAfterTxVerify;
	int8	calState; // Current algorithm state, analogue to a row in one of the tables
	bool	isIqSwapped;
}DcParams_t;

typedef struct DcElements
{
	DcParams_t params;
	DcResults_t results;
	DcDataSet_t dataSet;
}DcElements_t;



/**********************************************************************/
/***					Lpf							***/
/**********************************************************************/

// Scratch-pad
typedef struct LpfDataSet
{
	int64					desiredPowerLevel[RFIC_PATH_TYPE_MAX];  // Energy level against which the min search is conducted
	int64					rxRefAvgEnergy[RFIC_PATH_TYPE_MAX];     // Average energy measured in the pass band in Rx loop
	int64					txRefAvgEnergy[RFIC_PATH_TYPE_MAX];     // Average energy measured in the pass band in Tx loop
	int64					txStopBinRxEnergy[RFIC_PATH_TYPE_MAX];  // Energy measured in the stop bin during Rx loop for use during Tx stop bin verify
	RficLoopbackAntennas_t	antInfo;        // Current antenna roles in the loopback
	AntennaBitmaps_e		antBitmap;      // used antenna
	int8					currToneGenAmp; // Current Tone Generator Amplitude
    uint8					numOfRfPathsToCalibrate; // is dual I and Q calibration needed, or just I branch
	bool					isIqSwap;       // Is there IQ swapping
	bool					isCB;           // Are we in channel bonding mode
}LpfDataSet_t;

// Algorithm Results
typedef struct LpfResults
{
	uint32		lastRunTime;
	CalStatus_e status[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8		passBandError[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8		stopBandError[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	uint8		antRxLpfWordsMtx[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX]; 
	uint8		antRxLpfPartialWordsMtx[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX]; // For the cases where the partial get/set is 
	uint8		antTxLpfWordsMtx[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_PATH_TYPE_MAX];
}LpfResults_t;

// Algorithm parametes
typedef struct LpfParams
{
	int8    pgc1;
	int8    pgc2;
	int8    pgc3;
	int8    toneGenAmp;
	int8    numOfCycles; 
	uint8   initialWord;
	uint8   maxNumOfEdgeBandSteps;
	int8    cbStopBandTone;
	int8    ncbStopBandTone;
	int8    passBandTone;
}LpfParams_t;

typedef struct LpfElements
{
	LpfParams_t  params;
	LpfResults_t results;
	LpfDataSet_t dataSet;
}LpfElements_t;



/**********************************************************************/
/***					RssiPath                                              					***/
/**********************************************************************/
#define RSSI_PATH_SECTION_SIZE (12)					// SECTION_SIZE must equal (SECTION_SIZE_AFTER_PARTITION*NUM_SECTION_PARTITION)
#define RSSI_PATH_SECTION_SIZE_AFTER_PARTITION (4)
#define RSSI_PATH_NUM_SECTION_PARTITION (3)

#define RSSI_PATH_MAX_SAMPLES_TO_AVERAGE (255)

#define RSSI_PATH_NUM_OF_SAMPLES_TO_AVERAGE_CB (16)
#define RSSI_PATH_NUM_OF_SAMPLES_TO_AVERAGE_NCB (16)
#define LOW_PATITION_THRESHOLD (10)				//non-linear section low threshold - derivative percentage from maximum derivative
#define HIGH_PATITION_THRESHOLD (80)				//non-linear section high threshold - derivative percentage from maximum derivative
#define EDGE_THRESHOLD (20)						//low/high power edge derivative percentage from maximum derivative
#define RSSI_PATH_TONE_FOR_MEASUREMENT (10)		// low tone freq was chosen to avoid compression along the rssi calibration
// 6 db attenuation difference between Hyp2 & Hyp3 should be investigated 
#define RSSI_PATH_TONE_INIT_AMPLITUDE	(9)

#define RSSI_PATH_TONE_MIN_POWER (-58)			//70-12(TONE_POWER_OFFSET)
#define RSSI_PATH_TONE_MAX_POWER (14)

#define MAX_RSSI_TABLE_VALUE (63)
#define MIN_RSSI_TABLE_VALUE (0)


/* Verify Results */
#define VERIFY_RSSI
#ifdef VERIFY_RSSI	
#define VERIFY_RESOLUTION (1)					//power step resolution during verification
#define MAX_RSSI_POWER_DIFF (4)					//Power diff (max) - between measured and calculated/calibrated RSSI
#define MIN_RSSI_DYNAMIC_RANGE (40)				//Dynamic range (min) of power values - where the graph is non-saturated
#define RSSI_PATH_NUM_VARIATION_SAMPLES	(10)	//Number of samples for variation measurement
#define RSSI_PATH_VARIATION_POWER 	(-30)			//Power used for variation measurement
#define RSSI_PATH_MAX_MEASUREMENT_VARIATION (4)	//Variation measurement (max) - maximum difference between RSSI measurement samples for given VARIATION_POWER
#endif //VERIFY_RSSI

#define RSSI_PATH_LNA			(HDK_LNA_INDEX_HIGH_GAIN)
#define RSSI_PATH_PGC1			(18)
#define RSSI_PATH_PGC2			(0)
#define RSSI_PATH_PGC3			(0)

#define RSSI_PATH_DERIVATIVE_RESOLUTION (6)		// fixed point issue 0-7
#define RSSI_PATH_MAX_DERIVATIVE_RESOLUTION (7)	// derivative_resolution > 7 can cause problems in fixpoint calculation
#define RSSI_PATH_MIN_DERIVATIVE (-1000)

#define RSSI_PATH_TABLE_RESOLUTION		(8)		// resolution of values written to PHY table
#define RSSI_PATH_TABLE_ATT_OFFSET		(3)		// attenuation offset of values written to PHY table

typedef struct 
{
	CalStatus_e status[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	uint32 lastRunTime;
	uint32 measureRssiRunTime;
	uint32 calcDerivativeRunTime;
	uint32 verifyRunTime;
	int16 firstCalPowerInDynamicRange[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int16 lastCalPowerInDynamicRange[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8 dynamicRange[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8 rssiPowerDiff[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8 maxDiffIsInPower[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
	int8 measurementVariation[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];
}RssiPath_results_t;

typedef struct 
{
	uint8 sectionSize;
	uint8 sectionSizeAfterPartition;
	uint8 numSectionPartition;
	uint8 numAvrgSamplesCb;
	uint8 numAvrgSamplesNcb;
	uint8 lowPartitionThreshold;
	uint8 highPartitionThreshold;
	uint8 edgeThreshold;
	uint8 runOverNumCellsHighTableZone;
	uint8 runOverNumCellsLowTableZone;
	 int8 toneForMeasurement;
	 int8 toneInitAmplitude;
	 int8 tonePowerOffset;
	 int8 toneCalGainLimit;
     int8 toneMinPower;
	 int8 toneMaxPower;
	uint8 tableOffset;
	uint8 tableOffsetNcb;
	uint8 verifyResolution;
	uint8 maxRssiPowerDiff;
	uint8 minRssiDynamicRange;
	uint8 numVariationSamples;
	 int8 variationPower;
	uint8 maxMeasurementVariation;
	 HdkLnaIndex_e lnaIndex;
	 int8 pgc1;		
	 int8 pgc2;
	 int8 pgc3;
}RssiPath_params_t;

typedef struct 
{
	RssiPath_results_t	results;
	RssiPath_params_t	params;
} RssiPath_elements_t;

/**********************************************************************/
/***					TxIq                                                    					***/
/**********************************************************************/


typedef struct 
{
	uint8 antMask;
	uint8 rangeType;
	uint8 firstCalibBinIndex;		//The bin that should be calibrated next
	uint8 totalNumCalibratedBins;	//Total number of bins that should be calibrated in one iteration offline/online
	uint16 *calibratedBins;
}TxIqCalibRangeDetails_t;

typedef struct 
{
	uint8 calibAnt;
	uint8 rangeType;
	uint8 firstCalibBinIndex;     //The bin that should be calibrated next
	bool positiveRangeFix;		//flag-calibration of all positive bins completed at current iteration - fix failed bins
	bool negativeRangeFix;		//flag-calibration of all negative bins completed at current iteration - fix failed bins
	uint8 lastEnabledAntenna;
}TxIqOnlineDetails_t;

typedef struct 
{
	TxIqBinStatus_e	binStatus[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][TX_IQ_MAX_CALIBRATED_BINS]; //bin calibration status
	int16			energyOffset[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][TX_IQ_MAX_CALIBRATED_BINS];
	int16			a[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][TX_IQ_MAX_CALIBRATED_BINS];
	int16			b[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][TX_IQ_MAX_CALIBRATED_BINS];
	int32			SSB_F_20M[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][2][2];
	int32			SSB_F_40M[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][2][2];
	CalStatus_e		status[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];		
	uint32			lastRunTime;
	uint32			singleBinCalibRunTime;				//calibrate and verify run time
	uint32			singleBinVerifyRunTime;
	uint32			singleBinPairInterpolationRunTime;
	uint32			fixBinsRunTime;						// Run time for all failed bins
	uint32			restoreHwRegistersRunTime;
} TxIq_results_t;


//Params must not be changed during offline calibration or in the process of online calibration iterations
typedef struct 
{
	int32	mat_A[2][TX_IQ_PFIT_MAX_PNTS];		// Inverse matrix
	int16	x[TX_IQ_PFIT_MAX_PNTS];				// the X-axis points to the parabola
				//calibrated positive bins CB (corresponding negative bins also calibrated) -
				//must include edge bins of positive range!!!
	uint16	CalibBinsCb[TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY];		
				//calibrated positive bins nCB (corresponding negative bins also calibrated)
				//must include edge bins of positive range!!!
	uint16	CalibBinsNCb[TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY];	
	uint16	CalibBinsCb80[TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY];	
	int16	maxVerifyEnergy;	
	uint8	numPointsX;							// actual number of points in x
	uint8	numBinsCb80SinglePolarity;			// actual number of positive/negative CB calibrated bins
	uint8	numBinsCbSinglePolarity;			// actual number of positive/negative CB calibrated bins
	uint8	numBinsNCbSinglePolarity;			// actual number of positive/negative nCB calibrated bins
	uint8	numBinsOnlineIteration;				// number of bins calibrated in a single online iteration
	uint8	pgc3;
	int8	toneAmplitude;						
	int8	toneAmplitudeDbvCb;
	int8	toneAmplitudeDbvNcb;
	uint8	grtzlNumCycles;
	uint8	verifyNumMeasurements;
	
	/*IQTD params*/

	// BW 80
	int8 	LSB40_LSB20_20M;
	int8 	LSB40_USB20_20M;
	int8 	USB40_LSB20_20M;
	int8 	USB40_USB20_20M;
	
	int8 	LSB40_LSB20_40M;
	int8 	LSB40_USB20_40M;
	int8 	USB40_LSB20_40M;
	int8 	USB40_USB20_40M;
	// BW 40
	int8 	LSB20;
	int8 	USB20;
} TxIq_params_t;

typedef struct 
{
	TxIq_results_t		results;
	TxIq_params_t		params;
} TxIq_elements_t;


/**********************************************************************/
/***					TxLO                                                   	                ***/
/**********************************************************************/

typedef struct 
{
//galia w300 verify 	int16			energyOffset[MAX_NUM_OF_ANTENNAS][RFIC_TX_GAIN_TPC_INDEX_MAX];
	int16			tpcEnergy[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_TX_GAIN_TPC_INDEX_MAX];		//verify energy per TPC
	int16			diffEnergy[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_TX_GAIN_TPC_INDEX_MAX];	// verify energy difference between refEnergy and TPC Energy
	int8			dacs[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT][RFIC_TX_GAIN_TPC_INDEX_MAX][RFIC_PATH_TYPE_MAX];		//calibration DAC I,Q result 
	CalStatus_e		status[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];    
	int16			refEnergy[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];		//verify reference energy
	uint32			lastRunTime;
	uint32			restoreHwRegistersRunTime;
	uint32			singleTpcCalibRunTime;				//calibrate and verify run time
	uint32			singleTpcVerifyRunTime;
	int8			digitalDacI[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];	//calibration digital DAC I result 
	int8			digitalDacQ[MAX_NUMBER_OF_ANTENNAS_IN_PROJECT];	//calibration digital DAC Q result 
}TxLO_results_t;

typedef struct 
{
	int16	maxVerifyEnergyDiff;
	uint8	calibBin;
	uint8	verifyRefBin;
	uint8	dacNumIterOffline;
	uint8	pgc2;
	uint8	pgc3;
	int8	toneAmplitude;									
	uint8	binaryMaxSteps;
	uint8	linearMaxSteps;
	uint8	grtzlNumCycles;
	uint8	verifyNumMeasurements;
	uint8	digitalDacMaxIter;
	int8	dacMin;
	int8	dacMax;
	int8	clipMin;
	int8	clipMax;
	uint8	numTpcsOnlineIteration; // number of TPCs calibrated in a single online iteration
	uint8	digitalDacTpcIdx;
	uint8	verifyRefTpcIdx;
	int8 	binaryPivot;

}TxLO_params_t;

typedef struct 
{
	TxLO_results_t	results;
	TxLO_params_t	params;
} TxLO_elements_t;



typedef struct 
{
	RxIQRF_elements_t		RxIQparams;
    DcElements_t            RxDCparams;
    LpfElements_t           Lpfparams;
    RssiPath_elements_t     Rssiparams;
    TxIq_elements_t         TxIqParams;
    TxLO_elements_t         TxLoParams;
} Calibration_params_otf_t;


#endif 

#endif /* !UMI_RSN_INCLUDED_H */
