/*************************************************************************/
/* defines and macros of PHY library functions for Firmware use          */
/*************************************************************************/

#ifndef _PHY_ACCESS_DEFINITIONS_H_
#define _PHY_ACCESS_DEFINITIONS_H_

#include "System_GlobalDefinitions.h"
#include "mt_sysrst.h"
#include "RegAccess_Api.h"
#include "Pac_Api.h"
#include "HDK_utils.h"

#define BYTE_OFFSET_SHIFT_TO_WORD	2

#define PHY_DELAY(x)																	MT_Delay(x)
#define PHY_WRITE64(base_addr, offset, value)											RegAccess_Write64bitReg(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), value)
#define PHY_WRITE32(base_addr, offset, value)											RegAccess_Read(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), value)
#define PHY_READ_REG(base_addr, offset, dst_addr)										RegAccess_Read(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), dst_addr)
#define PHY_READ_REG_FIELD(base_addr, offset, shift, mask, dst_addr)					RegAccess_ReadField(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), shift, mask, dst_addr)
#define PHY_WRITE_REG_FIELD(base_addr, offset, shift, mask, value)						RegAccess_WriteMasked(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), mask << shift, value)
#define PHY_READ_AND_VERIFY_REG(base_addr, offset, value, success)						RegAccess_ReadAndVerify(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), value, success)
#define PHY_READ_AND_VERIFY_REG_FIELD(base_addr, offset, shift, mask, value, success);	RegAccess_ReadAndVerifyField(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), shift, mask, value, success)
#define PHY_WRITE_REG(base_addr, offset, value)											RegAccess_Write(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), value)
#define PHY_WRITE_REG_8(base_addr, value)												RegAccess_Write(base_addr, value)
#define PHY_WRITE_INCR_FOUR(offset, value)												RegAccess_WriteInc4(offset, value)
#define PHY_SET_REGISTER_FIELD(dst_addr, shift, mask, value)							PHY_WRITE_REG_FIELD(dst_addr, 0, shift, mask, value)
#define PHY_READ_MODIFY_WRITE(base_addr, offset, shift, mask, value)					PHY_WRITE_REG_FIELD(base_addr, offset, shift, mask, value)
#define PHY_WAIT_FOR_FIELD_VALUE(base_addr, offset, shift, mask, exp_val, timeout, success) RegAccess_WaitForField(base_addr + (offset << BYTE_OFFSET_SHIFT_TO_WORD), shift, mask, exp_val, timeout, success)
#define PHY_GET_TSF_TIME()																GET_TSF_TIMER_LOW()
#define READ_ARR_FROM_MASK_ANT_REGS(regAddress,regValueAntArr,antMask)					readArrFromMaskAntRegs(regAddress, regValueAntArr, antMask)
#define WRITE_ARR_2_MASK_ANT_REGS(regAddress,regValueAntArr,antMask)					writeArr2MaskAntRegs(regAddress,regValueAntArr,antMask)

#endif //_PHY_ACCESS_DEFINITIONS_H_

