/*  Defines for WAVE500 with WRX500 */

#ifndef __CalibrationsDefines_h__
#define __CalibrationsDefines_h__


/**********************************************************************/
/***					Global Definitions                                                                   ***/
/**********************************************************************/


#define MAX_NUM_OF_BW						   4 

#define ANTENNA_CONNECTED_DEFAULT_BITMAP 0xFF
#define ANTENNA_SELECTION_DEFAULT_BITMAP 0x55

// General enum for antenna numbering
typedef enum
{
    ANTENNA_0,
    ANTENNA_1,
    ANTENNA_2,
    ANTENNA_3,
    MAX_ANTENNA = ANTENNA_3,
    TOTAL_ANTENNAS,
}Antenna_e;

#define MAX_NUM_OF_ANTENNAS	                   TOTAL_ANTENNAS
#define MAX_NUM_OF_DIGITAL_ANTENNAS    (4)

#define ANTENNA_BITMAP_NONE			0x0 /* binary(0000) */
    /* Single Antennas */
#define ANTENNA_BITMAP_ANTENNA_0	0x1 /* binary(0001) */
#define ANTENNA_BITMAP_ANTENNA_1	0x2 /* binary(0010) */
#define ANTENNA_BITMAP_ANTENNA_2	0x4 /* binary(0100) */
#define ANTENNA_BITMAP_ANTENNA_3	0x8 /* binary(1000) */

    /* Single Antennas - antenna selection  */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_0	0x1 /* binary(00000001) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_1	0x4 /* binary(00000100) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_2	0x10 /* binary(00010000) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_3	0x40 /* binary(01000000) */

    /* Two Antennas */
#define ANTENNA_BITMAP_ANTENNA_0_AND_1	(ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_1) /* binary(0011) */
#define ANTENNA_BITMAP_ANTENNA_0_AND_2	(ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_2) /* binary(0101) */
#define ANTENNA_BITMAP_ANTENNA_0_AND_3	(ANTENNA_BITMAP_ANTENNA_0 | ANTENNA_BITMAP_ANTENNA_3) /* binary(1001) */
#define ANTENNA_BITMAP_ANTENNA_1_AND_2	(ANTENNA_BITMAP_ANTENNA_1 | ANTENNA_BITMAP_ANTENNA_2) /* binary(0110) */
#define ANTENNA_BITMAP_ANTENNA_1_AND_3	(ANTENNA_BITMAP_ANTENNA_1 | ANTENNA_BITMAP_ANTENNA_3) /* binary(1010) */
#define ANTENNA_BITMAP_ANTENNA_2_AND_3	(ANTENNA_BITMAP_ANTENNA_2 | ANTENNA_BITMAP_ANTENNA_3) /* binary(1100) */
	
#define ANTENNA_SELECTION_BITMAP_ANTENNA_0_AND_1	(ANTENNA_SELECTION_BITMAP_ANTENNA_0 | ANTENNA_SELECTION_BITMAP_ANTENNA_1) /* binary(00000101) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_0_AND_2	(ANTENNA_SELECTION_BITMAP_ANTENNA_0 | ANTENNA_SELECTION_BITMAP_ANTENNA_2) /* binary(00010001) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_0_AND_3	(ANTENNA_SELECTION_BITMAP_ANTENNA_0 | ANTENNA_SELECTION_BITMAP_ANTENNA_3) /* binary(01000001) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_1_AND_2	(ANTENNA_SELECTION_BITMAP_ANTENNA_1 | ANTENNA_SELECTION_BITMAP_ANTENNA_2) /* binary(00010100) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_1_AND_3	(ANTENNA_SELECTION_BITMAP_ANTENNA_1 | ANTENNA_SELECTION_BITMAP_ANTENNA_3) /* binary(01000100) */
#define ANTENNA_SELECTION_BITMAP_ANTENNA_2_AND_3	(ANTENNA_SELECTION_BITMAP_ANTENNA_2 | ANTENNA_SELECTION_BITMAP_ANTENNA_3) /* binary(01010000) */

    /* All Antennas */
#define ANTENNA_BITMAP_ALL_ANTENNAS				0xf /* binary(1111) */
#define ANTENNA_BITMAP_ALL_ANTENNAS_GEN5		0xF /* binary(1111) */
#define ANTENNA_BITMAP_ALL_AFE_CHANNELS_GEN5	0x1F
    
#define ANTENNA_BITMAP_MAX_ANTENNAS		0xf

typedef uint32 AntennaBitmaps_e;

#define	FCSI_CHANNEL_A	0
#define	FCSI_CHANNEL_B	1
#define	FCSI_CHANNEL_C	2
#define	FCSI_CHANNEL_D	3
#define	FCSI_CHANNEL_E	4
#define	FCSI_TOTAL_CHANNELS	5

typedef	uint8	FcsiChannels_e;

/* LNA index Enum */
/* The LNA active values are stored in the PHY registers in this order:   */
/*             ______________________________________                     */
/*             |  Low (MSB)  |  Mid  |  High (LSB)  |                     */
/*             |___[11:8]____|_[8:4]_|____[3:0]_____|                     */
/* We use this enum to address and ask for the actual value corresponding */
/* to the desired index. In W300 0 is usually the high index, and in AR10 */ 
/* it is usually 3. This enum helps iterate over all LNA's with no        */
/* platform dependency */
typedef enum HdkLnaIndex
{
    HDK_LNA_INDEX_MIN_INDEX = 0,
    HDK_LNA_INDEX_HIGH_GAIN = HDK_LNA_INDEX_MIN_INDEX,
    HDK_LNA_INDEX_MID_GAIN,
    HDK_LNA_INDEX_LOW_GAIN,
    HDK_LNA_INDEX_MAX_INDEX = 6,
    HDK_LNA_INDEX_NUM_OF_INDEXES = HDK_LNA_INDEX_MAX_INDEX,
} HdkLnaIndex_e;

#define MAX_NUMBER_OF_LNA_CROSSING_POINT 	(7)

/**********************************************************************/
/***					Tx calibration                              ***/
/**********************************************************************/
#define TX_CALIB_STEP_NUM				(4)
#define GET_JUMPS_NUM(OFFS,SIZE) 	((((-OFFS)	/ SIZE) << 1)+1)

#define TX_CALIB_STEP_1_START_OFFSET	(-100)
#define TX_CALIB_STEP_1_JUMP_SIZE		(25)
#define TX_CALIB_STEP_1_JUMPS_NUM		GET_JUMPS_NUM(TX_CALIB_STEP_1_START_OFFSET, TX_CALIB_STEP_1_JUMP_SIZE)		

#define TX_CALIB_STEP_2_START_OFFSET	(-16)
#define TX_CALIB_STEP_2_JUMP_SIZE		(8)
#define TX_CALIB_STEP_2_JUMPS_NUM		GET_JUMPS_NUM(TX_CALIB_STEP_2_START_OFFSET, TX_CALIB_STEP_2_JUMP_SIZE)		

#define TX_CALIB_STEP_3_START_OFFSET	(-6)
#define TX_CALIB_STEP_3_JUMP_SIZE		(2)
#define TX_CALIB_STEP_3_JUMPS_NUM		GET_JUMPS_NUM(TX_CALIB_STEP_3_START_OFFSET, TX_CALIB_STEP_3_JUMP_SIZE)		

#define TX_CALIB_STEP_4_START_OFFSET	(-1)
#define TX_CALIB_STEP_4_JUMP_SIZE		(1)
#define TX_CALIB_STEP_4_JUMPS_NUM		GET_JUMPS_NUM(TX_CALIB_STEP_4_START_OFFSET, TX_CALIB_STEP_4_JUMP_SIZE)		


// Goertzel
#define TX_GRTZL_TONE_DIGGAIN					(256)   
#define TX_GRTZL_ENERGY_RESOLUTION				(12)
#define TX_GRTZL_TONE_SCALE						(1)	
#define TX_GRTZL_LENGTH							(1024)
#define TX_GRTZL_TIMEOUT						(1000)
#define TX_GRTZL_NUM_OF_CYCLES					(32)


// rfic
#define TX_INITIAL_LNA_INDEX					(0)
#define TX_INITIAL_PGC_GAIN_DB					(14)
#define TX_PGC_BW								(160)
#define TX_PAD_GAIN_DB_5G						(10)
#define TX_PAD_GAIN_DB_2_4G						(14)
#define TX_INITIAL_TPC_INDEX					(2)


#define TX_DIFI_2_GAIN							(0)  

/**********************************************************************/
/***					TxIQ                                        ***/
/**********************************************************************/


#define TX_IQ_ENERGY_MAX_VALUE			(750)
#define TX_IQ_CALIB_BIN					(4)

#define TXIQ_CALIBRATED_BIN_START	(0)
#define TXIQ_CALIBRATED_BIN_END		(256)

#define TXIQ_20_CALIBRATED_BIN   	(4)
#define TXIQ_40_CALIBRATED_BIN    	(4)
#define TXIQ_80_CALIBRATED_BIN    	(4)
#define TXIQ_160_CALIBRATED_BIN    	(4)


#define TXIQ_MAX_TRIES_OFFLINE	(2)
#define TXIQ_MAX_TRIES_ONLINE	(1)


typedef enum
{
	BIN_CALIB_SUCCESS,	//calibration and verification succeeded
	BIN_VERIFY_FAIL,	//verify failed (and fix failed)
	BIN_FIX_SUCCESS,	//calibration or verify failed but fix succeeded (found adjacent successful bins)
	BIN_CALIB_NONE		//before calibration
} TxIqBinStatus_e;

/**********************************************************************/
/***					PhyRFIC                                                  				 ***/
/**********************************************************************/

#define DELAY_AFTER_PHY_RFIC_CHANGE 30
#define DELAY_CHANGE_PER_BW		 	10
#define MINIMUM_DELAY			 	1


#define TONE_AMPLITUDE_REFERENCE_SIGN   	(1)

/**********************************************************************/
/***					TxLO                                                   			          ***/
/**********************************************************************/


#define LO_CALIB_BIN						(8)

#define TXLO_MAX_TRIES_OFFLINE				(3)
#define TXLO_MAX_TRIES_ONLINE				(1)
#define TXLO_ENERGY_MAX_VALUE				(800)



/**********************************************************************/
/***					TPC		                                                  			          ***/
/**********************************************************************/
#define MAX_TSSI_SECTIONS	4
#define GAIN_RESOLUTION		3

#define DIG_LOWER_LIMIT_DEFAULT			((int16)(-(1 << GAIN_RESOLUTION)))				// -1 db
#define PRE_DRV_MIN_GAIN_DEFAULT		((int16)(-(29 << (GAIN_RESOLUTION - 1))))		// -14.5 db
#define PGC_MIN_GAIN_DEFAULT			((int16)(-(6 << GAIN_RESOLUTION)))				// -6 db
#define PGC_STEP_DEFAULT				((int16)(4 << GAIN_RESOLUTION))					// 4 db
#define PGC_LOWER_LIMIT_DEFAULT			((int16)(-(6 << GAIN_RESOLUTION)))				// -6 db
#define PGC_UPPER_LIMIT_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define PRE_DRV_STEP_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define PRE_DRV_LOWER_LIMIT_DEFAULT		((int16)(-(45 << (GAIN_RESOLUTION - 1))))		// -22.5 db
#define PRE_DRV_UPPER_LIMIT_DEFAULT		((int16)(15 << (GAIN_RESOLUTION - 1)))			// 7.5 db
#define DIG_STEP_DEFAULT				((int16)(1 << (GAIN_RESOLUTION - 2)))			// 0.25 db
#define DIG_MAX_GAIN_DEFAULT			((int16)(1 << GAIN_RESOLUTION))					// 1 db
#define DIG_UPPER_LIMIT_DEFAULT			((int16)(2 << GAIN_RESOLUTION))					// 2 db
#define DIG_MIN_GAIN_DEFAULT			((int16)(-(1 << GAIN_RESOLUTION)))				// -1 db
#define POWER_VECTOR_LEN_DEFAULT		(96)
#define MIN_POWER_DEFAULT				(26)												// Ultimate EVM default = 13 dBm
#define MAX_EVM_DEFAULT					(38)
#define MIN_POWER_INDEX_DEFAULT			(0)
#define POWER_VEC_STEP_DEFAULT			((int16)(1 << (GAIN_RESOLUTION - 1)))			// 0.5 db
#define NUM_TSSI_CUT_POINTS_DEFAULT		(3)
#define PGC_WORD_OFFSET_DEFAULT			((int16)(6 << GAIN_RESOLUTION))					// 6 db
#define PGC_WORD_SHIFT_DEFAULT			(GAIN_RESOLUTION + 2)
#define PRE_DRV_WORD_OFFSET_DEFAULT		((int16)(45 << (GAIN_RESOLUTION - 1)))			// 22.5 db
#define PRE_DRV_WORD_SHIFT_DEFAULT		(GAIN_RESOLUTION + 1)
#define DIG_WORD_OFFSET_DEFAULT			((int16)(1 << GAIN_RESOLUTION))					// 1 db
#define DIG_WORD_SHIFT_DEFAULT			(GAIN_RESOLUTION - 2)

#define TPC_CHARACTERIZATION_LINEAR		(0)
#define TPC_CHARACTERIZATION_LOG		(1)
#define TPC_CHARACTERIZATION_SQUARE		(2)
#define TPC_CHARACTERIZATION_DEFAULT	TPC_CHARACTERIZATION_LOG

#define DIGITAL_WORD_WIDTH				(9)
#define DIGITAL_WORD_SHIFT				(0)
#define PGC_WORD_WIDTH					(2)
#define PGC_WORD_SHIFT					(DIGITAL_WORD_WIDTH)
#define PRE_DRV_WORD_WIDTH				(4)
#define PRE_DRV_WORD_SHIFT				(PGC_WORD_SHIFT + PGC_WORD_WIDTH)

#define TPC_MAX_S2D_REGIONS				3

#define TPC_GAIN_TABLE_START_ADDR		(0x9000)
#define TPC_POWER_OUT_START_ADDR		(0x8000)
#define TPC_TSSI_TABLE_START_ADDR		(0x8800)
#define TPC_TSSI_NUM_WORDS_IN_REGION	2
#define TPC_TSSI_NUM_WORDS_PER_ANT		(MAX_NUM_OF_BW * TPC_MAX_S2D_REGIONS * TPC_TSSI_NUM_WORDS_IN_REGION)
#define TPC_S2D_RAM_B_SHIFT				16
#define TPC_S2D_RAM_A_SHIFT				0
#define TPC_S2D_RAM_OFFSET_SHIFT		16
#define TPC_S2D_RAM_GAIN_SHIFT			5
#define TPC_S2D_RAM_PTHRESHOLD_SHIFT	25
#define TPC_S2D_RAM_PTHRESHOLD_MASK		(0x7E000000)
#define TPC_S2D_RAM_PTHRESHOLD_INVALID	(0xFF)

#define TPC_S2D_RAM_MASK				(0x7FFF0000)
#define TPC_TSSI_TABLE_BW_SECTION_SIZE 	(TPC_MAX_S2D_REGIONS * TPC_TSSI_NUM_WORDS_IN_REGION)

#define GAIN_TABLE_BYTES_WIDTH			(4)
#define GAIN_TABLE_ENTRIES				(128)

#define POWER_VECTOR_WORD_WIDTH			(8)
#define POWER_VEC_BW_SECTION_SIZE		(48)
#define POWER_VEC_BYTES_WIDTH			(4)

#define TPC_ACC_ENABLE_MASK				1
#define TPC_OPEN_LOOP_INDEX				0

#define TPC_POWER_OUT_MAX_ROWS	96

/**********************************************************************/
/***				RxIQ	                                                                         ***/
/**********************************************************************/
#define RXIQ_OFFLINE_ACCUM_NUM_OF_SAMPLES 					(1000000)
#define RXIQ_ONLINE_ACCUM_NUM_OF_SAMPLES 					(640000)
#define RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES					(4096)
#define RXIQ_VERIFICATION_ACCUM_NUM_OF_SAMPLES 				(100000)
#define RXIQ_ACCUM_RATE 		  							(0)
#define RXIQ_ACCUM_DC_MODE 		  							(0)
#define RXIQ_ACCUM_RSSI_MODE	  							(0)
#define RXIQ_ACCUM_SHIFT 		  							(5)
#define RXIQ_ACCUM_SHIFT_160	  							(7)
#define RXIQ_ACCUM_SHIFT_600B	  							(7)
#define RXIQ_OFFLINE_ACCUM_TIMEOUT 		  					(10000)
#define RXIQ_ONLINE_ACCUM_TIMEOUT 		  					(5000)
#define RXIQ_VERIFICATION_ACCUM_TIMEOUT 					(1000)
#define RXIQ_IIR_SHIFT	 		  							(9)
#define RXIQ_IIR_MIN_DELAY 		  							(5)
#define RXIQ_OFFLINE_MAX_NUM_OF_TRIES	  					(3)
#define RXIQ_ONLINE_MAX_NUM_OF_TRIES	  					(1)
#define RXIQ_SUCCESS_TH_DB_OFFLINE 							(-40)
#define RXIQ_SUCCESS_TH_DB_ONLINE 							(-45)
#define RXIQ_SUCCESS_RELATIVE_TH_DB_ONLINE_AFTER_OFFLINE	(40)
#define RXIQ_SUCCESS_RELATIVE_TH_DB_ONLINE_AFTER_ONLINE 	(45)
#define RXIQ_LNA_INDEX			  							(0)
#define RXIQ_PGC_GAIN_DB		  							(10)
#define RXIQ_TARGET_POWER		  							(-25)
#define RXIQ_W1_NUM_FRAC_BITS								(12)	// number of bits used after the decimal point for W1
#define RXIQ_W2_NUM_RES_BITS								(12)	// number of bits used after the decimal point for W2
#define RXIQ_INITIAL_W1_VALUE							    (1<<RXIQ_W1_NUM_FRAC_BITS)
#define RXIQ_INITIAL_W2_VALUE								(0)
#define RX_IQ_ROUND											(6)
#define RXIQ_NLMS_DIFI_2_GAIN								(0)   		   // dB
#define RXIQ_NLMS_IIR_SHIFT									(1)
#define RXIQ_NLMS_EQ_LENGTH									(5)
#define RXIQ_NLMS_IQ_FIR_DELAY	 		  					(5)
#define RXIQ_NLMS_OFFLINE_MAX_NUM_OF_TRIES					(10)
#define RXIQ_NLMS_ITERATIONS								(5)
#define RXIQ_NLMS_ALFA										(2)
#define RXIQ_NLMS_NUM_OF_ENABLED_COEFFS						(12)
#define RXIQ_NUM_OF_PGC_GAINS								(11)
#define RXIQ_NLMS_FRCTL										(0)

#define RXIQ_NLMS_TIMEOUT_LMS_OFFLINE    					(3500) //usec
#define RXIQ_NLMS_DIGGAIN									(100)
#define RXIQ_NLMS_GRTZL_NUM_OF_CYCLES						(16)
#define RXIQ_NLMS_GRTZL_LENGTH								(1024)
#define RXIQ_NLMS_GRTZL_TIMEOUT								(1000)
#define RXIQ_NLMS_NUM_OF_BINS								(17)
#define RXIQ_NLMS_LNA_GAIN_INDEX							(2)
#define RXIQ_NLMS_LOOP_TYPE									(1)
#define RXIQ_NLMS_IQ_SELECTION								(3)
#define RXIQ_NLMS_SCALE										(0)
#define RXIQ_NLMS_DIG_GAIN									(100)
#define RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES				(16)
#define RXIQ_NLMS_AMP_SQUARE_RES 							(20) //should be even, was 12
#define RXIQ_NLMS_AMP_RES 									(RXIQ_NLMS_AMP_SQUARE_RES>>1)
#define RXIQ_NLMS_PHI_RES									(20)
#define RXIQ_NLMS_NUM_RES									(RXIQ_NLMS_PHI_RES+RXIQ_NLMS_AMP_RES)
#define RXIQ_NLMS_IMR_RES									(5)

#define RXIQ_XTALK_OFFLINE_MAX_NUM_OF_TRIES	  				(1)
#define RXIQ_XTALK_TONE_DIGGAIN								(256)
#define RXIQ_XTALK_GRTZL_LENGTH								(1024)
#define RXIQ_XTALK_GRTZL_NUM_OF_CYCLES						(16)
#define RXIQ_XTALK_GRTZL_TIMEOUT							(1000)
#define RXIQ_XTALK_LOOP_TYPE								(1)
#define RXIQ_XTALK_NUM_RES_BITS								(5)
#define RXIQ_XTALK_DETECTOR_THRESHOLD  						(255)


/**********************************************************************/
/***					RxDC	                                                  		          ***/
/**********************************************************************/

#define RXDC_PGC_GAIN_FOR_ANALOG_CALIBRATION_DB (20)
#define RXDC_NUM_OF_PGC_GAINS					(11)
#define RXDC_TIMEOUT_FOR_ANALOG_CALIBRATION_OFFLINE 	(3500) //usec
#define RXDC_TIMEOUT_FOR_ANALOG_CALIBRATION_ONLINE 		(500)  //usec
#define RXDC_TIMEOUT_FOR_ACCUMULATOR		 	(1000) 
#define RXDC_INTEGRATOR_BW_OFFLINE				(13)
#define RXDC_INTEGRATOR_BW_ONLINE				(10)
#define RXDC_DIFI_2_GAIN						(0)   		   // dB
#define RXDC_NUM_OF_LNA_SETTINGS 				(7)
#define RXDC_FIRST_LNA_INDEX					(0)
#define RXDC_LAST_LNA_INDEX_FIRST_ONLINE		(3)
#define RXDC_MAX_NUM_OF_TRIES_OFFLINE			(3)
#define RXDC_MAX_NUM_OF_TRIES_ONLINE			(1)
#define RXDC_ACCUM_NUM_OF_SAMPLES				(8192)
#define RXDC_ACCUM_RATE							(1)
#define RXDC_ACCUM_DC_MODE						(1)
#define RXDC_ACCUM_RSSI_MODE					(0)
#define RXDC_ACCUM_SHIFT						(0)
#define RXDC_SUCCESS_TH							(2000) 		   // uV


#endif
