/*******************************************************************
*                                                                   
*  DUMMY_PHY.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef DUMMY_PHY_regs_H_FILE
#define DUMMY_PHY_regs_H_FILE

/* DPHY_REG000_BYTE_ERROR_RATE */
/* once every limit reverse the byte */
#define REG_DPHY_REG000_BYTE_ERROR_RATE          0x00000
#define REG_DPHY_REG000_BYTE_ERROR_RATE_MASK     0xffffffff
#define REG_DPHY_REG000_BYTE_ERROR_RATE_SHIFT    0
#define REG_DPHY_REG000_BYTE_ERROR_RATE_WIDTH    32

/* DPHY_REG001_BE_ERROR_RATE */
/* once every limit terminate the packet with error */
#define REG_DPHY_REG001_BE_ERROR_RATE          0x00004
#define REG_DPHY_REG001_BE_ERROR_RATE_MASK     0xffffffff
#define REG_DPHY_REG001_BE_ERROR_RATE_SHIFT    0
#define REG_DPHY_REG001_BE_ERROR_RATE_WIDTH    32

/* DPHY_REG002_BE_ERROR_NUM_OF_BYTES */
/* be error number of bytes removed */
#define REG_DPHY_REG002_BE_ERROR_NUM_OF_BYTES          0x00008
#define REG_DPHY_REG002_BE_ERROR_NUM_OF_BYTES_MASK     0x000fffff
#define REG_DPHY_REG002_BE_ERROR_NUM_OF_BYTES_SHIFT    0
#define REG_DPHY_REG002_BE_ERROR_NUM_OF_BYTES_WIDTH    20

/* DPHY_REG003_PACKET_ERROR_RATE */
/* once every limit the packet with header fails (l-sig/ht-sig/gf) session with mac not opened */
#define REG_DPHY_REG003_PACKET_ERROR_RATE          0x0000C
#define REG_DPHY_REG003_PACKET_ERROR_RATE_MASK     0xffffffff
#define REG_DPHY_REG003_PACKET_ERROR_RATE_SHIFT    0
#define REG_DPHY_REG003_PACKET_ERROR_RATE_WIDTH    32

/* DPHY_REG004_MAX_MCS */
/* max supported mcs */
#define REG_DPHY_REG004_MAX_MCS          0x00010
#define REG_DPHY_REG004_MAX_MCS_MASK     0x0000007f
#define REG_DPHY_REG004_MAX_MCS_SHIFT    0
#define REG_DPHY_REG004_MAX_MCS_WIDTH    7

/* DPHY_REG005_CLEAR_CNT */
/* clear all counters */
#define REG_DPHY_REG005_CLEAR_CNT          0x00014
#define REG_DPHY_REG005_CLEAR_CNT_MASK     0x00000001
#define REG_DPHY_REG005_CLEAR_CNT_SHIFT    0
#define REG_DPHY_REG005_CLEAR_CNT_WIDTH    1

/* DPHY_REG005_LATCH_CNT */
/* lock counters to latch */
#define REG_DPHY_REG005_LATCH_CNT          0x00014
#define REG_DPHY_REG005_LATCH_CNT_MASK     0x00000002
#define REG_DPHY_REG005_LATCH_CNT_SHIFT    1
#define REG_DPHY_REG005_LATCH_CNT_WIDTH    1

/* DPHY_REG006_TRANSMITTED_PKTS_CNT */
/* transmitted_pkts_cnt */
#define REG_DPHY_REG006_TRANSMITTED_PKTS_CNT          0x00018
#define REG_DPHY_REG006_TRANSMITTED_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG006_TRANSMITTED_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG006_TRANSMITTED_PKTS_CNT_WIDTH    32

/* DPHY_REG007_RECIEVED_TOTAL_PKTS_CNT */
/* recieved_total_pkts_cnt */
#define REG_DPHY_REG007_RECIEVED_TOTAL_PKTS_CNT          0x0001C
#define REG_DPHY_REG007_RECIEVED_TOTAL_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG007_RECIEVED_TOTAL_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG007_RECIEVED_TOTAL_PKTS_CNT_WIDTH    32

/* DPHY_REG008_RECIEVED_GOOD_PKTS_CNT */
/* recieved_good_pkts_cnt */
#define REG_DPHY_REG008_RECIEVED_GOOD_PKTS_CNT          0x00020
#define REG_DPHY_REG008_RECIEVED_GOOD_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG008_RECIEVED_GOOD_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG008_RECIEVED_GOOD_PKTS_CNT_WIDTH    32

/* DPHY_REG009_RECIEVED_UNSUPPORTED_PKTS_CNT */
/* recieved_unsupported_pkts_cnt */
#define REG_DPHY_REG009_RECIEVED_UNSUPPORTED_PKTS_CNT          0x00024
#define REG_DPHY_REG009_RECIEVED_UNSUPPORTED_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG009_RECIEVED_UNSUPPORTED_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG009_RECIEVED_UNSUPPORTED_PKTS_CNT_WIDTH    32

/* DPHY_REG00A_RECIEVED_COLLISION_PKTS_CNT */
/* recieved_collision_pkts_cnt */
#define REG_DPHY_REG00A_RECIEVED_COLLISION_PKTS_CNT          0x00028
#define REG_DPHY_REG00A_RECIEVED_COLLISION_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG00A_RECIEVED_COLLISION_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG00A_RECIEVED_COLLISION_PKTS_CNT_WIDTH    32

/* DPHY_REG00B_RECIEVED_ERROR_PKTS_CNT */
/* recieved_error_pkts_cnt */
#define REG_DPHY_REG00B_RECIEVED_ERROR_PKTS_CNT          0x0002C
#define REG_DPHY_REG00B_RECIEVED_ERROR_PKTS_CNT_MASK     0xffffffff
#define REG_DPHY_REG00B_RECIEVED_ERROR_PKTS_CNT_SHIFT    0
#define REG_DPHY_REG00B_RECIEVED_ERROR_PKTS_CNT_WIDTH    32

/* DPHY_REG00C_RECIEVED_BYTE_CNT */
/* recieved_byte_cnt */
#define REG_DPHY_REG00C_RECIEVED_BYTE_CNT          0x00030
#define REG_DPHY_REG00C_RECIEVED_BYTE_CNT_MASK     0xffffffff
#define REG_DPHY_REG00C_RECIEVED_BYTE_CNT_SHIFT    0
#define REG_DPHY_REG00C_RECIEVED_BYTE_CNT_WIDTH    32

/* DPHY_REG00D_TRANSMITTED_PKTS_CNT_LATCH */
/* transmitted_pkts_cnt_latch */
#define REG_DPHY_REG00D_TRANSMITTED_PKTS_CNT_LATCH          0x00034
#define REG_DPHY_REG00D_TRANSMITTED_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG00D_TRANSMITTED_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG00D_TRANSMITTED_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG00E_RECIEVED_TOTAL_PKTS_CNT_LATCH */
/* recieved_total_pkts_cnt_latch */
#define REG_DPHY_REG00E_RECIEVED_TOTAL_PKTS_CNT_LATCH          0x00038
#define REG_DPHY_REG00E_RECIEVED_TOTAL_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG00E_RECIEVED_TOTAL_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG00E_RECIEVED_TOTAL_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG00F_RECIEVED_GOOD_PKTS_CNT_LATCH */
/* recieved_good_pkts_cnt_latch */
#define REG_DPHY_REG00F_RECIEVED_GOOD_PKTS_CNT_LATCH          0x0003C
#define REG_DPHY_REG00F_RECIEVED_GOOD_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG00F_RECIEVED_GOOD_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG00F_RECIEVED_GOOD_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG010_RECIEVED_UNSUPPORTED_PKTS_CNT_LATCH */
/* recieved_unsupported_pkts_cnt_latch */
#define REG_DPHY_REG010_RECIEVED_UNSUPPORTED_PKTS_CNT_LATCH          0x00040
#define REG_DPHY_REG010_RECIEVED_UNSUPPORTED_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG010_RECIEVED_UNSUPPORTED_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG010_RECIEVED_UNSUPPORTED_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG011_RECIEVED_COLLISION_PKTS_CNT_LATCH */
/* recieved_collision_pkts_cnt_latch */
#define REG_DPHY_REG011_RECIEVED_COLLISION_PKTS_CNT_LATCH          0x00044
#define REG_DPHY_REG011_RECIEVED_COLLISION_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG011_RECIEVED_COLLISION_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG011_RECIEVED_COLLISION_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG012_RECIEVED_ERROR_PKTS_CNT_LATCH */
/* recieved_error_pkts_cnt_latch */
#define REG_DPHY_REG012_RECIEVED_ERROR_PKTS_CNT_LATCH          0x00048
#define REG_DPHY_REG012_RECIEVED_ERROR_PKTS_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG012_RECIEVED_ERROR_PKTS_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG012_RECIEVED_ERROR_PKTS_CNT_LATCH_WIDTH    32

/* DPHY_REG013_RECIEVED_BYTE_CNT_LATCH */
/* recieved_byte_cnt_latch */
#define REG_DPHY_REG013_RECIEVED_BYTE_CNT_LATCH          0x0004C
#define REG_DPHY_REG013_RECIEVED_BYTE_CNT_LATCH_MASK     0xffffffff
#define REG_DPHY_REG013_RECIEVED_BYTE_CNT_LATCH_SHIFT    0
#define REG_DPHY_REG013_RECIEVED_BYTE_CNT_LATCH_WIDTH    32
#endif 
