/*******************************************************************
*                                                                   
*  DV_BOARD.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef DV_BOARD_regs_H_FILE
#define DV_BOARD_regs_H_FILE

/* DV_BOARD_3015_PIF_WR_DATA */
/*  Pif Mode\nPif Write Data 12 bits width\nGen2.0\nBit[15] (1)  - push data to pif fifo (usually used for burst mode),\nBit[14] 1- herc increment address (usually used for burst mode - fast sequence - d,a,d,d,d,..,d)\nwriting new data to Herc\nusing Auto Increment adderess.\ni.e\n   wr_imd   (PHY_RX_TD_IF_phy_rxtd_if15 ,4321)  // Data  write data 0x321 use auti onc\n   wr_imd   (PHY_RX_TD_IF_phy_rxtd_if16 ,00c4)  //  Pif cntrl adrr 21:16 cs 22 wr_rdn 23 wr addr 3  Push data + contol\n   wr_imd   (PHY_RX_TD_IF_phy_rxtd_if15 ,c456)  // Data Burst mode push data to fifo\n   wr_imd   (PHY_RX_TD_IF_phy_rxtd_if15 ,8789)  // Data push data to fifo and end of burst bit [14] =0\n\nBurst Mode operational only with gen_risc program - fifo not empty during burst\n */
#define REG_DV_BOARD_3015_PIF_WR_DATA          0x30010054
#define REG_DV_BOARD_3015_PIF_WR_DATA_MASK     0x0000ffff
#define REG_DV_BOARD_3015_PIF_WR_DATA_SHIFT    0
#define REG_DV_BOARD_3015_PIF_WR_DATA_WIDTH    16

/* DV_BOARD_3016_PIF_PUSH_DATA_CNTRL */
/* Pif Mode:\nPif Push Data and Control\nreg_16[8] is address auto increment (normal burst mode - a,d,a,d,...,a,d)\ndata to fifo {reg_16[7:0],reg_15}.\nreg_16[7] write active high read active low (wr_rdn)\nreg_16[6] Cs 0/1\nreg_16[5:0] address\nBit [11:0] Data from reg_15\n\nRFIC MSPI & Parallel Mode\n[31:30] chip select \n00- cs0\n01- cs1\n10- cs2\n\nBurst Mode operational only with gen_risc program - fifo not empty during burst\n  */
#define REG_DV_BOARD_3016_PIF_PUSH_DATA_CNTRL          0x30010058
#define REG_DV_BOARD_3016_PIF_PUSH_DATA_CNTRL_MASK     0x0000ffff
#define REG_DV_BOARD_3016_PIF_PUSH_DATA_CNTRL_SHIFT    0
#define REG_DV_BOARD_3016_PIF_PUSH_DATA_CNTRL_WIDTH    16

/* DV_BOARD_3017_PIF_CLEAN_FIFO */
/* Pif Clean Fifo. */
#define REG_DV_BOARD_3017_PIF_CLEAN_FIFO          0x3001005C
#define REG_DV_BOARD_3017_PIF_CLEAN_FIFO_MASK     0x00000001
#define REG_DV_BOARD_3017_PIF_CLEAN_FIFO_SHIFT    0
#define REG_DV_BOARD_3017_PIF_CLEAN_FIFO_WIDTH    1

/* DV_BOARD_3017_PIF_CLEAR_STATUS */
/* Pif Read Master Pif Status Register.\nclean all status errors bits & and clean the Pif read data valid. */
#define REG_DV_BOARD_3017_PIF_CLEAR_STATUS          0x3001005C
#define REG_DV_BOARD_3017_PIF_CLEAR_STATUS_MASK     0x00000002
#define REG_DV_BOARD_3017_PIF_CLEAR_STATUS_SHIFT    1
#define REG_DV_BOARD_3017_PIF_CLEAR_STATUS_WIDTH    1

/* DV_BOARD_3018_PIF_STATUS_RD_DATA_VALID */
/* Pif Read Data Valid\nPif finished read operation and the data is valid and need to be read. */
#define REG_DV_BOARD_3018_PIF_STATUS_RD_DATA_VALID          0x30010060
#define REG_DV_BOARD_3018_PIF_STATUS_RD_DATA_VALID_MASK     0x00000001
#define REG_DV_BOARD_3018_PIF_STATUS_RD_DATA_VALID_SHIFT    0
#define REG_DV_BOARD_3018_PIF_STATUS_RD_DATA_VALID_WIDTH    1

/* DV_BOARD_3018_PIF_STATUS_DONE */
/* Pif Done\nCommand Fifo is empty & and last command was executed. */
#define REG_DV_BOARD_3018_PIF_STATUS_DONE          0x30010060
#define REG_DV_BOARD_3018_PIF_STATUS_DONE_MASK     0x00000002
#define REG_DV_BOARD_3018_PIF_STATUS_DONE_SHIFT    1
#define REG_DV_BOARD_3018_PIF_STATUS_DONE_WIDTH    1

/* DV_BOARD_3018_PIF_STATUS_TXFIFO_EMPTY */
/* Pif Command Fifo is empty. */
#define REG_DV_BOARD_3018_PIF_STATUS_TXFIFO_EMPTY          0x30010060
#define REG_DV_BOARD_3018_PIF_STATUS_TXFIFO_EMPTY_MASK     0x00000004
#define REG_DV_BOARD_3018_PIF_STATUS_TXFIFO_EMPTY_SHIFT    2
#define REG_DV_BOARD_3018_PIF_STATUS_TXFIFO_EMPTY_WIDTH    1

/* DV_BOARD_3018_PIF_BYTES_IN_TX_FIFO */
/* Pif Number of commands in fifo. */
#define REG_DV_BOARD_3018_PIF_BYTES_IN_TX_FIFO          0x30010060
#define REG_DV_BOARD_3018_PIF_BYTES_IN_TX_FIFO_MASK     0x00000038
#define REG_DV_BOARD_3018_PIF_BYTES_IN_TX_FIFO_SHIFT    3
#define REG_DV_BOARD_3018_PIF_BYTES_IN_TX_FIFO_WIDTH    3

/* DV_BOARD_3018_PIF_RX_OVERRUN */
/* Pif Rx Overrun */
#define REG_DV_BOARD_3018_PIF_RX_OVERRUN          0x30010060
#define REG_DV_BOARD_3018_PIF_RX_OVERRUN_MASK     0x00000040
#define REG_DV_BOARD_3018_PIF_RX_OVERRUN_SHIFT    6
#define REG_DV_BOARD_3018_PIF_RX_OVERRUN_WIDTH    1

/* DV_BOARD_3018_PIFI_TX_OVERRUN */
/* Pif Tx Overrun */
#define REG_DV_BOARD_3018_PIFI_TX_OVERRUN          0x30010060
#define REG_DV_BOARD_3018_PIFI_TX_OVERRUN_MASK     0x00000080
#define REG_DV_BOARD_3018_PIFI_TX_OVERRUN_SHIFT    7
#define REG_DV_BOARD_3018_PIFI_TX_OVERRUN_WIDTH    1

/* DV_BOARD_3019_PIF_RD_DATA_LOW */
/* Pif Read Data\nRead Low 16 Bits. */
#define REG_DV_BOARD_3019_PIF_RD_DATA_LOW          0x30010064
#define REG_DV_BOARD_3019_PIF_RD_DATA_LOW_MASK     0x0000ffff
#define REG_DV_BOARD_3019_PIF_RD_DATA_LOW_SHIFT    0
#define REG_DV_BOARD_3019_PIF_RD_DATA_LOW_WIDTH    16

/* DV_BOARD_301A_PIF_RD_DATA_HIGH */
/* Pif Read Data\nRead High 16 Bits. */
#define REG_DV_BOARD_301A_PIF_RD_DATA_HIGH          0x30010068
#define REG_DV_BOARD_301A_PIF_RD_DATA_HIGH_MASK     0x0000ffff
#define REG_DV_BOARD_301A_PIF_RD_DATA_HIGH_SHIFT    0
#define REG_DV_BOARD_301A_PIF_RD_DATA_HIGH_WIDTH    16

/* DV_BOARD_3048_PIF_CLK_LENGTH */
/* Half length of wr in clk +1. 
Strobe rate = (sys_clk/(reg+1)*2 */
#define REG_DV_BOARD_3048_PIF_CLK_LENGTH          0x30000120
#define REG_DV_BOARD_3048_PIF_CLK_LENGTH_MASK     0x00000007
#define REG_DV_BOARD_3048_PIF_CLK_LENGTH_SHIFT    0
#define REG_DV_BOARD_3048_PIF_CLK_LENGTH_WIDTH    3

/* DV_BOARD_3048_PIF_START_DLY_CS */
/* cs up and rd_stb up at the begining of the transaction. */
#define REG_DV_BOARD_3048_PIF_START_DLY_CS          0x30000120
#define REG_DV_BOARD_3048_PIF_START_DLY_CS_MASK     0x00000030
#define REG_DV_BOARD_3048_PIF_START_DLY_CS_SHIFT    4
#define REG_DV_BOARD_3048_PIF_START_DLY_CS_WIDTH    2

/* DV_BOARD_3048_PIF_END_DLY_CS */
/* Delay between the rd_stb negated and trhe cs negated. */
#define REG_DV_BOARD_3048_PIF_END_DLY_CS          0x30000120
#define REG_DV_BOARD_3048_PIF_END_DLY_CS_MASK     0x00000300
#define REG_DV_BOARD_3048_PIF_END_DLY_CS_SHIFT    8
#define REG_DV_BOARD_3048_PIF_END_DLY_CS_WIDTH    2

/* DV_BOARD_3048_PIF_END_ADD_DLY */
/* delay between rd_strb up and end of address.  */
#define REG_DV_BOARD_3048_PIF_END_ADD_DLY          0x30000120
#define REG_DV_BOARD_3048_PIF_END_ADD_DLY_MASK     0x00003000
#define REG_DV_BOARD_3048_PIF_END_ADD_DLY_SHIFT    12
#define REG_DV_BOARD_3048_PIF_END_ADD_DLY_WIDTH    2

/* DV_BOARD_3048_PIF_RD_CLK_LENGTH */
/* Half length of read in clk +1. 
Strobe rate = (sys_clk/(reg+1)*2 */
#define REG_DV_BOARD_3048_PIF_RD_CLK_LENGTH          0x30000120
#define REG_DV_BOARD_3048_PIF_RD_CLK_LENGTH_MASK     0x00070000
#define REG_DV_BOARD_3048_PIF_RD_CLK_LENGTH_SHIFT    16
#define REG_DV_BOARD_3048_PIF_RD_CLK_LENGTH_WIDTH    3

/* DV_BOARD_3048_PIF_RD_END_DLY_CS */
/* Delay between the rd_stb negated and trhe cs negated. */
#define REG_DV_BOARD_3048_PIF_RD_END_DLY_CS          0x30000120
#define REG_DV_BOARD_3048_PIF_RD_END_DLY_CS_MASK     0x00700000
#define REG_DV_BOARD_3048_PIF_RD_END_DLY_CS_SHIFT    20
#define REG_DV_BOARD_3048_PIF_RD_END_DLY_CS_WIDTH    3

/* DV_BOARD_3049_PIF_EN_BURST_READ */
/* Enable Burst Read. The default value was changed to "1" support wr/read/wr to the fifo
1-The Control fifo is not blocked after read command.
0-The control fifo blocked after the first read command.

 */
#define REG_DV_BOARD_3049_PIF_EN_BURST_READ          0x30000124
#define REG_DV_BOARD_3049_PIF_EN_BURST_READ_MASK     0x00000002
#define REG_DV_BOARD_3049_PIF_EN_BURST_READ_SHIFT    1
#define REG_DV_BOARD_3049_PIF_EN_BURST_READ_WIDTH    1

/* DV_BOARD_304A_HYP_PIF_MSPI_READ_POLARITY */
/* Rx TD Hyp Pif Mspi read polarity
0-Read active Low
1-Read active High */
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_POLARITY          0x30000128
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_POLARITY_MASK     0x00020000
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_POLARITY_SHIFT    17
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_POLARITY_WIDTH    1

/* DV_BOARD_304A_HYP_PIF_MSPI_READ_BIT_LOCATION */
/* Rx TD Hyp Pif Mspi Read Bit Location.
19- for PIF. */
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_BIT_LOCATION          0x30000128
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_BIT_LOCATION_MASK     0xf8000000
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_BIT_LOCATION_SHIFT    27
#define REG_DV_BOARD_304A_HYP_PIF_MSPI_READ_BIT_LOCATION_WIDTH    5

/* DV_BOARD_317A_PIF_STROBE_CLK_ACTIVE */
/* pif_strobe_clk_active */
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_ACTIVE          0x300005E8
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_ACTIVE_MASK     0x00000001
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_ACTIVE_SHIFT    0
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_ACTIVE_WIDTH    1

/* DV_BOARD_317A_PIF_STROBE_CLK_RATIO */
/* pif_strobe_clk_ratio */
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_RATIO          0x300005E8
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_RATIO_MASK     0x000001f0
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_RATIO_SHIFT    4
#define REG_DV_BOARD_317A_PIF_STROBE_CLK_RATIO_WIDTH    5

/* DV_BOARD_8000_PIGGY_BB_CTRL */
/* piggy_bb_ctrl */
#define REG_DV_BOARD_8000_PIGGY_BB_CTRL          0x80000000
#define REG_DV_BOARD_8000_PIGGY_BB_CTRL_MASK     0x0000003f
#define REG_DV_BOARD_8000_PIGGY_BB_CTRL_SHIFT    0
#define REG_DV_BOARD_8000_PIGGY_BB_CTRL_WIDTH    6

/* DV_BOARD_8001_BB_CTRL */
/* bb_ctrl */
#define REG_DV_BOARD_8001_BB_CTRL          0x80000004
#define REG_DV_BOARD_8001_BB_CTRL_MASK     0x0000000f
#define REG_DV_BOARD_8001_BB_CTRL_SHIFT    0
#define REG_DV_BOARD_8001_BB_CTRL_WIDTH    4

/* DV_BOARD_8002_DPST_TX */
/* dpst_tx */
#define REG_DV_BOARD_8002_DPST_TX          0x80000008
#define REG_DV_BOARD_8002_DPST_TX_MASK     0x00000007
#define REG_DV_BOARD_8002_DPST_TX_SHIFT    0
#define REG_DV_BOARD_8002_DPST_TX_WIDTH    3
#endif 
