/*******************************************************************
*                                                                  
*  Denali_DDR.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 12/06/2011  */

#ifndef Denali_DDR_regs_H_FILE
#define Denali_DDR_regs_H_FILE

/* ADDR_CMP_EN */
#define REG_ADDR_CMP_EN          0x00000
#define REG_ADDR_CMP_EN_MASK     0x00000001
#define REG_ADDR_CMP_EN_SHIFT    0
#define REG_ADDR_CMP_EN_WIDTH    1

/* AP */
#define REG_AP          0x00000
#define REG_AP_MASK     0x00000100
#define REG_AP_SHIFT    8
#define REG_AP_WIDTH    1

/* AREFRESH */
#define REG_AREFRESH          0x00000
#define REG_AREFRESH_MASK     0x00010000
#define REG_AREFRESH_SHIFT    16
#define REG_AREFRESH_WIDTH    1

/* AUTO_REFRESH_MODE */
#define REG_AUTO_REFRESH_MODE          0x00000
#define REG_AUTO_REFRESH_MODE_MASK     0x01000000
#define REG_AUTO_REFRESH_MODE_SHIFT    24
#define REG_AUTO_REFRESH_MODE_WIDTH    1

/* BANK_SPLIT_EN */
#define REG_BANK_SPLIT_EN          0x00004
#define REG_BANK_SPLIT_EN_MASK     0x00000001
#define REG_BANK_SPLIT_EN_SHIFT    0
#define REG_BANK_SPLIT_EN_WIDTH    1

/* CKE_STATUS */
#define REG_CKE_STATUS          0x00004
#define REG_CKE_STATUS_MASK     0x00000100
#define REG_CKE_STATUS_SHIFT    8
#define REG_CKE_STATUS_WIDTH    1

/* CONCURRENTAP */
#define REG_CONCURRENTAP          0x00004
#define REG_CONCURRENTAP_MASK     0x00010000
#define REG_CONCURRENTAP_SHIFT    16
#define REG_CONCURRENTAP_WIDTH    1

/* CONCURRENTAP_WR_ONLY */
#define REG_CONCURRENTAP_WR_ONLY          0x00004
#define REG_CONCURRENTAP_WR_ONLY_MASK     0x01000000
#define REG_CONCURRENTAP_WR_ONLY_SHIFT    24
#define REG_CONCURRENTAP_WR_ONLY_WIDTH    1

/* DLLLOCKREG */
#define REG_DLLLOCKREG          0x00008
#define REG_DLLLOCKREG_MASK     0x00000001
#define REG_DLLLOCKREG_SHIFT    0
#define REG_DLLLOCKREG_WIDTH    1

/* DLL_BYPASS_MODE */
#define REG_DLL_BYPASS_MODE          0x00008
#define REG_DLL_BYPASS_MODE_MASK     0x00000100
#define REG_DLL_BYPASS_MODE_SHIFT    8
#define REG_DLL_BYPASS_MODE_WIDTH    1

/* DQS_N_EN */
#define REG_DQS_N_EN          0x00008
#define REG_DQS_N_EN_MASK     0x00010000
#define REG_DQS_N_EN_SHIFT    16
#define REG_DQS_N_EN_WIDTH    1

/* DRAM_CLK_DISABLE */
#define REG_DRAM_CLK_DISABLE          0x00008
#define REG_DRAM_CLK_DISABLE_MASK     0x01000000
#define REG_DRAM_CLK_DISABLE_SHIFT    24
#define REG_DRAM_CLK_DISABLE_WIDTH    1

/* DRIVE_DQ_DQS */
#define REG_DRIVE_DQ_DQS          0x0000C
#define REG_DRIVE_DQ_DQS_MASK     0x00000001
#define REG_DRIVE_DQ_DQS_SHIFT    0
#define REG_DRIVE_DQ_DQS_WIDTH    1

/* ENABLE_QUICK_SREFRESH */
#define REG_ENABLE_QUICK_SREFRESH          0x0000C
#define REG_ENABLE_QUICK_SREFRESH_MASK     0x00000100
#define REG_ENABLE_QUICK_SREFRESH_SHIFT    8
#define REG_ENABLE_QUICK_SREFRESH_WIDTH    1

/* FAST_WRITE */
#define REG_FAST_WRITE          0x0000C
#define REG_FAST_WRITE_MASK     0x00010000
#define REG_FAST_WRITE_SHIFT    16
#define REG_FAST_WRITE_WIDTH    1

/* INTRPTAPBURST */
#define REG_INTRPTAPBURST          0x0000C
#define REG_INTRPTAPBURST_MASK     0x01000000
#define REG_INTRPTAPBURST_SHIFT    24
#define REG_INTRPTAPBURST_WIDTH    1

/* INTRPTREADA */
#define REG_INTRPTREADA          0x00010
#define REG_INTRPTREADA_MASK     0x00000001
#define REG_INTRPTREADA_SHIFT    0
#define REG_INTRPTREADA_WIDTH    1

/* INTRPTWRITEA */
#define REG_INTRPTWRITEA          0x00010
#define REG_INTRPTWRITEA_MASK     0x00000100
#define REG_INTRPTWRITEA_SHIFT    8
#define REG_INTRPTWRITEA_WIDTH    1

/* MAX_CS_REG */
#define REG_MAX_CS_REG          0x00010
#define REG_MAX_CS_REG_MASK     0x00010000
#define REG_MAX_CS_REG_SHIFT    16
#define REG_MAX_CS_REG_WIDTH    1

/* NO_CMD_INIT */
#define REG_NO_CMD_INIT          0x00010
#define REG_NO_CMD_INIT_MASK     0x01000000
#define REG_NO_CMD_INIT_SHIFT    24
#define REG_NO_CMD_INIT_WIDTH    1

/* ODT_ALT_EN */
#define REG_ODT_ALT_EN          0x00014
#define REG_ODT_ALT_EN_MASK     0x00000001
#define REG_ODT_ALT_EN_SHIFT    0
#define REG_ODT_ALT_EN_WIDTH    1

/* PLACEMENT_EN */
#define REG_PLACEMENT_EN          0x00014
#define REG_PLACEMENT_EN_MASK     0x00000100
#define REG_PLACEMENT_EN_SHIFT    8
#define REG_PLACEMENT_EN_WIDTH    1

/* POWER_DOWN */
#define REG_POWER_DOWN          0x00014
#define REG_POWER_DOWN_MASK     0x00010000
#define REG_POWER_DOWN_SHIFT    16
#define REG_POWER_DOWN_WIDTH    1

/* PRIORITY_EN */
#define REG_PRIORITY_EN          0x00014
#define REG_PRIORITY_EN_MASK     0x01000000
#define REG_PRIORITY_EN_SHIFT    24
#define REG_PRIORITY_EN_WIDTH    1

/* PWRUP_SREFRESH_EXIT */
#define REG_PWRUP_SREFRESH_EXIT          0x00018
#define REG_PWRUP_SREFRESH_EXIT_MASK     0x00000001
#define REG_PWRUP_SREFRESH_EXIT_SHIFT    0
#define REG_PWRUP_SREFRESH_EXIT_WIDTH    1

/* REDUC */
#define REG_REDUC          0x00018
#define REG_REDUC_MASK     0x00000100
#define REG_REDUC_SHIFT    8
#define REG_REDUC_WIDTH    1

/* REG_DIMM_ENABLE */
#define REG_REG_DIMM_ENABLE          0x00018
#define REG_REG_DIMM_ENABLE_MASK     0x00010000
#define REG_REG_DIMM_ENABLE_SHIFT    16
#define REG_REG_DIMM_ENABLE_WIDTH    1

/* RESYNC_DLL */
#define REG_RESYNC_DLL          0x00018
#define REG_RESYNC_DLL_MASK     0x01000000
#define REG_RESYNC_DLL_SHIFT    24
#define REG_RESYNC_DLL_WIDTH    1

/* RESYNC_DLL_PER_AREF_EN */
#define REG_RESYNC_DLL_PER_AREF_EN          0x0001C
#define REG_RESYNC_DLL_PER_AREF_EN_MASK     0x00000001
#define REG_RESYNC_DLL_PER_AREF_EN_SHIFT    0
#define REG_RESYNC_DLL_PER_AREF_EN_WIDTH    1

/* RW_SAME_EN */
#define REG_RW_SAME_EN          0x0001C
#define REG_RW_SAME_EN_MASK     0x00000100
#define REG_RW_SAME_EN_SHIFT    8
#define REG_RW_SAME_EN_WIDTH    1

/* SREFRESH */
#define REG_SREFRESH          0x0001C
#define REG_SREFRESH_MASK     0x00010000
#define REG_SREFRESH_SHIFT    16
#define REG_SREFRESH_WIDTH    1

/* START */
#define REG_START          0x0001C
#define REG_START_MASK     0x01000000
#define REG_START_SHIFT    24
#define REG_START_WIDTH    1

/* SWAP_EN */
#define REG_SWAP_EN          0x00020
#define REG_SWAP_EN_MASK     0x00000001
#define REG_SWAP_EN_SHIFT    0
#define REG_SWAP_EN_WIDTH    1

/* TRAS_LOCKOUT */
#define REG_TRAS_LOCKOUT          0x00020
#define REG_TRAS_LOCKOUT_MASK     0x00000100
#define REG_TRAS_LOCKOUT_SHIFT    8
#define REG_TRAS_LOCKOUT_WIDTH    1

/* TREF_ENABLE */
#define REG_TREF_ENABLE          0x00020
#define REG_TREF_ENABLE_MASK     0x00010000
#define REG_TREF_ENABLE_SHIFT    16
#define REG_TREF_ENABLE_WIDTH    1

/* WEIGHTED_ROUND_ROBIN_LATENCY_CONTROL */
#define REG_WEIGHTED_ROUND_ROBIN_LATENCY_CONTROL          0x00020
#define REG_WEIGHTED_ROUND_ROBIN_LATENCY_CONTROL_MASK     0x01000000
#define REG_WEIGHTED_ROUND_ROBIN_LATENCY_CONTROL_SHIFT    24
#define REG_WEIGHTED_ROUND_ROBIN_LATENCY_CONTROL_WIDTH    1

/* WRITEINTERP */
#define REG_WRITEINTERP          0x00024
#define REG_WRITEINTERP_MASK     0x00000001
#define REG_WRITEINTERP_SHIFT    0
#define REG_WRITEINTERP_WIDTH    1

/* WRITE_MODEREG */
#define REG_WRITE_MODEREG          0x00024
#define REG_WRITE_MODEREG_MASK     0x00000100
#define REG_WRITE_MODEREG_SHIFT    8
#define REG_WRITE_MODEREG_WIDTH    1

/* AXI0_FIFO_TYPE_REG */
#define REG_AXI0_FIFO_TYPE_REG          0x00024
#define REG_AXI0_FIFO_TYPE_REG_MASK     0x00030000
#define REG_AXI0_FIFO_TYPE_REG_SHIFT    16
#define REG_AXI0_FIFO_TYPE_REG_WIDTH    2

/* AXI1_FIFO_TYPE_REG */
#define REG_AXI1_FIFO_TYPE_REG          0x00024
#define REG_AXI1_FIFO_TYPE_REG_MASK     0x03000000
#define REG_AXI1_FIFO_TYPE_REG_SHIFT    24
#define REG_AXI1_FIFO_TYPE_REG_WIDTH    2

/* AXI2_FIFO_TYPE_REG */
#define REG_AXI2_FIFO_TYPE_REG          0x00028
#define REG_AXI2_FIFO_TYPE_REG_MASK     0x00000003
#define REG_AXI2_FIFO_TYPE_REG_SHIFT    0
#define REG_AXI2_FIFO_TYPE_REG_WIDTH    2

/* AXI3_FIFO_TYPE_REG */
#define REG_AXI3_FIFO_TYPE_REG          0x00028
#define REG_AXI3_FIFO_TYPE_REG_MASK     0x00000300
#define REG_AXI3_FIFO_TYPE_REG_SHIFT    8
#define REG_AXI3_FIFO_TYPE_REG_WIDTH    2

/* AXI4_FIFO_TYPE_REG */
#define REG_AXI4_FIFO_TYPE_REG          0x00028
#define REG_AXI4_FIFO_TYPE_REG_MASK     0x00030000
#define REG_AXI4_FIFO_TYPE_REG_SHIFT    16
#define REG_AXI4_FIFO_TYPE_REG_WIDTH    2

/* WEIGHTED_ROUND_ROBIN_WEIGHT_SHARING */
#define REG_WEIGHTED_ROUND_ROBIN_WEIGHT_SHARING          0x00028
#define REG_WEIGHTED_ROUND_ROBIN_WEIGHT_SHARING_MASK     0x03000000
#define REG_WEIGHTED_ROUND_ROBIN_WEIGHT_SHARING_SHIFT    24
#define REG_WEIGHTED_ROUND_ROBIN_WEIGHT_SHARING_WIDTH    2

/* ADDR_PINS */
#define REG_ADDR_PINS          0x0002C
#define REG_ADDR_PINS_MASK     0x00000007
#define REG_ADDR_PINS_SHIFT    0
#define REG_ADDR_PINS_WIDTH    3

/* AXI0_PORT_ORDERING */
#define REG_AXI0_PORT_ORDERING          0x0002C
#define REG_AXI0_PORT_ORDERING_MASK     0x00000700
#define REG_AXI0_PORT_ORDERING_SHIFT    8
#define REG_AXI0_PORT_ORDERING_WIDTH    3

/* AXI0_R_PRIORITY */
#define REG_AXI0_R_PRIORITY          0x0002C
#define REG_AXI0_R_PRIORITY_MASK     0x00070000
#define REG_AXI0_R_PRIORITY_SHIFT    16
#define REG_AXI0_R_PRIORITY_WIDTH    3

/* AXI0_W_PRIORITY */
#define REG_AXI0_W_PRIORITY          0x0002C
#define REG_AXI0_W_PRIORITY_MASK     0x07000000
#define REG_AXI0_W_PRIORITY_SHIFT    24
#define REG_AXI0_W_PRIORITY_WIDTH    3

/* AXI1_PORT_ORDERING */
#define REG_AXI1_PORT_ORDERING          0x00030
#define REG_AXI1_PORT_ORDERING_MASK     0x00000007
#define REG_AXI1_PORT_ORDERING_SHIFT    0
#define REG_AXI1_PORT_ORDERING_WIDTH    3

/* AXI1_R_PRIORITY */
#define REG_AXI1_R_PRIORITY          0x00030
#define REG_AXI1_R_PRIORITY_MASK     0x00000700
#define REG_AXI1_R_PRIORITY_SHIFT    8
#define REG_AXI1_R_PRIORITY_WIDTH    3

/* AXI1_W_PRIORITY */
#define REG_AXI1_W_PRIORITY          0x00030
#define REG_AXI1_W_PRIORITY_MASK     0x00070000
#define REG_AXI1_W_PRIORITY_SHIFT    16
#define REG_AXI1_W_PRIORITY_WIDTH    3

/* AXI2_PORT_ORDERING */
#define REG_AXI2_PORT_ORDERING          0x00030
#define REG_AXI2_PORT_ORDERING_MASK     0x07000000
#define REG_AXI2_PORT_ORDERING_SHIFT    24
#define REG_AXI2_PORT_ORDERING_WIDTH    3

/* AXI2_R_PRIORITY */
#define REG_AXI2_R_PRIORITY          0x00034
#define REG_AXI2_R_PRIORITY_MASK     0x00000007
#define REG_AXI2_R_PRIORITY_SHIFT    0
#define REG_AXI2_R_PRIORITY_WIDTH    3

/* AXI2_W_PRIORITY */
#define REG_AXI2_W_PRIORITY          0x00034
#define REG_AXI2_W_PRIORITY_MASK     0x00000700
#define REG_AXI2_W_PRIORITY_SHIFT    8
#define REG_AXI2_W_PRIORITY_WIDTH    3

/* AXI3_PORT_ORDERING */
#define REG_AXI3_PORT_ORDERING          0x00034
#define REG_AXI3_PORT_ORDERING_MASK     0x00070000
#define REG_AXI3_PORT_ORDERING_SHIFT    16
#define REG_AXI3_PORT_ORDERING_WIDTH    3

/* AXI3_R_PRIORITY */
#define REG_AXI3_R_PRIORITY          0x00034
#define REG_AXI3_R_PRIORITY_MASK     0x07000000
#define REG_AXI3_R_PRIORITY_SHIFT    24
#define REG_AXI3_R_PRIORITY_WIDTH    3

/* AXI3_W_PRIORITY */
#define REG_AXI3_W_PRIORITY          0x00038
#define REG_AXI3_W_PRIORITY_MASK     0x00000007
#define REG_AXI3_W_PRIORITY_SHIFT    0
#define REG_AXI3_W_PRIORITY_WIDTH    3

/* AXI4_PORT_ORDERING */
#define REG_AXI4_PORT_ORDERING          0x00038
#define REG_AXI4_PORT_ORDERING_MASK     0x00000700
#define REG_AXI4_PORT_ORDERING_SHIFT    8
#define REG_AXI4_PORT_ORDERING_WIDTH    3

/* AXI4_R_PRIORITY */
#define REG_AXI4_R_PRIORITY          0x00038
#define REG_AXI4_R_PRIORITY_MASK     0x00070000
#define REG_AXI4_R_PRIORITY_SHIFT    16
#define REG_AXI4_R_PRIORITY_WIDTH    3

/* AXI4_W_PRIORITY */
#define REG_AXI4_W_PRIORITY          0x00038
#define REG_AXI4_W_PRIORITY_MASK     0x07000000
#define REG_AXI4_W_PRIORITY_SHIFT    24
#define REG_AXI4_W_PRIORITY_WIDTH    3

/* CASLAT */
#define REG_CASLAT          0x0003C
#define REG_CASLAT_MASK     0x00000007
#define REG_CASLAT_SHIFT    0
#define REG_CASLAT_WIDTH    3

/* CKE_DELAY */
#define REG_CKE_DELAY          0x0003C
#define REG_CKE_DELAY_MASK     0x00000700
#define REG_CKE_DELAY_SHIFT    8
#define REG_CKE_DELAY_WIDTH    3

/* COLUMN_SIZE */
#define REG_COLUMN_SIZE          0x0003C
#define REG_COLUMN_SIZE_MASK     0x00070000
#define REG_COLUMN_SIZE_SHIFT    16
#define REG_COLUMN_SIZE_WIDTH    3

/* PORT_DATA_ERROR_TYPE */
#define REG_PORT_DATA_ERROR_TYPE          0x0003C
#define REG_PORT_DATA_ERROR_TYPE_MASK     0x07000000
#define REG_PORT_DATA_ERROR_TYPE_SHIFT    24
#define REG_PORT_DATA_ERROR_TYPE_WIDTH    3

/* Q_FULLNESS */
#define REG_Q_FULLNESS          0x00040
#define REG_Q_FULLNESS_MASK     0x00000007
#define REG_Q_FULLNESS_SHIFT    0
#define REG_Q_FULLNESS_WIDTH    3

/* R2R_SAMECS_DLY */
#define REG_R2R_SAMECS_DLY          0x00040
#define REG_R2R_SAMECS_DLY_MASK     0x00000700
#define REG_R2R_SAMECS_DLY_SHIFT    8
#define REG_R2R_SAMECS_DLY_WIDTH    3

/* R2W_SAMECS_DLY */
#define REG_R2W_SAMECS_DLY          0x00040
#define REG_R2W_SAMECS_DLY_MASK     0x00070000
#define REG_R2W_SAMECS_DLY_SHIFT    16
#define REG_R2W_SAMECS_DLY_WIDTH    3

/* TBST_INT_INTERVAL */
#define REG_TBST_INT_INTERVAL          0x00040
#define REG_TBST_INT_INTERVAL_MASK     0x07000000
#define REG_TBST_INT_INTERVAL_SHIFT    24
#define REG_TBST_INT_INTERVAL_WIDTH    3

/* TCKE */
#define REG_TCKE          0x00044
#define REG_TCKE_MASK     0x00000007
#define REG_TCKE_SHIFT    0
#define REG_TCKE_WIDTH    3

/* TRRD */
#define REG_TRRD          0x00044
#define REG_TRRD_MASK     0x00000700
#define REG_TRRD_SHIFT    8
#define REG_TRRD_WIDTH    3

/* TRTP */
#define REG_TRTP          0x00044
#define REG_TRTP_MASK     0x00070000
#define REG_TRTP_SHIFT    16
#define REG_TRTP_WIDTH    3

/* W2R_SAMECS_DLY */
#define REG_W2R_SAMECS_DLY          0x00044
#define REG_W2R_SAMECS_DLY_MASK     0x07000000
#define REG_W2R_SAMECS_DLY_SHIFT    24
#define REG_W2R_SAMECS_DLY_WIDTH    3

/* W2W_SAMECS_DLY */
#define REG_W2W_SAMECS_DLY          0x00048
#define REG_W2W_SAMECS_DLY_MASK     0x00000007
#define REG_W2W_SAMECS_DLY_SHIFT    0
#define REG_W2W_SAMECS_DLY_WIDTH    3

/* ADD_ODT_CLK_DIFFTYPE_SAMECS */
#define REG_ADD_ODT_CLK_DIFFTYPE_SAMECS          0x00048
#define REG_ADD_ODT_CLK_DIFFTYPE_SAMECS_MASK     0x00000f00
#define REG_ADD_ODT_CLK_DIFFTYPE_SAMECS_SHIFT    8
#define REG_ADD_ODT_CLK_DIFFTYPE_SAMECS_WIDTH    4

/* AHB0_RDLEN */
#define REG_AHB0_RDLEN          0x00048
#define REG_AHB0_RDLEN_MASK     0x000f0000
#define REG_AHB0_RDLEN_SHIFT    16
#define REG_AHB0_RDLEN_WIDTH    4

/* AHB0_WRLEN */
#define REG_AHB0_WRLEN          0x00048
#define REG_AHB0_WRLEN_MASK     0x0f000000
#define REG_AHB0_WRLEN_SHIFT    24
#define REG_AHB0_WRLEN_WIDTH    4

/* AHB1_RDLEN */
#define REG_AHB1_RDLEN          0x0004C
#define REG_AHB1_RDLEN_MASK     0x0000000f
#define REG_AHB1_RDLEN_SHIFT    0
#define REG_AHB1_RDLEN_WIDTH    4

/* AHB1_WRLEN */
#define REG_AHB1_WRLEN          0x0004C
#define REG_AHB1_WRLEN_MASK     0x00000f00
#define REG_AHB1_WRLEN_SHIFT    8
#define REG_AHB1_WRLEN_WIDTH    4

/* AHB2_RDLEN */
#define REG_AHB2_RDLEN          0x0004C
#define REG_AHB2_RDLEN_MASK     0x000f0000
#define REG_AHB2_RDLEN_SHIFT    16
#define REG_AHB2_RDLEN_WIDTH    4

/* AHB2_WRLEN */
#define REG_AHB2_WRLEN          0x0004C
#define REG_AHB2_WRLEN_MASK     0x0f000000
#define REG_AHB2_WRLEN_SHIFT    24
#define REG_AHB2_WRLEN_WIDTH    4

/* AHB3_RDLEN */
#define REG_AHB3_RDLEN          0x00050
#define REG_AHB3_RDLEN_MASK     0x0000000f
#define REG_AHB3_RDLEN_SHIFT    0
#define REG_AHB3_RDLEN_WIDTH    4

/* AHB3_WRLEN */
#define REG_AHB3_WRLEN          0x00050
#define REG_AHB3_WRLEN_MASK     0x00000f00
#define REG_AHB3_WRLEN_SHIFT    8
#define REG_AHB3_WRLEN_WIDTH    4

/* APREBIT */
#define REG_APREBIT          0x00050
#define REG_APREBIT_MASK     0x000f0000
#define REG_APREBIT_SHIFT    16
#define REG_APREBIT_WIDTH    4

/* AXI0_PRIORITY0_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY0_RELATIVE_PRIORITY          0x00050
#define REG_AXI0_PRIORITY0_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI0_PRIORITY0_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI0_PRIORITY0_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY1_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY1_RELATIVE_PRIORITY          0x00054
#define REG_AXI0_PRIORITY1_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI0_PRIORITY1_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI0_PRIORITY1_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY2_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY2_RELATIVE_PRIORITY          0x00054
#define REG_AXI0_PRIORITY2_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI0_PRIORITY2_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI0_PRIORITY2_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY3_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY3_RELATIVE_PRIORITY          0x00054
#define REG_AXI0_PRIORITY3_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI0_PRIORITY3_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI0_PRIORITY3_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY4_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY4_RELATIVE_PRIORITY          0x00054
#define REG_AXI0_PRIORITY4_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI0_PRIORITY4_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI0_PRIORITY4_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY5_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY5_RELATIVE_PRIORITY          0x00058
#define REG_AXI0_PRIORITY5_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI0_PRIORITY5_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI0_PRIORITY5_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY6_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY6_RELATIVE_PRIORITY          0x00058
#define REG_AXI0_PRIORITY6_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI0_PRIORITY6_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI0_PRIORITY6_RELATIVE_PRIORITY_WIDTH    4

/* AXI0_PRIORITY7_RELATIVE_PRIORITY */
#define REG_AXI0_PRIORITY7_RELATIVE_PRIORITY          0x00058
#define REG_AXI0_PRIORITY7_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI0_PRIORITY7_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI0_PRIORITY7_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY0_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY0_RELATIVE_PRIORITY          0x00058
#define REG_AXI1_PRIORITY0_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI1_PRIORITY0_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI1_PRIORITY0_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY1_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY1_RELATIVE_PRIORITY          0x0005C
#define REG_AXI1_PRIORITY1_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI1_PRIORITY1_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI1_PRIORITY1_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY2_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY2_RELATIVE_PRIORITY          0x0005C
#define REG_AXI1_PRIORITY2_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI1_PRIORITY2_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI1_PRIORITY2_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY3_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY3_RELATIVE_PRIORITY          0x0005C
#define REG_AXI1_PRIORITY3_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI1_PRIORITY3_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI1_PRIORITY3_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY4_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY4_RELATIVE_PRIORITY          0x0005C
#define REG_AXI1_PRIORITY4_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI1_PRIORITY4_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI1_PRIORITY4_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY5_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY5_RELATIVE_PRIORITY          0x00060
#define REG_AXI1_PRIORITY5_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI1_PRIORITY5_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI1_PRIORITY5_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY6_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY6_RELATIVE_PRIORITY          0x00060
#define REG_AXI1_PRIORITY6_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI1_PRIORITY6_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI1_PRIORITY6_RELATIVE_PRIORITY_WIDTH    4

/* AXI1_PRIORITY7_RELATIVE_PRIORITY */
#define REG_AXI1_PRIORITY7_RELATIVE_PRIORITY          0x00060
#define REG_AXI1_PRIORITY7_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI1_PRIORITY7_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI1_PRIORITY7_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY0_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY0_RELATIVE_PRIORITY          0x00060
#define REG_AXI2_PRIORITY0_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI2_PRIORITY0_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI2_PRIORITY0_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY1_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY1_RELATIVE_PRIORITY          0x00064
#define REG_AXI2_PRIORITY1_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI2_PRIORITY1_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI2_PRIORITY1_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY2_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY2_RELATIVE_PRIORITY          0x00064
#define REG_AXI2_PRIORITY2_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI2_PRIORITY2_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI2_PRIORITY2_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY3_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY3_RELATIVE_PRIORITY          0x00064
#define REG_AXI2_PRIORITY3_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI2_PRIORITY3_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI2_PRIORITY3_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY4_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY4_RELATIVE_PRIORITY          0x00064
#define REG_AXI2_PRIORITY4_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI2_PRIORITY4_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI2_PRIORITY4_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY5_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY5_RELATIVE_PRIORITY          0x00068
#define REG_AXI2_PRIORITY5_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI2_PRIORITY5_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI2_PRIORITY5_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY6_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY6_RELATIVE_PRIORITY          0x00068
#define REG_AXI2_PRIORITY6_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI2_PRIORITY6_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI2_PRIORITY6_RELATIVE_PRIORITY_WIDTH    4

/* AXI2_PRIORITY7_RELATIVE_PRIORITY */
#define REG_AXI2_PRIORITY7_RELATIVE_PRIORITY          0x00068
#define REG_AXI2_PRIORITY7_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI2_PRIORITY7_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI2_PRIORITY7_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY0_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY0_RELATIVE_PRIORITY          0x00068
#define REG_AXI3_PRIORITY0_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI3_PRIORITY0_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI3_PRIORITY0_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY1_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY1_RELATIVE_PRIORITY          0x0006C
#define REG_AXI3_PRIORITY1_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI3_PRIORITY1_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI3_PRIORITY1_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY2_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY2_RELATIVE_PRIORITY          0x0006C
#define REG_AXI3_PRIORITY2_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI3_PRIORITY2_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI3_PRIORITY2_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY3_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY3_RELATIVE_PRIORITY          0x0006C
#define REG_AXI3_PRIORITY3_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI3_PRIORITY3_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI3_PRIORITY3_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY4_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY4_RELATIVE_PRIORITY          0x0006C
#define REG_AXI3_PRIORITY4_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI3_PRIORITY4_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI3_PRIORITY4_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY5_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY5_RELATIVE_PRIORITY          0x00070
#define REG_AXI3_PRIORITY5_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI3_PRIORITY5_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI3_PRIORITY5_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY6_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY6_RELATIVE_PRIORITY          0x00070
#define REG_AXI3_PRIORITY6_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI3_PRIORITY6_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI3_PRIORITY6_RELATIVE_PRIORITY_WIDTH    4

/* AXI3_PRIORITY7_RELATIVE_PRIORITY */
#define REG_AXI3_PRIORITY7_RELATIVE_PRIORITY          0x00070
#define REG_AXI3_PRIORITY7_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI3_PRIORITY7_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI3_PRIORITY7_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY0_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY0_RELATIVE_PRIORITY          0x00070
#define REG_AXI4_PRIORITY0_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI4_PRIORITY0_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI4_PRIORITY0_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY1_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY1_RELATIVE_PRIORITY          0x00074
#define REG_AXI4_PRIORITY1_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI4_PRIORITY1_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI4_PRIORITY1_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY2_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY2_RELATIVE_PRIORITY          0x00074
#define REG_AXI4_PRIORITY2_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI4_PRIORITY2_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI4_PRIORITY2_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY3_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY3_RELATIVE_PRIORITY          0x00074
#define REG_AXI4_PRIORITY3_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI4_PRIORITY3_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI4_PRIORITY3_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY4_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY4_RELATIVE_PRIORITY          0x00074
#define REG_AXI4_PRIORITY4_RELATIVE_PRIORITY_MASK     0x0f000000
#define REG_AXI4_PRIORITY4_RELATIVE_PRIORITY_SHIFT    24
#define REG_AXI4_PRIORITY4_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY5_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY5_RELATIVE_PRIORITY          0x00078
#define REG_AXI4_PRIORITY5_RELATIVE_PRIORITY_MASK     0x0000000f
#define REG_AXI4_PRIORITY5_RELATIVE_PRIORITY_SHIFT    0
#define REG_AXI4_PRIORITY5_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY6_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY6_RELATIVE_PRIORITY          0x00078
#define REG_AXI4_PRIORITY6_RELATIVE_PRIORITY_MASK     0x00000f00
#define REG_AXI4_PRIORITY6_RELATIVE_PRIORITY_SHIFT    8
#define REG_AXI4_PRIORITY6_RELATIVE_PRIORITY_WIDTH    4

/* AXI4_PRIORITY7_RELATIVE_PRIORITY */
#define REG_AXI4_PRIORITY7_RELATIVE_PRIORITY          0x00078
#define REG_AXI4_PRIORITY7_RELATIVE_PRIORITY_MASK     0x000f0000
#define REG_AXI4_PRIORITY7_RELATIVE_PRIORITY_SHIFT    16
#define REG_AXI4_PRIORITY7_RELATIVE_PRIORITY_WIDTH    4

/* CASLAT_LIN */
#define REG_CASLAT_LIN          0x00078
#define REG_CASLAT_LIN_MASK     0x0f000000
#define REG_CASLAT_LIN_SHIFT    24
#define REG_CASLAT_LIN_WIDTH    4

/* CASLAT_LIN_GATE */
#define REG_CASLAT_LIN_GATE          0x0007C
#define REG_CASLAT_LIN_GATE_MASK     0x0000000f
#define REG_CASLAT_LIN_GATE_SHIFT    0
#define REG_CASLAT_LIN_GATE_WIDTH    4

/* DRAM_CLASS */
#define REG_DRAM_CLASS          0x0007C
#define REG_DRAM_CLASS_MASK     0x00000f00
#define REG_DRAM_CLASS_SHIFT    8
#define REG_DRAM_CLASS_WIDTH    4

/* INITAREF */
#define REG_INITAREF          0x0007C
#define REG_INITAREF_MASK     0x000f0000
#define REG_INITAREF_SHIFT    16
#define REG_INITAREF_WIDTH    4

/* MAX_COL_REG */
#define REG_MAX_COL_REG          0x0007C
#define REG_MAX_COL_REG_MASK     0x0f000000
#define REG_MAX_COL_REG_SHIFT    24
#define REG_MAX_COL_REG_WIDTH    4

/* MAX_ROW_REG */
#define REG_MAX_ROW_REG          0x00080
#define REG_MAX_ROW_REG_MASK     0x0000000f
#define REG_MAX_ROW_REG_SHIFT    0
#define REG_MAX_ROW_REG_WIDTH    4

/* PORT_CMD_ERROR_TYPE */
#define REG_PORT_CMD_ERROR_TYPE          0x00080
#define REG_PORT_CMD_ERROR_TYPE_MASK     0x00000f00
#define REG_PORT_CMD_ERROR_TYPE_SHIFT    8
#define REG_PORT_CMD_ERROR_TYPE_WIDTH    4

/* RDLAT_ADJ */
#define REG_RDLAT_ADJ          0x00080
#define REG_RDLAT_ADJ_MASK     0x000f0000
#define REG_RDLAT_ADJ_SHIFT    16
#define REG_RDLAT_ADJ_WIDTH    4

/* TDFI_CTRLUPD_MIN */
#define REG_TDFI_CTRLUPD_MIN          0x00080
#define REG_TDFI_CTRLUPD_MIN_MASK     0x0f000000
#define REG_TDFI_CTRLUPD_MIN_SHIFT    24
#define REG_TDFI_CTRLUPD_MIN_WIDTH    4

/* TDFI_PHY_RDLAT */
#define REG_TDFI_PHY_RDLAT          0x00084
#define REG_TDFI_PHY_RDLAT_MASK     0x0000000f
#define REG_TDFI_PHY_RDLAT_SHIFT    0
#define REG_TDFI_PHY_RDLAT_WIDTH    4

/* TDFI_PHY_WRLAT */
#define REG_TDFI_PHY_WRLAT          0x00084
#define REG_TDFI_PHY_WRLAT_MASK     0x00000f00
#define REG_TDFI_PHY_WRLAT_SHIFT    8
#define REG_TDFI_PHY_WRLAT_WIDTH    4

/* TDFI_PHY_WRLAT_BASE */
#define REG_TDFI_PHY_WRLAT_BASE          0x00084
#define REG_TDFI_PHY_WRLAT_BASE_MASK     0x000f0000
#define REG_TDFI_PHY_WRLAT_BASE_SHIFT    16
#define REG_TDFI_PHY_WRLAT_BASE_WIDTH    4

/* TDFI_RDDATA_EN */
#define REG_TDFI_RDDATA_EN          0x00084
#define REG_TDFI_RDDATA_EN_MASK     0x0f000000
#define REG_TDFI_RDDATA_EN_SHIFT    24
#define REG_TDFI_RDDATA_EN_WIDTH    4

/* TDFI_RDDATA_EN_BASE */
#define REG_TDFI_RDDATA_EN_BASE          0x00088
#define REG_TDFI_RDDATA_EN_BASE_MASK     0x0000000f
#define REG_TDFI_RDDATA_EN_BASE_SHIFT    0
#define REG_TDFI_RDDATA_EN_BASE_WIDTH    4

/* TRP */
#define REG_TRP          0x00088
#define REG_TRP_MASK     0x00000f00
#define REG_TRP_SHIFT    8
#define REG_TRP_WIDTH    4

/* TRP_AB */
#define REG_TRP_AB          0x00088
#define REG_TRP_AB_MASK     0x000f0000
#define REG_TRP_AB_SHIFT    16
#define REG_TRP_AB_WIDTH    4

/* TWTR */
#define REG_TWTR          0x00088
#define REG_TWTR_MASK     0x0f000000
#define REG_TWTR_SHIFT    24
#define REG_TWTR_WIDTH    4

/* WRLAT */
#define REG_WRLAT          0x0008C
#define REG_WRLAT_MASK     0x0000000f
#define REG_WRLAT_SHIFT    0
#define REG_WRLAT_WIDTH    4

/* WRLAT_ADJ */
#define REG_WRLAT_ADJ          0x0008C
#define REG_WRLAT_ADJ_MASK     0x00000f00
#define REG_WRLAT_ADJ_SHIFT    8
#define REG_WRLAT_ADJ_WIDTH    4

/* WRR_PARAM_VALUE_ERR */
#define REG_WRR_PARAM_VALUE_ERR          0x0008C
#define REG_WRR_PARAM_VALUE_ERR_MASK     0x000f0000
#define REG_WRR_PARAM_VALUE_ERR_SHIFT    16
#define REG_WRR_PARAM_VALUE_ERR_WIDTH    4

/* AGE_COUNT */
#define REG_AGE_COUNT          0x0008C
#define REG_AGE_COUNT_MASK     0x1f000000
#define REG_AGE_COUNT_SHIFT    24
#define REG_AGE_COUNT_WIDTH    5

/* COMMAND_AGE_COUNT */
#define REG_COMMAND_AGE_COUNT          0x00090
#define REG_COMMAND_AGE_COUNT_MASK     0x0000001f
#define REG_COMMAND_AGE_COUNT_SHIFT    0
#define REG_COMMAND_AGE_COUNT_WIDTH    5

/* OCD_ADJUST_PDN_CS_0 */
#define REG_OCD_ADJUST_PDN_CS_0          0x00090
#define REG_OCD_ADJUST_PDN_CS_0_MASK     0x00001f00
#define REG_OCD_ADJUST_PDN_CS_0_SHIFT    8
#define REG_OCD_ADJUST_PDN_CS_0_WIDTH    5

/* OCD_ADJUST_PUP_CS_0 */
#define REG_OCD_ADJUST_PUP_CS_0          0x00090
#define REG_OCD_ADJUST_PUP_CS_0_MASK     0x001f0000
#define REG_OCD_ADJUST_PUP_CS_0_SHIFT    16
#define REG_OCD_ADJUST_PUP_CS_0_WIDTH    5

/* TCCD */
#define REG_TCCD          0x00090
#define REG_TCCD_MASK     0x1f000000
#define REG_TCCD_SHIFT    24
#define REG_TCCD_WIDTH    5

/* TCKESR */
#define REG_TCKESR          0x00094
#define REG_TCKESR_MASK     0x0000001f
#define REG_TCKESR_SHIFT    0
#define REG_TCKESR_WIDTH    5

/* TDAL */
#define REG_TDAL          0x00094
#define REG_TDAL_MASK     0x00001f00
#define REG_TDAL_SHIFT    8
#define REG_TDAL_WIDTH    5

/* TMRD */
#define REG_TMRD          0x00094
#define REG_TMRD_MASK     0x001f0000
#define REG_TMRD_SHIFT    16
#define REG_TMRD_WIDTH    5

/* TWR_INT */
#define REG_TWR_INT          0x00094
#define REG_TWR_INT_MASK     0x1f000000
#define REG_TWR_INT_SHIFT    24
#define REG_TWR_INT_WIDTH    5

/* OUT_OF_RANGE_LENGTH */
#define REG_OUT_OF_RANGE_LENGTH          0x00098
#define REG_OUT_OF_RANGE_LENGTH_MASK     0x0000003f
#define REG_OUT_OF_RANGE_LENGTH_SHIFT    0
#define REG_OUT_OF_RANGE_LENGTH_WIDTH    6

/* OUT_OF_RANGE_TYPE */
/* Cleared by read */
#define REG_OUT_OF_RANGE_TYPE          0x00098
#define REG_OUT_OF_RANGE_TYPE_MASK     0x00003f00
#define REG_OUT_OF_RANGE_TYPE_SHIFT    8
#define REG_OUT_OF_RANGE_TYPE_WIDTH    6

/* TRC */
#define REG_TRC          0x00098
#define REG_TRC_MASK     0x003f0000
#define REG_TRC_SHIFT    16
#define REG_TRC_WIDTH    6

/* OUT_OF_RANGE_SOURCE_ID */
#define REG_OUT_OF_RANGE_SOURCE_ID          0x00098
#define REG_OUT_OF_RANGE_SOURCE_ID_MASK     0x3f000000
#define REG_OUT_OF_RANGE_SOURCE_ID_SHIFT    24
#define REG_OUT_OF_RANGE_SOURCE_ID_WIDTH    6

/* PORT_CMD_ERROR_ID */
#define REG_PORT_CMD_ERROR_ID          0x0009C
#define REG_PORT_CMD_ERROR_ID_MASK     0x0000007f
#define REG_PORT_CMD_ERROR_ID_SHIFT    0
#define REG_PORT_CMD_ERROR_ID_WIDTH    7

/* PORT_DATA_ERROR_ID */
#define REG_PORT_DATA_ERROR_ID          0x0009C
#define REG_PORT_DATA_ERROR_ID_MASK     0x00007f00
#define REG_PORT_DATA_ERROR_ID_SHIFT    8
#define REG_PORT_DATA_ERROR_ID_WIDTH    7

/* DLL_LOCK */
#define REG_DLL_LOCK          0x0009C
#define REG_DLL_LOCK_MASK     0x007f0000
#define REG_DLL_LOCK_SHIFT    16
#define REG_DLL_LOCK_WIDTH    7

/* DLL_RST_ADJ_DLY */
#define REG_DLL_RST_ADJ_DLY          0x0009C
#define REG_DLL_RST_ADJ_DLY_MASK     0x7f000000
#define REG_DLL_RST_ADJ_DLY_SHIFT    24
#define REG_DLL_RST_ADJ_DLY_WIDTH    7

/* TMOD */
#define REG_TMOD          0x000A0
#define REG_TMOD_MASK     0x000000ff
#define REG_TMOD_SHIFT    0
#define REG_TMOD_WIDTH    8

/* TRAS_MIN */
#define REG_TRAS_MIN          0x000A0
#define REG_TRAS_MIN_MASK     0x0000ff00
#define REG_TRAS_MIN_SHIFT    8
#define REG_TRAS_MIN_WIDTH    8

/* TRCD_INT */
#define REG_TRCD_INT          0x000A0
#define REG_TRCD_INT_MASK     0x00ff0000
#define REG_TRCD_INT_SHIFT    16
#define REG_TRCD_INT_WIDTH    8

/* TRFC */
#define REG_TRFC          0x000A0
#define REG_TRFC_MASK     0xff000000
#define REG_TRFC_SHIFT    24
#define REG_TRFC_WIDTH    8

/* INT_ACK */
#define REG_INT_ACK          0x000A4
#define REG_INT_ACK_MASK     0x000001ff
#define REG_INT_ACK_SHIFT    0
#define REG_INT_ACK_WIDTH    9

/* AXI0_PRIORITY_RELAX */
#define REG_AXI0_PRIORITY_RELAX          0x000A4
#define REG_AXI0_PRIORITY_RELAX_MASK     0x01ff0000
#define REG_AXI0_PRIORITY_RELAX_SHIFT    16
#define REG_AXI0_PRIORITY_RELAX_WIDTH    9

/* AXI1_PRIORITY_RELAX */
#define REG_AXI1_PRIORITY_RELAX          0x000A8
#define REG_AXI1_PRIORITY_RELAX_MASK     0x000003ff
#define REG_AXI1_PRIORITY_RELAX_SHIFT    0
#define REG_AXI1_PRIORITY_RELAX_WIDTH    10

/* AXI2_PRIORITY_RELAX */
#define REG_AXI2_PRIORITY_RELAX          0x000A8
#define REG_AXI2_PRIORITY_RELAX_MASK     0x01ff0000
#define REG_AXI2_PRIORITY_RELAX_SHIFT    16
#define REG_AXI2_PRIORITY_RELAX_WIDTH    9

/* AXI3_PRIORITY_RELAX */
#define REG_AXI3_PRIORITY_RELAX          0x000AC
#define REG_AXI3_PRIORITY_RELAX_MASK     0x000003ff
#define REG_AXI3_PRIORITY_RELAX_SHIFT    0
#define REG_AXI3_PRIORITY_RELAX_WIDTH    10

/* AXI4_PRIORITY_RELAX */
#define REG_AXI4_PRIORITY_RELAX          0x000AC
#define REG_AXI4_PRIORITY_RELAX_MASK     0x01ff0000
#define REG_AXI4_PRIORITY_RELAX_SHIFT    16
#define REG_AXI4_PRIORITY_RELAX_WIDTH    9

/* INT_MASK */
#define REG_INT_MASK          0x000B0
#define REG_INT_MASK_MASK     0x000003ff
#define REG_INT_MASK_SHIFT    0
#define REG_INT_MASK_WIDTH    10

/* INT_STATUS */
#define REG_INT_STATUS          0x000B0
#define REG_INT_STATUS_MASK     0x01ff0000
#define REG_INT_STATUS_SHIFT    16
#define REG_INT_STATUS_WIDTH    9

/* MR0_DATA_0 */
#define REG_MR0_DATA_0          0x000B4
#define REG_MR0_DATA_0_MASK     0x00003fff
#define REG_MR0_DATA_0_SHIFT    0
#define REG_MR0_DATA_0_WIDTH    14

/* MR1_DATA_0 */
#define REG_MR1_DATA_0          0x000B4
#define REG_MR1_DATA_0_MASK     0x3fff0000
#define REG_MR1_DATA_0_SHIFT    16
#define REG_MR1_DATA_0_WIDTH    14

/* MR2_DATA_0 */
#define REG_MR2_DATA_0          0x000B8
#define REG_MR2_DATA_0_MASK     0x00003fff
#define REG_MR2_DATA_0_SHIFT    0
#define REG_MR2_DATA_0_WIDTH    14

/* MR3_DATA_0 */
#define REG_MR3_DATA_0          0x000B8
#define REG_MR3_DATA_0_MASK     0x3fff0000
#define REG_MR3_DATA_0_SHIFT    16
#define REG_MR3_DATA_0_WIDTH    14

/* TDFI_CTRLUPD_MAX */
#define REG_TDFI_CTRLUPD_MAX          0x000BC
#define REG_TDFI_CTRLUPD_MAX_MASK     0x00003fff
#define REG_TDFI_CTRLUPD_MAX_SHIFT    0
#define REG_TDFI_CTRLUPD_MAX_WIDTH    14

/* TDFI_PHYUPD_RESP */
#define REG_TDFI_PHYUPD_RESP          0x000BC
#define REG_TDFI_PHYUPD_RESP_MASK     0x3fff0000
#define REG_TDFI_PHYUPD_RESP_SHIFT    16
#define REG_TDFI_PHYUPD_RESP_WIDTH    14

/* TDFI_PHYUPD_TYPE0 */
#define REG_TDFI_PHYUPD_TYPE0          0x000C0
#define REG_TDFI_PHYUPD_TYPE0_MASK     0x00003fff
#define REG_TDFI_PHYUPD_TYPE0_SHIFT    0
#define REG_TDFI_PHYUPD_TYPE0_WIDTH    14

/* TDFI_PHYUPD_TYPE1 */
/* Cleared by read */
#define REG_TDFI_PHYUPD_TYPE1          0x000C0
#define REG_TDFI_PHYUPD_TYPE1_MASK     0x3fff0000
#define REG_TDFI_PHYUPD_TYPE1_SHIFT    16
#define REG_TDFI_PHYUPD_TYPE1_WIDTH    14

/* TDFI_PHYUPD_TYPE2 */
/* Cleared by read */
#define REG_TDFI_PHYUPD_TYPE2          0x000C4
#define REG_TDFI_PHYUPD_TYPE2_MASK     0x00003fff
#define REG_TDFI_PHYUPD_TYPE2_SHIFT    0
#define REG_TDFI_PHYUPD_TYPE2_WIDTH    14

/* TDFI_PHYUPD_TYPE3 */
#define REG_TDFI_PHYUPD_TYPE3          0x000C4
#define REG_TDFI_PHYUPD_TYPE3_MASK     0x3fff0000
#define REG_TDFI_PHYUPD_TYPE3_SHIFT    16
#define REG_TDFI_PHYUPD_TYPE3_WIDTH    14

/* TREF */
#define REG_TREF          0x000C8
#define REG_TREF_MASK     0x00003fff
#define REG_TREF_SHIFT    0
#define REG_TREF_WIDTH    14

/* AXI0_EN_SIZE_LT_WIDTH_INSTR */
#define REG_AXI0_EN_SIZE_LT_WIDTH_INSTR          0x000C8
#define REG_AXI0_EN_SIZE_LT_WIDTH_INSTR_MASK     0xffff0000
#define REG_AXI0_EN_SIZE_LT_WIDTH_INSTR_SHIFT    16
#define REG_AXI0_EN_SIZE_LT_WIDTH_INSTR_WIDTH    16

/* AXI1_EN_SIZE_LT_WIDTH_INSTR */
#define REG_AXI1_EN_SIZE_LT_WIDTH_INSTR          0x000CC
#define REG_AXI1_EN_SIZE_LT_WIDTH_INSTR_MASK     0x0000ffff
#define REG_AXI1_EN_SIZE_LT_WIDTH_INSTR_SHIFT    0
#define REG_AXI1_EN_SIZE_LT_WIDTH_INSTR_WIDTH    16

/* AXI2_EN_SIZE_LT_WIDTH_INSTR */
#define REG_AXI2_EN_SIZE_LT_WIDTH_INSTR          0x000CC
#define REG_AXI2_EN_SIZE_LT_WIDTH_INSTR_MASK     0xffff0000
#define REG_AXI2_EN_SIZE_LT_WIDTH_INSTR_SHIFT    16
#define REG_AXI2_EN_SIZE_LT_WIDTH_INSTR_WIDTH    16

/* AXI3_EN_SIZE_LT_WIDTH_INSTR */
#define REG_AXI3_EN_SIZE_LT_WIDTH_INSTR          0x000D0
#define REG_AXI3_EN_SIZE_LT_WIDTH_INSTR_MASK     0x0000ffff
#define REG_AXI3_EN_SIZE_LT_WIDTH_INSTR_SHIFT    0
#define REG_AXI3_EN_SIZE_LT_WIDTH_INSTR_WIDTH    16

/* AXI4_EN_SIZE_LT_WIDTH_INSTR */
#define REG_AXI4_EN_SIZE_LT_WIDTH_INSTR          0x000D0
#define REG_AXI4_EN_SIZE_LT_WIDTH_INSTR_MASK     0xffff0000
#define REG_AXI4_EN_SIZE_LT_WIDTH_INSTR_SHIFT    16
#define REG_AXI4_EN_SIZE_LT_WIDTH_INSTR_WIDTH    16

/* DLL_RST_DELAY */
#define REG_DLL_RST_DELAY          0x000D4
#define REG_DLL_RST_DELAY_MASK     0x0000ffff
#define REG_DLL_RST_DELAY_SHIFT    0
#define REG_DLL_RST_DELAY_WIDTH    16

/* TCPD */
#define REG_TCPD          0x000D4
#define REG_TCPD_MASK     0xffff0000
#define REG_TCPD_SHIFT    16
#define REG_TCPD_WIDTH    16

/* TDLL */
#define REG_TDLL          0x000D8
#define REG_TDLL_MASK     0x0000ffff
#define REG_TDLL_SHIFT    0
#define REG_TDLL_WIDTH    16

/* TPDEX */
#define REG_TPDEX          0x000D8
#define REG_TPDEX_MASK     0xffff0000
#define REG_TPDEX_SHIFT    16
#define REG_TPDEX_WIDTH    16

/* TRAS_MAX */
#define REG_TRAS_MAX          0x000DC
#define REG_TRAS_MAX_MASK     0x0000ffff
#define REG_TRAS_MAX_SHIFT    0
#define REG_TRAS_MAX_WIDTH    16

/* TXSNR */
#define REG_TXSNR          0x000DC
#define REG_TXSNR_MASK     0xffff0000
#define REG_TXSNR_SHIFT    16
#define REG_TXSNR_WIDTH    16

/* TXSR */
#define REG_TXSR          0x000E0
#define REG_TXSR_MASK     0x0000ffff
#define REG_TXSR_SHIFT    0
#define REG_TXSR_WIDTH    16

/* VERSION */
#define REG_VERSION          0x000E0
#define REG_VERSION_MASK     0xffff0000
#define REG_VERSION_SHIFT    16
#define REG_VERSION_WIDTH    16

/* TINIT */
/* 1- clean rx_fifo and tx_fifo */
#define REG_TINIT          0x000E4
#define REG_TINIT_MASK     0x00ffffff
#define REG_TINIT_SHIFT    0
#define REG_TINIT_WIDTH    24

/* OUT_OF_RANGE_ADDR */
/* 1- generate local int on dma completion/error */
#define REG_OUT_OF_RANGE_ADDR          0x000E8
#define REG_OUT_OF_RANGE_ADDR_MASK     0x0fffffff
#define REG_OUT_OF_RANGE_ADDR_SHIFT    0
#define REG_OUT_OF_RANGE_ADDR_WIDTH    28

/* PORT_CMD_ERROR_ADDR */
/* 1- generate host int on dma completion/error */
#define REG_PORT_CMD_ERROR_ADDR          0x000EC
#define REG_PORT_CMD_ERROR_ADDR_MASK     0x0fffffff
#define REG_PORT_CMD_ERROR_ADDR_SHIFT    0
#define REG_PORT_CMD_ERROR_ADDR_WIDTH    28

/* DFT_CTRL_REG */
/* start shared ram addr */
#define REG_DFT_CTRL_REG          0x000F0
#define REG_DFT_CTRL_REG_MASK     0xffffffff
#define REG_DFT_CTRL_REG_SHIFT    0
#define REG_DFT_CTRL_REG_WIDTH    32

/* DLL_CTRL_REG_0_0 */
#define REG_DLL_CTRL_REG_0_0          0x000F4
#define REG_DLL_CTRL_REG_0_0_MASK     0xffffffff
#define REG_DLL_CTRL_REG_0_0_SHIFT    0
#define REG_DLL_CTRL_REG_0_0_WIDTH    32

/* DLL_CTRL_REG_0_1 */
#define REG_DLL_CTRL_REG_0_1          0x000F8
#define REG_DLL_CTRL_REG_0_1_MASK     0xffffffff
#define REG_DLL_CTRL_REG_0_1_SHIFT    0
#define REG_DLL_CTRL_REG_0_1_WIDTH    32

/* DLL_CTRL_REG_1_0 */
#define REG_DLL_CTRL_REG_1_0          0x000FC
#define REG_DLL_CTRL_REG_1_0_MASK     0xffffffff
#define REG_DLL_CTRL_REG_1_0_SHIFT    0
#define REG_DLL_CTRL_REG_1_0_WIDTH    32

/* DLL_CTRL_REG_1_1 */
/* start shared ram addr */
#define REG_DLL_CTRL_REG_1_1          0x00100
#define REG_DLL_CTRL_REG_1_1_MASK     0xffffffff
#define REG_DLL_CTRL_REG_1_1_SHIFT    0
#define REG_DLL_CTRL_REG_1_1_WIDTH    32

/* DLL_OBS_REG_0_0 */
#define REG_DLL_OBS_REG_0_0          0x00104
#define REG_DLL_OBS_REG_0_0_MASK     0xffffffff
#define REG_DLL_OBS_REG_0_0_SHIFT    0
#define REG_DLL_OBS_REG_0_0_WIDTH    32

/* DLL_OBS_REG_0_1 */
#define REG_DLL_OBS_REG_0_1          0x00108
#define REG_DLL_OBS_REG_0_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_0_1_SHIFT    0
#define REG_DLL_OBS_REG_0_1_WIDTH    32

/* PAD_CTRL_REG_0 */
#define REG_PAD_CTRL_REG_0          0x0010C
#define REG_PAD_CTRL_REG_0_MASK     0xffffffff
#define REG_PAD_CTRL_REG_0_SHIFT    0
#define REG_PAD_CTRL_REG_0_WIDTH    32

/* PHY_CTRL_REG_0_0 */
#define REG_PHY_CTRL_REG_0_0          0x00110
#define REG_PHY_CTRL_REG_0_0_MASK     0xffffffff
#define REG_PHY_CTRL_REG_0_0_SHIFT    0
#define REG_PHY_CTRL_REG_0_0_WIDTH    32

/* PHY_CTRL_REG_0_1 */
#define REG_PHY_CTRL_REG_0_1          0x00114
#define REG_PHY_CTRL_REG_0_1_MASK     0xffffffff
#define REG_PHY_CTRL_REG_0_1_SHIFT    0
#define REG_PHY_CTRL_REG_0_1_WIDTH    32

/* PHY_CTRL_REG_1_0 */
#define REG_PHY_CTRL_REG_1_0          0x00118
#define REG_PHY_CTRL_REG_1_0_MASK     0xffffffff
#define REG_PHY_CTRL_REG_1_0_SHIFT    0
#define REG_PHY_CTRL_REG_1_0_WIDTH    32

/* PHY_CTRL_REG_1_1 */
#define REG_PHY_CTRL_REG_1_1          0x0011C
#define REG_PHY_CTRL_REG_1_1_MASK     0xffffffff
#define REG_PHY_CTRL_REG_1_1_SHIFT    0
#define REG_PHY_CTRL_REG_1_1_WIDTH    32

/* PHY_CTRL_REG_2 */
#define REG_PHY_CTRL_REG_2          0x00120
#define REG_PHY_CTRL_REG_2_MASK     0xffffffff
#define REG_PHY_CTRL_REG_2_SHIFT    0
#define REG_PHY_CTRL_REG_2_WIDTH    32

/* PHY_OBS_REG_0_0 */
#define REG_PHY_OBS_REG_0_0          0x00124
#define REG_PHY_OBS_REG_0_0_MASK     0xffffffff
#define REG_PHY_OBS_REG_0_0_SHIFT    0
#define REG_PHY_OBS_REG_0_0_WIDTH    32

/* PHY_OBS_REG_0_1 */
#define REG_PHY_OBS_REG_0_1          0x00128
#define REG_PHY_OBS_REG_0_1_MASK     0xffffffff
#define REG_PHY_OBS_REG_0_1_SHIFT    0
#define REG_PHY_OBS_REG_0_1_WIDTH    32

/* DLL_OBS_REG_1_0_0  */
#define REG_DLL_OBS_REG_1_0_0           0x0012C
#define REG_DLL_OBS_REG_1_0_0 _MASK     0xffffffff
#define REG_DLL_OBS_REG_1_0_0 _SHIFT    0
#define REG_DLL_OBS_REG_1_0_0 _WIDTH    32

/* DLL_OBS_REG_1_0_1 */
#define REG_DLL_OBS_REG_1_0_1          0x00130
#define REG_DLL_OBS_REG_1_0_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_0_1_SHIFT    0
#define REG_DLL_OBS_REG_1_0_1_WIDTH    32

/* DLL_OBS_REG_1_0_2 */
#define REG_DLL_OBS_REG_1_0_2          0x00134
#define REG_DLL_OBS_REG_1_0_2_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_0_2_SHIFT    0
#define REG_DLL_OBS_REG_1_0_2_WIDTH    32

/* DLL_OBS_REG_1_0_3 */
#define REG_DLL_OBS_REG_1_0_3          0x00138
#define REG_DLL_OBS_REG_1_0_3_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_0_3_SHIFT    0
#define REG_DLL_OBS_REG_1_0_3_WIDTH    32

/* DLL_OBS_REG_1_0_4  */
#define REG_DLL_OBS_REG_1_0_4           0x0013C
#define REG_DLL_OBS_REG_1_0_4 _MASK     0xffffffff
#define REG_DLL_OBS_REG_1_0_4 _SHIFT    0
#define REG_DLL_OBS_REG_1_0_4 _WIDTH    32

/* DLL_OBS_REG_1_0_5 */
#define REG_DLL_OBS_REG_1_0_5          0x00140
#define REG_DLL_OBS_REG_1_0_5_MASK     0x000fffff
#define REG_DLL_OBS_REG_1_0_5_SHIFT    0
#define REG_DLL_OBS_REG_1_0_5_WIDTH    20

/* DLL_OBS_REG_1_1_0 */
#define REG_DLL_OBS_REG_1_1_0          0x00144
#define REG_DLL_OBS_REG_1_1_0_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_1_0_SHIFT    0
#define REG_DLL_OBS_REG_1_1_0_WIDTH    32

/* DLL_OBS_REG_1_1_1 */
#define REG_DLL_OBS_REG_1_1_1          0x00148
#define REG_DLL_OBS_REG_1_1_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_1_1_SHIFT    0
#define REG_DLL_OBS_REG_1_1_1_WIDTH    32

/* DLL_OBS_REG_1_1_2 */
#define REG_DLL_OBS_REG_1_1_2          0x0014C
#define REG_DLL_OBS_REG_1_1_2_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_1_2_SHIFT    0
#define REG_DLL_OBS_REG_1_1_2_WIDTH    32

/* DLL_OBS_REG_1_1_3  */
#define REG_DLL_OBS_REG_1_1_3           0x00150
#define REG_DLL_OBS_REG_1_1_3 _MASK     0xffffffff
#define REG_DLL_OBS_REG_1_1_3 _SHIFT    0
#define REG_DLL_OBS_REG_1_1_3 _WIDTH    32

/* DLL_OBS_REG_1_1_4 */
#define REG_DLL_OBS_REG_1_1_4          0x00154
#define REG_DLL_OBS_REG_1_1_4_MASK     0xffffffff
#define REG_DLL_OBS_REG_1_1_4_SHIFT    0
#define REG_DLL_OBS_REG_1_1_4_WIDTH    32

/* DLL_OBS_REG_1_1_5 */
#define REG_DLL_OBS_REG_1_1_5          0x00158
#define REG_DLL_OBS_REG_1_1_5_MASK     0x000fffff
#define REG_DLL_OBS_REG_1_1_5_SHIFT    0
#define REG_DLL_OBS_REG_1_1_5_WIDTH    20

/* DLL_OBS_REG_2_0_0 */
#define REG_DLL_OBS_REG_2_0_0          0x0015C
#define REG_DLL_OBS_REG_2_0_0_MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_0_SHIFT    0
#define REG_DLL_OBS_REG_2_0_0_WIDTH    32

/* DLL_OBS_REG_2_0_1 */
#define REG_DLL_OBS_REG_2_0_1          0x00160
#define REG_DLL_OBS_REG_2_0_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_1_SHIFT    0
#define REG_DLL_OBS_REG_2_0_1_WIDTH    32

/* DLL_OBS_REG_2_0_2 */
#define REG_DLL_OBS_REG_2_0_2          0x00164
#define REG_DLL_OBS_REG_2_0_2_MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_2_SHIFT    0
#define REG_DLL_OBS_REG_2_0_2_WIDTH    32

/* DLL_OBS_REG_2_0_3 */
#define REG_DLL_OBS_REG_2_0_3          0x00168
#define REG_DLL_OBS_REG_2_0_3_MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_3_SHIFT    0
#define REG_DLL_OBS_REG_2_0_3_WIDTH    32

/* DLL_OBS_REG_2_0_4  */
#define REG_DLL_OBS_REG_2_0_4           0x0016C
#define REG_DLL_OBS_REG_2_0_4 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_4 _SHIFT    0
#define REG_DLL_OBS_REG_2_0_4 _WIDTH    32

/* DLL_OBS_REG_2_0_5  */
#define REG_DLL_OBS_REG_2_0_5           0x00170
#define REG_DLL_OBS_REG_2_0_5 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_0_5 _SHIFT    0
#define REG_DLL_OBS_REG_2_0_5 _WIDTH    32

/* DLL_OBS_REG_2_1_0  */
#define REG_DLL_OBS_REG_2_1_0           0x00174
#define REG_DLL_OBS_REG_2_1_0 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_1_0 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_0 _WIDTH    32

/* DLL_OBS_REG_2_1_1  */
#define REG_DLL_OBS_REG_2_1_1           0x00178
#define REG_DLL_OBS_REG_2_1_1 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_1_1 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_1 _WIDTH    32

/* DLL_OBS_REG_2_1_2  */
#define REG_DLL_OBS_REG_2_1_2           0x0017C
#define REG_DLL_OBS_REG_2_1_2 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_1_2 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_2 _WIDTH    32

/* DLL_OBS_REG_2_1_3  */
#define REG_DLL_OBS_REG_2_1_3           0x00180
#define REG_DLL_OBS_REG_2_1_3 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_1_3 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_3 _WIDTH    32

/* DLL_OBS_REG_2_1_4  */
#define REG_DLL_OBS_REG_2_1_4           0x00184
#define REG_DLL_OBS_REG_2_1_4 _MASK     0xffffffff
#define REG_DLL_OBS_REG_2_1_4 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_4 _WIDTH    32

/* DLL_OBS_REG_2_1_5  */
#define REG_DLL_OBS_REG_2_1_5           0x00188
#define REG_DLL_OBS_REG_2_1_5 _MASK     0x000fffff
#define REG_DLL_OBS_REG_2_1_5 _SHIFT    0
#define REG_DLL_OBS_REG_2_1_5 _WIDTH    20

/* DLL_OBS_REG_3_0_0  */
#define REG_DLL_OBS_REG_3_0_0           0x0018C
#define REG_DLL_OBS_REG_3_0_0 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_0_0 _SHIFT    0
#define REG_DLL_OBS_REG_3_0_0 _WIDTH    32

/* DLL_OBS_REG_3_0_1 */
#define REG_DLL_OBS_REG_3_0_1          0x00190
#define REG_DLL_OBS_REG_3_0_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_3_0_1_SHIFT    0
#define REG_DLL_OBS_REG_3_0_1_WIDTH    32

/* DLL_OBS_REG_3_0_2 */
#define REG_DLL_OBS_REG_3_0_2          0x00194
#define REG_DLL_OBS_REG_3_0_2_MASK     0xffffffff
#define REG_DLL_OBS_REG_3_0_2_SHIFT    0
#define REG_DLL_OBS_REG_3_0_2_WIDTH    32

/* DLL_OBS_REG_3_0_3 */
#define REG_DLL_OBS_REG_3_0_3          0x00198
#define REG_DLL_OBS_REG_3_0_3_MASK     0xffffffff
#define REG_DLL_OBS_REG_3_0_3_SHIFT    0
#define REG_DLL_OBS_REG_3_0_3_WIDTH    32

/* DLL_OBS_REG_3_0_4  */
#define REG_DLL_OBS_REG_3_0_4           0x0019C
#define REG_DLL_OBS_REG_3_0_4 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_0_4 _SHIFT    0
#define REG_DLL_OBS_REG_3_0_4 _WIDTH    32

/* DLL_OBS_REG_3_0_5  */
#define REG_DLL_OBS_REG_3_0_5           0x001A0
#define REG_DLL_OBS_REG_3_0_5 _MASK     0x000fffff
#define REG_DLL_OBS_REG_3_0_5 _SHIFT    0
#define REG_DLL_OBS_REG_3_0_5 _WIDTH    20

/* DLL_OBS_REG_3_1_0  */
#define REG_DLL_OBS_REG_3_1_0           0x001A4
#define REG_DLL_OBS_REG_3_1_0 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_1_0 _SHIFT    0
#define REG_DLL_OBS_REG_3_1_0 _WIDTH    32

/* DLL_OBS_REG_3_1_1 */
#define REG_DLL_OBS_REG_3_1_1          0x001A8
#define REG_DLL_OBS_REG_3_1_1_MASK     0xffffffff
#define REG_DLL_OBS_REG_3_1_1_SHIFT    0
#define REG_DLL_OBS_REG_3_1_1_WIDTH    32

/* DLL_OBS_REG_3_1_2  */
#define REG_DLL_OBS_REG_3_1_2           0x001AC
#define REG_DLL_OBS_REG_3_1_2 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_1_2 _SHIFT    0
#define REG_DLL_OBS_REG_3_1_2 _WIDTH    32

/* DLL_OBS_REG_3_1_3  */
#define REG_DLL_OBS_REG_3_1_3           0x001B0
#define REG_DLL_OBS_REG_3_1_3 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_1_3 _SHIFT    0
#define REG_DLL_OBS_REG_3_1_3 _WIDTH    32

/* DLL_OBS_REG_3_1_4  */
#define REG_DLL_OBS_REG_3_1_4           0x001B4
#define REG_DLL_OBS_REG_3_1_4 _MASK     0xffffffff
#define REG_DLL_OBS_REG_3_1_4 _SHIFT    0
#define REG_DLL_OBS_REG_3_1_4 _WIDTH    32

/* DLL_OBS_REG_3_1_5  */
#define REG_DLL_OBS_REG_3_1_5           0x001B8
#define REG_DLL_OBS_REG_3_1_5 _MASK     0x000fffff
#define REG_DLL_OBS_REG_3_1_5 _SHIFT    0
#define REG_DLL_OBS_REG_3_1_5 _WIDTH    20
#endif 
