/*******************************************************************
*                                                                   
*  EVM_FPGA.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef EVM_FPGA_regs_H_FILE
#define EVM_FPGA_regs_H_FILE

/* MCS_RATE_0 */
#define REG_MCS_RATE_0          0x0
#define REG_MCS_RATE_0_MASK     0x000000ff
#define REG_MCS_RATE_0_SHIFT    0
#define REG_MCS_RATE_0_WIDTH    8

/* MCS_N_MODE_0 */
#define REG_MCS_N_MODE_0          0x0
#define REG_MCS_N_MODE_0_MASK     0x00000100
#define REG_MCS_N_MODE_0_SHIFT    8
#define REG_MCS_N_MODE_0_WIDTH    1

/* MCS_RANK2_0 */
#define REG_MCS_RANK2_0          0x0
#define REG_MCS_RANK2_0_MASK     0x00000200
#define REG_MCS_RANK2_0_SHIFT    9
#define REG_MCS_RANK2_0_WIDTH    1

/* MCS_RATE_1 */
#define REG_MCS_RATE_1          0x4
#define REG_MCS_RATE_1_MASK     0x000000ff
#define REG_MCS_RATE_1_SHIFT    0
#define REG_MCS_RATE_1_WIDTH    8

/* MCS_N_MODE_1 */
#define REG_MCS_N_MODE_1          0x4
#define REG_MCS_N_MODE_1_MASK     0x00000100
#define REG_MCS_N_MODE_1_SHIFT    8
#define REG_MCS_N_MODE_1_WIDTH    1

/* MCS_RANK2_1 */
#define REG_MCS_RANK2_1          0x4
#define REG_MCS_RANK2_1_MASK     0x00000200
#define REG_MCS_RANK2_1_SHIFT    9
#define REG_MCS_RANK2_1_WIDTH    1

/* USB_SUSPEND_TESTMODE_EN */
#define REG_USB_SUSPEND_TESTMODE_EN          0x48
#define REG_USB_SUSPEND_TESTMODE_EN_MASK     0x00000001
#define REG_USB_SUSPEND_TESTMODE_EN_SHIFT    0
#define REG_USB_SUSPEND_TESTMODE_EN_WIDTH    1

/* USB_SUSPEND_POWER_SAVE_EN */
#define REG_USB_SUSPEND_POWER_SAVE_EN          0x48
#define REG_USB_SUSPEND_POWER_SAVE_EN_MASK     0x00000002
#define REG_USB_SUSPEND_POWER_SAVE_EN_SHIFT    1
#define REG_USB_SUSPEND_POWER_SAVE_EN_WIDTH    1

/* MCS_RATE_63 */
#define REG_MCS_RATE_63          0xfc
#define REG_MCS_RATE_63_MASK     0x000000ff
#define REG_MCS_RATE_63_SHIFT    0
#define REG_MCS_RATE_63_WIDTH    8

/* MCS_N_MODE_63 */
#define REG_MCS_N_MODE_63          0xfc
#define REG_MCS_N_MODE_63_MASK     0x00000100
#define REG_MCS_N_MODE_63_SHIFT    8
#define REG_MCS_N_MODE_63_WIDTH    1

/* MCS_RANK2_63 */
#define REG_MCS_RANK2_63          0xfc
#define REG_MCS_RANK2_63_MASK     0x00000200
#define REG_MCS_RANK2_63_SHIFT    9
#define REG_MCS_RANK2_63_WIDTH    1

/* DPHY_RADIO_CHANNEL */
#define REG_DPHY_RADIO_CHANNEL          0x200
#define REG_DPHY_RADIO_CHANNEL_MASK     0x00000001
#define REG_DPHY_RADIO_CHANNEL_SHIFT    0
#define REG_DPHY_RADIO_CHANNEL_WIDTH    1

/* DPHY_MEDIUM_BUSY_DELAY */
/* Measured in microseconds */
#define REG_DPHY_MEDIUM_BUSY_DELAY          0x204
#define REG_DPHY_MEDIUM_BUSY_DELAY_MASK     0x000000ff
#define REG_DPHY_MEDIUM_BUSY_DELAY_SHIFT    0
#define REG_DPHY_MEDIUM_BUSY_DELAY_WIDTH    8

/* DPHY_MEDIUM_BUSY_TIME */
/* Measured in microseconds */
#define REG_DPHY_MEDIUM_BUSY_TIME          0x204
#define REG_DPHY_MEDIUM_BUSY_TIME_MASK     0x0000ff00
#define REG_DPHY_MEDIUM_BUSY_TIME_SHIFT    8
#define REG_DPHY_MEDIUM_BUSY_TIME_WIDTH    8

/* DPHY_MEDIUM_BUSY_ARM */
#define REG_DPHY_MEDIUM_BUSY_ARM          0x208
#define REG_DPHY_MEDIUM_BUSY_ARM_MASK     0x00000001
#define REG_DPHY_MEDIUM_BUSY_ARM_SHIFT    0
#define REG_DPHY_MEDIUM_BUSY_ARM_WIDTH    1

/* DPHY_MEDIUM_BUSY_DELAY_TIMER */
/* Measured in microseconds */
#define REG_DPHY_MEDIUM_BUSY_DELAY_TIMER          0x20c
#define REG_DPHY_MEDIUM_BUSY_DELAY_TIMER_MASK     0x000000ff
#define REG_DPHY_MEDIUM_BUSY_DELAY_TIMER_SHIFT    0
#define REG_DPHY_MEDIUM_BUSY_DELAY_TIMER_WIDTH    8

/* DPHY_MEDIUM_BUSY_TIME_TIMER */
/* Measured in microseconds */
#define REG_DPHY_MEDIUM_BUSY_TIME_TIMER          0x20c
#define REG_DPHY_MEDIUM_BUSY_TIME_TIMER_MASK     0x0000ff00
#define REG_DPHY_MEDIUM_BUSY_TIME_TIMER_SHIFT    8
#define REG_DPHY_MEDIUM_BUSY_TIME_TIMER_WIDTH    8

/* DUMMY_PHY_MODE_ENABLE */
#define REG_DUMMY_PHY_MODE_ENABLE          0x210
#define REG_DUMMY_PHY_MODE_ENABLE_MASK     0x00000001
#define REG_DUMMY_PHY_MODE_ENABLE_SHIFT    0
#define REG_DUMMY_PHY_MODE_ENABLE_WIDTH    1

/* DUMMY_PHY_TX_SW_RESET */
#define REG_DUMMY_PHY_TX_SW_RESET          0x214
#define REG_DUMMY_PHY_TX_SW_RESET_MASK     0x00000001
#define REG_DUMMY_PHY_TX_SW_RESET_SHIFT    0
#define REG_DUMMY_PHY_TX_SW_RESET_WIDTH    1

/* DUMMY_PHY_RX_SW_RESET */
#define REG_DUMMY_PHY_RX_SW_RESET          0x214
#define REG_DUMMY_PHY_RX_SW_RESET_MASK     0x00000002
#define REG_DUMMY_PHY_RX_SW_RESET_SHIFT    1
#define REG_DUMMY_PHY_RX_SW_RESET_WIDTH    1

/* RESET_TIME_STAMP */
#define REG_RESET_TIME_STAMP          0x20000000
#define REG_RESET_TIME_STAMP_MASK     0x00000001
#define REG_RESET_TIME_STAMP_SHIFT    0
#define REG_RESET_TIME_STAMP_WIDTH    1

/* LOGGER_MODE */
#define REG_LOGGER_MODE          0x20000004
#define REG_LOGGER_MODE_MASK     0x00000001
#define REG_LOGGER_MODE_SHIFT    0
#define REG_LOGGER_MODE_WIDTH    1

/* CONTINUOUS_MODE */
#define REG_CONTINUOUS_MODE          0x20000004
#define REG_CONTINUOUS_MODE_MASK     0x00000002
#define REG_CONTINUOUS_MODE_SHIFT    1
#define REG_CONTINUOUS_MODE_WIDTH    1

/* DATA_FROM_GPIO */
#define REG_DATA_FROM_GPIO          0x20000004
#define REG_DATA_FROM_GPIO_MASK     0x00000004
#define REG_DATA_FROM_GPIO_SHIFT    2
#define REG_DATA_FROM_GPIO_WIDTH    1

/* DATA_FROM_USB */
#define REG_DATA_FROM_USB          0x20000004
#define REG_DATA_FROM_USB_MASK     0x00000008
#define REG_DATA_FROM_USB_SHIFT    3
#define REG_DATA_FROM_USB_WIDTH    1

/* DATA_TO_HYPERION */
#define REG_DATA_TO_HYPERION          0x20000004
#define REG_DATA_TO_HYPERION_MASK     0x00000010
#define REG_DATA_TO_HYPERION_SHIFT    4
#define REG_DATA_TO_HYPERION_WIDTH    1

/* DATA_TO_USB */
#define REG_DATA_TO_USB          0x20000004
#define REG_DATA_TO_USB_MASK     0x00000020
#define REG_DATA_TO_USB_SHIFT    5
#define REG_DATA_TO_USB_WIDTH    1

/* CYCLIC_MODE */
#define REG_CYCLIC_MODE          0x20000004
#define REG_CYCLIC_MODE_MASK     0x00000040
#define REG_CYCLIC_MODE_SHIFT    6
#define REG_CYCLIC_MODE_WIDTH    1

/* STOP_FROM_REGISTER_MODE */
#define REG_STOP_FROM_REGISTER_MODE          0x20000004
#define REG_STOP_FROM_REGISTER_MODE_MASK     0x00000080
#define REG_STOP_FROM_REGISTER_MODE_SHIFT    7
#define REG_STOP_FROM_REGISTER_MODE_WIDTH    1

/* END_ADDRESS */
#define REG_END_ADDRESS          0x20000008
#define REG_END_ADDRESS_MASK     0xffffffff
#define REG_END_ADDRESS_SHIFT    0
#define REG_END_ADDRESS_WIDTH    32

/* PACKET_SIZE_REGISTER */
#define REG_PACKET_SIZE_REGISTER          0x20000010
#define REG_PACKET_SIZE_REGISTER_MASK     0x0000ffff
#define REG_PACKET_SIZE_REGISTER_SHIFT    0
#define REG_PACKET_SIZE_REGISTER_WIDTH    16

/* PACKET_END_DISABLE */
#define REG_PACKET_END_DISABLE          0x20000018
#define REG_PACKET_END_DISABLE_MASK     0x00000001
#define REG_PACKET_END_DISABLE_SHIFT    0
#define REG_PACKET_END_DISABLE_WIDTH    1

/* USB_ADDR */
#define REG_USB_ADDR          0x20000018
#define REG_USB_ADDR_MASK     0x00000006
#define REG_USB_ADDR_SHIFT    1
#define REG_USB_ADDR_WIDTH    2

/* CRC_MODE */
#define REG_CRC_MODE          0x20000018
#define REG_CRC_MODE_MASK     0x00000008
#define REG_CRC_MODE_SHIFT    3
#define REG_CRC_MODE_WIDTH    1

/* START_OP_2_0 */
#define REG_START_OP_2_0          0x20000018
#define REG_START_OP_2_0_MASK     0x00000010
#define REG_START_OP_2_0_SHIFT    4
#define REG_START_OP_2_0_WIDTH    1

/* START_OP_2_1 */
#define REG_START_OP_2_1          0x20000018
#define REG_START_OP_2_1_MASK     0x00000020
#define REG_START_OP_2_1_SHIFT    5
#define REG_START_OP_2_1_WIDTH    1

/* START_OP_0 */
#define REG_START_OP_0          0x20000018
#define REG_START_OP_0_MASK     0x00000040
#define REG_START_OP_0_SHIFT    6
#define REG_START_OP_0_WIDTH    1

/* START_OP_1 */
#define REG_START_OP_1          0x20000018
#define REG_START_OP_1_MASK     0x00000080
#define REG_START_OP_1_SHIFT    7
#define REG_START_OP_1_WIDTH    1

/* OFF_CNT_LIMIT */
#define REG_OFF_CNT_LIMIT          0x2000001c
#define REG_OFF_CNT_LIMIT_MASK     0x0000ffff
#define REG_OFF_CNT_LIMIT_SHIFT    0
#define REG_OFF_CNT_LIMIT_WIDTH    16

/* DEEP_SWITCHES_VAL */
#define REG_DEEP_SWITCHES_VAL          0x20000020
#define REG_DEEP_SWITCHES_VAL_MASK     0xffffffff
#define REG_DEEP_SWITCHES_VAL_SHIFT    0
#define REG_DEEP_SWITCHES_VAL_WIDTH    32

/* DELAY_STOP */
#define REG_DELAY_STOP          0x20000024
#define REG_DELAY_STOP_MASK     0xffffffff
#define REG_DELAY_STOP_SHIFT    0
#define REG_DELAY_STOP_WIDTH    32

/* DONE_0 */
#define REG_DONE_0          0x2000002c
#define REG_DONE_0_MASK     0x00000001
#define REG_DONE_0_SHIFT    0
#define REG_DONE_0_WIDTH    1

/* DONE_1 */
#define REG_DONE_1          0x2000002c
#define REG_DONE_1_MASK     0x00000002
#define REG_DONE_1_SHIFT    1
#define REG_DONE_1_WIDTH    1

/* DONE_OP_2_0 */
#define REG_DONE_OP_2_0          0x2000002c
#define REG_DONE_OP_2_0_MASK     0x00000004
#define REG_DONE_OP_2_0_SHIFT    2
#define REG_DONE_OP_2_0_WIDTH    1

/* DONE_OP_2_1 */
#define REG_DONE_OP_2_1          0x2000002c
#define REG_DONE_OP_2_1_MASK     0x00000008
#define REG_DONE_OP_2_1_SHIFT    3
#define REG_DONE_OP_2_1_WIDTH    1

/* USB_START_READ_ADDRESS */
#define REG_USB_START_READ_ADDRESS          0x20000030
#define REG_USB_START_READ_ADDRESS_MASK     0xffffffff
#define REG_USB_START_READ_ADDRESS_SHIFT    0
#define REG_USB_START_READ_ADDRESS_WIDTH    32

/* STOP_FROM_REG */
#define REG_STOP_FROM_REG          0x20000034
#define REG_STOP_FROM_REG_MASK     0x00000001
#define REG_STOP_FROM_REG_SHIFT    0
#define REG_STOP_FROM_REG_WIDTH    1

/* LEDS_REG */
#define REG_LEDS_REG          0x20000038
#define REG_LEDS_REG_MASK     0xffffffff
#define REG_LEDS_REG_SHIFT    0
#define REG_LEDS_REG_WIDTH    32

/* USB_FIFO_ADDRESS */
#define REG_USB_FIFO_ADDRESS          0x2000003c
#define REG_USB_FIFO_ADDRESS_MASK     0x00000003
#define REG_USB_FIFO_ADDRESS_SHIFT    0
#define REG_USB_FIFO_ADDRESS_WIDTH    2

/* VERSION_REG */
#define REG_VERSION_REG          0x2000007c
#define REG_VERSION_REG_MASK     0xffffffff
#define REG_VERSION_REG_SHIFT    0
#define REG_VERSION_REG_WIDTH    32

/* HYP_FCSI_MASTER_STUB_ACTIVE */
#define REG_HYP_FCSI_MASTER_STUB_ACTIVE          0x80000000
#define REG_HYP_FCSI_MASTER_STUB_ACTIVE_MASK     0x00000001
#define REG_HYP_FCSI_MASTER_STUB_ACTIVE_SHIFT    0
#define REG_HYP_FCSI_MASTER_STUB_ACTIVE_WIDTH    1

/* FCSI_RSTRQ */
#define REG_FCSI_RSTRQ          0x80000004
#define REG_FCSI_RSTRQ_MASK     0x00000001
#define REG_FCSI_RSTRQ_SHIFT    0
#define REG_FCSI_RSTRQ_WIDTH    1

/* FCSI_CLK_WR_DIVR */
#define REG_FCSI_CLK_WR_DIVR          0x80000008
#define REG_FCSI_CLK_WR_DIVR_MASK     0x0000001f
#define REG_FCSI_CLK_WR_DIVR_SHIFT    0
#define REG_FCSI_CLK_WR_DIVR_WIDTH    5

/* FCSI_CLK_RD_DIVR */
#define REG_FCSI_CLK_RD_DIVR          0x80000008
#define REG_FCSI_CLK_RD_DIVR_MASK     0x00001f00
#define REG_FCSI_CLK_RD_DIVR_SHIFT    8
#define REG_FCSI_CLK_RD_DIVR_WIDTH    5

/* FCSI_RF_MS_SELECT */
#define REG_FCSI_RF_MS_SELECT          0x80000008
#define REG_FCSI_RF_MS_SELECT_MASK     0x00002000
#define REG_FCSI_RF_MS_SELECT_SHIFT    13
#define REG_FCSI_RF_MS_SELECT_WIDTH    1

/* FCSI_ADDR_A */
#define REG_FCSI_ADDR_A          0x8000000c
#define REG_FCSI_ADDR_A_MASK     0x0000007f
#define REG_FCSI_ADDR_A_SHIFT    0
#define REG_FCSI_ADDR_A_WIDTH    7

/* FCSI_ADDR_B */
#define REG_FCSI_ADDR_B          0x80000010
#define REG_FCSI_ADDR_B_MASK     0x0000007f
#define REG_FCSI_ADDR_B_SHIFT    0
#define REG_FCSI_ADDR_B_WIDTH    7

/* FCSI_ADDR_C */
#define REG_FCSI_ADDR_C          0x80000014
#define REG_FCSI_ADDR_C_MASK     0x0000007f
#define REG_FCSI_ADDR_C_SHIFT    0
#define REG_FCSI_ADDR_C_WIDTH    7

/* FCSI_WR_DATA_A */
#define REG_FCSI_WR_DATA_A          0x80000018
#define REG_FCSI_WR_DATA_A_MASK     0x0000ffff
#define REG_FCSI_WR_DATA_A_SHIFT    0
#define REG_FCSI_WR_DATA_A_WIDTH    16

/* FCSI_WR_DATA_B */
#define REG_FCSI_WR_DATA_B          0x8000001c
#define REG_FCSI_WR_DATA_B_MASK     0x0000ffff
#define REG_FCSI_WR_DATA_B_SHIFT    0
#define REG_FCSI_WR_DATA_B_WIDTH    16

/* FCSI_WR_DATA_C */
#define REG_FCSI_WR_DATA_C          0x80000020
#define REG_FCSI_WR_DATA_C_MASK     0x0000ffff
#define REG_FCSI_WR_DATA_C_SHIFT    0
#define REG_FCSI_WR_DATA_C_WIDTH    16

/* FCSI_RD_WR */
#define REG_FCSI_RD_WR          0x80000024
#define REG_FCSI_RD_WR_MASK     0x00000001
#define REG_FCSI_RD_WR_SHIFT    0
#define REG_FCSI_RD_WR_WIDTH    1

/* FCSI_BUSY */
#define REG_FCSI_BUSY          0x80000080
#define REG_FCSI_BUSY_MASK     0x00000001
#define REG_FCSI_BUSY_SHIFT    0
#define REG_FCSI_BUSY_WIDTH    1

/* FCSI_RD_DATA_A */
#define REG_FCSI_RD_DATA_A          0x80000084
#define REG_FCSI_RD_DATA_A_MASK     0x0000ffff
#define REG_FCSI_RD_DATA_A_SHIFT    0
#define REG_FCSI_RD_DATA_A_WIDTH    16

/* FCSI_RD_DATA_B */
#define REG_FCSI_RD_DATA_B          0x80000088
#define REG_FCSI_RD_DATA_B_MASK     0x0000ffff
#define REG_FCSI_RD_DATA_B_SHIFT    0
#define REG_FCSI_RD_DATA_B_WIDTH    16

/* FCSI_RD_DATA_C */
#define REG_FCSI_RD_DATA_C          0x8000008c
#define REG_FCSI_RD_DATA_C_MASK     0x0000ffff
#define REG_FCSI_RD_DATA_C_SHIFT    0
#define REG_FCSI_RD_DATA_C_WIDTH    16
#endif 
