/*******************************************************************
*                                                                   
*  MODEM_11B.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef MODEM_11B_regs_H_FILE
#define MODEM_11B_regs_H_FILE

/* MDMBCNTL_INT_PREPRE */
/* Number of clock cycles at 44 MHz to count for the pre-preamble. */
#define REG_MDMBCNTL_INT_PREPRE          0x0C000
#define REG_MDMBCNTL_INT_PREPRE_MASK     0x0000003f
#define REG_MDMBCNTL_INT_PREPRE_SHIFT    0
#define REG_MDMBCNTL_INT_PREPRE_WIDTH    6

/* MDMBCNTL_INT_SFDLEN */
/* Select the number of preamble bits that should be considered in short SFD comparison */
#define REG_MDMBCNTL_INT_SFDLEN          0x0C000
#define REG_MDMBCNTL_INT_SFDLEN_MASK     0x00000700
#define REG_MDMBCNTL_INT_SFDLEN_SHIFT    8
#define REG_MDMBCNTL_INT_SFDLEN_WIDTH    3

/* MDMBCNTL_INT_SFDERR */
/* Select the number of errors that are allowed in the short SFD comparison (0-7) */
#define REG_MDMBCNTL_INT_SFDERR          0x0C000
#define REG_MDMBCNTL_INT_SFDERR_MASK     0x00007000
#define REG_MDMBCNTL_INT_SFDERR_SHIFT    12
#define REG_MDMBCNTL_INT_SFDERR_WIDTH    3

/* MDMBCNTL_INT_SCRAMBDISB */
/* Scrambeling disable */
#define REG_MDMBCNTL_INT_SCRAMBDISB          0x0C000
#define REG_MDMBCNTL_INT_SCRAMBDISB_MASK     0x00100000
#define REG_MDMBCNTL_INT_SCRAMBDISB_SHIFT    20
#define REG_MDMBCNTL_INT_SCRAMBDISB_WIDTH    1

/* MDMBCNTL_INT_SPREADDISB */
/* Spreading disable (This bit is only meaningful for 1 and 2 Mb/s data rates; it is ignored at other rates). */
#define REG_MDMBCNTL_INT_SPREADDISB          0x0C000
#define REG_MDMBCNTL_INT_SPREADDISB_MASK     0x00200000
#define REG_MDMBCNTL_INT_SPREADDISB_SHIFT    21
#define REG_MDMBCNTL_INT_SPREADDISB_WIDTH    1

/* MDMBCNTL_INT_FIRDISB */
/* Tx and Rx filters disable */
#define REG_MDMBCNTL_INT_FIRDISB          0x0C000
#define REG_MDMBCNTL_INT_FIRDISB_MASK     0x00400000
#define REG_MDMBCNTL_INT_FIRDISB_SHIFT    22
#define REG_MDMBCNTL_INT_FIRDISB_WIDTH    1

/* MDMBCNTL_INT_EQDISB */
/* Equalizer bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_EQDISB          0x0C000
#define REG_MDMBCNTL_INT_EQDISB_MASK     0x00800000
#define REG_MDMBCNTL_INT_EQDISB_SHIFT    23
#define REG_MDMBCNTL_INT_EQDISB_WIDTH    1

/* MDMBCNTL_INT_COMPDISB */
/* Frequency offset compensation bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_COMPDISB          0x0C000
#define REG_MDMBCNTL_INT_COMPDISB_MASK     0x01000000
#define REG_MDMBCNTL_INT_COMPDISB_SHIFT    24
#define REG_MDMBCNTL_INT_COMPDISB_WIDTH    1

/* MDMBCNTL_INT_DCOFFDISB */
/* DC Offset compensation bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_DCOFFDISB          0x0C000
#define REG_MDMBCNTL_INT_DCOFFDISB_MASK     0x02000000
#define REG_MDMBCNTL_INT_DCOFFDISB_SHIFT    25
#define REG_MDMBCNTL_INT_DCOFFDISB_WIDTH    1

/* MDMBCNTL_INT_PRECOMPDISB */
/* Frequency pre-compensation bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_PRECOMPDISB          0x0C000
#define REG_MDMBCNTL_INT_PRECOMPDISB_MASK     0x04000000
#define REG_MDMBCNTL_INT_PRECOMPDISB_SHIFT    26
#define REG_MDMBCNTL_INT_PRECOMPDISB_WIDTH    1

/* MDMBCNTL_INT_GAINDISB */
/* Gain compensation bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_GAINDISB          0x0C000
#define REG_MDMBCNTL_INT_GAINDISB_MASK     0x08000000
#define REG_MDMBCNTL_INT_GAINDISB_SHIFT    27
#define REG_MDMBCNTL_INT_GAINDISB_WIDTH    1

/* MDMBCNTL_INT_IQMMDISB */
/* I/Q Mismatch compensation bypass (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_IQMMDISB          0x0C000
#define REG_MDMBCNTL_INT_IQMMDISB_MASK     0x10000000
#define REG_MDMBCNTL_INT_IQMMDISB_SHIFT    28
#define REG_MDMBCNTL_INT_IQMMDISB_WIDTH    1

/* MDMBCNTL_INT_INTERPDISB */
/* Bypass the timing interpolator for timing offset compensation, (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_INTERPDISB          0x0C000
#define REG_MDMBCNTL_INT_INTERPDISB_MASK     0x20000000
#define REG_MDMBCNTL_INT_INTERPDISB_SHIFT    29
#define REG_MDMBCNTL_INT_INTERPDISB_WIDTH    1

/* MDMBCNTL_INT_RXC2DISB */
/* Bypass the 2s complement conversion in the Rx path (leaving the data samples unchanged) */
#define REG_MDMBCNTL_INT_RXC2DISB          0x0C000
#define REG_MDMBCNTL_INT_RXC2DISB_MASK     0x40000000
#define REG_MDMBCNTL_INT_RXC2DISB_SHIFT    30
#define REG_MDMBCNTL_INT_RXC2DISB_WIDTH    1

/* MDMBCNTL_INT_TLOCKDISB */
/* 0: Extract the Timing lock from bit 2 of the received SERVICE field (normal mode).
1: Always use the timing estimation to compensate for the timing error, regardless of the setting of the SERVICE field. */
#define REG_MDMBCNTL_INT_TLOCKDISB          0x0C000
#define REG_MDMBCNTL_INT_TLOCKDISB_MASK     0x80000000
#define REG_MDMBCNTL_INT_TLOCKDISB_SHIFT    31
#define REG_MDMBCNTL_INT_TLOCKDISB_WIDTH    1

/* MDMBPRMINIT_INT_ALPHA */
/* ? = 6 + ALPHA[1:0] */
#define REG_MDMBPRMINIT_INT_ALPHA          0x0C020
#define REG_MDMBPRMINIT_INT_ALPHA_MASK     0x00000003
#define REG_MDMBPRMINIT_INT_ALPHA_SHIFT    0
#define REG_MDMBPRMINIT_INT_ALPHA_WIDTH    2

/* MDMBPRMINIT_INT_BETA */
/* ? = 4 + BETA [1:0] */
#define REG_MDMBPRMINIT_INT_BETA          0x0C020
#define REG_MDMBPRMINIT_INT_BETA_MASK     0x00000030
#define REG_MDMBPRMINIT_INT_BETA_SHIFT    4
#define REG_MDMBPRMINIT_INT_BETA_WIDTH    2

/* MDMBPRMINIT_INT_MU */
/* ? = MU [1:0] */
#define REG_MDMBPRMINIT_INT_MU          0x0C020
#define REG_MDMBPRMINIT_INT_MU_MASK     0x00030000
#define REG_MDMBPRMINIT_INT_MU_SHIFT    16
#define REG_MDMBPRMINIT_INT_MU_WIDTH    2

/* MDMBPRMINIT_INT_RHO */
/* ? = 2 + RHO [1:0] */
#define REG_MDMBPRMINIT_INT_RHO          0x0C020
#define REG_MDMBPRMINIT_INT_RHO_MASK     0x00300000
#define REG_MDMBPRMINIT_INT_RHO_SHIFT    20
#define REG_MDMBPRMINIT_INT_RHO_WIDTH    2

/* MDMBTALPHA_INT_TALPHA0 */
/* ??0 = TALPHA0 [3:0]  10 ?s */
#define REG_MDMBTALPHA_INT_TALPHA0          0x0C030
#define REG_MDMBTALPHA_INT_TALPHA0_MASK     0x0000000f
#define REG_MDMBTALPHA_INT_TALPHA0_SHIFT    0
#define REG_MDMBTALPHA_INT_TALPHA0_WIDTH    4

/* MDMBTALPHA_INT_TALPHA1 */
/* ??1 = TALPHA1 [3:0]  10 ?s */
#define REG_MDMBTALPHA_INT_TALPHA1          0x0C030
#define REG_MDMBTALPHA_INT_TALPHA1_MASK     0x000000f0
#define REG_MDMBTALPHA_INT_TALPHA1_SHIFT    4
#define REG_MDMBTALPHA_INT_TALPHA1_WIDTH    4

/* MDMBTALPHA_INT_TALPHA2 */
/* ??2 = TALPHA2 [3:0]  10 ?s */
#define REG_MDMBTALPHA_INT_TALPHA2          0x0C030
#define REG_MDMBTALPHA_INT_TALPHA2_MASK     0x00000f00
#define REG_MDMBTALPHA_INT_TALPHA2_SHIFT    8
#define REG_MDMBTALPHA_INT_TALPHA2_WIDTH    4

/* MDMBTALPHA_INT_TALPHA3 */
/* ??3 = TALPHA3 [3:0]  10 ?s */
#define REG_MDMBTALPHA_INT_TALPHA3          0x0C030
#define REG_MDMBTALPHA_INT_TALPHA3_MASK     0x0000f000
#define REG_MDMBTALPHA_INT_TALPHA3_SHIFT    12
#define REG_MDMBTALPHA_INT_TALPHA3_WIDTH    4

/* MDMBTBETA_INT_TBETA0 */
/* ??0 = TBETA0 [3:0]  10 ?s */
#define REG_MDMBTBETA_INT_TBETA0          0x0C040
#define REG_MDMBTBETA_INT_TBETA0_MASK     0x0000000f
#define REG_MDMBTBETA_INT_TBETA0_SHIFT    0
#define REG_MDMBTBETA_INT_TBETA0_WIDTH    4

/* MDMBTBETA_INT_TBETA1 */
/* ??1 = TBETA1 [3:0]  10 ?s */
#define REG_MDMBTBETA_INT_TBETA1          0x0C040
#define REG_MDMBTBETA_INT_TBETA1_MASK     0x000000f0
#define REG_MDMBTBETA_INT_TBETA1_SHIFT    4
#define REG_MDMBTBETA_INT_TBETA1_WIDTH    4

/* MDMBTBETA_INT_TBETA2 */
/* ??2 = TBETA2 [3:0]  10 ?s */
#define REG_MDMBTBETA_INT_TBETA2          0x0C040
#define REG_MDMBTBETA_INT_TBETA2_MASK     0x00000f00
#define REG_MDMBTBETA_INT_TBETA2_SHIFT    8
#define REG_MDMBTBETA_INT_TBETA2_WIDTH    4

/* MDMBTBETA_INT_TBETA3 */
/* ??3 = TBETA3 [3:0]  10 ?s */
#define REG_MDMBTBETA_INT_TBETA3          0x0C040
#define REG_MDMBTBETA_INT_TBETA3_MASK     0x0000f000
#define REG_MDMBTBETA_INT_TBETA3_SHIFT    12
#define REG_MDMBTBETA_INT_TBETA3_WIDTH    4

/* MDMBTMU_INT_TMU0 */
/* ??0 = TMU0 [3:0]  10 ?s */
#define REG_MDMBTMU_INT_TMU0          0x0C050
#define REG_MDMBTMU_INT_TMU0_MASK     0x0000000f
#define REG_MDMBTMU_INT_TMU0_SHIFT    0
#define REG_MDMBTMU_INT_TMU0_WIDTH    4

/* MDMBTMU_INT_TMU1 */
/* ??1 = TMU1 [3:0]  10 ?s */
#define REG_MDMBTMU_INT_TMU1          0x0C050
#define REG_MDMBTMU_INT_TMU1_MASK     0x000000f0
#define REG_MDMBTMU_INT_TMU1_SHIFT    4
#define REG_MDMBTMU_INT_TMU1_WIDTH    4

/* MDMBTMU_INT_TMU2 */
/* ??2 = TMU2 [3:0]  10 ?s */
#define REG_MDMBTMU_INT_TMU2          0x0C050
#define REG_MDMBTMU_INT_TMU2_MASK     0x00000f00
#define REG_MDMBTMU_INT_TMU2_SHIFT    8
#define REG_MDMBTMU_INT_TMU2_WIDTH    4

/* MDMBTMU_INT_TMU3 */
/* ??3 = TMU3 [3:0]  10 ?s */
#define REG_MDMBTMU_INT_TMU3          0x0C050
#define REG_MDMBTMU_INT_TMU3_MASK     0x0000f000
#define REG_MDMBTMU_INT_TMU3_SHIFT    12
#define REG_MDMBTMU_INT_TMU3_WIDTH    4

/* MDMBCNTL1_INT_RXMAXLENGTH */
/* Maximum accepted received length when in Enhanced rx length check. */
#define REG_MDMBCNTL1_INT_RXMAXLENGTH          0x0C060
#define REG_MDMBCNTL1_INT_RXMAXLENGTH_MASK     0x00000fff
#define REG_MDMBCNTL1_INT_RXMAXLENGTH_SHIFT    0
#define REG_MDMBCNTL1_INT_RXMAXLENGTH_WIDTH    12

/* MDMBCNTL1_INT_RXLENCHKEN */
/* Simple rx length check: 
    Only length from 1 to 4095 bytes is accepted. 
    Other received length is considered as a Format Violation. rxe_errorstat_o = Format Violation
Enhanced rx length check:
    Only length from 14 to RXMAXLENGTH bytes is accepted. 
    Other received length is considered as a Format Violation. rxe_errorstat_o = Format Violation */
#define REG_MDMBCNTL1_INT_RXLENCHKEN          0x0C060
#define REG_MDMBCNTL1_INT_RXLENCHKEN_MASK     0x00001000
#define REG_MDMBCNTL1_INT_RXLENCHKEN_SHIFT    12
#define REG_MDMBCNTL1_INT_RXLENCHKEN_WIDTH    1

/* MDMBCNTL1_INT_DSCRMODESEL */
/* 0: Fixed dscr_mode - earlier sfd_found indication for different scrambler
1: Old dscr_mode */
#define REG_MDMBCNTL1_INT_DSCRMODESEL          0x0C060
#define REG_MDMBCNTL1_INT_DSCRMODESEL_MASK     0x00002000
#define REG_MDMBCNTL1_INT_DSCRMODESEL_SHIFT    13
#define REG_MDMBCNTL1_INT_DSCRMODESEL_WIDTH    1

/* MDMBRFCNTL_INT_TXCONST */
/* Value to be sent to the I data DAC before the Tx packets, for auto-calibration of the transmit path. 
This value is in 2s complement format and represents the average power of the packet. */
#define REG_MDMBRFCNTL_INT_TXCONST          0x0C070
#define REG_MDMBRFCNTL_INT_TXCONST_MASK     0x0000ff00
#define REG_MDMBRFCNTL_INT_TXCONST_SHIFT    8
#define REG_MDMBRFCNTL_INT_TXCONST_WIDTH    8

/* MDMBRFCNTL_INT_TXENDDEL */
/* number of 44 MHz clock cycles */
#define REG_MDMBRFCNTL_INT_TXENDDEL          0x0C070
#define REG_MDMBRFCNTL_INT_TXENDDEL_MASK     0x00ff0000
#define REG_MDMBRFCNTL_INT_TXENDDEL_SHIFT    16
#define REG_MDMBRFCNTL_INT_TXENDDEL_WIDTH    8

/* MDMBCCA_INT_CCAMODE */
/* CCA mode */
#define REG_MDMBCCA_INT_CCAMODE          0x0C080
#define REG_MDMBCCA_INT_CCAMODE_MASK     0x00000700
#define REG_MDMBCCA_INT_CCAMODE_SHIFT    8
#define REG_MDMBCCA_INT_CCAMODE_WIDTH    3

/* MDMBEQCNTL_INT_EQTIME */
/* in ?s */
#define REG_MDMBEQCNTL_INT_EQTIME          0x0C090
#define REG_MDMBEQCNTL_INT_EQTIME_MASK     0x0000000f
#define REG_MDMBEQCNTL_INT_EQTIME_SHIFT    0
#define REG_MDMBEQCNTL_INT_EQTIME_WIDTH    4

/* MDMBEQCNTL_INT_ESTTIME */
/* in ?s */
#define REG_MDMBEQCNTL_INT_ESTTIME          0x0C090
#define REG_MDMBEQCNTL_INT_ESTTIME_MASK     0x000003e0
#define REG_MDMBEQCNTL_INT_ESTTIME_SHIFT    5
#define REG_MDMBEQCNTL_INT_ESTTIME_WIDTH    5

/* MDMBEQCNTL_INT_COMPTIME */
/* in ?s */
#define REG_MDMBEQCNTL_INT_COMPTIME          0x0C090
#define REG_MDMBEQCNTL_INT_COMPTIME_MASK     0x00007c00
#define REG_MDMBEQCNTL_INT_COMPTIME_SHIFT    10
#define REG_MDMBEQCNTL_INT_COMPTIME_WIDTH    5

/* MDMBEQCNTL_INT_EQHOLD */
/* in ?s */
#define REG_MDMBEQCNTL_INT_EQHOLD          0x0C090
#define REG_MDMBEQCNTL_INT_EQHOLD_MASK     0x0fff0000
#define REG_MDMBEQCNTL_INT_EQHOLD_SHIFT    16
#define REG_MDMBEQCNTL_INT_EQHOLD_WIDTH    12

/* MDMBCNTL2_INT_LOOPTIME */
/* in ?s */
#define REG_MDMBCNTL2_INT_LOOPTIME          0x0C0A0
#define REG_MDMBCNTL2_INT_LOOPTIME_MASK     0x0000000f
#define REG_MDMBCNTL2_INT_LOOPTIME_SHIFT    0
#define REG_MDMBCNTL2_INT_LOOPTIME_WIDTH    4

/* MDMBCNTL2_INT_SYNCTIME */
/* in ?s */
#define REG_MDMBCNTL2_INT_SYNCTIME          0x0C0A0
#define REG_MDMBCNTL2_INT_SYNCTIME_MASK     0x00003f00
#define REG_MDMBCNTL2_INT_SYNCTIME_SHIFT    8
#define REG_MDMBCNTL2_INT_SYNCTIME_WIDTH    6

/* MDMBCNTL2_INT_PRECOMP */
/* in ?s */
#define REG_MDMBCNTL2_INT_PRECOMP          0x0C0A0
#define REG_MDMBCNTL2_INT_PRECOMP_MASK     0x003f0000
#define REG_MDMBCNTL2_INT_PRECOMP_SHIFT    16
#define REG_MDMBCNTL2_INT_PRECOMP_WIDTH    6

/* MDMBCNTL2_INT_MAXSTAGE */
/* Number of stages in the DSSS/CCK interpolator used for timing offset compensation.
The maximum total drift (transmitter + receiver) that can be compensated is MAXSTAGE  (5/4) ppm. 
Maximum possible value is 27h (39d). */
#define REG_MDMBCNTL2_INT_MAXSTAGE          0x0C0A0
#define REG_MDMBCNTL2_INT_MAXSTAGE_MASK     0x3f000000
#define REG_MDMBCNTL2_INT_MAXSTAGE_SHIFT    24
#define REG_MDMBCNTL2_INT_MAXSTAGE_WIDTH    6

/* MDMBSTAT0_REG_DCOFFSETI */
/* signed */
#define REG_MDMBSTAT0_REG_DCOFFSETI          0x0C0B0
#define REG_MDMBSTAT0_REG_DCOFFSETI_MASK     0x0000003f
#define REG_MDMBSTAT0_REG_DCOFFSETI_SHIFT    0
#define REG_MDMBSTAT0_REG_DCOFFSETI_WIDTH    6

/* MDMBSTAT0_REG_DCOFFSETQ */
/* signed */
#define REG_MDMBSTAT0_REG_DCOFFSETQ          0x0C0B0
#define REG_MDMBSTAT0_REG_DCOFFSETQ_MASK     0x00003f00
#define REG_MDMBSTAT0_REG_DCOFFSETQ_SHIFT    8
#define REG_MDMBSTAT0_REG_DCOFFSETQ_WIDTH    6

/* MDMBSTAT0_REG_EQSUMI */
/* It is used for AWGN channel detection. */
#define REG_MDMBSTAT0_REG_EQSUMI          0x0C0B0
#define REG_MDMBSTAT0_REG_EQSUMI_MASK     0x00ff0000
#define REG_MDMBSTAT0_REG_EQSUMI_SHIFT    16
#define REG_MDMBSTAT0_REG_EQSUMI_WIDTH    8

/* MDMBSTAT0_REG_EQSUMQ */
/* It is used for AWGN channel detection. */
#define REG_MDMBSTAT0_REG_EQSUMQ          0x0C0B0
#define REG_MDMBSTAT0_REG_EQSUMQ_MASK     0xff000000
#define REG_MDMBSTAT0_REG_EQSUMQ_SHIFT    24
#define REG_MDMBSTAT0_REG_EQSUMQ_WIDTH    8

/* MDMBSTAT1_REG_FREQOFFESTIM */
/* 0.7 x FREQOFFESTIM[7:0] = Estimated value in ppm. */
#define REG_MDMBSTAT1_REG_FREQOFFESTIM          0x0C0C0
#define REG_MDMBSTAT1_REG_FREQOFFESTIM_MASK     0x000000ff
#define REG_MDMBSTAT1_REG_FREQOFFESTIM_SHIFT    0
#define REG_MDMBSTAT1_REG_FREQOFFESTIM_WIDTH    8

/* MDMBSTAT1_REG_IQGAINESTIM */
/* Last Packet Gain Estimation */
#define REG_MDMBSTAT1_REG_IQGAINESTIM          0x0C0C0
#define REG_MDMBSTAT1_REG_IQGAINESTIM_MASK     0x00007f00
#define REG_MDMBSTAT1_REG_IQGAINESTIM_SHIFT    8
#define REG_MDMBSTAT1_REG_IQGAINESTIM_WIDTH    7

/* MDMBVERSION_INT_UPG */
/* Modem version upgrade number */
#define REG_MDMBVERSION_INT_UPG          0x0C0D0
#define REG_MDMBVERSION_INT_UPG_MASK     0x000000ff
#define REG_MDMBVERSION_INT_UPG_SHIFT    0
#define REG_MDMBVERSION_INT_UPG_WIDTH    8

/* MDMBVERSION_INT_REL */
/* Modem version release number */
#define REG_MDMBVERSION_INT_REL          0x0C0D0
#define REG_MDMBVERSION_INT_REL_MASK     0x0000ff00
#define REG_MDMBVERSION_INT_REL_SHIFT    8
#define REG_MDMBVERSION_INT_REL_WIDTH    8

/* MDMBVERSION_INT_BUILD */
/* Modem version build number */
#define REG_MDMBVERSION_INT_BUILD          0x0C0D0
#define REG_MDMBVERSION_INT_BUILD_MASK     0xffff0000
#define REG_MDMBVERSION_INT_BUILD_SHIFT    16
#define REG_MDMBVERSION_INT_BUILD_WIDTH    16

/* FRONTENDCTRL_INT_DCDISB */
/* disable the dc offset estimation  */
#define REG_FRONTENDCTRL_INT_DCDISB          0x0C0E0
#define REG_FRONTENDCTRL_INT_DCDISB_MASK     0x00000001
#define REG_FRONTENDCTRL_INT_DCDISB_SHIFT    0
#define REG_FRONTENDCTRL_INT_DCDISB_WIDTH    1

/* FRONTENDCTRL_INT_SCALDISB */
/* disable scaling */
#define REG_FRONTENDCTRL_INT_SCALDISB          0x0C0E0
#define REG_FRONTENDCTRL_INT_SCALDISB_MASK     0x00000002
#define REG_FRONTENDCTRL_INT_SCALDISB_SHIFT    1
#define REG_FRONTENDCTRL_INT_SCALDISB_WIDTH    1

/* FRONTENDCTRL_INT_MULTSCALDISB */
/* disable amplifier */
#define REG_FRONTENDCTRL_INT_MULTSCALDISB          0x0C0E0
#define REG_FRONTENDCTRL_INT_MULTSCALDISB_MASK     0x00000004
#define REG_FRONTENDCTRL_INT_MULTSCALDISB_SHIFT    2
#define REG_FRONTENDCTRL_INT_MULTSCALDISB_WIDTH    1

/* FRONTENDCTRL_INT_MULTSCAL */
/* explanation at part 5.4.2 of the Wild Modem DSSS-CCK Front End 44Mhz specifications */
#define REG_FRONTENDCTRL_INT_MULTSCAL          0x0C0E0
#define REG_FRONTENDCTRL_INT_MULTSCAL_MASK     0x000003f8
#define REG_FRONTENDCTRL_INT_MULTSCAL_SHIFT    3
#define REG_FRONTENDCTRL_INT_MULTSCAL_WIDTH    7

/* FRONTENDCTRL_INT_DCESTTIME */
/* choosing DC estimation time 2/6 us */
#define REG_FRONTENDCTRL_INT_DCESTTIME          0x0C0E0
#define REG_FRONTENDCTRL_INT_DCESTTIME_MASK     0x00000400
#define REG_FRONTENDCTRL_INT_DCESTTIME_SHIFT    10
#define REG_FRONTENDCTRL_INT_DCESTTIME_WIDTH    1
#endif 
