/*******************************************************************
*                                                                   
*  PHY_RXBE.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 12/03/2013  */

#ifndef PHY_RXBE_regs_H_FILE
#define PHY_RXBE_regs_H_FILE

/* PHY_RXBE_REG04_RXBE_TP_0_LOW_EN */
/* Enables local block input of a test plug: de-interleaver output */
#define REG_PHY_RXBE_REG04_RXBE_TP_0_LOW_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_0_LOW_EN_MASK     0x00000001
#define REG_PHY_RXBE_REG04_RXBE_TP_0_LOW_EN_SHIFT    0
#define REG_PHY_RXBE_REG04_RXBE_TP_0_LOW_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_0_MID_EN */
/* Enables local block input of a test plug: de-puncture output */
#define REG_PHY_RXBE_REG04_RXBE_TP_0_MID_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_0_MID_EN_MASK     0x00000002
#define REG_PHY_RXBE_REG04_RXBE_TP_0_MID_EN_SHIFT    1
#define REG_PHY_RXBE_REG04_RXBE_TP_0_MID_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_0_HIGH_EN */
/* Enables local block input of a test plug: viterbi output + LDPC output + de-scrambler output */
#define REG_PHY_RXBE_REG04_RXBE_TP_0_HIGH_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_0_HIGH_EN_MASK     0x00000004
#define REG_PHY_RXBE_REG04_RXBE_TP_0_HIGH_EN_SHIFT    2
#define REG_PHY_RXBE_REG04_RXBE_TP_0_HIGH_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_1_LOW_EN */
/* Enables local block input of a test plug: A-length, A-rate, N packet, Parity error */
#define REG_PHY_RXBE_REG04_RXBE_TP_1_LOW_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_1_LOW_EN_MASK     0x00000008
#define REG_PHY_RXBE_REG04_RXBE_TP_1_LOW_EN_SHIFT    3
#define REG_PHY_RXBE_REG04_RXBE_TP_1_LOW_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_1_MID_EN */
/* Enables local block input of a test plug: N-length, CB, FEC, CP, Aggregate. */
#define REG_PHY_RXBE_REG04_RXBE_TP_1_MID_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_1_MID_EN_MASK     0x00000010
#define REG_PHY_RXBE_REG04_RXBE_TP_1_MID_EN_SHIFT    4
#define REG_PHY_RXBE_REG04_RXBE_TP_1_MID_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_1_HIGH_EN */
/* Enables local block input of a test plug: rank, N-rate, constellation 1, constellation 2, scrambler init, CRC TX, CRC Error */
#define REG_PHY_RXBE_REG04_RXBE_TP_1_HIGH_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_1_HIGH_EN_MASK     0x00000020
#define REG_PHY_RXBE_REG04_RXBE_TP_1_HIGH_EN_SHIFT    5
#define REG_PHY_RXBE_REG04_RXBE_TP_1_HIGH_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_LDPC_LOW_EN */
/* Enables local block input of a test plug: LDPC */
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_LOW_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_LOW_EN_MASK     0x00000040
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_LOW_EN_SHIFT    6
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_LOW_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_2_LOW_EN */
/* Enables local block input of a test plug: Data out bits [23:0] */
#define REG_PHY_RXBE_REG04_RXBE_TP_2_LOW_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_2_LOW_EN_MASK     0x00000080
#define REG_PHY_RXBE_REG04_RXBE_TP_2_LOW_EN_SHIFT    7
#define REG_PHY_RXBE_REG04_RXBE_TP_2_LOW_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_2_MID_EN */
/* Enables local block input of a test plug: Packet length, Data out bits [31:24] */
#define REG_PHY_RXBE_REG04_RXBE_TP_2_MID_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_2_MID_EN_MASK     0x00000100
#define REG_PHY_RXBE_REG04_RXBE_TP_2_MID_EN_SHIFT    8
#define REG_PHY_RXBE_REG04_RXBE_TP_2_MID_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_2_HIGH_EN */
/* Enables local block input of a test plug: phy_pac_rx_data_valid, pac_phy_rx_phy_enable, phy_pac_rx_phy_ready, aggregate[4:0], packet rate [7:0] */
#define REG_PHY_RXBE_REG04_RXBE_TP_2_HIGH_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_2_HIGH_EN_MASK     0x00000200
#define REG_PHY_RXBE_REG04_RXBE_TP_2_HIGH_EN_SHIFT    9
#define REG_PHY_RXBE_REG04_RXBE_TP_2_HIGH_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_LDPC_MID_EN */
/* Enables local block input of a test plug: LDPC */
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_MID_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_MID_EN_MASK     0x00000400
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_MID_EN_SHIFT    10
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_MID_EN_WIDTH    1

/* PHY_RXBE_REG04_RXBE_TP_LDPC_HIGH_EN */
/* Enables local block input of a test plug: LDPC */
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_HIGH_EN          0x00010
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_HIGH_EN_MASK     0x00000800
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_HIGH_EN_SHIFT    11
#define REG_PHY_RXBE_REG04_RXBE_TP_LDPC_HIGH_EN_WIDTH    1

/* PHY_RXBE_REG04_TP_DEBUG_CNT_EN */
/* Enable local test Debug counter. This counter functions like as the first test plug set (low+mid+high) in the chain. */
#define REG_PHY_RXBE_REG04_TP_DEBUG_CNT_EN          0x00010
#define REG_PHY_RXBE_REG04_TP_DEBUG_CNT_EN_MASK     0x80000000
#define REG_PHY_RXBE_REG04_TP_DEBUG_CNT_EN_SHIFT    31
#define REG_PHY_RXBE_REG04_TP_DEBUG_CNT_EN_WIDTH    1

/* PHY_RXBE_REG07_TP_DEBUG_CLK2STRB */
/* Enable local test Debug counter. This counter functions like as the first test plug set (low+mid+high) in the chain. */
#define REG_PHY_RXBE_REG07_TP_DEBUG_CLK2STRB          0x0001C
#define REG_PHY_RXBE_REG07_TP_DEBUG_CLK2STRB_MASK     0x0000000f
#define REG_PHY_RXBE_REG07_TP_DEBUG_CLK2STRB_SHIFT    0
#define REG_PHY_RXBE_REG07_TP_DEBUG_CLK2STRB_WIDTH    4

/* PHY_RXBE_REG08_TP_LOW_MUX_CTRL */
/* tp_low_mux_ctrl
00 -gpio low = test bus low.
01 -gpio low = test bus mid.
10 -gpio low = test bus high */
#define REG_PHY_RXBE_REG08_TP_LOW_MUX_CTRL          0x00020
#define REG_PHY_RXBE_REG08_TP_LOW_MUX_CTRL_MASK     0x00000003
#define REG_PHY_RXBE_REG08_TP_LOW_MUX_CTRL_SHIFT    0
#define REG_PHY_RXBE_REG08_TP_LOW_MUX_CTRL_WIDTH    2

/* PHY_RXBE_REG08_TP_MID_MUX_CTRL */
/* tp_mid_mux_ctrl
00 -gpio mid = test bus low.
01 -gpio mid = test bus mid.
10 -gpio mid = test bus high */
#define REG_PHY_RXBE_REG08_TP_MID_MUX_CTRL          0x00020
#define REG_PHY_RXBE_REG08_TP_MID_MUX_CTRL_MASK     0x0000000C
#define REG_PHY_RXBE_REG08_TP_MID_MUX_CTRL_SHIFT    2
#define REG_PHY_RXBE_REG08_TP_MID_MUX_CTRL_WIDTH    2

/* PHY_RXBE_REG08_TP_HIGH_MUX_CTRL */
/* tp_high_mux_ctrl
00 -gpio high = test bus low.
01 -gpio high = test bus mid.
10 -gpio high = test bus high */
#define REG_PHY_RXBE_REG08_TP_HIGH_MUX_CTRL          0x00020
#define REG_PHY_RXBE_REG08_TP_HIGH_MUX_CTRL_MASK     0x00000030
#define REG_PHY_RXBE_REG08_TP_HIGH_MUX_CTRL_SHIFT    4
#define REG_PHY_RXBE_REG08_TP_HIGH_MUX_CTRL_WIDTH    2

/* PHY_RXBE_REG09_SPARE_FF_GCLK_BYPASS */
/* 1' - activate gclk. */
#define REG_PHY_RXBE_REG09_SPARE_FF_GCLK_BYPASS          0x00024
#define REG_PHY_RXBE_REG09_SPARE_FF_GCLK_BYPASS_MASK     0x0000ffff
#define REG_PHY_RXBE_REG09_SPARE_FF_GCLK_BYPASS_SHIFT    0
#define REG_PHY_RXBE_REG09_SPARE_FF_GCLK_BYPASS_WIDTH    16

/* PHY_RXBE_REG15_PHY_MAC_IF_TP_MODE */
/* 0' = trigger mode (a change in one of the signals is the strobe for the bus)
'1' = sample mode (signals are sampled at 40/80MHz strobe) */
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_MODE          0x00054
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_MODE_MASK     0x00000001
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_MODE_SHIFT    0
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_MODE_WIDTH    1

/* PHY_RXBE_REG15_PHY_MAC_IF_TP_RATE */
/* 0' = 40MHz tp strobe in sample mode
'1' = 80MHz tp strobe in sample mode */
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_RATE          0x00054
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_RATE_MASK     0x00000002
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_RATE_SHIFT    1
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_RATE_WIDTH    1

/* PHY_RXBE_REG15_PHY_MAC_IF_TP_STATUS */
/* 0' = data bus
'1' =status bus */
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_STATUS          0x00054
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_STATUS_MASK     0x00000004
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_STATUS_SHIFT    2
#define REG_PHY_RXBE_REG15_PHY_MAC_IF_TP_STATUS_WIDTH    1

/* PHY_RXBE_REG18_VITERBI_TB_DEPTH */
/* Viterbi decoder TB depth */
#define REG_PHY_RXBE_REG18_VITERBI_TB_DEPTH          0x00060
#define REG_PHY_RXBE_REG18_VITERBI_TB_DEPTH_MASK     0x0000003F
#define REG_PHY_RXBE_REG18_VITERBI_TB_DEPTH_SHIFT    0
#define REG_PHY_RXBE_REG18_VITERBI_TB_DEPTH_WIDTH    6

/* PHY_RXBE_REG19_REPORT_FULL_METRICS */
/* 0' = report basic metrics to the MAC
'1' = report full metrics to the MAC */
#define REG_PHY_RXBE_REG19_REPORT_FULL_METRICS          0x00064
#define REG_PHY_RXBE_REG19_REPORT_FULL_METRICS_MASK     0x00000001
#define REG_PHY_RXBE_REG19_REPORT_FULL_METRICS_SHIFT    0
#define REG_PHY_RXBE_REG19_REPORT_FULL_METRICS_WIDTH    1

/* PHY_RXBE_REG19_WAIT_FOR_GRISC_METRICS */
/* 0' = don't wait for gen risc metrics
'1' = wait for gen risc metrics */
#define REG_PHY_RXBE_REG19_WAIT_FOR_GRISC_METRICS          0x00064
#define REG_PHY_RXBE_REG19_WAIT_FOR_GRISC_METRICS_MASK     0x00000002
#define REG_PHY_RXBE_REG19_WAIT_FOR_GRISC_METRICS_SHIFT    1
#define REG_PHY_RXBE_REG19_WAIT_FOR_GRISC_METRICS_WIDTH    1

/* PHY_RXBE_REG19_WAIT_FOR_SNR_METRICS */
/* Wait for snr metrics
that comes from Hw before sending the Metrics */
#define REG_PHY_RXBE_REG19_WAIT_FOR_SNR_METRICS          0x00064
#define REG_PHY_RXBE_REG19_WAIT_FOR_SNR_METRICS_MASK     0x00000010
#define REG_PHY_RXBE_REG19_WAIT_FOR_SNR_METRICS_SHIFT    4
#define REG_PHY_RXBE_REG19_WAIT_FOR_SNR_METRICS_WIDTH    1

/* PHY_RXBE_REG1E_NUM_BITS_IN_PACKET */
/* Number of bits in the packet calculated by the last symbol block */
#define REG_PHY_RXBE_REG1E_NUM_BITS_IN_PACKET          0x00078
#define REG_PHY_RXBE_REG1E_NUM_BITS_IN_PACKET_MASK     0x01FFFFFF
#define REG_PHY_RXBE_REG1E_NUM_BITS_IN_PACKET_SHIFT    0
#define REG_PHY_RXBE_REG1E_NUM_BITS_IN_PACKET_WIDTH    25

/* PHY_RXBE_REG20_MAC_IF_MIN_CYCLE */
/* Min word cycle length in clock cycles */
#define REG_PHY_RXBE_REG20_MAC_IF_MIN_CYCLE          0x00080
#define REG_PHY_RXBE_REG20_MAC_IF_MIN_CYCLE_MASK     0x00FF0000
#define REG_PHY_RXBE_REG20_MAC_IF_MIN_CYCLE_SHIFT    16
#define REG_PHY_RXBE_REG20_MAC_IF_MIN_CYCLE_WIDTH    8

/* PHY_RXBE_REG21_PACKET_LIMIT */
/* Maximum number of erorrs allowed in a packet in order to add to error counter */
#define REG_PHY_RXBE_REG21_PACKET_LIMIT          0x00084
#define REG_PHY_RXBE_REG21_PACKET_LIMIT_MASK     0x0007FFFF
#define REG_PHY_RXBE_REG21_PACKET_LIMIT_SHIFT    0
#define REG_PHY_RXBE_REG21_PACKET_LIMIT_WIDTH    19

/* PHY_RXBE_REG22_PRBS_LOAD_VAL */
/* Init value for LFSR */
#define REG_PHY_RXBE_REG22_PRBS_LOAD_VAL          0x00088
#define REG_PHY_RXBE_REG22_PRBS_LOAD_VAL_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG22_PRBS_LOAD_VAL_SHIFT    0
#define REG_PHY_RXBE_REG22_PRBS_LOAD_VAL_WIDTH    32

/* PHY_RXBE_REG23_PRBS_CRC_ENABLE */
/* Enable PRBS Comparison */
#define REG_PHY_RXBE_REG23_PRBS_CRC_ENABLE          0x0008C
#define REG_PHY_RXBE_REG23_PRBS_CRC_ENABLE_MASK     0x00000001
#define REG_PHY_RXBE_REG23_PRBS_CRC_ENABLE_SHIFT    0
#define REG_PHY_RXBE_REG23_PRBS_CRC_ENABLE_WIDTH    1

/* PHY_RXBE_REG23_PACKET_WITH_CRC */
/* indication if the test packet got CRC */
#define REG_PHY_RXBE_REG23_PACKET_WITH_CRC          0x0008C
#define REG_PHY_RXBE_REG23_PACKET_WITH_CRC_MASK     0x00000002
#define REG_PHY_RXBE_REG23_PACKET_WITH_CRC_SHIFT    1
#define REG_PHY_RXBE_REG23_PACKET_WITH_CRC_WIDTH    1

/* PHY_RXBE_REG24_CLEAR_COUNTERS */
/* Clear all PRBS Counters */
#define REG_PHY_RXBE_REG24_CLEAR_COUNTERS          0x00090
#define REG_PHY_RXBE_REG24_CLEAR_COUNTERS_MASK     0x00000001
#define REG_PHY_RXBE_REG24_CLEAR_COUNTERS_SHIFT    0
#define REG_PHY_RXBE_REG24_CLEAR_COUNTERS_WIDTH    1

/* PHY_RXBE_REG25_LATCH_COUNTERS */
/* Latch all PRBS counters before reading them */
#define REG_PHY_RXBE_REG25_LATCH_COUNTERS          0x00094
#define REG_PHY_RXBE_REG25_LATCH_COUNTERS_MASK     0x00000001
#define REG_PHY_RXBE_REG25_LATCH_COUNTERS_SHIFT    0
#define REG_PHY_RXBE_REG25_LATCH_COUNTERS_WIDTH    1

/* PHY_RXBE_REG26_PRBS_TYPE */
/* PRBS Polynom type */
#define REG_PHY_RXBE_REG26_PRBS_TYPE          0x00098
#define REG_PHY_RXBE_REG26_PRBS_TYPE_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG26_PRBS_TYPE_SHIFT    0
#define REG_PHY_RXBE_REG26_PRBS_TYPE_WIDTH    32

/* PHY_RXBE_REG28_SIG_DECODE_CRC_LEN */
/* Signal CRC length */
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_LEN          0x000A0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_LEN_MASK     0x00000007
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_LEN_SHIFT    0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_LEN_WIDTH    3

/* PHY_RXBE_REG28_SIG_DECODE_CRC_TYPE */
/* Signal CRC type */
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_TYPE          0x000A0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_TYPE_MASK     0x00000FF0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_TYPE_SHIFT    4
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_TYPE_WIDTH    8

/* PHY_RXBE_REG28_SIG_DECODE_CRC_CORRUPT */
/* Signal CRC corrupt mode */
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_CORRUPT          0x000A0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_CORRUPT_MASK     0x00001000
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_CORRUPT_SHIFT    12
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_CORRUPT_WIDTH    1

/* PHY_RXBE_REG28_SIG_DECODE_CRC_INIT */
/* Signal CRC shift register init value */
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_INIT          0x000A0
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_INIT_MASK     0x00FF0000
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_INIT_SHIFT    16
#define REG_PHY_RXBE_REG28_SIG_DECODE_CRC_INIT_WIDTH    8

/* PHY_RXBE_REG29_SW_SIG1_RATE */
/* SW bypass of Signal 1 A packet Rate */
#define REG_PHY_RXBE_REG29_SW_SIG1_RATE          0x000A4
#define REG_PHY_RXBE_REG29_SW_SIG1_RATE_MASK     0x0000000F
#define REG_PHY_RXBE_REG29_SW_SIG1_RATE_SHIFT    0
#define REG_PHY_RXBE_REG29_SW_SIG1_RATE_WIDTH    4

/* PHY_RXBE_REG29_SW_SIG1_RESERVED */
/* SW bypass of Signal 1 reserved bit */
#define REG_PHY_RXBE_REG29_SW_SIG1_RESERVED          0x000A4
#define REG_PHY_RXBE_REG29_SW_SIG1_RESERVED_MASK     0x00000010
#define REG_PHY_RXBE_REG29_SW_SIG1_RESERVED_SHIFT    4
#define REG_PHY_RXBE_REG29_SW_SIG1_RESERVED_WIDTH    1

/* PHY_RXBE_REG29_SW_SIG1_LENGTH */
/* SW bypass of Signal 1 A packet length */
#define REG_PHY_RXBE_REG29_SW_SIG1_LENGTH          0x000A4
#define REG_PHY_RXBE_REG29_SW_SIG1_LENGTH_MASK     0x0001FFE0
#define REG_PHY_RXBE_REG29_SW_SIG1_LENGTH_SHIFT    5
#define REG_PHY_RXBE_REG29_SW_SIG1_LENGTH_WIDTH    12

/* PHY_RXBE_REG29_SW_SIG1_PARITY */
/* SW bypass of Signal 1 parity bit */
#define REG_PHY_RXBE_REG29_SW_SIG1_PARITY          0x000A4
#define REG_PHY_RXBE_REG29_SW_SIG1_PARITY_MASK     0x00020000
#define REG_PHY_RXBE_REG29_SW_SIG1_PARITY_SHIFT    17
#define REG_PHY_RXBE_REG29_SW_SIG1_PARITY_WIDTH    1

/* PHY_RXBE_REG2A_SW_SIG2_MCS */
/* SW bypass of Signal 2 MCS Field = Rate number */
#define REG_PHY_RXBE_REG2A_SW_SIG2_MCS          0x000A8
#define REG_PHY_RXBE_REG2A_SW_SIG2_MCS_MASK     0x0000007F
#define REG_PHY_RXBE_REG2A_SW_SIG2_MCS_SHIFT    0
#define REG_PHY_RXBE_REG2A_SW_SIG2_MCS_WIDTH    7

/* PHY_RXBE_REG2A_SW_SIG2_BW_20_40 */
/* SW bypass of Signal 2 BW_20_40 Field */
#define REG_PHY_RXBE_REG2A_SW_SIG2_BW_20_40          0x000A8
#define REG_PHY_RXBE_REG2A_SW_SIG2_BW_20_40_MASK     0x00000080
#define REG_PHY_RXBE_REG2A_SW_SIG2_BW_20_40_SHIFT    7
#define REG_PHY_RXBE_REG2A_SW_SIG2_BW_20_40_WIDTH    1

/* PHY_RXBE_REG2A_SW_SIG2_SIZE */
/* SW bypass of Signal 2 N packet size */
#define REG_PHY_RXBE_REG2A_SW_SIG2_SIZE          0x000A8
#define REG_PHY_RXBE_REG2A_SW_SIG2_SIZE_MASK     0x00FFFF00
#define REG_PHY_RXBE_REG2A_SW_SIG2_SIZE_SHIFT    8
#define REG_PHY_RXBE_REG2A_SW_SIG2_SIZE_WIDTH    16

/* PHY_RXBE_REG2B_SW_SIG3_SMOOTHING */
/* SW bypass of Signal 3 smoothing */
#define REG_PHY_RXBE_REG2B_SW_SIG3_SMOOTHING          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_SMOOTHING_MASK     0x00000001
#define REG_PHY_RXBE_REG2B_SW_SIG3_SMOOTHING_SHIFT    0
#define REG_PHY_RXBE_REG2B_SW_SIG3_SMOOTHING_WIDTH    1

/* PHY_RXBE_REG2B_SW_SIG3_SOUNDING */
/* SW bypass of Signal 3 sounding */
#define REG_PHY_RXBE_REG2B_SW_SIG3_SOUNDING          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_SOUNDING_MASK     0x00000002
#define REG_PHY_RXBE_REG2B_SW_SIG3_SOUNDING_SHIFT    1
#define REG_PHY_RXBE_REG2B_SW_SIG3_SOUNDING_WIDTH    1

/* PHY_RXBE_REG2B_SW_SIG3_AGGREGATION */
/* SW bypass of Signal 3 Aggregation */
#define REG_PHY_RXBE_REG2B_SW_SIG3_AGGREGATION          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_AGGREGATION_MASK     0x00000004
#define REG_PHY_RXBE_REG2B_SW_SIG3_AGGREGATION_SHIFT    2
#define REG_PHY_RXBE_REG2B_SW_SIG3_AGGREGATION_WIDTH    1

/* PHY_RXBE_REG2B_SW_SIG3_STBC */
/* SW bypass of Signal 3 STBC */
#define REG_PHY_RXBE_REG2B_SW_SIG3_STBC          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_STBC_MASK     0x00000018
#define REG_PHY_RXBE_REG2B_SW_SIG3_STBC_SHIFT    3
#define REG_PHY_RXBE_REG2B_SW_SIG3_STBC_WIDTH    2

/* PHY_RXBE_REG2B_SW_SIG3_FEC */
/* SW bypass of Signal 3 FEC mode (LDPC / Viterbi) */
#define REG_PHY_RXBE_REG2B_SW_SIG3_FEC          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_FEC_MASK     0x00000020
#define REG_PHY_RXBE_REG2B_SW_SIG3_FEC_SHIFT    5
#define REG_PHY_RXBE_REG2B_SW_SIG3_FEC_WIDTH    1

/* PHY_RXBE_REG2B_SW_SIG3_SHORT_GI */
/* SW bypass of Signal 3 short Cyclic prefix */
#define REG_PHY_RXBE_REG2B_SW_SIG3_SHORT_GI          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_SHORT_GI_MASK     0x00000040
#define REG_PHY_RXBE_REG2B_SW_SIG3_SHORT_GI_SHIFT    6
#define REG_PHY_RXBE_REG2B_SW_SIG3_SHORT_GI_WIDTH    1

/* PHY_RXBE_REG2B_SW_SIG3_NUM_HT_LTF */
/* SW bypass of Signal 3 number of additional HT-LTFs */
#define REG_PHY_RXBE_REG2B_SW_SIG3_NUM_HT_LTF          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_NUM_HT_LTF_MASK     0x00000180
#define REG_PHY_RXBE_REG2B_SW_SIG3_NUM_HT_LTF_SHIFT    7
#define REG_PHY_RXBE_REG2B_SW_SIG3_NUM_HT_LTF_WIDTH    2

/* PHY_RXBE_REG2B_SW_SIG3_CRC */
/* SW bypass of Signal 3 CRC on packet header */
#define REG_PHY_RXBE_REG2B_SW_SIG3_CRC          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_CRC_MASK     0x0001FE00
#define REG_PHY_RXBE_REG2B_SW_SIG3_CRC_SHIFT    9
#define REG_PHY_RXBE_REG2B_SW_SIG3_CRC_WIDTH    8

/* PHY_RXBE_REG2B_SW_SIG3_RESERVED */
/* SW bypass of Signal 3 reserved bit */
#define REG_PHY_RXBE_REG2B_SW_SIG3_RESERVED          0x000AC
#define REG_PHY_RXBE_REG2B_SW_SIG3_RESERVED_MASK     0x00020000
#define REG_PHY_RXBE_REG2B_SW_SIG3_RESERVED_SHIFT    17
#define REG_PHY_RXBE_REG2B_SW_SIG3_RESERVED_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG1_RATE */
/* Enable SW bypass of Signal 1 A packet Rate */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RATE          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RATE_MASK     0x00000001
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RATE_SHIFT    0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RATE_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG1_RESERVED */
/* Enable SW bypass of Signal 1 reserved bit */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RESERVED          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RESERVED_MASK     0x00000002
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RESERVED_SHIFT    1
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_RESERVED_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG1_LENGTH */
/* Enable SW bypass of Signal 1 A packet length */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_LENGTH          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_LENGTH_MASK     0x00000004
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_LENGTH_SHIFT    2
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_LENGTH_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG1_PARITY */
/* Enable SW bypass of Signal 1 parity bit */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_PARITY          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_PARITY_MASK     0x00000008
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_PARITY_SHIFT    3
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG1_PARITY_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG2_MCS */
/* Enable SW bypass of Signal 2 MCS */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_MCS          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_MCS_MASK     0x00000010
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_MCS_SHIFT    4
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_MCS_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG2_BW_20_40 */
/* Enable SW bypass of Signal 2 BW_20_40 */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_BW_20_40          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_BW_20_40_MASK     0x00000020
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_BW_20_40_SHIFT    5
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_BW_20_40_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG2_SIZE */
/* Enable SW bypass of Signal 2 N packet size */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_SIZE          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_SIZE_MASK     0x00000040
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_SIZE_SHIFT    6
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG2_SIZE_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_SMOOTHING */
/* Enable SW bypass of Signal 3 smoothing */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SMOOTHING          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SMOOTHING_MASK     0x00000080
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SMOOTHING_SHIFT    7
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SMOOTHING_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_SOUNDING */
/* Enable SW bypass of Signal 3 sounding */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SOUNDING          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SOUNDING_MASK     0x00000100
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SOUNDING_SHIFT    8
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SOUNDING_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_AGGREGATION */
/* Enable SW bypass of Signal 3 aggregation */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_AGGREGATION          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_AGGREGATION_MASK     0x00000200
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_AGGREGATION_SHIFT    9
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_AGGREGATION_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_STBC */
/* Enable SW bypass of Signal 3 stbc */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_STBC          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_STBC_MASK     0x00000400
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_STBC_SHIFT    10
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_STBC_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_FEC */
/* Enable SW bypass of Signal 3 FEC mode (LDPC / Viterbi) */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_FEC          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_FEC_MASK     0x00000800
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_FEC_SHIFT    11
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_FEC_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_SHORT_GI */
/* Enable SW bypass of Signal 3 short Cyclic prefix */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SHORT_GI          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SHORT_GI_MASK     0x00001000
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SHORT_GI_SHIFT    12
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_SHORT_GI_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_NUM_HT_LTF */
/* Enable SW bypass of Signal 3 num HT-LTF */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_NUM_HT_LTF          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_NUM_HT_LTF_MASK     0x00002000
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_NUM_HT_LTF_SHIFT    13
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_NUM_HT_LTF_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_CRC */
/* Enable SW bypass of Signal 3 CRC on packet header */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_CRC          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_CRC_MASK     0x00004000
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_CRC_SHIFT    14
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_CRC_WIDTH    1

/* PHY_RXBE_REG2C_SW_BYPS_SIG3_RESERVED */
/* Enable SW bypass of Signal 3 reserved bit */
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_RESERVED          0x000B0
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_RESERVED_MASK     0x00008000
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_RESERVED_SHIFT    15
#define REG_PHY_RXBE_REG2C_SW_BYPS_SIG3_RESERVED_WIDTH    1

/* PHY_RXBE_REG34_PRBS_ERR_CNT_LATCHED */
/* Number of PRBS Errors in comparison count - latched */
#define REG_PHY_RXBE_REG34_PRBS_ERR_CNT_LATCHED          0x000D0
#define REG_PHY_RXBE_REG34_PRBS_ERR_CNT_LATCHED_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG34_PRBS_ERR_CNT_LATCHED_SHIFT    0
#define REG_PHY_RXBE_REG34_PRBS_ERR_CNT_LATCHED_WIDTH    32

/* PHY_RXBE_REG35_PRBS_BIT_CNT_LATCHED_31_0 */
/* Number of bits in PRBS comparison count - latched */
#define REG_PHY_RXBE_REG35_PRBS_BIT_CNT_LATCHED_31_0          0x000D4
#define REG_PHY_RXBE_REG35_PRBS_BIT_CNT_LATCHED_31_0_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG35_PRBS_BIT_CNT_LATCHED_31_0_SHIFT    0
#define REG_PHY_RXBE_REG35_PRBS_BIT_CNT_LATCHED_31_0_WIDTH    32

/* PHY_RXBE_REG36_PRBS_BIT_CNT_LATCHED_47_32 */
/* Number of bits in PRBS comparison count - latched */
#define REG_PHY_RXBE_REG36_PRBS_BIT_CNT_LATCHED_47_32          0x000D8
#define REG_PHY_RXBE_REG36_PRBS_BIT_CNT_LATCHED_47_32_MASK     0x0000FFFF
#define REG_PHY_RXBE_REG36_PRBS_BIT_CNT_LATCHED_47_32_SHIFT    0
#define REG_PHY_RXBE_REG36_PRBS_BIT_CNT_LATCHED_47_32_WIDTH    16

/* PHY_RXBE_REG37_CRC_PACKET_CNT_LATCHED */
/* Number of compared packets - latched */
#define REG_PHY_RXBE_REG37_CRC_PACKET_CNT_LATCHED          0x000DC
#define REG_PHY_RXBE_REG37_CRC_PACKET_CNT_LATCHED_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG37_CRC_PACKET_CNT_LATCHED_SHIFT    0
#define REG_PHY_RXBE_REG37_CRC_PACKET_CNT_LATCHED_WIDTH    32

/* PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED */
/* Number of compared errored packets with CRC error - latched */
#define REG_PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED          0x000E0
#define REG_PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED_SHIFT    0
#define REG_PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED_WIDTH    32

/* PHY_RXBE_REG39_PRBS_ERR_PACKET_CNT_LATCHED */
/* Number of compared errored packets with PRBS error - latched */
#define REG_PHY_RXBE_REG39_PRBS_ERR_PACKET_CNT_LATCHED          0x000E4
#define REG_PHY_RXBE_REG39_PRBS_ERR_PACKET_CNT_LATCHED_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG39_PRBS_ERR_PACKET_CNT_LATCHED_SHIFT    0
#define REG_PHY_RXBE_REG39_PRBS_ERR_PACKET_CNT_LATCHED_WIDTH    32

/* PHY_RXBE_REG3C_BIST_DONE */
/* BIST done */
#define REG_PHY_RXBE_REG3C_BIST_DONE          0x000F0
#define REG_PHY_RXBE_REG3C_BIST_DONE_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG3C_BIST_DONE_SHIFT    0
#define REG_PHY_RXBE_REG3C_BIST_DONE_WIDTH    32

/* PHY_RXBE_REG3E_BIST_RESULT */
/* BIST result */
#define REG_PHY_RXBE_REG3E_BIST_RESULT          0x000F8
#define REG_PHY_RXBE_REG3E_BIST_RESULT_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG3E_BIST_RESULT_SHIFT    0
#define REG_PHY_RXBE_REG3E_BIST_RESULT_WIDTH    32

/* PHY_RXBE_REG3F_SW_BIST_START */
/* BIST start */
#define REG_PHY_RXBE_REG3F_SW_BIST_START          0x000FC
#define REG_PHY_RXBE_REG3F_SW_BIST_START_MASK     0x00000001
#define REG_PHY_RXBE_REG3F_SW_BIST_START_SHIFT    0
#define REG_PHY_RXBE_REG3F_SW_BIST_START_WIDTH    1

/* PHY_RXBE_REG3F_CLEAR_RAM_MODE */
/* 1' - activating BIST will clear the RAMs. */
#define REG_PHY_RXBE_REG3F_CLEAR_RAM_MODE          0x000FC
#define REG_PHY_RXBE_REG3F_CLEAR_RAM_MODE_MASK     0x00000002
#define REG_PHY_RXBE_REG3F_CLEAR_RAM_MODE_SHIFT    1
#define REG_PHY_RXBE_REG3F_CLEAR_RAM_MODE_WIDTH    1

/* PHY_RXBE_REG41_RXBE_MASK_PARITY_ERR */
/* Mask parity error in signal 1 */
#define REG_PHY_RXBE_REG41_RXBE_MASK_PARITY_ERR          0x00104
#define REG_PHY_RXBE_REG41_RXBE_MASK_PARITY_ERR_MASK     0x00000001
#define REG_PHY_RXBE_REG41_RXBE_MASK_PARITY_ERR_SHIFT    0
#define REG_PHY_RXBE_REG41_RXBE_MASK_PARITY_ERR_WIDTH    1

/* PHY_RXBE_REG41_RXBE_MASK_RATE_ERR */
/* Mask invalid rate error in signal 1 - when the rate is not one of the 8 valid rates */
#define REG_PHY_RXBE_REG41_RXBE_MASK_RATE_ERR          0x00104
#define REG_PHY_RXBE_REG41_RXBE_MASK_RATE_ERR_MASK     0x00000002
#define REG_PHY_RXBE_REG41_RXBE_MASK_RATE_ERR_SHIFT    1
#define REG_PHY_RXBE_REG41_RXBE_MASK_RATE_ERR_WIDTH    1

/* PHY_RXBE_REG41_RXBE_MASK_P_SIZE_ERR */
/* Mask packet size error in signal 1 - when the packet size is smaller than the minimum value */
#define REG_PHY_RXBE_REG41_RXBE_MASK_P_SIZE_ERR          0x00104
#define REG_PHY_RXBE_REG41_RXBE_MASK_P_SIZE_ERR_MASK     0x00000004
#define REG_PHY_RXBE_REG41_RXBE_MASK_P_SIZE_ERR_SHIFT    2
#define REG_PHY_RXBE_REG41_RXBE_MASK_P_SIZE_ERR_WIDTH    1

/* PHY_RXBE_REG41_RXBE_MASK_RESERVED_ERR */
/* Mask reserved bit error in signal 1 - when mode reserved bit is not zero */
#define REG_PHY_RXBE_REG41_RXBE_MASK_RESERVED_ERR          0x00104
#define REG_PHY_RXBE_REG41_RXBE_MASK_RESERVED_ERR_MASK     0x00000008
#define REG_PHY_RXBE_REG41_RXBE_MASK_RESERVED_ERR_SHIFT    3
#define REG_PHY_RXBE_REG41_RXBE_MASK_RESERVED_ERR_WIDTH    1

/* PHY_RXBE_REG41_RXBE_MASK_CRC_ERR */
/* Mask bad CRC error in signal 3 */
#define REG_PHY_RXBE_REG41_RXBE_MASK_CRC_ERR          0x00104
#define REG_PHY_RXBE_REG41_RXBE_MASK_CRC_ERR_MASK     0x00000010
#define REG_PHY_RXBE_REG41_RXBE_MASK_CRC_ERR_SHIFT    4
#define REG_PHY_RXBE_REG41_RXBE_MASK_CRC_ERR_WIDTH    1

/* PHY_RXBE_REG42_MINIMUM_PACKET_SIZE */
/* Minimum packet size in bytes */
#define REG_PHY_RXBE_REG42_MINIMUM_PACKET_SIZE          0x00108
#define REG_PHY_RXBE_REG42_MINIMUM_PACKET_SIZE_MASK     0x00000FFF
#define REG_PHY_RXBE_REG42_MINIMUM_PACKET_SIZE_SHIFT    0
#define REG_PHY_RXBE_REG42_MINIMUM_PACKET_SIZE_WIDTH    12

/* PHY_RXBE_REG4A_PRBS_ERR_CNT */
/* Number of PRBS Errors in comparison count - real time */
#define REG_PHY_RXBE_REG4A_PRBS_ERR_CNT          0x00128
#define REG_PHY_RXBE_REG4A_PRBS_ERR_CNT_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG4A_PRBS_ERR_CNT_SHIFT    0
#define REG_PHY_RXBE_REG4A_PRBS_ERR_CNT_WIDTH    32

/* PHY_RXBE_REG4B_PRBS_BIT_CNT_31_0 */
/* Number of bits in PRBS comparison count - real time */
#define REG_PHY_RXBE_REG4B_PRBS_BIT_CNT_31_0          0x0012C
#define REG_PHY_RXBE_REG4B_PRBS_BIT_CNT_31_0_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG4B_PRBS_BIT_CNT_31_0_SHIFT    0
#define REG_PHY_RXBE_REG4B_PRBS_BIT_CNT_31_0_WIDTH    32

/* PHY_RXBE_REG4C_PRBS_BIT_CNT_47_32 */
/* Number of bits in PRBS comparison count - real time */
#define REG_PHY_RXBE_REG4C_PRBS_BIT_CNT_47_32          0x00130
#define REG_PHY_RXBE_REG4C_PRBS_BIT_CNT_47_32_MASK     0x0000FFFF
#define REG_PHY_RXBE_REG4C_PRBS_BIT_CNT_47_32_SHIFT    0
#define REG_PHY_RXBE_REG4C_PRBS_BIT_CNT_47_32_WIDTH    16

/* PHY_RXBE_REG4D_CRC_PACKET_CNT */
/* Number of compared packets - real time */
#define REG_PHY_RXBE_REG4D_CRC_PACKET_CNT          0x00134
#define REG_PHY_RXBE_REG4D_CRC_PACKET_CNT_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG4D_CRC_PACKET_CNT_SHIFT    0
#define REG_PHY_RXBE_REG4D_CRC_PACKET_CNT_WIDTH    32

/* PHY_RXBE_REG4E_CRC_ERR_PACKET_CNT */
/* Number of compared errored packets with CRC error - real time */
#define REG_PHY_RXBE_REG4E_CRC_ERR_PACKET_CNT          0x00138
#define REG_PHY_RXBE_REG4E_CRC_ERR_PACKET_CNT_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG4E_CRC_ERR_PACKET_CNT_SHIFT    0
#define REG_PHY_RXBE_REG4E_CRC_ERR_PACKET_CNT_WIDTH    32

/* PHY_RXBE_REG4F_PRBS_ERR_PACKET_CNT */
/* Number of compared errored packets with PRBS error - real time */
#define REG_PHY_RXBE_REG4F_PRBS_ERR_PACKET_CNT          0x0013C
#define REG_PHY_RXBE_REG4F_PRBS_ERR_PACKET_CNT_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG4F_PRBS_ERR_PACKET_CNT_SHIFT    0
#define REG_PHY_RXBE_REG4F_PRBS_ERR_PACKET_CNT_WIDTH    32

/* PHY_RXBE_REG50_PHY_MAC_IF_BIT_COUNTER */
/* Phy MAC IF bit counter */
#define REG_PHY_RXBE_REG50_PHY_MAC_IF_BIT_COUNTER          0x00140
#define REG_PHY_RXBE_REG50_PHY_MAC_IF_BIT_COUNTER_MASK     0x0007FFFF
#define REG_PHY_RXBE_REG50_PHY_MAC_IF_BIT_COUNTER_SHIFT    0
#define REG_PHY_RXBE_REG50_PHY_MAC_IF_BIT_COUNTER_WIDTH    19

/* PHY_RXBE_REG51_HYP_RXBE_GPO */
/* RxBE general purpose output */
#define REG_PHY_RXBE_REG51_HYP_RXBE_GPO          0x00144
#define REG_PHY_RXBE_REG51_HYP_RXBE_GPO_MASK     0x0000FFFF
#define REG_PHY_RXBE_REG51_HYP_RXBE_GPO_SHIFT    0
#define REG_PHY_RXBE_REG51_HYP_RXBE_GPO_WIDTH    16

/* PHY_RXBE_REG52_HYP_RXBE_GPR */
/* RxBE general purpose register */
#define REG_PHY_RXBE_REG52_HYP_RXBE_GPR          0x00148
#define REG_PHY_RXBE_REG52_HYP_RXBE_GPR_MASK     0xFFFFFFFF
#define REG_PHY_RXBE_REG52_HYP_RXBE_GPR_SHIFT    0
#define REG_PHY_RXBE_REG52_HYP_RXBE_GPR_WIDTH    32

/* PHY_RXBE_REG53_HYP_RXBE_GPI */
/* RxBE general purpose input */
#define REG_PHY_RXBE_REG53_HYP_RXBE_GPI          0x0014C
#define REG_PHY_RXBE_REG53_HYP_RXBE_GPI_MASK     0x0000FFFF
#define REG_PHY_RXBE_REG53_HYP_RXBE_GPI_SHIFT    0
#define REG_PHY_RXBE_REG53_HYP_RXBE_GPI_WIDTH    16

/* PHY_RXBE_REG54_HYP_RXBE_GPI2 */
/* RxBE general purpose input 2 */
#define REG_PHY_RXBE_REG54_HYP_RXBE_GPI2          0x00150
#define REG_PHY_RXBE_REG54_HYP_RXBE_GPI2_MASK     0x0000FFFF
#define REG_PHY_RXBE_REG54_HYP_RXBE_GPI2_SHIFT    0
#define REG_PHY_RXBE_REG54_HYP_RXBE_GPI2_WIDTH    16

/* PHY_RXBE_REG55_DEINT_A0_RM */
/* deint_a0_rm */
#define REG_PHY_RXBE_REG55_DEINT_A0_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_A0_RM_MASK     0x00000007
#define REG_PHY_RXBE_REG55_DEINT_A0_RM_SHIFT    0
#define REG_PHY_RXBE_REG55_DEINT_A0_RM_WIDTH    3

/* PHY_RXBE_REG55_DEINT_A1_RM */
/* deint_a1_rm */
#define REG_PHY_RXBE_REG55_DEINT_A1_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_A1_RM_MASK     0x00000070
#define REG_PHY_RXBE_REG55_DEINT_A1_RM_SHIFT    4
#define REG_PHY_RXBE_REG55_DEINT_A1_RM_WIDTH    3

/* PHY_RXBE_REG55_DEINT_A2_RM */
/* deint_a2_rm */
#define REG_PHY_RXBE_REG55_DEINT_A2_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_A2_RM_MASK     0x00000700
#define REG_PHY_RXBE_REG55_DEINT_A2_RM_SHIFT    8
#define REG_PHY_RXBE_REG55_DEINT_A2_RM_WIDTH    3

/* PHY_RXBE_REG55_DEINT_B0_RM */
/* deint_b0_rm */
#define REG_PHY_RXBE_REG55_DEINT_B0_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_B0_RM_MASK     0x00007000
#define REG_PHY_RXBE_REG55_DEINT_B0_RM_SHIFT    12
#define REG_PHY_RXBE_REG55_DEINT_B0_RM_WIDTH    3

/* PHY_RXBE_REG55_DEINT_B1_RM */
/* deint_b1_rm */
#define REG_PHY_RXBE_REG55_DEINT_B1_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_B1_RM_MASK     0x00070000
#define REG_PHY_RXBE_REG55_DEINT_B1_RM_SHIFT    16
#define REG_PHY_RXBE_REG55_DEINT_B1_RM_WIDTH    3

/* PHY_RXBE_REG55_DEINT_B2_RM */
/* deint_b2_rm */
#define REG_PHY_RXBE_REG55_DEINT_B2_RM          0x00154
#define REG_PHY_RXBE_REG55_DEINT_B2_RM_MASK     0x00700000
#define REG_PHY_RXBE_REG55_DEINT_B2_RM_SHIFT    20
#define REG_PHY_RXBE_REG55_DEINT_B2_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U96X128B_0_RM */
/* merged_u96x128b_0_rm */
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_0_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_0_RM_MASK     0x00000007
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_0_RM_SHIFT    0
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_0_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U96X128B_1_RM */
/* merged_u96x128b_1_rm */
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_1_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_1_RM_MASK     0x00000070
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_1_RM_SHIFT    4
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_1_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U96X128B_2_RM */
/* merged_u96x128b_2_rm */
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_2_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_2_RM_MASK     0x00000700
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_2_RM_SHIFT    8
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_2_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U96X128B_3_RM */
/* merged_u96x128b_3_rm */
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_3_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_3_RM_MASK     0x00007000
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_3_RM_SHIFT    12
#define REG_PHY_RXBE_REG56_MERGED_U96X128B_3_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U8X128B_0_RM */
/* merged_u8x128b_0_rm */
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_0_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_0_RM_MASK     0x00070000
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_0_RM_SHIFT    16
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_0_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U8X128B_1_RM */
/* merged_u8x128b_1_rm */
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_1_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_1_RM_MASK     0x00700000
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_1_RM_SHIFT    20
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_1_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U8X128B_2_RM */
/* merged_u8x128b_2_rm */
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_2_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_2_RM_MASK     0x07000000
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_2_RM_SHIFT    24
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_2_RM_WIDTH    3

/* PHY_RXBE_REG56_MERGED_U8X128B_3_RM */
/* merged_u8x128b_3_rm */
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_3_RM          0x00158
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_3_RM_MASK     0x70000000
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_3_RM_SHIFT    28
#define REG_PHY_RXBE_REG56_MERGED_U8X128B_3_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_0_RM */
/* merged_u32x128b_0_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_0_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_0_RM_MASK     0x00000007
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_0_RM_SHIFT    0
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_0_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_1_RM */
/* merged_u32x128b_1_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_1_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_1_RM_MASK     0x00000070
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_1_RM_SHIFT    4
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_1_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_2_RM */
/* merged_u32x128b_2_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_2_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_2_RM_MASK     0x00000700
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_2_RM_SHIFT    8
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_2_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_3_RM */
/* merged_u32x128b_3_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_3_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_3_RM_MASK     0x00007000
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_3_RM_SHIFT    12
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_3_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_4_RM */
/* merged_u32x128b_4_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_4_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_4_RM_MASK     0x00070000
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_4_RM_SHIFT    16
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_4_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_5_RM */
/* merged_u32x128b_5_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_5_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_5_RM_MASK     0x00700000
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_5_RM_SHIFT    20
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_5_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_6_RM */
/* merged_u32x128b_6_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_6_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_6_RM_MASK     0x07000000
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_6_RM_SHIFT    24
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_6_RM_WIDTH    3

/* PHY_RXBE_REG57_MERGED_U32X128B_7_RM */
/* merged_u32x128b_7_rm */
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_7_RM          0x0015C
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_7_RM_MASK     0x70000000
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_7_RM_SHIFT    28
#define REG_PHY_RXBE_REG57_MERGED_U32X128B_7_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_8_RM */
/* merged_u32x128b_8_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_8_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_8_RM_MASK     0x00000007
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_8_RM_SHIFT    0
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_8_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_9_RM */
/* merged_u32x128b_9_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_9_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_9_RM_MASK     0x00000070
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_9_RM_SHIFT    4
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_9_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_A_RM */
/* merged_u32x128b_a_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_A_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_A_RM_MASK     0x00000700
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_A_RM_SHIFT    8
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_A_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_B_RM */
/* merged_u32x128b_b_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_B_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_B_RM_MASK     0x00007000
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_B_RM_SHIFT    12
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_B_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_C_RM */
/* merged_u32x128b_c_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_C_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_C_RM_MASK     0x00070000
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_C_RM_SHIFT    16
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_C_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_D_RM */
/* merged_u32x128b_d_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_D_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_D_RM_MASK     0x00700000
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_D_RM_SHIFT    20
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_D_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_E_RM */
/* merged_u32x128b_e_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_E_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_E_RM_MASK     0x07000000
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_E_RM_SHIFT    24
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_E_RM_WIDTH    3

/* PHY_RXBE_REG58_MERGED_U32X128B_F_RM */
/* merged_u32x128b_f_rm */
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_F_RM          0x00160
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_F_RM_MASK     0x70000000
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_F_RM_SHIFT    28
#define REG_PHY_RXBE_REG58_MERGED_U32X128B_F_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U32X128B_10_RM */
/* merged_u32x128b_10_rm */
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_10_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_10_RM_MASK     0x00000007
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_10_RM_SHIFT    0
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_10_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U32X128B_11_RM */
/* merged_u32x128b_11_rm */
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_11_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_11_RM_MASK     0x00000070
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_11_RM_SHIFT    4
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_11_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U32X128B_12_RM */
/* merged_u32x128b_12_rm */
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_12_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_12_RM_MASK     0x00000700
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_12_RM_SHIFT    8
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_12_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U32X128B_13_RM */
/* merged_u32x128b_13_rm */
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_13_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_13_RM_MASK     0x00007000
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_13_RM_SHIFT    12
#define REG_PHY_RXBE_REG59_MERGED_U32X128B_13_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U24X64B_0_RM */
/* merged_u24x64b_0_rm */
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_0_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_0_RM_MASK     0x00070000
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_0_RM_SHIFT    16
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_0_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U24X64B_1_RM */
/* merged_u24x64b_1_rm */
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_1_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_1_RM_MASK     0x00700000
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_1_RM_SHIFT    20
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_1_RM_WIDTH    3

/* PHY_RXBE_REG59_MERGED_U24X64B_2_RM */
/* merged_u24x64b_2_rm */
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_2_RM          0x00164
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_2_RM_MASK     0x07000000
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_2_RM_SHIFT    24
#define REG_PHY_RXBE_REG59_MERGED_U24X64B_2_RM_WIDTH    3

/* PHY_RXBE_REG5A_BIST_DONE_HIGH */
/* BIST high done */
#define REG_PHY_RXBE_REG5A_BIST_DONE_HIGH          0x00168
#define REG_PHY_RXBE_REG5A_BIST_DONE_HIGH_MASK     0x0000001F
#define REG_PHY_RXBE_REG5A_BIST_DONE_HIGH_SHIFT    0
#define REG_PHY_RXBE_REG5A_BIST_DONE_HIGH_WIDTH    5

/* PHY_RXBE_REG5B_BIST_RESULT_HIGH */
/* BIST high result */
#define REG_PHY_RXBE_REG5B_BIST_RESULT_HIGH          0x0016C
#define REG_PHY_RXBE_REG5B_BIST_RESULT_HIGH_MASK     0x0000001F
#define REG_PHY_RXBE_REG5B_BIST_RESULT_HIGH_SHIFT    0
#define REG_PHY_RXBE_REG5B_BIST_RESULT_HIGH_WIDTH    5

/* PHY_RXBE_REG5D_GCLK_SHUTDOWN_EN */
/* gclk shutdown - when '1' clocks will be always deactive */
#define REG_PHY_RXBE_REG5D_GCLK_SHUTDOWN_EN          0x00174
#define REG_PHY_RXBE_REG5D_GCLK_SHUTDOWN_EN_MASK     0x00003fff
#define REG_PHY_RXBE_REG5D_GCLK_SHUTDOWN_EN_SHIFT    0
#define REG_PHY_RXBE_REG5D_GCLK_SHUTDOWN_EN_WIDTH    14

/* PHY_RXBE_REG5E_BIST_SCR_BYPASS */
/* bist_scr_bypass */
#define REG_PHY_RXBE_REG5E_BIST_SCR_BYPASS          0x00178
#define REG_PHY_RXBE_REG5E_BIST_SCR_BYPASS_MASK     0x00000001
#define REG_PHY_RXBE_REG5E_BIST_SCR_BYPASS_SHIFT    0
#define REG_PHY_RXBE_REG5E_BIST_SCR_BYPASS_WIDTH    1

/* PHY_RXBE_REG5E_RAM_TEST_MODE */
/* ram_test_mode */
#define REG_PHY_RXBE_REG5E_RAM_TEST_MODE          0x00178
#define REG_PHY_RXBE_REG5E_RAM_TEST_MODE_MASK     0x00000002
#define REG_PHY_RXBE_REG5E_RAM_TEST_MODE_SHIFT    1
#define REG_PHY_RXBE_REG5E_RAM_TEST_MODE_WIDTH    1

/* PHY_RXBE_REG5E_MEM_GLOBAL_RM */
/* mem_global_rm */
#define REG_PHY_RXBE_REG5E_MEM_GLOBAL_RM          0x00178
#define REG_PHY_RXBE_REG5E_MEM_GLOBAL_RM_MASK     0x0000000c
#define REG_PHY_RXBE_REG5E_MEM_GLOBAL_RM_SHIFT    2
#define REG_PHY_RXBE_REG5E_MEM_GLOBAL_RM_WIDTH    2

/* PHY_RXBE_REG60_LDPC_MAX_ITER_0_2 */
/* ldpc_max_iter cw 0 rate 1/2 */
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_2          0x00180
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_2_MASK     0x000000ff
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_2_SHIFT    0
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_2_WIDTH    8

/* PHY_RXBE_REG60_LDPC_MAX_ITER_0_1 */
/* ldpc_max_iter cw 0 rate 2/3 */
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_1          0x00180
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_1_MASK     0x0000ff00
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_1_SHIFT    8
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_1_WIDTH    8

/* PHY_RXBE_REG60_LDPC_MAX_ITER_0_0 */
/* ldpc_max_iter cw 0 rate 3/4 */
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_0          0x00180
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_0_MASK     0x00ff0000
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_0_SHIFT    16
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_0_WIDTH    8

/* PHY_RXBE_REG60_LDPC_MAX_ITER_0_3 */
/* ldpc_max_iter cw 0 rate 5/6 */
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_3          0x00180
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_3_MASK     0xff000000
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_3_SHIFT    24
#define REG_PHY_RXBE_REG60_LDPC_MAX_ITER_0_3_WIDTH    8

/* PHY_RXBE_REG61_LDPC_MAX_ITER_1_2 */
/* ldpc_max_iter cw 1 rate 1/2 */
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_2          0x00184
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_2_MASK     0x000000ff
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_2_SHIFT    0
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_2_WIDTH    8

/* PHY_RXBE_REG61_LDPC_MAX_ITER_1_1 */
/* ldpc_max_iter cw 1 rate 2/3 */
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_1          0x00184
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_1_MASK     0x0000ff00
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_1_SHIFT    8
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_1_WIDTH    8

/* PHY_RXBE_REG61_LDPC_MAX_ITER_1_0 */
/* ldpc_max_iter cw 1 rate 3/4 */
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_0          0x00184
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_0_MASK     0x00ff0000
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_0_SHIFT    16
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_0_WIDTH    8

/* PHY_RXBE_REG61_LDPC_MAX_ITER_1_3 */
/* ldpc_max_iter cw 1 rate 5/6 */
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_3          0x00184
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_3_MASK     0xff000000
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_3_SHIFT    24
#define REG_PHY_RXBE_REG61_LDPC_MAX_ITER_1_3_WIDTH    8

/* PHY_RXBE_REG62_LDPC_MAX_ITER_2_2 */
/* ldpc_max_iter cw 2 rate 1/2 */
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_2          0x00188
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_2_MASK     0x000000ff
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_2_SHIFT    0
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_2_WIDTH    8

/* PHY_RXBE_REG62_LDPC_MAX_ITER_2_1 */
/* ldpc_max_iter cw 2 rate 2/3 */
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_1          0x00188
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_1_MASK     0x0000ff00
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_1_SHIFT    8
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_1_WIDTH    8

/* PHY_RXBE_REG62_LDPC_MAX_ITER_2_0 */
/* ldpc_max_iter cw 2 rate 3/4 */
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_0          0x00188
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_0_MASK     0x00ff0000
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_0_SHIFT    16
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_0_WIDTH    8

/* PHY_RXBE_REG62_LDPC_MAX_ITER_2_3 */
/* ldpc_max_iter cw 2 rate 5/6 */
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_3          0x00188
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_3_MASK     0xff000000
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_3_SHIFT    24
#define REG_PHY_RXBE_REG62_LDPC_MAX_ITER_2_3_WIDTH    8

/* PHY_RXBE_REG63_LDPC_OUT_WIDTH */
/* ldpc out bus width: possible 8,6 and 4 bits per cycle */
#define REG_PHY_RXBE_REG63_LDPC_OUT_WIDTH          0x0018C
#define REG_PHY_RXBE_REG63_LDPC_OUT_WIDTH_MASK     0x0000000f
#define REG_PHY_RXBE_REG63_LDPC_OUT_WIDTH_SHIFT    0
#define REG_PHY_RXBE_REG63_LDPC_OUT_WIDTH_WIDTH    4

/* PHY_RXBE_REG64_GLOBAL_RDY_LIMIT */
/* global still high waiting for BF report limit */
#define REG_PHY_RXBE_REG64_GLOBAL_RDY_LIMIT          0x00190
#define REG_PHY_RXBE_REG64_GLOBAL_RDY_LIMIT_MASK     0x00000fff
#define REG_PHY_RXBE_REG64_GLOBAL_RDY_LIMIT_SHIFT    0
#define REG_PHY_RXBE_REG64_GLOBAL_RDY_LIMIT_WIDTH    12

/* PHY_RXBE_REG65_ENABLE_AIR_TIME_BLOCK */
/* enable air time calc unit block of mac access during signal  */
#define REG_PHY_RXBE_REG65_ENABLE_AIR_TIME_BLOCK          0x00194
#define REG_PHY_RXBE_REG65_ENABLE_AIR_TIME_BLOCK_MASK     0x00000001
#define REG_PHY_RXBE_REG65_ENABLE_AIR_TIME_BLOCK_SHIFT    0
#define REG_PHY_RXBE_REG65_ENABLE_AIR_TIME_BLOCK_WIDTH    1
#endif 
